/* eslint-disable jsx-a11y/anchor-is-valid */

/**
 * External dependencies
 */
import classNames from 'classnames';

/**
 * WordPress dependencies
 */
import {useEffect, Fragment} from '@wordpress/element';
import {__} from '@wordpress/i18n';

/**
 * Internal dependencies
 */
import BWFBlockStyle from './css';
import {fontCheck, getCurrentScreen} from 'WFTY/utils';
import BWFGeneral from './inspector-control/general';
import BWFStyle from './inspector-control/style';
import BWFBlocksInspectorControlInner from 'WFTY/inspector/blocks-inspector-inner';

const {order_details} = window.wfty_blocks;
const uniqueIDArr = [];

const Edit = (props) => {
    const {
        attributes: {
            anchor,
            orderHeading,
            uniqueID,
            subscriptionHeading,
            downloadHeading,
            downloadBtnText,
            downloadFileCount,
            downloadFileExpiry,
            orderProductImage,
            downloadPreview,
            subscriptionPreview
        },
        className,
        clientId,
        setAttributes,
    } = props;

    useEffect(() => {
        let id = clientId.substr(2, 9).replace('-', '');
        if (!uniqueID || uniqueIDArr.includes(uniqueID)) {
            uniqueIDArr.push(id);
            setAttributes({uniqueID: id});
        } else {
            uniqueIDArr.push(uniqueID);
        }
        fontCheck(props.attributes);
    }, []);

    const screen = getCurrentScreen();


    return (
        <Fragment>
            <BWFBlockStyle {...props} />
            <BWFBlocksInspectorControlInner {...props} BWFGeneral={BWFGeneral} BWFStyle={BWFStyle}/>
            <div className={classNames('wfty-order-details-block', className, `wfty-${uniqueID}`)} id={anchor}>
                <div className="wffn_order_details_table">
                    <div className="wfty_wrap">
                        <div className="wfty_box wfty_order_details">
                            <div className="wfty-order-details-heading wfty_title">{orderHeading}</div>
                            <div className={(orderProductImage) ? ("wfty_pro_list_cont wfty_show_images") : "wfty_pro_list_cont wfty_hide_images"}>
                                <div className="wfty_pro_list wfty_clearfix">
                                    <div className="wfty_leftDiv wfty_clearfix">
                                        {(orderProductImage) ?
                                            (<div className="wfty_p_img">
                                                <a href="javascript:void(0);"><img height="100" width="100" className="attachment-shop_thumbnail size-shop_thumbnail" src={order_details.img_url}/></a>
                                            </div>) : ''
                                        }
                                        <div className="wfty_p_name">
                                            <a href="javascript:void(0);"><span className="wfty_t">{order_details.pro_name}</span></a>
                                            <span className="wfty_quantity_value_box"><span className="multiply"> x</span>1</span>
                                            <div className="wfty_info">
                                                <ul className="wc-item-meta">
                                                    <li><strong className="wc-item-meta-label">Color: </strong><p>Blue</p></li>
                                                    <li><strong className="wc-item-meta-label">Size: </strong><p>Large</p></li>
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                    <div className="wfty_rightDiv">
                                        <span className="woocommerce-Price-amount amount"><span className="woocommerce-Price-currencySymbol">{order_details.currency}</span>{order_details.price}</span>
                                    </div>
                                    <div className="wfty-clearfix"></div>
                                </div>
                                <table>
                                    <tfoot>
                                    <tr>
                                        <th scope="row">{order_details.sub_head}</th>
                                        <td>
                                            <span className="woocommerce-Price-amount amount"><span className="woocommerce-Price-currencySymbol">{order_details.currency}</span>{order_details.price}</span>
                                        </td>
                                    </tr>
                                    {('true' == order_details.shipping) ? (
                                        <tr>
                                            <th scope="row">{order_details.ship_head}</th>
                                            <td>
                                                <span className="woocommerce-Price-amount amount"><span className="woocommerce-Price-currencySymbol">{order_details.currency}</span>{order_details.shipping_price}</span>
                                                <small className="shipped_via">{order_details.ship_text}</small>
                                            </td>
                                        </tr>) : ''
                                    }
                                    <tr>
                                        <th scope="row">{order_details.payment_head}</th>
                                        <td>{order_details.payment_text}</td>
                                    </tr>
                                    <tr>
                                        <th scope="row">{order_details.total_head}</th>
                                        <td>
                                            <span className="woocommerce-Price-amount amount"><span className="woocommerce-Price-currencySymbol">{order_details.currency}</span>{order_details.total_price}</span>
                                        </td>
                                    </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                        <>
                            {downloadPreview && (
                                <div className="wfty_box wfty_order_download">
                                    <div className="wfty_title">{downloadHeading}</div>
                                    <table className="shop_table shop_table_responsive wfty_order_downloads">
                                        <thead>
                                        <tr>
                                            <th className="download-product"><span className="nobr">{order_details.down_th_file}</span></th>
                                            {downloadFileCount ? (
                                                <th className="download-remaining"><span className="nobr">{order_details.down_th_down}</span></th>) : ''
                                            }
                                            {downloadFileExpiry ? (
                                                <th className="download-expires"><span className="nobr">{order_details.down_th_exp}</span></th>) : ''
                                            }
                                            <th className="download-file"><span className="nobr"></span></th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <tr>
                                            <td data-title={order_details.down_th_file} className="download-product">{order_details.down_td_file}</td>
                                            {downloadFileCount ? (
                                                <td data-title={order_details.down_th_down} className="download-remaining">10</td>) : ''
                                            }
                                            {downloadFileExpiry ? (
                                                <td data-title={order_details.down_th_exp} className="download-expires">{order_details.down_td_exp}</td>) : ''
                                            }
                                            <td className="download-file"><a href="javascript:void(0);">{downloadBtnText}</a></td>
                                        </tr>
                                        </tbody>
                                    </table>
                                </div>

                            )}
                        </>
                        <>
                            {subscriptionPreview && (
                                <div className="wfty_box wfty_subscription">
                                    <div className="wfty_title">{subscriptionHeading}</div>
                                    <table className="shop_table shop_table_responsive my_account_orders">
                                        <thead>
                                        <tr>
                                            <th className="order-number wfty_left"><span className="nobr">{order_details.subs_th_title}</span></th>
                                            <th className="order-status wfty_center"><span className="nobr">{order_details.subs_th_pay}</span></th>
                                            <th className="order-total wfty_center"><span className="nobr">{order_details.subs_th_tot}</span></th>
                                            <th className="order-total wfty_center"><span className="nobr">{order_details.subs_th_act}</span></th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <tr className="order">
                                            <td data-title={order_details.subs_th_title} className="subscription-id order-number wfty_left">
                                                <a href="javascript:void(0);"><strong>#1234 </strong></a><small>({order_details.subs_td_title})</small>
                                            </td>
                                            <td data-title={order_details.subs_th_pay} className="subscription-next-payment order-date wfty_center">{order_details.subs_td_pay}</td>
                                            <td data-title={order_details.subs_th_tot} className="subscription-total order-total wfty_center">
                                                <span className="woocommerce-Price-amount amount"><span className="woocommerce-Price-currencySymbol">{order_details.currency}</span>{order_details.subs_td_tot}</span>
                                            </td>
                                            <td data-title={order_details.subs_th_act} className="subscription-actions order-actions wfty_center">
                                                <a href="javascript:void(0);" className="button view">{order_details.subs_td_act}</a>
                                            </td>
                                        </tr>
                                        </tbody>
                                    </table>
                                </div>

                            )

                            }
                        </>

                    </div>
                </div>
            </div>


        </Fragment>
    );
};
export default Edit;