<?php
/**
 * States
 *
 * Returns an array of country states. This deprecates and replaces the /states/ directory found in older versions.
 * States should be defined in English and translated native through localisation files.
 * Country codes and states (or province) names should follow the Unicode CLDR recommendation (http://cldr.unicode.org/translation/country-names).
 * Countries defined with empty arrays have no states.
 *
 *
 */

defined( 'ABSPATH' ) || exit;

return array(
	'AF' => array(),
	'AO' => array( // Angola states.
		'BGO' => __( 'Bengo', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BLU' => __( 'Benguela', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BIE' => __( 'Bié', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CAB' => __( 'Cabinda', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CNN' => __( 'Cunene', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'HUA' => __( 'Huambo', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'HUI' => __( 'Huíla', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CCU' => __( 'Kuando Kubango', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CNO' => __( 'Kwanza-Norte', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CUS' => __( 'Kwanza-Sul', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'LUA' => __( 'Luanda', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'LNO' => __( 'Lunda-Norte', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'LSU' => __( 'Lunda-Sul', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'MAL' => __( 'Malanje', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'MOX' => __( 'Moxico', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'NAM' => __( 'Namibe', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UIG' => __( 'Uíge', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'ZAI' => __( 'Zaire', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
	),
	'AR' => array( // Argentinian provinces.
		'C' => __( 'Ciudad Autónoma de Buenos Aires', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'B' => __( 'Buenos Aires', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'K' => __( 'Catamarca', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'H' => __( 'Chaco', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'U' => __( 'Chubut', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'X' => __( 'Córdoba', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'W' => __( 'Corrientes', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'E' => __( 'Entre Ríos', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'P' => __( 'Formosa', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'Y' => __( 'Jujuy', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'L' => __( 'La Pampa', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'F' => __( 'La Rioja', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'M' => __( 'Mendoza', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'N' => __( 'Misiones', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'Q' => __( 'Neuquén', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'R' => __( 'Río Negro', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'A' => __( 'Salta', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'J' => __( 'San Juan', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'D' => __( 'San Luis', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'Z' => __( 'Santa Cruz', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'S' => __( 'Santa Fe', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'G' => __( 'Santiago del Estero', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'V' => __( 'Tierra del Fuego', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'T' => __( 'Tucumán', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
	),
	'AT' => array(),
	'AU' => array( // Australian states.
		'ACT' => __( 'Australian Capital Territory', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'NSW' => __( 'New South Wales', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'NT'  => __( 'Northern Territory', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'QLD' => __( 'Queensland', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'SA'  => __( 'South Australia', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TAS' => __( 'Tasmania', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'VIC' => __( 'Victoria', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'WA'  => __( 'Western Australia', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
	),
	'AX' => array(),
	'BD' => array( // Bangladeshi states (districts).
		'BD-05' => __( 'Bagerhat', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BD-01' => __( 'Bandarban', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BD-02' => __( 'Barguna', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BD-06' => __( 'Barishal', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BD-07' => __( 'Bhola', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BD-03' => __( 'Bogura', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BD-04' => __( 'Brahmanbaria', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BD-09' => __( 'Chandpur', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BD-10' => __( 'Chattogram', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BD-12' => __( 'Chuadanga', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BD-11' => __( "Cox's Bazar", 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BD-08' => __( 'Cumilla', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BD-13' => __( 'Dhaka', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BD-14' => __( 'Dinajpur', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BD-15' => __( 'Faridpur ', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BD-16' => __( 'Feni', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BD-19' => __( 'Gaibandha', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BD-18' => __( 'Gazipur', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BD-17' => __( 'Gopalganj', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BD-20' => __( 'Habiganj', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BD-21' => __( 'Jamalpur', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BD-22' => __( 'Jashore', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BD-25' => __( 'Jhalokati', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BD-23' => __( 'Jhenaidah', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BD-24' => __( 'Joypurhat', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BD-29' => __( 'Khagrachhari', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BD-27' => __( 'Khulna', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BD-26' => __( 'Kishoreganj', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BD-28' => __( 'Kurigram', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BD-30' => __( 'Kushtia', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BD-31' => __( 'Lakshmipur', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BD-32' => __( 'Lalmonirhat', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BD-36' => __( 'Madaripur', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BD-37' => __( 'Magura', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BD-33' => __( 'Manikganj ', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BD-39' => __( 'Meherpur', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BD-38' => __( 'Moulvibazar', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BD-35' => __( 'Munshiganj', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BD-34' => __( 'Mymensingh', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BD-48' => __( 'Naogaon', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BD-43' => __( 'Narail', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BD-40' => __( 'Narayanganj', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BD-42' => __( 'Narsingdi', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BD-44' => __( 'Natore', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BD-45' => __( 'Nawabganj', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BD-41' => __( 'Netrakona', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BD-46' => __( 'Nilphamari', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BD-47' => __( 'Noakhali', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BD-49' => __( 'Pabna', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BD-52' => __( 'Panchagarh', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BD-51' => __( 'Patuakhali', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BD-50' => __( 'Pirojpur', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BD-53' => __( 'Rajbari', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BD-54' => __( 'Rajshahi', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BD-56' => __( 'Rangamati', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BD-55' => __( 'Rangpur', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BD-58' => __( 'Satkhira', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BD-62' => __( 'Shariatpur', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BD-57' => __( 'Sherpur', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BD-59' => __( 'Sirajganj', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BD-61' => __( 'Sunamganj', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BD-60' => __( 'Sylhet', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BD-63' => __( 'Tangail', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BD-64' => __( 'Thakurgaon', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
	),
	'BE' => array(),
	'BG' => array( // Bulgarian states.
		'BG-01' => __( 'Blagoevgrad', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BG-02' => __( 'Burgas', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BG-08' => __( 'Dobrich', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BG-07' => __( 'Gabrovo', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BG-26' => __( 'Haskovo', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BG-09' => __( 'Kardzhali', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BG-10' => __( 'Kyustendil', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BG-11' => __( 'Lovech', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BG-12' => __( 'Montana', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BG-13' => __( 'Pazardzhik', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BG-14' => __( 'Pernik', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BG-15' => __( 'Pleven', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BG-16' => __( 'Plovdiv', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BG-17' => __( 'Razgrad', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BG-18' => __( 'Ruse', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BG-27' => __( 'Shumen', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BG-19' => __( 'Silistra', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BG-20' => __( 'Sliven', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BG-21' => __( 'Smolyan', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BG-23' => __( 'Sofia', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BG-22' => __( 'Sofia-Grad', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BG-24' => __( 'Stara Zagora', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BG-25' => __( 'Targovishte', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BG-03' => __( 'Varna', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BG-04' => __( 'Veliko Tarnovo', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BG-05' => __( 'Vidin', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BG-06' => __( 'Vratsa', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BG-28' => __( 'Yambol', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
	),
	'BH' => array(),
	'BI' => array(),
	'BJ' => array( // Benin states.
		'AL' => __( 'Alibori', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'AK' => __( 'Atakora', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'AQ' => __( 'Atlantique', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BO' => __( 'Borgou', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CO' => __( 'Collines', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'KO' => __( 'Kouffo', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'DO' => __( 'Donga', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'LI' => __( 'Littoral', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'MO' => __( 'Mono', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'OU' => __( 'Ouémé', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'PL' => __( 'Plateau', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'ZO' => __( 'Zou', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
	),
	'BO' => array( // Bolivian states.
		'B' => __( 'Chuquisaca', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'H' => __( 'Beni', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'C' => __( 'Cochabamba', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'L' => __( 'La Paz', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'O' => __( 'Oruro', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'N' => __( 'Pando', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'P' => __( 'Potosí', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'S' => __( 'Santa Cruz', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'T' => __( 'Tarija', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
	),
	'BR' => array( // Brazillian states.
		'AC' => __( 'Acre', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'AL' => __( 'Alagoas', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'AP' => __( 'Amapá', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'AM' => __( 'Amazonas', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BA' => __( 'Bahia', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CE' => __( 'Ceará', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'DF' => __( 'Distrito Federal', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'ES' => __( 'Espírito Santo', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'GO' => __( 'Goiás', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'MA' => __( 'Maranhão', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'MT' => __( 'Mato Grosso', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'MS' => __( 'Mato Grosso do Sul', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'MG' => __( 'Minas Gerais', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'PA' => __( 'Pará', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'PB' => __( 'Paraíba', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'PR' => __( 'Paraná', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'PE' => __( 'Pernambuco', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'PI' => __( 'Piauí', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'RJ' => __( 'Rio de Janeiro', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'RN' => __( 'Rio Grande do Norte', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'RS' => __( 'Rio Grande do Sul', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'RO' => __( 'Rondônia', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'RR' => __( 'Roraima', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'SC' => __( 'Santa Catarina', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'SP' => __( 'São Paulo', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'SE' => __( 'Sergipe', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TO' => __( 'Tocantins', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
	),
	'CA' => array( // Canadian states.
		'AB' => __( 'Alberta', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BC' => __( 'British Columbia', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'MB' => __( 'Manitoba', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'NB' => __( 'New Brunswick', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'NL' => __( 'Newfoundland and Labrador', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'NT' => __( 'Northwest Territories', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'NS' => __( 'Nova Scotia', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'NU' => __( 'Nunavut', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'ON' => __( 'Ontario', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'PE' => __( 'Prince Edward Island', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'QC' => __( 'Quebec', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'SK' => __( 'Saskatchewan', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'YT' => __( 'Yukon Territory', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
	),
	'CH' => array( // Cantons of Switzerland.
		'AG' => __( 'Aargau', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'AR' => __( 'Appenzell Ausserrhoden', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'AI' => __( 'Appenzell Innerrhoden', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BL' => __( 'Basel-Landschaft', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BS' => __( 'Basel-Stadt', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BE' => __( 'Bern', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'FR' => __( 'Fribourg', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'GE' => __( 'Geneva', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'GL' => __( 'Glarus', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'GR' => __( 'Graubünden', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'JU' => __( 'Jura', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'LU' => __( 'Luzern', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'NE' => __( 'Neuchâtel', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'NW' => __( 'Nidwalden', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'OW' => __( 'Obwalden', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'SH' => __( 'Schaffhausen', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'SZ' => __( 'Schwyz', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'SO' => __( 'Solothurn', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'SG' => __( 'St. Gallen', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TG' => __( 'Thurgau', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TI' => __( 'Ticino', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UR' => __( 'Uri', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'VS' => __( 'Valais', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'VD' => __( 'Vaud', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'ZG' => __( 'Zug', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'ZH' => __( 'Zürich', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
	),
	'CN' => array( // Chinese states.
		'CN1'  => __( 'Yunnan / 云南', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CN2'  => __( 'Beijing / 北京', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CN3'  => __( 'Tianjin / 天津', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CN4'  => __( 'Hebei / 河北', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CN5'  => __( 'Shanxi / 山西', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CN6'  => __( 'Inner Mongolia / 內蒙古', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CN7'  => __( 'Liaoning / 辽宁', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CN8'  => __( 'Jilin / 吉林', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CN9'  => __( 'Heilongjiang / 黑龙江', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CN10' => __( 'Shanghai / 上海', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CN11' => __( 'Jiangsu / 江苏', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CN12' => __( 'Zhejiang / 浙江', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CN13' => __( 'Anhui / 安徽', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CN14' => __( 'Fujian / 福建', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CN15' => __( 'Jiangxi / 江西', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CN16' => __( 'Shandong / 山东', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CN17' => __( 'Henan / 河南', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CN18' => __( 'Hubei / 湖北', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CN19' => __( 'Hunan / 湖南', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CN20' => __( 'Guangdong / 广东', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CN21' => __( 'Guangxi Zhuang / 广西壮族', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CN22' => __( 'Hainan / 海南', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CN23' => __( 'Chongqing / 重庆', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CN24' => __( 'Sichuan / 四川', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CN25' => __( 'Guizhou / 贵州', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CN26' => __( 'Shaanxi / 陕西', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CN27' => __( 'Gansu / 甘肃', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CN28' => __( 'Qinghai / 青海', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CN29' => __( 'Ningxia Hui / 宁夏', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CN30' => __( 'Macao / 澳门', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CN31' => __( 'Tibet / 西藏', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CN32' => __( 'Xinjiang / 新疆', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
	),
	'CZ' => array(),
	'DE' => array(),
	'DK' => array(),
	'DZ' => array(
		'DZ-01' => __( 'Adrar', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'DZ-02' => __( 'Chlef', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'DZ-03' => __( 'Laghouat', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'DZ-04' => __( 'Oum El Bouaghi', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'DZ-05' => __( 'Batna', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'DZ-06' => __( 'Béjaïa', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'DZ-07' => __( 'Biskra', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'DZ-08' => __( 'Béchar', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'DZ-09' => __( 'Blida', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'DZ-10' => __( 'Bouira', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'DZ-11' => __( 'Tamanghasset', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'DZ-12' => __( 'Tébessa', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'DZ-13' => __( 'Tlemcen', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'DZ-14' => __( 'Tiaret', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'DZ-15' => __( 'Tizi Ouzou', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'DZ-16' => __( 'Algiers', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'DZ-17' => __( 'Djelfa', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'DZ-18' => __( 'Jijel', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'DZ-19' => __( 'Sétif', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'DZ-20' => __( 'Saïda', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'DZ-21' => __( 'Skikda', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'DZ-22' => __( 'Sidi Bel Abbès', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'DZ-23' => __( 'Annaba', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'DZ-24' => __( 'Guelma', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'DZ-25' => __( 'Constantine', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'DZ-26' => __( 'Médéa', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'DZ-27' => __( 'Mostaganem', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'DZ-28' => __( 'M’Sila', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'DZ-29' => __( 'Mascara', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'DZ-30' => __( 'Ouargla', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'DZ-31' => __( 'Oran', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'DZ-32' => __( 'El Bayadh', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'DZ-33' => __( 'Illizi', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'DZ-34' => __( 'Bordj Bou Arréridj', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'DZ-35' => __( 'Boumerdès', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'DZ-36' => __( 'El Tarf', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'DZ-37' => __( 'Tindouf', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'DZ-38' => __( 'Tissemsilt', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'DZ-39' => __( 'El Oued', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'DZ-40' => __( 'Khenchela', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'DZ-41' => __( 'Souk Ahras', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'DZ-42' => __( 'Tipasa', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'DZ-43' => __( 'Mila', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'DZ-44' => __( 'Aïn Defla', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'DZ-45' => __( 'Naama', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'DZ-46' => __( 'Aïn Témouchent', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'DZ-47' => __( 'Ghardaïa', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'DZ-48' => __( 'Relizane', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
	),
	'EE' => array(),
	'EG' => array( // Egypt states.
		'EGALX' => __( 'Alexandria', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'EGASN' => __( 'Aswan', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'EGAST' => __( 'Asyut', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'EGBA'  => __( 'Red Sea', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'EGBH'  => __( 'Beheira', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'EGBNS' => __( 'Beni Suef', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'EGC'   => __( 'Cairo', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'EGDK'  => __( 'Dakahlia', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'EGDT'  => __( 'Damietta', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'EGFYM' => __( 'Faiyum', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'EGGH'  => __( 'Gharbia', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'EGGZ'  => __( 'Giza', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'EGIS'  => __( 'Ismailia', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'EGJS'  => __( 'South Sinai', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'EGKB'  => __( 'Qalyubia', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'EGKFS' => __( 'Kafr el-Sheikh', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'EGKN'  => __( 'Qena', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'EGLX'  => __( 'Luxor', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'EGMN'  => __( 'Minya', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'EGMNF' => __( 'Monufia', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'EGMT'  => __( 'Matrouh', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'EGPTS' => __( 'Port Said', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'EGSHG' => __( 'Sohag', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'EGSHR' => __( 'Al Sharqia', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'EGSIN' => __( 'North Sinai', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'EGSUZ' => __( 'Suez', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'EGWAD' => __( 'New Valley', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
	),
	'ES' => array( // Spanish states.
		'C'  => __( 'A Coruña', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'VI' => __( 'Araba/Álava', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'AB' => __( 'Albacete', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'A'  => __( 'Alicante', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'AL' => __( 'Almería', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'O'  => __( 'Asturias', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'AV' => __( 'Ávila', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BA' => __( 'Badajoz', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'PM' => __( 'Baleares', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'B'  => __( 'Barcelona', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BU' => __( 'Burgos', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CC' => __( 'Cáceres', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CA' => __( 'Cádiz', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'S'  => __( 'Cantabria', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CS' => __( 'Castellón', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CE' => __( 'Ceuta', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CR' => __( 'Ciudad Real', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CO' => __( 'Córdoba', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CU' => __( 'Cuenca', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'GI' => __( 'Girona', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'GR' => __( 'Granada', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'GU' => __( 'Guadalajara', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'SS' => __( 'Gipuzkoa', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'H'  => __( 'Huelva', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'HU' => __( 'Huesca', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'J'  => __( 'Jaén', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'LO' => __( 'La Rioja', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'GC' => __( 'Las Palmas', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'LE' => __( 'León', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'L'  => __( 'Lleida', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'LU' => __( 'Lugo', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'M'  => __( 'Madrid', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'MA' => __( 'Málaga', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'ML' => __( 'Melilla', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'MU' => __( 'Murcia', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'NA' => __( 'Navarra', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'OR' => __( 'Ourense', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'P'  => __( 'Palencia', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'PO' => __( 'Pontevedra', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'SA' => __( 'Salamanca', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TF' => __( 'Santa Cruz de Tenerife', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'SG' => __( 'Segovia', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'SE' => __( 'Sevilla', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'SO' => __( 'Soria', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'T'  => __( 'Tarragona', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TE' => __( 'Teruel', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TO' => __( 'Toledo', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'V'  => __( 'Valencia', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'VA' => __( 'Valladolid', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BI' => __( 'Biscay', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'ZA' => __( 'Zamora', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'Z'  => __( 'Zaragoza', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
	),
	'FI' => array(),
	'FR' => array(),
	'GH' => array( // Ghanaian Regions.
		'AF' => __( 'Ahafo', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'AH' => __( 'Ashanti', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BA' => __( 'Brong-Ahafo', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BO' => __( 'Bono', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BE' => __( 'Bono East', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CP' => __( 'Central', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'EP' => __( 'Eastern', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'AA' => __( 'Greater Accra', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'NE' => __( 'North East', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'NP' => __( 'Northern', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'OT' => __( 'Oti', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'SV' => __( 'Savannah', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UE' => __( 'Upper East', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UW' => __( 'Upper West', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TV' => __( 'Volta', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'WP' => __( 'Western', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'WN' => __( 'Western North', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
	),
	'GP' => array(),
	'GR' => array( // Greek Regions.
		'I' => __( 'Attica', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'A' => __( 'East Macedonia and Thrace', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'B' => __( 'Central Macedonia', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'C' => __( 'West Macedonia', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'D' => __( 'Epirus', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'E' => __( 'Thessaly', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'F' => __( 'Ionian Islands', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'G' => __( 'West Greece', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'H' => __( 'Central Greece', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'J' => __( 'Peloponnese', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'K' => __( 'North Aegean', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'L' => __( 'South Aegean', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'M' => __( 'Crete', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
	),
	'GF' => array(),
	'HK' => array( // Hong Kong states.
		'HONG KONG'       => __( 'Hong Kong Island', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'KOWLOON'         => __( 'Kowloon', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'NEW TERRITORIES' => __( 'New Territories', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
	),
	'HU' => array( // Hungary states.
		'BK' => __( 'Bács-Kiskun', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BE' => __( 'Békés', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BA' => __( 'Baranya', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BZ' => __( 'Borsod-Abaúj-Zemplén', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BU' => __( 'Budapest', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CS' => __( 'Csongrád-Csanád', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'FE' => __( 'Fejér', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'GS' => __( 'Győr-Moson-Sopron', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'HB' => __( 'Hajdú-Bihar', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'HE' => __( 'Heves', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'JN' => __( 'Jász-Nagykun-Szolnok', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'KE' => __( 'Komárom-Esztergom', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'NO' => __( 'Nógrád', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'PE' => __( 'Pest', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'SO' => __( 'Somogy', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'SZ' => __( 'Szabolcs-Szatmár-Bereg', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TO' => __( 'Tolna', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'VA' => __( 'Vas', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'VE' => __( 'Veszprém', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'ZA' => __( 'Zala', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
	),
	'ID' => array( // Indonesia Provinces.
		'AC' => __( 'Daerah Istimewa Aceh', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'SU' => __( 'Sumatera Utara', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'SB' => __( 'Sumatera Barat', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'RI' => __( 'Riau', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'KR' => __( 'Kepulauan Riau', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'JA' => __( 'Jambi', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'SS' => __( 'Sumatera Selatan', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BB' => __( 'Bangka Belitung', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BE' => __( 'Bengkulu', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'LA' => __( 'Lampung', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'JK' => __( 'DKI Jakarta', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'JB' => __( 'Jawa Barat', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BT' => __( 'Banten', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'JT' => __( 'Jawa Tengah', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'JI' => __( 'Jawa Timur', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'YO' => __( 'Daerah Istimewa Yogyakarta', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BA' => __( 'Bali', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'NB' => __( 'Nusa Tenggara Barat', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'NT' => __( 'Nusa Tenggara Timur', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'KB' => __( 'Kalimantan Barat', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'KT' => __( 'Kalimantan Tengah', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'KI' => __( 'Kalimantan Timur', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'KS' => __( 'Kalimantan Selatan', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'KU' => __( 'Kalimantan Utara', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'SA' => __( 'Sulawesi Utara', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'ST' => __( 'Sulawesi Tengah', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'SG' => __( 'Sulawesi Tenggara', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'SR' => __( 'Sulawesi Barat', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'SN' => __( 'Sulawesi Selatan', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'GO' => __( 'Gorontalo', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'MA' => __( 'Maluku', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'MU' => __( 'Maluku Utara', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'PA' => __( 'Papua', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'PB' => __( 'Papua Barat', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
	),
	'IE' => array( // Republic of Ireland.
		'CW' => __( 'Carlow', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CN' => __( 'Cavan', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CE' => __( 'Clare', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CO' => __( 'Cork', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'DL' => __( 'Donegal', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'D'  => __( 'Dublin', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'G'  => __( 'Galway', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'KY' => __( 'Kerry', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'KE' => __( 'Kildare', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'KK' => __( 'Kilkenny', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'LS' => __( 'Laois', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'LM' => __( 'Leitrim', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'LK' => __( 'Limerick', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'LD' => __( 'Longford', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'LH' => __( 'Louth', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'MO' => __( 'Mayo', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'MH' => __( 'Meath', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'MN' => __( 'Monaghan', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'OY' => __( 'Offaly', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'RN' => __( 'Roscommon', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'SO' => __( 'Sligo', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TA' => __( 'Tipperary', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'WD' => __( 'Waterford', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'WH' => __( 'Westmeath', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'WX' => __( 'Wexford', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'WW' => __( 'Wicklow', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
	),
	'IN' => array( // Indian states.
		'AP' => __( 'Andhra Pradesh', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'AR' => __( 'Arunachal Pradesh', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'AS' => __( 'Assam', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BR' => __( 'Bihar', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CT' => __( 'Chhattisgarh', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'GA' => __( 'Goa', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'GJ' => __( 'Gujarat', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'HR' => __( 'Haryana', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'HP' => __( 'Himachal Pradesh', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'JK' => __( 'Jammu and Kashmir', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'JH' => __( 'Jharkhand', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'KA' => __( 'Karnataka', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'KL' => __( 'Kerala', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'MP' => __( 'Madhya Pradesh', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'MH' => __( 'Maharashtra', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'MN' => __( 'Manipur', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'ML' => __( 'Meghalaya', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'MZ' => __( 'Mizoram', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'NL' => __( 'Nagaland', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'OR' => __( 'Orissa', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'PB' => __( 'Punjab', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'RJ' => __( 'Rajasthan', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'SK' => __( 'Sikkim', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TN' => __( 'Tamil Nadu', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TS' => __( 'Telangana', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TR' => __( 'Tripura', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UK' => __( 'Uttarakhand', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UP' => __( 'Uttar Pradesh', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'WB' => __( 'West Bengal', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'AN' => __( 'Andaman and Nicobar Islands', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CH' => __( 'Chandigarh', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'DN' => __( 'Dadra and Nagar Haveli', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'DD' => __( 'Daman and Diu', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'DL' => __( 'Delhi', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'LD' => __( 'Lakshadeep', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'PY' => __( 'Pondicherry (Puducherry)', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
	),
	'IR' => array( // Iran States.
		'KHZ' => __( 'Khuzestan  (خوزستان)', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'THR' => __( 'Tehran  (تهران)', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'ILM' => __( 'Ilaam (ایلام)', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BHR' => __( 'Bushehr (بوشهر)', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'ADL' => __( 'Ardabil (اردبیل)', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'ESF' => __( 'Isfahan (اصفهان)', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'YZD' => __( 'Yazd (یزد)', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'KRH' => __( 'Kermanshah (کرمانشاه)', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'KRN' => __( 'Kerman (کرمان)', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'HDN' => __( 'Hamadan (همدان)', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'GZN' => __( 'Ghazvin (قزوین)', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'ZJN' => __( 'Zanjan (زنجان)', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'LRS' => __( 'Luristan (لرستان)', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'ABZ' => __( 'Alborz (البرز)', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'EAZ' => __( 'East Azarbaijan (آذربایجان شرقی)', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'WAZ' => __( 'West Azarbaijan (آذربایجان غربی)', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CHB' => __( 'Chaharmahal and Bakhtiari (چهارمحال و بختیاری)', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'SKH' => __( 'South Khorasan (خراسان جنوبی)', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'RKH' => __( 'Razavi Khorasan (خراسان رضوی)', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'NKH' => __( 'North Khorasan (خراسان شمالی)', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'SMN' => __( 'Semnan (سمنان)', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'FRS' => __( 'Fars (فارس)', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'QHM' => __( 'Qom (قم)', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'KRD' => __( 'Kurdistan / کردستان)', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'KBD' => __( 'Kohgiluyeh and BoyerAhmad (کهگیلوییه و بویراحمد)', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'GLS' => __( 'Golestan (گلستان)', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'GIL' => __( 'Gilan (گیلان)', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'MZN' => __( 'Mazandaran (مازندران)', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'MKZ' => __( 'Markazi (مرکزی)', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'HRZ' => __( 'Hormozgan (هرمزگان)', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'SBN' => __( 'Sistan and Baluchestan (سیستان و بلوچستان)', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
	),
	'IS' => array(),
	'IT' => array( // Italy Provinces.
		'AG' => __( 'Agrigento', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'AL' => __( 'Alessandria', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'AN' => __( 'Ancona', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'AO' => __( 'Aosta', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'AR' => __( 'Arezzo', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'AP' => __( 'Ascoli Piceno', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'AT' => __( 'Asti', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'AV' => __( 'Avellino', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BA' => __( 'Bari', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BT' => __( 'Barletta-Andria-Trani', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BL' => __( 'Belluno', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BN' => __( 'Benevento', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BG' => __( 'Bergamo', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BI' => __( 'Biella', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BO' => __( 'Bologna', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BZ' => __( 'Bolzano', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BS' => __( 'Brescia', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BR' => __( 'Brindisi', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CA' => __( 'Cagliari', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CL' => __( 'Caltanissetta', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CB' => __( 'Campobasso', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CE' => __( 'Caserta', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CT' => __( 'Catania', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CZ' => __( 'Catanzaro', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CH' => __( 'Chieti', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CO' => __( 'Como', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CS' => __( 'Cosenza', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CR' => __( 'Cremona', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'KR' => __( 'Crotone', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CN' => __( 'Cuneo', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'EN' => __( 'Enna', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'FM' => __( 'Fermo', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'FE' => __( 'Ferrara', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'FI' => __( 'Firenze', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'FG' => __( 'Foggia', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'FC' => __( 'Forlì-Cesena', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'FR' => __( 'Frosinone', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'GE' => __( 'Genova', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'GO' => __( 'Gorizia', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'GR' => __( 'Grosseto', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'IM' => __( 'Imperia', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'IS' => __( 'Isernia', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'SP' => __( 'La Spezia', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'AQ' => __( "L'Aquila", 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'LT' => __( 'Latina', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'LE' => __( 'Lecce', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'LC' => __( 'Lecco', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'LI' => __( 'Livorno', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'LO' => __( 'Lodi', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'LU' => __( 'Lucca', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'MC' => __( 'Macerata', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'MN' => __( 'Mantova', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'MS' => __( 'Massa-Carrara', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'MT' => __( 'Matera', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'ME' => __( 'Messina', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'MI' => __( 'Milano', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'MO' => __( 'Modena', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'MB' => __( 'Monza e della Brianza', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'NA' => __( 'Napoli', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'NO' => __( 'Novara', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'NU' => __( 'Nuoro', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'OR' => __( 'Oristano', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'PD' => __( 'Padova', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'PA' => __( 'Palermo', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'PR' => __( 'Parma', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'PV' => __( 'Pavia', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'PG' => __( 'Perugia', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'PU' => __( 'Pesaro e Urbino', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'PE' => __( 'Pescara', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'PC' => __( 'Piacenza', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'PI' => __( 'Pisa', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'PT' => __( 'Pistoia', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'PN' => __( 'Pordenone', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'PZ' => __( 'Potenza', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'PO' => __( 'Prato', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'RG' => __( 'Ragusa', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'RA' => __( 'Ravenna', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'RC' => __( 'Reggio Calabria', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'RE' => __( 'Reggio Emilia', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'RI' => __( 'Rieti', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'RN' => __( 'Rimini', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'RM' => __( 'Roma', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'RO' => __( 'Rovigo', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'SA' => __( 'Salerno', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'SS' => __( 'Sassari', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'SV' => __( 'Savona', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'SI' => __( 'Siena', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'SR' => __( 'Siracusa', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'SO' => __( 'Sondrio', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'SU' => __( 'Sud Sardegna', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TA' => __( 'Taranto', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TE' => __( 'Teramo', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TR' => __( 'Terni', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TO' => __( 'Torino', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TP' => __( 'Trapani', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TN' => __( 'Trento', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TV' => __( 'Treviso', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TS' => __( 'Trieste', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UD' => __( 'Udine', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'VA' => __( 'Varese', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'VE' => __( 'Venezia', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'VB' => __( 'Verbano-Cusio-Ossola', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'VC' => __( 'Vercelli', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'VR' => __( 'Verona', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'VV' => __( 'Vibo Valentia', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'VI' => __( 'Vicenza', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'VT' => __( 'Viterbo', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
	),
	'IL' => array(),
	'IM' => array(),

	/**
	 * Japan States.
	 *
	 * English notation of prefectures conform to the notation of Japan Post.
	 * The suffix corresponds with the Japanese translation file.
	 */
	'JP' => array(
		'JP01' => __( 'Hokkaido', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'JP02' => __( 'Aomori', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'JP03' => __( 'Iwate', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'JP04' => __( 'Miyagi', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'JP05' => __( 'Akita', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'JP06' => __( 'Yamagata', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'JP07' => __( 'Fukushima', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'JP08' => __( 'Ibaraki', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'JP09' => __( 'Tochigi', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'JP10' => __( 'Gunma', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'JP11' => __( 'Saitama', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'JP12' => __( 'Chiba', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'JP13' => __( 'Tokyo', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'JP14' => __( 'Kanagawa', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'JP15' => __( 'Niigata', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'JP16' => __( 'Toyama', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'JP17' => __( 'Ishikawa', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'JP18' => __( 'Fukui', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'JP19' => __( 'Yamanashi', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'JP20' => __( 'Nagano', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'JP21' => __( 'Gifu', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'JP22' => __( 'Shizuoka', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'JP23' => __( 'Aichi', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'JP24' => __( 'Mie', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'JP25' => __( 'Shiga', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'JP26' => __( 'Kyoto', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'JP27' => __( 'Osaka', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'JP28' => __( 'Hyogo', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'JP29' => __( 'Nara', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'JP30' => __( 'Wakayama', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'JP31' => __( 'Tottori', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'JP32' => __( 'Shimane', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'JP33' => __( 'Okayama', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'JP34' => __( 'Hiroshima', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'JP35' => __( 'Yamaguchi', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'JP36' => __( 'Tokushima', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'JP37' => __( 'Kagawa', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'JP38' => __( 'Ehime', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'JP39' => __( 'Kochi', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'JP40' => __( 'Fukuoka', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'JP41' => __( 'Saga', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'JP42' => __( 'Nagasaki', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'JP43' => __( 'Kumamoto', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'JP44' => __( 'Oita', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'JP45' => __( 'Miyazaki', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'JP46' => __( 'Kagoshima', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'JP47' => __( 'Okinawa', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
	),
	'KE' => array( // Kenya counties.
		'KE01' => __( 'Baringo', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'KE02' => __( 'Bomet', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'KE03' => __( 'Bungoma', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'KE04' => __( 'Busia', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'KE05' => __( 'Elgeyo-Marakwet', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'KE06' => __( 'Embu', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'KE07' => __( 'Garissa', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'KE08' => __( 'Homa Bay', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'KE09' => __( 'Isiolo', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'KE10' => __( 'Kajiado', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'KE11' => __( 'Kakamega', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'KE12' => __( 'Kericho', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'KE13' => __( 'Kiambu', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'KE14' => __( 'Kilifi', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'KE15' => __( 'Kirinyaga', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'KE16' => __( 'Kisii', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'KE17' => __( 'Kisumu', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'KE18' => __( 'Kitui', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'KE19' => __( 'Kwale', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'KE20' => __( 'Laikipia', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'KE21' => __( 'Lamu', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'KE22' => __( 'Machakos', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'KE23' => __( 'Makueni', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'KE24' => __( 'Mandera', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'KE25' => __( 'Marsabit', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'KE26' => __( 'Meru', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'KE27' => __( 'Migori', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'KE28' => __( 'Mombasa', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'KE29' => __( 'Murang’a', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'KE30' => __( 'Nairobi County', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'KE31' => __( 'Nakuru', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'KE32' => __( 'Nandi', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'KE33' => __( 'Narok', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'KE34' => __( 'Nyamira', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'KE35' => __( 'Nyandarua', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'KE36' => __( 'Nyeri', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'KE37' => __( 'Samburu', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'KE38' => __( 'Siaya', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'KE39' => __( 'Taita-Taveta', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'KE40' => __( 'Tana River', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'KE41' => __( 'Tharaka-Nithi', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'KE42' => __( 'Trans Nzoia', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'KE43' => __( 'Turkana', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'KE44' => __( 'Uasin Gishu', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'KE45' => __( 'Vihiga', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'KE46' => __( 'Wajir', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'KE47' => __( 'West Pokot', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
	),
	'KR' => array(),
	'KW' => array(),
	'LA' => array(
		'AT' => __( 'Attapeu', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BK' => __( 'Bokeo', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BL' => __( 'Bolikhamsai', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CH' => __( 'Champasak', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'HO' => __( 'Houaphanh', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'KH' => __( 'Khammouane', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'LM' => __( 'Luang Namtha', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'LP' => __( 'Luang Prabang', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'OU' => __( 'Oudomxay', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'PH' => __( 'Phongsaly', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'SL' => __( 'Salavan', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'SV' => __( 'Savannakhet', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'VI' => __( 'Vientiane Province', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'VT' => __( 'Vientiane', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'XA' => __( 'Sainyabuli', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'XE' => __( 'Sekong', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'XI' => __( 'Xiangkhouang', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'XS' => __( 'Xaisomboun', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
	),
	'LB' => array(),
	'LR' => array( // Liberia provinces.
		'BM' => __( 'Bomi', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BN' => __( 'Bong', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'GA' => __( 'Gbarpolu', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'GB' => __( 'Grand Bassa', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'GC' => __( 'Grand Cape Mount', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'GG' => __( 'Grand Gedeh', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'GK' => __( 'Grand Kru', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'LO' => __( 'Lofa', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'MA' => __( 'Margibi', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'MY' => __( 'Maryland', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'MO' => __( 'Montserrado', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'NM' => __( 'Nimba', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'RV' => __( 'Rivercess', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'RG' => __( 'River Gee', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'SN' => __( 'Sinoe', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
	),
	'LU' => array(),
	'MD' => array( // Moldova states.
		'C'  => __( 'Chișinău', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BL' => __( 'Bălți', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'AN' => __( 'Anenii Noi', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BS' => __( 'Basarabeasca', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BR' => __( 'Briceni', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CH' => __( 'Cahul', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CT' => __( 'Cantemir', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CL' => __( 'Călărași', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CS' => __( 'Căușeni', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CM' => __( 'Cimișlia', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CR' => __( 'Criuleni', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'DN' => __( 'Dondușeni', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'DR' => __( 'Drochia', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'DB' => __( 'Dubăsari', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'ED' => __( 'Edineț', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'FL' => __( 'Fălești', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'FR' => __( 'Florești', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'GE' => __( 'UTA Găgăuzia', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'GL' => __( 'Glodeni', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'HN' => __( 'Hîncești', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'IL' => __( 'Ialoveni', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'LV' => __( 'Leova', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'NS' => __( 'Nisporeni', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'OC' => __( 'Ocnița', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'OR' => __( 'Orhei', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'RZ' => __( 'Rezina', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'RS' => __( 'Rîșcani', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'SG' => __( 'Sîngerei', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'SR' => __( 'Soroca', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'ST' => __( 'Strășeni', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'SD' => __( 'Șoldănești', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'SV' => __( 'Ștefan Vodă', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TR' => __( 'Taraclia', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TL' => __( 'Telenești', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UN' => __( 'Ungheni', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
	),
	'MQ' => array(),
	'MT' => array(),
	'MX' => array( // Mexico States.
		'DF' => __( 'Ciudad de México', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'JA' => __( 'Jalisco', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'NL' => __( 'Nuevo León', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'AG' => __( 'Aguascalientes', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BC' => __( 'Baja California', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BS' => __( 'Baja California Sur', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CM' => __( 'Campeche', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CS' => __( 'Chiapas', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CH' => __( 'Chihuahua', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CO' => __( 'Coahuila', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CL' => __( 'Colima', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'DG' => __( 'Durango', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'GT' => __( 'Guanajuato', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'GR' => __( 'Guerrero', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'HG' => __( 'Hidalgo', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'MX' => __( 'Estado de México', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'MI' => __( 'Michoacán', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'MO' => __( 'Morelos', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'NA' => __( 'Nayarit', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'OA' => __( 'Oaxaca', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'PU' => __( 'Puebla', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'QT' => __( 'Querétaro', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'QR' => __( 'Quintana Roo', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'SL' => __( 'San Luis Potosí', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'SI' => __( 'Sinaloa', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'SO' => __( 'Sonora', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TB' => __( 'Tabasco', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TM' => __( 'Tamaulipas', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TL' => __( 'Tlaxcala', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'VE' => __( 'Veracruz', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'YU' => __( 'Yucatán', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'ZA' => __( 'Zacatecas', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
	),
	'MY' => array( // Malaysian states.
		'JHR' => __( 'Johor', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'KDH' => __( 'Kedah', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'KTN' => __( 'Kelantan', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'LBN' => __( 'Labuan', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'MLK' => __( 'Malacca (Melaka)', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'NSN' => __( 'Negeri Sembilan', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'PHG' => __( 'Pahang', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'PNG' => __( 'Penang (Pulau Pinang)', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'PRK' => __( 'Perak', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'PLS' => __( 'Perlis', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'SBH' => __( 'Sabah', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'SWK' => __( 'Sarawak', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'SGR' => __( 'Selangor', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TRG' => __( 'Terengganu', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'PJY' => __( 'Putrajaya', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'KUL' => __( 'Kuala Lumpur', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
	),
	'MZ' => array( // Mozambique provinces.
		'MZP'   => __( 'Cabo Delgado', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'MZG'   => __( 'Gaza', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'MZI'   => __( 'Inhambane', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'MZB'   => __( 'Manica', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'MZL'   => __( 'Maputo Province', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'MZMPM' => __( 'Maputo', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'MZN'   => __( 'Nampula', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'MZA'   => __( 'Niassa', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'MZS'   => __( 'Sofala', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'MZT'   => __( 'Tete', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'MZQ'   => __( 'Zambézia', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
	),
	'NA' => array( // Namibia regions.
		'ER' => __( 'Erongo', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'HA' => __( 'Hardap', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'KA' => __( 'Karas', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'KE' => __( 'Kavango East', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'KW' => __( 'Kavango West', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'KH' => __( 'Khomas', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'KU' => __( 'Kunene', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'OW' => __( 'Ohangwena', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'OH' => __( 'Omaheke', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'OS' => __( 'Omusati', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'ON' => __( 'Oshana', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'OT' => __( 'Oshikoto', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'OD' => __( 'Otjozondjupa', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CA' => __( 'Zambezi', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
	),
	'NG' => array( // Nigerian provinces.
		'AB' => __( 'Abia', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'FC' => __( 'Abuja', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'AD' => __( 'Adamawa', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'AK' => __( 'Akwa Ibom', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'AN' => __( 'Anambra', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BA' => __( 'Bauchi', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BY' => __( 'Bayelsa', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BE' => __( 'Benue', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BO' => __( 'Borno', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CR' => __( 'Cross River', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'DE' => __( 'Delta', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'EB' => __( 'Ebonyi', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'ED' => __( 'Edo', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'EK' => __( 'Ekiti', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'EN' => __( 'Enugu', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'GO' => __( 'Gombe', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'IM' => __( 'Imo', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'JI' => __( 'Jigawa', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'KD' => __( 'Kaduna', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'KN' => __( 'Kano', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'KT' => __( 'Katsina', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'KE' => __( 'Kebbi', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'KO' => __( 'Kogi', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'KW' => __( 'Kwara', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'LA' => __( 'Lagos', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'NA' => __( 'Nasarawa', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'NI' => __( 'Niger', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'OG' => __( 'Ogun', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'ON' => __( 'Ondo', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'OS' => __( 'Osun', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'OY' => __( 'Oyo', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'PL' => __( 'Plateau', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'RI' => __( 'Rivers', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'SO' => __( 'Sokoto', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TA' => __( 'Taraba', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'YO' => __( 'Yobe', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'ZA' => __( 'Zamfara', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
	),
	'NL' => array(),
	'NO' => array(),
	'NP' => array( // Nepal states (Zones).
		'BAG' => __( 'Bagmati', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BHE' => __( 'Bheri', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'DHA' => __( 'Dhaulagiri', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'GAN' => __( 'Gandaki', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'JAN' => __( 'Janakpur', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'KAR' => __( 'Karnali', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'KOS' => __( 'Koshi', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'LUM' => __( 'Lumbini', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'MAH' => __( 'Mahakali', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'MEC' => __( 'Mechi', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'NAR' => __( 'Narayani', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'RAP' => __( 'Rapti', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'SAG' => __( 'Sagarmatha', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'SET' => __( 'Seti', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
	),
	'NZ' => array( // New Zealand States.
		'NL' => __( 'Northland', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'AK' => __( 'Auckland', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'WA' => __( 'Waikato', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BP' => __( 'Bay of Plenty', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TK' => __( 'Taranaki', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'GI' => __( 'Gisborne', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'HB' => __( 'Hawke’s Bay', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'MW' => __( 'Manawatu-Wanganui', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'WE' => __( 'Wellington', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'NS' => __( 'Nelson', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'MB' => __( 'Marlborough', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TM' => __( 'Tasman', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'WC' => __( 'West Coast', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CT' => __( 'Canterbury', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'OT' => __( 'Otago', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'SL' => __( 'Southland', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
	),
	'PE' => array( // Peru states.
		'CAL' => __( 'El Callao', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'LMA' => __( 'Municipalidad Metropolitana de Lima', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'AMA' => __( 'Amazonas', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'ANC' => __( 'Ancash', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'APU' => __( 'Apurímac', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'ARE' => __( 'Arequipa', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'AYA' => __( 'Ayacucho', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CAJ' => __( 'Cajamarca', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CUS' => __( 'Cusco', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'HUV' => __( 'Huancavelica', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'HUC' => __( 'Huánuco', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'ICA' => __( 'Ica', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'JUN' => __( 'Junín', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'LAL' => __( 'La Libertad', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'LAM' => __( 'Lambayeque', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'LIM' => __( 'Lima', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'LOR' => __( 'Loreto', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'MDD' => __( 'Madre de Dios', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'MOQ' => __( 'Moquegua', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'PAS' => __( 'Pasco', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'PIU' => __( 'Piura', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'PUN' => __( 'Puno', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'SAM' => __( 'San Martín', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TAC' => __( 'Tacna', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TUM' => __( 'Tumbes', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UCA' => __( 'Ucayali', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
	),

	/**
	 * Philippine Provinces.
	 */
	'PH' => array(
		'ABR' => __( 'Abra', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'AGN' => __( 'Agusan del Norte', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'AGS' => __( 'Agusan del Sur', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'AKL' => __( 'Aklan', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'ALB' => __( 'Albay', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'ANT' => __( 'Antique', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'APA' => __( 'Apayao', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'AUR' => __( 'Aurora', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BAS' => __( 'Basilan', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BAN' => __( 'Bataan', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BTN' => __( 'Batanes', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BTG' => __( 'Batangas', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BEN' => __( 'Benguet', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BIL' => __( 'Biliran', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BOH' => __( 'Bohol', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BUK' => __( 'Bukidnon', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BUL' => __( 'Bulacan', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CAG' => __( 'Cagayan', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CAN' => __( 'Camarines Norte', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CAS' => __( 'Camarines Sur', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CAM' => __( 'Camiguin', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CAP' => __( 'Capiz', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CAT' => __( 'Catanduanes', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CAV' => __( 'Cavite', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CEB' => __( 'Cebu', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'COM' => __( 'Compostela Valley', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'NCO' => __( 'Cotabato', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'DAV' => __( 'Davao del Norte', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'DAS' => __( 'Davao del Sur', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'DAC' => __( 'Davao Occidental', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'DAO' => __( 'Davao Oriental', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'DIN' => __( 'Dinagat Islands', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'EAS' => __( 'Eastern Samar', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'GUI' => __( 'Guimaras', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'IFU' => __( 'Ifugao', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'ILN' => __( 'Ilocos Norte', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'ILS' => __( 'Ilocos Sur', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'ILI' => __( 'Iloilo', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'ISA' => __( 'Isabela', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'KAL' => __( 'Kalinga', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'LUN' => __( 'La Union', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'LAG' => __( 'Laguna', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'LAN' => __( 'Lanao del Norte', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'LAS' => __( 'Lanao del Sur', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'LEY' => __( 'Leyte', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'MAG' => __( 'Maguindanao', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'MAD' => __( 'Marinduque', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'MAS' => __( 'Masbate', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'MSC' => __( 'Misamis Occidental', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'MSR' => __( 'Misamis Oriental', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'MOU' => __( 'Mountain Province', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'NEC' => __( 'Negros Occidental', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'NER' => __( 'Negros Oriental', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'NSA' => __( 'Northern Samar', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'NUE' => __( 'Nueva Ecija', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'NUV' => __( 'Nueva Vizcaya', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'MDC' => __( 'Occidental Mindoro', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'MDR' => __( 'Oriental Mindoro', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'PLW' => __( 'Palawan', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'PAM' => __( 'Pampanga', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'PAN' => __( 'Pangasinan', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'QUE' => __( 'Quezon', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'QUI' => __( 'Quirino', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'RIZ' => __( 'Rizal', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'ROM' => __( 'Romblon', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'WSA' => __( 'Samar', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'SAR' => __( 'Sarangani', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'SIQ' => __( 'Siquijor', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'SOR' => __( 'Sorsogon', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'SCO' => __( 'South Cotabato', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'SLE' => __( 'Southern Leyte', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'SUK' => __( 'Sultan Kudarat', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'SLU' => __( 'Sulu', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'SUN' => __( 'Surigao del Norte', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'SUR' => __( 'Surigao del Sur', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TAR' => __( 'Tarlac', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TAW' => __( 'Tawi-Tawi', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'ZMB' => __( 'Zambales', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'ZAN' => __( 'Zamboanga del Norte', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'ZAS' => __( 'Zamboanga del Sur', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'ZSI' => __( 'Zamboanga Sibugay', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'00'  => __( 'Metro Manila', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
	),
	'PK' => array( // Pakistan's states.
		'JK' => __( 'Azad Kashmir', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BA' => __( 'Balochistan', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TA' => __( 'FATA', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'GB' => __( 'Gilgit Baltistan', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'IS' => __( 'Islamabad Capital Territory', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'KP' => __( 'Khyber Pakhtunkhwa', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'PB' => __( 'Punjab', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'SD' => __( 'Sindh', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
	),
	'PL' => array(),
	'PT' => array(),
	'PY' => array( // Paraguay states.
		'PY-ASU' => __( 'Asunción', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'PY-1'   => __( 'Concepción', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'PY-2'   => __( 'San Pedro', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'PY-3'   => __( 'Cordillera', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'PY-4'   => __( 'Guairá', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'PY-5'   => __( 'Caaguazú', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'PY-6'   => __( 'Caazapá', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'PY-7'   => __( 'Itapúa', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'PY-8'   => __( 'Misiones', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'PY-9'   => __( 'Paraguarí', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'PY-10'  => __( 'Alto Paraná', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'PY-11'  => __( 'Central', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'PY-12'  => __( 'Ñeembucú', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'PY-13'  => __( 'Amambay', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'PY-14'  => __( 'Canindeyú', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'PY-15'  => __( 'Presidente Hayes', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'PY-16'  => __( 'Alto Paraguay', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'PY-17'  => __( 'Boquerón', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
	),
	'RE' => array(),
	'RO' => array( // Romania states.
		'AB' => __( 'Alba', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'AR' => __( 'Arad', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'AG' => __( 'Argeș', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BC' => __( 'Bacău', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BH' => __( 'Bihor', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BN' => __( 'Bistrița-Năsăud', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BT' => __( 'Botoșani', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BR' => __( 'Brăila', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BV' => __( 'Brașov', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'B'  => __( 'București', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'BZ' => __( 'Buzău', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CL' => __( 'Călărași', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CS' => __( 'Caraș-Severin', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CJ' => __( 'Cluj', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CT' => __( 'Constanța', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CV' => __( 'Covasna', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'DB' => __( 'Dâmbovița', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'DJ' => __( 'Dolj', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'GL' => __( 'Galați', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'GR' => __( 'Giurgiu', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'GJ' => __( 'Gorj', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'HR' => __( 'Harghita', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'HD' => __( 'Hunedoara', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'IL' => __( 'Ialomița', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'IS' => __( 'Iași', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'IF' => __( 'Ilfov', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'MM' => __( 'Maramureș', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'MH' => __( 'Mehedinți', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'MS' => __( 'Mureș', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'NT' => __( 'Neamț', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'OT' => __( 'Olt', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'PH' => __( 'Prahova', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'SJ' => __( 'Sălaj', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'SM' => __( 'Satu Mare', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'SB' => __( 'Sibiu', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'SV' => __( 'Suceava', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TR' => __( 'Teleorman', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TM' => __( 'Timiș', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TL' => __( 'Tulcea', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'VL' => __( 'Vâlcea', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'VS' => __( 'Vaslui', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'VN' => __( 'Vrancea', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
	),
	'RS' => array(),
	'SG' => array(),
	'SK' => array(),
	'SI' => array(),
	'TH' => array( // Thailand states.
		'TH-37' => __( 'Amnat Charoen', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TH-15' => __( 'Ang Thong', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TH-14' => __( 'Ayutthaya', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TH-10' => __( 'Bangkok', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TH-38' => __( 'Bueng Kan', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TH-31' => __( 'Buri Ram', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TH-24' => __( 'Chachoengsao', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TH-18' => __( 'Chai Nat', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TH-36' => __( 'Chaiyaphum', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TH-22' => __( 'Chanthaburi', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TH-50' => __( 'Chiang Mai', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TH-57' => __( 'Chiang Rai', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TH-20' => __( 'Chonburi', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TH-86' => __( 'Chumphon', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TH-46' => __( 'Kalasin', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TH-62' => __( 'Kamphaeng Phet', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TH-71' => __( 'Kanchanaburi', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TH-40' => __( 'Khon Kaen', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TH-81' => __( 'Krabi', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TH-52' => __( 'Lampang', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TH-51' => __( 'Lamphun', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TH-42' => __( 'Loei', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TH-16' => __( 'Lopburi', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TH-58' => __( 'Mae Hong Son', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TH-44' => __( 'Maha Sarakham', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TH-49' => __( 'Mukdahan', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TH-26' => __( 'Nakhon Nayok', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TH-73' => __( 'Nakhon Pathom', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TH-48' => __( 'Nakhon Phanom', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TH-30' => __( 'Nakhon Ratchasima', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TH-60' => __( 'Nakhon Sawan', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TH-80' => __( 'Nakhon Si Thammarat', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TH-55' => __( 'Nan', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TH-96' => __( 'Narathiwat', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TH-39' => __( 'Nong Bua Lam Phu', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TH-43' => __( 'Nong Khai', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TH-12' => __( 'Nonthaburi', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TH-13' => __( 'Pathum Thani', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TH-94' => __( 'Pattani', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TH-82' => __( 'Phang Nga', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TH-93' => __( 'Phatthalung', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TH-56' => __( 'Phayao', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TH-67' => __( 'Phetchabun', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TH-76' => __( 'Phetchaburi', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TH-66' => __( 'Phichit', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TH-65' => __( 'Phitsanulok', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TH-54' => __( 'Phrae', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TH-83' => __( 'Phuket', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TH-25' => __( 'Prachin Buri', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TH-77' => __( 'Prachuap Khiri Khan', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TH-85' => __( 'Ranong', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TH-70' => __( 'Ratchaburi', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TH-21' => __( 'Rayong', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TH-45' => __( 'Roi Et', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TH-27' => __( 'Sa Kaeo', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TH-47' => __( 'Sakon Nakhon', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TH-11' => __( 'Samut Prakan', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TH-74' => __( 'Samut Sakhon', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TH-75' => __( 'Samut Songkhram', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TH-19' => __( 'Saraburi', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TH-91' => __( 'Satun', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TH-17' => __( 'Sing Buri', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TH-33' => __( 'Sisaket', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TH-90' => __( 'Songkhla', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TH-64' => __( 'Sukhothai', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TH-72' => __( 'Suphan Buri', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TH-84' => __( 'Surat Thani', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TH-32' => __( 'Surin', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TH-63' => __( 'Tak', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TH-92' => __( 'Trang', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TH-23' => __( 'Trat', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TH-34' => __( 'Ubon Ratchathani', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TH-41' => __( 'Udon Thani', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TH-61' => __( 'Uthai Thani', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TH-53' => __( 'Uttaradit', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TH-95' => __( 'Yala', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TH-35' => __( 'Yasothon', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
	),
	'TR' => array( // Turkey States.
		'TR01' => __( 'Adana', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TR02' => __( 'Adıyaman', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TR03' => __( 'Afyon', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TR04' => __( 'Ağrı', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TR05' => __( 'Amasya', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TR06' => __( 'Ankara', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TR07' => __( 'Antalya', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TR08' => __( 'Artvin', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TR09' => __( 'Aydın', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TR10' => __( 'Balıkesir', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TR11' => __( 'Bilecik', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TR12' => __( 'Bingöl', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TR13' => __( 'Bitlis', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TR14' => __( 'Bolu', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TR15' => __( 'Burdur', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TR16' => __( 'Bursa', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TR17' => __( 'Çanakkale', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TR18' => __( 'Çankırı', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TR19' => __( 'Çorum', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TR20' => __( 'Denizli', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TR21' => __( 'Diyarbakır', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TR22' => __( 'Edirne', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TR23' => __( 'Elazığ', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TR24' => __( 'Erzincan', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TR25' => __( 'Erzurum', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TR26' => __( 'Eskişehir', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TR27' => __( 'Gaziantep', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TR28' => __( 'Giresun', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TR29' => __( 'Gümüşhane', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TR30' => __( 'Hakkari', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TR31' => __( 'Hatay', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TR32' => __( 'Isparta', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TR33' => __( 'İçel', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TR34' => __( 'İstanbul', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TR35' => __( 'İzmir', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TR36' => __( 'Kars', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TR37' => __( 'Kastamonu', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TR38' => __( 'Kayseri', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TR39' => __( 'Kırklareli', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TR40' => __( 'Kırşehir', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TR41' => __( 'Kocaeli', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TR42' => __( 'Konya', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TR43' => __( 'Kütahya', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TR44' => __( 'Malatya', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TR45' => __( 'Manisa', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TR46' => __( 'Kahramanmaraş', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TR47' => __( 'Mardin', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TR48' => __( 'Muğla', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TR49' => __( 'Muş', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TR50' => __( 'Nevşehir', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TR51' => __( 'Niğde', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TR52' => __( 'Ordu', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TR53' => __( 'Rize', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TR54' => __( 'Sakarya', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TR55' => __( 'Samsun', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TR56' => __( 'Siirt', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TR57' => __( 'Sinop', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TR58' => __( 'Sivas', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TR59' => __( 'Tekirdağ', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TR60' => __( 'Tokat', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TR61' => __( 'Trabzon', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TR62' => __( 'Tunceli', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TR63' => __( 'Şanlıurfa', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TR64' => __( 'Uşak', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TR65' => __( 'Van', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TR66' => __( 'Yozgat', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TR67' => __( 'Zonguldak', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TR68' => __( 'Aksaray', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TR69' => __( 'Bayburt', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TR70' => __( 'Karaman', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TR71' => __( 'Kırıkkale', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TR72' => __( 'Batman', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TR73' => __( 'Şırnak', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TR74' => __( 'Bartın', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TR75' => __( 'Ardahan', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TR76' => __( 'Iğdır', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TR77' => __( 'Yalova', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TR78' => __( 'Karabük', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TR79' => __( 'Kilis', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TR80' => __( 'Osmaniye', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TR81' => __( 'Düzce', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
	),
	'TZ' => array( // Tanzania States.
		'TZ01' => __( 'Arusha', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TZ02' => __( 'Dar es Salaam', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TZ03' => __( 'Dodoma', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TZ04' => __( 'Iringa', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TZ05' => __( 'Kagera', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TZ06' => __( 'Pemba North', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TZ07' => __( 'Zanzibar North', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TZ08' => __( 'Kigoma', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TZ09' => __( 'Kilimanjaro', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TZ10' => __( 'Pemba South', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TZ11' => __( 'Zanzibar South', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TZ12' => __( 'Lindi', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TZ13' => __( 'Mara', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TZ14' => __( 'Mbeya', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TZ15' => __( 'Zanzibar West', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TZ16' => __( 'Morogoro', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TZ17' => __( 'Mtwara', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TZ18' => __( 'Mwanza', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TZ19' => __( 'Coast', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TZ20' => __( 'Rukwa', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TZ21' => __( 'Ruvuma', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TZ22' => __( 'Shinyanga', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TZ23' => __( 'Singida', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TZ24' => __( 'Tabora', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TZ25' => __( 'Tanga', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TZ26' => __( 'Manyara', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TZ27' => __( 'Geita', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TZ28' => __( 'Katavi', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TZ29' => __( 'Njombe', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TZ30' => __( 'Simiyu', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
	),
	'LK' => array(),
	'SE' => array(),
	'UG' => array( // Uganda districts. Ref: https://en.wikipedia.org/wiki/ISO_3166-2:UG.
		'UG314' => __( 'Abim', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG301' => __( 'Adjumani', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG322' => __( 'Agago', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG323' => __( 'Alebtong', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG315' => __( 'Amolatar', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG324' => __( 'Amudat', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG216' => __( 'Amuria', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG316' => __( 'Amuru', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG302' => __( 'Apac', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG303' => __( 'Arua', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG217' => __( 'Budaka', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG218' => __( 'Bududa', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG201' => __( 'Bugiri', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG235' => __( 'Bugweri', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG420' => __( 'Buhweju', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG117' => __( 'Buikwe', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG219' => __( 'Bukedea', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG118' => __( 'Bukomansimbi', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG220' => __( 'Bukwa', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG225' => __( 'Bulambuli', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG416' => __( 'Buliisa', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG401' => __( 'Bundibugyo', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG430' => __( 'Bunyangabu', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG402' => __( 'Bushenyi', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG202' => __( 'Busia', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG221' => __( 'Butaleja', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG119' => __( 'Butambala', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG233' => __( 'Butebo', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG120' => __( 'Buvuma', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG226' => __( 'Buyende', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG317' => __( 'Dokolo', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG121' => __( 'Gomba', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG304' => __( 'Gulu', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG403' => __( 'Hoima', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG417' => __( 'Ibanda', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG203' => __( 'Iganga', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG418' => __( 'Isingiro', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG204' => __( 'Jinja', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG318' => __( 'Kaabong', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG404' => __( 'Kabale', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG405' => __( 'Kabarole', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG213' => __( 'Kaberamaido', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG427' => __( 'Kagadi', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG428' => __( 'Kakumiro', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG101' => __( 'Kalangala', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG222' => __( 'Kaliro', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG122' => __( 'Kalungu', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG102' => __( 'Kampala', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG205' => __( 'Kamuli', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG413' => __( 'Kamwenge', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG414' => __( 'Kanungu', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG206' => __( 'Kapchorwa', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG236' => __( 'Kapelebyong', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG126' => __( 'Kasanda', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG406' => __( 'Kasese', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG207' => __( 'Katakwi', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG112' => __( 'Kayunga', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG407' => __( 'Kibaale', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG103' => __( 'Kiboga', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG227' => __( 'Kibuku', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG432' => __( 'Kikuube', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG419' => __( 'Kiruhura', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG421' => __( 'Kiryandongo', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG408' => __( 'Kisoro', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG305' => __( 'Kitgum', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG319' => __( 'Koboko', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG325' => __( 'Kole', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG306' => __( 'Kotido', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG208' => __( 'Kumi', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG333' => __( 'Kwania', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG228' => __( 'Kween', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG123' => __( 'Kyankwanzi', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG422' => __( 'Kyegegwa', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG415' => __( 'Kyenjojo', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG125' => __( 'Kyotera', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG326' => __( 'Lamwo', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG307' => __( 'Lira', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG229' => __( 'Luuka', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG104' => __( 'Luwero', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG124' => __( 'Lwengo', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG114' => __( 'Lyantonde', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG223' => __( 'Manafwa', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG320' => __( 'Maracha', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG105' => __( 'Masaka', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG409' => __( 'Masindi', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG214' => __( 'Mayuge', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG209' => __( 'Mbale', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG410' => __( 'Mbarara', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG423' => __( 'Mitooma', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG115' => __( 'Mityana', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG308' => __( 'Moroto', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG309' => __( 'Moyo', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG106' => __( 'Mpigi', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG107' => __( 'Mubende', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG108' => __( 'Mukono', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG334' => __( 'Nabilatuk', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG311' => __( 'Nakapiripirit', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG116' => __( 'Nakaseke', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG109' => __( 'Nakasongola', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG230' => __( 'Namayingo', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG234' => __( 'Namisindwa', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG224' => __( 'Namutumba', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG327' => __( 'Napak', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG310' => __( 'Nebbi', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG231' => __( 'Ngora', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG424' => __( 'Ntoroko', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG411' => __( 'Ntungamo', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG328' => __( 'Nwoya', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG331' => __( 'Omoro', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG329' => __( 'Otuke', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG321' => __( 'Oyam', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG312' => __( 'Pader', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG332' => __( 'Pakwach', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG210' => __( 'Pallisa', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG110' => __( 'Rakai', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG429' => __( 'Rubanda', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG425' => __( 'Rubirizi', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG431' => __( 'Rukiga', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG412' => __( 'Rukungiri', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG111' => __( 'Sembabule', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG232' => __( 'Serere', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG426' => __( 'Sheema', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG215' => __( 'Sironko', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG211' => __( 'Soroti', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG212' => __( 'Tororo', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG113' => __( 'Wakiso', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG313' => __( 'Yumbe', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UG330' => __( 'Zombo', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
	),
	'UM' => array(
		'81' => __( 'Baker Island', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'84' => __( 'Howland Island', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'86' => __( 'Jarvis Island', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'67' => __( 'Johnston Atoll', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'89' => __( 'Kingman Reef', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'71' => __( 'Midway Atoll', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'76' => __( 'Navassa Island', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'95' => __( 'Palmyra Atoll', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'79' => __( 'Wake Island', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
	),
	'US' => array( // United States.
		'AL' => __( 'Alabama', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'AK' => __( 'Alaska', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'AZ' => __( 'Arizona', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'AR' => __( 'Arkansas', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CA' => __( 'California', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CO' => __( 'Colorado', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'CT' => __( 'Connecticut', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'DE' => __( 'Delaware', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'DC' => __( 'District Of Columbia', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'FL' => __( 'Florida', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'GA' => _x( 'Georgia', 'US state of Georgia', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'HI' => __( 'Hawaii', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'ID' => __( 'Idaho', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'IL' => __( 'Illinois', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'IN' => __( 'Indiana', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'IA' => __( 'Iowa', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'KS' => __( 'Kansas', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'KY' => __( 'Kentucky', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'LA' => __( 'Louisiana', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'ME' => __( 'Maine', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'MD' => __( 'Maryland', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'MA' => __( 'Massachusetts', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'MI' => __( 'Michigan', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'MN' => __( 'Minnesota', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'MS' => __( 'Mississippi', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'MO' => __( 'Missouri', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'MT' => __( 'Montana', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'NE' => __( 'Nebraska', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'NV' => __( 'Nevada', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'NH' => __( 'New Hampshire', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'NJ' => __( 'New Jersey', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'NM' => __( 'New Mexico', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'NY' => __( 'New York', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'NC' => __( 'North Carolina', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'ND' => __( 'North Dakota', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'OH' => __( 'Ohio', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'OK' => __( 'Oklahoma', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'OR' => __( 'Oregon', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'PA' => __( 'Pennsylvania', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'RI' => __( 'Rhode Island', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'SC' => __( 'South Carolina', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'SD' => __( 'South Dakota', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TN' => __( 'Tennessee', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'TX' => __( 'Texas', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'UT' => __( 'Utah', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'VT' => __( 'Vermont', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'VA' => __( 'Virginia', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'WA' => __( 'Washington', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'WV' => __( 'West Virginia', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'WI' => __( 'Wisconsin', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'WY' => __( 'Wyoming', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'AA' => __( 'Armed Forces (AA)', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'AE' => __( 'Armed Forces (AE)', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'AP' => __( 'Armed Forces (AP)', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
	),
	'VN' => array(),
	'YT' => array(),
	'ZA' => array( // South African states.
		'EC'  => __( 'Eastern Cape', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'FS'  => __( 'Free State', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'GP'  => __( 'Gauteng', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'KZN' => __( 'KwaZulu-Natal', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'LP'  => __( 'Limpopo', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'MP'  => __( 'Mpumalanga', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'NC'  => __( 'Northern Cape', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'NW'  => __( 'North West', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'WC'  => __( 'Western Cape', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
	),
	'ZM' => array( // Zambia's Provinces. Ref: https://en.wikipedia.org/wiki/ISO_3166-2:ZM.
		'ZM-01' => __( 'Western', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'ZM-02' => __( 'Central', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'ZM-03' => __( 'Eastern', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'ZM-04' => __( 'Luapula', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'ZM-05' => __( 'Northern', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'ZM-06' => __( 'North-Western', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'ZM-07' => __( 'Southern', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'ZM-08' => __( 'Copperbelt', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'ZM-09' => __( 'Lusaka', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
		'ZM-10' => __( 'Muchinga', 'woofunnels' ), // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch
	),
);
