import { registerBlockType } from '@wordpress/blocks';
import './style.scss';

/**
 * Internal dependencies
 */
import Edit from './edit';
import save from './save';
import metadata from './block.json';

registerBlockType( metadata.name, {
	/**
	 * @see ./edit.js
	 */
	edit: Edit,

	/**
	 * Block icon
	 */
	icon: {
		src: (
			<svg
				version="1.1"
				xmlns="http://www.w3.org/2000/svg"
				width="56"
				height="32"
				viewBox="0 0 56 32"
			>
				<title>pricing-table</title>
				<path d="M17.951 32h20.449v-32h-20.449v32zM18.732 0.78h18.888v30.439h-18.888v-30.439z"></path>
				<path d="M34.419 21.776h-12.488c-0.234 0-0.39 0.156-0.39 0.39s0.156 0.39 0.39 0.39h12.488c0.234 0 0.39-0.156 0.39-0.39s-0.234-0.39-0.39-0.39z"></path>
				<path d="M32.859 24.117h-9.444c-0.234 0-0.39 0.156-0.39 0.39s0.156 0.39 0.39 0.39h9.444c0.234 0 0.39-0.156 0.39-0.39s-0.156-0.39-0.39-0.39z"></path>
				<path d="M31.063 26.459h-5.854c-0.234 0-0.39 0.156-0.39 0.39s0.156 0.39 0.39 0.39h5.854c0.234 0 0.39-0.156 0.39-0.39s-0.156-0.39-0.39-0.39z"></path>
				<path d="M28.176 14.751c-1.015 0-1.873-0.859-1.873-1.873 0-0.234-0.156-0.39-0.39-0.39s-0.39 0.156-0.39 0.39c0 1.327 1.015 2.419 2.263 2.654v1.249c0 0.234 0.156 0.39 0.39 0.39s0.39-0.156 0.39-0.39v-1.249c1.249-0.156 2.263-1.327 2.263-2.654 0-1.483-1.171-2.654-2.654-2.654-1.015 0-1.873-0.859-1.873-1.873s0.859-1.873 1.873-1.873c1.015 0 1.873 0.859 1.873 1.873 0 0.234 0.156 0.39 0.39 0.39s0.39-0.156 0.39-0.39c0-1.327-1.015-2.42-2.263-2.654v-1.327c0-0.234-0.156-0.39-0.39-0.39s-0.39 0.156-0.39 0.39v1.249c-1.249 0.156-2.263 1.327-2.263 2.654 0 1.483 1.171 2.654 2.654 2.654 1.015 0 1.873 0.859 1.873 1.873s-0.859 1.951-1.873 1.951z"></path>
				<path d="M44.878 21.307h8.273c0.234 0 0.39-0.156 0.39-0.39s-0.156-0.39-0.39-0.39h-8.273c-0.234 0-0.39 0.156-0.39 0.39s0.156 0.39 0.39 0.39z"></path>
				<path d="M51.59 22.868h-5.229c-0.234 0-0.39 0.156-0.39 0.39s0.156 0.39 0.39 0.39h5.229c0.234 0 0.39-0.156 0.39-0.39s-0.156-0.39-0.39-0.39z"></path>
				<path d="M41.834 4.839v22.322h14.361v-22.322h-14.361zM55.415 26.381h-12.8v-20.761h12.8v20.761z"></path>
				<path d="M49.015 13.737c-0.468 0-0.78-0.39-0.78-0.78 0-0.234-0.156-0.39-0.39-0.39s-0.39 0.156-0.39 0.39c0 0.702 0.546 1.327 1.171 1.561v0.468c0 0.234 0.156 0.39 0.39 0.39s0.39-0.156 0.39-0.39v-0.468c0.702-0.156 1.171-0.78 1.171-1.561 0-0.859-0.702-1.561-1.561-1.561-0.468 0-0.781-0.39-0.781-0.78 0-0.468 0.312-0.78 0.781-0.78 0 0 0 0 0 0s0 0 0 0c0.468 0 0.781 0.39 0.781 0.78 0 0.234 0.156 0.39 0.39 0.39s0.39-0.156 0.39-0.39c0-0.702-0.546-1.327-1.171-1.561v-0.468c0-0.234-0.156-0.39-0.39-0.39s-0.39 0.156-0.39 0.39v0.468c-0.702 0.156-1.171 0.78-1.171 1.561 0 0.859 0.702 1.561 1.561 1.561 0.468 0 0.781 0.39 0.781 0.78s-0.312 0.78-0.781 0.78z"></path>
				<path d="M11.317 20.527h-8.273c-0.234 0-0.39 0.156-0.39 0.39s0.156 0.39 0.39 0.39h8.273c0.234 0 0.39-0.156 0.39-0.39s-0.156-0.39-0.39-0.39z"></path>
				<path d="M9.756 22.868h-5.229c-0.234 0-0.39 0.156-0.39 0.39s0.156 0.39 0.39 0.39h5.229c0.234 0 0.39-0.156 0.39-0.39s-0.156-0.39-0.39-0.39z"></path>
				<path d="M0 27.161h14.361v-22.322h-14.361v22.322zM0.78 5.62h12.8v20.761h-12.8v-20.761z"></path>
				<path d="M7.181 13.737c-0.468 0-0.78-0.39-0.78-0.78 0-0.234-0.156-0.39-0.39-0.39s-0.39 0.156-0.39 0.39c0 0.702 0.546 1.327 1.171 1.561v0.468c0 0.234 0.156 0.39 0.39 0.39s0.39-0.156 0.39-0.39v-0.468c0.702-0.156 1.171-0.78 1.171-1.561 0-0.859-0.702-1.561-1.561-1.561-0.468 0-0.78-0.39-0.78-0.78 0-0.468 0.312-0.78 0.78-0.78 0 0 0 0 0 0s0 0 0 0c0.468 0 0.78 0.39 0.78 0.78 0 0.234 0.156 0.39 0.39 0.39s0.39-0.156 0.39-0.39c0-0.702-0.546-1.327-1.171-1.561v-0.468c0-0.234-0.156-0.39-0.39-0.39s-0.39 0.156-0.39 0.39v0.468c-0.702 0.156-1.171 0.78-1.171 1.561 0 0.859 0.702 1.561 1.561 1.561 0.468 0 0.78 0.39 0.78 0.78s-0.312 0.78-0.78 0.78z"></path>
			</svg>
		),
	},

	/**
	 * @see ./save.js
	 */
	save,
} );
