<?php

class BWFAN_WC_Cart_Billing_Email extends BWFAN_Merge_Tag {

	private static $instance = null;

	public function __construct() {
		$this->tag_name        = 'cart_billing_email';
		$this->tag_description = __( 'Cart Billing Email', 'wp-marketing-automations' );
		add_shortcode( 'bwfan_cart_billing_email', array( $this, 'parse_shortcode' ) );
		$this->support_fallback = false;
		$this->priority         = 1;
	}

	public static function get_instance() {
		if ( null === self::$instance ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	/**
	 * Parse the merge tag and return its value.
	 *
	 * @param $attr
	 *
	 * @return mixed|string|void
	 */
	public function parse_shortcode( $attr ) {
		if ( true === BWFAN_Merge_Tag_Loader::get_data( 'is_preview' ) ) {
			return $this->get_dummy_preview();
		}

		return $this->parse_shortcode_output( BWFAN_Merge_Tag_Loader::get_data( 'email' ), $attr );
	}

	/**
	 * Show dummy value of the current merge tag.
	 *
	 * @return string
	 */
	public function get_dummy_preview() {
		return 'customer2133@gmail.com';
	}


}

/**
 * Register this merge tag to a group.
 */
if ( bwfan_is_woocommerce_active() ) {
	BWFAN_Merge_Tag_Loader::register( 'wc_ab_cart', 'BWFAN_WC_Cart_Billing_Email', null, __( 'Abandoned Cart', 'wp-marketing-automations' ) );
}
