<?php

class BWFAN_WC_Admin_Order_Note extends BWFAN_Merge_Tag {

	private static $instance = null;


	public function __construct() {
		$this->tag_name        = 'current_order_note';
		$this->tag_description = __( 'Current Order Note', 'wp-marketing-automations' );
		add_shortcode( 'bwfan_current_order_note', array( $this, 'parse_shortcode' ) );
	}

	public static function get_instance() {
		if ( null === self::$instance ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	/**
	 * Parse the merge tag and return its value.
	 *
	 * @param $attr
	 *
	 * @return mixed|string|void
	 */
	public function parse_shortcode( $attr ) {
		if ( true === BWFAN_Merge_Tag_Loader::get_data( 'is_preview' ) ) {
			return $this->get_dummy_preview();
		}
		$current_order_note = BWFAN_Merge_Tag_Loader::get_data( 'current_order_note' );

		if ( empty( $current_order_note ) ) {
			return $this->parse_shortcode_output( '', $attr );
		}
		$current_order_note = apply_filters( 'bwfan_current_order_note', $current_order_note, $attr );

		return $this->parse_shortcode_output( $current_order_note, $attr );
	}

	/**
	 * Show dummy value of the current merge tag.
	 *
	 * @return string
	 */
	public function get_dummy_preview() {
		return 'Dummy order Note';
	}


}


/**
 * Register this merge tag to a group.
 */
if ( bwfan_is_woocommerce_active() ) {
	BWFAN_Merge_Tag_Loader::register( 'wc_order', 'BWFAN_WC_Admin_Order_Note', null, __( 'Order', 'wp-marketing-automations' ) );
}