<?php

class Chatbot_Widget extends \Elementor\Widget_Base {

    public function get_name() {

        return 'chatbot_widget';

    }



    public function get_title() {

        return __('Chatbot Widget', 'text-domain');

    }



    public function get_icon() {

        return 'eicon-chat';

    }



    public function get_categories() {

        return ['general'];

    }



    protected function render() {

        ?>
       <div id="chatbot-container">
            <!-- Chat Icon (Click to Open) -->
            <div id="chatbot-icon" onclick="toggleChat()">
                 <i class="fa-solid fa-robot"></i>
            </div>

            <!-- Chatbox -->
            <div id="chatbot">
               <div id="chat-header">
                    <div id="chat-header-2" style="width: 100%; height: 100%;">
                        <div class="chat-greetings">
                        <img src="<?php echo plugin_dir_url(__FILE__) . '/sapientus.png'; ?>" alt="" id="chatbot-logo">
                        <div>Sapientus AI Chatbot</div>
                    </div>
                    <div>
                        <span onclick="toggleChat()" id="close-chat">X</span>
                    </div>
                   </div>
                </div>
                <div id="chat-status">
                    <span class="status-dot"></span>Currently Online
                </div>

                <!-- Chat Messages -->
                <div id="chat-messages"></div>

                <!-- Chat Input -->
                <div id="chat-input-container">
                    <button id="emoji-button">😀</button>
                    <textarea id="chat-input" placeholder="Type your message..."></textarea>
                    <button id="send-message">
                        <i class="fa-regular fa-paper-plane"></i>
                    </button>
                    <div id="emoji-picker" style="display: none;"></div>
                </div>
            </div>
        </div>
        <?php

    }

}

?>

