/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2025-04-21 03:38:37 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wpbq_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpbq_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpbq_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `hash` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `package` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpbq_e_events` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `event_data` text COLLATE utf8mb4_unicode_520_ci,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `created_at_index` (`created_at`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpbq_e_notes` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `route_url` text COLLATE utf8mb4_unicode_520_ci COMMENT 'Clean url where the note was created.',
  `route_title` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `route_post_id` bigint(20) unsigned DEFAULT NULL COMMENT 'The post id of the route that the note was created on.',
  `post_id` bigint(20) unsigned DEFAULT NULL,
  `element_id` varchar(60) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL COMMENT 'The Elementor element ID the note is attached to.',
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `author_id` bigint(20) unsigned DEFAULT NULL,
  `author_display_name` varchar(250) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL COMMENT 'Save the author name when the author was deleted.',
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `position` text COLLATE utf8mb4_unicode_520_ci COMMENT 'A JSON string that represents the position of the note inside the element in percentages. e.g. {x:10, y:15}',
  `content` longtext COLLATE utf8mb4_unicode_520_ci,
  `is_resolved` tinyint(1) NOT NULL DEFAULT '0',
  `is_public` tinyint(1) NOT NULL DEFAULT '1',
  `last_activity_at` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `route_url_index` (`route_url`(191)),
  KEY `post_id_index` (`post_id`),
  KEY `element_id_index` (`element_id`),
  KEY `parent_id_index` (`parent_id`),
  KEY `author_id_index` (`author_id`),
  KEY `status_index` (`status`),
  KEY `is_resolved_index` (`is_resolved`),
  KEY `is_public_index` (`is_public`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`),
  KEY `last_activity_at_index` (`last_activity_at`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpbq_e_notes_users_relations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL COMMENT 'The relation type between user and note (e.g mention, watch, read).',
  `note_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `type_index` (`type`),
  KEY `note_id_index` (`note_id`),
  KEY `user_id_index` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpbq_e_submissions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(60) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `hash_id` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `main_meta_id` bigint(20) unsigned NOT NULL COMMENT 'Id of main field. to represent the main meta field',
  `post_id` bigint(20) unsigned NOT NULL,
  `referer` varchar(500) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `referer_title` varchar(300) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `element_id` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `form_name` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `campaign_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip` varchar(46) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `actions_count` int(11) DEFAULT '0',
  `actions_succeeded_count` int(11) DEFAULT '0',
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `is_read` tinyint(1) NOT NULL DEFAULT '0',
  `meta` text COLLATE utf8mb4_unicode_520_ci,
  `created_at_gmt` datetime NOT NULL,
  `updated_at_gmt` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `hash_id_unique_index` (`hash_id`),
  KEY `main_meta_id_index` (`main_meta_id`),
  KEY `hash_id_index` (`hash_id`),
  KEY `type_index` (`type`),
  KEY `post_id_index` (`post_id`),
  KEY `element_id_index` (`element_id`),
  KEY `campaign_id_index` (`campaign_id`),
  KEY `user_id_index` (`user_id`),
  KEY `user_ip_index` (`user_ip`),
  KEY `status_index` (`status`),
  KEY `is_read_index` (`is_read`),
  KEY `created_at_gmt_index` (`created_at_gmt`),
  KEY `updated_at_gmt_index` (`updated_at_gmt`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`),
  KEY `referer_index` (`referer`(191)),
  KEY `referer_title_index` (`referer_title`(191))
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpbq_e_submissions_actions_log` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) unsigned NOT NULL,
  `action_name` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `action_label` varchar(60) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `log` text COLLATE utf8mb4_unicode_520_ci,
  `created_at_gmt` datetime NOT NULL,
  `updated_at_gmt` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `submission_id_index` (`submission_id`),
  KEY `action_name_index` (`action_name`),
  KEY `status_index` (`status`),
  KEY `created_at_gmt_index` (`created_at_gmt`),
  KEY `updated_at_gmt_index` (`updated_at_gmt`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpbq_e_submissions_values` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `key` varchar(60) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  KEY `submission_id_index` (`submission_id`),
  KEY `key_index` (`key`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpbq_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpbq_loginizer_logs` (
  `username` varchar(255) NOT NULL DEFAULT '',
  `time` int(10) NOT NULL DEFAULT '0',
  `count` int(10) NOT NULL DEFAULT '0',
  `lockout` int(10) NOT NULL DEFAULT '0',
  `ip` varchar(255) NOT NULL DEFAULT '',
  `url` varchar(255) NOT NULL DEFAULT '',
  UNIQUE KEY `ip` (`ip`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wpbq_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=MyISAM AUTO_INCREMENT=2426 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpbq_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=11482 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpbq_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=MyISAM AUTO_INCREMENT=1301 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpbq_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpbq_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpbq_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpbq_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpbq_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=32 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpbq_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpbq_wpbot_response` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `query` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `keyword` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `response` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `category` varchar(256) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `intent` varchar(256) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `custom` varchar(256) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `lang` varchar(25) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  FULLTEXT KEY `query` (`query`,`keyword`,`response`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpbq_wpbot_sessions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `session` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpbq_wpfm_backup` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `backup_name` text COLLATE utf8mb4_unicode_520_ci,
  `backup_date` text COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpbq_wpwhpro_authentication` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `auth_type` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `template` longtext COLLATE utf8mb4_unicode_520_ci,
  `log_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: wpbq_duplicator_packages */
INSERT INTO `wpbq_duplicator_packages` VALUES("3", "20250226_sapientus_black", "8190aff268a3ddda5033_20250421033826", "21", "2025-04-21 03:38:37", "sapientus_author", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-04-21 03:38:26\";s:7:\"Version\";s:8:\"1.5.11.2\";s:9:\"VersionWP\";s:3:\"6.8\";s:9:\"VersionDB\";s:6:\"5.7.43\";s:10:\"VersionPHP\";s:6:\"8.2.28\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:3;s:4:\"Name\";s:24:\"20250226_sapientus_black\";s:4:\"Hash\";s:35:\"8190aff268a3ddda5033_20250421033826\";s:8:\"NameHash\";s:60:\"20250226_sapientus_black_8190aff268a3ddda5033_20250421033826\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:70:\"20250226_sapientus_black_8190aff268a3ddda5033_20250421033826_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"20.8\";s:6:\"WPUser\";s:16:\"sapientus_author\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:72:\"20250226_sapientus_black_8190aff268a3ddda5033_20250421033826_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:44:\"/home/slklwimy/public_html/staging/sapientus\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:2059;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:10929;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Size\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-04-21 03:38:26\";s:7:\"Version\";s:8:\"1.5.11.2\";s:9:\"VersionWP\";s:3:\"6.8\";s:9:\"VersionDB\";s:6:\"5.7.43\";s:10:\"VersionPHP\";s:6:\"8.2.28\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:24:\"20250226_sapientus_black\";s:4:\"Hash\";s:35:\"8190aff268a3ddda5033_20250421033826\";s:8:\"NameHash\";s:60:\"20250226_sapientus_black_8190aff268a3ddda5033_20250421033826\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:78:\"20250226_sapientus_black_8190aff268a3ddda5033_20250421033826_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:58:\"/home/slklwimy/public_html/staging/sapientus/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:73:\"20250226_sapientus_black_8190aff268a3ddda5033_20250421033826_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:150:\"/home/slklwimy/public_html/staging/sapientus/wp-content/backups-dup-lite/tmp/20250226_sapientus_black_8190aff268a3ddda5033_20250421033826_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:53:\"/home/slklwimy/public_html/staging/sapientus/wp-admin\";i:1;s:56:\"/home/slklwimy/public_html/staging/sapientus/wp-includes\";i:2;s:65:\"/home/slklwimy/public_html/staging/sapientus/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:44:\"/home/slklwimy/public_html/staging/sapientus\";i:1;s:44:\"/home/slklwimy/public_html/staging/sapientus\";i:2;s:55:\"/home/slklwimy/public_html/staging/sapientus/wp-content\";i:3;s:63:\"/home/slklwimy/public_html/staging/sapientus/wp-content/uploads\";i:4;s:63:\"/home/slklwimy/public_html/staging/sapientus/wp-content/plugins\";i:5;s:66:\"/home/slklwimy/public_html/staging/sapientus/wp-content/mu-plugins\";i:6;s:62:\"/home/slklwimy/public_html/staging/sapientus/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:76:\"/home/slklwimy/public_html/staging/sapientus/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}");

/* INSERT TABLE DATA: wpbq_e_events */
INSERT INTO `wpbq_e_events` VALUES("1", "{\"event\":\"modal load\",\"version\":\"\",\"details\":\"{\\\"placement\\\":\\\"Onboarding wizard\\\",\\\"step\\\":\\\"account\\\",\\\"user_state\\\":\\\"anon\\\"}\",\"ts\":\"2025-02-20T17:15:43.421-08:00\"}", "2025-02-20 17:15:43");

/* INSERT TABLE DATA: wpbq_loginizer_logs */
INSERT INTO `wpbq_loginizer_logs` VALUES("sapientus_staging", "1745206650", "1", "0", "112.201.162.250", "https://slk.lwi.mybluehost.me/staging/sapientus/wp-login.php");

/* INSERT TABLE DATA: wpbq_options */
INSERT INTO `wpbq_options` VALUES("1", "cron", "a:19:{i:1745208390;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1745226387;a:2:{s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1745226390;a:2:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1745226391;a:1:{s:31:\"softaculous_pro_ai_history_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1745226394;a:1:{s:39:\"check_plugin_updates-loginizer-security\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1745226395;a:3:{s:31:\"check_plugin_updates-gosmtp-pro\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:32:\"check_plugin_updates-siteseo-pro\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:28:\"check_plugin_updates-siteseo\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1745226396;a:1:{s:33:\"check_plugin_updates-backuply-pro\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1745226409;a:2:{s:34:\"check_plugin_updates-pagelayer-pro\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:36:\"check_plugin_updates-speedycache-pro\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1745226418;a:1:{s:36:\"check_plugin_updates-softaculous-pro\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1745226428;a:4:{s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:18:\"backuply_clean_tmp\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:14:\"backuply_daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1745226939;a:1:{s:28:\"elementor/tracker/send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1745227169;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1745229166;a:1:{s:22:\"wpwh_daily_maintenance\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1745244000;a:1:{s:29:\"duplicator_email_summary_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1745459569;a:1:{s:27:\"acf_update_site_health_data\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1745485992;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1745571987;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1745573903;a:1:{s:30:\"duplicator_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}", "on");
INSERT INTO `wpbq_options` VALUES("2", "siteurl", "https://slk.lwi.mybluehost.me/staging/sapientus", "on");
INSERT INTO `wpbq_options` VALUES("3", "home", "https://slk.lwi.mybluehost.me/staging/sapientus", "on");
INSERT INTO `wpbq_options` VALUES("4", "blogname", "Sapientus", "on");
INSERT INTO `wpbq_options` VALUES("5", "blogdescription", "", "on");
INSERT INTO `wpbq_options` VALUES("6", "users_can_register", "0", "on");
INSERT INTO `wpbq_options` VALUES("7", "admin_email", "admin@slk.lwi.mybluehost.me", "on");
INSERT INTO `wpbq_options` VALUES("8", "start_of_week", "1", "on");
INSERT INTO `wpbq_options` VALUES("9", "use_balanceTags", "0", "on");
INSERT INTO `wpbq_options` VALUES("10", "use_smilies", "1", "on");
INSERT INTO `wpbq_options` VALUES("11", "require_name_email", "1", "on");
INSERT INTO `wpbq_options` VALUES("12", "comments_notify", "1", "on");
INSERT INTO `wpbq_options` VALUES("13", "posts_per_rss", "3", "on");
INSERT INTO `wpbq_options` VALUES("14", "rss_use_excerpt", "0", "on");
INSERT INTO `wpbq_options` VALUES("15", "mailserver_url", "mail.example.com", "on");
INSERT INTO `wpbq_options` VALUES("16", "mailserver_login", "login@example.com", "on");
INSERT INTO `wpbq_options` VALUES("17", "mailserver_pass", "", "on");
INSERT INTO `wpbq_options` VALUES("18", "mailserver_port", "110", "on");
INSERT INTO `wpbq_options` VALUES("19", "default_category", "1", "on");
INSERT INTO `wpbq_options` VALUES("20", "default_comment_status", "open", "on");
INSERT INTO `wpbq_options` VALUES("21", "default_ping_status", "open", "on");
INSERT INTO `wpbq_options` VALUES("22", "default_pingback_flag", "1", "on");
INSERT INTO `wpbq_options` VALUES("23", "posts_per_page", "3", "on");
INSERT INTO `wpbq_options` VALUES("24", "date_format", "F j, Y", "on");
INSERT INTO `wpbq_options` VALUES("25", "time_format", "g:i a", "on");
INSERT INTO `wpbq_options` VALUES("26", "links_updated_date_format", "F j, Y g:i a", "on");
INSERT INTO `wpbq_options` VALUES("27", "comment_moderation", "0", "on");
INSERT INTO `wpbq_options` VALUES("28", "moderation_notify", "1", "on");
INSERT INTO `wpbq_options` VALUES("29", "permalink_structure", "/%postname%/", "on");
INSERT INTO `wpbq_options` VALUES("30", "rewrite_rules", "a:151:{s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:15:\"^sitemaps\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:15:\"^sitemaps\\.xml$\";s:30:\"index.php?sitemap_type=general\";s:12:\"^author.xml$\";s:29:\"index.php?sitemap_type=author\";s:28:\"^media-sitemap([0-9]+)?.xml$\";s:46:\"index.php?sitemap_type=media&paged=$matches[1]\";s:28:\"^post-sitemap([0-9]+)?\\.xml$\";s:45:\"index.php?sitemap_type=post&paged=$matches[1]\";s:28:\"^page-sitemap([0-9]+)?\\.xml$\";s:45:\"index.php?sitemap_type=page&paged=$matches[1]\";s:32:\"^category-sitemap([0-9]+)?\\.xml$\";s:49:\"index.php?sitemap_type=category&paged=$matches[1]\";s:32:\"^post_tag-sitemap([0-9]+)?\\.xml$\";s:49:\"index.php?sitemap_type=post_tag&paged=$matches[1]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:46:\"e-floating-buttons/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:56:\"e-floating-buttons/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:76:\"e-floating-buttons/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:71:\"e-floating-buttons/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:71:\"e-floating-buttons/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:52:\"e-floating-buttons/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:35:\"e-floating-buttons/([^/]+)/embed/?$\";s:51:\"index.php?e-floating-buttons=$matches[1]&embed=true\";s:39:\"e-floating-buttons/([^/]+)/trackback/?$\";s:45:\"index.php?e-floating-buttons=$matches[1]&tb=1\";s:47:\"e-floating-buttons/([^/]+)/page/?([0-9]{1,})/?$\";s:58:\"index.php?e-floating-buttons=$matches[1]&paged=$matches[2]\";s:54:\"e-floating-buttons/([^/]+)/comment-page-([0-9]{1,})/?$\";s:58:\"index.php?e-floating-buttons=$matches[1]&cpage=$matches[2]\";s:43:\"e-floating-buttons/([^/]+)(?:/([0-9]+))?/?$\";s:57:\"index.php?e-floating-buttons=$matches[1]&page=$matches[2]\";s:35:\"e-floating-buttons/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"e-floating-buttons/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"e-floating-buttons/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"e-floating-buttons/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"e-floating-buttons/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"e-floating-buttons/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:34:\"career/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:44:\"career/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:64:\"career/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"career/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"career/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:40:\"career/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:23:\"career/([^/]+)/embed/?$\";s:39:\"index.php?career=$matches[1]&embed=true\";s:27:\"career/([^/]+)/trackback/?$\";s:33:\"index.php?career=$matches[1]&tb=1\";s:35:\"career/([^/]+)/page/?([0-9]{1,})/?$\";s:46:\"index.php?career=$matches[1]&paged=$matches[2]\";s:42:\"career/([^/]+)/comment-page-([0-9]{1,})/?$\";s:46:\"index.php?career=$matches[1]&cpage=$matches[2]\";s:31:\"career/([^/]+)(?:/([0-9]+))?/?$\";s:45:\"index.php?career=$matches[1]&page=$matches[2]\";s:23:\"career/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:33:\"career/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:53:\"career/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:48:\"career/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:48:\"career/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:29:\"career/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:37:\"news-post/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:47:\"news-post/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:67:\"news-post/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"news-post/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"news-post/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:43:\"news-post/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:26:\"news-post/([^/]+)/embed/?$\";s:37:\"index.php?news=$matches[1]&embed=true\";s:30:\"news-post/([^/]+)/trackback/?$\";s:31:\"index.php?news=$matches[1]&tb=1\";s:38:\"news-post/([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?news=$matches[1]&paged=$matches[2]\";s:45:\"news-post/([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?news=$matches[1]&cpage=$matches[2]\";s:34:\"news-post/([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?news=$matches[1]&page=$matches[2]\";s:26:\"news-post/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:36:\"news-post/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:56:\"news-post/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"news-post/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"news-post/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:32:\"news-post/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:40:\"index.php?&page_id=124&cpage=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}", "on");
INSERT INTO `wpbq_options` VALUES("31", "hack_file", "0", "on");
INSERT INTO `wpbq_options` VALUES("32", "blog_charset", "UTF-8", "on");
INSERT INTO `wpbq_options` VALUES("33", "moderation_keys", "", "off");
INSERT INTO `wpbq_options` VALUES("34", "active_plugins", "a:21:{i:0;s:30:\"advanced-custom-fields/acf.php\";i:1;s:29:\"backuply-pro/backuply-pro.php\";i:2;s:21:\"backuply/backuply.php\";i:3;s:47:\"custom-chatbot-widget/custom-chatbot-widget.php\";i:4;s:25:\"duplicator/duplicator.php\";i:5;s:31:\"elementor-pro/elementor-pro.php\";i:6;s:23:\"elementor/elementor.php\";i:7;s:65:\"essential-addons-for-elementor-lite/essential_adons_elementor.php\";i:8;s:25:\"gosmtp-pro/gosmtp-pro.php\";i:9;s:17:\"gosmtp/gosmtp.php\";i:10;s:41:\"loginizer-security/loginizer-security.php\";i:11;s:23:\"loginizer/loginizer.php\";i:12;s:31:\"pagelayer-pro/pagelayer-pro.php\";i:13;s:23:\"pagelayer/pagelayer.php\";i:14;s:27:\"siteseo-pro/siteseo-pro.php\";i:15;s:19:\"siteseo/siteseo.php\";i:16;s:35:\"softaculous-pro/softaculous-pro.php\";i:17;s:35:\"speedycache-pro/speedycache-pro.php\";i:18;s:27:\"speedycache/speedycache.php\";i:20;s:39:\"wp-file-manager/file_folder_manager.php\";i:21;s:27:\"wp-webhooks/wp-webhooks.php\";}", "on");
INSERT INTO `wpbq_options` VALUES("35", "category_base", "", "on");
INSERT INTO `wpbq_options` VALUES("36", "ping_sites", "http://rpc.pingomatic.com/", "on");
INSERT INTO `wpbq_options` VALUES("37", "comment_max_links", "2", "on");
INSERT INTO `wpbq_options` VALUES("38", "gmt_offset", "0", "on");
INSERT INTO `wpbq_options` VALUES("39", "default_email_category", "1", "on");
INSERT INTO `wpbq_options` VALUES("40", "recently_edited", "a:3:{i:0;s:92:\"/home/slklwimy/public_html/staging/sapientus/wp-content/themes/hello-elementor/functions.php\";i:2;s:88:\"/home/slklwimy/public_html/staging/sapientus/wp-content/themes/hello-elementor/style.css\";i:3;s:0:\"\";}", "off");
INSERT INTO `wpbq_options` VALUES("41", "template", "hello-elementor", "on");
INSERT INTO `wpbq_options` VALUES("42", "stylesheet", "hello-elementor", "on");
INSERT INTO `wpbq_options` VALUES("43", "comment_registration", "0", "on");
INSERT INTO `wpbq_options` VALUES("44", "html_type", "text/html", "on");
INSERT INTO `wpbq_options` VALUES("45", "use_trackback", "0", "on");
INSERT INTO `wpbq_options` VALUES("46", "default_role", "subscriber", "on");
INSERT INTO `wpbq_options` VALUES("47", "db_version", "58975", "on");
INSERT INTO `wpbq_options` VALUES("48", "uploads_use_yearmonth_folders", "1", "on");
INSERT INTO `wpbq_options` VALUES("49", "upload_path", "", "on");
INSERT INTO `wpbq_options` VALUES("50", "blog_public", "1", "on");
INSERT INTO `wpbq_options` VALUES("51", "default_link_category", "2", "on");
INSERT INTO `wpbq_options` VALUES("52", "show_on_front", "page", "on");
INSERT INTO `wpbq_options` VALUES("53", "tag_base", "", "on");
INSERT INTO `wpbq_options` VALUES("54", "show_avatars", "1", "on");
INSERT INTO `wpbq_options` VALUES("55", "avatar_rating", "G", "on");
INSERT INTO `wpbq_options` VALUES("56", "upload_url_path", "", "on");
INSERT INTO `wpbq_options` VALUES("57", "thumbnail_size_w", "150", "on");
INSERT INTO `wpbq_options` VALUES("58", "thumbnail_size_h", "150", "on");
INSERT INTO `wpbq_options` VALUES("59", "thumbnail_crop", "1", "on");
INSERT INTO `wpbq_options` VALUES("60", "medium_size_w", "300", "on");
INSERT INTO `wpbq_options` VALUES("61", "medium_size_h", "300", "on");
INSERT INTO `wpbq_options` VALUES("62", "avatar_default", "mystery", "on");
INSERT INTO `wpbq_options` VALUES("63", "large_size_w", "1024", "on");
INSERT INTO `wpbq_options` VALUES("64", "large_size_h", "1024", "on");
INSERT INTO `wpbq_options` VALUES("65", "image_default_link_type", "none", "on");
INSERT INTO `wpbq_options` VALUES("66", "image_default_size", "", "on");
INSERT INTO `wpbq_options` VALUES("67", "image_default_align", "", "on");
INSERT INTO `wpbq_options` VALUES("68", "close_comments_for_old_posts", "0", "on");
INSERT INTO `wpbq_options` VALUES("69", "close_comments_days_old", "14", "on");
INSERT INTO `wpbq_options` VALUES("70", "thread_comments", "1", "on");
INSERT INTO `wpbq_options` VALUES("71", "thread_comments_depth", "5", "on");
INSERT INTO `wpbq_options` VALUES("72", "page_comments", "0", "on");
INSERT INTO `wpbq_options` VALUES("73", "comments_per_page", "50", "on");
INSERT INTO `wpbq_options` VALUES("74", "default_comments_page", "newest", "on");
INSERT INTO `wpbq_options` VALUES("75", "comment_order", "asc", "on");
INSERT INTO `wpbq_options` VALUES("76", "sticky_posts", "a:0:{}", "on");
INSERT INTO `wpbq_options` VALUES("77", "widget_categories", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wpbq_options` VALUES("78", "widget_text", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wpbq_options` VALUES("79", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wpbq_options` VALUES("80", "uninstall_plugins", "a:6:{s:35:\"softaculous-pro/softaculous-pro.php\";s:30:\"softaculous_pro_uninstall_hook\";s:23:\"loginizer/loginizer.php\";s:22:\"loginizer_deactivation\";s:19:\"siteseo/siteseo.php\";s:27:\"\\SiteSEO\\Install::uninstall\";s:21:\"backuply/backuply.php\";s:21:\"backuply_deactivation\";s:27:\"speedycache/speedycache.php\";s:31:\"\\SpeedyCache\\Install::uninstall\";s:23:\"elementor/elementor.php\";a:2:{i:0;s:21:\"Elementor\\Maintenance\";i:1;s:9:\"uninstall\";}}", "off");
INSERT INTO `wpbq_options` VALUES("81", "timezone_string", "", "on");
INSERT INTO `wpbq_options` VALUES("82", "page_for_posts", "613", "on");
INSERT INTO `wpbq_options` VALUES("83", "page_on_front", "124", "on");
INSERT INTO `wpbq_options` VALUES("84", "default_post_format", "0", "on");
INSERT INTO `wpbq_options` VALUES("85", "link_manager_enabled", "0", "on");
INSERT INTO `wpbq_options` VALUES("86", "finished_splitting_shared_terms", "1", "on");
INSERT INTO `wpbq_options` VALUES("87", "site_icon", "491", "on");
INSERT INTO `wpbq_options` VALUES("88", "medium_large_size_w", "768", "on");
INSERT INTO `wpbq_options` VALUES("89", "medium_large_size_h", "0", "on");
INSERT INTO `wpbq_options` VALUES("90", "wp_page_for_privacy_policy", "3", "on");
INSERT INTO `wpbq_options` VALUES("91", "show_comments_cookies_opt_in", "1", "on");
INSERT INTO `wpbq_options` VALUES("92", "admin_email_lifespan", "1755594387", "on");
INSERT INTO `wpbq_options` VALUES("93", "disallowed_keys", "", "off");
INSERT INTO `wpbq_options` VALUES("94", "comment_previously_approved", "1", "on");
INSERT INTO `wpbq_options` VALUES("95", "auto_plugin_theme_update_emails", "a:0:{}", "off");
INSERT INTO `wpbq_options` VALUES("96", "auto_update_core_dev", "enabled", "on");
INSERT INTO `wpbq_options` VALUES("97", "auto_update_core_minor", "enabled", "on");
INSERT INTO `wpbq_options` VALUES("98", "auto_update_core_major", "enabled", "on");
INSERT INTO `wpbq_options` VALUES("99", "wp_force_deactivated_plugins", "a:0:{}", "on");
INSERT INTO `wpbq_options` VALUES("100", "wp_attachment_pages_enabled", "0", "on");
INSERT INTO `wpbq_options` VALUES("101", "initial_db_version", "58975", "on");
INSERT INTO `wpbq_options` VALUES("102", "wpbq_user_roles", "a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:69:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:14:\"siteseo_manage\";b:1;s:26:\"create_notes_elementor-pro\";b:1;s:24:\"edit_notes_elementor-pro\";b:1;s:26:\"delete_notes_elementor-pro\";b:1;s:24:\"read_notes_elementor-pro\";b:1;s:31:\"edit_others_notes_elementor-pro\";b:1;s:33:\"delete_others_notes_elementor-pro\";b:1;s:39:\"read_others_private_notes_elementor-pro\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}", "on");
INSERT INTO `wpbq_options` VALUES("103", "fresh_site", "0", "off");
INSERT INTO `wpbq_options` VALUES("104", "user_count", "1", "off");
INSERT INTO `wpbq_options` VALUES("105", "widget_block", "a:6:{i:2;a:1:{s:7:\"content\";s:19:\"<!-- wp:search /-->\";}i:3;a:1:{s:7:\"content\";s:154:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Posts</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->\";}i:4;a:1:{s:7:\"content\";s:227:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Comments</h2><!-- /wp:heading --><!-- wp:latest-comments {\"displayAvatar\":false,\"displayDate\":false,\"displayExcerpt\":false} /--></div><!-- /wp:group -->\";}i:5;a:1:{s:7:\"content\";s:146:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Archives</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->\";}i:6;a:1:{s:7:\"content\";s:150:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Categories</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->\";}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wpbq_options` VALUES("106", "sidebars_widgets", "a:2:{s:19:\"wp_inactive_widgets\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}s:13:\"array_version\";i:3;}", "auto");
INSERT INTO `wpbq_options` VALUES("107", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wpbq_options` VALUES("108", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wpbq_options` VALUES("109", "widget_archives", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wpbq_options` VALUES("110", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wpbq_options` VALUES("111", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wpbq_options` VALUES("112", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wpbq_options` VALUES("113", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wpbq_options` VALUES("114", "widget_meta", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wpbq_options` VALUES("115", "widget_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wpbq_options` VALUES("116", "widget_recent-posts", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wpbq_options` VALUES("117", "widget_recent-comments", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wpbq_options` VALUES("118", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wpbq_options` VALUES("119", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wpbq_options` VALUES("120", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wpbq_options` VALUES("121", "recovery_keys", "a:0:{}", "off");
INSERT INTO `wpbq_options` VALUES("122", "theme_mods_twentytwentyfive", "a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1740043149;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}}}}", "off");
INSERT INTO `wpbq_options` VALUES("123", "_transient_wp_core_block_css_files", "a:2:{s:7:\"version\";s:5:\"6.7.2\";s:5:\"files\";a:540:{i:0;s:23:\"archives/editor-rtl.css\";i:1;s:27:\"archives/editor-rtl.min.css\";i:2;s:19:\"archives/editor.css\";i:3;s:23:\"archives/editor.min.css\";i:4;s:22:\"archives/style-rtl.css\";i:5;s:26:\"archives/style-rtl.min.css\";i:6;s:18:\"archives/style.css\";i:7;s:22:\"archives/style.min.css\";i:8;s:20:\"audio/editor-rtl.css\";i:9;s:24:\"audio/editor-rtl.min.css\";i:10;s:16:\"audio/editor.css\";i:11;s:20:\"audio/editor.min.css\";i:12;s:19:\"audio/style-rtl.css\";i:13;s:23:\"audio/style-rtl.min.css\";i:14;s:15:\"audio/style.css\";i:15;s:19:\"audio/style.min.css\";i:16;s:19:\"audio/theme-rtl.css\";i:17;s:23:\"audio/theme-rtl.min.css\";i:18;s:15:\"audio/theme.css\";i:19;s:19:\"audio/theme.min.css\";i:20;s:21:\"avatar/editor-rtl.css\";i:21;s:25:\"avatar/editor-rtl.min.css\";i:22;s:17:\"avatar/editor.css\";i:23;s:21:\"avatar/editor.min.css\";i:24;s:20:\"avatar/style-rtl.css\";i:25;s:24:\"avatar/style-rtl.min.css\";i:26;s:16:\"avatar/style.css\";i:27;s:20:\"avatar/style.min.css\";i:28;s:21:\"button/editor-rtl.css\";i:29;s:25:\"button/editor-rtl.min.css\";i:30;s:17:\"button/editor.css\";i:31;s:21:\"button/editor.min.css\";i:32;s:20:\"button/style-rtl.css\";i:33;s:24:\"button/style-rtl.min.css\";i:34;s:16:\"button/style.css\";i:35;s:20:\"button/style.min.css\";i:36;s:22:\"buttons/editor-rtl.css\";i:37;s:26:\"buttons/editor-rtl.min.css\";i:38;s:18:\"buttons/editor.css\";i:39;s:22:\"buttons/editor.min.css\";i:40;s:21:\"buttons/style-rtl.css\";i:41;s:25:\"buttons/style-rtl.min.css\";i:42;s:17:\"buttons/style.css\";i:43;s:21:\"buttons/style.min.css\";i:44;s:22:\"calendar/style-rtl.css\";i:45;s:26:\"calendar/style-rtl.min.css\";i:46;s:18:\"calendar/style.css\";i:47;s:22:\"calendar/style.min.css\";i:48;s:25:\"categories/editor-rtl.css\";i:49;s:29:\"categories/editor-rtl.min.css\";i:50;s:21:\"categories/editor.css\";i:51;s:25:\"categories/editor.min.css\";i:52;s:24:\"categories/style-rtl.css\";i:53;s:28:\"categories/style-rtl.min.css\";i:54;s:20:\"categories/style.css\";i:55;s:24:\"categories/style.min.css\";i:56;s:19:\"code/editor-rtl.css\";i:57;s:23:\"code/editor-rtl.min.css\";i:58;s:15:\"code/editor.css\";i:59;s:19:\"code/editor.min.css\";i:60;s:18:\"code/style-rtl.css\";i:61;s:22:\"code/style-rtl.min.css\";i:62;s:14:\"code/style.css\";i:63;s:18:\"code/style.min.css\";i:64;s:18:\"code/theme-rtl.css\";i:65;s:22:\"code/theme-rtl.min.css\";i:66;s:14:\"code/theme.css\";i:67;s:18:\"code/theme.min.css\";i:68;s:22:\"columns/editor-rtl.css\";i:69;s:26:\"columns/editor-rtl.min.css\";i:70;s:18:\"columns/editor.css\";i:71;s:22:\"columns/editor.min.css\";i:72;s:21:\"columns/style-rtl.css\";i:73;s:25:\"columns/style-rtl.min.css\";i:74;s:17:\"columns/style.css\";i:75;s:21:\"columns/style.min.css\";i:76;s:33:\"comment-author-name/style-rtl.css\";i:77;s:37:\"comment-author-name/style-rtl.min.css\";i:78;s:29:\"comment-author-name/style.css\";i:79;s:33:\"comment-author-name/style.min.css\";i:80;s:29:\"comment-content/style-rtl.css\";i:81;s:33:\"comment-content/style-rtl.min.css\";i:82;s:25:\"comment-content/style.css\";i:83;s:29:\"comment-content/style.min.css\";i:84;s:26:\"comment-date/style-rtl.css\";i:85;s:30:\"comment-date/style-rtl.min.css\";i:86;s:22:\"comment-date/style.css\";i:87;s:26:\"comment-date/style.min.css\";i:88;s:31:\"comment-edit-link/style-rtl.css\";i:89;s:35:\"comment-edit-link/style-rtl.min.css\";i:90;s:27:\"comment-edit-link/style.css\";i:91;s:31:\"comment-edit-link/style.min.css\";i:92;s:32:\"comment-reply-link/style-rtl.css\";i:93;s:36:\"comment-reply-link/style-rtl.min.css\";i:94;s:28:\"comment-reply-link/style.css\";i:95;s:32:\"comment-reply-link/style.min.css\";i:96;s:30:\"comment-template/style-rtl.css\";i:97;s:34:\"comment-template/style-rtl.min.css\";i:98;s:26:\"comment-template/style.css\";i:99;s:30:\"comment-template/style.min.css\";i:100;s:42:\"comments-pagination-numbers/editor-rtl.css\";i:101;s:46:\"comments-pagination-numbers/editor-rtl.min.css\";i:102;s:38:\"comments-pagination-numbers/editor.css\";i:103;s:42:\"comments-pagination-numbers/editor.min.css\";i:104;s:34:\"comments-pagination/editor-rtl.css\";i:105;s:38:\"comments-pagination/editor-rtl.min.css\";i:106;s:30:\"comments-pagination/editor.css\";i:107;s:34:\"comments-pagination/editor.min.css\";i:108;s:33:\"comments-pagination/style-rtl.css\";i:109;s:37:\"comments-pagination/style-rtl.min.css\";i:110;s:29:\"comments-pagination/style.css\";i:111;s:33:\"comments-pagination/style.min.css\";i:112;s:29:\"comments-title/editor-rtl.css\";i:113;s:33:\"comments-title/editor-rtl.min.css\";i:114;s:25:\"comments-title/editor.css\";i:115;s:29:\"comments-title/editor.min.css\";i:116;s:23:\"comments/editor-rtl.css\";i:117;s:27:\"comments/editor-rtl.min.css\";i:118;s:19:\"comments/editor.css\";i:119;s:23:\"comments/editor.min.css\";i:120;s:22:\"comments/style-rtl.css\";i:121;s:26:\"comments/style-rtl.min.css\";i:122;s:18:\"comments/style.css\";i:123;s:22:\"comments/style.min.css\";i:124;s:20:\"cover/editor-rtl.css\";i:125;s:24:\"cover/editor-rtl.min.css\";i:126;s:16:\"cover/editor.css\";i:127;s:20:\"cover/editor.min.css\";i:128;s:19:\"cover/style-rtl.css\";i:129;s:23:\"cover/style-rtl.min.css\";i:130;s:15:\"cover/style.css\";i:131;s:19:\"cover/style.min.css\";i:132;s:22:\"details/editor-rtl.css\";i:133;s:26:\"details/editor-rtl.min.css\";i:134;s:18:\"details/editor.css\";i:135;s:22:\"details/editor.min.css\";i:136;s:21:\"details/style-rtl.css\";i:137;s:25:\"details/style-rtl.min.css\";i:138;s:17:\"details/style.css\";i:139;s:21:\"details/style.min.css\";i:140;s:20:\"embed/editor-rtl.css\";i:141;s:24:\"embed/editor-rtl.min.css\";i:142;s:16:\"embed/editor.css\";i:143;s:20:\"embed/editor.min.css\";i:144;s:19:\"embed/style-rtl.css\";i:145;s:23:\"embed/style-rtl.min.css\";i:146;s:15:\"embed/style.css\";i:147;s:19:\"embed/style.min.css\";i:148;s:19:\"embed/theme-rtl.css\";i:149;s:23:\"embed/theme-rtl.min.css\";i:150;s:15:\"embed/theme.css\";i:151;s:19:\"embed/theme.min.css\";i:152;s:19:\"file/editor-rtl.css\";i:153;s:23:\"file/editor-rtl.min.css\";i:154;s:15:\"file/editor.css\";i:155;s:19:\"file/editor.min.css\";i:156;s:18:\"file/style-rtl.css\";i:157;s:22:\"file/style-rtl.min.css\";i:158;s:14:\"file/style.css\";i:159;s:18:\"file/style.min.css\";i:160;s:23:\"footnotes/style-rtl.css\";i:161;s:27:\"footnotes/style-rtl.min.css\";i:162;s:19:\"footnotes/style.css\";i:163;s:23:\"footnotes/style.min.css\";i:164;s:23:\"freeform/editor-rtl.css\";i:165;s:27:\"freeform/editor-rtl.min.css\";i:166;s:19:\"freeform/editor.css\";i:167;s:23:\"freeform/editor.min.css\";i:168;s:22:\"gallery/editor-rtl.css\";i:169;s:26:\"gallery/editor-rtl.min.css\";i:170;s:18:\"gallery/editor.css\";i:171;s:22:\"gallery/editor.min.css\";i:172;s:21:\"gallery/style-rtl.css\";i:173;s:25:\"gallery/style-rtl.min.css\";i:174;s:17:\"gallery/style.css\";i:175;s:21:\"gallery/style.min.css\";i:176;s:21:\"gallery/theme-rtl.css\";i:177;s:25:\"gallery/theme-rtl.min.css\";i:178;s:17:\"gallery/theme.css\";i:179;s:21:\"gallery/theme.min.css\";i:180;s:20:\"group/editor-rtl.css\";i:181;s:24:\"group/editor-rtl.min.css\";i:182;s:16:\"group/editor.css\";i:183;s:20:\"group/editor.min.css\";i:184;s:19:\"group/style-rtl.css\";i:185;s:23:\"group/style-rtl.min.css\";i:186;s:15:\"group/style.css\";i:187;s:19:\"group/style.min.css\";i:188;s:19:\"group/theme-rtl.css\";i:189;s:23:\"group/theme-rtl.min.css\";i:190;s:15:\"group/theme.css\";i:191;s:19:\"group/theme.min.css\";i:192;s:21:\"heading/style-rtl.css\";i:193;s:25:\"heading/style-rtl.min.css\";i:194;s:17:\"heading/style.css\";i:195;s:21:\"heading/style.min.css\";i:196;s:19:\"html/editor-rtl.css\";i:197;s:23:\"html/editor-rtl.min.css\";i:198;s:15:\"html/editor.css\";i:199;s:19:\"html/editor.min.css\";i:200;s:20:\"image/editor-rtl.css\";i:201;s:24:\"image/editor-rtl.min.css\";i:202;s:16:\"image/editor.css\";i:203;s:20:\"image/editor.min.css\";i:204;s:19:\"image/style-rtl.css\";i:205;s:23:\"image/style-rtl.min.css\";i:206;s:15:\"image/style.css\";i:207;s:19:\"image/style.min.css\";i:208;s:19:\"image/theme-rtl.css\";i:209;s:23:\"image/theme-rtl.min.css\";i:210;s:15:\"image/theme.css\";i:211;s:19:\"image/theme.min.css\";i:212;s:29:\"latest-comments/style-rtl.css\";i:213;s:33:\"latest-comments/style-rtl.min.css\";i:214;s:25:\"latest-comments/style.css\";i:215;s:29:\"latest-comments/style.min.css\";i:216;s:27:\"latest-posts/editor-rtl.css\";i:217;s:31:\"latest-posts/editor-rtl.min.css\";i:218;s:23:\"latest-posts/editor.css\";i:219;s:27:\"latest-posts/editor.min.css\";i:220;s:26:\"latest-posts/style-rtl.css\";i:221;s:30:\"latest-posts/style-rtl.min.css\";i:222;s:22:\"latest-posts/style.css\";i:223;s:26:\"latest-posts/style.min.css\";i:224;s:18:\"list/style-rtl.css\";i:225;s:22:\"list/style-rtl.min.css\";i:226;s:14:\"list/style.css\";i:227;s:18:\"list/style.min.css\";i:228;s:22:\"loginout/style-rtl.css\";i:229;s:26:\"loginout/style-rtl.min.css\";i:230;s:18:\"loginout/style.css\";i:231;s:22:\"loginout/style.min.css\";i:232;s:25:\"media-text/editor-rtl.css\";i:233;s:29:\"media-text/editor-rtl.min.css\";i:234;s:21:\"media-text/editor.css\";i:235;s:25:\"media-text/editor.min.css\";i:236;s:24:\"media-text/style-rtl.css\";i:237;s:28:\"media-text/style-rtl.min.css\";i:238;s:20:\"media-text/style.css\";i:239;s:24:\"media-text/style.min.css\";i:240;s:19:\"more/editor-rtl.css\";i:241;s:23:\"more/editor-rtl.min.css\";i:242;s:15:\"more/editor.css\";i:243;s:19:\"more/editor.min.css\";i:244;s:30:\"navigation-link/editor-rtl.css\";i:245;s:34:\"navigation-link/editor-rtl.min.css\";i:246;s:26:\"navigation-link/editor.css\";i:247;s:30:\"navigation-link/editor.min.css\";i:248;s:29:\"navigation-link/style-rtl.css\";i:249;s:33:\"navigation-link/style-rtl.min.css\";i:250;s:25:\"navigation-link/style.css\";i:251;s:29:\"navigation-link/style.min.css\";i:252;s:33:\"navigation-submenu/editor-rtl.css\";i:253;s:37:\"navigation-submenu/editor-rtl.min.css\";i:254;s:29:\"navigation-submenu/editor.css\";i:255;s:33:\"navigation-submenu/editor.min.css\";i:256;s:25:\"navigation/editor-rtl.css\";i:257;s:29:\"navigation/editor-rtl.min.css\";i:258;s:21:\"navigation/editor.css\";i:259;s:25:\"navigation/editor.min.css\";i:260;s:24:\"navigation/style-rtl.css\";i:261;s:28:\"navigation/style-rtl.min.css\";i:262;s:20:\"navigation/style.css\";i:263;s:24:\"navigation/style.min.css\";i:264;s:23:\"nextpage/editor-rtl.css\";i:265;s:27:\"nextpage/editor-rtl.min.css\";i:266;s:19:\"nextpage/editor.css\";i:267;s:23:\"nextpage/editor.min.css\";i:268;s:24:\"page-list/editor-rtl.css\";i:269;s:28:\"page-list/editor-rtl.min.css\";i:270;s:20:\"page-list/editor.css\";i:271;s:24:\"page-list/editor.min.css\";i:272;s:23:\"page-list/style-rtl.css\";i:273;s:27:\"page-list/style-rtl.min.css\";i:274;s:19:\"page-list/style.css\";i:275;s:23:\"page-list/style.min.css\";i:276;s:24:\"paragraph/editor-rtl.css\";i:277;s:28:\"paragraph/editor-rtl.min.css\";i:278;s:20:\"paragraph/editor.css\";i:279;s:24:\"paragraph/editor.min.css\";i:280;s:23:\"paragraph/style-rtl.css\";i:281;s:27:\"paragraph/style-rtl.min.css\";i:282;s:19:\"paragraph/style.css\";i:283;s:23:\"paragraph/style.min.css\";i:284;s:35:\"post-author-biography/style-rtl.css\";i:285;s:39:\"post-author-biography/style-rtl.min.css\";i:286;s:31:\"post-author-biography/style.css\";i:287;s:35:\"post-author-biography/style.min.css\";i:288;s:30:\"post-author-name/style-rtl.css\";i:289;s:34:\"post-author-name/style-rtl.min.css\";i:290;s:26:\"post-author-name/style.css\";i:291;s:30:\"post-author-name/style.min.css\";i:292;s:26:\"post-author/editor-rtl.css\";i:293;s:30:\"post-author/editor-rtl.min.css\";i:294;s:22:\"post-author/editor.css\";i:295;s:26:\"post-author/editor.min.css\";i:296;s:25:\"post-author/style-rtl.css\";i:297;s:29:\"post-author/style-rtl.min.css\";i:298;s:21:\"post-author/style.css\";i:299;s:25:\"post-author/style.min.css\";i:300;s:33:\"post-comments-form/editor-rtl.css\";i:301;s:37:\"post-comments-form/editor-rtl.min.css\";i:302;s:29:\"post-comments-form/editor.css\";i:303;s:33:\"post-comments-form/editor.min.css\";i:304;s:32:\"post-comments-form/style-rtl.css\";i:305;s:36:\"post-comments-form/style-rtl.min.css\";i:306;s:28:\"post-comments-form/style.css\";i:307;s:32:\"post-comments-form/style.min.css\";i:308;s:27:\"post-content/editor-rtl.css\";i:309;s:31:\"post-content/editor-rtl.min.css\";i:310;s:23:\"post-content/editor.css\";i:311;s:27:\"post-content/editor.min.css\";i:312;s:26:\"post-content/style-rtl.css\";i:313;s:30:\"post-content/style-rtl.min.css\";i:314;s:22:\"post-content/style.css\";i:315;s:26:\"post-content/style.min.css\";i:316;s:23:\"post-date/style-rtl.css\";i:317;s:27:\"post-date/style-rtl.min.css\";i:318;s:19:\"post-date/style.css\";i:319;s:23:\"post-date/style.min.css\";i:320;s:27:\"post-excerpt/editor-rtl.css\";i:321;s:31:\"post-excerpt/editor-rtl.min.css\";i:322;s:23:\"post-excerpt/editor.css\";i:323;s:27:\"post-excerpt/editor.min.css\";i:324;s:26:\"post-excerpt/style-rtl.css\";i:325;s:30:\"post-excerpt/style-rtl.min.css\";i:326;s:22:\"post-excerpt/style.css\";i:327;s:26:\"post-excerpt/style.min.css\";i:328;s:34:\"post-featured-image/editor-rtl.css\";i:329;s:38:\"post-featured-image/editor-rtl.min.css\";i:330;s:30:\"post-featured-image/editor.css\";i:331;s:34:\"post-featured-image/editor.min.css\";i:332;s:33:\"post-featured-image/style-rtl.css\";i:333;s:37:\"post-featured-image/style-rtl.min.css\";i:334;s:29:\"post-featured-image/style.css\";i:335;s:33:\"post-featured-image/style.min.css\";i:336;s:34:\"post-navigation-link/style-rtl.css\";i:337;s:38:\"post-navigation-link/style-rtl.min.css\";i:338;s:30:\"post-navigation-link/style.css\";i:339;s:34:\"post-navigation-link/style.min.css\";i:340;s:28:\"post-template/editor-rtl.css\";i:341;s:32:\"post-template/editor-rtl.min.css\";i:342;s:24:\"post-template/editor.css\";i:343;s:28:\"post-template/editor.min.css\";i:344;s:27:\"post-template/style-rtl.css\";i:345;s:31:\"post-template/style-rtl.min.css\";i:346;s:23:\"post-template/style.css\";i:347;s:27:\"post-template/style.min.css\";i:348;s:24:\"post-terms/style-rtl.css\";i:349;s:28:\"post-terms/style-rtl.min.css\";i:350;s:20:\"post-terms/style.css\";i:351;s:24:\"post-terms/style.min.css\";i:352;s:24:\"post-title/style-rtl.css\";i:353;s:28:\"post-title/style-rtl.min.css\";i:354;s:20:\"post-title/style.css\";i:355;s:24:\"post-title/style.min.css\";i:356;s:26:\"preformatted/style-rtl.css\";i:357;s:30:\"preformatted/style-rtl.min.css\";i:358;s:22:\"preformatted/style.css\";i:359;s:26:\"preformatted/style.min.css\";i:360;s:24:\"pullquote/editor-rtl.css\";i:361;s:28:\"pullquote/editor-rtl.min.css\";i:362;s:20:\"pullquote/editor.css\";i:363;s:24:\"pullquote/editor.min.css\";i:364;s:23:\"pullquote/style-rtl.css\";i:365;s:27:\"pullquote/style-rtl.min.css\";i:366;s:19:\"pullquote/style.css\";i:367;s:23:\"pullquote/style.min.css\";i:368;s:23:\"pullquote/theme-rtl.css\";i:369;s:27:\"pullquote/theme-rtl.min.css\";i:370;s:19:\"pullquote/theme.css\";i:371;s:23:\"pullquote/theme.min.css\";i:372;s:39:\"query-pagination-numbers/editor-rtl.css\";i:373;s:43:\"query-pagination-numbers/editor-rtl.min.css\";i:374;s:35:\"query-pagination-numbers/editor.css\";i:375;s:39:\"query-pagination-numbers/editor.min.css\";i:376;s:31:\"query-pagination/editor-rtl.css\";i:377;s:35:\"query-pagination/editor-rtl.min.css\";i:378;s:27:\"query-pagination/editor.css\";i:379;s:31:\"query-pagination/editor.min.css\";i:380;s:30:\"query-pagination/style-rtl.css\";i:381;s:34:\"query-pagination/style-rtl.min.css\";i:382;s:26:\"query-pagination/style.css\";i:383;s:30:\"query-pagination/style.min.css\";i:384;s:25:\"query-title/style-rtl.css\";i:385;s:29:\"query-title/style-rtl.min.css\";i:386;s:21:\"query-title/style.css\";i:387;s:25:\"query-title/style.min.css\";i:388;s:20:\"query/editor-rtl.css\";i:389;s:24:\"query/editor-rtl.min.css\";i:390;s:16:\"query/editor.css\";i:391;s:20:\"query/editor.min.css\";i:392;s:19:\"quote/style-rtl.css\";i:393;s:23:\"quote/style-rtl.min.css\";i:394;s:15:\"quote/style.css\";i:395;s:19:\"quote/style.min.css\";i:396;s:19:\"quote/theme-rtl.css\";i:397;s:23:\"quote/theme-rtl.min.css\";i:398;s:15:\"quote/theme.css\";i:399;s:19:\"quote/theme.min.css\";i:400;s:23:\"read-more/style-rtl.css\";i:401;s:27:\"read-more/style-rtl.min.css\";i:402;s:19:\"read-more/style.css\";i:403;s:23:\"read-more/style.min.css\";i:404;s:18:\"rss/editor-rtl.css\";i:405;s:22:\"rss/editor-rtl.min.css\";i:406;s:14:\"rss/editor.css\";i:407;s:18:\"rss/editor.min.css\";i:408;s:17:\"rss/style-rtl.css\";i:409;s:21:\"rss/style-rtl.min.css\";i:410;s:13:\"rss/style.css\";i:411;s:17:\"rss/style.min.css\";i:412;s:21:\"search/editor-rtl.css\";i:413;s:25:\"search/editor-rtl.min.css\";i:414;s:17:\"search/editor.css\";i:415;s:21:\"search/editor.min.css\";i:416;s:20:\"search/style-rtl.css\";i:417;s:24:\"search/style-rtl.min.css\";i:418;s:16:\"search/style.css\";i:419;s:20:\"search/style.min.css\";i:420;s:20:\"search/theme-rtl.css\";i:421;s:24:\"search/theme-rtl.min.css\";i:422;s:16:\"search/theme.css\";i:423;s:20:\"search/theme.min.css\";i:424;s:24:\"separator/editor-rtl.css\";i:425;s:28:\"separator/editor-rtl.min.css\";i:426;s:20:\"separator/editor.css\";i:427;s:24:\"separator/editor.min.css\";i:428;s:23:\"separator/style-rtl.css\";i:429;s:27:\"separator/style-rtl.min.css\";i:430;s:19:\"separator/style.css\";i:431;s:23:\"separator/style.min.css\";i:432;s:23:\"separator/theme-rtl.css\";i:433;s:27:\"separator/theme-rtl.min.css\";i:434;s:19:\"separator/theme.css\";i:435;s:23:\"separator/theme.min.css\";i:436;s:24:\"shortcode/editor-rtl.css\";i:437;s:28:\"shortcode/editor-rtl.min.css\";i:438;s:20:\"shortcode/editor.css\";i:439;s:24:\"shortcode/editor.min.css\";i:440;s:24:\"site-logo/editor-rtl.css\";i:441;s:28:\"site-logo/editor-rtl.min.css\";i:442;s:20:\"site-logo/editor.css\";i:443;s:24:\"site-logo/editor.min.css\";i:444;s:23:\"site-logo/style-rtl.css\";i:445;s:27:\"site-logo/style-rtl.min.css\";i:446;s:19:\"site-logo/style.css\";i:447;s:23:\"site-logo/style.min.css\";i:448;s:27:\"site-tagline/editor-rtl.css\";i:449;s:31:\"site-tagline/editor-rtl.min.css\";i:450;s:23:\"site-tagline/editor.css\";i:451;s:27:\"site-tagline/editor.min.css\";i:452;s:26:\"site-tagline/style-rtl.css\";i:453;s:30:\"site-tagline/style-rtl.min.css\";i:454;s:22:\"site-tagline/style.css\";i:455;s:26:\"site-tagline/style.min.css\";i:456;s:25:\"site-title/editor-rtl.css\";i:457;s:29:\"site-title/editor-rtl.min.css\";i:458;s:21:\"site-title/editor.css\";i:459;s:25:\"site-title/editor.min.css\";i:460;s:24:\"site-title/style-rtl.css\";i:461;s:28:\"site-title/style-rtl.min.css\";i:462;s:20:\"site-title/style.css\";i:463;s:24:\"site-title/style.min.css\";i:464;s:26:\"social-link/editor-rtl.css\";i:465;s:30:\"social-link/editor-rtl.min.css\";i:466;s:22:\"social-link/editor.css\";i:467;s:26:\"social-link/editor.min.css\";i:468;s:27:\"social-links/editor-rtl.css\";i:469;s:31:\"social-links/editor-rtl.min.css\";i:470;s:23:\"social-links/editor.css\";i:471;s:27:\"social-links/editor.min.css\";i:472;s:26:\"social-links/style-rtl.css\";i:473;s:30:\"social-links/style-rtl.min.css\";i:474;s:22:\"social-links/style.css\";i:475;s:26:\"social-links/style.min.css\";i:476;s:21:\"spacer/editor-rtl.css\";i:477;s:25:\"spacer/editor-rtl.min.css\";i:478;s:17:\"spacer/editor.css\";i:479;s:21:\"spacer/editor.min.css\";i:480;s:20:\"spacer/style-rtl.css\";i:481;s:24:\"spacer/style-rtl.min.css\";i:482;s:16:\"spacer/style.css\";i:483;s:20:\"spacer/style.min.css\";i:484;s:20:\"table/editor-rtl.css\";i:485;s:24:\"table/editor-rtl.min.css\";i:486;s:16:\"table/editor.css\";i:487;s:20:\"table/editor.min.css\";i:488;s:19:\"table/style-rtl.css\";i:489;s:23:\"table/style-rtl.min.css\";i:490;s:15:\"table/style.css\";i:491;s:19:\"table/style.min.css\";i:492;s:19:\"table/theme-rtl.css\";i:493;s:23:\"table/theme-rtl.min.css\";i:494;s:15:\"table/theme.css\";i:495;s:19:\"table/theme.min.css\";i:496;s:24:\"tag-cloud/editor-rtl.css\";i:497;s:28:\"tag-cloud/editor-rtl.min.css\";i:498;s:20:\"tag-cloud/editor.css\";i:499;s:24:\"tag-cloud/editor.min.css\";i:500;s:23:\"tag-cloud/style-rtl.css\";i:501;s:27:\"tag-cloud/style-rtl.min.css\";i:502;s:19:\"tag-cloud/style.css\";i:503;s:23:\"tag-cloud/style.min.css\";i:504;s:28:\"template-part/editor-rtl.css\";i:505;s:32:\"template-part/editor-rtl.min.css\";i:506;s:24:\"template-part/editor.css\";i:507;s:28:\"template-part/editor.min.css\";i:508;s:27:\"template-part/theme-rtl.css\";i:509;s:31:\"template-part/theme-rtl.min.css\";i:510;s:23:\"template-part/theme.css\";i:511;s:27:\"template-part/theme.min.css\";i:512;s:30:\"term-description/style-rtl.css\";i:513;s:34:\"term-description/style-rtl.min.css\";i:514;s:26:\"term-description/style.css\";i:515;s:30:\"term-description/style.min.css\";i:516;s:27:\"text-columns/editor-rtl.css\";i:517;s:31:\"text-columns/editor-rtl.min.css\";i:518;s:23:\"text-columns/editor.css\";i:519;s:27:\"text-columns/editor.min.css\";i:520;s:26:\"text-columns/style-rtl.css\";i:521;s:30:\"text-columns/style-rtl.min.css\";i:522;s:22:\"text-columns/style.css\";i:523;s:26:\"text-columns/style.min.css\";i:524;s:19:\"verse/style-rtl.css\";i:525;s:23:\"verse/style-rtl.min.css\";i:526;s:15:\"verse/style.css\";i:527;s:19:\"verse/style.min.css\";i:528;s:20:\"video/editor-rtl.css\";i:529;s:24:\"video/editor-rtl.min.css\";i:530;s:16:\"video/editor.css\";i:531;s:20:\"video/editor.min.css\";i:532;s:19:\"video/style-rtl.css\";i:533;s:23:\"video/style-rtl.min.css\";i:534;s:15:\"video/style.css\";i:535;s:19:\"video/style.min.css\";i:536;s:19:\"video/theme-rtl.css\";i:537;s:23:\"video/theme-rtl.min.css\";i:538;s:15:\"video/theme.css\";i:539;s:19:\"video/theme.min.css\";}}", "on");
INSERT INTO `wpbq_options` VALUES("802", "duplicator_version_plugin", "1.5.11.2", "auto");
INSERT INTO `wpbq_options` VALUES("810", "duplicator_package_active", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-04-21 03:38:26\";s:7:\"Version\";s:8:\"1.5.11.2\";s:9:\"VersionWP\";s:3:\"6.8\";s:9:\"VersionDB\";s:6:\"5.7.43\";s:10:\"VersionPHP\";s:6:\"8.2.28\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:24:\"20250226_sapientus_black\";s:4:\"Hash\";s:35:\"8190aff268a3ddda5033_20250421033826\";s:8:\"NameHash\";s:60:\"20250226_sapientus_black_8190aff268a3ddda5033_20250421033826\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:70:\"20250226_sapientus_black_8190aff268a3ddda5033_20250421033826_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";N;s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:44:\"/home/slklwimy/public_html/staging/sapientus\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:2059;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:10929;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Size\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-04-21 03:38:26\";s:7:\"Version\";s:8:\"1.5.11.2\";s:9:\"VersionWP\";s:3:\"6.8\";s:9:\"VersionDB\";s:6:\"5.7.43\";s:10:\"VersionPHP\";s:6:\"8.2.28\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:24:\"20250226_sapientus_black\";s:4:\"Hash\";s:35:\"8190aff268a3ddda5033_20250421033826\";s:8:\"NameHash\";s:60:\"20250226_sapientus_black_8190aff268a3ddda5033_20250421033826\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";N;s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:58:\"/home/slklwimy/public_html/staging/sapientus/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";N;s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:19:\"sameNameTableExists\";N;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:65;s:24:\"\0DUP_Database\0tempDbPath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:53:\"/home/slklwimy/public_html/staging/sapientus/wp-admin\";i:1;s:56:\"/home/slklwimy/public_html/staging/sapientus/wp-includes\";i:2;s:65:\"/home/slklwimy/public_html/staging/sapientus/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:44:\"/home/slklwimy/public_html/staging/sapientus\";i:1;s:44:\"/home/slklwimy/public_html/staging/sapientus\";i:2;s:55:\"/home/slklwimy/public_html/staging/sapientus/wp-content\";i:3;s:63:\"/home/slklwimy/public_html/staging/sapientus/wp-content/uploads\";i:4;s:63:\"/home/slklwimy/public_html/staging/sapientus/wp-content/plugins\";i:5;s:66:\"/home/slklwimy/public_html/staging/sapientus/wp-content/mu-plugins\";i:6;s:62:\"/home/slklwimy/public_html/staging/sapientus/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:76:\"/home/slklwimy/public_html/staging/sapientus/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}", "auto");
INSERT INTO `wpbq_options` VALUES("804", "duplicator_install_info", "a:3:{s:7:\"version\";s:8:\"1.5.11.2\";s:4:\"time\";i:1740532951;s:10:\"updateTime\";i:1740532951;}", "off");
INSERT INTO `wpbq_options` VALUES("805", "duplicator_uninstall_package", "1", "auto");
INSERT INTO `wpbq_options` VALUES("806", "duplicator_uninstall_settings", "1", "auto");
INSERT INTO `wpbq_options` VALUES("807", "duplicator_settings", "a:20:{s:7:\"version\";s:8:\"1.5.11.2\";s:18:\"uninstall_settings\";b:1;s:15:\"uninstall_files\";b:1;s:13:\"package_debug\";b:0;s:23:\"email_summary_frequency\";s:6:\"weekly\";s:9:\"amNotices\";b:1;s:17:\"package_mysqldump\";b:1;s:22:\"package_mysqldump_path\";s:0:\"\";s:24:\"package_phpdump_qrylimit\";s:3:\"100\";s:17:\"package_zip_flush\";b:0;s:19:\"installer_name_mode\";s:6:\"simple\";s:16:\"storage_position\";s:6:\"wpcont\";s:20:\"storage_htaccess_off\";b:0;s:18:\"archive_build_mode\";i:2;s:17:\"skip_archive_scan\";b:0;s:21:\"unhook_third_party_js\";b:0;s:22:\"unhook_third_party_css\";b:0;s:17:\"active_package_id\";i:3;s:14:\"usage_tracking\";b:0;i:0;b:0;}", "auto");
INSERT INTO `wpbq_options` VALUES("808", "duplicator_plugin_data_stats", "{\n    \"lastSendTime\": 0,\n    \"identifier\": \"fK8=q5u5IL7MgRolrj==fTgF_N3kO=JklSvkETM5wz.l\",\n    \"plugin\": \"dup-lite\",\n    \"pluginStatus\": \"active\",\n    \"buildCount\": 2,\n    \"buildLastDate\": 1740800136,\n    \"buildFailedCount\": 0,\n    \"buildFailedLastDate\": 0,\n    \"siteSizeMB\": 288.26999999999998181010596454143524169921875,\n    \"siteNumFiles\": 12988,\n    \"siteDbSizeMB\": 44.13000000000000255795384873636066913604736328125,\n    \"siteDbNumTables\": 24\n}", "auto");
INSERT INTO `wpbq_options` VALUES("2397", "_site_transient_timeout_theme_roots", "1745205088", "off");
INSERT INTO `wpbq_options` VALUES("2398", "_site_transient_theme_roots", "a:4:{s:15:\"hello-elementor\";s:7:\"/themes\";s:16:\"twentytwentyfive\";s:7:\"/themes\";s:16:\"twentytwentyfour\";s:7:\"/themes\";s:17:\"twentytwentythree\";s:7:\"/themes\";}", "off");
INSERT INTO `wpbq_options` VALUES("130", "_transient_wp_styles_for_blocks", "a:2:{s:4:\"hash\";s:32:\"1a7f8946efbf284a4c14585980ade540\";s:6:\"blocks\";a:5:{s:11:\"core/button\";s:0:\"\";s:14:\"core/site-logo\";s:0:\"\";s:18:\"core/post-template\";s:0:\"\";s:12:\"core/columns\";s:0:\"\";s:14:\"core/pullquote\";s:69:\":root :where(.wp-block-pullquote){font-size: 1.5em;line-height: 1.6;}\";}}", "on");
INSERT INTO `wpbq_options` VALUES("284", "_transient_timeout__elementor_ab_test_plg_site_mailer_submission", "1747819304", "off");
INSERT INTO `wpbq_options` VALUES("285", "_transient__elementor_ab_test_plg_site_mailer_submission", "1", "off");
INSERT INTO `wpbq_options` VALUES("218", "recently_activated", "a:2:{s:34:\"tidio-live-chat/tidio-elements.php\";i:1741882298;s:23:\"chatbot/qcld-wpwbot.php\";i:1741859186;}", "off");
INSERT INTO `wpbq_options` VALUES("219", "eael_version", "6.1.4", "auto");
INSERT INTO `wpbq_options` VALUES("220", "essential-addons-for-elementor-lite_notices", "a:3:{s:17:\"holiday_24_notice\";a:4:{s:5:\"start\";i:1740042806;s:10:\"recurrence\";b:0;s:7:\"refresh\";s:5:\"6.1.4\";s:6:\"expire\";i:1736553599;}s:7:\"version\";s:5:\"1.1.0\";s:6:\"review\";a:3:{s:5:\"start\";i:1740647607;s:10:\"recurrence\";i:30;s:7:\"refresh\";s:5:\"6.1.4\";}}", "off");
INSERT INTO `wpbq_options` VALUES("221", "eael_admin_menu_notice", "11", "off");
INSERT INTO `wpbq_options` VALUES("135", "softaculous_pro_license", "a:14:{s:7:\"license\";s:30:\"SOFTWP-26641-15969-22204-21216\";s:7:\"expires\";s:8:\"20250504\";s:4:\"type\";s:1:\"1\";s:8:\"type_txt\";s:7:\"Premium\";s:9:\"num_sites\";N;s:4:\"plan\";s:8:\"personal\";s:6:\"active\";i:1;s:10:\"licexpired\";N;s:4:\"thid\";N;s:6:\"status\";i:1;s:9:\"last_edit\";s:10:\"1740042391\";s:10:\"status_txt\";s:33:\"<font color=\"green\">Active</font>\";s:8:\"has_plid\";i:1;s:11:\"last_update\";i:1745203283;}", "yes");
INSERT INTO `wpbq_options` VALUES("136", "softaculous_pro_settings", "a:1:{s:19:\"ai_history_duration\";i:90;}", "auto");
INSERT INTO `wpbq_options` VALUES("137", "softaculous_pro_version", "2.2.1", "auto");
INSERT INTO `wpbq_options` VALUES("138", "softaculous_pro_rebranding", "a:4:{s:2:\"sn\";s:11:\"Softaculous\";s:8:\"logo_url\";s:0:\"\";s:13:\"default_hf_bg\";s:0:\"\";s:15:\"default_hf_text\";s:0:\"\";}", "yes");
INSERT INTO `wpbq_options` VALUES("140", "loginizer_version", "1.9.8", "auto");
INSERT INTO `wpbq_options` VALUES("141", "loginizer_options", "a:0:{}", "auto");
INSERT INTO `wpbq_options` VALUES("142", "loginizer_last_reset", "1745203283", "auto");
INSERT INTO `wpbq_options` VALUES("143", "loginizer_whitelist", "a:0:{}", "auto");
INSERT INTO `wpbq_options` VALUES("144", "loginizer_blacklist", "a:0:{}", "auto");
INSERT INTO `wpbq_options` VALUES("145", "loginizer_2fa_whitelist", "a:0:{}", "auto");
INSERT INTO `wpbq_options` VALUES("146", "loginizer_softwp_upgrade", "1740042393", "auto");
INSERT INTO `wpbq_options` VALUES("147", "loginizer_ins_time", "1740042393", "auto");
INSERT INTO `wpbq_options` VALUES("148", "loginizer_free_installed", "1740042393", "auto");
INSERT INTO `wpbq_options` VALUES("149", "loginizer_version_pro_nag", "1740042393", "auto");
INSERT INTO `wpbq_options` VALUES("150", "loginizer_version_free_nag", "1740042393", "auto");
INSERT INTO `wpbq_options` VALUES("151", "loginizer_pro_version", "1.9.8", "auto");
INSERT INTO `wpbq_options` VALUES("166", "gosmtp_pro_version", "1.1.1", "auto");
INSERT INTO `wpbq_options` VALUES("153", "siteseo_toggle", "a:6:{s:13:\"toggle-titles\";b:1;s:18:\"toggle-xml-sitemap\";b:1;s:23:\"toggle-instant-indexing\";b:1;s:15:\"toggle-advanced\";b:1;s:13:\"toggle-social\";b:1;s:23:\"toggle-google-analytics\";b:1;}", "auto");
INSERT INTO `wpbq_options` VALUES("154", "siteseo_titles_option_name", "a:13:{s:10:\"titles_sep\";s:1:\"-\";s:22:\"titles_home_site_title\";s:13:\"%%sitetitle%%\";s:21:\"titles_home_site_desc\";s:11:\"%%tagline%%\";s:20:\"titles_single_titles\";a:2:{s:4:\"post\";a:3:{s:6:\"enable\";b:1;s:5:\"title\";s:15:\"%%post_title%% \";s:11:\"description\";s:16:\"%%post_excerpt%%\";}s:4:\"page\";a:3:{s:6:\"enable\";b:1;s:5:\"title\";s:15:\"%%post_title%% \";s:11:\"description\";s:16:\"%%post_excerpt%%\";}}s:28:\"titles_archives_author_title\";s:15:\"%%post_author%%\";s:30:\"titles_archives_author_noindex\";b:1;s:26:\"titles_archives_date_title\";s:16:\"%%archive_date%%\";s:28:\"titles_archives_date_noindex\";b:1;s:36:\"titles_archives_search_title_noindex\";b:1;s:27:\"titles_nositelinkssearchbox\";b:1;s:28:\"titles_archives_search_title\";s:19:\"%%search_keywords%%\";s:25:\"titles_archives_404_title\";s:20:\"404 - Page not found\";s:17:\"titles_tax_titles\";a:2:{s:8:\"category\";a:1:{s:6:\"enable\";b:1;}s:8:\"post_tag\";a:1:{s:6:\"enable\";b:1;}}}", "auto");
INSERT INTO `wpbq_options` VALUES("155", "siteseo_social_option_name", "a:2:{s:19:\"social_twitter_card\";b:1;s:18:\"social_facebook_og\";b:1;}", "auto");
INSERT INTO `wpbq_options` VALUES("156", "siteseo_xml_sitemap_option_name", "a:3:{s:26:\"xml_sitemap_general_enable\";b:1;s:27:\"xml_sitemap_post_types_list\";a:2:{s:4:\"post\";a:1:{s:7:\"include\";b:1;}s:4:\"page\";a:1:{s:7:\"include\";b:1;}}s:27:\"xml_sitemap_taxonomies_list\";a:2:{s:8:\"category\";a:1:{s:7:\"include\";b:1;}s:8:\"post_tag\";a:1:{s:7:\"include\";b:1;}}}", "auto");
INSERT INTO `wpbq_options` VALUES("157", "siteseo_advanced_option_name", "a:2:{s:20:\"advanced_attachments\";b:1;s:28:\"appearance_universal_metabox\";b:1;}", "auto");
INSERT INTO `wpbq_options` VALUES("158", "siteseo_version", "1.1.5", "auto");
INSERT INTO `wpbq_options` VALUES("159", "external_updates-loginizer-security", "O:8:\"stdClass\":3:{s:9:\"lastCheck\";i:1745203291;s:14:\"checkedVersion\";s:5:\"1.9.8\";s:6:\"update\";O:8:\"stdClass\":11:{s:2:\"id\";i:0;s:4:\"slug\";s:18:\"loginizer-security\";s:7:\"version\";s:5:\"2.0.0\";s:8:\"homepage\";s:20:\"http://loginizer.com\";s:6:\"tested\";s:5:\"6.7.2\";s:12:\"download_url\";s:156:\"https://s1.softaculous.com/a/loginizer/download.php?version=2.0.0&license=SOFTWP-26641-15969-22204-21216&url=https://slk.lwi.mybluehost.me/staging/sapientus\";s:14:\"upgrade_notice\";N;s:8:\"filename\";s:41:\"loginizer-security/loginizer-security.php\";s:12:\"translations\";a:0:{}s:5:\"icons\";a:2:{s:2:\"2x\";s:50:\"https://ps.w.org/loginizer/assets/icon-256x256.png\";s:2:\"1x\";s:50:\"https://ps.w.org/loginizer/assets/icon-128x128.png\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:53:\"https://ps.w.org/loginizer/assets/banner-1544x500.jpg\";s:2:\"1x\";s:52:\"https://ps.w.org/loginizer/assets/banner-772x250.jpg\";}}}", "off");
INSERT INTO `wpbq_options` VALUES("160", "siteseo_pro_version", "1.1.5", "auto");
INSERT INTO `wpbq_options` VALUES("162", "loginizer_checksums_last_run", "1745022958", "auto");
INSERT INTO `wpbq_options` VALUES("163", "gosmtp_free_installed", "1740042395", "auto");
INSERT INTO `wpbq_options` VALUES("164", "gosmtp_version_pro_nag", "1740042395", "auto");
INSERT INTO `wpbq_options` VALUES("165", "gosmtp_version_free_nag", "1740042395", "auto");
INSERT INTO `wpbq_options` VALUES("161", "gosmtp_version", "1.1.1", "auto");
INSERT INTO `wpbq_options` VALUES("167", "backuply_version", "1.4.3", "auto");
INSERT INTO `wpbq_options` VALUES("168", "backuply_config_keys", "a:1:{s:12:\"BACKUPLY_KEY\";s:64:\"e68286aabc73d70f13a2c1ce7279690bdd8c059c0d7d20930b85c3f5f7a5e5bd\";}", "auto");
INSERT INTO `wpbq_options` VALUES("169", "loginizer_checksums_diff", "a:0:{}", "auto");
INSERT INTO `wpbq_options` VALUES("171", "backuply_pro_version", "1.4.3", "auto");
INSERT INTO `wpbq_options` VALUES("172", "external_updates-gosmtp-pro", "O:8:\"stdClass\":3:{s:9:\"lastCheck\";i:1745203291;s:14:\"checkedVersion\";s:5:\"1.1.1\";s:6:\"update\";O:8:\"stdClass\":9:{s:2:\"id\";i:0;s:4:\"slug\";s:10:\"gosmtp-pro\";s:7:\"version\";s:5:\"1.1.1\";s:8:\"homepage\";s:19:\"https://gosmtp.net/\";s:6:\"tested\";s:5:\"6.7.2\";s:12:\"download_url\";s:153:\"https://s3.softaculous.com/a/gosmtp/download.php?version=1.1.1&license=SOFTWP-26641-15969-22204-21216&url=https://slk.lwi.mybluehost.me/staging/sapientus\";s:14:\"upgrade_notice\";N;s:8:\"filename\";s:25:\"gosmtp-pro/gosmtp-pro.php\";s:12:\"translations\";a:0:{}}}", "off");
INSERT INTO `wpbq_options` VALUES("173", "pagelayer_version", "1.9.8", "auto");
INSERT INTO `wpbq_options` VALUES("174", "pagelayer_options", "a:0:{}", "auto");
INSERT INTO `wpbq_options` VALUES("175", "pagelayer_pro_version", "1.9.8", "auto");
INSERT INTO `wpbq_options` VALUES("176", "pagelayer_pro_options", "a:0:{}", "auto");
INSERT INTO `wpbq_options` VALUES("177", "external_updates-siteseo-pro", "O:8:\"stdClass\":3:{s:9:\"lastCheck\";i:1745203292;s:14:\"checkedVersion\";s:5:\"1.1.5\";s:6:\"update\";O:8:\"stdClass\":9:{s:2:\"id\";i:0;s:4:\"slug\";s:11:\"siteseo-pro\";s:7:\"version\";s:5:\"1.2.0\";s:8:\"homepage\";s:17:\"http://siteseo.io\";s:6:\"tested\";s:5:\"6.7.2\";s:12:\"download_url\";s:154:\"https://s7.softaculous.com/a/siteseo/download.php?version=1.2.0&license=SOFTWP-26641-15969-22204-21216&url=https://slk.lwi.mybluehost.me/staging/sapientus\";s:14:\"upgrade_notice\";N;s:8:\"filename\";s:27:\"siteseo-pro/siteseo-pro.php\";s:12:\"translations\";a:0:{}}}", "off");
INSERT INTO `wpbq_options` VALUES("222", "elementor_active_kit", "5", "auto");
INSERT INTO `wpbq_options` VALUES("223", "elementor_font_display", "swap", "auto");
INSERT INTO `wpbq_options` VALUES("226", "elementor_checklist", "{\"last_opened_timestamp\":1740044569,\"first_closed_checklist_in_editor\":false,\"is_popup_minimized\":false,\"steps\":{\"add_logo\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"set_fonts_and_colors\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"create_pages\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"setup_header\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"assign_homepage\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"setup_header_pro\":{\"is_marked_completed\":false,\"is_immutable_completed\":false}},\"should_open_in_editor\":true}", "auto");
INSERT INTO `wpbq_options` VALUES("227", "elementor_version", "3.27.6", "auto");
INSERT INTO `wpbq_options` VALUES("228", "elementor_install_history", "a:1:{s:6:\"3.27.6\";i:1740042939;}", "auto");
INSERT INTO `wpbq_options` VALUES("229", "elementor_events_db_version", "1.0.0", "off");
INSERT INTO `wpbq_options` VALUES("231", "elementor_onboarded", "1", "auto");
INSERT INTO `wpbq_options` VALUES("232", "_elementor_installed_time", "1740042952", "auto");
INSERT INTO `wpbq_options` VALUES("233", "elementor_connect_site_key", "84dcec602c4010c2daf413f5029fafc4", "auto");
INSERT INTO `wpbq_options` VALUES("178", "external_updates-siteseo", "O:8:\"stdClass\":3:{s:9:\"lastCheck\";i:1745203292;s:14:\"checkedVersion\";s:5:\"1.1.5\";s:6:\"update\";O:8:\"stdClass\":9:{s:2:\"id\";i:0;s:4:\"slug\";s:7:\"siteseo\";s:7:\"version\";s:5:\"1.2.0\";s:8:\"homepage\";s:17:\"http://siteseo.io\";s:6:\"tested\";s:5:\"6.7.2\";s:12:\"download_url\";s:71:\"https://a.softaculous.com/siteseo/files/versions/latest-stable-free.zip\";s:14:\"upgrade_notice\";N;s:8:\"filename\";s:19:\"siteseo/siteseo.php\";s:12:\"translations\";a:0:{}}}", "off");
INSERT INTO `wpbq_options` VALUES("179", "speedycache_options", "a:6:{s:3:\"lbc\";b:1;s:10:\"minify_css\";b:1;s:4:\"gzip\";b:1;s:11:\"minify_html\";b:1;s:9:\"minify_js\";b:1;s:15:\"render_blocking\";b:1;}", "auto");
INSERT INTO `wpbq_options` VALUES("180", "speedycache_version", "1.2.9", "auto");
INSERT INTO `wpbq_options` VALUES("181", "external_updates-backuply-pro", "O:8:\"stdClass\":3:{s:9:\"lastCheck\";i:1745203293;s:14:\"checkedVersion\";s:5:\"1.4.3\";s:6:\"update\";O:8:\"stdClass\":9:{s:2:\"id\";i:0;s:4:\"slug\";s:12:\"backuply-pro\";s:7:\"version\";s:5:\"1.4.4\";s:8:\"homepage\";s:21:\"https://backuply.com/\";s:6:\"tested\";s:5:\"6.7.2\";s:12:\"download_url\";s:155:\"https://s8.softaculous.com/a/backuply/download.php?version=1.4.4&license=SOFTWP-26641-15969-22204-21216&url=https://slk.lwi.mybluehost.me/staging/sapientus\";s:14:\"upgrade_notice\";N;s:8:\"filename\";s:29:\"backuply-pro/backuply-pro.php\";s:12:\"translations\";a:0:{}}}", "off");
INSERT INTO `wpbq_options` VALUES("182", "speedycache_pro_version", "1.2.9", "auto");
INSERT INTO `wpbq_options` VALUES("183", "speedycache_free_installed", "1740042409", "auto");
INSERT INTO `wpbq_options` VALUES("184", "speedycache_pro_older_pro_version_nag", "1740042409", "auto");
INSERT INTO `wpbq_options` VALUES("185", "speedycache_pro_older_free_version_nag", "1740042409", "auto");
INSERT INTO `wpbq_options` VALUES("187", "external_updates-pagelayer-pro", "O:8:\"stdClass\":3:{s:9:\"lastCheck\";i:1745203293;s:14:\"checkedVersion\";s:5:\"1.9.8\";s:6:\"update\";O:8:\"stdClass\":9:{s:2:\"id\";i:0;s:4:\"slug\";s:13:\"pagelayer-pro\";s:7:\"version\";s:5:\"2.0.0\";s:8:\"homepage\";s:21:\"https://pagelayer.com\";s:6:\"tested\";s:5:\"6.7.2\";s:12:\"download_url\";s:156:\"https://s1.softaculous.com/a/pagelayer/download.php?version=2.0.0&license=SOFTWP-26641-15969-22204-21216&url=https://slk.lwi.mybluehost.me/staging/sapientus\";s:14:\"upgrade_notice\";N;s:8:\"filename\";s:31:\"pagelayer-pro/pagelayer-pro.php\";s:12:\"translations\";a:0:{}}}", "off");
INSERT INTO `wpbq_options` VALUES("188", "external_updates-speedycache-pro", "O:8:\"stdClass\":3:{s:9:\"lastCheck\";i:1745203293;s:14:\"checkedVersion\";s:5:\"1.2.9\";s:6:\"update\";O:8:\"stdClass\":9:{s:2:\"id\";i:0;s:4:\"slug\";s:15:\"speedycache-pro\";s:7:\"version\";s:5:\"1.3.3\";s:8:\"homepage\";s:22:\"http://speedycache.com\";s:6:\"tested\";s:3:\"6.8\";s:12:\"download_url\";s:158:\"https://s5.softaculous.com/a/speedycache/download.php?version=1.3.3&license=SOFTWP-26641-15969-22204-21216&url=https://slk.lwi.mybluehost.me/staging/sapientus\";s:14:\"upgrade_notice\";N;s:8:\"filename\";s:35:\"speedycache-pro/speedycache-pro.php\";s:12:\"translations\";a:0:{}}}", "off");
INSERT INTO `wpbq_options` VALUES("189", "speedycache_img", "a:5:{s:9:\"on_upload\";b:0;s:14:\"automatic_optm\";b:0;s:11:\"url_rewrite\";b:0;s:18:\"compression_method\";s:2:\"gd\";s:19:\"compression_quality\";s:2:\"70\";}", "auto");
INSERT INTO `wpbq_options` VALUES("191", "loginizer_login_attempt_stats", "a:7:{i:1740042000;a:1:{i:1;i:1;}i:1740798000;a:1:{i:1;i:1;}i:1741856400;a:1:{i:1;i:1;}i:1741860000;a:1:{i:1;i:1;}i:1741878000;a:1:{i:1;i:1;}i:1741906800;a:1:{i:1;i:1;}i:1745204400;a:2:{i:0;i:1;i:1;i:1;}}", "off");
INSERT INTO `wpbq_options` VALUES("192", "backuply_hide_trial", "1740042428", "off");
INSERT INTO `wpbq_options` VALUES("193", "backuply_backup_nag", "1741858231", "off");
INSERT INTO `wpbq_options` VALUES("194", "backuply_license_notice", "1740042428", "auto");
INSERT INTO `wpbq_options` VALUES("204", "finished_updating_comment_type", "1", "auto");
INSERT INTO `wpbq_options` VALUES("196", "external_updates-softaculous-pro", "O:8:\"stdClass\":3:{s:9:\"lastCheck\";i:1745206663;s:14:\"checkedVersion\";s:5:\"2.2.1\";s:6:\"update\";O:8:\"stdClass\":9:{s:2:\"id\";i:0;s:4:\"slug\";s:15:\"softaculous-pro\";s:7:\"version\";s:5:\"2.2.2\";s:8:\"homepage\";s:19:\"https://softwp.net/\";s:6:\"tested\";s:3:\"6.8\";s:12:\"download_url\";s:153:\"https://s5.softaculous.com/a/softwp/download.php?version=2.2.2&license=SOFTWP-26641-15969-22204-21216&url=https://slk.lwi.mybluehost.me/staging/sapientus\";s:14:\"upgrade_notice\";N;s:8:\"filename\";s:35:\"softaculous-pro/softaculous-pro.php\";s:12:\"translations\";a:0:{}}}", "off");
INSERT INTO `wpbq_options` VALUES("2411", "_site_transient_timeout_community-events-6a55cebd258c0198572f91db1ae01135", "1745249871", "off");
INSERT INTO `wpbq_options` VALUES("2412", "_site_transient_community-events-6a55cebd258c0198572f91db1ae01135", "a:4:{s:9:\"sandboxed\";b:0;s:5:\"error\";N;s:8:\"location\";a:1:{s:2:\"ip\";s:13:\"112.201.162.0\";}s:6:\"events\";a:0:{}}", "off");
INSERT INTO `wpbq_options` VALUES("2413", "_transient_timeout_feed_9bbd59226dc36b9b26cd43f15694c5c3", "1745249872", "off");
INSERT INTO `wpbq_options` VALUES("2414", "_transient_feed_9bbd59226dc36b9b26cd43f15694c5c3", "a:6:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:52:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\n \n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:8:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"https://wordpress.org/news\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"The latest news about WordPress and the WordPress community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 15 Apr 2025 22:16:36 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://wordpress.org/?v=6.9-alpha-60172\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"image\";a:1:{i:0;a:6:{s:4:\"data\";s:11:\"\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:3:\"url\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://s.w.org/favicon.ico?2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"https://wordpress.org/news\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"width\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"height\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:66:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"WordPress 6.8 “Cecil”\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:41:\"https://wordpress.org/news/2025/04/cecil/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 15 Apr 2025 17:00:45 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:4:{i:0;a:5:{s:4:\"data\";s:7:\"General\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"6.8\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:8:\"releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=18701\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:395:\"WordPress 6.8, code-named “Cecil,” refines your creative workflow with a streamlined Style Book, now available in select Classic themes. Enjoy faster navigation via speculative loading, stronger security with bcrypt password hashing, and over 100 accessibility improvements. With thoughtful editor upgrades and behind-the-scenes performance boosts, 6.8 delivers polish, power, and precision.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Jeffrey Paul\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:79526:\"\n<figure class=\"wp-block-image size-large\"><img data-recalc-dims=\"1\" fetchpriority=\"high\" decoding=\"async\" width=\"1024\" height=\"535\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/04/WordPress-6-8-Cecil.png?resize=1024%2C535&#038;ssl=1\" alt=\"Simulated record album featuring a grid of brightly-colored duotone portraits of Cecil Taylor\" class=\"wp-image-18708\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/04/WordPress-6-8-Cecil.png?resize=1024%2C535&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/04/WordPress-6-8-Cecil.png?resize=300%2C157&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/04/WordPress-6-8-Cecil.png?resize=768%2C401&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/04/WordPress-6-8-Cecil.png?resize=1536%2C802&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/04/WordPress-6-8-Cecil.png?resize=2048%2C1070&amp;ssl=1 2048w, https://i0.wp.com/wordpress.org/news/files/2025/04/WordPress-6-8-Cecil.png?w=3000&amp;ssl=1 3000w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" /></figure>\n\n\n\n<p>Each WordPress release celebrates an artist who has left an indelible mark on music.&nbsp; WordPress 6.8, code-named “Cecil,” honors the legendary pianist and jazz pioneer Cecil Taylor.</p>\n\n\n\n<p>Classically trained yet relentlessly unconventional, Taylor reimagined the piano as a percussive instrument—layering tone clusters, polyphony, and rhythm into a sound both chaotic and precise. His music defied expectation, finding form in disorder and harmony in dissonance.</p>\n\n\n\n<p>That same spirit drives WordPress 6.8. Embrace its bold new features with the same curiosity and experimentation that defined Cecil’s sound.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Welcome to WordPress 6.8!</h2>\n\n\n\n<p>WordPress 6.8 polishes and refines the tools that you use every day, making your site faster, more secure, and easier to manage.&nbsp; The Style Book now has a structured layout and works with Classic themes, giving you more control over global styles. Speculative loading speeds up navigation by preloading links before users navigate to them, bcrypt hashing strengthens password security automatically, and database optimizations improve performance.</p>\n\n\n\n<p><a href=\"https://wordpress.org/wordpress-6.8.zip\">Download WordPress 6.8 “Cecil”</a></p>\n\n\n\n<h2 class=\"wp-block-heading\">A release polished to a high sheen.</h2>\n\n\n\n<h3 class=\"wp-block-heading\">The Style Book gets a cleaner look—and a few new tricks.</h3>\n\n\n\n<p>The Style Book has a new, structured layout and clearer labels, to make it even easier to edit colors, typography—almost all your site styles—in one place.</p>\n\n\n\n<p>Plus, now you can see it in Classic themes that have editor-styles or a theme.json file.&nbsp; Find the Style Book under Appearance &gt; Design and use it to preview your theme’s evolution, as you edit CSS or make changes in the Customizer.</p>\n\n\n\n<figure class=\"wp-block-image size-full\"><img data-recalc-dims=\"1\" decoding=\"async\" width=\"900\" height=\"900\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/04/6-8-style-book.png?resize=900%2C900&#038;ssl=1\" alt=\"\" class=\"wp-image-18703\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/04/6-8-style-book.png?w=900&amp;ssl=1 900w, https://i0.wp.com/wordpress.org/news/files/2025/04/6-8-style-book.png?resize=300%2C300&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/04/6-8-style-book.png?resize=150%2C150&amp;ssl=1 150w, https://i0.wp.com/wordpress.org/news/files/2025/04/6-8-style-book.png?resize=768%2C768&amp;ssl=1 768w\" sizes=\"(max-width: 900px) 100vw, 900px\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Editor improvements</h3>\n\n\n\n<p>Easier ways to see your options in Data Views, and you can exclude sticky posts from the Query Loop.&nbsp; Plus, you’ll find lots of little improvements in the editor that smooth your way through everything you build.</p>\n\n\n\n<figure class=\"wp-block-image size-full\"><img data-recalc-dims=\"1\" decoding=\"async\" width=\"900\" height=\"900\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/04/6-8-editor-improvements.png?resize=900%2C900&#038;ssl=1\" alt=\"\" class=\"wp-image-18705\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/04/6-8-editor-improvements.png?w=900&amp;ssl=1 900w, https://i0.wp.com/wordpress.org/news/files/2025/04/6-8-editor-improvements.png?resize=300%2C300&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/04/6-8-editor-improvements.png?resize=150%2C150&amp;ssl=1 150w, https://i0.wp.com/wordpress.org/news/files/2025/04/6-8-editor-improvements.png?resize=768%2C768&amp;ssl=1 768w\" sizes=\"(max-width: 900px) 100vw, 900px\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Near-instant page loads, thanks to Speculative Loading</h3>\n\n\n\n<p>In WordPress 6.8, pages load faster than ever.&nbsp; When you or your user hovers over or clicks a link, WordPress may preload the next page, for a smoother, near-instant experience. The system balances speed and efficiency, and you can control how it works, with a plugin or your own code.&nbsp; This feature only works in modern browsers—older ones will simply ignore it without any impact.</p>\n\n\n\n<figure class=\"wp-block-image size-full\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"900\" height=\"900\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/04/6-8-speculative-loading-1.png?resize=900%2C900&#038;ssl=1\" alt=\"\" class=\"wp-image-18706\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/04/6-8-speculative-loading-1.png?w=900&amp;ssl=1 900w, https://i0.wp.com/wordpress.org/news/files/2025/04/6-8-speculative-loading-1.png?resize=300%2C300&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/04/6-8-speculative-loading-1.png?resize=150%2C150&amp;ssl=1 150w, https://i0.wp.com/wordpress.org/news/files/2025/04/6-8-speculative-loading-1.png?resize=768%2C768&amp;ssl=1 768w\" sizes=\"auto, (max-width: 900px) 100vw, 900px\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Stronger password security with bcrypt</h3>\n\n\n\n<p>Now passwords are harder to crack with bcrypt hashing, which takes a lot more computing power to break.&nbsp; This strengthens overall security, as do other encryption improvements across WordPress.&nbsp; You don’t need to do anything—everything updates automatically.</p>\n\n\n\n<figure class=\"wp-block-image size-full\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"900\" height=\"900\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/04/6-8-stronger-password-security-bcrypt.png?resize=900%2C900&#038;ssl=1\" alt=\"\" class=\"wp-image-18707\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/04/6-8-stronger-password-security-bcrypt.png?w=900&amp;ssl=1 900w, https://i0.wp.com/wordpress.org/news/files/2025/04/6-8-stronger-password-security-bcrypt.png?resize=300%2C300&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/04/6-8-stronger-password-security-bcrypt.png?resize=150%2C150&amp;ssl=1 150w, https://i0.wp.com/wordpress.org/news/files/2025/04/6-8-stronger-password-security-bcrypt.png?resize=768%2C768&amp;ssl=1 768w\" sizes=\"auto, (max-width: 900px) 100vw, 900px\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Accessibility improvements</h3>\n\n\n\n<p>100+ accessibility fixes and enhancements touch a broad spectrum of the WordPress experience.&nbsp; This release includes fixes to every bundled theme, improvements to the navigation menu management, the customizer, and simplified labeling.&nbsp; The Block Editor has over 70 improvements to blocks, DataViews, and to its overall user experience.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Performance updates</h3>\n\n\n\n<p>WordPress 6.8 packs a wide range of performance fixes and enhancements to speed up everything from editing to browsing.&nbsp; Beyond speculative loading, WordPress 6.8 pays special attention to the block editor, block type registration, and query caching.&nbsp; Plus, imagine never waiting longer than 50 milliseconds—for any interaction.&nbsp; In WordPress 6.8, the Interactivity API takes a first step toward that goal.</p>\n\n\n\n<h3 class=\"wp-block-heading\">And much more</h3>\n\n\n\n<p>For a comprehensive overview of all the new features and enhancements in WordPress 6.8, please visit the feature-showcase website.</p>\n\n\n\n<p><a href=\"https://wordpress.org/download/releases/6-8/\">Check out what’s new</a></p>\n\n\n\n<h2 class=\"wp-block-heading\">Learn more about WordPress 6.8</h2>\n\n\n\n<p><a href=\"https://learn.wordpress.org/\">Learn WordPress</a> is a free resource for new and experienced WordPress users.&nbsp; Learn is stocked with how-to videos on using various features in WordPress, <a href=\"https://learn.wordpress.org/social-learning/\">interactive workshops</a> for exploring topics in-depth, and lesson plans for diving deep into specific areas of WordPress.</p>\n\n\n\n<p>Read the <a href=\"https://wordpress.org/documentation/wordpress-version/version-6.8\">WordPress 6.8 Release Notes</a> for information on installation, enhancements, fixed issues, release contributors, learning resources, and the list of file changes.</p>\n\n\n\n<p>Explore the <a href=\"https://make.wordpress.org/core/2025/03/28/wordpress-6-8-field-guide/\">WordPress 6.8 Field Guide</a>.&nbsp; Learn about the changes in this release with detailed developer notes to help you build with WordPress.</p>\n\n\n\n<h2 class=\"wp-block-heading\">The 6.8 release squad</h2>\n\n\n\n<p>Every release comes to you from a dedicated team of enthusiastic contributors who help keep things on track and moving smoothly.&nbsp; The team that has led 6.8 is a cross-functional group of contributors who are always ready to champion ideas, remove blockers, and resolve issues.</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Release Lead: <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a></li>\n\n\n\n<li>Release Coordination: <a href=\"https://profiles.wordpress.org/jeffpaul/\">Jeffrey Paul</a> and <a href=\"https://profiles.wordpress.org/michelleames/\">Michelle Frechette</a></li>\n\n\n\n<li>Tech Leads: <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a>, <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a>, and <a href=\"https://profiles.wordpress.org/mamaduka/\">George Mamadashvili</a></li>\n\n\n\n<li>Triage Lead: <a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a></li>\n\n\n\n<li>Design Lead: <a href=\"https://profiles.wordpress.org/karmatosed/\">Tammie Lister</a></li>\n\n\n\n<li>Performance Lead: <a href=\"https://profiles.wordpress.org/flixos90/\">Felix Arntz</a></li>\n\n\n\n<li>Test Lead: <a href=\"https://profiles.wordpress.org/krupajnanda/\">Krupa Nanda</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Thank you, contributors</strong></h2>\n\n\n\n<p>The mission of WordPress is to <a href=\"https://wordpress.org/about/\">democratize publishing</a> and embody the <a href=\"https://opensource.org/osd-annotated\">freedoms that come with open source</a>.&nbsp; A global and diverse community of people collaborating to strengthen the software supports this effort.</p>\n\n\n\n<p>WordPress 6.8 reflects the tireless efforts and passion of more than 900 contributors in more than 60 countries all over the world. This release also welcomed over 250 first-time contributors!&nbsp;</p>\n\n\n\n<p>Their collaboration delivered more than 320 enhancements and fixes, ensuring a stable release for all—a testament to the power and capability of the WordPress open source community.</p>\n\n\n<p class=\"has-small-font-size\"><a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a> · <a href=\"https://profiles.wordpress.org/aaronrobertshaw/\">Aaron Robertshaw</a> · <a href=\"https://profiles.wordpress.org/thehercules/\">Aashish Sharma</a> · <a href=\"https://profiles.wordpress.org/webcommsat/\">Abha Thakor</a> · <a href=\"https://profiles.wordpress.org/hiabhaykulkarni/\">Abhay Kulkarni</a> · <a href=\"https://profiles.wordpress.org/abhi3315/\">Abhishek Sharma</a> · <a href=\"https://profiles.wordpress.org/adakaleh/\">AdaKaleh</a> · <a href=\"https://profiles.wordpress.org/adamsilverstein/\">Adam Silverstein</a> · <a href=\"https://profiles.wordpress.org/zieladam/\">Adam Zieliński</a> · <a href=\"https://profiles.wordpress.org/adhun/\">Adhun Anand</a> · <a href=\"https://profiles.wordpress.org/adityab98/\">Aditya Bansode</a> · <a href=\"https://profiles.wordpress.org/stromhalm/\">Adrian Jagusch</a> · <a href=\"https://profiles.wordpress.org/aduth/\">aduth</a> · <a href=\"https://profiles.wordpress.org/hemant-ahir/\">Ahir Hemant</a> · <a href=\"https://profiles.wordpress.org/ahmarzaidi/\">Ahmar Zaidi</a> · <a href=\"https://profiles.wordpress.org/chaion07/\">Ahmed Kabir Chaion</a> · <a href=\"https://profiles.wordpress.org/engahmeds3ed/\">Ahmed Saeed</a> · <a href=\"https://profiles.wordpress.org/ahsankhan316/\">Ahsan Khan</a> · <a href=\"https://profiles.wordpress.org/aishwarryapande/\">Aishwarrya Pande</a> · <a href=\"https://profiles.wordpress.org/ajayghaghretiya1/\">Ajay Ghaghretiya</a> · <a href=\"https://profiles.wordpress.org/ajmaurya/\">Ajay Maurya</a> · <a href=\"https://profiles.wordpress.org/ajitbohra/\">Ajit Bohra</a> · <a href=\"https://profiles.wordpress.org/akanshusingh/\">Akanshu Singh</a> · <a href=\"https://profiles.wordpress.org/wildworks/\">Aki Hamano</a> · <a href=\"https://profiles.wordpress.org/atachibana/\">Akira Tachibana</a> · <a href=\"https://profiles.wordpress.org/aks30498/\">aks30498</a> · <a href=\"https://profiles.wordpress.org/akshat2802/\">Akshat Kakkad</a> · <a href=\"https://profiles.wordpress.org/akshaydhere/\">Akshay Dhere</a> · <a href=\"https://profiles.wordpress.org/aljullu/\">Albert Juh&#233; Lluveras</a> · <a href=\"https://profiles.wordpress.org/ralessio/\">Alessio</a> · <a href=\"https://profiles.wordpress.org/xknown/\">Alex Concha</a> · <a href=\"https://profiles.wordpress.org/alexflorisca/\">Alex Florisca</a> · <a href=\"https://profiles.wordpress.org/ajlende/\">Alex Lende</a> · <a href=\"https://profiles.wordpress.org/alexstine/\">Alex Stine</a> · <a href=\"https://profiles.wordpress.org/albigdd/\">Alexander Bigga</a> · <a href=\"https://profiles.wordpress.org/alexandrebuffet/\">Alexandre Buffet</a> · <a href=\"https://profiles.wordpress.org/alexus450/\">Alexei Samarschi</a> · <a href=\"https://profiles.wordpress.org/alexschmitz/\">alexschmitz</a> · <a href=\"https://profiles.wordpress.org/alireyad/\">Ali Akbar Reyad</a> · <a href=\"https://profiles.wordpress.org/firewatch/\">allilevine</a> · <a href=\"https://profiles.wordpress.org/alpipego/\">alpipego</a> · <a href=\"https://profiles.wordpress.org/mrfoxtalbot/\">Alvaro G&#243;mez</a> · <a href=\"https://profiles.wordpress.org/akrocks/\">Amaan Khan</a> · <a href=\"https://profiles.wordpress.org/alh0319/\">Amber Hinds</a> · <a href=\"https://profiles.wordpress.org/amimulihsanmahdi/\">Amimul Ihsan</a> · <a href=\"https://profiles.wordpress.org/amin7/\">Amin</a> · <a href=\"https://profiles.wordpress.org/amincharoliya/\">Amin Charoliya</a> · <a href=\"https://profiles.wordpress.org/amitbhosale/\">Amit Bhosale</a> · <a href=\"https://profiles.wordpress.org/amitraj2203/\">Amit Raj</a> · <a href=\"https://profiles.wordpress.org/ammarmassoud/\">Ammar Mohamed Fath Allah Abd-Elaaty Massoud</a> · <a href=\"https://profiles.wordpress.org/amolebonde/\">amolebonde</a> · <a href=\"https://profiles.wordpress.org/anandraj346/\">Anand Raj</a> · <a href=\"https://profiles.wordpress.org/anlino/\">Anders Nor&#233;n</a> · <a href=\"https://profiles.wordpress.org/afercia/\">Andrea Fercia</a> · <a href=\"https://profiles.wordpress.org/awetz583/\">Andrea Roenning</a> · <a href=\"https://profiles.wordpress.org/bowedk/\">Andreas Pedersen</a> · <a href=\"https://profiles.wordpress.org/andraganescu/\">Andrei Draganescu</a> · <a href=\"https://profiles.wordpress.org/euthelup/\">Andrei Lupu</a> · <a href=\"https://profiles.wordpress.org/nacin/\">Andrew Nacin</a> · <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a> · <a href=\"https://profiles.wordpress.org/andrewserong/\">Andrew Serong</a> · <a href=\"https://profiles.wordpress.org/andrewssanya/\">Andrew Ssanya</a> · <a href=\"https://profiles.wordpress.org/rarst/\">Andrey \"Rarst\" Savchenko</a> · <a href=\"https://profiles.wordpress.org/oandregal/\">André Maneiro</a> · <a href=\"https://profiles.wordpress.org/afragen/\">Andy Fragen</a> · <a href=\"https://profiles.wordpress.org/rilwis/\">Anh Tran</a> · <a href=\"https://profiles.wordpress.org/wpgurudev/\">Ankit Gade</a> · <a href=\"https://profiles.wordpress.org/ankit-k-gupta/\">Ankit K Gupta</a> · <a href=\"https://profiles.wordpress.org/ankitkumarshah/\">Ankit Kumar Shah</a> · <a href=\"https://profiles.wordpress.org/ankitmaru/\">Ankit Panchal</a> · <a href=\"https://profiles.wordpress.org/ankitpatel1578/\">Ankit Patel</a> · <a href=\"https://profiles.wordpress.org/anmolverma404/\">Anmol Verma</a> · <a href=\"https://profiles.wordpress.org/annchichi/\">annchichi</a> · <a href=\"https://profiles.wordpress.org/annebovelett/\">Anne-Mieke Bovelett</a> · <a href=\"https://profiles.wordpress.org/annezazu/\">annezazu</a> · <a href=\"https://profiles.wordpress.org/antpb/\">Anthony Burchell</a> · <a href=\"https://profiles.wordpress.org/ahortin/\">Anthony Hortin</a> · <a href=\"https://profiles.wordpress.org/antonvlasenko/\">Anton Vlasenko</a> · <a href=\"https://profiles.wordpress.org/anujrathore24/\">Anuj Singh</a> · <a href=\"https://profiles.wordpress.org/anveshika/\">Anveshika Srivastava</a> · <a href=\"https://profiles.wordpress.org/aristath/\">Ari Stathopoulos</a> · <a href=\"https://profiles.wordpress.org/arielmaidana/\">Ariel Maidana</a> · <a href=\"https://profiles.wordpress.org/arnaudbroes/\">arnaudbroes</a> · <a href=\"https://profiles.wordpress.org/arnoutblueshell/\">arnoutblueshell</a> · <a href=\"https://profiles.wordpress.org/artemiosans/\">Artemio Morales</a> · <a href=\"https://profiles.wordpress.org/mohonchandra/\">Asish Chandra Mohon</a> · <a href=\"https://profiles.wordpress.org/auareyou/\">Au</a> · <a href=\"https://profiles.wordpress.org/autotutorial/\">autotutorial</a> · <a href=\"https://profiles.wordpress.org/ayeshrajans/\">Ayesh Karunaratne</a> · <a href=\"https://profiles.wordpress.org/azharderaiya/\">Azhar Deraiya</a> · <a href=\"https://profiles.wordpress.org/beryldlg/\">B&#233;ryl de La Grandi&#232;re</a> · <a href=\"https://profiles.wordpress.org/back2backdvm/\">back2backdvm</a> · <a href=\"https://profiles.wordpress.org/neo2k23/\">BackuPs</a> · <a href=\"https://profiles.wordpress.org/balub/\">Balu B</a> · <a href=\"https://profiles.wordpress.org/barry/\">Barry</a> · <a href=\"https://profiles.wordpress.org/bayejid00/\">Bayejid Ahmed</a> · <a href=\"https://profiles.wordpress.org/beafialho/\">Beatriz Fialho</a> · <a href=\"https://profiles.wordpress.org/benharri/\">ben</a> · <a href=\"https://profiles.wordpress.org/scruffian/\">Ben Dwyer</a> · <a href=\"https://profiles.wordpress.org/bsutcliffe/\">Ben Sutcliffe</a> · <a href=\"https://profiles.wordpress.org/benazeer/\">Benazeer</a> · <a href=\"https://profiles.wordpress.org/benniledl/\">Benedikt Ledl</a> · <a href=\"https://profiles.wordpress.org/benjamin_zekavica/\">Benjamin Zekavica</a> · <a href=\"https://profiles.wordpress.org/benoitchantre/\">Benoit Chantre</a> · <a href=\"https://profiles.wordpress.org/bernhard-reiter/\">bernhard-reiter</a> · <a href=\"https://profiles.wordpress.org/berislavgrgicak/\">Bero</a> · <a href=\"https://profiles.wordpress.org/bgermann/\">bgermann</a> · <a href=\"https://profiles.wordpress.org/albatross10/\">Bhavik Kalpesh</a> · <a href=\"https://profiles.wordpress.org/bijit027/\">Bijit Deb</a> · <a href=\"https://profiles.wordpress.org/birgire/\">Birgir Erlendsson (birgire)</a> · <a href=\"https://profiles.wordpress.org/bph/\">Birgit Pauli-Haack</a> · <a href=\"https://profiles.wordpress.org/rainynewt/\">Bishal Shrestha</a> · <a href=\"https://profiles.wordpress.org/bjornw/\">BjornW</a> · <a href=\"https://profiles.wordpress.org/bluantinoo/\">bluantinoo</a> · <a href=\"https://profiles.wordpress.org/bogdanungureanu/\">BogdanUngureanu</a> · <a href=\"https://profiles.wordpress.org/bor0/\">Boro Sitnikovski</a> · <a href=\"https://profiles.wordpress.org/veryard/\">Brad</a> · <a href=\"https://profiles.wordpress.org/bjorsch/\">Brad Jorsch</a> · <a href=\"https://profiles.wordpress.org/bradleyt/\">Bradley Taylor</a> · <a href=\"https://profiles.wordpress.org/bhubbard/\">Brandon Hubbard</a> · <a href=\"https://profiles.wordpress.org/bpayton/\">Brandon Payton</a> · <a href=\"https://profiles.wordpress.org/brettsmason/\">brettsmason</a> · <a href=\"https://profiles.wordpress.org/brevilo/\">brevilo</a> · <a href=\"https://profiles.wordpress.org/ironprogrammer/\">Brian Alexander</a> · <a href=\"https://profiles.wordpress.org/bacoords/\">Brian Coords</a> · <a href=\"https://profiles.wordpress.org/masteradhoc/\">Brian Haas</a> · <a href=\"https://profiles.wordpress.org/bronsonquick/\">Bronson Quick</a> · <a href=\"https://profiles.wordpress.org/bschneidewind/\">Bryan Schneidewind</a> · <a href=\"https://profiles.wordpress.org/burakkaptan/\">burak</a> · <a href=\"https://profiles.wordpress.org/burnuser/\">burnuser</a> · <a href=\"https://profiles.wordpress.org/snicco/\">Calvin Alkan</a> · <a href=\"https://profiles.wordpress.org/calvinalkan/\">Calvin Alkan</a> · <a href=\"https://profiles.wordpress.org/cbravobernal/\">Carlos Bravo</a> · <a href=\"https://profiles.wordpress.org/poena/\">Carolina Nymark</a> · <a href=\"https://profiles.wordpress.org/cbirdsong/\">cbirdsong</a> · <a href=\"https://profiles.wordpress.org/cgastrell/\">cgastrell</a> · <a href=\"https://profiles.wordpress.org/charleslf/\">charleslf</a> · <a href=\"https://profiles.wordpress.org/mel_cha/\">chiilog (Chiaki Okamoto)</a> · <a href=\"https://profiles.wordpress.org/chintanmachhi207/\">chintanmachhi207</a> · <a href=\"https://profiles.wordpress.org/chrico/\">ChriCo</a> · <a href=\"https://profiles.wordpress.org/chriscct7/\">chriscct7</a> · <a href=\"https://profiles.wordpress.org/chrisdotdotdot/\">chrisdotdotdot</a> · <a href=\"https://profiles.wordpress.org/apermo/\">Christoph Daum</a> · <a href=\"https://profiles.wordpress.org/claimableperch/\">claimableperch</a> · <a href=\"https://profiles.wordpress.org/claudiulodro/\">Claudiu Lodromanean</a> · <a href=\"https://profiles.wordpress.org/codebymikey/\">codebymikey</a> · <a href=\"https://profiles.wordpress.org/codersantosh/\">codersantosh</a> · <a href=\"https://profiles.wordpress.org/costdev/\">Colin Stewart</a> · <a href=\"https://profiles.wordpress.org/colind/\">ColinD</a> · <a href=\"https://profiles.wordpress.org/colinleroy/\">colinleroy</a> · <a href=\"https://profiles.wordpress.org/coreyw/\">Corey Worrell</a> · <a href=\"https://profiles.wordpress.org/courane01/\">Courtney Robertson</a> · <a href=\"https://profiles.wordpress.org/cbusquets1989/\">Cris Busquets</a> · <a href=\"https://profiles.wordpress.org/mitogh/\">Crisoforo Gaspar</a> · <a href=\"https://profiles.wordpress.org/ctienshi/\">ctienshi</a> · <a href=\"https://profiles.wordpress.org/cweiske/\">cweiske</a> · <a href=\"https://profiles.wordpress.org/didierjm/\">cybeardjm</a> · <a href=\"https://profiles.wordpress.org/coquardcyr/\">Cyrille</a> · <a href=\"https://profiles.wordpress.org/css31/\">Cyrille Sanson</a> · <a href=\"https://profiles.wordpress.org/daedalon/\">Daedalon</a> · <a href=\"https://profiles.wordpress.org/acketon/\">Dakota Chichester</a> · <a href=\"https://profiles.wordpress.org/dalleyne/\">Damien Alleyne</a> · <a href=\"https://profiles.wordpress.org/colorful-tones/\">Damon Cook</a> · <a href=\"https://profiles.wordpress.org/dpknauss/\">Dan Knauss</a> · <a href=\"https://profiles.wordpress.org/danht/\">danht</a> · <a href=\"https://profiles.wordpress.org/daniguardiola/\">Dani Guardiola</a> · <a href=\"https://profiles.wordpress.org/danielbachhuber/\">Daniel Bachhuber</a> · <a href=\"https://profiles.wordpress.org/danielpost/\">Daniel Post</a> · <a href=\"https://profiles.wordpress.org/talldanwp/\">Daniel Richards</a> · <a href=\"https://profiles.wordpress.org/mte90/\">Daniele Scasciafratte</a> · <a href=\"https://profiles.wordpress.org/danielpataki/\">danielpataki</a> · <a href=\"https://profiles.wordpress.org/danielvann/\">danielvann</a> · <a href=\"https://profiles.wordpress.org/darerodz/\">darerodz</a> · <a href=\"https://profiles.wordpress.org/dkotter/\">Darin Kotter</a> · <a href=\"https://profiles.wordpress.org/dhewercorus/\">Darren Hewer</a> · <a href=\"https://profiles.wordpress.org/davelo/\">Dave Loodts</a> · <a href=\"https://profiles.wordpress.org/davilera/\">David Aguilera</a> · <a href=\"https://profiles.wordpress.org/darnado/\">David Arnado</a> · <a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a> · <a href=\"https://profiles.wordpress.org/davidbinda/\">David Biňovec</a> · <a href=\"https://profiles.wordpress.org/davidabowman/\">David Bowman</a> · <a href=\"https://profiles.wordpress.org/dpcalhoun/\">David Calhoun</a> · <a href=\"https://profiles.wordpress.org/dafargier/\">David FARGIER</a> · <a href=\"https://profiles.wordpress.org/dlh/\">David Herrera</a> · <a href=\"https://profiles.wordpress.org/david-innes/\">David Innes</a> · <a href=\"https://profiles.wordpress.org/justlevine/\">David Levine</a> · <a href=\"https://profiles.wordpress.org/daviedr/\">David Rozando</a> · <a href=\"https://profiles.wordpress.org/dshanske/\">David Shanske</a> · <a href=\"https://profiles.wordpress.org/get_dave/\">David Smith</a> · <a href=\"https://profiles.wordpress.org/daymobrew/\">daymobrew</a> · <a href=\"https://profiles.wordpress.org/deadduck169/\">deadduck169</a> · <a href=\"https://profiles.wordpress.org/dsas/\">Dean Sas</a> · <a href=\"https://profiles.wordpress.org/dkarfa/\">Debabrata Karfa</a> · <a href=\"https://profiles.wordpress.org/debarghyabanerjee/\">DEBARGHYA BANERJEE</a> · <a href=\"https://profiles.wordpress.org/deeppatel8950/\">Deep Patel</a> · <a href=\"https://profiles.wordpress.org/deepakrohilla/\">Deepak Rohilla</a> · <a href=\"https://profiles.wordpress.org/realloc/\">Dennis Ploetner</a> · <a href=\"https://profiles.wordpress.org/dmsnell/\">Dennis Snell</a> · <a href=\"https://profiles.wordpress.org/densinakum/\">Densi Nakum</a> · <a href=\"https://profiles.wordpress.org/designsimply/\">designsimply</a> · <a href=\"https://profiles.wordpress.org/devansh2002/\">Devansh Chaudhary</a> · <a href=\"https://profiles.wordpress.org/dhananjaykuber/\">Dhananjay Kuber</a> · <a href=\"https://profiles.wordpress.org/dharm1025/\">Dharmesh Patel</a> · <a href=\"https://profiles.wordpress.org/dhavalkapadane/\">Dhaval Kapadane</a> · <a href=\"https://profiles.wordpress.org/dheeraj2995/\">Dheeraj Bhosale</a> · <a href=\"https://profiles.wordpress.org/dhrumilk/\">Dhrumil Kumbhani</a> · <a href=\"https://profiles.wordpress.org/dhruvang21/\">Dhruvang21</a> · <a href=\"https://profiles.wordpress.org/dhruvishah2203/\">Dhruvi Shah</a> · <a href=\"https://profiles.wordpress.org/dhruvik18/\">Dhruvik Malaviya</a> · <a href=\"https://profiles.wordpress.org/diguj/\">Digvijay Zite</a> · <a href=\"https://profiles.wordpress.org/dilipom13/\">dilip</a> · <a href=\"https://profiles.wordpress.org/dilipbheda/\">Dilip Bheda</a> · <a href=\"https://profiles.wordpress.org/diliphingarajiya/\">Dilip Hingarajiya</a> · <a href=\"https://profiles.wordpress.org/dilip2615/\">Dilip Modhavadiya</a> · <a href=\"https://profiles.wordpress.org/dingguodong/\">DingGuodong</a> · <a href=\"https://profiles.wordpress.org/dd32/\">Dion Hulse</a> · <a href=\"https://profiles.wordpress.org/divyeshk71/\">Divyesh_kakrecha</a> · <a href=\"https://profiles.wordpress.org/djcowan/\">dj.cowan</a> · <a href=\"https://profiles.wordpress.org/mediaformat/\">Django</a> · <a href=\"https://profiles.wordpress.org/dnnsjsk/\">dnnsjsk</a> · <a href=\"https://profiles.wordpress.org/doekenorg/\">Doeke Norg</a> · <a href=\"https://profiles.wordpress.org/dogee/\">dogee</a> · <a href=\"https://profiles.wordpress.org/domenicdenicola/\">domenicdenicola</a> · <a href=\"https://profiles.wordpress.org/ocean90/\">Dominik Schilling</a> · <a href=\"https://profiles.wordpress.org/donalirl/\">donalirl</a> · <a href=\"https://profiles.wordpress.org/dooperweb/\">dooperweb</a> · <a href=\"https://profiles.wordpress.org/dougwollison/\">Doug Wollison</a> · <a href=\"https://profiles.wordpress.org/dretzlaff/\">dretzlaff</a> · <a href=\"https://profiles.wordpress.org/drewapicture/\">Drew Jaynes</a> · <a href=\"https://profiles.wordpress.org/drivingralle/\">Drivingralle</a> · <a href=\"https://profiles.wordpress.org/dwainm/\">Dwain Maralack</a> · <a href=\"https://profiles.wordpress.org/earthman100/\">Earthman Media</a> · <a href=\"https://profiles.wordpress.org/eclev91/\">eclev91</a> · <a href=\"https://profiles.wordpress.org/eddystile/\">Eddy</a> · <a href=\"https://profiles.wordpress.org/cais/\">Edward Caissie</a> · <a href=\"https://profiles.wordpress.org/eceleste/\">efc</a> · <a href=\"https://profiles.wordpress.org/talksina/\">Elena Brescacin</a> · <a href=\"https://profiles.wordpress.org/elizaan36/\">elizaan36</a> · <a href=\"https://profiles.wordpress.org/ellatrix/\">Ella van Durpe</a> · <a href=\"https://profiles.wordpress.org/codex-m/\">Emerson Maningo</a> · <a href=\"https://profiles.wordpress.org/emlebrun/\">Emilie LEBRUN</a> · <a href=\"https://profiles.wordpress.org/eatse/\">Emmanuel Ats&#233;</a> · <a href=\"https://profiles.wordpress.org/lopo/\">Enrico Battocchi</a> · <a href=\"https://profiles.wordpress.org/ericdye/\">Eric Dye</a> · <a href=\"https://profiles.wordpress.org/ethitter/\">Erick Hitter</a> · <a href=\"https://profiles.wordpress.org/codekraft/\">Erik</a> · <a href=\"https://profiles.wordpress.org/kebbet/\">Erik</a> · <a href=\"https://profiles.wordpress.org/im3dabasia1/\">Eshaan Dabasiya</a> · <a href=\"https://profiles.wordpress.org/estelaris/\">Estela Rueda</a> · <a href=\"https://profiles.wordpress.org/eherman24/\">Evan Herman</a> · <a href=\"https://profiles.wordpress.org/etobiesen/\">Even Tobiesen</a> · <a href=\"https://profiles.wordpress.org/fabiankaegy/\">Fabian Kägy</a> · <a href=\"https://profiles.wordpress.org/gaambo/\">Fabian Todt</a> · <a href=\"https://profiles.wordpress.org/faisalahammad/\">Faisal Ahammad</a> · <a href=\"https://profiles.wordpress.org/faisal03/\">Faisal Alvi</a> · <a href=\"https://profiles.wordpress.org/fazyshah/\">Faizan Nabi</a> · <a href=\"https://profiles.wordpress.org/flixos90/\">Felix Arntz</a> · <a href=\"https://profiles.wordpress.org/ffffelix/\">Felix Renicks</a> · <a href=\"https://profiles.wordpress.org/finntown/\">finntown</a> · <a href=\"https://profiles.wordpress.org/firoz2456/\">Firoz Sabaliya</a> · <a href=\"https://profiles.wordpress.org/francina/\">Francesca Marano</a> · <a href=\"https://profiles.wordpress.org/franciscabusas22/\">Francis Cabusas</a> · <a href=\"https://profiles.wordpress.org/fcoveram/\">Francisco</a> · <a href=\"https://profiles.wordpress.org/frankbiganski/\">Frank B.</a> · <a href=\"https://profiles.wordpress.org/frank-klein/\">Frank Klein</a> · <a href=\"https://profiles.wordpress.org/franz00/\">Fransisca H</a> · <a href=\"https://profiles.wordpress.org/frkly/\">frkly</a> · <a href=\"https://profiles.wordpress.org/fushar/\">fushar</a> · <a href=\"https://profiles.wordpress.org/fxbenard/\">FX B&#233;nard</a> · <a href=\"https://profiles.wordpress.org/gaellebesson/\">gaellebesson</a> · <a href=\"https://profiles.wordpress.org/gajendrasingh/\">Gajendra Singh</a> · <a href=\"https://profiles.wordpress.org/galibh/\">Galib Hayder</a> · <a href=\"https://profiles.wordpress.org/ecgan/\">Gan Eng Chin</a> · <a href=\"https://profiles.wordpress.org/garrett-eclipse/\">Garrett Hyder</a> · <a href=\"https://profiles.wordpress.org/garyj/\">Gary Jones</a> · <a href=\"https://profiles.wordpress.org/pento/\">Gary Pendergast</a> · <a href=\"https://profiles.wordpress.org/soulseekah/\">Gennady Kovshenin</a> · <a href=\"https://profiles.wordpress.org/mamaduka/\">George Mamadashvili</a> · <a href=\"https://profiles.wordpress.org/geriux/\">Gerardo Pacheco</a> · <a href=\"https://profiles.wordpress.org/ghinamt/\">ghinamt</a> · <a href=\"https://profiles.wordpress.org/girishpanchal/\">Girish Panchal</a> · <a href=\"https://profiles.wordpress.org/giuriani/\">giuriani</a> · <a href=\"https://profiles.wordpress.org/glendaviesnz/\">Glen Davies</a> · <a href=\"https://profiles.wordpress.org/glynnquelch/\">Glynn Quelch</a> · <a href=\"https://profiles.wordpress.org/ingeniumed/\">Gopal Krishnan</a> · <a href=\"https://profiles.wordpress.org/grantmkin/\">Grant M. Kinney</a> · <a href=\"https://profiles.wordpress.org/gziolo/\">Greg Ziółkowski</a> · <a href=\"https://profiles.wordpress.org/gregbenz/\">gregbenz</a> · <a href=\"https://profiles.wordpress.org/grgarside/\">grgarside</a> · <a href=\"https://profiles.wordpress.org/growwbuddy/\">GrowwBuddy</a> · <a href=\"https://profiles.wordpress.org/guido07111975/\">Guido</a> · <a href=\"https://profiles.wordpress.org/guillaumeturpin/\">Guillaume TURPIN</a> · <a href=\"https://profiles.wordpress.org/gulamdastgir04/\">Gulamdastgir Momin</a> · <a href=\"https://profiles.wordpress.org/priethor/\">H&#233;ctor Prieto</a> · <a href=\"https://profiles.wordpress.org/gencmedya/\">Halil Kaya</a> · <a href=\"https://profiles.wordpress.org/yahaly/\">Halyna Yampolska</a> · <a href=\"https://profiles.wordpress.org/hameem1102/\">Hameem Mahdad Kader</a> · <a href=\"https://profiles.wordpress.org/hanneslsm/\">Hannes Leismann</a> · <a href=\"https://profiles.wordpress.org/hage/\">Hans-Gerd Gerhards</a> · <a href=\"https://profiles.wordpress.org/hardipparmar/\">Hardip Parmar</a> · <a href=\"https://profiles.wordpress.org/hareesh-pillai/\">Hareesh S</a> · <a href=\"https://profiles.wordpress.org/harishanker/\">Hari Shanker R</a> · <a href=\"https://profiles.wordpress.org/harrym/\">harrym</a> · <a href=\"https://profiles.wordpress.org/harshalkadu/\">Harshal Kadu</a> · <a href=\"https://profiles.wordpress.org/hazdiego/\">Haz</a> · <a href=\"https://profiles.wordpress.org/hekuranredev/\">hekuranredev</a> · <a href=\"https://profiles.wordpress.org/helen/\">Helen Hou-Sandi</a> · <a href=\"https://profiles.wordpress.org/hdkothari81/\">Hemant Kothari</a> · <a href=\"https://profiles.wordpress.org/iamarinoh/\">Henrique Iamarino</a> · <a href=\"https://profiles.wordpress.org/henrywright/\">Henry Wright</a> · <a href=\"https://profiles.wordpress.org/rvouill/\">Herve THOMAS</a> · <a href=\"https://profiles.wordpress.org/hideishi/\">hideishi</a> · <a href=\"https://profiles.wordpress.org/kurudrive/\">Hidekazu Ishikawa</a> · <a href=\"https://profiles.wordpress.org/hilayt24/\">Hilay Trivedi</a> · <a href=\"https://profiles.wordpress.org/panchalhimani711/\">Himani Panchal</a> · <a href=\"https://profiles.wordpress.org/abcd95/\">Himanshu Pathak</a> · <a href=\"https://profiles.wordpress.org/hbhalodia/\">Hit Bhalodia</a> · <a href=\"https://profiles.wordpress.org/hitendra-chopda/\">Hitendra Chopda</a> · <a href=\"https://profiles.wordpress.org/hiteshhuptechweb/\">Hitesh Dhokai</a> · <a href=\"https://profiles.wordpress.org/hovhanneshovakimyan/\">Hovhannes Hovakimyan</a> · <a href=\"https://profiles.wordpress.org/hueitan/\">hueitan</a> · <a href=\"https://profiles.wordpress.org/humanify/\">humanify</a> · <a href=\"https://profiles.wordpress.org/hussain896/\">hussain896</a> · <a href=\"https://profiles.wordpress.org/huubl/\">huubl</a> · <a href=\"https://profiles.wordpress.org/huzaifaalmesbah/\">Huzaifa Al Mesbah</a> · <a href=\"https://profiles.wordpress.org/iandunn/\">Ian Dunn</a> · <a href=\"https://profiles.wordpress.org/ilovecats7/\">ilovecats7</a> · <a href=\"https://profiles.wordpress.org/imranhasanraaz/\">Imran</a> · <a href=\"https://profiles.wordpress.org/imranh920/\">Imran Hossain (a11n)</a> · <a href=\"https://profiles.wordpress.org/indirabiswas27/\">Indira Biswas</a> · <a href=\"https://profiles.wordpress.org/indithemes/\">indithemes</a> · <a href=\"https://profiles.wordpress.org/isabel_brison/\">Isabel Brison</a> · <a href=\"https://profiles.wordpress.org/iseulde/\">iseulde</a> · <a href=\"https://profiles.wordpress.org/isuke01/\">Isu</a> · <a href=\"https://profiles.wordpress.org/ivankristianto/\">Ivan Kristianto</a> · <a href=\"https://profiles.wordpress.org/moxie/\">Jack</a> · <a href=\"https://profiles.wordpress.org/jagirbahesh/\">Jagir Bahesh</a> · <a href=\"https://profiles.wordpress.org/jainil07/\">Jainil Shah</a> · <a href=\"https://profiles.wordpress.org/whyisjake/\">Jake Spurlock</a> · <a href=\"https://profiles.wordpress.org/jameskoster/\">James Koster</a> · <a href=\"https://profiles.wordpress.org/jhmonroe/\">James Monroe</a> · <a href=\"https://profiles.wordpress.org/jopdop30/\">James Payne</a> · <a href=\"https://profiles.wordpress.org/imaginarymedia/\">James Robinson</a> · <a href=\"https://profiles.wordpress.org/q0rban/\">James Sansbury</a> · <a href=\"https://profiles.wordpress.org/jamieblomerus/\">Jamie Blomerus</a> · <a href=\"https://profiles.wordpress.org/jammycakes/\">jammycakes</a> · <a href=\"https://profiles.wordpress.org/lysyjan87/\">Jan Lys&#253;</a> · <a href=\"https://profiles.wordpress.org/janak007/\">janak Kaneriya</a> · <a href=\"https://profiles.wordpress.org/janusdev/\">janusdev</a> · <a href=\"https://profiles.wordpress.org/jsnajdr/\">Jarda Snajdr</a> · <a href=\"https://profiles.wordpress.org/jarekmorawski/\">jarekmorawski</a> · <a href=\"https://profiles.wordpress.org/boogah/\">Jason Cosper</a> · <a href=\"https://profiles.wordpress.org/madtownlems/\">Jason LeMahieu (MadtownLems)</a> · <a href=\"https://profiles.wordpress.org/jasonsa19/\">Jason Sauerwald</a> · <a href=\"https://profiles.wordpress.org/javiercasares/\">Javier Casares</a> · <a href=\"https://profiles.wordpress.org/shovan_jaya/\">Jayaram</a> · <a href=\"https://profiles.wordpress.org/jdahir0789/\">JD Ahir</a> · <a href=\"https://profiles.wordpress.org/jdnd/\">jdnd</a> · <a href=\"https://profiles.wordpress.org/audrasjb/\">Jean-Baptiste Audras</a> · <a href=\"https://profiles.wordpress.org/krokodok/\">Jeff Chi</a> · <a href=\"https://profiles.wordpress.org/maverick3x6/\">Jeff Golenski</a> · <a href=\"https://profiles.wordpress.org/jffng/\">Jeff Ong</a> · <a href=\"https://profiles.wordpress.org/jeffpaul/\">Jeff Paul</a> · <a href=\"https://profiles.wordpress.org/jeflopodev/\">jeflopo</a> · <a href=\"https://profiles.wordpress.org/jdy68/\">Jenny Dupuy</a> · <a href=\"https://profiles.wordpress.org/jepperask/\">jepperask</a> · <a href=\"https://profiles.wordpress.org/jeremyfelt/\">Jeremy Felt</a> · <a href=\"https://profiles.wordpress.org/jeremy80/\">jeremy80</a> · <a href=\"https://profiles.wordpress.org/jeremyroman/\">jeremyroman</a> · <a href=\"https://profiles.wordpress.org/jeryj/\">jeryj</a> · <a href=\"https://profiles.wordpress.org/jessedyck/\">jessedyck</a> · <a href=\"https://profiles.wordpress.org/luminuu/\">Jessica Lyschik</a> · <a href=\"https://profiles.wordpress.org/jigar-bhanushali/\">Jigar Bhanushali</a> · <a href=\"https://profiles.wordpress.org/jigar9998/\">Jigar Panchal</a> · <a href=\"https://profiles.wordpress.org/jnweaver/\">jnweaver</a> · <a href=\"https://profiles.wordpress.org/jartes/\">Joan Artes</a> · <a href=\"https://profiles.wordpress.org/jodamo5/\">jodamo5</a> · <a href=\"https://profiles.wordpress.org/joedolson/\">Joe Dolson</a> · <a href=\"https://profiles.wordpress.org/joehoyle/\">Joe Hoyle</a> · <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a> · <a href=\"https://profiles.wordpress.org/joecsmalley/\">joecsmalley</a> · <a href=\"https://profiles.wordpress.org/joen/\">Joen Asmussen</a> · <a href=\"https://profiles.wordpress.org/timse201/\">Johannes J&#252;lg</a> · <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a> · <a href=\"https://profiles.wordpress.org/johnjamesjacoby/\">John James Jacoby</a> · <a href=\"https://profiles.wordpress.org/johnregan3/\">John Regan</a> · <a href=\"https://profiles.wordpress.org/arrcorona/\">Jomar Jay Corona</a> · <a href=\"https://profiles.wordpress.org/jomonthomaslobo1/\">Jomon Thomas Lobo</a> · <a href=\"https://profiles.wordpress.org/jonsurrell/\">Jon Surrell</a> · <a href=\"https://profiles.wordpress.org/psykro/\">Jonathan Bossenger</a> · <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a> · <a href=\"https://profiles.wordpress.org/jongycastillo/\">Jong</a> · <a href=\"https://profiles.wordpress.org/n2erjo00/\">Joni Erkkil&#228;</a> · <a href=\"https://profiles.wordpress.org/spacedmonkey/\">Jonny Harris</a> · <a href=\"https://profiles.wordpress.org/jonnyauk/\">jonnyauk</a> · <a href=\"https://profiles.wordpress.org/joomskys/\">joomskys</a> · <a href=\"https://profiles.wordpress.org/joostdevalk/\">Joost de Valk</a> · <a href=\"https://profiles.wordpress.org/jordesign/\">jordesign</a> · <a href=\"https://profiles.wordpress.org/jorgefilipecosta/\">Jorge Costa</a> · <a href=\"https://profiles.wordpress.org/josvelasco/\">Jos Velasco</a> · <a href=\"https://profiles.wordpress.org/josevarghese/\">Jose Varghese</a> · <a href=\"https://profiles.wordpress.org/blogitsolutions/\">Josef Seidl</a> · <a href=\"https://profiles.wordpress.org/josephscott/\">Joseph Scott</a> · <a href=\"https://profiles.wordpress.org/joshuawold/\">Joshua Wold</a> · <a href=\"https://profiles.wordpress.org/jottevanger/\">jottevanger</a> · <a href=\"https://profiles.wordpress.org/jokanane/\">Jouni Kananen</a> · <a href=\"https://profiles.wordpress.org/joyously/\">Joy</a> · <a href=\"https://profiles.wordpress.org/juanfra/\">Juan Aldasoro</a> · <a href=\"https://profiles.wordpress.org/juanbuis/\">juanbuis</a> · <a href=\"https://profiles.wordpress.org/juanmaguitar/\">JuanMa Garrido</a> · <a href=\"https://profiles.wordpress.org/juanwp22/\">juanwp22</a> · <a href=\"https://profiles.wordpress.org/jules-colle/\">Jules Colle</a> · <a href=\"https://profiles.wordpress.org/julianmar/\">julianmar</a> · <a href=\"https://profiles.wordpress.org/juliemoynat/\">Julie Moynat</a> · <a href=\"https://profiles.wordpress.org/jrf/\">Juliette Reinders Folmer</a> · <a href=\"https://profiles.wordpress.org/juliobox/\">Julio Potier</a> · <a href=\"https://profiles.wordpress.org/greenshady/\">Justin Tadlock</a> · <a href=\"https://profiles.wordpress.org/juzar/\">Juzar</a> · <a href=\"https://profiles.wordpress.org/kadamwhite/\">K. Adam White</a> · <a href=\"https://profiles.wordpress.org/kafleg/\">KafleG</a> · <a href=\"https://profiles.wordpress.org/kevin940726/\">Kai Hao</a> · <a href=\"https://profiles.wordpress.org/kaitohm/\">Kaito Hanamori</a> · <a href=\"https://profiles.wordpress.org/ikamal/\">Kamal Hosen</a> · <a href=\"https://profiles.wordpress.org/kapasias/\">KAP ASIAs</a> · <a href=\"https://profiles.wordpress.org/kapilpaul/\">Kapil Paul</a> · <a href=\"https://profiles.wordpress.org/karlgroves/\">karlgroves</a> · <a href=\"https://profiles.wordpress.org/karolmanijak/\">Karol Manijak</a> · <a href=\"https://profiles.wordpress.org/karthickmurugan/\">Karthick Murugan</a> · <a href=\"https://profiles.wordpress.org/thekt12/\">Karthik Thayyil</a> · <a href=\"https://profiles.wordpress.org/karthikeya01/\">Karthikeya Bethu</a> · <a href=\"https://profiles.wordpress.org/kasparsd/\">Kaspars</a> · <a href=\"https://profiles.wordpress.org/zoonini/\">Kathryn Presner</a> · <a href=\"https://profiles.wordpress.org/kausaralm/\">Kausar Alam</a> · <a href=\"https://profiles.wordpress.org/keithdevon/\">keithdevon</a> · <a href=\"https://profiles.wordpress.org/kel-dc/\">Kel Santiago-Pilarski</a> · <a href=\"https://profiles.wordpress.org/ryelle/\">Kelly Choyce-Dwan</a> · <a href=\"https://profiles.wordpress.org/tinypixel/\">Kelly Mears</a> · <a href=\"https://profiles.wordpress.org/keoshi/\">keoshi</a> · <a href=\"https://profiles.wordpress.org/ketanniruke/\">Ketan Niruke</a> · <a href=\"https://profiles.wordpress.org/patelketan/\">Ketan Patel</a> · <a href=\"https://profiles.wordpress.org/kevinlearynet/\">Kevinleary.net</a> · <a href=\"https://profiles.wordpress.org/kharisblank/\">Kharis Sulistiyono</a> · <a href=\"https://profiles.wordpress.org/kirasong/\">Kira Schroder</a> · <a href=\"https://profiles.wordpress.org/kjroelke/\">KJ Roelke</a> · <a href=\"https://profiles.wordpress.org/kkmuffme/\">kkmuffme</a> · <a href=\"https://profiles.wordpress.org/knutsp/\">Knut Sparhell</a> · <a href=\"https://profiles.wordpress.org/kohheepeace/\">kohheepeace</a> · <a href=\"https://profiles.wordpress.org/kmgalanakis/\">Konstantinos Galanakis</a> · <a href=\"https://profiles.wordpress.org/xkon/\">Konstantinos Xenos</a> · <a href=\"https://profiles.wordpress.org/kristastevens/\">kristastevens</a> · <a href=\"https://profiles.wordpress.org/krupajnanda/\">Krupa Nanda</a> · <a href=\"https://profiles.wordpress.org/krupaly2k/\">Krupal Lakhia</a> · <a href=\"https://profiles.wordpress.org/laurelfulford/\">laurelfulford</a> · <a href=\"https://profiles.wordpress.org/wplmillet/\">Laurent MILLET</a> · <a href=\"https://profiles.wordpress.org/lakshmananphp/\">Lax Mariappan</a> · <a href=\"https://profiles.wordpress.org/laxman-prajapati/\">Laxman Prajapati</a> · <a href=\"https://profiles.wordpress.org/lcarevic/\">lcarevic</a> · <a href=\"https://profiles.wordpress.org/leecollings/\">Lee</a> · <a href=\"https://profiles.wordpress.org/leewillis77/\">Lee Willis</a> · <a href=\"https://profiles.wordpress.org/leedxw/\">leedxw</a> · <a href=\"https://profiles.wordpress.org/0mirka00/\">Lena Morita</a> · <a href=\"https://profiles.wordpress.org/lenasterg/\">lenasterg</a> · <a href=\"https://profiles.wordpress.org/leszeks/\">leszeks</a> · <a href=\"https://profiles.wordpress.org/leup/\">leup</a> · <a href=\"https://profiles.wordpress.org/levskipg/\">levskipg</a> · <a href=\"https://profiles.wordpress.org/lgladdy/\">Liam Gladdy</a> · <a href=\"https://profiles.wordpress.org/louislaugesen/\">Louis</a> · <a href=\"https://profiles.wordpress.org/louwie17/\">Lourens</a> · <a href=\"https://profiles.wordpress.org/lovesoni1999/\">Love Soni</a> · <a href=\"https://profiles.wordpress.org/thelovekesh/\">Lovekesh Kumar</a> · <a href=\"https://profiles.wordpress.org/lovewpmu/\">lovewpmu</a> · <a href=\"https://profiles.wordpress.org/lovor/\">Lovro Hrust</a> · <a href=\"https://profiles.wordpress.org/dreadlox/\">Lox</a> · <a href=\"https://profiles.wordpress.org/ltrihan/\">ltrihan</a> · <a href=\"https://profiles.wordpress.org/gigitux/\">Luigi Teschio</a> · <a href=\"https://profiles.wordpress.org/zaguiini/\">Luis Felipe Zaguini</a> · <a href=\"https://profiles.wordpress.org/luisherranz/\">luisherranz</a> · <a href=\"https://profiles.wordpress.org/wpfed/\">Lukasz</a> · <a href=\"https://profiles.wordpress.org/lukecavanagh/\">Luke Cavanagh</a> · <a href=\"https://profiles.wordpress.org/gadelhas/\">M&#225;rio Santos</a> · <a href=\"https://profiles.wordpress.org/maciejmackowiak/\">maciejmackowiak</a> · <a href=\"https://profiles.wordpress.org/madhudollu/\">Madhu Dollu</a> · <a href=\"https://profiles.wordpress.org/madpeter/\">madpeter</a> · <a href=\"https://profiles.wordpress.org/magdarogier/\">Magda Rogier</a> · <a href=\"https://profiles.wordpress.org/onemaggie/\">Maggie Cabrera</a> · <a href=\"https://profiles.wordpress.org/mp518/\">Mahesh Prajapati</a> · <a href=\"https://profiles.wordpress.org/mai21/\">Mai</a> · <a href=\"https://profiles.wordpress.org/maikelraow/\">maikelraow</a> · <a href=\"https://profiles.wordpress.org/travel_girl/\">Maja Benke</a> · <a href=\"https://profiles.wordpress.org/mkrndmane/\">Makarand G. Mane</a> · <a href=\"https://profiles.wordpress.org/tomdxw/\">mallorydxw-old</a> · <a href=\"https://profiles.wordpress.org/manfcarlo/\">manfcarlo</a> · <a href=\"https://profiles.wordpress.org/manojmaharrshi/\">Manoj Maharrshi</a> · <a href=\"https://profiles.wordpress.org/manzoorwanijk/\">Manzoor Wani (a11n)</a> · <a href=\"https://profiles.wordpress.org/mdxfr/\">Marc</a> · <a href=\"https://profiles.wordpress.org/fullofcaffeine/\">Marcelo de Moraes Serpa</a> · <a href=\"https://profiles.wordpress.org/marchalyoan/\">marchalyoan</a> · <a href=\"https://profiles.wordpress.org/afmarchetti/\">Marchetti Design</a> · <a href=\"https://profiles.wordpress.org/mciampini/\">Marco Ciampini</a> · <a href=\"https://profiles.wordpress.org/mariayohana/\">Maria Yohana</a> · <a href=\"https://profiles.wordpress.org/marian1/\">marian1</a> · <a href=\"https://profiles.wordpress.org/nuryko/\">Marianna</a> · <a href=\"https://profiles.wordpress.org/plari/\">Marie</a> · <a href=\"https://profiles.wordpress.org/tyxla/\">Marin Atanasov</a> · <a href=\"https://profiles.wordpress.org/marineevain/\">Marine EVAIN</a> · <a href=\"https://profiles.wordpress.org/nofearinc/\">Mario Peshev</a> · <a href=\"https://profiles.wordpress.org/santosguillamot/\">Mario Santos</a> · <a href=\"https://profiles.wordpress.org/clorith/\">Marius L. J.</a> · <a href=\"https://profiles.wordpress.org/markhowellsmead/\">Mark Howells-Mead</a> · <a href=\"https://profiles.wordpress.org/mapk/\">Mark Uraine</a> · <a href=\"https://profiles.wordpress.org/mark-k/\">Mark-k</a> · <a href=\"https://profiles.wordpress.org/martinkrcho/\">martin.krcho</a> · <a href=\"https://profiles.wordpress.org/marybaum/\">Mary Baum</a> · <a href=\"https://profiles.wordpress.org/4thhubbard/\">Mary Hubbard</a> · <a href=\"https://profiles.wordpress.org/immasud/\">Masud Rana</a> · <a href=\"https://profiles.wordpress.org/paapst/\">Mathieu Paapst</a> · <a href=\"https://profiles.wordpress.org/mmaattiiaass/\">Matias Benedetto</a> · <a href=\"https://profiles.wordpress.org/matveb/\">Matias Ventura</a> · <a href=\"https://profiles.wordpress.org/iammattthomas/\">Matt (Thomas) Miklic</a> · <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a> · <a href=\"https://profiles.wordpress.org/mattyrob/\">Matt Robinson</a> · <a href=\"https://profiles.wordpress.org/mattwest/\">Matt West</a> · <a href=\"https://profiles.wordpress.org/matteoenna/\">Matteo Enna</a> · <a href=\"https://profiles.wordpress.org/kinggmobb/\">Matthew</a> · <a href=\"https://profiles.wordpress.org/mboynes/\">Matthew Boynes</a> · <a href=\"https://profiles.wordpress.org/mattryanwalker/\">mattryanwalker</a> · <a href=\"https://profiles.wordpress.org/azouamauriac/\">Mauriac AZOUA</a> · <a href=\"https://profiles.wordpress.org/maximemeganck/\">Maxime Meganck</a> · <a href=\"https://profiles.wordpress.org/maximebj/\">maximebj</a> · <a href=\"https://profiles.wordpress.org/mayanktripathi32/\">Mayank Tripathi</a> · <a href=\"https://profiles.wordpress.org/mayur8991/\">Mayur Prajapati</a> · <a href=\"https://profiles.wordpress.org/faithcoder/\">Md Abdullah Al Arif</a> · <a href=\"https://profiles.wordpress.org/hmbashar/\">Md Abul Bashar</a> · <a href=\"https://profiles.wordpress.org/itsmhrahman/\">Md Hafijur Rahman</a> · <a href=\"https://profiles.wordpress.org/kawsar007/\">MD Kawsar Chowdhury</a> · <a href=\"https://profiles.wordpress.org/mehdi01/\">Md Mahdi Hasan</a> · <a href=\"https://profiles.wordpress.org/mdibrahimk48/\">Md. Ibrahim Khalil</a> · <a href=\"https://profiles.wordpress.org/najmulsaju/\">Md. Najmul Islam</a> · <a href=\"https://profiles.wordpress.org/mehedi_csit/\">Md.Mehedi Hasan</a> · <a href=\"https://profiles.wordpress.org/mdviralsampat/\">mdviralsampat</a> · <a href=\"https://profiles.wordpress.org/megane9988/\">megane9988</a> · <a href=\"https://profiles.wordpress.org/leeseoftbc/\">MelissaH</a> · <a href=\"https://profiles.wordpress.org/metropolis_john/\">metropolis_john</a> · <a href=\"https://profiles.wordpress.org/mdawaffe/\">Michael Adams (mdawaffe)</a> · <a href=\"https://profiles.wordpress.org/mburridge/\">Michael Burridge</a> · <a href=\"https://profiles.wordpress.org/websiteredev/\">Michael Willman</a> · <a href=\"https://profiles.wordpress.org/czapla/\">Michal Czaplinski</a> · <a href=\"https://profiles.wordpress.org/michelleames/\">Michelle Frechette</a> · <a href=\"https://profiles.wordpress.org/micromadness/\">micromadness</a> · <a href=\"https://profiles.wordpress.org/mcsf/\">Miguel Fonseca</a> · <a href=\"https://profiles.wordpress.org/mmtr86/\">Miguel Torres</a> · <a href=\"https://profiles.wordpress.org/mijotj/\">Mijo T J</a> · <a href=\"https://profiles.wordpress.org/simison/\">Mikael Korpela</a> · <a href=\"https://profiles.wordpress.org/mbijon/\">Mike Bijon</a> · <a href=\"https://profiles.wordpress.org/ritterml/\">Mike Ritter</a> · <a href=\"https://profiles.wordpress.org/mikinc860/\">Mikin Chauhan</a> · <a href=\"https://profiles.wordpress.org/milana_cap/\">Milana Cap</a> · <a href=\"https://profiles.wordpress.org/milindmore22/\">Milind More</a> · <a href=\"https://profiles.wordpress.org/mimitips/\">mimi</a> · <a href=\"https://profiles.wordpress.org/369work/\">miroku</a> · <a href=\"https://profiles.wordpress.org/presstoke/\">Mitchell Austin</a> · <a href=\"https://profiles.wordpress.org/modi2918/\">Modi Sahil</a> · <a href=\"https://profiles.wordpress.org/antwortzeit/\">modulbuero</a> · <a href=\"https://profiles.wordpress.org/aboelfotoh/\">Mohamed Aboelfotoh Mohamed</a> · <a href=\"https://profiles.wordpress.org/mohitdadhich10/\">Mohit Dadhich</a> · <a href=\"https://profiles.wordpress.org/mojorob/\">mojorob</a> · <a href=\"https://profiles.wordpress.org/jucaduca/\">Morais Junior</a> · <a href=\"https://profiles.wordpress.org/mosescursor/\">Moses Cursor Ssebunya</a> · <a href=\"https://profiles.wordpress.org/mosne/\">Mosne / Paolo Tesei</a> · <a href=\"https://profiles.wordpress.org/mr660/\">mr660</a> · <a href=\"https://profiles.wordpress.org/mreishus/\">mreishus</a> · <a href=\"https://profiles.wordpress.org/mrunalkulkarni/\">mrunalkulkarni</a> · <a href=\"https://profiles.wordpress.org/mrwweb/\">mrwweb</a> · <a href=\"https://profiles.wordpress.org/mtdkei/\">mt</a> · <a href=\"https://profiles.wordpress.org/muddassirnasim/\">Muddassir Rahman Nasim</a> · <a href=\"https://profiles.wordpress.org/devmuhib/\">Muhibul Haque</a> · <a href=\"https://profiles.wordpress.org/mujuonly/\">mujuonly</a> · <a href=\"https://profiles.wordpress.org/mukesh27/\">Mukesh Panchal</a> · <a href=\"https://profiles.wordpress.org/mukulsingh27/\">Mukul Singh</a> · <a href=\"https://profiles.wordpress.org/my1xt/\">My1</a> · <a href=\"https://profiles.wordpress.org/n8finch/\">n8finch</a> · <a href=\"https://profiles.wordpress.org/assassinateur/\">Nadir Seghir</a> · <a href=\"https://profiles.wordpress.org/nandow/\">nandow</a> · <a href=\"https://profiles.wordpress.org/nanisamireddy/\">NANI SAMIREDDY</a> · <a href=\"https://profiles.wordpress.org/narenin/\">Narendra Sishodiya</a> · <a href=\"https://profiles.wordpress.org/nareshbheda/\">Naresh Bheda</a> · <a href=\"https://profiles.wordpress.org/nataliat2004/\">Natalia T</a> · <a href=\"https://profiles.wordpress.org/nathanatmoz/\">Nathan Johnson</a> · <a href=\"https://profiles.wordpress.org/navneet/\">navneet</a> · <a href=\"https://profiles.wordpress.org/navi161/\">Navneet Kaur</a> · <a href=\"https://profiles.wordpress.org/nhrrob/\">Nazmul Hasan Robin</a> · <a href=\"https://profiles.wordpress.org/greatislander/\">Ned Zimmerman</a> · <a href=\"https://profiles.wordpress.org/neotrope/\">neotrope</a> · <a href=\"https://profiles.wordpress.org/mcqueen22/\">NerQuiles</a> · <a href=\"https://profiles.wordpress.org/krstarica/\">net</a> · <a href=\"https://profiles.wordpress.org/ndiego/\">Nick Diego</a> · <a href=\"https://profiles.wordpress.org/nickgalvez/\">nickgalvez</a> · <a href=\"https://profiles.wordpress.org/undefinedfr/\">Nicolas RIVIERE</a> · <a href=\"https://profiles.wordpress.org/nicolasleroy/\">nicolasleroy</a> · <a href=\"https://profiles.wordpress.org/nidhidhandhukiya/\">nidhidhandhukiya</a> · <a href=\"https://profiles.wordpress.org/ntsekouras/\">Nik Tsekouras</a> · <a href=\"https://profiles.wordpress.org/smushytaco/\">Nikan Radan</a> · <a href=\"https://profiles.wordpress.org/nikitasolanki1812/\">Nikita Solanki</a> · <a href=\"https://profiles.wordpress.org/nikunj8866/\">Nikunj Hatkar</a> · <a href=\"https://profiles.wordpress.org/snilesh/\">Nilesh Shiragave</a> · <a href=\"https://profiles.wordpress.org/nirajgirixd/\">Niraj Giri</a> · <a href=\"https://profiles.wordpress.org/nithins53/\">Nithin SreeRaj</a> · <a href=\"https://profiles.wordpress.org/mrtortai/\">Noam Eppel</a> · <a href=\"https://profiles.wordpress.org/noruzzaman/\">Noruzzaman</a> · <a href=\"https://profiles.wordpress.org/nosilver4u/\">nosilver4u</a> · <a href=\"https://profiles.wordpress.org/oceantober/\">oceantober</a> · <a href=\"https://profiles.wordpress.org/finalwebsites/\">Olaf Lederer</a> · <a href=\"https://profiles.wordpress.org/oglekler/\">Olga Gleckler</a> · <a href=\"https://profiles.wordpress.org/domainsupport/\">Oliver Campion</a> · <a href=\"https://profiles.wordpress.org/jbkkd/\">Omer Korner</a> · <a href=\"https://profiles.wordpress.org/arzola/\">Oscar Arzola</a> · <a href=\"https://profiles.wordpress.org/groenroos/\">Oskari Groenroos</a> · <a href=\"https://profiles.wordpress.org/othernoel/\">othernoel</a> · <a href=\"https://profiles.wordpress.org/ov3rfly/\">Ov3rfly</a> · <a href=\"https://profiles.wordpress.org/paaljoachim/\">Paal Joachim Romdahl</a> · <a href=\"https://profiles.wordpress.org/pampfelimetten/\">pampfelimetten</a> · <a href=\"https://profiles.wordpress.org/parinpanjari/\">Parin Panjari</a> · <a href=\"https://profiles.wordpress.org/dparthj/\">Parth Dodiya</a> · <a href=\"https://profiles.wordpress.org/parthvataliya/\">Parth vataliya</a> · <a href=\"https://profiles.wordpress.org/swissspidy/\">Pascal Birchler</a> · <a href=\"https://profiles.wordpress.org/casiepa/\">Pascal Casier</a> · <a href=\"https://profiles.wordpress.org/pateljaymin/\">Patel Jaymin</a> · <a href=\"https://profiles.wordpress.org/patricia70/\">Patricia BT</a> · <a href=\"https://profiles.wordpress.org/lumiblog/\">Patrick Lumumba</a> · <a href=\"https://profiles.wordpress.org/eartboard/\">Paul</a> · <a href=\"https://profiles.wordpress.org/pbearne/\">Paul Bearne</a> · <a href=\"https://profiles.wordpress.org/pbiron/\">Paul Biron</a> · <a href=\"https://profiles.wordpress.org/bbpaule/\">Paul English</a> · <a href=\"https://profiles.wordpress.org/paulkevan/\">Paul Kevan</a> · <a href=\"https://profiles.wordpress.org/paullb/\">paullb</a> · <a href=\"https://profiles.wordpress.org/psrpinto/\">Paulo Pinto</a> · <a href=\"https://profiles.wordpress.org/paulopmt1/\">Paulo Trentin</a> · <a href=\"https://profiles.wordpress.org/pavanpatil1/\">Pavan Patil</a> · <a href=\"https://profiles.wordpress.org/creadordev/\">Pawan Kumar</a> · <a href=\"https://profiles.wordpress.org/pedromendonca/\">Pedro Mendon&#231;a</a> · <a href=\"https://profiles.wordpress.org/provenself/\">Peter Rubin</a> · <a href=\"https://profiles.wordpress.org/westi/\">Peter Westwood</a> · <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a> · <a href=\"https://profiles.wordpress.org/peter8nss/\">peter8nss</a> · <a href=\"https://profiles.wordpress.org/peterdavehello/\">peterdavehello</a> · <a href=\"https://profiles.wordpress.org/petitphp/\">petitphp</a> · <a href=\"https://profiles.wordpress.org/philliproth/\">philliproth</a> · <a href=\"https://profiles.wordpress.org/philwebs/\">philwebs</a> · <a href=\"https://profiles.wordpress.org/pitamdey/\">Pitam Dey</a> · <a href=\"https://profiles.wordpress.org/pixlpirate/\">pixlpirate</a> · <a href=\"https://profiles.wordpress.org/podpirate/\">podpirate</a> · <a href=\"https://profiles.wordpress.org/poojabhimani/\">Pooja Bhimani</a> · <a href=\"https://profiles.wordpress.org/pooja1210/\">Pooja Killekar (Muchandikar)</a> · <a href=\"https://profiles.wordpress.org/pooja9712/\">pooja9712</a> · <a href=\"https://profiles.wordpress.org/praful2111/\">Praful Patel</a> · <a href=\"https://profiles.wordpress.org/prasadkarmalkar/\">Prasad Karmalkar</a> · <a href=\"https://profiles.wordpress.org/prashant/\">prashant</a> · <a href=\"https://profiles.wordpress.org/pmbaldha/\">Prashant Baldha</a> · <a href=\"https://profiles.wordpress.org/contactprashantpp/\">Prashant Patil</a> · <a href=\"https://profiles.wordpress.org/prathamesh24/\">Prathamesh Shirke</a> · <a href=\"https://profiles.wordpress.org/prathameshbhagat1511/\">prathameshbhagat1511</a> · <a href=\"https://profiles.wordpress.org/pkbhatt/\">Pratik Bhatt</a> · <a href=\"https://profiles.wordpress.org/pratikgandhi/\">Pratik Gandhi</a> · <a href=\"https://profiles.wordpress.org/pratiklondhe/\">Pratik Londhe</a> · <a href=\"https://profiles.wordpress.org/presskopp/\">Presskopp</a> · <a href=\"https://profiles.wordpress.org/digitalpritam/\">Pritam Sonone</a> · <a href=\"https://profiles.wordpress.org/priyank9033/\">Priyank Vadhavana</a> · <a href=\"https://profiles.wordpress.org/pushpenderindia/\">Pushpender Singh</a> · <a href=\"https://profiles.wordpress.org/itsjonq/\">Q</a> · <a href=\"https://profiles.wordpress.org/qhaensler/\">qhaensler</a> · <a href=\"https://profiles.wordpress.org/rfischmann/\">Rafael Fischmann</a> · <a href=\"https://profiles.wordpress.org/rahulsprajapati/\">Rahul Prajapati</a> · <a href=\"https://profiles.wordpress.org/imrraaj/\">Raj Patel</a> · <a href=\"https://profiles.wordpress.org/rajat1192/\">Rajat Patel</a> · <a href=\"https://profiles.wordpress.org/raj198/\">Rajendra Patel</a> · <a href=\"https://profiles.wordpress.org/rajendrapatilraj/\">Rajendra Patil</a> · <a href=\"https://profiles.wordpress.org/rkradadiya/\">Rajesh Radadiya</a> · <a href=\"https://profiles.wordpress.org/rajeshrathodwp/\">Rajesh Rathod</a> · <a href=\"https://profiles.wordpress.org/rajinsharwar/\">Rajin Sharwar</a> · <a href=\"https://profiles.wordpress.org/rahmohn/\">Ramon Ahnert</a> · <a href=\"https://profiles.wordpress.org/rcorrales/\">Ramon Corrales</a> · <a href=\"https://profiles.wordpress.org/ramonopoly/\">Ramon James</a> · <a href=\"https://profiles.wordpress.org/ravigadhiyawp/\">Ravi Gadhiya</a> · <a href=\"https://profiles.wordpress.org/redkite/\">redkite</a> · <a href=\"https://profiles.wordpress.org/rehanali/\">Rehan Ali</a> · <a href=\"https://profiles.wordpress.org/rejaulalomkhan/\">Rejaul Alom Khan</a> · <a href=\"https://profiles.wordpress.org/rembem/\">Remco</a> · <a href=\"https://profiles.wordpress.org/renathoc/\">Renatho</a> · <a href=\"https://profiles.wordpress.org/ooraiser69/\">Renz Jay Sanchez</a> · <a href=\"https://profiles.wordpress.org/youknowriad/\">Riad Benguella</a> · <a href=\"https://profiles.wordpress.org/richtabor/\">Rich Tabor</a> · <a href=\"https://profiles.wordpress.org/riddhidave/\">Riddhi Dave</a> · <a href=\"https://profiles.wordpress.org/rinkalpagdar/\">Rinkal Pagdar</a> · <a href=\"https://profiles.wordpress.org/rishavdutta/\">Rishav Dutta</a> · <a href=\"https://profiles.wordpress.org/rcreators/\">Rishi Mehta</a> · <a href=\"https://profiles.wordpress.org/rishishah/\">Rishi Shah</a> · <a href=\"https://profiles.wordpress.org/rishit30g/\">Rishit Gupta</a> · <a href=\"https://profiles.wordpress.org/rkyburz/\">rkyburz</a> · <a href=\"https://profiles.wordpress.org/noisysocks/\">Robert Anderson</a> · <a href=\"https://profiles.wordpress.org/miqrogroove/\">Robert Chapin</a> · <a href=\"https://profiles.wordpress.org/robertghetau/\">Robert Ghetau</a> · <a href=\"https://profiles.wordpress.org/harmr/\">Robert Seyfriedsberger</a> · <a href=\"https://profiles.wordpress.org/robertstaddon/\">robertstaddon</a> · <a href=\"https://profiles.wordpress.org/robinmartijn/\">Robin Martijn</a> · <a href=\"https://profiles.wordpress.org/kreppar/\">Rodrigo Arias</a> · <a href=\"https://profiles.wordpress.org/rodrigosprimo/\">Rodrigo Primo</a> · <a href=\"https://profiles.wordpress.org/rogierlankhorst/\">Rogier Lankhorst</a> · <a href=\"https://profiles.wordpress.org/geekofshire/\">Rohan Jha</a> · <a href=\"https://profiles.wordpress.org/rohitmathur7/\">rohitmathur7</a> · <a href=\"https://profiles.wordpress.org/rohjay/\">rohjay</a> · <a href=\"https://profiles.wordpress.org/room34/\">room34</a> · <a href=\"https://profiles.wordpress.org/rotemg/\">Rotem Gelbart</a> · <a href=\"https://profiles.wordpress.org/lev0/\">Roy Orbitson</a> · <a href=\"https://profiles.wordpress.org/roytanck/\">Roy Tanck</a> · <a href=\"https://profiles.wordpress.org/roybellingan/\">roybellingan</a> · <a href=\"https://profiles.wordpress.org/ruchirj/\">Ruchir Goswami</a> · <a href=\"https://profiles.wordpress.org/rudrakshigupta/\">Rudrakshi Gupta</a> · <a href=\"https://profiles.wordpress.org/rupesh5438/\">Rupesh Patil</a> · <a href=\"https://profiles.wordpress.org/rupw/\">rupw</a> · <a href=\"https://profiles.wordpress.org/ruturajraval2305/\">Ruturaj Raval</a> · <a href=\"https://profiles.wordpress.org/rvoigt/\">rvoigt</a> · <a href=\"https://profiles.wordpress.org/bookdude13/\">Ryan Fredlund</a> · <a href=\"https://profiles.wordpress.org/ryanhellyer/\">Ryan Hellyer</a> · <a href=\"https://profiles.wordpress.org/rmccue/\">Ryan McCue</a> · <a href=\"https://profiles.wordpress.org/welcher/\">Ryan Welcher</a> · <a href=\"https://profiles.wordpress.org/looswebstudio/\">Ryo</a> · <a href=\"https://profiles.wordpress.org/sppramodh/\">S P Pramodh</a> · <a href=\"https://profiles.wordpress.org/sebastienserre/\">S&#233;bastien SERRE</a> · <a href=\"https://profiles.wordpress.org/sergiomdgomes/\">S&#233;rgio Gomes</a> · <a href=\"https://profiles.wordpress.org/soean/\">S&#246;ren W&#252;nsch</a> · <a href=\"https://profiles.wordpress.org/sabbir1991/\">Sabbir Ahmed</a> · <a href=\"https://profiles.wordpress.org/sabrineg/\">sabrineg</a> · <a href=\"https://profiles.wordpress.org/isaeedam/\">Saeed Piri</a> · <a href=\"https://profiles.wordpress.org/sagarlakhani/\">Sagar Lakhani</a> · <a href=\"https://profiles.wordpress.org/sagarprajapati/\">Sagar Prajapati</a> · <a href=\"https://profiles.wordpress.org/mi5t4n/\">Sagar Tamang</a> · <a href=\"https://profiles.wordpress.org/sailpete/\">sailpete</a> · <a href=\"https://profiles.wordpress.org/sainathpoojary/\">Sainath Poojary</a> · <a href=\"https://profiles.wordpress.org/sajjad67/\">Sajjad Hossain Sagor</a> · <a href=\"https://profiles.wordpress.org/sallyruchman/\">sally</a> · <a href=\"https://profiles.wordpress.org/samiamnot/\">samiamnot</a> · <a href=\"https://profiles.wordpress.org/viralsampat/\">Sampat Viral</a> · <a href=\"https://profiles.wordpress.org/ranafge/\">Samsul Islam Rana</a> · <a href=\"https://profiles.wordpress.org/otto42/\">Samuel Wood (Otto)</a> · <a href=\"https://profiles.wordpress.org/codexdemon/\">Sanyogg Shelar</a> · <a href=\"https://profiles.wordpress.org/mikachan/\">Sarah Norris</a> · <a href=\"https://profiles.wordpress.org/sarathar/\">Sarath AR</a> · <a href=\"https://profiles.wordpress.org/sarthaknagoshe2002/\">Sarthak Nagoshe</a> · <a href=\"https://profiles.wordpress.org/sathyapulse/\">Sathiya Venkatesan</a> · <a href=\"https://profiles.wordpress.org/sfougnier/\">Saul Fougnier</a> · <a href=\"https://profiles.wordpress.org/saurabhdhariwal/\">saurabh.dhariwal</a> · <a href=\"https://profiles.wordpress.org/saxonafletcher/\">Saxon Fletcher</a> · <a href=\"https://profiles.wordpress.org/infosatech/\">Sayan Datta</a> · <a href=\"https://profiles.wordpress.org/sayedulsayem/\">Sayedul Sayem</a> · <a href=\"https://profiles.wordpress.org/sbathompson/\">sbathompson</a> · <a href=\"https://profiles.wordpress.org/paragoninitiativeenterprises/\">Scott Arciszewski</a> · <a href=\"https://profiles.wordpress.org/scribu/\">scribu</a> · <a href=\"https://profiles.wordpress.org/sean212/\">Sean Fisher</a> · <a href=\"https://profiles.wordpress.org/seanlanglands/\">seanlanglands</a> · <a href=\"https://profiles.wordpress.org/sebastianpisula/\">Sebastian Pisula</a> · <a href=\"https://profiles.wordpress.org/seifradwane/\">Seif Radwane</a> · <a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey Biryukov</a> · <a href=\"https://profiles.wordpress.org/sergiogutierrez/\">sergiogutierrez</a> · <a href=\"https://profiles.wordpress.org/smrubenstein/\">Seth Rubenstein</a> · <a href=\"https://profiles.wordpress.org/severinepozzo/\">Severine Pozzo</a> · <a href=\"https://profiles.wordpress.org/shadialaghbari/\">Shadi G شادي جـ</a> · <a href=\"https://profiles.wordpress.org/shailu25/\">Shail Mehta</a> · <a href=\"https://profiles.wordpress.org/sh4lin/\">Shalin Shah</a> · <a href=\"https://profiles.wordpress.org/shanemuir/\">Shane Muirhead</a> · <a href=\"https://profiles.wordpress.org/spdft/\">Shoe</a> · <a href=\"https://profiles.wordpress.org/shraddhagore/\">Shraddha Gore</a> · <a href=\"https://profiles.wordpress.org/shreyashd21/\">shreyashd21</a> · <a href=\"https://profiles.wordpress.org/shub07/\">Shubham Kumar Bansal</a> · <a href=\"https://profiles.wordpress.org/iamshubhamsp/\">Shubham Patil</a> · <a href=\"https://profiles.wordpress.org/shulard/\">shulard</a> · <a href=\"https://profiles.wordpress.org/shyamkariya/\">Shyam Kariya</a> · <a href=\"https://profiles.wordpress.org/nomnom99/\">Siddharth Thevaril</a> · <a href=\"https://profiles.wordpress.org/siliconforks/\">siliconforks</a> · <a href=\"https://profiles.wordpress.org/simo_m/\">Simone Maranzana</a> · <a href=\"https://profiles.wordpress.org/sirlouen/\">SirLouen</a> · <a href=\"https://profiles.wordpress.org/sjefen6/\">sjefen6</a> · <a href=\"https://profiles.wordpress.org/slaffik/\">Slava Abakumov</a> · <a href=\"https://profiles.wordpress.org/mslavco/\">Slavco Mihajloski</a> · <a href=\"https://profiles.wordpress.org/smerriman/\">smerriman</a> · <a href=\"https://profiles.wordpress.org/snehapatil02/\">Sneha Patil</a> · <a href=\"https://profiles.wordpress.org/snehal5774/\">snehal5774</a> · <a href=\"https://profiles.wordpress.org/sohamjoshi8275/\">Soham sham joshi</a> · <a href=\"https://profiles.wordpress.org/sourabhjain/\">Sourabh Jain</a> · <a href=\"https://profiles.wordpress.org/sourav08/\">Sourav Pahwa</a> · <a href=\"https://profiles.wordpress.org/soyebsalar/\">soyeb salar</a> · <a href=\"https://profiles.wordpress.org/spencerfinnell/\">Spencer Finnell</a> · <a href=\"https://profiles.wordpress.org/spenserhale/\">Spenser Hale</a> · <a href=\"https://profiles.wordpress.org/spmultidots/\">spmultidots</a> · <a href=\"https://profiles.wordpress.org/spncr/\">spncr</a> · <a href=\"https://profiles.wordpress.org/srikat/\">Sridhar Katakam</a> · <a href=\"https://profiles.wordpress.org/stefahn/\">Stefan Seidner-Britting</a> · <a href=\"https://profiles.wordpress.org/ryokuhi/\">Stefano Minoia</a> · <a href=\"https://profiles.wordpress.org/stein2nd/\">stein2nd</a> · <a href=\"https://profiles.wordpress.org/sabernhardt/\">Stephen Bernhardt</a> · <a href=\"https://profiles.wordpress.org/netweb/\">Stephen Edgar</a> · <a href=\"https://profiles.wordpress.org/dufresnesteven/\">Steve Dufresne</a> · <a href=\"https://profiles.wordpress.org/stimul/\">stimul</a> · <a href=\"https://profiles.wordpress.org/strarsis/\">strarsis</a> · <a href=\"https://profiles.wordpress.org/stuartmcalpine/\">Stuart McAlpine</a> · <a href=\"https://profiles.wordpress.org/subodhrajpopat/\">Subodh Rajpopat</a> · <a href=\"https://profiles.wordpress.org/subrataemfluence/\">Subrata Sarkar</a> · <a href=\"https://profiles.wordpress.org/sketchboy/\">SUHAS SUTAR</a> · <a href=\"https://profiles.wordpress.org/sukhendu2002/\">Sukhendu Sekhar Guria</a> · <a href=\"https://profiles.wordpress.org/sumitbagthariya16/\">Sumit Bagthariya</a> · <a href=\"https://profiles.wordpress.org/sumitsingh/\">Sumit Singh</a> · <a href=\"https://profiles.wordpress.org/csesumonpro/\">Sumon Sarker</a> · <a href=\"https://profiles.wordpress.org/sunil25393/\">SunilPrajapati</a> · <a href=\"https://profiles.wordpress.org/surajswalstar/\">Suraj Sutar</a> · <a href=\"https://profiles.wordpress.org/swalkinshaw/\">swalkinshaw</a> · <a href=\"https://profiles.wordpress.org/cybr/\">Sybre Waaijer</a> · <a href=\"https://profiles.wordpress.org/synchro/\">Synchro</a> · <a href=\"https://profiles.wordpress.org/tschwarz-1/\">t.schwarz</a> · <a href=\"https://profiles.wordpress.org/tacoverdo/\">Taco Verdonschot</a> · <a href=\"https://profiles.wordpress.org/gonom9/\">Taegon Kim</a> · <a href=\"https://profiles.wordpress.org/iamtakashi/\">Takashi Irie</a> · <a href=\"https://profiles.wordpress.org/inc2734/\">Takashi Kitajima</a> · <a href=\"https://profiles.wordpress.org/takayukister/\">Takayuki Miyoshi</a> · <a href=\"https://profiles.wordpress.org/takuword/\">takuword</a> · <a href=\"https://profiles.wordpress.org/karmatosed/\">Tammie Lister</a> · <a href=\"https://profiles.wordpress.org/devtanbir/\">Tanbir Ahmod</a> · <a href=\"https://profiles.wordpress.org/voboghure/\">Tapan Kumer Das</a> · <a href=\"https://profiles.wordpress.org/th23/\">th23</a> · <a href=\"https://profiles.wordpress.org/thakordarshil/\">Thakor Darshil</a> · <a href=\"https://profiles.wordpress.org/thelmachido/\">thelmachido a11n</a> · <a href=\"https://profiles.wordpress.org/themebeans/\">ThemeBeans</a> · <a href=\"https://profiles.wordpress.org/thomaswm/\">thomaswm</a> · <a href=\"https://profiles.wordpress.org/threadi/\">threadi</a> · <a href=\"https://profiles.wordpress.org/thrijith/\">Thrijith Thankachan</a> · <a href=\"https://profiles.wordpress.org/tiagogoncalves/\">tiago</a> · <a href=\"https://profiles.wordpress.org/tigriweb/\">TigriWeb</a> · <a href=\"https://profiles.wordpress.org/tillkruess/\">Till Kr&#252;ss</a> · <a href=\"https://profiles.wordpress.org/tb1909/\">Tim Brath&#228;rig</a> · <a href=\"https://profiles.wordpress.org/dontfeedthecode/\">Tim Sheehan</a> · <a href=\"https://profiles.wordpress.org/timwhitlock/\">Tim W</a> · <a href=\"https://profiles.wordpress.org/sippis/\">Timi Wahalahti</a> · <a href=\"https://profiles.wordpress.org/spaceshipone/\">Timoth&#233;e Brosille</a> · <a href=\"https://profiles.wordpress.org/timothyblynjacobs/\">Timothy Jacobs</a> · <a href=\"https://profiles.wordpress.org/tkama/\">Timur Kamaev</a> · <a href=\"https://profiles.wordpress.org/tirth03/\">Tirth Doshi</a> · <a href=\"https://profiles.wordpress.org/tjarrett/\">TJarrett</a> · <a href=\"https://profiles.wordpress.org/tobiasbg/\">Tobias B&#228;thge</a> · <a href=\"https://profiles.wordpress.org/tobifjellner/\">tobifjellner (Tor-Bjorn &#8220;Tobi&#8221; Fjellner)</a> · <a href=\"https://profiles.wordpress.org/tgsrvrs/\">Tom Gugel</a> · <a href=\"https://profiles.wordpress.org/tommusrhodus/\">Tom Rhodes</a> · <a href=\"https://profiles.wordpress.org/shimotomoki/\">Tomoki Shimomura</a> · <a href=\"https://profiles.wordpress.org/skithund/\">Toni Viemer&#246;</a> · <a href=\"https://profiles.wordpress.org/hellofromtonya/\">Tonya Mork</a> · <a href=\"https://profiles.wordpress.org/toro_unit/\">Toro_Unit (Hiroshi Urabe)</a> · <a href=\"https://profiles.wordpress.org/zodiac1978/\">Torsten Landsiedel</a> · <a href=\"https://profiles.wordpress.org/tropicalista/\">tropicalista</a> · <a href=\"https://profiles.wordpress.org/areziaal/\">Troy Chaplin</a> · <a href=\"https://profiles.wordpress.org/truptikanzariya/\">Trupti Kanzariya</a> · <a href=\"https://profiles.wordpress.org/trushaamin/\">Trusha</a> · <a href=\"https://profiles.wordpress.org/tunetheweb/\">tunetheweb</a> · <a href=\"https://profiles.wordpress.org/dinhtungdu/\">Tung Du</a> · <a href=\"https://profiles.wordpress.org/tusharaddweb/\">Tushar Patel</a> · <a href=\"https://profiles.wordpress.org/tyb/\">TyB</a> · <a href=\"https://profiles.wordpress.org/tysonlmao/\">tysonlmao</a> · <a href=\"https://profiles.wordpress.org/ugyensupport/\">Ugyen Dorji</a> · <a href=\"https://profiles.wordpress.org/umeshsinghin/\">Umesh Singh</a> · <a href=\"https://profiles.wordpress.org/unsalkorkmaz/\">Unsal Korkmaz</a> · <a href=\"https://profiles.wordpress.org/up1512001/\">up1512001</a> · <a href=\"https://profiles.wordpress.org/upadalavipul/\">upadalavipul</a> · <a href=\"https://profiles.wordpress.org/utrenkner/\">utrenkner</a> · <a href=\"https://profiles.wordpress.org/eboxnet/\">Vagelis</a> · <a href=\"https://profiles.wordpress.org/vaibhavsweb/\">Vaibhav Singh Web</a> · <a href=\"https://profiles.wordpress.org/vaibhav2527/\">Vaibhav Tukaram Nawale</a> · <a href=\"https://profiles.wordpress.org/valer1e/\">Val&#233;rie Galassi</a> · <a href=\"https://profiles.wordpress.org/twvania/\">Vania</a> · <a href=\"https://profiles.wordpress.org/okvee/\">vee</a> · <a href=\"https://profiles.wordpress.org/vevas/\">Vegard S.</a> · <a href=\"https://profiles.wordpress.org/vgnavada/\">vgnavada</a> · <a href=\"https://profiles.wordpress.org/vcanales/\">Vicente Canales</a> · <a href=\"https://profiles.wordpress.org/fylgjur/\">Victoria - a11n</a> · <a href=\"https://profiles.wordpress.org/gvgvgvijayan/\">Vijayan</a> · <a href=\"https://profiles.wordpress.org/vijaysinh9094/\">Vijaysinh Zala</a> · <a href=\"https://profiles.wordpress.org/vikrampm/\">Vikram</a> · <a href=\"https://profiles.wordpress.org/szepeviktor/\">Viktor Sz&#233;pe</a> · <a href=\"https://profiles.wordpress.org/vineet2003/\">Vinit</a> · <a href=\"https://profiles.wordpress.org/vipulgupta003/\">Vipul Gupta</a> · <a href=\"https://profiles.wordpress.org/vipulpatil/\">Vipul Patil</a> · <a href=\"https://profiles.wordpress.org/virgildia/\">Virgildia</a> · <a href=\"https://profiles.wordpress.org/virgar/\">Virginie Garnier</a> · <a href=\"https://profiles.wordpress.org/virginienacci/\">virginienacci</a> · <a href=\"https://profiles.wordpress.org/vishy-moghan/\">Vishy Moghan</a> · <a href=\"https://profiles.wordpress.org/vivekawsm/\">vivekawsm</a> · <a href=\"https://profiles.wordpress.org/vrishabhsk/\">Vrishabh Jasani</a> · <a href=\"https://profiles.wordpress.org/vykesmac/\">vykesmac</a> · <a href=\"https://profiles.wordpress.org/wadowad/\">wadowad</a> · <a href=\"https://profiles.wordpress.org/pctevree/\">Web-Pepper</a> · <a href=\"https://profiles.wordpress.org/webmandesign/\">WebMan Design &#124; Oliver Juhas</a> · <a href=\"https://profiles.wordpress.org/west7/\">Wes Theron</a> · <a href=\"https://profiles.wordpress.org/westonruter/\">Weston Ruter</a> · <a href=\"https://profiles.wordpress.org/whaze/\">whaze</a> · <a href=\"https://profiles.wordpress.org/skorasaurus/\">Will Skora</a> · <a href=\"https://profiles.wordpress.org/williampatton/\">williampatton</a> · <a href=\"https://profiles.wordpress.org/wongjn/\">wongjn</a> · <a href=\"https://profiles.wordpress.org/worldweb/\">World Web Technology</a> · <a href=\"https://profiles.wordpress.org/wpgerd/\">wpgerd</a> · <a href=\"https://profiles.wordpress.org/wprockstar2/\">wprockstar2</a> · <a href=\"https://profiles.wordpress.org/wwdes/\">wwdes</a> · <a href=\"https://profiles.wordpress.org/xate/\">xate</a> · <a href=\"https://profiles.wordpress.org/xavilc/\">xavilc</a> · <a href=\"https://profiles.wordpress.org/xpurichan/\">xpurichan</a> · <a href=\"https://profiles.wordpress.org/yahil/\">Yahil Madakiya</a> · <a href=\"https://profiles.wordpress.org/yaniiliev/\">Yani</a> · <a href=\"https://profiles.wordpress.org/yashrocz/\">Yash Kukreja</a> · <a href=\"https://profiles.wordpress.org/yellowafterlife/\">yellowafterlife</a> · <a href=\"https://profiles.wordpress.org/yogeshbhutkar/\">Yogesh Bhutkar</a> · <a href=\"https://profiles.wordpress.org/yudhisthirnahar/\">yudhisthirnahar</a> · <a href=\"https://profiles.wordpress.org/fierevere/\">Yui</a> · <a href=\"https://profiles.wordpress.org/yuliyan/\">Yuliyan Slavchev</a> · <a href=\"https://profiles.wordpress.org/omaeyusuke/\">yuu</a> · <a href=\"https://profiles.wordpress.org/zaoyao/\">zaoyao</a> · <a href=\"https://profiles.wordpress.org/zargarov/\">Zargarov</a> · <a href=\"https://profiles.wordpress.org/zebulan/\">Zebulan Stanphill</a> · <a href=\"https://profiles.wordpress.org/zeelthakkar/\">zeelthakkar</a> · <a href=\"https://profiles.wordpress.org/zunaid321/\">Zunaid Amin</a> · <a href=\"https://profiles.wordpress.org/haozi/\">耗子</a></p>\n\n\n\n<p>More than <a href=\"https://translate.wordpress.org/stats/\">60 locales have fully translated</a> WordPress 6.8 into their language making this one of the most translated releases ever on day one.&nbsp; Community translators are working hard to ensure more translations are on their way.&nbsp; Thank you to everyone who helps make WordPress available in 200 languages.</p>\n\n\n\n<p>Last but not least, thanks to the volunteers who contribute to the <a href=\"https://wordpress.org/support/\">support forums</a> by answering questions from WordPress users worldwide.</p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Get involved</strong></h2>\n\n\n\n<p>Participation in WordPress goes far beyond coding. And learning more and getting involved is easy.&nbsp; Discover the teams that come together to <a href=\"https://make.wordpress.org/\">Make WordPress</a> and use <a href=\"https://make.wordpress.org/contribute/\">this interactive tool</a> to help you decide which is right for you.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"18701\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:66:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"WordCamp Europe 2025: Sali, Basel!\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"https://wordpress.org/news/2025/04/wordcamp-europe-2025-sali-basel/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 14 Apr 2025 19:16:10 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:4:{i:0;a:5:{s:4:\"data\";s:6:\"Events\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"WordCamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:4:\"WCEU\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:9:\"WordCamps\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=18683\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:411:\"WordCamp Europe 2025 will be held in gorgeous Basel, Switzerland, from June 5 to 7. It will bring together open source enthusiasts, developers, and WordPress professionals from across the region—and the world! This year’s event offers fresh perspectives, engaging conversations, and countless opportunities to connect with the WordPress community, agencies, and innovators over three action-packed [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Brett McSherry\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:6552:\"\n<figure class=\"wp-block-image size-large\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"390\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/04/473144529_985418666952827_8265761567676487048_n.png?resize=1024%2C390&#038;ssl=1\" alt=\"\" class=\"wp-image-18690\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/04/473144529_985418666952827_8265761567676487048_n.png?resize=1024%2C390&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/04/473144529_985418666952827_8265761567676487048_n.png?resize=300%2C114&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/04/473144529_985418666952827_8265761567676487048_n.png?resize=768%2C292&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/04/473144529_985418666952827_8265761567676487048_n.png?w=1230&amp;ssl=1 1230w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /></figure>\n\n\n\n<p>WordCamp Europe 2025 will be held in gorgeous Basel, Switzerland, from June 5 to 7. It will bring together open source enthusiasts, developers, and WordPress professionals from across the region—and the world!</p>\n\n\n\n<p>This year’s event offers fresh perspectives, engaging conversations, and countless opportunities to connect with the WordPress community, agencies, and innovators over three action-packed days of learning, networking, and collaboration.</p>\n\n\n\n<div class=\"wp-block-group has-off-white-background-color has-background is-layout-constrained wp-container-core-group-is-layout-8503c47b wp-block-group-is-layout-constrained\">\n<div style=\"height:50px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<p class=\"has-text-align-center has-large-font-size\"><img src=\"https://s.w.org/images/core/emoji/15.1.0/72x72/1f39f.png\" alt=\"🎟\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /> <strong>Tickets are limited—secure yours today!</strong></p>\n\n\n\n<div style=\"height:25px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<div class=\"wp-block-buttons is-content-justification-center is-layout-flex wp-container-core-buttons-is-layout-a89b3969 wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link has-text-align-center wp-element-button\" href=\"https://europe.wordcamp.org/2025/tickets/\">Get your ticket now</a></div>\n</div>\n\n\n\n<div style=\"height:50px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n</div>\n\n\n\n<h2 class=\"wp-block-heading\">Keynotes, panels, and deep dives</h2>\n\n\n\n<p>The main conference, which will be held on June 6th and 7th, will feature <a href=\"https://europe.wordcamp.org/2025/schedule/\">a lineup of notable keynote sessions</a>, including diverse sessions on business strategy and building innovative modern features, open-source advocacy, accessibility, and more. For those looking to sharpen their skills, presentations will dive deep into topics like SEO for WordPress, performance optimization, speed-builds, and leveraging AI.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Q&amp;A Fireside Chat</h2>\n\n\n\n<p>You can join Mary Hubbard, the WordPress Executive Director, and Matt Mullenweg, co-founder of the WordPress project on June 7th to discuss WordPress and its community, followed by an in-person Q&amp;A session here in Basel.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Explore Basel</h2>\n\n\n\n<p>Basel, the third-largest city in Switzerland, <a href=\"https://europe.wordcamp.org/2025/location/\">is filled with historical buildings, a cathedral, museums, and hidden gems</a>! You can get around Basel and experience it yourself using your BaselCard, which allows you to hop on and off all public transportation without a worry. A walk down Basel’s river Rhine could be the perfect evening during your visit to WordCamp Europe!</p>\n\n\n\n<p><img src=\"https://s.w.org/images/core/emoji/15.1.0/72x72/1f6cf.png\" alt=\"🛏\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /><a href=\"https://europe.wordcamp.org/2025/location/accommodation/\"> Find accommodations in Basel<br></a><img src=\"https://s.w.org/images/core/emoji/15.1.0/72x72/1f68c.png\" alt=\"🚌\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /><a href=\"https://europe.wordcamp.org/2025/location/getting-around-in-basel/\"> Learn about BaselCard benefits<br></a><img src=\"https://s.w.org/images/core/emoji/15.1.0/72x72/1f4c4.png\" alt=\"📄\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /><a href=\"https://europe.wordcamp.org/2025/location/visa/\"> Need a visa? Apply by May 10, 2025</a></p>\n\n\n\n<p><img src=\"https://s.w.org/images/core/emoji/15.1.0/72x72/1f4c5.png\" alt=\"📅\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /> <strong>Plan Your WordCamp Europe Experience</strong> See the <a href=\"https://europe.wordcamp.org/2025/schedule/\">full schedule</a>, plan your sessions, and maximize your time in Basel.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Get WordCamp-ready</h2>\n\n\n\n<p><img src=\"https://s.w.org/images/core/emoji/15.1.0/72x72/1f39f.png\" alt=\"🎟\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /> <strong>Make sure to secure your <a href=\"https://europe.wordcamp.org/2025/tickets/\">WordCamp Europe 2025 tickets</a></strong> (if you haven’t already!)</p>\n\n\n\n<p>Follow WordCamp Europe news on <a href=\"https://bsky.app/profile/wordpress.org\">Bluesky</a>, <a href=\"https://instagram.com/wordpress/\">Instagram</a>, <a href=\"https://www.facebook.com/WordPress\">Facebook</a>, <a href=\"https://www.linkedin.com/company/wordpress/\">LinkedIn</a>, <a href=\"https://www.threads.net/@wordpress\">Threads</a>, <a href=\"https://mastodon.world/@wordpress\">Mastodon</a>, and <a href=\"https://twitter.com/WordPress\">X/Twitter</a> for real-time updates!</p>\n\n\n\n<p>You can also help us spread the word about WordCamp Europe this year! Post about your attendance <a href=\"https://europe.wordcamp.org/2025/press/spread-the-word/\">using our ready-made texts</a> or we also encourage you to use your own voice – you know your community best.</p>\n\n\n\n<p>And as always, be part of the conversation! Whether you’re attending in-person in Basel or following along online, share your experiences using the tags #WCEU and #WordPress on all social media networks!</p>\n\n\n\n<p>Basel is calling—see you at WordCamp Europe 2025! <img src=\"https://s.w.org/images/core/emoji/15.1.0/72x72/1f1e8-1f1ed.png\" alt=\"🇨🇭\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<p>Thank you to <a href=\"https://profiles.wordpress.org/dolgelukkig/\">@dolgelukkig</a> for drafting this copy.</p>\n\n\n\n<p></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"18683\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:69:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"WordPress 6.8 Release Candidate 3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://wordpress.org/news/2025/04/wordpress-6-8-release-candidate-3/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 08 Apr 2025 15:54:49 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:5:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"6-8\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:11:\"development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:8:\"releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=18673\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:260:\"WordPress 6.8 RC 3 is ready for download and testing! The scheduled final release date for WordPress 6.8 is April 15, 2025. Your help testing over the next week is vital to ensuring the final release is everything it should be: stable, powerful, and intuitive.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Jeffrey Paul\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:8765:\"\n<p>The third release candidate (“RC3”) for WordPress 6.8 is ready for download and testing!</p>\n\n\n\n<p><strong>This version of the WordPress software is under development</strong>.<strong>&nbsp; Please do not install, run, or test this version of WordPress on production or mission-critical websites.</strong>&nbsp; Instead, it’s recommended that you evaluate RC3 on a test server and site.</p>\n\n\n\n<p>Reaching this phase of the release cycle is an important milestone.&nbsp; While release candidates are considered ready for release, testing remains crucial to ensure that everything in WordPress 6.8 is the best it can be.</p>\n\n\n\n<p>You can test WordPress 6.8 RC3 in four ways:</p>\n\n\n\n<figure class=\"wp-block-table\"><table class=\"has-fixed-layout\"><tbody><tr><td><strong>Plugin</strong></td><td>Install and activate the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin on a WordPress install.&nbsp; (Select the “Bleeding edge” channel and “Beta/RC Only” stream).</td></tr><tr><td><strong>Direct Download</strong></td><td>Download the <a href=\"https://wordpress.org/wordpress-6.8-RC3.zip\">RC3 version (zip)</a> and install it on a WordPress website.</td></tr><tr><td><strong>Command Line</strong></td><td>Use the following <a href=\"https://make.wordpress.org/cli/\">WP-CLI</a> command: <code>wp core update --version=6.8-RC3</code></td></tr><tr><td><strong>WordPress Playground</strong></td><td>Use the <a href=\"https://playground.wordpress.net/?php=8.0&amp;wp=beta&amp;networking=no&amp;language=&amp;multisite=no&amp;random=y4q1rn88xn\">6.8 RC3 WordPress Playground instance</a> (available within 35 minutes after the release is ready) to test the software directly in your browser without the need for a separate site or setup.</td></tr></tbody></table></figure>\n\n\n\n<p>The current target for the WordPress 6.8 release is <strong>April 15, 2025</strong>. Get an overview of the <a href=\"https://make.wordpress.org/core/6-8/\">6.8 release cycle</a>, and check the <a href=\"https://make.wordpress.org/core/\">Make WordPress Core blog</a> for <a href=\"https://make.wordpress.org/core/tag/6-8/\">6.8-related posts</a> leading up to next week’s release for further details.</p>\n\n\n\n<h2 class=\"wp-block-heading\">What’s in WordPress 6.8 RC3?</h2>\n\n\n\n<p>Get a recap of WordPress 6.8’s highlighted features in the <a href=\"https://wordpress.org/news/2025/03/wordpress-6-8-beta-1/\">Beta 1 announcement</a>. For more technical information related to issues addressed since <a href=\"https://wordpress.org/news/2025/04/wordpress-6-8-release-candidate-2/\">RC2</a>, you can browse the following links:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://github.com/WordPress/gutenberg/commits/wp/6.8?since=2025-04-02&amp;until=2025-04-08\">GitHub commits for 6.8</a> since April 1</li>\n\n\n\n<li><a href=\"https://core.trac.wordpress.org/log/branches/6.8?action=stop_on_copy&amp;mode=stop_on_copy&amp;rev=60145&amp;stop_rev=60125&amp;limit=100&amp;sfp_email=&amp;sfph_mail=\">Changes committed</a> since April 1</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">How you can contribute</h2>\n\n\n\n<p>WordPress is open source software made possible by a passionate community that collaborates and contributes to its development. The resources below outline various ways you can help the world’s most popular open source web platform, regardless of your technical expertise.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Get involved in testing</h3>\n\n\n\n<p>Testing for issues is critical to ensuring WordPress is performant and stable. It’s also a meaningful way for anyone to contribute. <a href=\"https://make.wordpress.org/test/2025/03/04/help-test-wordpress-6-8/\">This detailed guide</a> will walk you through testing features in WordPress 6.8.&nbsp; For those new to testing, follow <a href=\"https://make.wordpress.org/test/handbook/get-setup-for-testing/\">this general testing guide</a> for more details on getting set up.</p>\n\n\n\n<p>If you encounter an issue, please report it to the <a href=\"https://wordpress.org/support/forum/alphabeta/\">Alpha/Beta area</a> of the support forums or directly to <a href=\"https://core.trac.wordpress.org/newticket\">WordPress Trac</a> if you are comfortable writing a reproducible bug report. You can also check your issue against a list of <a href=\"https://core.trac.wordpress.org/tickets/major\">known bugs</a>.</p>\n\n\n\n<p>Curious about testing releases in general?&nbsp; Follow along with the <a href=\"https://make.wordpress.org/test/\">testing initiatives in Make Core</a> and join the <a href=\"https://wordpress.slack.com/messages/core-test/\">#core-test channel</a> on <a href=\"https://wordpress.slack.com/\">Making WordPress Slack</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Search for vulnerabilities</h3>\n\n\n\n<p>From now until the final release of WordPress 6.8 (scheduled for April 15, 2025), the <a href=\"https://make.wordpress.org/core/handbook/testing/reporting-security-vulnerabilities/#enhanced-bounty-rewards-during-beta-and-release-candidate-phases\">monetary reward for reporting new, unreleased security vulnerabilities</a> is doubled.&nbsp; Please follow responsible disclosure practices as detailed in the project’s security practices and policies outlined on the <a href=\"https://hackerone.com/wordpress\">HackerOne page</a> and in the <a href=\"https://wordpress.org/about/security/\">security white paper</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Update your theme or plugin</h3>\n\n\n\n<p>For plugin and theme authors, your products play an integral role in extending the functionality and value of WordPress for all users.&nbsp; For more details on developer-related changes in 6.8, please review the <a href=\"https://make.wordpress.org/core/2025/03/28/wordpress-6-8-field-guide/\">WordPress 6.8 Field Guide</a>.</p>\n\n\n\n<p>Thanks for continuing to test your themes and plugins with the WordPress 6.8 beta releases.&nbsp; With RC3, you’ll want to conclude your testing and update the <em>“Tested up to”</em> version in your <a href=\"https://developer.wordpress.org/plugins/wordpress-org/how-your-readme-txt-works/\">plugin’s readme file</a> to 6.8.</p>\n\n\n\n<p>If you find compatibility issues, please post detailed information to the <a href=\"https://wordpress.org/support/forum/alphabeta/\">support forum</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Help translate WordPress</h3>\n\n\n\n<p>Do you speak a language other than English?  <bdo lang=\"es\" dir=\"ltr\">¿Español?</bdo>  <bdo lang=\"fr\" dir=\"ltr\">Français?</bdo>  <bdo lang=\"ru\" dir=\"ltr\">Русский?</bdo>  <bdo lang=\"ja\" dir=\"ltr\">日本語?</bdo> <bdo lang=\"hi\" dir=\"ltr\">हिन्दी?</bdo> <bdo lang=\"mr\" dir=\"ltr\">मराठी?</bdo> <bdo lang=\"bn\" dir=\"ltr\">বাংলা?</bdo>  You can <a href=\"https://translate.wordpress.org/projects/wp/dev/\">help translate WordPress into more than 100 languages</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">An RC3 haiku</h2>\n\n\n\n<p><em>The launch draws closer,</em><em><br></em><em>Six-eight sings through RC3,</em><em><br></em><em>Almost time to shine.</em></p>\n\n\n\n<p class=\"has-text-align-right\"><em>Thank you to the following contributors for collaborating on this post: <a href=\'https://profiles.wordpress.org/audrasjb/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>audrasjb</a>, <a href=\'https://profiles.wordpress.org/mamaduka/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>mamaduka</a>, <a href=\'https://profiles.wordpress.org/krupajnanda/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>krupajnanda</a>, <a href=\'https://profiles.wordpress.org/benjamin_zekavica/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>benjamin_zekavica</a>, <a href=\'https://profiles.wordpress.org/narenin/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>narenin</a>, <a href=\'https://profiles.wordpress.org/joedolson/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>joedolson</a>, <a href=\'https://profiles.wordpress.org/courane01/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>courane01</a>, <a href=\'https://profiles.wordpress.org/joemcgill/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>joemcgill</a>, <a href=\'https://profiles.wordpress.org/marybaum/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>marybaum</a>, <a href=\'https://profiles.wordpress.org/kmgalanakis/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>kmgalanakis</a>, <a href=\'https://profiles.wordpress.org/umeshsinghin/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>umeshsinghin</a>, <a href=\'https://profiles.wordpress.org/wildworks/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>wildworks</a>, <a href=\'https://profiles.wordpress.org/mkrndmane/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>mkrndmane</a>.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"18673\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:69:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"WordPress 6.8 Release Candidate 2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://wordpress.org/news/2025/04/wordpress-6-8-release-candidate-2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 01 Apr 2025 15:53:20 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:5:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"6.8\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:11:\"development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:8:\"releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=18662\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:367:\"The second Release Candidate (“RC2”) for WordPress 6.8 is ready for download and testing! This version of the WordPress software is under development. Please do not install, run, or test this version of WordPress on production or mission-critical websites. Instead, it’s recommended that you evaluate RC2 on a test server and site. Reaching this phase [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"Jonathan Desrosiers\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:8741:\"\n<p>The second Release Candidate (“RC2”) for WordPress 6.8 is ready for download and testing!</p>\n\n\n\n<p><strong>This version of the WordPress software is under development</strong>.<strong> Please do not install, run, or test this version of WordPress on production or mission-critical websites.</strong> Instead, it’s recommended that you evaluate RC2 on a test server and site.</p>\n\n\n\n<p>Reaching this phase of the release cycle is an important milestone. While release candidates are considered ready for release, testing remains crucial to ensure that everything in WordPress 6.8 is the best it can be.</p>\n\n\n\n<p>You can test WordPress 6.8 RC2 in four ways:</p>\n\n\n\n<figure class=\"wp-block-table\"><table class=\"has-fixed-layout\"><tbody><tr><td><strong>Plugin</strong></td><td>Install and activate the<a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\"> WordPress Beta Tester</a> plugin on a WordPress install. (Select the “Bleeding edge” channel and “Beta/RC Only” stream).</td></tr><tr><td><strong>Direct Download</strong></td><td>Download the<a href=\"https://wordpress.org/wordpress-6.8-RC2.zip\"> RC2 version (zip)</a> and install it on a WordPress website.</td></tr><tr><td><strong>Command Line</strong></td><td>Use the following<a href=\"https://make.wordpress.org/cli/\"> WP-CLI</a> command: wp core update &#8211;version=6.8-RC2</td></tr><tr><td><strong>WordPress Playground</strong></td><td>Use the<a href=\"https://playground.wordpress.net/?php=8.0&amp;wp=beta&amp;networking=no&amp;language=&amp;multisite=no&amp;random=y4q1rn88xn\"> 6.8 RC2 WordPress Playground instance</a> (available within 35 minutes after the release is ready) to test the software directly in your browser without the need for a separate site or setup.</td></tr></tbody></table></figure>\n\n\n\n<p>The current target for the WordPress 6.8 release is <strong>April 15, 2025</strong>.&nbsp; Get an overview of the<a href=\"https://make.wordpress.org/core/6-8/\"> 6.8 release cycle</a>, and check the<a href=\"https://make.wordpress.org/core/\"> Make WordPress Core blog</a> for<a href=\"https://make.wordpress.org/core/tag/6-8/\"> 6.8-related posts</a> in the coming weeks for further details.</p>\n\n\n\n<h2 class=\"wp-block-heading\">What’s in WordPress 6.8 RC2?</h2>\n\n\n\n<p>Get a recap of WordPress 6.8’s highlighted features in the<a href=\"https://wordpress.org/news/2025/03/wordpress-6-8-beta-1/\"> Beta 1 announcement</a>. For more technical information related to issues addressed since RC1, you can browse the following links:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://github.com/WordPress/gutenberg/commits/wp/6.8?since=2025-03-26&amp;until=2025-04-01\">GitHub commits for 6.8</a> since March 25</li>\n\n\n\n<li><a href=\"https://core.trac.wordpress.org/query?id=63175%2C62887%2C63193%2C61219&amp;milestone=6.8&amp;group=component&amp;col=id&amp;col=summary&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=status&amp;col=priority&amp;order=priority\">Closed Trac tickets</a> since March 25</li>\n</ul>\n\n\n\n<p>Want to look deeper into the details and technical notes for this release? These recent posts cover some of the latest updates:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://make.wordpress.org/core/2025/03/06/speculative-loading-in-6-8/\">Speculative Loading in 6.8</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2025/02/17/wordpress-6-8-will-use-bcrypt-for-password-hashing/\">WordPress 6.8 will use bcrypt for password hashing</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2025/03/12/roster-of-design-tools-per-block-wordpress-6-8-edition/\">Roster of design tools per block (WordPress 6.8 edition)</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2025/03/13/more-efficient-block-type-registration-in-6-8/\">More efficient block type registration in 6.8</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2025/03/25/updates-to-user-interface-components-in-wordpress-6-8/\">Updates to user-interface components in WordPress 6.8</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2025/03/24/interactivity-api-best-practices-in-6-8/\">Interactivity API best practices in 6.8</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2025/03/12/i18n-improvements-6-8/\">Internationalization improvements in 6.8</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">How you can contribute</h2>\n\n\n\n<p>WordPress is open source software made possible by a passionate community of people collaborating on and contributing to its development. The resources below outline various ways you can help the world’s most popular open source web platform, regardless of your technical expertise.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Get involved in testing</h3>\n\n\n\n<p>Testing for issues is critical to ensuring WordPress is performant and stable.&nbsp; It’s also a meaningful way for anyone to contribute. <a href=\"https://make.wordpress.org/test/2025/03/04/help-test-wordpress-6-8/\">&nbsp;This detailed guide</a> will walk you through testing features in WordPress 6.8.&nbsp; For those new to testing, follow<a href=\"https://make.wordpress.org/test/handbook/get-setup-for-testing/\"> this general testing guide</a> for more details on getting set up.</p>\n\n\n\n<p>If you encounter an issue, please report it to the<a href=\"https://wordpress.org/support/forum/alphabeta/\"> Alpha/Beta area</a> of the support forums or directly to<a href=\"https://core.trac.wordpress.org/newticket\"> WordPress Trac</a> if you are comfortable writing a reproducible bug report.&nbsp; You can also check your issue against a list of<a href=\"https://core.trac.wordpress.org/tickets/major\"> known bugs</a>.</p>\n\n\n\n<p>Curious about testing releases in general?&nbsp; Follow along with the<a href=\"https://make.wordpress.org/test/\"> testing initiatives in Make Core</a> and join the<a href=\"https://wordpress.slack.com/messages/core-test/\"> #core-test channel</a> on<a href=\"https://wordpress.slack.com/\"> Making WordPress Slack</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Search for vulnerabilities</h3>\n\n\n\n<p>From now until the final release of WordPress 6.8 (scheduled for April 15, 2025), the<a href=\"https://make.wordpress.org/core/handbook/testing/reporting-security-vulnerabilities/#enhanced-bounty-rewards-during-beta-and-release-candidate-phases\"> monetary reward for reporting new, unreleased security vulnerabilities</a> is doubled. Please follow responsible disclosure practices as detailed in the project’s security practices and policies outlined on the<a href=\"https://hackerone.com/wordpress\"> HackerOne page</a> and in the<a href=\"https://wordpress.org/about/security/\"> security white paper</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Update your theme or plugin</h3>\n\n\n\n<p>For plugin and theme authors, your products play an integral role in extending the functionality and value of WordPress for all users.</p>\n\n\n\n<p>Thanks for continuing to test your themes and plugins with the WordPress 6.8 beta releases. With RC2, you’ll want to conclude your testing and update the <em>“Tested up to”</em> version in your<a href=\"https://developer.wordpress.org/plugins/wordpress-org/how-your-readme-txt-works/\"> plugin’s readme file</a> to 6.8.</p>\n\n\n\n<p>If you find compatibility issues, please post detailed information to the<a href=\"https://wordpress.org/support/forum/alphabeta/\"> support forum</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Help translate WordPress</h3>\n\n\n\n<p>Do you speak a language other than English?  ¿Español?  Français? Русский? 日本語?  हिन्दी?  বাংলা?  मराठी?  ಕನ್ನಡ?  You can<a href=\"https://translate.wordpress.org/projects/wp/dev/\"> help translate WordPress into more than 100 languages</a>. This release milestone (RC2) also marks the<a href=\"https://make.wordpress.org/polyglots/handbook/glossary/#hard-freeze\"> hard string freeze</a> point of the 6.8 release cycle.</p>\n\n\n\n<h2 class=\"wp-block-heading\">An RC2 haiku</h2>\n\n\n\n<p><em>Testing, 1, 2, 3</em><br><em>It’s almost April fifteenth</em><br><em>Squashing all the bugs</em></p>\n\n\n\n<p><em>Thank you to the following contributors for collaborating on this post: <a href=\'https://profiles.wordpress.org/michelleames/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>michelleames</a>, <a href=\'https://profiles.wordpress.org/tacoverdo/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>tacoverdo</a>, <a href=\'https://profiles.wordpress.org/jopdop30/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>jopdop30</a>, <a href=\'https://profiles.wordpress.org/vgnavada/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>vgnavada</a>, <a href=\'https://profiles.wordpress.org/jeffpaul/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>jeffpaul</a>.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"18662\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:69:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"WordPress 6.8 Release Candidate 1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://wordpress.org/news/2025/03/wordpress-6-8-release-candidate-1/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 25 Mar 2025 16:19:41 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:5:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"6.8\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:11:\"development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:8:\"releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=18639\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:267:\"WordPress 6.8 RC 1 is ready for download and testing! The scheduled final release date for WordPress 6.8 is April 15, 2025. Your help testing over the next three weeks is vital to ensuring the final release is everything it should be: stable, powerful, and intuitive.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Jeffrey Paul\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:9475:\"\n<p>The first Release Candidate (“RC1”) for WordPress 6.8 is ready for download and testing!</p>\n\n\n\n<p><strong>This version of the WordPress software is under development</strong>.<strong>&nbsp; Please do not install, run, or test this version of WordPress on production or mission-critical websites.</strong>&nbsp; Instead, it’s recommended that you evaluate RC1 on a test server and site.</p>\n\n\n\n<p>Reaching this phase of the release cycle is an important milestone.&nbsp; While release candidates are considered ready for release, testing remains crucial to ensure that everything in WordPress 6.8 is the best it can be.</p>\n\n\n\n<p>You can test WordPress 6.8 RC1 in four ways:</p>\n\n\n\n<figure class=\"wp-block-table\"><table class=\"has-fixed-layout\"><tbody><tr><td><strong>Plugin</strong></td><td>Install and activate the<a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\"> WordPress Beta Tester</a> plugin on a WordPress install.&nbsp; (Select the “Bleeding edge” channel and “Beta/RC Only” stream).</td></tr><tr><td><strong>Direct Download</strong></td><td>Download the <a href=\"https://wordpress.org/wordpress-6.8-RC1.zip\">RC1 version (zip)</a> and install it on a WordPress website.</td></tr><tr><td><strong>Command Line</strong></td><td>Use the following<a href=\"https://make.wordpress.org/cli/\"> WP-CLI</a> command: <code>wp core update --version=6.8-RC1</code></td></tr><tr><td><strong>WordPress Playground</strong></td><td>Use the <a href=\"https://playground.wordpress.net/?php=8.0&amp;wp=beta&amp;networking=no&amp;language=&amp;multisite=no&amp;random=y4q1rn88xn\">6.8 RC1 WordPress Playground instance</a> (available within 35 minutes after the release is ready) to test the software directly in your browser without the need for a separate site or setup.</td></tr></tbody></table></figure>\n\n\n\n<p>The current target for the WordPress 6.8 release is <strong>April 15, 2025</strong>.&nbsp; Get an overview of the <a href=\"https://make.wordpress.org/core/6-8/\">6.8 release cycle</a>, and check the<a href=\"https://make.wordpress.org/core/\"> Make WordPress Core blog</a> for <a href=\"https://make.wordpress.org/core/tag/6-8/\">6.8-related posts</a> in the coming weeks for further details.</p>\n\n\n\n<h2 class=\"wp-block-heading\">What’s in WordPress 6.8 RC1?</h2>\n\n\n\n<p>Get a recap of WordPress 6.8’s highlighted features in the <a href=\"https://wordpress.org/news/2025/03/wordpress-6-8-beta-1/\">Beta 1 announcement</a>.&nbsp; For more technical information related to issues addressed since Beta 3, you can browse the following links:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://github.com/WordPress/gutenberg/commits/wp/6.8?since=2025-03-18&amp;until=2025-03-25\">GitHub commits for 6.8</a> since March 18</li>\n\n\n\n<li><a href=\"https://core.trac.wordpress.org/query?status=closed&amp;changetime=03%2F18%2F2025..03%2F25%2F2025&amp;milestone=6.8&amp;col=id&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=id\">Closed Trac tickets</a> since March 18</li>\n</ul>\n\n\n\n<p>Want to look deeper into the details and technical notes for this release? These recent posts cover some of the latest updates:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://make.wordpress.org/core/2025/03/06/speculative-loading-in-6-8/\">Speculative Loading in 6.8</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2025/02/17/wordpress-6-8-will-use-bcrypt-for-password-hashing/\">WordPress 6.8 will use bcrypt for password hashing</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2025/03/12/roster-of-design-tools-per-block-wordpress-6-8-edition/\">Roster of design tools per block (WordPress 6.8 edition)</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2025/03/13/more-efficient-block-type-registration-in-6-8/\">More efficient block type registration in 6.8</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2025/03/25/updates-to-user-interface-components-in-wordpress-6-8/\">Updates to user-interface components in WordPress 6.8</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2025/03/24/interactivity-api-best-practices-in-6-8/\">Interactivity API best practices in 6.8</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2025/03/12/i18n-improvements-6-8/\">Internationalization improvements in 6.8</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">How you can contribute</h2>\n\n\n\n<p>WordPress is open source software made possible by a passionate community of people collaborating on and contributing to its development.&nbsp; The resources below outline various ways you can help the world’s most popular open source web platform, regardless of your technical expertise.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Get involved in testing</h3>\n\n\n\n<p>Testing for issues is critical to ensuring WordPress is performant and stable.&nbsp; It’s also a meaningful way for anyone to contribute.&nbsp; <a href=\"https://make.wordpress.org/test/2025/03/04/help-test-wordpress-6-8/\">This detailed guide</a> will walk you through testing features in WordPress 6.8.&nbsp; For those new to testing, follow <a href=\"https://make.wordpress.org/test/handbook/get-setup-for-testing/\">this general testing guide</a> for more details on getting set up.</p>\n\n\n\n<p>If you encounter an issue, please report it to the<a href=\"https://wordpress.org/support/forum/alphabeta/\"> Alpha/Beta area</a> of the support forums or directly to<a href=\"https://core.trac.wordpress.org/newticket\"> WordPress Trac</a> if you are comfortable writing a reproducible bug report.&nbsp; You can also check your issue against a list of<a href=\"https://core.trac.wordpress.org/tickets/major\"> known bugs</a>.</p>\n\n\n\n<p>Curious about testing releases in general?&nbsp; Follow along with the<a href=\"https://make.wordpress.org/test/\"> testing initiatives in Make Core</a> and join the<a href=\"https://wordpress.slack.com/messages/core-test/\"> #core-test channel</a> on<a href=\"https://wordpress.slack.com/\"> Making WordPress Slack</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Search for vulnerabilities</h3>\n\n\n\n<p>From now until the final release of WordPress 6.8 (scheduled for April 15, 2025), the <a href=\"https://make.wordpress.org/core/handbook/testing/reporting-security-vulnerabilities/#enhanced-bounty-rewards-during-beta-and-release-candidate-phases\">monetary reward for reporting new, unreleased security vulnerabilities</a> is doubled.&nbsp; Please follow responsible disclosure practices as detailed in the project’s security practices and policies outlined on the<a href=\"https://hackerone.com/wordpress\"> HackerOne page</a> and in the<a href=\"https://wordpress.org/about/security/\"> security white paper</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Update your theme or plugin</h3>\n\n\n\n<p>For plugin and theme authors, your products play an integral role in extending the functionality and value of WordPress for all users.</p>\n\n\n\n<p>Thanks for continuing to test your themes and plugins with the WordPress 6.8 beta releases.&nbsp; With RC1, you’ll want to conclude your testing and update the <em>“Tested up to”</em> version in your<a href=\"https://developer.wordpress.org/plugins/wordpress-org/how-your-readme-txt-works/\"> plugin’s readme file</a> to 6.8.</p>\n\n\n\n<p>If you find compatibility issues, please post detailed information to the<a href=\"https://wordpress.org/support/forum/alphabeta/\"> support forum</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Help translate WordPress</h3>\n\n\n\n<p>Do you speak a language other than English?  <bdo lang=\"es\" dir=\"ltr\">¿Español?</bdo>  <bdo lang=\"fr\" dir=\"ltr\">Français?</bdo>  <bdo lang=\"ru\" dir=\"ltr\">Русский?</bdo>  <bdo lang=\"jp\" dir=\"ltr\">日本語?</bdo> <bdo lang=\"hi\" dir=\"ltr\">हिन्दी?</bdo>  <bdo lang=\"bn\" dir=\"ltr\">বাংলা?</bdo>  <bdo lang=\"mr\" dir=\"ltr\">मराठी?</bdo>  You can<a href=\"https://translate.wordpress.org/projects/wp/dev/\"> help translate WordPress into more than 100 languages</a>.  This release milestone (RC1) also marks the<a href=\"https://make.wordpress.org/polyglots/handbook/glossary/#hard-freeze\"> hard string freeze</a> point of the 6.8 release cycle.</p>\n\n\n\n<h2 class=\"wp-block-heading\">An RC1 haiku</h2>\n\n\n\n<p>March fades, nearly there,<br>Six-eight hums—a steady beat,<br>RC greets the world.</p>\n\n\n\n<p class=\"has-text-align-right\"><em>Thank you to the following contributors for collaborating on this post: <a href=\'https://profiles.wordpress.org/joemcgill/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>joemcgill</a> <a href=\'https://profiles.wordpress.org/benjamin_zekavica/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>benjamin_zekavica</a> <a href=\'https://profiles.wordpress.org/courane01/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>courane01</a> <a href=\'https://profiles.wordpress.org/mkrndmane/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>mkrndmane</a> <a href=\'https://profiles.wordpress.org/audrasjb/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>audrasjb</a> <a href=\'https://profiles.wordpress.org/areziaal/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>areziaal</a> <a href=\'https://profiles.wordpress.org/ankit-k-gupta/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>ankit-k-gupta</a> <a href=\'https://profiles.wordpress.org/krupajnanda/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>krupajnanda</a> <a href=\'https://profiles.wordpress.org/bph/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>bph</a>.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"18639\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:69:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 6.8 Beta 3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2025/03/wordpress-6-8-beta-3/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 18 Mar 2025 15:35:14 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:5:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"6.8\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:11:\"development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:8:\"releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=18634\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:289:\"WordPress 6.8 Beta 3 is ready for download and testing! The scheduled final release date for WordPress 6.8 is April 15, 2025. Your help testing Beta and RC versions over the next four weeks is vital to ensuring the final release is everything it should be: stable, powerful, and intuitive.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Jeffrey Paul\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:5627:\"\n<p>WordPress 6.8 Beta 3 is now ready for testing!</p>\n\n\n\n<p><strong>This beta version of the WordPress software is under development</strong>. Please do not install, run, or test this version of WordPress on production or mission-critical websites. Instead, it is recommended you evaluate Beta 3 on a test server and site.</p>\n\n\n\n<p>You can test WordPress 6.8 Beta 3 in four ways:</p>\n\n\n\n<figure class=\"wp-block-table\"><table class=\"has-fixed-layout\"><tbody><tr><td><strong>Plugin</strong></td><td>Install and activate the<a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\"> WordPress Beta Tester</a> plugin on a WordPress install.&nbsp; (Select the “Bleeding edge” channel and “Beta/RC Only” stream).</td></tr><tr><td><strong>Direct Download</strong></td><td>Download the <a href=\"https://wordpress.org/wordpress-6.8-beta3.zip\">Beta 3 version (zip)</a> and install it on a WordPress website.</td></tr><tr><td><strong>Command Line</strong></td><td>Use the following<a href=\"https://make.wordpress.org/cli/\"> WP-CLI</a> command: <code>wp core update --version=6.8-beta3</code></td></tr><tr><td><strong>WordPress Playground</strong></td><td>Use the <a href=\"https://playground.wordpress.net/?php=8.0&amp;wp=beta&amp;networking=no&amp;language=&amp;multisite=no&amp;random=y4q1rn88xn\">6.8 Beta 3 WordPress Playground instance</a> to test the software directly in your browser without the need for a separate site or setup.</td></tr></tbody></table></figure>\n\n\n\n<p>The current target date for the final release of WordPress 6.8 is <strong>April 15, 2025</strong>. Get an overview of the <a href=\"https://make.wordpress.org/core/6-8/\">6.8 release cycle</a>, and check the<a href=\"https://make.wordpress.org/core/\"> Make WordPress Core blog</a> for <a href=\"https://make.wordpress.org/core/tag/6-8/\">6.8-related posts</a> in the coming weeks for more information.</p>\n\n\n\n<p><strong>Catch up on what’s new in WordPress 6.8</strong>: Read the <a href=\"https://wordpress.org/news/2025/03/wordpress-6-8-beta-1/\">Beta 1</a> and <a href=\"https://wordpress.org/news/2025/03/wordpress-6-8-beta-2/\">Beta 2</a> announcements for details and highlights.</p>\n\n\n\n<h2 class=\"wp-block-heading\">How to test this release</h2>\n\n\n\n<p>Your help testing the WordPress 6.8 Beta 3 version is key to ensuring everything in the release is the best it can be. While testing the upgrade process is essential, trying out new features is equally important. <a href=\"https://make.wordpress.org/test/2025/03/04/help-test-wordpress-6-8/\">This detailed guide</a> will walk you through testing features in WordPress 6.8.</p>\n\n\n\n<p>If you encounter an issue, please report it to the Alpha/Beta area of the support forums or directly to<a href=\"https://core.trac.wordpress.org/newticket\"> WordPress Trac</a> if you are comfortable writing a reproducible bug report. You can also check your issue against a list of<a href=\"https://core.trac.wordpress.org/tickets/major\"> known bugs</a>.</p>\n\n\n\n<p>Curious about testing releases in general?&nbsp; Follow along with the<a href=\"https://make.wordpress.org/test/\"> testing initiatives in Make Core</a> and join the<a href=\"https://wordpress.slack.com/messages/core-test/\"> #core-test channel</a> on<a href=\"https://wordpress.slack.com/\"> Making WordPress Slack</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Vulnerability bounty doubles during Beta/RC</h2>\n\n\n\n<p>Between Beta 1, released on March 4, 2025, and the final Release Candidate (RC) scheduled for April 8, 2025, the <a href=\"https://make.wordpress.org/core/handbook/testing/reporting-security-vulnerabilities/#enhanced-bounty-rewards-during-beta-and-release-candidate-phases\">monetary reward for reporting new, unreleased security vulnerabilities</a> is doubled. Please follow responsible disclosure practices as detailed in the project’s security practices and policies outlined on the<a href=\"https://hackerone.com/wordpress\"> HackerOne page</a> and in the<a href=\"https://wordpress.org/about/security/\"> security white paper</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Beta 3 updates and highlights</h2>\n\n\n\n<p>WordPress 6.8 Beta 3 contains more than 3 Editor updates and fixes since the Beta 2 release, including 16 tickets for WordPress core.</p>\n\n\n\n<p>Each beta cycle focuses on bug fixes; more are on the way with your help through testing. You can browse the technical details for all issues addressed since Beta 3 using these links:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://github.com/WordPress/gutenberg/commits/wp/6.8?since=2025-03-12&amp;until=2025-03-17\">GitHub commits for 6.8</a> since March 12, 2025</li>\n\n\n\n<li><a href=\"https://core.trac.wordpress.org/query?status=closed&amp;changetime=03%2F12%2F2025..03%2F17%2F2025&amp;milestone=6.8&amp;col=id&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=id\">Closed Trac tickets</a> since March 12, 2025</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">A Beta 3 haiku</h2>\n\n\n\n<p>Beta three refines,<br>WordPress shapes with steady hands,<br>Code grows into form.</p>\n\n\n\n<p class=\"has-text-align-right\"><em>Props to <a href=\'https://profiles.wordpress.org/benjamin_zekavica/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>benjamin_zekavica</a> <a href=\'https://profiles.wordpress.org/krupajnanda/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>krupajnanda</a> <a href=\'https://profiles.wordpress.org/ankit-k-gupta/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>ankit-k-gupta</a> <a href=\'https://profiles.wordpress.org/joemcgill/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>joemcgill</a> for proofreading and review.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"18634\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:69:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 6.8 Beta 2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2025/03/wordpress-6-8-beta-2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 11 Mar 2025 15:46:13 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:5:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"6.8\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:11:\"development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:8:\"releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=18619\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:289:\"WordPress 6.8 Beta 2 is ready for download and testing! The scheduled final release date for WordPress 6.8 is April 15, 2025. Your help testing Beta and RC versions over the next five weeks is vital to ensuring the final release is everything it should be: stable, powerful, and intuitive.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Jeffrey Paul\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:5940:\"\n<p>WordPress 6.8 Beta 2 is now ready for testing!</p>\n\n\n\n<p><strong>This beta version of the WordPress software is under development</strong>. Please do not install, run, or test this version of WordPress on production or mission-critical websites.&nbsp; Instead, you should evaluate Beta 2 on a test server and site.</p>\n\n\n\n<p>You can test WordPress 6.8 Beta 2 in four ways:</p>\n\n\n\n<figure class=\"wp-block-table\"><table class=\"has-fixed-layout\"><tbody><tr><td><strong>Plugin</strong></td><td>Install and activate the<a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\"> WordPress Beta Tester</a> plugin on a WordPress install. (Select the “Bleeding edge” channel and “Beta/RC Only” stream.)</td></tr><tr><td><strong>Direct Download</strong></td><td>Download the <a href=\"https://wordpress.org/wordpress-6.8-beta2.zip\">Beta 2 version (zip)</a> and install it on a WordPress website.</td></tr><tr><td><strong>Command Line</strong></td><td>Use this<a href=\"https://make.wordpress.org/cli/\"> WP-CLI</a> command: <code>wp core update --version=6.8-beta2</code></td></tr><tr><td><strong>WordPress Playground</strong></td><td>Use the <a href=\"https://playground.wordpress.net/?php=8.0&amp;wp=beta&amp;networking=no&amp;language=&amp;multisite=no&amp;random=y4q1rn88xn\">6.8 Beta 2 WordPress Playground instance</a> to test the software directly in your browser.&nbsp; No setup is required–just click and go!&nbsp;</td></tr></tbody></table></figure>\n\n\n\n<p>The current target date for the final release of WordPress 6.8 is <strong>April 15, 2025</strong>. Get an overview of the <a href=\"https://make.wordpress.org/core/6-8/\">6.8 release cycle</a>, and check the<a href=\"https://make.wordpress.org/core/\"> Make WordPress Core blog</a> for <a href=\"https://make.wordpress.org/core/tag/6-8/\">6.8-related posts</a> in the coming weeks for more information.</p>\n\n\n\n<p><strong>Catch up on what’s new in WordPress 6.8</strong>: <a href=\"https://wordpress.org/news/2025/03/wordpress-6-8-beta-1/\">Read the Beta 1 announcement</a> for details and highlights.</p>\n\n\n\n<h2 class=\"wp-block-heading\">How to test this release</h2>\n\n\n\n<p>Your help testing the WordPress 6.8 Beta 2 version is key to ensuring everything in the release is the best it can be. While testing the upgrade process is essential, trying out new features is equally important.&nbsp; <a href=\"https://make.wordpress.org/test/2025/03/04/help-test-wordpress-6-8/\">This detailed guide</a> will walk you through testing features in WordPress 6.8.</p>\n\n\n\n<p>If you encounter an issue, please report it to the<a href=\"https://wordpress.org/support/forum/alphabeta/\"> Alpha/Beta area</a> of the support forums or directly to<a href=\"https://core.trac.wordpress.org/newticket\"> WordPress Trac</a> if you are comfortable writing a reproducible bug report. You can also check your issue against a list of<a href=\"https://core.trac.wordpress.org/tickets/major\"> known bugs</a>.</p>\n\n\n\n<p>Curious about testing releases in general? Follow along with the<a href=\"https://make.wordpress.org/test/\"> testing initiatives in Make Core</a> and join the<a href=\"https://wordpress.slack.com/messages/core-test/\"> #core-test channel</a> on<a href=\"https://wordpress.slack.com/\"> Making WordPress Slack</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Vulnerability bounty doubles during Beta/RC</h2>\n\n\n\n<p>Between Beta 1, released on March 4, 2025, and the final Release Candidate (RC) scheduled for April 8, 2025, the<a href=\"https://make.wordpress.org/core/handbook/testing/reporting-security-vulnerabilities/#enhanced-bounty-rewards-during-beta-and-release-candidate-phases\"> monetary reward for reporting new, unreleased security vulnerabilities</a> is doubled. Please follow responsible disclosure practices as detailed in the project’s security practices and policies outlined on the<a href=\"https://hackerone.com/wordpress\"> HackerOne page</a> and in the<a href=\"https://wordpress.org/about/security/\"> security white paper</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Beta 2 updates and highlights</h2>\n\n\n\n<p>WordPress 6.8 Beta 2 contains more than 14 Editor updates and fixes since the Beta 1 release, including 21 tickets for WordPress core.</p>\n\n\n\n<p>Each beta cycle focuses on bug fixes; more are on the way with your help through testing. You can browse the technical details for all issues addressed since Beta 1 using these links:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://github.com/WordPress/gutenberg/commits/wp/6.8?since=2025-03-05&amp;until=2025-03-10\">GitHub commits for 6.8</a> since March 4, 2025</li>\n\n\n\n<li><a href=\"https://core.trac.wordpress.org/query?status=closed&amp;changetime=03%2F05%2F2025..03%2F10%2F2025&amp;milestone=6.8&amp;col=id&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=id\">Closed Trac tickets</a> since March 4, 2025</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">A Beta 2 haiku</h2>\n\n\n\n<p>Second wave refines,<br>Lines of code like rivers flow,<br>WordPress finds its form.</p>\n\n\n\n<p class=\"has-text-align-right\"><em>Props to <a href=\'https://profiles.wordpress.org/ankitkumarshah/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>ankitkumarshah</a> <a href=\'https://profiles.wordpress.org/vgnavada/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>vgnavada</a> <a href=\'https://profiles.wordpress.org/krupajnanda/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>krupajnanda</a> <a href=\'https://profiles.wordpress.org/michelleames/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>michelleames</a> <a href=\'https://profiles.wordpress.org/audrasjb/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>audrasjb</a> <a href=\'https://profiles.wordpress.org/marybaum/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>marybaum</a> <a href=\'https://profiles.wordpress.org/ecgan/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>ecgan</a></em> <em>for proofreading and review.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"18619\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:69:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 6.8 Beta 1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2025/03/wordpress-6-8-beta-1/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 04 Mar 2025 17:09:45 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:5:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"6.8\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:11:\"development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:8:\"releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=18582\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:288:\"WordPress 6.8 Beta 1 is ready for download and testing! The scheduled final release date for WordPress 6.8 is April 15, 2025. Your help testing Beta and RC versions over the next six weeks is vital to ensuring the final release is everything it should be: stable, powerful, and intuitive.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Jeffrey Paul\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:10596:\"\n<p>WordPress 6.8 Beta 1 is ready for download and testing!</p>\n\n\n\n<p><strong>This beta version of the WordPress software is under development.</strong> Please do not install, run, or test this version of WordPress on production or mission-critical websites. Instead, set up a test environment or a local site to explore the new features.</p>\n\n\n\n<h2 class=\"wp-block-heading\">How to Test WordPress 6.8 Beta 1</h2>\n\n\n\n<p>You can test this beta release in any of the following ways:&nbsp;</p>\n\n\n\n<figure class=\"wp-block-table\"><table class=\"has-fixed-layout\"><tbody><tr><td><strong>WordPress Beta Tester Plugin</strong></td><td>Install and activate the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin on a WordPress install. Select the “Bleeding edge” channel and “Beta/RC Only” stream.</td></tr><tr><td><strong>Direct Download</strong></td><td>Download the <a href=\"https://wordpress.org/wordpress-6.8-beta1.zip\">Beta 1 version (zip)</a> and install it on a WordPress website.</td></tr><tr><td><strong>Command Line (WP-CLI)</strong></td><td>Use this <a href=\"https://make.wordpress.org/cli/\">WP-CLI</a> command: <code>wp core update --version=6.8-beta1</code></td></tr><tr><td><strong>WordPress Playground</strong></td><td>Use a <a href=\"https://playground.wordpress.net/?php=8.0&amp;wp=beta&amp;networking=no&amp;language=&amp;multisite=no&amp;random=r8nny4q18x\">6.8 Beta 1 WordPress Playground instance</a> to test the software directly in your browser. No setup required–-just click and go!</td></tr></tbody></table></figure>\n\n\n\n<p>The scheduled final release date for WordPress 6.8 is <strong>April 15, 2025</strong>. Your help testing Beta and RC versions over the next six weeks is vital to ensuring the final release is everything it should be: stable, powerful, and intuitive.</p>\n\n\n\n<h2 class=\"wp-block-heading\">How important is your testing?</h2>\n\n\n\n<p>Testing for issues is a critical part of developing any software, and it’s a meaningful way for anyone to contribute—whether or not you have experience.&nbsp; <a href=\"https://make.wordpress.org/test/2025/03/04/help-test-wordpress-6-8/\">Details on what to test in WordPress 6.8 are here</a>.</p>\n\n\n\n<p>If you encounter an issue, please share it in the <a href=\"https://wordpress.org/support/forum/alphabeta/\">Alpha/Beta area</a> of the support forums. If you are comfortable submitting a reproducible bug report, you can do so <a href=\"https://core.trac.wordpress.org/newticket\">via WordPress Trac</a>. You can also check your issue against this list of <a href=\"https://core.trac.wordpress.org/tickets/major\">known bugs</a>.</p>\n\n\n\n<p>Curious about testing releases in general and how to get started? Follow along with the<a href=\"https://make.wordpress.org/test/\"> testing initiatives in Make Core</a> and join the <a href=\"https://wordpress.slack.com/messages/core-test/\">#core-test channel</a> on <a href=\"https://wordpress.slack.com/\">Making WordPress Slack</a>.</p>\n\n\n\n<p>WordPress 6.8 will include many new features that were previously only available in the Gutenberg plugin. Learn more about Gutenberg updates since WordPress 6.7 in the<a href=\"https://make.wordpress.org/core/tag/gutenberg-new/\"> What’s New in Gutenberg</a> posts for versions<a href=\"https://make.wordpress.org/core/2024/06/09/what-is-new-in-gutenberg-18-5-05-jun/\"> </a><a href=\"https://make.wordpress.org/core/2024/10/09/whats-new-in-gutenberg-15-9-31-may-2/\">19.4</a>, <a href=\"https://make.wordpress.org/core/2024/10/24/whats-new-in-gutenberg-19-5-23-october/\">19.5</a>, <a href=\"https://make.wordpress.org/core/2024/11/06/whats-new-in-gutenberg-15-9-31-may-2-2/\">19.6</a>, <a href=\"https://make.wordpress.org/core/2024/11/20/whats-new-in-gutenberg-19-7-20-november/\">19.7</a>, <a href=\"https://make.wordpress.org/core/2024/12/04/whats-new-in-gutenberg-19-8-4-december/\">19.8</a>, <a href=\"https://make.wordpress.org/core/2024/12/18/whats-new-in-gutenberg-19-9-19-december/\">19.9</a>, <a href=\"https://make.wordpress.org/core/2025/01/11/whats-new-in-gutenberg-20-0-10-january/\">20.0</a>, <a href=\"https://make.wordpress.org/core/2025/02/08/whats-new-in-gutenberg-20-1-and-20-2/\">20.1, 20.2</a>, <a href=\"https://make.wordpress.org/core/2025/03/03/whats-new-in-gutenberg-20-3-18-february/\">20.3</a>, and 20.4.</p>\n\n\n\n<h2 class=\"wp-block-heading\">What’s New in WordPress 6.8 Beta 1</h2>\n\n\n\n<p>This is a polish release, with user enhancements throughout incorporated into the latest Gutenberg updates. WordPress 6.8 brings a luster and gloss that only a polish release can.</p>\n\n\n\n<p>WordPress 6.8 Beta 1 contains over 370 enhancements and 520 bug fixes for the editor, including design improvements, polishing the query loop, and more than <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;milestone=6.8&amp;group=component&amp;max=500&amp;col=id&amp;col=summary&amp;col=owner&amp;col=type&amp;col=priority&amp;col=component&amp;col=version&amp;order=priority\">230 tickets for WordPress 6.8 Core</a>. Here’s a glimpse of what’s coming:</p>\n\n\n\n<h3 class=\"wp-block-heading\">Editor improvements</h3>\n\n\n\n<p>Easier ways to see your options in Data Views, and you can opt to ignore sticky posts in the Query Loop. Plus you’ll find lots of little improvements in the editor!</p>\n\n\n\n<h3 class=\"wp-block-heading\">The Style Book comes to Classic themes</h3>\n\n\n\n<p>The Style Book now features a <a href=\"https://github.com/WordPress/gutenberg/issues/68036\">structured layout</a> so you can preview site colors, typography, and block styles more easily. You can use the Style Book in classic themes with editor-styles or a theme.json file and includes clearer labels, and you can find them under <code>Appearance &gt; Design</code>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Support for Speculation browser API</h3>\n\n\n\n<p>WordPress 6.8 introduces native support for speculative loading, leveraging the <a href=\"https://developer.mozilla.org/en-US/docs/Web/API/Speculation_Rules_API\">Speculation Rules API</a> to improve site performance with near-instant page loads. This feature prefetches or prerenders URLs based on user interactions, such as hovering over links, reducing load times for subsequent pages.</p>\n\n\n\n<p>By default, WordPress 6.8 applies a conservative prefetching strategy, balancing performance gains with resource efficiency. Developers can customize speculative loading behavior using new filters, since the API does not include UI-based controls. The existing <a href=\"https://wordpress.org/plugins/speculation-rules/\">Speculative Loading feature plugin</a> will adapt to the core implementation, allowing deeper customization.&nbsp; Please test this feature in supported browsers (currently Chrome 108+ and Edge 108+, with more browsers evaluating) and provide feedback on <a href=\"https://core.trac.wordpress.org/ticket/62503\">#62503</a> to help refine its implementation.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Major security boost</h3>\n\n\n\n<p>WordPress 6.8 will use bcrypt for password hashing, which <a href=\"https://make.wordpress.org/core/2025/02/17/wordpress-6-8-will-use-bcrypt-for-password-hashing/\">significantly hardens WordPress.</a> Other hashing is getting hardened, too, throughout the security apparatus. You won’t have to change anything in your daily workflow.</p>\n\n\n\n<p><strong>The features included in this first beta may change before the final release of WordPress 6.8, based on what testers like you find.</strong></p>\n\n\n\n<p>Get an overview of the <a href=\"https://make.wordpress.org/core/6-8/\">6.8 release cycle</a> and check the <a href=\"https://make.wordpress.org/core/\">Make WordPress Core blog</a> for<a href=\"https://make.wordpress.org/core/tag/6-8/\"> 6.8-related posts</a> in the next few weeks for further details.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Caveat on testing 6.8 Beta 1 in versions older than 5.1</h2>\n\n\n\n<p>Due to an update made to the upgrade routine during this release, (see <a href=\"https://core.trac.wordpress.org/changeset/59803\">r59803</a>), any upgrade from versions older than 5.1 will fail. Folks are working to resolve this specific issue, so please hold off on reporting on this while testing the Beta 1 release.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Vulnerability bounty doubles during Beta &amp; Release Candidate</h2>\n\n\n\n<p>The WordPress community sponsors a <a href=\"https://make.wordpress.org/core/handbook/testing/reporting-security-vulnerabilities/#enhanced-bounty-rewards-during-beta-and-release-candidate-phases\">monetary reward for reporting new, unreleased security vulnerabilities</a>. This reward doubles during the period between Beta 1 on March 4, 2025 and the final Release Candidate (RC) scheduled for April 15, 2025.  Please follow responsible disclosure practices as detailed in the project’s security practices and policies. You can find those on the <a href=\"https://hackerone.com/wordpress\">HackerOne page</a> and in the <a href=\"https://wordpress.org/about/security/\">security white paper</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Just for you: a Beta 1 haiku</h2>\n\n\n\n<p>March winds shift the tide.<br>Hands unite in open source;<br>WordPress moves ahead.</p>\n\n\n\n<p class=\"has-text-align-right\"><em>Props to <a href=\'https://profiles.wordpress.org/audrasjb/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>audrasjb</a> <a href=\'https://profiles.wordpress.org/marybaum/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>marybaum</a> <a href=\'https://profiles.wordpress.org/mamaduka/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>mamaduka</a> <a href=\'https://profiles.wordpress.org/michelleames/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>michelleames</a> <a href=\'https://profiles.wordpress.org/bph/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>bph</a> <a href=\'https://profiles.wordpress.org/jorbin/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>jorbin</a> <a href=\'https://profiles.wordpress.org/joemcgill/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>joemcgill</a> <a href=\'https://profiles.wordpress.org/krupajnanda/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>krupajnanda</a> <a href=\'https://profiles.wordpress.org/desrosj/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>desrosj</a> <a href=\'https://profiles.wordpress.org/benjamin_zekavica/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>benjamin_zekavica</a> <a href=\'https://profiles.wordpress.org/lysyjan87/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>lysyjan87</a></em> <em>for reviewing and collaborating on this post!</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"18582\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"Shaping Tomorrow at WordCamp Asia 2025\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"https://wordpress.org/news/2025/02/shaping-tomorrow-at-wordcamp-asia-2025/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 22 Feb 2025 15:04:04 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:6:\"Events\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"WordCamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=18515\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:394:\"Over 1,400 attendees from 71 countries gathered at the Philippine International Convention Center in Manila, and nearly 15,000 more joined online, for WordCamp Asia 2025. It&#8217;s the people. It&#8217;s the friendships and the stories. Matt Mullenweg, WordPress Cofounder The flagship WordPress event started with a dedicated Contributor Day, followed by two days of engaging talks, [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Nicholas Garofalo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:56759:\"\n<figure class=\"wp-block-image size-large\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"512\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250222-WCAsia-02-21-PM_1280x640-1-scaled-1.jpg?resize=1024%2C512&#038;ssl=1\" alt=\"WordCamp Asia 2025 attendees gathered for a group photo\" class=\"wp-image-18521\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250222-WCAsia-02-21-PM_1280x640-1-scaled-1-scaled.jpg?resize=1024%2C512&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250222-WCAsia-02-21-PM_1280x640-1-scaled-1-scaled.jpg?resize=300%2C150&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250222-WCAsia-02-21-PM_1280x640-1-scaled-1-scaled.jpg?resize=768%2C384&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250222-WCAsia-02-21-PM_1280x640-1-scaled-1-scaled.jpg?resize=1536%2C768&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250222-WCAsia-02-21-PM_1280x640-1-scaled-1-scaled.jpg?resize=2048%2C1024&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /></figure>\n\n\n\n<p>Over 1,400 attendees from 71 countries gathered at the Philippine International Convention Center in Manila, and nearly 15,000 more joined online, for WordCamp Asia 2025.</p>\n\n\n\n<div class=\"wp-block-group is-nowrap is-layout-flex wp-container-core-group-is-layout-6c531013 wp-block-group-is-layout-flex\">\n<figure class=\"wp-block-pullquote alignwide has-text-align-center\"><blockquote><p>It&#8217;s the people. It&#8217;s the friendships and the stories.</p><cite>Matt Mullenweg, WordPress Cofounder</cite></blockquote></figure>\n</div>\n\n\n\n<p>The flagship WordPress event started with a dedicated Contributor Day, followed by two days of engaging talks, panels, hands-on workshops, and networking. Notable guests included WordPress Cofounder <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a> and Gutenberg Lead Architect <a href=\"https://profiles.wordpress.org/matveb/\">Matías Ventura</a>, who were joined by a diverse lineup of speakers and panelists.</p>\n\n\n\n<p>Throughout the event, the sponsor hall buzzed with activity as companies from across the WordPress ecosystem showcased their latest products, engaged with attendees, and offered live demos and giveaways.&nbsp;Each day, attendees refueled with diverse food offerings featuring Filipino favorites, turning meals into a prime networking opportunity where new connections were made and ideas were exchanged.</p>\n\n\n\n<h2 class=\"wp-block-heading\">New Ways to Engage</h2>\n\n\n\n<p>This year’s event introduced several new programs to the schedule:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Solutions Spotlight</strong>—a series of dynamic 10-minute lightning talks that gave an inside look at innovative products, cutting-edge strategies, and real-world solutions from top-tier sponsors, all designed to help attendees succeed in the WordPress ecosystem. These fast-paced sessions offered a unique opportunity to discover how leading brands are solving challenges, empowering users, and shaping the future of WordPress.</li>\n\n\n\n<li><strong>YouthCamp</strong>, a dedicated event for kids and teens ages 8-17, offered a full day of free, hands-on sessions designed to spark creativity and introduce the world of WordPress and open source. Through interactive workshops covering web basics, design, and development, participants gained practical skills while exploring the power of building online.&nbsp;</li>\n\n\n\n<li>The new <strong>Career and Social Corners</strong> enhanced networking, fostered meaningful connections, and created new opportunities for those within the WordPress community. Career Corner was the go-to space for attendees exploring career opportunities, connecting with sponsors, and discovering exciting new roles. Meanwhile, Social Corner offered a relaxed, lounge-style environment where attendees could engage in informal discussions over refreshments.</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Contributor Day</h2>\n\n\n\n<p>WordCamp Asia kicked off with an incredible Contributor Day, bringing together almost 800 contributors, many of them new, to collaborate, share knowledge, and give back to WordPress. With 37 dedicated table leads and 16 experts from the Human Library guiding the way, participants of all experience levels engaged in meaningful discussions, tackled important tasks, and made a lasting impact on the WordPress project.</p>\n\n\n\n<figure class=\"wp-block-gallery has-nested-images columns-default is-cropped has-border-color has-darker-grey-background-color has-background wp-block-gallery-1 is-layout-flex wp-block-gallery-is-layout-flex\" style=\"border-color:#1c2024;border-width:20px;border-radius:2px\">\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;6805bbed8cf35&quot;}\" data-wp-interactive=\"core/image\" class=\"wp-block-image size-large has-custom-border wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18526\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1834.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18526\" style=\"border-radius:2px\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1834-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1834-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1834-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1834-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1834-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;6805bbed8d37f&quot;}\" data-wp-interactive=\"core/image\" class=\"wp-block-image size-large has-custom-border wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18537\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1914.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18537\" style=\"border-radius:2px\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1914-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1914-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1914-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1914-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1914-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;6805bbed8d76d&quot;}\" data-wp-interactive=\"core/image\" class=\"wp-block-image size-large has-custom-border wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18527\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1989.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18527\" style=\"border-radius:2px\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1989-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1989-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1989-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1989-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1989-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;6805bbed8db63&quot;}\" data-wp-interactive=\"core/image\" class=\"wp-block-image size-large has-custom-border wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18524\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1926.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18524\" style=\"border-radius:2px\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1926-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1926-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1926-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1926-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1926-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;6805bbed8df3f&quot;}\" data-wp-interactive=\"core/image\" class=\"wp-block-image size-large has-custom-border wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18530\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1920.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18530\" style=\"border-radius:2px\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1920-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1920-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1920-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1920-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1920-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;6805bbed8e330&quot;}\" data-wp-interactive=\"core/image\" class=\"wp-block-image size-large has-custom-border wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18525\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1963.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18525\" style=\"border-radius:2px\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1963-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1963-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1963-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1963-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1963-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure class=\"wp-block-image size-large\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-id=\"18616\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/02/WORDCAMPASIA2025_PH_PICC_DAY01_CONTRIBUTORSDAY_JOHN_CARLO_PATTAGUAN-474.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18616\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/02/WORDCAMPASIA2025_PH_PICC_DAY01_CONTRIBUTORSDAY_JOHN_CARLO_PATTAGUAN-474-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/02/WORDCAMPASIA2025_PH_PICC_DAY01_CONTRIBUTORSDAY_JOHN_CARLO_PATTAGUAN-474-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/02/WORDCAMPASIA2025_PH_PICC_DAY01_CONTRIBUTORSDAY_JOHN_CARLO_PATTAGUAN-474-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/02/WORDCAMPASIA2025_PH_PICC_DAY01_CONTRIBUTORSDAY_JOHN_CARLO_PATTAGUAN-474-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/02/WORDCAMPASIA2025_PH_PICC_DAY01_CONTRIBUTORSDAY_JOHN_CARLO_PATTAGUAN-474-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /></figure>\n\n\n\n<figure class=\"wp-block-image size-large\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"768\" data-id=\"18614\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250220_153813.jpg?resize=1024%2C768&#038;ssl=1\" alt=\"\" class=\"wp-image-18614\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250220_153813-scaled.jpg?resize=1024%2C768&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220_153813-scaled.jpg?resize=300%2C225&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220_153813-scaled.jpg?resize=768%2C576&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220_153813-scaled.jpg?resize=1536%2C1152&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220_153813-scaled.jpg?resize=2048%2C1536&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /></figure>\n\n\n\n<figure class=\"wp-block-image size-large\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"684\" data-id=\"18615\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/02/T2S_6305.jpg?resize=1024%2C684&#038;ssl=1\" alt=\"\" class=\"wp-image-18615\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/02/T2S_6305-scaled.jpg?resize=1024%2C684&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/02/T2S_6305-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/02/T2S_6305-scaled.jpg?resize=768%2C513&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/02/T2S_6305-scaled.jpg?resize=1536%2C1025&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/02/T2S_6305-scaled.jpg?resize=2048%2C1367&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;6805bbed8e90e&quot;}\" data-wp-interactive=\"core/image\" class=\"wp-block-image size-large has-custom-border wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18528\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1902.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18528\" style=\"border-radius:2px\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1902-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1902-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1902-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1902-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1902-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;6805bbed8ecad&quot;}\" data-wp-interactive=\"core/image\" class=\"wp-block-image size-large has-custom-border wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18534\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1886.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18534\" style=\"border-radius:2px\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1886-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1886-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1886-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1886-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1886-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;6805bbed8f0a2&quot;}\" data-wp-interactive=\"core/image\" class=\"wp-block-image size-large has-custom-border wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18531\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1885.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18531\" style=\"border-radius:2px\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1885-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1885-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1885-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1885-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1885-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;6805bbed8f38c&quot;}\" data-wp-interactive=\"core/image\" class=\"wp-block-image size-large has-custom-border wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18536\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC07465.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18536\" style=\"border-radius:2px\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC07465-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC07465-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC07465-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC07465-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC07465-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n</figure>\n\n\n\n<p>Key contributions included resolving a critical media bug, advancing vertical text editing in Gutenberg, and refining the editing experience with dozens of issue closures. Performance optimizations and accessibility improvements abounded, joined by seven fresh patterns, and over 44,000 newly translated strings.</p>\n\n\n\n<p>New tools and workflows were explored to enhance testing and development. The day also saw meaningful conversations between hosting providers and users, improvements to event organizing processes, and hands-on training.</p>\n\n\n\n<p>With innovative ideas, new faces, and significant progress across multiple areas, Contributor Day reinforced the spirit of open source collaboration that drives WordPress forward.</p>\n\n\n\n<h2 class=\"wp-block-heading\">The Future is WordPress</h2>\n\n\n\n<p>On the first full conference day, attendees gathered to celebrate the power of open source collaboration and innovation. Opening remarks from global and local event leads reflected on the incredible journey of WordCamp Asia, tracing its roots back to the first Southeast Asian WordCamp in Manila in 2008. This full-circle moment underscored how the WordPress community has flourished over the years, driven by shared knowledge and a commitment to an open web. The excitement continued with a highly anticipated opening keynote from Matías Ventura, who shared insights into the future of Gutenberg and WordPress, inspiring attendees to embrace the next wave of innovation and creativity in content publishing.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n<iframe loading=\"lazy\" title=\"How WordPress is Evolving | Insights from Gutenberg’s Lead Architect at WordCamp Asia 2025.\" width=\"500\" height=\"281\" src=\"https://www.youtube.com/embed/-Zgv2q5NHBA?feature=oembed\" frameborder=\"0\" allow=\"accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share\" referrerpolicy=\"strict-origin-when-cross-origin\" allowfullscreen></iframe>\n</div></figure>\n\n\n\n<p>The day then began in earnest. Talks highlighted new ways to integrate WordPress with external applications, opening possibilities for more interactive and scalable digital experiences. Simultaneously, content strategists and marketers explored evolving best practices in SEO, learning how to optimize their sites for visibility, engagement, and long-term growth. These sessions emphasized the importance of adaptability in a constantly evolving digital landscape, ensuring that WordPress users stay ahead of industry trends.</p>\n\n\n\n<p>Workshops throughout the day provided hands-on learning experiences tailored to a wide range of skill levels. Developers refined their expertise, gaining practical knowledge they could apply to their own projects. Accessibility advocates led discussions on designing for inclusivity, showcasing strategies to make WordPress-powered websites more navigable and user-friendly for people of all abilities.</p>\n\n\n\n<p>As the conference continued into the afternoon, conversations expanded to performance optimization and emerging technologies shaping the future of WordPress. A dedicated session explored AI-driven workflows, demonstrating how artificial intelligence can enhance site performance, automate repetitive tasks, and create more personalized user experiences. These discussions showcased the evolving role of WordPress as a versatile platform that extends beyond traditional publishing.</p>\n\n\n\n<p>The first day culminated in a thought-provoking keynote panel, WordPress in 2030, where industry leaders explored the future of the platform. The discussion covered the expanding open source community, emerging technologies, and the role of education and mentorship. Panelists shared their perspectives on the opportunities and challenges ahead, encouraging attendees to actively shape the future of WordPress by contributing, innovating, and advocating for an open web.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"442\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250222-CleanShot-2025-02-22-at-07.42.19%402x.jpg?resize=1024%2C442&#038;ssl=1\" alt=\"Panelists Noel Tock, Hong Phuc Dang, Jon Ang, Courtney Robertson, and Raquel Manriquez discuss WordPress in 2030\" class=\"wp-image-18561\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250222-CleanShot-2025-02-22-at-07.42.19%402x-scaled.jpg?resize=1024%2C442&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250222-CleanShot-2025-02-22-at-07.42.19%402x-scaled.jpg?resize=300%2C129&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250222-CleanShot-2025-02-22-at-07.42.19%402x-scaled.jpg?resize=768%2C331&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250222-CleanShot-2025-02-22-at-07.42.19%402x-scaled.jpg?resize=1536%2C663&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250222-CleanShot-2025-02-22-at-07.42.19%402x-scaled.jpg?resize=2048%2C883&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /></figure>\n\n\n\n<p>Returning for the final day of WordCamp Asia 2025, attendees explored a new set of sessions designed to push the boundaries of web development and strategy. Technical discussions on advanced Gutenberg block development highlighted innovative ways to build more dynamic and interactive content experiences, while another session examined performance optimization strategies to enhance site speed, accessibility, and overall user engagement. Content creators and marketers gained valuable insights into audience growth, effective storytelling, and data-driven content strategies to maximize impact.</p>\n\n\n\n<p>The final sessions of the conference reinforced WordPress’s adaptability and innovation, equipping attendees with new skills and strategies.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Q&amp;A</h2>\n\n\n\n<p>As the final day drew to a close, Matt shared historic photos from WordCamp Davao 2008 in the Philippines, and then answered questions from the audience.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n<iframe loading=\"lazy\" title=\"Exclusive Q&amp;A with Matt Mullenweg at WordCamp Asia 2025 – Insights &amp; Future of WordPress!\" width=\"500\" height=\"281\" src=\"https://www.youtube.com/embed/LEm2NXwbZKc?feature=oembed\" frameborder=\"0\" allow=\"accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share\" referrerpolicy=\"strict-origin-when-cross-origin\" allowfullscreen></iframe>\n</div></figure>\n\n\n\n<p>Questions covered a variety of topics, incluiding: publishing on the open web, AI, headless WordPress, education, and Matt’s personal motivations. It was clear throughout the Q&amp;A that the future of WordPress is as bright as the island-themed attire at the event’s after-party.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Closing</h2>\n\n\n\n<p>Thank you to all the hard-working organizers who made this event possible, the speakers who took the stage, the visitors who ventured to Manila, and everyone who tuned in from around the world. Our hope is that every WordCamp attendee leaves with new knowledge, new friends, and new inspiration to build a better web.</p>\n\n\n\n<figure class=\"wp-block-gallery has-nested-images columns-default is-cropped has-border-color has-darker-grey-background-color has-background wp-block-gallery-2 is-layout-flex wp-block-gallery-is-layout-flex\" style=\"border-color:#1c2024;border-width:20px;border-radius:2px\">\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;6805bbed8feb3&quot;}\" data-wp-interactive=\"core/image\" class=\"wp-block-image size-large has-custom-border wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18533\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1853.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18533\" style=\"border-radius:2px\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1853-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1853-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1853-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1853-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1853-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;6805bbed90186&quot;}\" data-wp-interactive=\"core/image\" class=\"wp-block-image size-large has-custom-border wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"684\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18547\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250221-T2S_5388.jpg?resize=1024%2C684&#038;ssl=1\" alt=\"\" class=\"wp-image-18547\" style=\"border-radius:2px\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250221-T2S_5388-scaled.jpg?resize=1024%2C684&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250221-T2S_5388-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250221-T2S_5388-scaled.jpg?resize=768%2C513&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250221-T2S_5388-scaled.jpg?resize=1536%2C1025&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250221-T2S_5388-scaled.jpg?resize=2048%2C1367&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;6805bbed9043a&quot;}\" data-wp-interactive=\"core/image\" class=\"wp-block-image size-large has-custom-border wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18535\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1877.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18535\" style=\"border-radius:2px\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1877-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1877-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1877-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1877-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1877-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;6805bbed906f6&quot;}\" data-wp-interactive=\"core/image\" class=\"wp-block-image size-large has-custom-border wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18523\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1800.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18523\" style=\"border-radius:2px\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1800-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1800-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1800-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1800-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1800-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;6805bbed909af&quot;}\" data-wp-interactive=\"core/image\" class=\"wp-block-image size-large has-custom-border wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18532\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1861.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18532\" style=\"border-radius:2px\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1861-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1861-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1861-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1861-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1861-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;6805bbed90c7e&quot;}\" data-wp-interactive=\"core/image\" class=\"wp-block-image size-large has-custom-border wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18529\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1860.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18529\" style=\"border-radius:2px\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1860-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1860-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1860-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1860-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1860-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;6805bbed90f41&quot;}\" data-wp-interactive=\"core/image\" class=\"wp-block-image size-large has-custom-border wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18545\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250221-250221_12-35-12_N7A00461_NExT.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18545\" style=\"border-radius:2px\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250221-250221_12-35-12_N7A00461_NExT-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250221-250221_12-35-12_N7A00461_NExT-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250221-250221_12-35-12_N7A00461_NExT-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250221-250221_12-35-12_N7A00461_NExT-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250221-250221_12-35-12_N7A00461_NExT-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;6805bbed91201&quot;}\" data-wp-interactive=\"core/image\" class=\"wp-block-image size-large has-custom-border wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18543\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250221-DSC_2549.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18543\" style=\"border-radius:2px\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250221-DSC_2549-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250221-DSC_2549-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250221-DSC_2549-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250221-DSC_2549-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250221-DSC_2549-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;6805bbed914b8&quot;}\" data-wp-interactive=\"core/image\" class=\"wp-block-image size-large has-custom-border wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"684\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18546\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250221-IMG_3709.jpg?resize=1024%2C684&#038;ssl=1\" alt=\"\" class=\"wp-image-18546\" style=\"border-radius:2px\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250221-IMG_3709-scaled.jpg?resize=1024%2C684&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250221-IMG_3709-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250221-IMG_3709-scaled.jpg?resize=768%2C513&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250221-IMG_3709-scaled.jpg?resize=1536%2C1025&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250221-IMG_3709-scaled.jpg?resize=2048%2C1367&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;6805bbed9177e&quot;}\" data-wp-interactive=\"core/image\" class=\"wp-block-image size-large has-custom-border wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"768\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18540\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250222-b9848a28-a181-47dc-80af-4d2eb6a72756.jpg?resize=1024%2C768&#038;ssl=1\" alt=\"\" class=\"wp-image-18540\" style=\"border-radius:2px\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250222-b9848a28-a181-47dc-80af-4d2eb6a72756.jpg?resize=1024%2C768&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250222-b9848a28-a181-47dc-80af-4d2eb6a72756.jpg?resize=300%2C225&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250222-b9848a28-a181-47dc-80af-4d2eb6a72756.jpg?resize=768%2C576&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250222-b9848a28-a181-47dc-80af-4d2eb6a72756.jpg?resize=1536%2C1152&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250222-b9848a28-a181-47dc-80af-4d2eb6a72756.jpg?w=1600&amp;ssl=1 1600w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n</figure>\n\n\n\n<p>Be sure to mark your calendars for other major WordPress events in 2025: <a href=\"https://europe.wordcamp.org/2025/\">WordCamp Europe</a> (Basel, Switzerland) and<a href=\"https://us.wordcamp.org/2025/\"> WordCamp US</a> (Portland, Oregon, USA). Then join us in Mumbai, India for WordCamp Asia 2026!</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"18515\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"Report: WordPress in 2025\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://wordpress.org/news/2025/02/wordpress-in-2025-report/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 15 Feb 2025 03:19:09 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"General\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=18475\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:379:\"This year is set to be transformative for WordPress, yet many decision-makers risk overlooking the immense opportunities ahead. Our new “WordPress in 2025” report highlights why WordPress should be a cornerstone of your long-term strategy. Stay ahead of the curve—read the report now to see how WordPress can drive growth and innovation for your business in the [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Noel Tock\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3721:\"\n<p>This year is set to be transformative for WordPress, yet many decision-makers risk overlooking the immense opportunities ahead. Our new <strong>“WordPress in 2025”</strong> report highlights why WordPress should be a cornerstone of your long-term strategy. Stay ahead of the curve—read the report now to see how WordPress can drive growth and innovation for your business in the years to come.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"647\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/02/WordPress-in-2025-WPORG-2.jpg?resize=1024%2C647&#038;ssl=1\" alt=\"\" class=\"wp-image-18476\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/02/WordPress-in-2025-WPORG-2.jpg?resize=1024%2C647&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/02/WordPress-in-2025-WPORG-2.jpg?resize=300%2C189&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/02/WordPress-in-2025-WPORG-2.jpg?resize=768%2C485&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/02/WordPress-in-2025-WPORG-2.jpg?resize=1536%2C970&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/02/WordPress-in-2025-WPORG-2.jpg?resize=2048%2C1293&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /></figure>\n\n\n\n<p>Some of the key points we explore:&nbsp;</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>As proprietary &#8220;next-gen&#8221; CMS hype fizzles out and enterprise budgets shift priorities, open-source CMSs like WordPress are primed to gain ground in the commoditized CMS space. WordPress&#8217; maturity and extensibility provide a high starting point for innovation.</li>\n\n\n\n<li>WordPress&#8217; Block Editor has seen tremendous investment, amassing over 34,000 commits &#8211; more than entire competing CMS projects. New capabilities like Full Site Editing (FSE) give enterprises unprecedented ability to enable no-code site building.</li>\n\n\n\n<li>Just as being the first user-friendly publishing tool propelled WordPress&#8217; initial growth, AI presents a similar opportunity. WordPress&#8217; contributor community can build not just AI features, but an exciting multi-agent, LLM-agnostic ecosystem representing an intelligent content operating system.</li>\n\n\n\n<li>Pure-play headless vendors are working backwards to add no-code editing, while WordPress has long supported robust headless capabilities alongside its mature editor. For complex sites, hybrid architectures leveraging both are the pragmatic path forward.</li>\n</ul>\n\n\n\n<p><a href=\"https://wordpress.org/news/files/2025/02/WordPress-in-2025-Report-Noel-Tock.pdf\">Download the full WordPress in 2025 (PDF)</a> report directly to learn more.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Don’t miss WP:25, the virtual event.</h3>\n\n\n\n<p><a href=\"https://humanmade.com/wordpress-in-2025-event/?utm_campaign=41192678-WordPress%20in%202025&amp;utm_source=event&amp;utm_medium=Noel%20sales%20outreach&amp;utm_content=event%20landing%20page\">Save your spot at our free event, WP:25</a>, exploring the future of WordPress and featuring key people working with many of the ideas discussed in the report. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<p><strong>About the report&#8217;s author, <a href=\"https://profiles.wordpress.org/noel_tock/\">Noel Tock</a></strong> — Having built his first website back in 1995, Noel has long been watching the evolution of the CMS space. As a co-owner at one of the leading enterprise WordPress agencies, Human Made, his belief in the power of open source is as great as ever. Human Made is a WordPress VIP Gold Partner specializing in DXP, headless, AI and more.</p>\n\n\n\n<p></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"18475\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:32:\"https://wordpress.org/news/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"\n	hourly	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"\n	1	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:4:\"site\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"14607090\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:48:\"WpOrg\\Requests\\Utility\\CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:12:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Mon, 21 Apr 2025 03:37:51 GMT\";s:12:\"content-type\";s:34:\"application/rss+xml; charset=UTF-8\";s:4:\"vary\";s:37:\"Accept-Encoding, accept, content-type\";s:25:\"strict-transport-security\";s:12:\"max-age=3600\";s:6:\"x-olaf\";s:3:\"⛄\";s:13:\"last-modified\";s:29:\"Tue, 15 Apr 2025 22:16:36 GMT\";s:4:\"link\";s:63:\"<https://wordpress.org/news/wp-json/>; rel=\"https://api.w.org/\"\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:16:\"content-encoding\";s:2:\"br\";s:7:\"alt-svc\";s:19:\"h3=\":443\"; ma=86400\";s:4:\"x-nc\";s:9:\"HIT ord 1\";}}s:5:\"build\";i:1727758220;s:21:\"cache_expiration_time\";i:1745249872;s:23:\"__cache_expiration_time\";i:1745249872;}", "off");
INSERT INTO `wpbq_options` VALUES("2415", "_transient_timeout_feed_mod_9bbd59226dc36b9b26cd43f15694c5c3", "1745249872", "off");
INSERT INTO `wpbq_options` VALUES("2416", "_transient_feed_mod_9bbd59226dc36b9b26cd43f15694c5c3", "1745206672", "off");
INSERT INTO `wpbq_options` VALUES("2417", "duplicator_expire_search-replace-wpcode", "{\"expire\":1746416272,\"value\":{\"wp_version\":\"5.5\",\"php_version\":\"7.0\"}}", "on");
INSERT INTO `wpbq_options` VALUES("2418", "duplicator_expire_wp-mail-smtp", "{\"expire\":1746416272,\"value\":{\"wp_version\":\"5.5\",\"php_version\":\"7.2\"}}", "on");
INSERT INTO `wpbq_options` VALUES("2419", "duplicator_expire_insert-headers-and-footers", "{\"expire\":1746416272,\"value\":{\"wp_version\":\"4.6\",\"php_version\":\"5.5\"}}", "on");
INSERT INTO `wpbq_options` VALUES("2420", "_transient_timeout_feed_d117b5738fbd35bd8c0391cda1f2b5d9", "1745249873", "off");
INSERT INTO `wpbq_options` VALUES("2421", "_transient_feed_d117b5738fbd35bd8c0391cda1f2b5d9", "a:6:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:61:\"\n	\n	\n	\n	\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"WordPress Planet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"en\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"WordPress Planet - http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:50:{i:0;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"Do The Woo Community: Be Flexible\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"https://dothewoo.io/?post_type=blog&p=94847\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"https://dothewoo.io/blog/be-flexible/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"I would not be where I am today if I hadn\'t been flexible.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 20 Apr 2025 08:11:21 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"Matt: Greatest Hits\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=141409\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"https://ma.tt/2025/04/greatest-hits/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:7892:\"<p>I&#8217;ve been blogging now for approximately 8,465 days since my first post on Movable Type. My colleague <a href=\"https://danluu.com/\">Dan Luu</a> helped me compile some of the &#8220;greatest hits&#8221; from the archives of ma.tt, perhaps some posts will stir some memories for you as well:</p>\n\n\n\n<p><a href=\"https://ma.tt/2023/08/i-love-wordcamps/\"><strong>Where Did WordCamps Come From? (2023)</strong></a></p>\n\n\n\n<p>A look back at how Foo Camp and Bar Camp inspired WordCamps.</p>\n\n\n\n<p><a href=\"https://ma.tt/2018/09/ceos-and-the-real-world/\"><strong>Getting Real Feedback as a CEO (2018)</strong></a></p>\n\n\n\n<p>How do you make sure you get good information when you’re CEO? Something we’ve been trying that’s been working is having an anonymous internal forum. Like Blind, but internal to the company, and really anonymous, without anything linking a user ID to a comment.</p>\n\n\n\n<p><a href=\"https://ma.tt/2016/10/wix-and-the-gpl/\"><strong>Wix and the GPL (2016)</strong></a></p>\n\n\n\n<p>That time Wix built their closed-source mobile app on GPL code.</p>\n\n\n\n<p><a href=\"https://ma.tt/2015/02/left-my-heart-in/\"><strong>What I Miss and Don’t Miss About San Francisco (2015)</strong></a></p>\n\n\n\n<p>Self explanatory <img src=\"https://s.w.org/images/core/emoji/15.1.0/72x72/1f642.png\" alt=\"🙂\" class=\"wp-smiley\" /></p>\n\n\n\n<p><a href=\"https://ma.tt/2015/02/advice-and-fallacies/\"><strong>Advice About Advice (2015)</strong></a></p>\n\n\n\n<p>Why you need to think things through from first principles and not just blindly follow advice.</p>\n\n\n\n<p><a href=\"https://ma.tt/2014/04/the-web-matters/\"><strong>Why the Web Still Matters (2014)</strong></a></p>\n\n\n\n<p>A guest post by Ben Thompson of <a href=\"https://stratechery.com/\">Stratechery</a> on why “the web is dead” comments were wrong in 2014. Still true today!</p>\n\n\n\n<p><a href=\"https://ma.tt/2014/01/four-freedoms/\"><strong>The Four Freedoms (2014)</strong></a></p>\n\n\n\n<p>A discussion of Stallman’s four open source freedoms. Our open source Bill of Rights, if you will.</p>\n\n\n\n<p><a href=\"https://ma.tt/2014/01/intrinsic-blogging/\"><strong>The Intrinsic Value of Blogging (2014)</strong></a></p>\n\n\n\n<p>On ignoring vanity metrics and blogging for intrinsic reasons</p>\n\n\n\n<p><strong>What’s in My Bag </strong><a href=\"https://ma.tt/2015/01/whats-in-my-bag-2014/\"><strong>2014</strong></a><strong>, </strong><a href=\"https://ma.tt/2016/03/whats-in-my-bag-2016-edition/\"><strong>2016</strong></a><strong>, </strong><a href=\"https://ma.tt/2017/05/whats-in-my-bag-2017/\"><strong>2017</strong></a><strong>, </strong><a href=\"https://ma.tt/2018/10/whats-in-my-bag-2018-edition/\"><strong>2018</strong></a><strong>, </strong><a href=\"https://ma.tt/2021/01/whats-in-my-bag-2020/\"><strong>2020</strong></a><strong>, </strong><a href=\"https://ma.tt/2023/12/the-bag-post/\"><strong>2023</strong></a><strong>, </strong><a href=\"https://ma.tt/2025/01/2025-bag/\"><strong>2025</strong></a></p>\n\n\n\n<p>What I’ve been carrying in my travel bag&nbsp;</p>\n\n\n\n<p><a href=\"https://ma.tt/2011/09/automattic-creed/\"><strong>Why Your Company Should Have a Creed (2011)</strong></a></p>\n\n\n\n<p>I&#8217;m really jazzed that dozens of companies have adopted this or similar ideas since then.</p>\n\n\n\n<p><a href=\"https://ma.tt/2010/11/one-point-oh/\"><strong>1.0 is the Loneliest Number (2010)</strong></a></p>\n\n\n\n<p>On the importance of releasing quickly and getting feedback.</p>\n\n\n\n<p><a href=\"https://ma.tt/2010/05/twitter-api/\"><strong>The Twitter API (2010)</strong></a></p>\n\n\n\n<p>A discussion on the Twitter API missing the boat on, as Jack Dorsey put it, becoming a protocol.</p>\n\n\n\n<p><a href=\"https://ma.tt/2010/02/i-miss-school/\"><strong>I Miss School (2010)</strong></a></p>\n\n\n\n<p>Just like they say, youth is wasted on the young, I think I squandered school when I was in it.</p>\n\n\n\n<p><a href=\"https://ma.tt/2009/08/starting-a-bank/\"><strong>What Startup Idea Would I suggest? Start a Bank (2009)</strong></a></p>\n\n\n\n<p>There’s been a lot of action in the payments space since 2009. For new companies, we have Square (2009), Stripe (2010), and Wealthsimple (2014), among others. Ally Bank (rebranded from GMAC in 2010) has also been trying to provide a modern customer-focused experience.</p>\n\n\n\n<p><a href=\"https://ma.tt/2009/08/kill-your-community/\"><strong>Six Steps to Kill Your Community (2009)</strong></a></p>\n\n\n\n<p>Platform and product anti-patterns.</p>\n\n\n\n<p><a href=\"https://ma.tt/2009/07/not-lonely-at-all/\"><strong>In Defense of the GPL for Open Source Projects (2009)</strong></a></p>\n\n\n\n<p>This was a response to a popular post about how GPL open source projects would lose out to projects under licenses like MIT, BSD, and Apache. I didn’t agree then and I don’t agree now.&nbsp;</p>\n\n\n\n<p><a href=\"https://ma.tt/2009/06/the-way-i-work-annotated/\"><strong>The Way I Work (2009)</strong></a></p>\n\n\n\n<p>Self explanatory <img src=\"https://s.w.org/images/core/emoji/15.1.0/72x72/1f642.png\" alt=\"🙂\" class=\"wp-smiley\" /></p>\n\n\n\n<p><a href=\"https://ma.tt/2008/05/infrastructure-as-competitive-advantage/\"><strong>Infrastructure as Competitive Advantage (2008)</strong></a></p>\n\n\n\n<p>On the importance of performance, reliability, and security. This was a core priority for us and it shows. <span>We dominate the competition on third-party performance comparisons&nbsp;<a href=\"https://x.com/danluu/status/1890232671084900643\" target=\"_blank\">at the platform level</a>&nbsp;and on&nbsp;<a href=\"https://danluu.com/slow-device/\" target=\"_blank\">the default user experience,</a>&nbsp;and&nbsp;<a href=\"https://ma.tt/2025/03/real-wordpress-security/\" target=\"_blank\">our security is top-notch</a>.</span></p>\n\n\n\n<p><a href=\"https://ma.tt/2007/07/price-of-freedom/\"><strong>The Price of Freedom and Open Source Licenses (2007)</strong><strong><br /></strong><strong><br /></strong></a>A response to a user who wanted the ability to remove GPL freedoms from WordPress.</p>\n\n\n\n<p><a href=\"https://ma.tt/2007/07/on-php/\"><strong>The PHP5 Transition (2007)</strong></a></p>\n\n\n\n<p>How PHP5 forced us to divert time and attention away from users to deal with migration costs.</p>\n\n\n\n<p><a href=\"https://ma.tt/2007/03/kapor-vs-zuckerberg/\"><strong>Mitch Kapor vs. Mark Zuckerberg (2007)</strong></a></p>\n\n\n\n<p>At Startup School, Kapor advocated for having team diversity while Zuckerberg advocated for a “young and technical” because the best work comes from young people. Now that Facebook (Meta) has grown up, Zuckerberg is doing what Kapor said companies should do and not what Zuckerberg said companies should do! Zuckerberg’s trusted people aren’t young anymore and aren’t being replaced by the young.</p>\n\n\n\n<p><a href=\"https://ma.tt/2007/01/relevant-sun/\"><strong>Sun Isn’t Relevant to Startups (2007)</strong></a><strong>, and </strong><a href=\"https://ma.tt/2007/01/sun-followup/\"><strong>Followup (2007)</strong></a></p>\n\n\n\n<p>A discussion of Sun’s Startup Essentials program and Jonathan Schwartz&#8217;s (then CEO of Sun) reply.</p>\n\n\n\n<p><a href=\"https://ma.tt/2006/04/feed-validator/\"><strong>The RSS Feed Validator is Dead to Me (2006)</strong></a></p>\n\n\n\n<p>The RSS 2.0 feed validator is old news today but the experience here is a good example of why people didn’t take any of these validators seriously and they’re all old news</p>\n\n\n\n<p><a href=\"https://ma.tt/2006/03/hours-and-work/\"><strong>There’s No Correlation Between Hours Worked and Work Done (2006)</strong></a></p>\n\n\n\n<p>Self explanatory <img src=\"https://s.w.org/images/core/emoji/15.1.0/72x72/1f642.png\" alt=\"🙂\" class=\"wp-smiley\" /></p>\n\n\n\n<p><a href=\"https://ma.tt/2005/11/hidden-costs/\"><strong>Should We Have Hidden Options? (2005)</strong></a></p>\n\n\n\n<p>A discussion of the hidden cost of hidden options.</p>\n\n\n\n<p>We probably missed some, if there’s a post you think should be included leave it in the comments.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 19 Apr 2025 23:56:17 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"Do The Woo Community: Vibes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"https://dothewoo.io/?post_type=blog&p=94797\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://dothewoo.io/blog/vibes/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:176:\"BobWP\'s short reflection on the resurgence of the term \"vibes,\" expressing ambivalence, especially regarding its use in technology and media, and anticipating branded products.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 19 Apr 2025 08:24:53 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:124:\"Gutenberg Times: WordPress 6.8 released, Block Accessibility checks, Stacking cards layout, and more — Weekend Edition 326\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://gutenbergtimes.com/?p=39995\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:128:\"https://gutenbergtimes.com/wordpress-6-8-released-block-accessibility-checks-stacking-cards-layout-and-more-weekend-edition-326/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:14980:\"<p>Hi there, </p>\n\n\n\n<p>In most European countries, Easter is a four-day weekend with two bank holidays, on Good Friday and Easter Monday. It&#8217;s a welcome occasion to unplug and enjoy the life right in front of you. For me, that&#8217;s organizing my home, celebrating Spring in the English Garden, friends coming over for a card game and lots of art. What are you doing to unplug?</p>\n\n\n\n<p>A huge shoutout to <strong>Simon Kraft</strong>, Krautpress <img src=\"https://s.w.org/images/core/emoji/15.1.0/72x72/1f44b.png\" alt=\"👋\" class=\"wp-smiley\" /> for inviting me to the WordPress Meetup in Konstanz this week! I had an awesome time and loved connecting with the German WordPress community. Plus, I&#8217;ve now got <a href=\"https://bit.ly/playground-wm-konstanz\">the German version of the slidedeck </a>from my WordCamp Asia presentation!</p>\n\n\n\n<p>This week, the final release of WordPress 6.8 came out &#8220;Cecil&#8221;, the last major WordPress version for 2025. We will see more minor releases for sure, the first one is scheduled tentatively for April 29, 2025.</p>\n\n\n\n<p>And now, if you celebrate  it or not, I wish you and yours a Happy Easter! <img src=\"https://s.w.org/images/core/emoji/15.1.0/72x72/1f423.png\" alt=\"🐣\" class=\"wp-smiley\" /><img src=\"https://s.w.org/images/core/emoji/15.1.0/72x72/1f430.png\" alt=\"🐰\" class=\"wp-smiley\" /></p>\n\n\n\n<p>CU next week again, <img src=\"https://s.w.org/images/core/emoji/15.1.0/72x72/1f495.png\" alt=\"💕\" class=\"wp-smiley\" /><br /><em>Birgit</em></p>\n\n\n\n<div class=\"wp-block-group has-light-background-background-color has-background\"><div class=\"wp-block-group__inner-container is-layout-flow wp-block-group-is-layout-flow\">\n<p><strong>Table of Contents</strong></p>\n\n\n\n<ol><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/wordpress-6-8-released-block-accessibility-checks-stacking-cards-layout-and-more-weekend-edition-326/#wordpress-6-8\">WordPress 6.8</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/wordpress-6-8-released-block-accessibility-checks-stacking-cards-layout-and-more-weekend-edition-326/#0-p\">Plugins and Tools for #nocode site builders and owners</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/wordpress-6-8-released-block-accessibility-checks-stacking-cards-layout-and-more-weekend-edition-326/#3-building-themes-for-fse-and-word-press\">Building Blocks and Tools for the Block editor</a></li></ol>\n</div></div>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"wordpress-6-8\">WordPress 6.8</h2>\n\n\n\n<p><a href=\"https://wordpress.org/news/2025/04/cecil/\"><strong>WordPress 6.8 “Cecil”</strong></a> is out! It honors the legendary pianist and jazz pioneer Cecil Taylor. Congratulations to the <em>release quad</em> and the over 900 contributors from over 60 countries, 250 of them were first timers.</p>\n\n\n\n<p><strong>Jeff Paul</strong> wrote in the release post: &#8220;WordPress 6.8 polishes and refines the tools that you use every day, making your site faster, more secure, and easier to manage.&nbsp; The Style Book now has a structured layout and works with Classic themes, giving you more control over global styles. Speculative loading speeds up navigation by preloading links before users navigate to them, bcrypt hashing strengthens password security automatically, and database optimizations improve performance.&#8221;</p>\n\n\n\n<p>If you want to take a deep dive into all the updates, here are the couple of links, I shared before: </p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>The <a href=\"https://make.wordpress.org/core/2025/03/28/wordpress-6-8-field-guide/\"><strong>WordPress 6.8 Field Guide</strong></a> has all the cool updates that matter to developers.</li>\n\n\n\n<li>Don’t miss the <a href=\"https://gutenbergtimes.com/source-of-truth-wordpress-6-8/\"><strong>Source of Truth (WordPress 6.8)</strong></a> for the latest on Block editor updates.</li>\n</ul>\n\n\n\n<p>More articles covering 6.8 from different point of views: </p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>In <a href=\"https://wordpress.com/blog/2025/04/15/wordpress-6-8/\"><strong>WordPress 6.8: Feature Highlights and&nbsp;Improvements</strong></a>, <strong>Jonathan Bossenger</strong> compiled a comprehensive list of the user facing changes of the new version.</li>\n\n\n\n<li><strong>Bud Kraus</strong> discovered <a href=\"https://www.hostinger.com/blog/wordpress-6-8\"><strong>6 key changes in WordPress 6.8</strong></a> for the Hostinger Blog. </li>\n\n\n\n<li><strong>Justin Tadlock</strong> published <a href=\"https://wordpress.com/blog/2025/04/16/wordpress-6-8-developers\"><strong>The Developer’s Guide to WordPress&nbsp;6.8</strong></a></li>\n\n\n\n<li><strong>Gianna Legate</strong>, HumanMade explained <a href=\"https://humanmade.com/wordpress-for-enterprise/what-wordpress-6-8-means-for-enterprise-features-and-benefits/\"><strong>What WordPress 6.8 means for enterprise: Features and benefits</strong></a> </li>\n\n\n\n<li><strong>Jeff Paul </strong>recounts how <a href=\"https://10up.com/blog/2025/team-contribute-wordpress-6-8/\"><strong>Fueled+10up Leads the Way in the Making of WordPress 6.8</strong></a></li>\n</ul>\n\n\n\n<div class=\"wp-block-group has-light-background-background-color has-background\"><div class=\"wp-block-group__inner-container is-layout-constrained wp-block-group-is-layout-constrained\">\n<p><img src=\"https://s.w.org/images/core/emoji/15.1.0/72x72/1f399.png\" alt=\"🎙\" class=\"wp-smiley\" /> Latest episode: <a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-116-wordpress-6-8-field-guide/\">Gutenberg Changelog 116 – WordPress 6.8, Source of Truth, Field Guide, Gutenberg 20.5 and 20.6</a> with special guest JC Palmes, WebDev Studios</p>\n\n\n\n<img width=\"652\" height=\"184\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/04/Screenshot-2025-04-05-at-12.27.14.png?resize=652%2C184&ssl=1\" alt=\"\" class=\"wp-image-39894\" />\n</div></div>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"0-p\">Plugins and Tools for #nocode site builders and owners<a href=\"https://bsky.app/profile/troychaplin.bsky.social\"></a></h2>\n\n\n\n<p>Last week, I mentioned the <a href=\"https://wordpress.com/ai-website-builder/\"><em>new AI builder at WordPress.com</em></a>. <strong>Matt Medeiros</strong>, <em>WPMinute</em>, took it out for a spin and in his video you will be right there with him, getting a first impression. <a href=\"https://www.youtube.com/watch?v=SxrWvHv90wM\"><strong>I Tried the WordPress.com AI Builder</strong></a>.</p>\n\n\n<div width=\"100%\" class=\"wp-block-newsletterglue-showhide ng-block\">\n<div class=\"wp-block-embed__wrapper\">\n\n</div>\n</div>\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><a href=\"https://bsky.app/profile/troychaplin.bsky.social\"><strong>‪Troy Chaplin</strong>‬</a> continued his work on the <a href=\"https://wordpress.org/plugins/block-accessibility-checks/\"><strong>Block Accessibility Checks plugin</strong></a>. For the new features he added to the existing image conditions a check for the alt text length and matches with captions, plus tools to help follow WP coding standards. <a href=\"https://wordpress.org/plugins/block-accessibility-checks/\">Version 1.2.0</a> now is ready for download from the WordPress plugin repository. </p>\n\n\n\n<img width=\"652\" height=\"277\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/04/Block-Accesibility-check-screenshot.png?resize=652%2C277&ssl=1\" alt=\"Screenshot Block Accessibility Check plugin v. 1.2\" class=\"wp-image-40006\" />\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Jean-Baptist Audras,</strong> a core committer and engineer at the Whodunit agency, just dropped the <a href=\"https://wordpress.org/plugins/who-inline-quote-format/\"><strong>Inline Quote Format Button for the Block Editor</strong></a> plugin in the WordPress repository.  With this plugin activated, content creators can easily mark inline citations using the <code>q</code> HTML element right from the Format toolbar in the block editor. This way they make sure that assistive technologies get that the sentence is a citation, keeping things clear for everyone!  Using this plugin keeps your site inline with one of the European Accessibility Act&#8217;s (EAA) criteria to properly indicate inline citations, according to Audras. To style the inline quote use the <strong>Editor &gt; Styles &gt; Additional CSS</strong> and add CSS for the element q, i.e., <code>q {color:purple}</code>. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>In his latest video, <strong>Jamie Marsland</strong> shows you <strong><a href=\"https://www.youtube.com/watch?v=IH3RINZ8rWI\">how to create beautiful Stacking Cards in WordPress</a></strong>. &#8220;You’ll get a behind-the-scenes look at the process so you can understand how it works and tweak it for your own needs.&#8221; he wrote in the description. </p>\n\n\n<div width=\"100%\" class=\"wp-block-newsletterglue-showhide ng-block\">\n<div class=\"wp-block-embed__wrapper\">\n\n</div>\n</div>\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>&nbsp;<a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/\" target=\"_blank\" rel=\"noreferrer noopener\">&#8220;Keeping up with Gutenberg &#8211; Index 2025&#8221;</a>&nbsp;</strong><br />A chronological list of the WordPress Make Blog posts from various teams involved in Gutenberg development: Design, Theme Review Team, Core Editor, Core JS, Core CSS, Test, and Meta team from Jan. 2024 on. Updated by yours truly. The previous years are also available: <strong><strong><a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2020/\">2020</a>&nbsp;|&nbsp;<a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2021/\">2021</a></strong>&nbsp;|&nbsp;<strong><a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2022/\">2022</a></strong></strong>&nbsp;|&nbsp;<strong><a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/gutenberg-index-2023\">2023</a></strong> | <a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/gutenberg-index-2024/\"><strong>2024</strong></a></p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"3-building-themes-for-fse-and-word-press\">Building Blocks and Tools for the Block editor</h2>\n\n\n\n<p><strong>JuanMa Garrido</strong>, developer advocate at Automattic, takes you with him on <a href=\"https://juanma.codes/2025/04/17/a-deep-dive-into-a-blocks-attributes/\"><strong>A deep dive into a block’s “attributes”</strong></a>. He explores how attributes work within WordPress blocks, focusing on their role in storing and managing block data. Garrido explains the different types of attributes, such as string, number, array, and object, and demonstrates how to define them in a block’s code. The article also covers how attributes are sourced from HTML, how they persist in the block’s markup, and how developers can use them to control block behavior and appearance. Practical code examples illustrate best practices for defining, accessing, and updating attributes in custom Gutenberg blocks.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Riad Benguella</strong> announced new features for Studio app. <a href=\"https://wordpress.com/blog/2025/03/31/studio-custom-domains-https/\"><strong>Add Custom Domains and HTTPS Support to Your Local WordPress Development</strong>.</a> User can now make local WordPress development more closely mirror live production environments. Developers can now assign custom wp<code>.local</code> domains and enable SSL for their local sites. It helps developer with better testing of plugins and themes that require specific domains or secure connections. The process is streamlined, with Studio handling most technical details automatically, though macOS users must manually install the SSL certificate. These updates aim to enhance flexibility and realism in local development workflows, based on user feedback, as Studio continues to evolve. You can <a href=\"https://developer.wordpress.com/studio/\">download open-source Studio for free</a>. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong><a href=\"https://gutenbergtimes.com/need-a-zip-from-master/\">Need a plugin .zip from Gutenberg&#8217;s master branch?</a></strong><br />Gutenberg Times provides daily build for testing and review. </p>\n\n\n\n<p>Now also available via <a href=\"https://playground.wordpress.net/?blueprint-url=https://gutenbergtimes.com/wp-content/uploads/2020/11/playnightly.json\">WordPress Playground</a>. There is no need for a test site locally or on a server. Have you been using it? <a href=\"mailto:pauli@gutenbergtimes.com\">Email me </a>with your experience</p>\n\n\n\n<p><img alt=\"GitHub all releases\" src=\"https://img.shields.io/github/downloads/bph/gutenberg/total?style=for-the-badge\" /></p>\n\n\n\n<p class=\"has-text-align-left has-small-font-size\"><em>Questions? Suggestions? Ideas? </em> <em>Don&#8217;t hesitate to send <a href=\"mailto:pauli@gutenbergtimes.com\">them via email</a> or</em><br /><em> send me a message on WordPress Slack or Twitter @bph</em>. </p>\n\n\n\n<p class=\"has-text-align-left has-small-font-size\">For questions to be answered on the <a href=\"http://gutenbergtimes.com/podcast\">Gutenberg Changelog</a>, email to <a href=\"mailto:changelog@gutenbergtimes.com\">changelog@gutenbergtimes.com</a></p>\n\n\n\n<p>Featured Image: Skyline Chicago by Birgit Pauli-Haack</p>\n\n\n\n<hr class=\"wp-block-separator has-css-opacity is-style-wide\" />\n\n\n\n<p class=\"has-text-align-left\"><strong>Don&#8217;t want to miss the next Weekend Edition? </strong></p>\n\n\n<form class=\"wp-block-newsletterglue-form ngl-form ngl-portrait\" action=\"https://gutenbergtimes.com/feed/\" method=\"post\"><div class=\"ngl-form-container\"><div class=\"ngl-form-field\"><label class=\"ngl-form-label\" for=\"ngl_email\"><br />Type in your Email address to subscribe.</label><div class=\"ngl-form-input\"><input type=\"email\" class=\"ngl-form-input-text\" name=\"ngl_email\" id=\"ngl_email\" /></div></div><button type=\"submit\" class=\"ngl-form-button\">Subscribe</button><p class=\"ngl-form-text\">We hate spam, too, and won&#8217;t give your email address to anyone <br />except Mailchimp to send out our Weekend Edition</p></div><div class=\"ngl-message-overlay\"><div class=\"ngl-message-svg-wrap\"></div><div class=\"ngl-message-overlay-text\">Thanks for subscribing.</div></div><input type=\"hidden\" name=\"ngl_list_id\" id=\"ngl_list_id\" value=\"26f81bd8ae\" /><input type=\"hidden\" name=\"ngl_double_optin\" id=\"ngl_double_optin\" value=\"yes\" /></form>\n\n\n<hr class=\"wp-block-separator has-css-opacity is-style-wide\" />\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 18 Apr 2025 23:27:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Birgit Pauli-Haack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:116:\"Do The Woo Community: From Page Views to Conversions: Improving Products with WordPress Analytics with Derek Ashauer\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=94460\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:114:\"https://dothewoo.io/from-page-views-to-conversions-improving-products-with-wordpress-analytics-with-derek-ashauer/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:224:\"In this episode of Woo ProductChat, James and Katie discuss user analytics with Derek Ashauer, emphasizing data-driven decisions for WordPress product owners, conversion tracking, and actionable insights for business growth.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 18 Apr 2025 14:34:48 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"Gravatar: Best Digital Business Cards for Lead Generation\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"http://blog.gravatar.com/?p=3062\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"https://blog.gravatar.com/2025/04/18/best-digital-business-card/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:17000:\"<p>Did you know that <a href=\"https://wavecnct.com/blogs/news/business-card-statistics\">88% of paper business cards are thrown away within a week</a>? This staggering statistic highlights a common frustration for professionals – traditional business cards often fail to create lasting connections.</p>\n\n\n\n<p>Digital business cards offer a smarter approach to networking. Unlike paper cards that get lost or discarded, these modern alternatives let you share contact details instantly through QR codes and track when recipients view your information. Plus, many digital cards integrate with Customer Relationship Management (CRM) systems, transforming simple contact sharing into a powerful lead generation tool.</p>\n\n\n\n<p>In this article, we&#8217;ll explore the best digital business card options available so you can decide on the tools that will enhance your <a href=\"https://blog.gravatar.com/2024/04/10/personal-branding-tools/\">personal brand</a>, help you build stronger professional relationships, or generate more leads.</p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Why digital business cards are your new lead generation engine</strong></h2>\n\n\n\n<p>Remember when business cards were just pieces of paper with your name and phone number? Those days are gone. Modern digital business cards work more like miniature marketing systems – they don&#8217;t just <a href=\"https://blog.gravatar.com/2024/08/02/organizational-benefits-of-efficient-contact-sharing/\">share your contact info</a>; they help you build and nurture professional relationships.</p>\n\n\n\n<p>The growth in digital business card adoption tells an interesting story. According to recent research, the <a href=\"https://www.globenewswire.com/news-release/2023/04/17/2647635/0/en/Digital-Business-Card-Market-Size-is-Estimated-to-Hit-US-500-Million-by-2033-North-America-Leads-the-Industry-Share-Fact-MR-Report.html#:~:text=Worldwide%20demand%20for%20digital%20business%20cards%20is%20forecasted%20to%20surge%20at%20a%20CAGR%20of%209.5%25%20during%20the%20forecast%20period%20(2023%20to%202033).\">worldwide demand for digital business cards is forecasted to surge</a> at a rate of 9.5% during the forecast period (2023 to 2033). And it makes sense – who wouldn&#8217;t want a business card that automatically saves contacts and helps track potential leads?</p>\n\n\n\n<p>Think of it like having a tiny personal assistant in your pocket. When you share your digital card via QR code, it transfers contact details and automatically logs the interaction in your CRM system. Some cards even notify you when someone views your profile or downloads your materials.&nbsp;</p>\n\n\n\n<p>This tracking capability transforms how you follow up with contacts. Instead of playing the guessing game of &#8220;Should I reach out now?&#8221;, you can actively see who&#8217;s actively engaged with your profile and time your follow-ups perfectly. Spot a potential client who just viewed your portfolio? That&#8217;s your cue to send a friendly check-in message.</p>\n\n\n\n<p>These tools come at various price points and with different features. Some focus on simple contact sharing, while others offer full suites of lead generation and analytics tools. For example, a sales team might want advanced CRM integration and tracking, while a freelance designer might just need basic contact sharing with a portfolio link.</p>\n\n\n\n<p>Let&#8217;s explore some specific options and find out which might work best for your needs.</p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Guide to the top digital business card platforms&nbsp;</strong></h2>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>1. Gravatar</strong></h3>\n\n\n\n<img width=\"1397\" height=\"716\" src=\"https://blog.gravatar.com/wp-content/uploads/2025/03/gravatar-new-homepage.png\" alt=\"Gravatar homepage\" class=\"wp-image-3064\" />\n\n\n\n<p><a href=\"https://gravatar.com/\">Gravatar</a> is a versatile platform that can easily become your online business card that never runs out and updates itself everywhere at once. This free service from <a href=\"https://automattic.com/\">Automattic</a> (the folks behind <a href=\"http://wordpress.com\">WordPress.com</a>) turns your email address into a universal online identity that follows you across thousands of websites.</p>\n\n\n\n<img width=\"1421\" height=\"985\" src=\"https://blog.gravatar.com/wp-content/uploads/2025/03/ronnie-gravatar-profile.png\" alt=\"Example of a Gravatar profile\" class=\"wp-image-3065\" />\n\n\n\n<p>What makes Gravatar special? Unlike standalone digital business cards, your Gravatar profile automatically appears whenever you comment, contribute, or interact on supported platforms – from WordPress blogs to <a href=\"https://github.com/trending\">GitHub repositories</a>. Update your information once at Gravatar.com, and those changes instantly sync everywhere your profile appears.</p>\n\n\n\n<p>Going to a <a href=\"https://blog.gravatar.com/2025/02/17/how-to-be-better-at-networking/\">networking event</a> and need to share your details in person? Gravatar has you covered. Add your profile to <a href=\"https://www.apple.com/wallet/\">Apple</a> or <a href=\"https://play.google.com/store/apps/details?id=com.google.android.apps.walletnfcrel\">Google Wallet</a> for quick QR code sharing at networking events. Getting started takes just minutes – visit Gravatar.com, create a profile, and you&#8217;ve got a powerful <a href=\"https://blog.gravatar.com/2024/11/08/creating-a-digital-business-card/\">digital business card</a> that works automatically across the web, completely free of charge.</p>\n\n\n\n<a href=\"https://gravatar.com/connect/?gravatar_from=blog\"><img width=\"3243\" height=\"729\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/12/free_profile_cta.png\" alt=\"\" class=\"wp-image-2616\" /></a>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>2. HiHello</strong></h3>\n\n\n\n<img width=\"1380\" height=\"869\" src=\"https://blog.gravatar.com/wp-content/uploads/2025/03/hihello-homepage.png\" alt=\"HiHello homepage\" class=\"wp-image-3067\" />\n\n\n\n<p><a href=\"https://www.hihello.com/\">HiHello</a> is a full-featured digital business card platform that combines contact sharing with lead-tracking capabilities. Users can share their cards through NFC tapping or QR codes, with the option to add cards directly to Apple or Google Wallet for quick access.</p>\n\n\n\n<p>The platform includes several practical features:&nbsp;</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>CRM integration for automatic contact syncing.</li>\n\n\n\n<li>Analytics to track card views and engagement.</li>\n\n\n\n<li>An AI scanner that can digitize paper business cards.</li>\n\n\n\n<li>Consistent branding through customizable templates, colors, and QR code designs.</li>\n</ul>\n\n\n\n<p>The pricing structure has four tiers:&nbsp;</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Free tier for personal use and some basic features.&nbsp;</li>\n\n\n\n<li>Professional plan ($6/month), which adds features like custom branding, advanced analytics, and unlimited card designs.</li>\n\n\n\n<li>Business tier ($5/user/month) that provides administrative controls, CRM integration, and team-wide templates.&nbsp;</li>\n\n\n\n<li>Enterprise options with custom pricing, additional security features, and various deployment solutions.</li>\n</ul>\n\n\n\n<p><strong>Worth noting:</strong> While the free tier works well for individuals, many of the lead generation and tracking features require a paid subscription.</p>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>3. Popl</strong></h3>\n\n\n\n<img width=\"1351\" height=\"749\" src=\"https://blog.gravatar.com/wp-content/uploads/2025/03/popl-homepage.png\" alt=\"Popl homepage\" class=\"wp-image-3068\" />\n\n\n\n<p><a href=\"https://popl.co/\">Popl</a> is an AI-powered digital business card platform with a focus on lead capture and event networking. The platform&#8217;s standout feature is its versatile scanning capability – not just for traditional business cards but also for conference badges, <a href=\"https://www.linkedin.com/help/linkedin/answer/a525286/using-a-linkedin-qr-code-to-connect-with-members\">LinkedIn QR codes</a>, and even digital cards from other platforms.</p>\n\n\n\n<p>The platform includes several conference-focused features:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>AI-powered contact enrichment to automatically fill in missing information.</li>\n\n\n\n<li>Offline scanning capabilities for poor Wi-Fi environments.</li>\n\n\n\n<li>Direct CRM synchronization.</li>\n\n\n\n<li>Event-specific lead qualifiers and tagging.</li>\n\n\n\n<li>Detailed marketing attribution tracking.</li>\n</ul>\n\n\n\n<p>The pricing structure is tiered:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Free tier for basic individual digital cards.</li>\n\n\n\n<li>Professional plan ($11.99/month), unlocking advanced CRM features, lead capture, and analytics.</li>\n\n\n\n<li>Team plans with custom pricing, offering additional features like shared templates and administrative controls.</li>\n</ul>\n\n\n\n<p><strong>Worth noting:</strong> While Popl provides free digital business cards, its core strength lies in its lead capture and event management capabilities, which are only available in paid tiers.</p>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>4. Wave</strong></h3>\n\n\n\n<img width=\"660\" height=\"393\" src=\"https://blog.gravatar.com/wp-content/uploads/2025/03/wave-homepage.png?w=660\" alt=\"Wave homepage\" class=\"wp-image-3069\" />\n\n\n\n<p><a href=\"http://wavecnct.com\">Wave</a> combines digital business card functionality with lead generation tools. The platform offers automatic synchronization – when users update their contact details, the changes reflect instantly across all shared cards and integrations.</p>\n\n\n\n<p>The platform includes several networking-focused features:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Deep customization options for fonts, colors, and design elements.</li>\n\n\n\n<li>Quick-capture lead forms for events and conferences.</li>\n\n\n\n<li>Integration with major CRMs, including <a href=\"https://www.hubspot.com/\">HubSpot</a>.</li>\n\n\n\n<li>PDF and video file hosting capabilities.</li>\n\n\n\n<li>Real-time analytics and engagement tracking.</li>\n</ul>\n\n\n\n<p>The pricing structure follows a simple model:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Free tier offering basic digital business cards and contact sharing.</li>\n\n\n\n<li>Professional plan ($4.99/month) that adds features like video uploads, file hosting, and advanced analytics.</li>\n\n\n\n<li>Business tier with custom pricing for team management and enterprise features.</li>\n</ul>\n\n\n\n<p><strong>Worth noting:</strong> While Wave provides comprehensive free features, some of its more advanced networking capabilities require a paid subscription.</p>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>5. Mobilo&nbsp;</strong></h3>\n\n\n\n<img width=\"660\" height=\"322\" src=\"https://blog.gravatar.com/wp-content/uploads/2025/03/mobilo-homepage.png?w=660\" alt=\"Mobilo homepage\" class=\"wp-image-3070\" />\n\n\n\n<p><a href=\"https://www.mobilocard.com/\">Mobilo</a> positions itself as a business card solution designed specifically for professional teams, with an emphasis on personal branding and event networking. The platform treats each digital card as a mini landing page, allowing extensive customization.</p>\n\n\n\n<p>The platform includes several team-focused features:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Customizable headers, video embeds, and downloadable content hosting.</li>\n\n\n\n<li>Event-focused lead capture with automated follow-ups.</li>\n\n\n\n<li>Integration with email systems for automated presentation sharing.</li>\n\n\n\n<li>Built-in calendar linking capabilities.</li>\n\n\n\n<li>Detailed ROI tracking for events and networking activities.</li>\n</ul>\n\n\n\n<p>The pricing structure is flexible and based on several factors:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Card material choice (recyclable plastic, wood, or stainless steel).</li>\n\n\n\n<li>Number of team members.</li>\n\n\n\n<li>Required features and integrations.</li>\n\n\n\n<li>Physical NFC card requirements.</li>\n</ul>\n\n\n\n<p><strong>Worth noting: </strong>For specific pricing details and customized team solutions, interested users should visit <a href=\"https://www.mobilocard.com/pricing\">Mobilo&#8217;s pricing page</a>, as costs vary based on organizational needs and setup requirements.</p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Gravatar: Your universal digital identity solution</strong></h2>\n\n\n\n<p>Gravatar takes a unique double approach to digital business cards – it integrates them automatically into the platforms professionals use daily and can serve offline networking with a dynamic QR code.&nbsp;</p>\n\n\n\n<p>Simply add your Gravatar profile to Apple or Google Wallet for instant QR code sharing at events and meetings.</p>\n\n\n\n<img width=\"660\" height=\"466\" src=\"https://blog.gravatar.com/wp-content/uploads/2025/03/gravatar-qr-code-example.png?w=660\" alt=\"Example of a Gravatar profile QR code\" class=\"wp-image-3071\" />\n\n\n\n<p>Unlike standalone solutions that mostly require manual sharing, your Gravatar profile appears naturally wherever you engage online – from WordPress blogs to <a href=\"https://github.com/\">GitHub</a> repositories, <a href=\"https://slack.com/\">Slack</a> channels, and <a href=\"https://www.atlassian.com/\">Atlassian</a> products.</p>\n\n\n\n<img width=\"1328\" height=\"695\" src=\"https://blog.gravatar.com/wp-content/uploads/2025/03/update-once-sync-everywhere-1.png\" alt=\"Gravatar profile syncing capabilities\" class=\"wp-image-3072\" />\n\n\n\n<p>Think of it as a self-maintaining digital business card. Update your Gravatar profile once, and those changes ripple across every platform where your email address appears. No more checking multiple profiles or worrying about outdated information. This works great for offline networking as well. When someone scans your QR code, they will be led to your profile, which is always up-to-date, unlike normal business cards.&nbsp;</p>\n\n\n\n<p>For professionals managing multiple identities, Gravatar&#8217;s email-based system lets you maintain separate profiles – use one email for work-related platforms and another for personal projects. This separation ensures you present the right image in each context.</p>\n\n\n\n<p>However, the true power of Gravatar lies in its organic reach. Rather than only actively exchanging contact information, potential connections discover your profile naturally as they interact with your comments, contributions, or collaborations across the web.&nbsp;</p>\n\n\n\n<img width=\"660\" height=\"366\" src=\"https://blog.gravatar.com/wp-content/uploads/2025/03/gravatar-comment-section-1.png?w=660\" alt=\"Example of a Gravatar profile showing automatically in a WordPress blog comment section\" class=\"wp-image-3073\" />\n\n\n\n<table class=\"has-fixed-layout\"><tbody><tr><td><img src=\"https://s0.wp.com/wp-content/mu-plugins/wpcom-smileys/twemoji/2/72x72/1f913.png\" alt=\"🤓\" class=\"wp-smiley\" /><strong>Tip:</strong> <em>Add your Gravatar URL to your </em><a href=\"https://blog.gravatar.com/2024/12/20/link-in-bio-tools/\"><em>social media bio links</em></a><em> to further expand this passive networking effect.</em></td></tr></tbody></table>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Create your digital business card with Gravatar today</strong></h2>\n\n\n\n<p>Platforms like HiHello, Popl, Wave, and Mobilo offer solid digital business card features, but Gravatar stands apart with its unique integration-first approach. Unlike these services that require manual sharing or paid subscriptions for advanced features, Gravatar provides comprehensive functionality completely free of charge.</p>\n\n\n\n<p>What makes Gravatar different? While other platforms focus on lead generation through active networking, Gravatar also creates opportunities passively through automatic integration into the tools professionals already use. Your profile appears organically across WordPress, GitHub, Slack, and other major platforms – no subscription fees or manual updates are required.</p>\n\n\n\n<p>Think of Gravatar as your central command center for online identity. Update it once, and your information automatically syncs everywhere your email appears. No juggling multiple profiles or paying for team features. Plus, you get the same QR code sharing for offline meetings and social media integration capabilities as paid services, along with the flexibility to maintain separate professional and personal identities.</p>\n\n\n\n<p>Ready to get started? Visit Gravatar.com and click &#8220;Get Started Now.&#8221; Simply enter your email address, customize your profile with a photo and details, and add verified links to your social media accounts and portfolio.&nbsp;</p>\n\n\n\n<p>Don’t wait! <a href=\"https://gravatar.com/connect?gravatar_from=signup\">Create your Gravatar profile</a> and experience the ease of a universally recognized digital business card that requires no active sharing – once set up, it works automatically across platforms where professionals already engage.</p>\n\n\n\n<a href=\"https://gravatar.com/connect/?gravatar_from=blog\"><img width=\"3243\" height=\"729\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/12/free_profile_cta.png\" alt=\"\" class=\"wp-image-2616\" /></a>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 18 Apr 2025 13:19:19 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Ronnie Burt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"Do The Woo Community: Do the Woo Friday Shares, April 18, 2025 v15\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"https://dothewoo.io/?post_type=blog&p=94755\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"https://dothewoo.io/blog/do-the-woo-friday-shares-april-18-2025-v15/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:135:\"Curated content from the Woo, WordPress, and Open Web community is compiled in this comprehensive list for easy access and exploration.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 18 Apr 2025 10:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"Do The Woo Community: Learning Computer Programming\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"https://dothewoo.io/?post_type=blog&p=94737\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"https://dothewoo.io/blog/computer-programming/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:112:\"In the 80\'s I learned Basic, COBOL, Assembly Language, Fortran and Pascal, and a lot of it on a TRS-80 computer.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 18 Apr 2025 08:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"Post Status: Decluttering Your Résumé\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://poststatus.com/?p=163548\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://poststatus.com/decluttering-your-resume/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:8809:\"<p>I took a webinar recently on decluttering and stopping the re-cluttering. And although this seminar was about physical clutter, it got me thinking about job searching and my résumé. I&#8217;m not gonna lie &#8211; although I help other people all the time with their CVs and résumés &#8211; my CV is a cluttered mess. And it needs desperate attention.</p>\n\n\n\n<p>So as I work on mine, I&#8217;m going to share some tips that might help others as they hone their résumés, too.</p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"h-decide-between-a-resume-and-a-cv-curriculum-vitae\">Decide between a résumé and a CV (curriculum vitae)</h2>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>A resume focuses on your&nbsp;<a href=\"https://www.thehrdigest.com/job-skills-to-include-on-your-resume-with-examples/\">job history and skills</a>, whereas a CV emphasizes your personal accomplishments. Both documents are essential, but they serve different purposes. Your resume is designed to get you noticed for a specific type of position where you can apply your skills as an entry-level sales job. In contrast, a CV shows employers and recruiters details about your life outside of work, such as previous volunteer activities and sports teams.<br /><em>from <a href=\"https://www.thehrdigest.com/cv-vs-resume-the-difference-between-a-resume-and-a-curriculum-vitae/\">TheHRDigest.com</a></em></p>\n</blockquote>\n\n\n\n<p>Most of us in tech will want to use a résumé rather than a CV, although a hybrid may be considered. </p>\n\n\n\n<p>For example, I still want to include a list of professional speaking engagements where I have been on stage. For a marketing and community position this is important, although not usually included in a traditional résumé.</p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"h-functional-resume-vs-chronological-resume\">Functional résumé vs. chronological résumé</h2>\n\n\n\n<p>A functional résumé and a chronological résumé serve different purposes depending on you background and career goals. A functional résumé emphasizes skills and competencies rather than work history, making it ideal for individuals with gaps in employment, career changers, or those with diverse but non-linear experiences. It groups qualifications under skill categories, helping highlight what you, the candidate, can do. </p>\n\n\n\n<p>In contrast, a chronological résumé lists work experience in reverse chronological order, showcasing a clear employment timeline and career progression. This format is usually favored by most employers and is best suited for candidates with a steady, relevant work history in the same field. While the functional résumé focuses on what you <em>can</em> do, the chronological résumé highlights <em>where</em> and <em>when</em> you’ve done it.</p>\n\n\n\n<p>You might choose a functional résumé over a chronological one if you want to shift the focus away from your work history and emphasize your skills and achievements instead. By organizing your résumé around what you <em>can do</em> rather than when and where you did it, a functional format allows you to present yourself in a stronger light if your job history doesn&#8217;t tell the full story of your qualifications.</p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"h-to-show-your-age-or-not-to\">To show your age or not to?</h2>\n\n\n\n<p>Typically, you should not include your age on a résumé. Age is considered personal information and isn&#8217;t relevant to your qualifications or ability to perform a job. Including it can unintentionally open the door to age discrimination, whether you&#8217;re younger or older. Instead, focus on your skills, experience, and accomplishments. </p>\n\n\n\n<p>This means you should avoid including graduation dates if you&#8217;re concerned about age bias—what matters most to employers is <em>what you bring to the table</em>, not how old you are.</p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"h-should-you-list-out-hobbies\">Should you list out hobbies?</h2>\n\n\n\n<p>Listing hobbies on a résumé is optional and depends on the job you&#8217;re applying for. In general, you should only include hobbies if they are relevant to the position or help show skills that are transferable or desirable in the workplace—like leadership, creativity, teamwork, or dedication. For example, if you&#8217;re applying for a job in marketing, a hobby like managing a personal blog or creating social media content could be a plus. On the other hand, if your hobbies aren’t related to the job or don’t add value to your application, it&#8217;s best to leave them off and use the space for more impactful content like achievements or skills.</p>\n\n\n\n<p>Listing some hobbies can share more information that you may want to. For example, listing something like being a scout leader might share that you have parenting responsibilities, which may make you seem less desirable (especially for women), as unconscious biases expect mothers to spend more time with family than at work.</p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"h-what-should-you-show-in-your-tech-stack\">What should you show in your tech stack?</h2>\n\n\n\n<p>Many times I have seen people list tech that is too basic to include on their résumé for the job they&#8217;re seeking. Including things like email, Google sheets, and Slack in today&#8217;s market are already expected of applicants and appear as résumé padding. When you list your tech stack on your résumé, take a careful look at each on your list to evaluate if it needs to be there. When in doubt, ask a friend in the industry.</p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"h-how-about-a-portfolio\">How about a portfolio?</h2>\n\n\n\n<p>For someone in the technology industry, a strong portfolio should showcase both technical skills and the impact of your work. Here’s what to include:</p>\n\n\n\n<ol class=\"wp-block-list\">\n<li><strong>Projects</strong> – Highlight 3–5 of your best or most relevant projects. Include brief descriptions, your role, the technologies used, and outcomes or results (e.g., improved performance, user growth, bug fixes, etc.).</li>\n\n\n\n<li>For developers, include <strong>Code Samples</strong> – Share links to GitHub or similar platforms where employers can see clean, well-documented code. Make sure it&#8217;s organized and shows your understanding of best practices.</li>\n\n\n\n<li><strong>Case Studies</strong> – For more complex projects, write short case studies that outline the problem, your approach, tools used, and the result.</li>\n\n\n\n<li><strong>Technical Skills</strong> – For developers, clearly list programming languages, frameworks, tools, and platforms you’re proficient in. For marketers, list the technology skills you have in media production and scheduling.</li>\n\n\n\n<li><strong>Live Demos or Screenshots</strong> – If possible, provide links to live demos or include screenshots to make your work tangible—especially helpful for front-end or UX/UI roles and marketing.</li>\n\n\n\n<li><strong>Resume &amp; Contact Info</strong> – Include a downloadable résumé and a clear way for potential employers to contact you.</li>\n\n\n\n<li><strong>Certifications or Awards</strong> – Optional, but helpful if they’re relevant to the job (like AWS certification, hackathon wins, etc.).</li>\n</ol>\n\n\n\n<p>The key is to show not just what you can build, but how you think, collaborate, and solve problems—that&#8217;s what really stands out. Want help building or reviewing a portfolio?</p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"h-should-you-include-a-photo-on-your-resume\">Should you include a photo on your résumé?</h2>\n\n\n\n<p>While your photo is included in your social channels (including LinkedIn), it&#8217;s not necessary to include on a résumé, and may actually count against you if the reviewer has any conscious or unconscious biases.</p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"h-when-in-doubt-hire-help-for-your-resume\">When in doubt, hire help for your résumé</h2>\n\n\n\n<p>Finding your next job is important, so if you&#8217;re not confident in your résumé-building skills, spending some money up front to stand out in a sea of applicants is money well-spent.</p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"h-best-wishes\">Best wishes</h2>\n\n\n\n<p>Most of all, best wishes in your pursuit of your next great position. Wishing you an easy time and a great fit for the best salary. Your happiness and health deserve it.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<p>Find jobs to apply for on our <a href=\"https://poststatus.com/jobs/\">Job Board</a>.</p>\n<p>This article, <a href=\"https://poststatus.com/decluttering-your-resume/\">Decluttering Your Résumé</a>, was published at  <a href=\"https://poststatus.com\">Post Status</a> — the community for WordPress professionals.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 17 Apr 2025 21:30:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Michelle Frechette\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Post Status: Agency News Weekly\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://poststatus.com/?p=163506\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://poststatus.com/agency-news-weekly-2025-04-14/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5858:\"<h2 class=\"gb-headline gb-headline-3f9efd72 gb-headline-text\">It&#8217;s Official &#8211; Only One Major WordPress Release for 2025</h2>\n\n\n\n<ul class=\"wp-block-list\">\n<li>WordPress 6.8 will be the only major core release this year following <a href=\"https://make.wordpress.org/core/2025/04/04/dotorg-core-committers-check-in/\">a meeting of Core Committers</a> on April 4.</li>\n\n\n\n<li>The stated reason for the decision was a reduction in weekly core contribution hours by companies like Automattic (from 4000 to 16) and Newfold Digital (from 329 to 20).</li>\n\n\n\n<li><a href=\"https://www.therepository.email/wordpress-scales-back-to-one-major-release-in-2025\">The Repository&#8217;s story on this topic</a> brings excellent insight to some of the people and opinions associated with this decision. As usual, it&#8217;s a great read.</li>\n\n\n\n<li><em><strong>What does this decision mean for those of us who run agencies or do client work?</strong></em></li>\n\n\n\n<li>From a technical perspective, maybe not much unless you&#8217;re all in on the Site Editor (as <a href=\"https://poststatus.com/agency-news-weekly-2025-03-17/\">I wrote on March 17</a> when the changes to the release schedule were first being discussed).</li>\n\n\n\n<li>I&#8217;m particularly interested in <a href=\"https://www.therepository.email/wordpress-scales-back-to-one-major-release-in-2025#:~:text=A%20key%20area%20of%20focus%20moving%20forward%20will%20be%20canonical%20plugins\">the focus on canonical plugins</a> to deliver new features rather than core development. </li>\n\n\n\n<li>As an agency owner, my biggest concern is perceived stagnation of the project in the tech world, which is a big deal as WordPress struggles to compete with platforms like Wix, Squarespace, and Shopify.</li>\n\n\n\n<li>It used to be easy to demonstrate how WordPress was a superior solution when clients had questions. Now that might be a harder sell, especially to those who hear tech industry chatter.</li>\n</ul>\n\n\n\n<h2 class=\"gb-headline gb-headline-930042ec gb-headline-text\">Seeing More Form Spam Lately? This AI Bot May Be to Blame</h2>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://thehackernews.com/2025/04/akirabot-targets-420000-sites-with.html\">An AI-powered spam bot called AkiraBot</a> has been targeting hundreds of thousands of websites with convincing spam messages generated by OpenAI technology.</li>\n\n\n\n<li>The Python-based bot uses GPT-4 model to create genuine-looking form entries that are based on the website&#8217;s content.</li>\n\n\n\n<li>The messages promote questionable SEO services under names like Akira and ServicewrapGO.</li>\n\n\n\n<li>Akirabot has also demonstrated an ability to defeat popular CAPTCHA systems, including Turnstile, hCAPTCHA, and reCAPTCHA.</li>\n\n\n\n<li>OpenAI has taken action by disabling the API key and associated assets used in this operation (at least for now).</li>\n</ul>\n\n\n\n<h2 class=\"gb-headline gb-headline-7643d17f gb-headline-text\">If You Target Quebec Customers, Make Sure You Know About Bill 96</h2>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>By June 1, 2025, <a href=\"https://translatepress.com/bill-96-quebec-canada/\">websites that target Quebec residents must be available in French</a> <em>at no disadvantage compared to other languages.</em></strong></li>\n\n\n\n<li><a href=\"https://www.cfib-fcei.ca/en/site/qc-law-14-bill-96\">Quebec’s Bill 96</a> is a sweeping law that expands the use of French across business, education, and public services.</li>\n\n\n\n<li>For businesses, the bill introduces strict requirements around offering French-language services, signage, contracts, and digital content (including websites and mobile apps) when doing business in the province.</li>\n\n\n\n<li>Companies located outside Quebec (or even outside Canada), must still comply <strong>if they target Quebec customers.</strong></li>\n\n\n\n<li><a href=\"https://oxoinnovation.com/quebec-bill-96/\">Non-compliance with the bill</a> can result in significant fines ranging from $3,000 to $30,000 per day, and company officers can being held personally liable.&nbsp;</li>\n\n\n\n<li>If you or your clients target customers in Quebec, this is weighty legislation that needs attention.</li>\n</ul>\n\n\n<div class=\"gb-container gb-container-c34423a9\">\n\n<h2 class=\"gb-headline gb-headline-7813eada gb-headline-text\">Worth a Look </h2>\n\n</div>\n\n\n<ul class=\"wp-block-list\">\n<li><strong><a href=\"https://theadminbar.com/2025-survey/\">The Admin Bar&#8217;s 2025 Web Professionals Survey results are in</a></strong>.  Interesting stats here from more that 1200 respondents.</li>\n\n\n\n<li><strong><a href=\"https://www.therepository.email/wordpress-foundation-secures-trademarks-for-managed-wordpress-and-hosted-wordpress-in-the-european-union\">The WordPress Foundation has secured trademarks</a></strong> for &#8220;Managed WordPress&#8221; and &#8220;Hosted WordPress&#8221; in the EU (along with UK and Australia). <em><a href=\"https://poststatus.com/agency-news-weekly-2025-03-10/#:~:text=Sell%20WordPress%20Care%20Plans%3F%20You%20Might%20Need%20to%20Rename%20Them.\">How this could impact your agency</a>.</em></li>\n\n\n\n<li><strong>Corey Maass has released the <a href=\"https://pausetab.com/\">PauseTab Chrome Extension</a></strong> &#8211; pause a tab now and bring it back exactly when you need it. Super cool.</li>\n\n\n\n<li><strong><a href=\"https://wordpress.com/ai-website-builder/\">WordPress.com has released an AI Website Builder</a></strong> that will create a WordPress site on their platform based on your prompts. <a href=\"https://www.youtube.com/watch?v=SxrWvHv90wM&ab_channel=WPMinuteTutorials\">Here&#8217;s Matt Medeiros&#8217; take</a>.</li>\n</ul>\n\n\n\n<p></p>\n<p>This article, <a href=\"https://poststatus.com/agency-news-weekly-2025-04-14/\">Agency News Weekly</a>, was published at  <a href=\"https://poststatus.com\">Post Status</a> — the community for WordPress professionals.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 17 Apr 2025 21:30:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Nathan Ingram\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:10;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"Post Status: The Latest from Post Status Members\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://poststatus.com/?p=163503\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"https://poststatus.com/the-latest-from-post-status-members-2025-04-14/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5657:\"<p><strong>Howard Spaeth</strong> launched his new WAAS project, <a href=\"https://builtforservice.com/Home\">Built for Service</a>.</p>\n\n\n\n<p><strong>Rodolfo Melogli</strong> promoted his upcoming Business Bloomer classes on WooCommerce, including topics like syncing with Google Sheets, auditing conversion rates, and optimizing sales emails. <a href=\"https://www.businessbloomer.com/class/how-to-sync-woocommerce-google-sheets-without-plugins/\">Explore the sessions</a></p>\n\n\n\n<p><strong>Syed Balkhi</strong> shared new feature updates to the <a href=\"https://x.com/syedbalkhi/status/1909290149462089893\">Charitable plugin</a>.</p>\n\n\n\n<p><strong>Adam Weeks</strong> released a <a href=\"https://youtu.be/6Axur-phLQ8?si=J0DKz5Lw02wDqP4X\">video conversation</a> with Marc Benzakein, discussing authenticity and their shared WordPress experiences.</p>\n\n\n\n<p><strong>Joost de Valk</strong> introduced a new <a href=\"https://progressplanner.com/progress-planners-new-integration-with-yoast/\">Progress Planner integration with Yoast SEO</a>, offering tailored improvement tips based on your SEO setup.</p>\n\n\n\n<p><strong>Corey Maass</strong> launched <a href=\"https://pausetab.com\">PauseTab</a>, his first Chrome extension, which lets users snooze browser tabs until needed.</p>\n\n\n\n<p><strong>Mitch Canter</strong> unveiled <a href=\"https://mrsfallout.com/\">a retro-styled WordPress website</a> for a popular Fallout content creator, designed as a throwback to early internet aesthetics.</p>\n\n\n\n<p><strong>Dan Knauss</strong> shared a <a href=\"https://www.youtube.com/watch?v=oThwBJLM4zg\">PublishPress podcast interview</a> with Kyle Van Deusen about his community-building work at The Admin Bar.</p>\n\n\n\n<p><strong>Topher DeRosia</strong> published a new <a href=\"https://heropress.com/essays/how-wordpress-changed-my-life-gratitude/\">HeroPress essay</a> by Caio Ferreira, also available in Brazilian Portuguese with audio.</p>\n\n\n\n<p><strong>Bob Dunn</strong> shared a <a href=\"https://dothewoo.io/navigating-the-accessibility-landscape-real-stories-with-bud-kraus/\">Do the Woo episode</a> focused on accessibility, featuring real stories and insights from Bud Kraus.</p>\n\n\n\n<p><strong>Jessica Lyschik</strong> appeared on the <a href=\"https://hubs.ly/Q03dVWfh0\">Greyd Conversations podcast</a> with Mike McAlister to discuss product development using the WordPress site editor.</p>\n\n\n\n<p><strong>Tom Whitaker</strong> shared a video on <a href=\"https://youtu.be/sARqZwnYOPM\">AI prompt enhancement</a>, encouraging better communication with AI for more accurate results.</p>\n\n\n\n<p><strong>Matt Medeiros</strong> released a <a href=\"https://youtu.be/SxrWvHv90wM\">review of WordPress.com’s new AI builder</a>, offering initial thoughts on its capabilities and usefulness.</p>\n\n\n\n<p><strong>Michelle Frechette</strong> published the latest <a href=\"https://wpwonderwomen.kit.com/posts/wp-wonder-women-newsletter-vol-1-issue-29\">WP Wonder Women newsletter</a>, featuring Stacy Carlson and updates from many women in the WordPress ecosystem.</p>\n\n\n\n<p><strong>Juan Hernando</strong> wrote about his role as <a href=\"https://ciudadanob.com/en/blog/2025/04/10/the-life-of-a-wordpress-community-program-manager-whatever-that-is/\">Program Manager for the WordPress Community team</a> and how Weglot supports his work.</p>\n\n\n\n<p><strong>Brian Henry</strong> announced a major update to <a href=\"https://github.com/BrianHenryIE/strauss/releases/tag/0.22.10.22.1\">Strauss</a>, his PHP namespacing tool, including a dry-run feature, config feedback, and compatibility with Composer workflows.</p>\n\n\n\n<p><strong>Jonathan Bossenger</strong> hosted a live session comparing <a href=\"https://www.twitch.tv/jonathanbossenger\">GitHub Copilot agent mode to Cursor</a> in VS Code for AI-assisted development.</p>\n\n\n\n<p><strong>Topher DeRosia</strong> mentioned his daughter’s creative work on <a href=\"https://www.patreon.com/SpoonQueenCreative?redirect=true\">Patreon</a>, encouraging the community to join the free level to support her.</p>\n\n\n\n<p><strong>Bud Kraus</strong> published a <a href=\"https://seriouslybud.com/stephanie-hudson/\">feature on Stephanie Hudson</a>, spotlighting her journey and the people who influenced her life.</p>\n\n\n\n<p><strong>Daniel Post</strong> explained how he <a href=\"https://bsky.app/profile/danielpost.com/post/3lmmbjg54q22m\">migrated from DeployHQ to GitHub Actions</a> for smoother deployment workflows.</p>\n\n\n\n<p><strong>Bob Dunn</strong> relaunched <a href=\"https://dothewoo.io/bobwp-unplugged-do-the-woo-query-newsletter-and-daily-posts/\">BobWP Unplugged</a>, including a new newsletter and daily WooCommerce posts.</p>\n\n\n\n<p><strong>Topher DeRosia</strong> published a new photo on <a href=\"https://wpphotos.info/barek-tila/\">WPPhotos</a> showing sand and rock harvesting in Bangladesh.</p>\n\n\n\n<p><strong>Hudson Atwell</strong> shared an <a href=\"https://gbti.network/ai/mcp/new-england-clam-chowder-the-red-or-the-white/\">MCP server boilerplate article</a>, explaining how to use MCP servers on the Windsurf IDE along with setup and debugging tools.</p>\n\n\n\n<p><strong>Ronni K. Gothard Christiansen</strong> announced <a href=\"https://aesirx.io/blog/aesirx/aesirx-cmp-for-wordpress-v1-5-0-consent-logging-and-more-customizable-user-control\">AesirX CMP for WordPress v1.5.0</a>, introducing consent logging, editable modal text, improved UI, and support for eight new languages.</p>\n<p>This article, <a href=\"https://poststatus.com/the-latest-from-post-status-members-2025-04-14/\">The Latest from Post Status Members</a>, was published at  <a href=\"https://poststatus.com\">Post Status</a> — the community for WordPress professionals.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 17 Apr 2025 21:30:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Nathan Ingram\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:11;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"Post Status: Post Status Happiness Hour Session Twenty Five\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://poststatus.com/?p=163527\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"https://poststatus.com/post-status-happiness-hour-session-twenty-five/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:47642:\"<div class=\"wp-block-embed__wrapper\">\n\n</div>\n\n\n\n\n\n\n\n<p><a href=\"https://poststatus.com/category/planet/#h-transcript\">Transcript</a> ↓</p>\n\n\n\n<p>In this episode of the Post Status Happiness Hour, host <a href=\"https://x.com/michelleames\">Michelle Frechette</a> interviews <a href=\"https://x.com/timbouchard\">Tim Bouchard</a>, and <a href=\"https://www.linkedin.com/in/brennanron/\">Ron Brennan</a> discuss the upcoming <a href=\"https://colorcode.events/\">Color Code event</a>, a conference focused on design, technology, and marketing. Unlike traditional WordCamps, Color Code aims to be more inclusive, welcoming participants from various platforms and technologies. The event will feature a diverse lineup of speakers, interactive elements like a live graffiti art competition, and networking opportunities. Set to take place in Buffalo, New York, the conference emphasizes accessibility and community involvement, promising a dynamic and engaging experience for all attendees.</p>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"h-top-takeaways\">Top Takeaways: </h3>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Networking and Collaboration Opportunities: </strong>The Color Code event emphasizes the power of in-person connections. With a focus on creative professionals, marketers, and developers, the event is designed to facilitate collaboration through both formal presentations and informal networking (the &#8220;hallway track&#8221;). Attendees can expect meaningful conversations and potential partnerships that might not happen in a purely virtual setting.</li>\n\n\n\n<li><strong>Diverse and Relevant Topics: </strong>The event will cover a range of cutting-edge topics, such as AI, content strategies, and the challenges of decoupling from major tech players like Google. These presentations, led by volunteer speakers, aim to provide valuable insights and practical knowledge, making the event a great opportunity for professionals to stay informed on industry trends.</li>\n\n\n\n<li><strong>Affordability and Accessibility:</strong> With an affordable ticket price ($40), including lunch and the after-party, Color Code positions itself as an accessible event for professionals of all backgrounds. The organizers also plan to record sessions and make them available online, ensuring that those who can’t attend in person still have access to the valuable content.</li>\n</ul>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"h-mentioned-in-the-show\">Mentioned In The Show:</h3>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://colorcode.events/\">Color Code</a></li>\n\n\n\n<li><a href=\"https://pressconf.events/\">Press Conf</a></li>\n\n\n\n<li><a href=\"https://wpengine.com/\">WP Engine</a></li>\n\n\n\n<li><a href=\"https://www.meetup.com/\">Meetup</a></li>\n\n\n\n<li><a href=\"https://senecaonebuffalo.com/\">Seneca One Tower</a></li>\n\n\n\n<li><a href=\"https://douglasdevelopment.com/\">Douglas Development</a></li>\n\n\n\n<li><a href=\"https://luminus.agency/\">Luminous </a></li>\n\n\n\n<li><a href=\"https://www.genemccarthys.com/\">Gene McCarthy&#8217;s</a></li>\n</ul>\n\n\n\n<div class=\"wp-block-columns has-theme-palette-8-background-color has-background is-layout-flex wp-container-core-columns-is-layout-1 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<h3 class=\"wp-block-heading\"><img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/1f64f.png\" alt=\"🙏\" class=\"wp-smiley\" /> Sponsor: <a href=\"https://poststat.us/a2-hosting\">A2 Hosting</a></h3>\n\n\n\n<p>A2Hosting offers solutions for WordPress and WooCommerce that are both blazing fast and ultra-reliable. WordPress can be easily deployed on ANY web hosting plan from A2: Shared, VPS, or Dedicated. A2 also offers Managed WordPress and WooCommerce Hosting. Take a look at a2hosting.com today!</p>\n</div>\n\n\n\n<div class=\"wp-block-column is-vertically-aligned-center is-layout-flow wp-block-column-is-layout-flow\">\n<img width=\"752\" height=\"470\" src=\"https://poststatus.com/wp-content/uploads/2022/08/imageedit_1_6433774706-752x470.png\" alt=\"A2 Hosting\" class=\"wp-image-104073\" />A2 Hosting\n</div>\n</div>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"h-you-can-follow-post-status-and-our-guests-on-social-media\"><img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/1f426.png\" alt=\"🐦\" class=\"wp-smiley\" /> You can follow Post Status and our guests on Social Media:</h3>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://x.com/timbouchard\">Tim Bouchard</a> (Owner/CEO, <a href=\"https://x.com/LuminusAgency\">LuminusAgency</a>)</li>\n\n\n\n<li><a href=\"https://www.linkedin.com/in/brennanron/\">Ron Brennan</a> (Managing Partner, <a href=\"https://www.linkedin.com/company/cani-marketing-group/\">CANI Marketing Group</a>)</li>\n\n\n\n<li><a href=\"https://twitter.com/michelleames\">Michelle Frechette</a>&nbsp;(Director of Community Relations,&nbsp;<a href=\"https://twitter.com/post_status\">Post Status</a>)</li>\n\n\n\n<li><a href=\"https://twitter.com/lemonadecode\">Olivia Bisset</a>&nbsp;(Intern,&nbsp;<a href=\"https://twitter.com/post_status\">Post Status</a>)</li>\n</ul>\n\n\n\n<p>The <strong>Post Status</strong> podcast is geared toward WordPress professionals, with interviews, news, and deep analysis. <img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/1f4dd.png\" alt=\"📝\" class=\"wp-smiley\" /></p>\n\n\n\n<p><a href=\"https://poststatus.com/category/post-status-podcasts/\">Browse our archives</a>, and don’t forget to subscribe via <a href=\"https://itunes.apple.com/us/podcast/post-status-draft-wordpress/id976403008\">iTunes</a>, <a href=\"https://podcasts.google.com/feed/aHR0cHM6Ly9mZWVkcy5zaW1wbGVjYXN0LmNvbS8ySkU5c2M4UA\">Google Podcasts</a>, <a href=\"https://www.youtube.com/c/PostStatus\">YouTube</a>, <a href=\"http://www.stitcher.com/podcast/krogsgard/post-status-draft-wordpress-podcast\">Stitcher</a>, <a href=\"https://wordpress-post-status-draft-podcast.simplecast.com/\">Simplecast</a>, or <a href=\"https://feeds.simplecast.com/2JE9sc8P\">RSS</a>. <img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/1f3a7.png\" alt=\"🎧\" class=\"wp-smiley\" /></p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"h-transcript\">Transcript</h2>\n\n\n\n<p>Michelle Frechette 00:00:02&nbsp; And welcome to our next Post Status Happiness Hour. Today I&#8217;m joined by two thirds of the organizing team for Color Code Events, Tim Bouchard and Ron Brennan, my neighbors to the west in Buffalo, New York. How are you guys doing?&nbsp;</p>\n\n\n\n<p>TIm Bouchard: Good.</p>\n\n\n\n<p>Ron Brennan 00:00:18&nbsp; Good. How are you?</p>\n\n\n\n<p>Michelle Frechette 00:00:20&nbsp; I&#8217;m good. Thanks. Ron, I don&#8217;t remember when you and I met. It&#8217;s been a really long time because we&#8217;ve been doing Buffalo, and it&#8217;s probably 2015 or 16. If I&#8217;m 14? I don&#8217;t know, being honest. We go way back.</p>\n\n\n\n<p>Ron Brennan 00:00:31&nbsp; 14 or 15 Yep. Somewhere.</p>\n\n\n\n<p>Michelle Frechette 00:00:33&nbsp; Yeah.</p>\n\n\n\n<p>Ron Brennan 00:00:33&nbsp; Your first WordCamp event.</p>\n\n\n\n<p>Michelle Frechette 00:00:36&nbsp; It was. I joke about I joke, I laugh about the fact that I posted on my only social channel at the time, which was, Facebook, and I called it. I said I was at my first WordPress Camp because I didn&#8217;t even remember. They were called word camps back then, but and Tim, you and I go back probably almost as far.</p>\n\n\n\n<p>Time Bouchard: Almost yeah.&nbsp; I met you back in 16 maybe?&nbsp;</p>\n\n\n\n<p>Michelle Frechette 00:00:55&nbsp; So nice to see you both here today, but we&#8217;re here to talk about Color Code, which I am fortunate to be a speaker at. I&#8217;m excited to bring my, my story there, my talk about doing personal branding and how you can increase your personal branding, and there&#8217;s some basic steps to doing that and get started. It can feel overwhelming, but it doesn&#8217;t need to. So I&#8217;ll save that for the actual event. I won&#8217;t give it all the way today, but I wanted to talk to you guys about what you&#8217;re doing because it&#8217;s it&#8217;s WordPress adjacent. It&#8217;s not a WordCamp. You&#8217;re doing something on your own. Similar to Press Conf that&#8217;s going on at the end of this month, but you have managed to keep the costs down. So it&#8217;s still a fairly low investment for people to attend. And it&#8217;s not an official WordPress event, which also was a choice for you. And it&#8217;s in person as well. So it&#8217;s not an online event.&nbsp; So tell me all the thought processes that went into getting this up and going off the ground. Also, I think the venue is supposed to be pretty sensational from what I&#8217;ve heard.&nbsp;</p>\n\n\n\n<p>Tim Bouchard 00:02:03&nbsp; Yeah. For sure.Yeah. Ron, do you want to start with this? I mean, you have the bigger history, so you can go for it.</p>\n\n\n\n<p>Ron Brennan 00:02:08&nbsp; Yeah. So as you know, like, Ben and myself and then Andy and then Tim, you know, we kind of ran the WordPress community here in Buffalo, New York. Ran the WordCamps we started this year. You know, Michelle, you know how we do it. We&#8217;re last minute. It drives you crazy. But, you know, we kind of pull together. We decide three weeks before the event. Hey, let&#8217;s do a WordCamp. And then, you know, our handlers and everything are going crazy. This year Tim really got involved, and he&#8217;s like, you know what, guys? We&#8217;re going to do this right this year.&nbsp; It&#8217;s going to be a real, you know, event that people look forward to going to. But we got to start. I mean we started last year after the event. It was crazy.</p>\n\n\n\n<p>Tim Bouchard 00:02:51&nbsp; Yeah. July and August. We started planning meeting for this year.</p>\n\n\n\n<p>Michelle Frechette 00:02:53&nbsp; Tim, you accomplished what I was unable to do for years.</p>\n\n\n\n<p>Tim Bouchard: I’m very persuasive.&nbsp;</p>\n\n\n\n<p>Michelle Frechette 00:02:57 Light that fire under those guys and get them started earlier.</p>\n\n\n\n<p>Ron Brennan 00:03:02&nbsp; Yeah. He, you know, he got us motivated by always suggesting meeting places that had, like, beer and chicken wings. So.</p>\n\n\n\n<p>Michelle Frechette 00:03:09&nbsp; I mean, with Buffalo. You got it. Where&#8217;s your favorite wings from?</p>\n\n\n\n<p>Ron Brennan 00:03:15&nbsp; Favorite wings. Mine are probably Bar Bill, but I like Gene McCarthy&#8217;s a lot, too. And that&#8217;s where this kind of all originated.</p>\n\n\n\n<p>Tim Bouchard 00:03:23&nbsp; I like Gene McCarthy&#8217;s too, but my my secret is the Tonawanda Golf Dome.</p>\n\n\n\n<p>Ron Brennan 00:03:28&nbsp; Oh, those are good, too.</p>\n\n\n\n<p>Michelle Frechette 00:03:30&nbsp; And you guys introduced me to Elmo&#8217;s, and I really liked Elmo&#8217;s.</p>\n\n\n\n<p>Tim Bouchard 00:03:33&nbsp; Yeah. So Elmo&#8217;s great.</p>\n\n\n\n<p>Tim Bouchard 00:03:35&nbsp; Yeah.</p>\n\n\n\n<p>Ron Brennan 00:03:35&nbsp; Okay.</p>\n\n\n\n<p>Michelle Frechette 00:03:35&nbsp; We got sidetracked.</p>\n\n\n\n<p>Ron Brennan 00:03:37&nbsp; Sorry. Yeah.</p>\n\n\n\n<p>Tim Bouchard 00:03:38&nbsp; That&#8217;s alright.</p>\n\n\n\n<p>Ron Brennan 00:03:38&nbsp; Do we have a time limit?</p>\n\n\n\n<p>Michelle Frechette 00:03:40&nbsp; I mean, we try to keep it to an hour, so.</p>\n\n\n\n<p>Ron Brennan 00:03:42&nbsp; Okay. So, anyway, we so we got started. We got going with our, our handler, sponsor, whoever, you know, our organizing friend. And then we got into it, and all the stuff happened with WordPress, you know, and it was really around that time with like Check Box Gate. Remember that? Like, I don&#8217;t even know if that&#8217;s still a thing where you got to certify that you&#8217;re not affiliated with WP engine.</p>\n\n\n\n<p>Tim Bouchard 00:04:06&nbsp; It&#8217;s like pineapple now or something. Yeah. Yeah. It&#8217;s not a thing anymore.</p>\n\n\n\n<p>Ron Brennan 00:04:10&nbsp; And we, you know, Tim and I both run our agencies and use those, those services. So we&#8217;re like, we don&#8217;t even know if we can log into this thing. And then, you know, are we going to be hindered by people that utilize this, that won&#8217;t you can&#8217;t buy tickets unless you check that box and log in to the WordPress back end.</p>\n\n\n\n<p>Ron Brennan 00:04:30&nbsp; So there were a lot of unknowns. But beside all of that, we we kind of started having conversations adjacent to this anyway, and thinking it would be cool to have a conference that wasn&#8217;t so platform specific and that didn&#8217;t, you know, like, WordPress is cool and designers come, but they have to be familiar with WordPress. This thing allows any platform, any technology, any designer, marketing agencies, you know, whatever. We&#8217;ve got so many different various people that would never probably come to a WordCamp, because maybe they don&#8217;t build on. We got a guy that&#8217;s building a CMS, I think, in one of the talks. I believe so. So nothing against WordCamp, you know, we we hope to keep that going here in the Buffalo community. But we, you know, we still have our WordCamp Meetup group that that goes once a month. But this is an exciting opportunity to do something different. And we didn&#8217;t know how it was going to be received. But, you know, Tim, again, got the, you know, just started like, emailing everybody and, and it&#8217;s like, okay, well, I guess we&#8217;re doing this thing. So, you know, formed a, an organization and started putting it together. And it&#8217;s going to be a great event. So Tim can talk about, like, the venue and all of that fun stuff that&#8217;s happening.</p>\n\n\n\n<p>Michelle Frechette 00:05:54&nbsp; I also want to know where the name came from. So I want you to dive into that at some point.</p>\n\n\n\n<p>Ron Brennan 00:05:58&nbsp; To sort of the real story.</p>\n\n\n\n<p>Tim Bouchard 00:05:59&nbsp; Yeah, yeah. Color Code itself is. I think the idea was we wanted to lean into both sides of the equation. And you know how it goes when you brainstorm like this. We had a ton of terrible ideas. We had some that other people already taken. We had some that were just straight up silly, but the Color Code, color art design, code tech, and it just kind of it&#8217;s, you know, alliteration, it all kind of works. So.</p>\n\n\n\n<p>Michelle Frechette 00:06:25&nbsp; It sounds like a Dunkle thing.</p>\n\n\n\n<p>Ron Brennan 00:06:29&nbsp; He was part of it.</p>\n\n\n\n<p>Tim Bouchard 00:06:30&nbsp; Yeah. He&#8217;s part. Yeah, we all definitely thought it&#8217;s one of those things where, like, the Slack channel and the Google Drive doc just goes crazy for like, two weeks, and then ultimately, you end up, okay. There&#8217;s a domain we could use for that. Let&#8217;s go for it.</p>\n\n\n\n<p>Ron Brennan 00:06:42&nbsp; That&#8217;s what it came down to the domain.</p>\n\n\n\n<p>Tim Bouchard 00:06:44&nbsp; Yeah, I think this is what everything comes down to when you name stuff. Now it&#8217;s is there a domain that you can register for it and then get an LLC or whatever. So Color Code was really meant to one have like a fun sound and really specifically just plainly say this is design and tech. And when you think about like the marketing world, that kind of factors into everything that we do for marketing too. So it&#8217;s all encompassing. And to John&#8217;s point or sorry, Ron&#8217;s point. It really allows us to branch out topic wise and technology wise. And we were talking about the venue, the Seneca One Tower in Buffalo is the most impressive building in the city from a size standpoint that stands over the city at like 33 floors or something like that. I&#8217;d say that City Hall is still probably the most impressive building, but the tower is amazing, but it&#8217;s also home to 43 North, which is one of the largest startup incubators in the country and runs one of the largest competitions in the country.</p>\n\n\n\n<p>Tim Bouchard 00:07:41&nbsp; So there&#8217;s lots of startups there, and they all have marketing, tech, advanced, you know, promotion. So it really kind of fits the vibe of what that tower has tried to become under Douglas Development, which is sort of like a tech hub and an incubator hub. And MIT has invested in it for. Their, their tech department. So it it has a a great auditorium large breakout rooms for. And we planned on maybe having one good track, but we got so many speakers submissions and there were a lot of good talks. And we really did want to have a variety of topics, from design to development to marketing. And it ultimately ended up that we we had enough, to whittle it down, to whittle it down to three tracks, which was 20 speakers and 19 talks. We have one. The headline talk, is actually a two person talk in the auditorium at the end of the day, but, it really worked out. Well, we do have we have speakers coming from all over the East Coast.</p>\n\n\n\n<p>Tim Bouchard 00:08:43&nbsp; We got sponsors at the national level. And to to Ron&#8217;s point, by making the event a little bit more inclusive to marketing and creative. We were able to pull a lot of local agency support to you on the sponsor side, because one of the goals was, we don&#8217;t need this to be a conference that makes money. We all have jobs. We all have agencies or freelance gigs. We wanted to create something that was still accessible for students and startup people, or just hobbyists even. So by getting the sponsorship, it allowed us to keep down the ticket costs. So the tickets are around what a typical WordCamp would be as well.</p>\n\n\n\n<p>Michelle Frechette 00:09:25&nbsp; Nice. That makes it much, much more accessible for people, for sure. Especially when you do have people flying in from all over to attend and to speak there. I think.</p>\n\n\n\n<p>Tim Bouchard 00:09:35&nbsp; Yeah. And it is still volunteer speaking at this point too. I mean, there&#8217;s a few sponsors that have speaking spots because it&#8217;s part of their sponsor level. But, the challenge to having a low ticket event is it has to be very community driven. So in that aspect, it is a lot like WordCamp. It&#8217;s just that the speakers are coming from such more diverse backgrounds now, and diverse topics, that it&#8217;s just interesting to see that there are other people in these industries that are willing to do volunteer speaking, too. So yeah, that&#8217;s that&#8217;s one. The other way, to their credit, to the speaker&#8217;s credit of being able to keep tickets, down in cost.</p>\n\n\n\n<p>Michelle Frechette 00:10:13&nbsp; Yeah. I&#8217;m going to pull up the, the site so we can kind of talk a little bit through, first of all, who is the Bauhaus lover? Because the whole design seems very much in the Bauhaus arena.</p>\n\n\n\n<p>Tim Bouchard 00:10:27&nbsp; Yeah. Which that&#8217;s my my art director at Luminous, John English. This is his brainchild.</p>\n\n\n\n<p>Michelle Frechette 00:10:32&nbsp; I love it. It looks great. And, there&#8217;s downtown Buffalo, I recognize that.</p>\n\n\n\n<p>Tim Bouchard 00:10:37&nbsp; Yep. That that view right there is up main Street from the level that the event is going to be on at Seneca Tower.</p>\n\n\n\n<p>Michelle Frechette 00:10:44&nbsp; Oh, nice. My daughter used to live right on Main Street there. So, Let&#8217;s see. So you have right now we are in the standard, so it&#8217;s only $40 to attend. And if you sign up after the 20th, it&#8217;s only $50. And you can do that with or without a t shirt for that extra $10. I see wings, of course. You gotta have wings. The venue looks phenomenal.</p>\n\n\n\n<p>Tim Bouchard 00:11:08&nbsp; Yep that the tower.</p>\n\n\n\n<p>Michelle Frechette 00:11:08&nbsp; And then there&#8217;s the schedule, which is, you know what everybody is always interested in seeing, like, who&#8217;s going to be here? Coffee in the lobby. Happy about that, for sure. You know, opening remarks as we call the event greeting here. And then you&#8217;ve got some, Tim, you and I are speaking at the same time. How did that happen?</p>\n\n\n\n<p>Tim Bouchard 00:11:25&nbsp; Yeah, yeah, it&#8217;s the way the schedule works out when you have tracks like this, you have to balance and make sure that you don&#8217;t have any overlapping.</p>\n\n\n\n<p>Michelle Frechette 00:11:33&nbsp; Topics. Absolutely.</p>\n\n\n\n<p>Tim Bouchard 00:11:35&nbsp; Yeah. So there&#8217;s, there&#8217;s definitely like in the flex track, which is green when it&#8217;s heavily marketing or design related.</p>\n\n\n\n<p>Tim Bouchard 00:11:40&nbsp; The other talks are more content and dev. Yeah. So, it was a hard balance when you have this many speakers. It&#8217;s like doing a wedding reception table seating.&nbsp; Figure out who has to be next to each other and who can&#8217;t.</p>\n\n\n\n<p>Michelle Frechette 00:11:55&nbsp; So you know, it is nice to go first thing though, because then you&#8217;ve ripped off the band aid and like the rest of the day, is your own, right?</p>\n\n\n\n<p>Tim Bouchard 00:12:01&nbsp; So yeah. And set the tone for the day too, right. So a lot of strong people leading off each track and then go from there.</p>\n\n\n\n<p>Michelle Frechette 00:12:09&nbsp; And you&#8217;ve got Jen Witkowski, you&#8217;ve got Lucas Manuel Alvarado, Kaitlin Bolling, Jim Brandt, Femi Lewis. Oh, I love Femi. She&#8217;s awesome.</p>\n\n\n\n<p>Tim Bouchard 00:12:17&nbsp; Christian Taylor&#8217;s coming too.</p>\n\n\n\n<p>Michelle Frechette 00:12:20&nbsp; Yeah. Christian from Craylor Media. Yep, I know Christian. He and I, met for the first time in person over at WordCamp Asia. Phenomenal. Doing so much work, in WordPress as far as news and sharing that kind of stuff. David Jackson.&nbsp;</p>\n\n\n\n<p>Tim Bouchard 00:12:33&nbsp; Yeah, I&#8217;ll point out my buddy Jordan from Orlando, who no one&#8217;s ever probably heard of in this community, but, for the sports fans or even general marketing fans, he&#8217;s behind the viral campaigns for the Pop Tarts College Bowl Game that have happened the last couple of years with the crazy Pop Tart stuff that&#8217;s happened, and he&#8217;s doing a talk on, kind of how that idea went from a bar. The typical bar napkin story to actually, like, winning the business and being like, oh, we have to actually do something now and then. It turned out to be amazing. And it went viral, like for a week, two years in a row, two different campaings.</p>\n\n\n\n<p>Michelle Frechette 00:13:09&nbsp; That&#8217;s very cool. I&#8217;m looking forward to hearing that.</p>\n\n\n\n<p>Tim Bouchard 00:13:12&nbsp; Yeah.</p>\n\n\n\n<p>Ron Brennan 00:13:12&nbsp; It’s just super meta just because Color Code happened on a bar napkin, it kind of. Yeah, as well.</p>\n\n\n\n<p>Michelle Frechette 00:13:17&nbsp; I&#8217;m not surprised.</p>\n\n\n\n<p>Tim Bouchard 00:13:18&nbsp; At Gene McCarthy&#8217;s over wings.</p>\n\n\n\n<p>Michelle Frechette 00:13:21&nbsp; We got Coriano Harris. Hue Got This, I like that. And then, Aaron Reimann, who is down in Atlanta area, Robert DeVore, Levi Neuland, Tamara Zantell, and then the, I guess keynote?</p>\n\n\n\n<p>Tim Bouchard 00:13:39&nbsp; Yeah kinda of. We wanted to bring everyone together at the end of the day in one room.</p>\n\n\n\n<p>Michelle Frechette 00:13:43&nbsp; And Natalie Munger, with Utilizing Heuristics to Improve Design, I love that. And then you do have an after party, I think, too, right?</p>\n\n\n\n<p>Tim Bouchard 00:13:49&nbsp; Yeah. Yeah. Ron, you want to talk about that? It&#8217;s in the works, but there&#8217;s it&#8217;s.</p>\n\n\n\n<p>Ron Brennan 00:13:53&nbsp; Yeah, we just kind of locked it down. Earlier today. So it&#8217;s going to be at, Pearl Street Brewery, which is a short walk away. You know, so, like, that&#8217;s kind of the cool thing about having it in downtown Buffalo, you know, the hotels that you&#8217;re going to stay at. You know, in our past, our WordCamps, you know, we had them in smaller communities and there weren&#8217;t really hotels. So you&#8217;re always just driving to the event or getting an Airbnb somewhere. Here like we&#8217;re in the heart of the city. Like our speaker networking event, you&#8217;re going to hop on on the train and take it right up Main Street, you know? So everything&#8217;s like, right right there, very accessible from.</p>\n\n\n\n<p>Michelle Frechette 00:14:35&nbsp; Yeah, yeah. Here, I&#8217;ll give you a chance to thank your, your sponsors now too. So you&#8217;ve got WP Engine.&nbsp;</p>\n\n\n\n<p>Tim Bouchard 00:14:42&nbsp; Yup WP Engine came in big and then you&#8217;ll see a bunch of the, the agencies and local colleges and stuff. And GoDaddy came in pretty big too.</p>\n\n\n\n<p>Michelle Frechette 00:14:49&nbsp; What&#8217;s FTN?</p>\n\n\n\n<p>Tim Bouchard 00:14:51&nbsp; Oh that&#8217;s Agency Fifteen. That&#8217;s a local agency. Creative agency.</p>\n\n\n\n<p>Michelle Frechette 00:14:54&nbsp; Nice. Luminous. Cani, and Douglas Development are collaborative.</p>\n\n\n\n<p>Tim Bouchard 00:15:00&nbsp; So props to Douglas. That tower. We are using the venue at no cost.</p>\n\n\n\n<p>Michelle Frechette:&nbsp; That&#8217;s amazing.</p>\n\n\n\n<p>Tim Bouchard: I mean, when you see, when you see the venue and you see what they&#8217;re offering us to be able to do at no cost. Another reason why the tickets are low.</p>\n\n\n\n<p>Michelle Frechette 00:15:15&nbsp; I was going to say that&#8217;s definitely contributes to that low ticket price.</p>\n\n\n\n<p>Tim Bouchard 00:15:18&nbsp; It&#8217;s insane. It&#8217;s such a good location and it will really facilitate like an amazing experience.</p>\n\n\n\n<p>Michelle Frechette 00:15:24&nbsp; You got Mr. Smith, Parkway, Martin, Canisius University, Kinsta, and then Black Space Creative, Ninteen, Breakdance and Lighthouse Marketing. And if people are interested, they can absolutely subscribe to the newsletter.</p>\n\n\n\n<p>Michelle Frechette 00:15:36&nbsp; Now you have I&#8217;m going to stop sharing because I think I&#8217;ve shown almost everything. You have listed it says Buffalo. But it looks like there&#8217;s room for more events, since the Buffalo is kind of like the subset of the site. Do you have plans at this point? Is it kind of leaving it open for future ideas?</p>\n\n\n\n<p>Tim Bouchard 00:15:57&nbsp; It&#8217;s it&#8217;s leaving it open right now. There is a plan, but there are no plans.</p>\n\n\n\n<p>Michelle Frechette 00:16:05&nbsp; We the concept of a concept of a plan.</p>\n\n\n\n<p>Ron Brennan 00:16:08&nbsp; We have concepts of a plan.</p>\n\n\n\n<p>Tim Bouchard 00:16:09&nbsp; Definitely concepts of a plan. We have had interest expressed by various sponsors that they would sponsor further events, too. So this is one of those things where if we have a formula to build an event like this that operates in the same way that people are used to with WordCamps, and we can spice up the national circuit a little bit with a handful of events each year. We can build out our organizer network. And, you know, it doesn&#8217;t have to be a big project for us. We don&#8217;t have to take over the world at this point. It&#8217;s about variety. Even locally Michelle, you&#8217;re, you know, in Rochester, you&#8217;re very active in WordPress and have done WordCamp Rochester too. Do we really need two WordCamps 70 miles apart from each other?</p>\n\n\n\n<p>Michelle Frechette 00:16:56&nbsp; Right. And we&#8217;ve talked about having we&#8217;ve talked about having WordCamp Western New York.</p>\n\n\n\n<p>Tim Bouchard 00:17:00&nbsp; Or doing work on Western New York and combining efforts. Right. So, you know, like Ron said, it&#8217;s a very good opportunity to expand our horizons and take what we learned for ten years off of the WordCamp and then make something else that we can inject into potentially some different cities, too, but definitely in Western New York. And it&#8217;s something that complements WordCamp very well.</p>\n\n\n\n<p>Michelle Frechette 00:17:20&nbsp; Yeah, absolutely. So tickets are still on sale, which is great. So if people are interested, finding tickets, do you have. I didn&#8217;t look because I live local enough. Do you have information about hotel stays and things like that? Venue information on the site recommended hotels, anything like that? or should they just go.</p>\n\n\n\n<p>Tim Bouchard 00:17:38&nbsp; To those specifically there? But to Ron&#8217;s point. The venue is downtown and if you do a Google map search, you&#8217;re going to find hotels within one train stop or walking distance. And it&#8217;s buffalo. So, they aren&#8217;t super expensive. Although there is a Shane Gillis comedy act at the arena that night, so you never know who&#8217;s coming into town buying up these hotel rooms.</p>\n\n\n\n<p>Michelle Frechette 00:17:58&nbsp; I&#8217;ve never heard of that person, so maybe it&#8217;s not as big as I don&#8217;t know. So whenever we have an event here in Rochester, the question is, the question from outside is, will you have garbage plates? The question from inside is we&#8217;re not going to have garbage plates, are we? So the question in Buffalo is, will there be wings at the after party or what can people expect?</p>\n\n\n\n<p>Ron Brennan 00:18:22&nbsp; Yeah I, I believe so. We&#8217;re going to have food, you know, like food is always a part of these things. We haven&#8217;t finalized the menu yet, but you know, I generally like to provide some Buffalo staples, especially when I know we have people coming in from out of town.</p>\n\n\n\n<p>Michelle Frechette 00:18:40&nbsp; I&#8217;m the same way as long as it&#8217;s mild, I. I love buffalo flavor. Not so much the. Not so much the spice. So to get back to something you said very early on, which was about pineapple on pizza. The pineapple on pizza question across the world is very similar to the Buffalo Western New York question of would you ever dip a wing in ranch?</p>\n\n\n\n<p>Tim Bouchard00:19:05&nbsp; No.</p>\n\n\n\n<p>&nbsp;Ron Brennan: No.</p>\n\n\n\n<p>Michelle Frechette 00:19:06&nbsp; You lose your buffalo card if you do that.</p>\n\n\n\n<p>Tim Bouchard 00:19:09&nbsp; No, it&#8217;s always blue cheese.</p>\n\n\n\n<p>Michelle Frechette 00:19:10&nbsp; Yeah. Blue cheese.</p>\n\n\n\n<p>Tim Bouchard 00:19:11&nbsp; And if it&#8217;s done right, it&#8217;s either homemade blue cheese by the restaurant or if you have to, it&#8217;s Rudy&#8217;s blue cheese.</p>\n\n\n\n<p>Ron Brennan: Yep.</p>\n\n\n\n<p>Michelle Frechette 00:19:17&nbsp; There you go. I&#8217;m sure Rochester doesn&#8217;t have either of those. So we take what we can get, but I think most of the time it&#8217;s Marie&#8217;s blue cheese? But, it will do.&nbsp;</p>\n\n\n\n<p>Ron Brennan 00:19:26&nbsp; That&#8217;s another one. People use that.</p>\n\n\n\n<p>Michelle Frechette 00:19:29&nbsp; In a pinch. Right? So what else? What else do you want to talk about with the event? What can people look forward to? What are you most excited about? And, is the stress levels hitting yet?</p>\n\n\n\n<p>Tim Bouchard 00:19:40&nbsp; it&#8217;s not super stressful. I mean, like, Fortunately, because we got started early, at this point, it&#8217;s just about making sure people know tickets are there, making sure they know the event exists. You know, we&#8217;ve been doing as much daily, almost, posting about speakers and sponsors and things on, on, you know, like X, Facebook, LinkedIn, all that good stuff. But one thing we haven&#8217;t talked about yet is the, Live graffiti art competition that will happen throughout the day in the lobby. Ben, who&#8217;s not here to talk about it. So we&#8217;ll do our best to do it for him. Is running essentially a large, sticky, note easel competition where we&#8217;ll have markers and things set up out in the lobby in a certain area and people throughout the day, if they want to either skip a session or between sessions. I don&#8217;t know what the official plan is for what will be done in terms of the art that&#8217;s done, but, do something and put it up on. Yes. Art battle. Art battle. 100%.&nbsp;</p>\n\n\n\n<p>Michelle Frechette 00:20:39&nbsp; This is answering June’s question.</p>\n\n\n\n<p>Tim Bouchard 00:20:41&nbsp; And it kind of. it kind of, vibes with, sticker that we have that we&#8217;re giving all the attendees and also the t-shirt option that we have, which is the Responsive by Design &#8211;&nbsp; Naughty by Nature reference. Yeah, I love that. there&#8217;s a little bit of this weird subtheme that we just decided to inject in that&#8217;s kind of like urban hip hop 80s. I don&#8217;t know, it just it seemed fun, so we just went for it. But there will be art battle stuff. There actually will be some interactive voting towards the second half of the day, and there will be three winners of gift gift cards at the end of the day, too.</p>\n\n\n\n<p>Michelle Frechette 00:21:17&nbsp; So can I make a suggestion for next year&#8217;s t-shirt?</p>\n\n\n\n<p>Speaker 4 00:21:20&nbsp; Sure.</p>\n\n\n\n<p>Michelle Frechette 00:21:21&nbsp; It&#8217;s black. It&#8217;s just black lettering on a white shirt, but it&#8217;s open lettering and it comes with Sharpie markers. So while you&#8217;re going through the day, you can color in your own Color Code shirt.</p>\n\n\n\n<p>Ron Brennan 00:21:32&nbsp; I like that.</p>\n\n\n\n<p>Tim Bouchard 00:21:33&nbsp; Interactive.</p>\n\n\n\n<p>Michelle Frechette 00:21:35&nbsp; Swag.</p>\n\n\n\n<p>Tim Bouchard 00:21:36&nbsp; Yeah. Yeah.</p>\n\n\n\n<p>Tim Bouchard 00:21:36&nbsp; Interactive swag.</p>\n\n\n\n<p>Michelle Frechette 00:21:37&nbsp; Somebody write that down.</p>\n\n\n\n<p>Tim Bouchard<strong> </strong>00:21:39&nbsp; We are. We&#8217;re getting a lot of good support from the sponsors too. So there will actually be things like swag bags when you check in. I mean, it&#8217;s just like we&#8217;ve gotten so much support from the people, that not only have done financial support, but they&#8217;re trying to make it so that the attendees have like a very top notch one day conference experience. So that&#8217;s I&#8217;m looking forward to that, to you and being able to provide that.</p>\n\n\n\n<p>Ron Brennan 00:22:03&nbsp; I think it&#8217;s going to be cool to have, like we&#8217;re going to have and then really never happens here. I mean, occasionally we&#8217;ll see other other marketing agency people at networking events or whatever. And, you know, some of us talk or whatever on, on online. But to have this group of people that are there in the same room together. Like I&#8217;m excited about that. You know, just what kind of collaborations and what kind of ideas can spark from just those side conversations that, you know, we&#8217;re never really in all in the same room like this.</p>\n\n\n\n<p>Michelle Frechette 00:22:38&nbsp; Yeah. So does that mean the hallway track is going to be exciting too?</p>\n\n\n\n<p>Ron Brennan 00:22:42&nbsp; Hallway tracks are always exciting.</p>\n\n\n\n<p>Michelle Frechette 00:22:43&nbsp; Haha! Opportunities to meet new people for sure.</p>\n\n\n\n<p>Tim Bouchard 00:22:48&nbsp; There&#8217;s there&#8217;s a lot of decent topics. I mean, we were scrolling through the the speaker list in the schedule. I mean, there will be AI topics and, you know, there&#8217;s the typical like content topics and there&#8217;s a few hot button topics. You know, the the new a new CMS someone is building is pretty cool. I&#8217;m going to be talking about decoupling yourself from Google because I personally am starting to hate Google. But like, you know, you have to live with it.</p>\n\n\n\n<p>Ron Brennan:&nbsp; How can it be done?&nbsp;</p>\n\n\n\n<p>Tim Bouchard: How do you play the game? I don&#8217;t know, right? Or I do know and I&#8217;m going to talk about it. But there&#8217;s a lot of decent like hot button topics that are coming up too. So I think even from a professional level, it&#8217;s not these aren&#8217;t like throwaway speaker presentations, even though they&#8217;re volunteer speakers. There&#8217;s going to be a lot of meat to this.</p>\n\n\n\n<p>Michelle Frechette 00:23:31&nbsp; Yeah, I realize that it&#8217;ll be hard for people to see necessarily, but the schedule is very concise. It&#8217;s also very colorful. I like that. but yeah, there&#8217;s a lot of amazing topics. I&#8217;m. I&#8217;m also glad that my talk is done early, because otherwise I have a tendency to, like, obsess about it and sit in the green room and work on it too much. And this way it&#8217;ll be done and I can go listen to other topics as well, which is a good thing.</p>\n\n\n\n<p>Ron Brennan 00:23:52&nbsp; Yeah, and there&#8217;s so many cool stories there, like Tamara, from The Foundry. she&#8217;s like second last talk in the in the second track there. The Future of Entrepreneurship. Like, she literally like her whole thing. And her whole career now has been to support her daughter, who was a young entrepreneur and had this product that she created and blew up into a company. And so she had to, you know, build out the support system to help her daughter turn this idea into a company. And now she&#8217;s teaching and, you know, kind of mentors young entrepreneurs. So this should be a really interesting, interesting talk there too.</p>\n\n\n\n<p>Michelle Frechette 00:24:35&nbsp; Yeah, for sure. There&#8217;s a lot of really, really cool stuff on the schedule. If people want to learn more here, let me change things up here a little bit. I do have a banner. I have a banner for this. Just go to colorcode.events in your browser and you will be able to see the whole schedule. Read up about the speakers and the topics, see more of what&#8217;s being planned for the day and for what&#8217;s up to the minute stuff. Go ahead on go on X. I still call it Twitter. Guys, I&#8217;m sorry, but.</p>\n\n\n\n<p>Tim Bouchard 00:25:04&nbsp; It’s Twitter. It’s both.&nbsp;</p>\n\n\n\n<p>Michelle Frechette 00:25:05&nbsp; Yeah @colorCodeEvents. it&#8217;s nice that you have the, you name something that had the URL available. That&#8217;s not always easy.</p>\n\n\n\n<p>Tim Bouchard 00:25:17&nbsp; Not for Instagram though. Instagram. It was taken by some unused account. So it&#8217;s like I think it&#8217;s hellocolorcode on Instagram.</p>\n\n\n\n<p>Michelle Frechette 00:25:24&nbsp; But yeah, there&#8217;s ways around things.</p>\n\n\n\n<p>Tim Bouchard 00:25:26&nbsp; But there&#8217;s always something.</p>\n\n\n\n<p>Michelle Frechette 00:25:28&nbsp; Exactly. But yeah. And you can get your tickets right on the website as well. Colorcode.events right now they are. What did we say, $40 for a ticket? To attend for the full day. And that includes lunch?</p>\n\n\n\n<p>Ron Brennan 00:25:39&nbsp; Yep.&nbsp;</p>\n\n\n\n<p>Michelle Frechette 00:25:41&nbsp; And the after party as well. So make sure that you sign up for that, especially if you&#8217;re in the area. But honestly, why wouldn&#8217;t you want to come anyway? And plus make a whole weekend of it? It&#8217;s just a hop, skip and a jump away from Niagara Falls. So you could actually, on Sunday, go and check out the falls or even Saturday night or Friday night or whatever. And, I love.</p>\n\n\n\n<p>Ron Brennan 00:25:59&nbsp; That we have our friends from, you know, Niagara Falls, Canada coming.</p>\n\n\n\n<p>Michelle Frechette 00:26:03&nbsp; Yep. Exactly. It&#8217;ll be good. I&#8217;m really looking forward to it. Yeah. Anything else you&#8217;d like to mention about it other than sign up? Come, join.</p>\n\n\n\n<p>Ron Brennan 00:26:13&nbsp; I think we&#8217;re going to be. We&#8217;re going to try. we&#8217;re not streaming it, but we are going to try and record every track and then, you know, get it up on a on a YouTube or make it available through the website in some way, shape or form or some combination of Tim&#8217;s cameras and our mics and whatever.</p>\n\n\n\n<p>Michelle Frechette 00:26:31&nbsp; Yeah, excellent. That&#8217;ll be great.</p>\n\n\n\n<p>Tim Bouchard 00:26:33&nbsp; Because we love torture. So we&#8217;re going to do that to ourselves.&nbsp;</p>\n\n\n\n<p>Ron Brennan 00:26:36&nbsp; That&#8217;s right. You know how that goes with with WordCamps. You know, then the footage will be there as well. Anybody edit it and actually upload it or will it sit on a.</p>\n\n\n\n<p>Tim Bouchard 00:26:47&nbsp; It&#8217;s important though. It&#8217;s you know, we&#8217;ve run an event like this for ten years, but this is the first event. And we want to make sure that people can see what it was, what it was about, what types of quality topics we had and speakers. So, you know, we think that there&#8217;s something here. And if we can make sure that we&#8217;re always pushing out the quality of this, then, you know, it makes it more possible for us to potentially do another city at some point. And it&#8217;s not just in Buffalo in the northeast. It could be in the southeast, it could be Midwest, it could be whatever. You know, there&#8217;s creatives, marketers and devs all over the country. Could be in Canada, could be in Europe, I don&#8217;t know.</p>\n\n\n\n<p>Ron Brennan 00:27:28&nbsp; Europe, yeah, it could be Europe. Color Code Europe/</p>\n\n\n\n<p>Tim Bouchard 00:27:30&nbsp; It&#8217;s only a concept of a plan.</p>\n\n\n\n<p>Michelle Frechette 00:27:33&nbsp; Exactly.</p>\n\n\n\n<p>Tim Bouchard 00:27:34&nbsp; That&#8217;s it.</p>\n\n\n\n<p>Michelle Frechette 00:27:35&nbsp; The concept of a plan. We have a couple people watching. If you have questions. Now is your time to put them in the comments before we wrap up for the day. I guess I have. I&#8217;m out of questions, I don&#8217;t know, are you still looking for sponsors or are you still in need of sponsors? And not so much?</p>\n\n\n\n<p>Tim Bouchard 00:27:51 Well, always. We&#8217;re the high, ticket sponsors are all taken up there. We&#8217;re always open to someone doing a low level if they want to grab a ticket and a low level sponsorship just to support it. We&#8217;ll always welcome that. So there&#8217;s still time to do that, but will it? It&#8217;s not critical for the event. It&#8217;s all set up, ready to go. We&#8217;re just get people on the tickets, get people the event. We&#8217;re going to have a great time, listen to some quality talks, meet some cool people, then do it again.</p>\n\n\n\n<p>Michelle Frechette 00:28:20&nbsp; Sounds good. I&#8217;m looking forward to it. I will be there bright and early. So are you coming.</p>\n\n\n\n<p>Ron Brennan 00:28:25&nbsp; Your coming&nbsp; the night before right?</p>\n\n\n\n<p>Michelle Frechette 00:28:28&nbsp; I was planning to. I don&#8217;t have anybody in the area to help me with my scooter at the hotel. That&#8217;s what&#8217;s stopping me from coming out the night early the night before, so I was going to drive in super early on Saturday.</p>\n\n\n\n<p>Ron Brennan 00:28:38&nbsp; Okay.</p>\n\n\n\n<p>Michelle Frechette 00:28:40&nbsp; But we can always talk later. If you know somebody that is in, is around and can help. But otherwise.</p>\n\n\n\n<p>Ron Brennan 00:28:45 That’s crazy we are here. I say that we&#8217;re we&#8217;re here like, you know, we were talking a little bit earlier on about your first WordCamp in Buffalo. Yeah. And, so that was the back in the good old days when Ben used to sneak, like, 150 people into the Canisius cafeteria, and that&#8217;s where we had the WordCamp. So that was.</p>\n\n\n\n<p>Michelle Frechette 00:29:08&nbsp; We&#8217;ve come a long way, baby.</p>\n\n\n\n<p>Ron Brennan 00:29:09&nbsp; That&#8217;s right. That&#8217;s where your first one was. Right at Canisius?</p>\n\n\n\n<p>Michelle Frechette&nbsp; 00:29:13&nbsp; Yeah.</p>\n\n\n\n<p>Ron Brennan 00:29:14&nbsp; I&#8217;m pretty sure that&#8217;s where I met you at Canisius. Yeah. And. Yeah. And then I found out after I didn&#8217;t know this, but I was like, I thought we had permission. And Ben&#8217;s like, no, nobody. I&#8217;m like, you just had 150 people show up here. And nobody questioned?</p>\n\n\n\n<p>Michelle Frechette 00:29:27&nbsp; Nobody blinked.</p>\n\n\n\n<p>Tim Bouchard 00:29:29&nbsp; Yeah, everybody knew about it but Canisius. But it was cool. It was a good event.</p>\n\n\n\n<p>Michelle Frechette 00:29:33&nbsp; It was like a it was a good event.</p>\n\n\n\n<p>Tim Bouchard 00:29:35&nbsp; I met my first developer, Tommy, who is now our current developer, again at that event at Canisius. He was just graduating from school, actually, through one of Ben&#8217;s programs. And that&#8217;s the type of thing you can do. It&#8217;s a good recruiting place, good networking place. It&#8217;s a good learning place. And genuinely, like, we know when this community gets together, whether it&#8217;s WordPress or marketing or creative or just that side of it, it&#8217;s it&#8217;s always good people. So yeah, we look forward to bringing those people together.</p>\n\n\n\n<p>Michelle Frechette 00:30:01&nbsp; Will you have a job board people can write openings on, and people who are looking for jobs like we do some events?</p>\n\n\n\n<p>Tim Bouchard 00:30:06&nbsp; You know, I thought about that and we haven&#8217;t set anything up. we do have a Slack channel, or property, whatever it&#8217;s called workspace that we have set up that we&#8217;re going to invite all the attendees into, probably after that 4/19 deadline so we can ramp up for two weeks and people can start chats in there and stuff.</p>\n\n\n\n<p>Michelle Frechette 00:30:26&nbsp; Sounds good.</p>\n\n\n\n<p>Tim Bouchard 00:30:26&nbsp; Because we want to just bring people together as much as possible.</p>\n\n\n\n<p>Michelle Frechette 00:30:30&nbsp; Yeah, I think that&#8217;s awesome. I want to thank.</p>\n\n\n\n<p>Ron Brennan 00:30:33&nbsp; Designers, developers, just any anybody that&#8217;s interested in, you know, learning more about some of the cool things that are being done or can be done, like this event, you know, it&#8217;s it&#8217;s it&#8217;s a great opportunity to network whether you&#8217;re looking to expand your career. You know, if I was in school as a computer science or developer or a, you know, a graphic designer or something right now, like this is an event, I would probably you&#8217;re going to have a bunch of the top marketing agencies in Buffalo on hand at this event, and it&#8217;s a great opportunity to expand that network and and just get out there.</p>\n\n\n\n<p>Michelle Frechette 00:31:16&nbsp; Absolutely, and if you even are thinking about it like I&#8217;ve been asking women like, you know, advice for people who are thinking, women who are thinking about joining WordPress and joining tech. So, I mean, if you have an inkling or want to learn a little bit more about it and the kinds of people involved, it&#8217;s a really inexpensive ticket to spend the day networking with folks and learning as much as you can.</p>\n\n\n\n<p>Tim Bouchard 00:31:37&nbsp; Yeah, and hopefully the weather cooperates with us. It&#8217;ll be May. May can be very nice in Buffalo. It could also be not nice. Who knows?</p>\n\n\n\n<p>Michelle Frechette 00:31:45&nbsp; I mean, we had snow yesterday.</p>\n\n\n\n<p>Tim Bouchard 00:31:47&nbsp; I&#8217;m hoping we can show off the city because it, you know, when the weather breaks in the city, it&#8217;s one of the best ones to to visit in the summertime. But there&#8217;s good people here, and we&#8217;re in a good spot downtown, so.</p>\n\n\n\n<p>Michelle Frechette 00:32:01&nbsp; Absolutely. Well, guys, don&#8217;t go anywhere. I&#8217;m going to go ahead and end this. But I want to talk to you for just a couple of minutes before we go. Thank you so much for being here. Really appreciate learning more and and being able to share this event with people through Post Status. if you are listening, go to colorcode.events for more information. And I don&#8217;t know who&#8217;s going to be here next week, but I will have another Post Status Happiness Hour live next week and we&#8217;ll be here to chat with everybody.</p>\n\n\n\n<p>Tim Bouchard 00:32:28&nbsp; Thanks. Yeah. Thanks, Michelle.</p>\n\n\n\n<p>Ron Brennan 00:32:30&nbsp; Yeah.</p>\n<p>This article, <a href=\"https://poststatus.com/post-status-happiness-hour-session-twenty-five/\">Post Status Happiness Hour Session Twenty Five</a>, was published at  <a href=\"https://poststatus.com\">Post Status</a> — the community for WordPress professionals.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 17 Apr 2025 21:30:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Olivia Bisset\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:12;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"Post Status: Layoffs: Survivor’s Guilt and Fear of Being Next\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://poststatus.com/?p=163488\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"https://poststatus.com/survivors-guilt-and-fear-of-being-next/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:7843:\"<p>Since being laid off in February, I&#8217;ve had a lot of conversations with others on both sides of layoffs. </p>\n\n\n\n<p>It&#8217;s really hard to be in the tech job market (or any job market in this economy) right now, with <a href=\"https://techcrunch.com/2025/04/04/tech-layoffs-2025-list/\">so many recent layoffs</a>. As someone in the mix of it right now (and I haven&#8217;t been looking that earnestly yet, as I&#8217;ve been taking some time to regroup, heal from feelings through the process, and decide what my next steps are) I understand the mental burden, the anxiety, and the fear that comes with being on the job market. </p>\n\n\n\n<p>I am privileged to be in a place financially that has afforded me some time off as I strategize. Others are not as fortunate and need to find work immediately to keep paying bills and putting food on the table for their families. It&#8217;s not easy, for sure.</p>\n\n\n\n<p>But it&#8217;s also not easy for those at the companies doing layoffs who are still employed there. There are so many feelings that come with being a &#8220;layoff survivor.&#8221; Yet to talk about those feelings seems so insensitive to those who are job searching like crazy, right?</p>\n\n\n\n<p>The thing is, it&#8217;s hard on both sides of the issue. </p>\n\n\n\n<p>While on the one hand, clearly, it&#8217;s difficult to be in a place where you&#8217;re suddenly looking for new employment, desperately trying to make sure you spend wisely to get you through to your next job, the truth is that <em>it&#8217;s mentally difficult to be a survivor, too.</em></p>\n\n\n\n<p>Sitting where I am at the moment, polishing my résumé, reading through job posts, it <em>could</em> (or should) be difficult to have sympathy for those <em>working</em>, but I&#8217;ve been in both places. I&#8217;ve been the person still in the company watching friends and colleagues suddenly wondering what to do next, and I&#8217;ve been where I am now.</p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"h-survivor-s-guilt-is-real-so-is-dread\">Survivor&#8217;s Guilt is Real. So is Dread.</h2>\n\n\n\n<p>It really doesn&#8217;t feel good when your employer has to do layoffs &#8211; even when you are one of the people still employed.</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>You may feel guilty when you see others being laid off and you&#8217;re still holding your job. This is a normal response in this situation. It&#8217;s difficult to see coworkers and friends lose their roles. Feeling bad for them is normal. It&#8217;s also normal to feel a sort of survivor&#8217;s guilt that you still have your role.</li>\n\n\n\n<li>You may also feel the dread of &#8220;waiting for the other shoe to drop.&#8221; Feeling like it could be you next causes anxiety. This is also a normal feeling. Anything that disrupts the status quo of your working environment &#8211; real or virtual &#8211; can make you feel off-kilter at best, and dread at worst.</li>\n</ul>\n\n\n\n<p>Layoffs usually happen when there is a surplus of workers for the demand, mostly based on sales. So feeling the dread of wondering if you will be included in the next wave of layoffs (or wondering if there <em>will be </em>a next wave) is very normal. And while there aren&#8217;t any words anyone can give you to make you feel 100% secure, you should know that a wave of layoffs isn&#8217;t a whim, and is planned well in advance to combat issues that have been rising over time, so if your job is still in place following layoffs, you should be fairly confident that you will continue to be employed.</p>\n\n\n\n<p>It&#8217;s also common after layoffs to have workloads redistributed, so you may feel some dread or anxiety if your workload is increased. Be sure to communicate with your supervisor what is actually doable, and what is too much to expect one person to accomplish. A company&#8217;s decision to do layoffs shouldn&#8217;t mean that those still working are taxed with more work than they can handle.</p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"h-how-to-talk-to-someone-who-has-been-laid-off\">How to Talk to Someone Who Has Been Laid Off</h2>\n\n\n\n<p>First, please <em>do</em> talk to those you want to remain friends (or friendly) with after they have been removed from their roles. Being laid off can feel like you&#8217;ve just been evicted from a home. You&#8217;ve often lost access to either a physical space you&#8217;re used to, or a digital one, or both. </p>\n\n\n\n<p>Not being in Slack channels with people you worked with, losing access to email and calendars, and watching access to work spaces disappear feels like you&#8217;ve been excommunicated from a community, when it&#8217;s really just a business protecting its own assets and following protocols. Reaching out to folks after the fact can help bridge the gap they feel between themselves and people they were used to working with.</p>\n\n\n\n<p><strong>Do&#8217;s and Don&#8217;ts</strong></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Do</strong> ask friends how they are doing and if they need to chat. Reaching out to check in, to say you enjoyed working together, or just to say you miss someone is a lovely way to stay connected.</li>\n\n\n\n<li><strong>Don&#8217;t</strong> ask them &#8220;have you found a job yet&#8221; or &#8220;how is the job search going.&#8221; This often feels like pressure, and having to say &#8220;no, I haven&#8217;t&#8221; feels bad. There is so much self doubt at this point in a person&#8217;s life, that added pressure by others about the job just feels oppressive and embarrassing.</li>\n\n\n\n<li><strong>Do</strong> offer to take them to coffee (or a coffee zoom) and be a listening ear.</li>\n\n\n\n<li><strong>Don&#8217;t</strong> badmouth the company or allow them to make you feel uncomfortable if they do.</li>\n\n\n\n<li><strong>Do</strong> offer to help if you can: review a résumé, make a call, serve as a reference, etc.</li>\n\n\n\n<li><strong>Don&#8217;t</strong> take anything they&#8217;ve shared with you back to the office to repeat to others. Don&#8217;t betray their trust.</li>\n\n\n\n<li><strong>Do</strong> offer reassurance, without sounding trite. Saying things like &#8220;I know you&#8217;ll land something soon,&#8221; or &#8220;you&#8217;ll be fine&#8221; aren&#8217;t helpful.</li>\n\n\n\n<li><strong>Nice, but not necessary</strong>, you can always gift someone a gift card for coffee, a meal, or something they enjoy as a hobby. (When I received a few of these, they made me feel valued, seen, and supported.)</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"h-protect-your-mental-health\">Protect Your Mental Health</h2>\n\n\n\n<p>Regardless of who was laid off in your company, none of their current situation is based on anything that <em>you</em> did or didn&#8217;t do.</p>\n\n\n\n<p>Leaning into guilt, anxiety, and dread doesn&#8217;t help someone else, and only hurts yourself, your mental wellbeing, and, potentially, your work performance. </p>\n\n\n\n<p>If you are struggling with your mental response to layoffs at your company, please find a trusted person, therapist, or doctor to talk to. </p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"h-if-you-have-been-laid-off\">If You Have Been Laid Off&#8230;</h2>\n\n\n\n<p>There are resources to help you. You can refer to <a href=\"https://poststatus.com/wordpress-layoffs-some-resources/\">our post about layoff resources</a> for many areas of help, including job boards, résumé ideas, networking groups and more.</p>\n\n\n\n<p>Remember that you aren&#8217;t alone. You have value. You deserve to work. </p>\n\n\n\n<p>There are people and resources to help you navigate to your next role.</p>\n\n\n\n<p></p>\n<p>This article, <a href=\"https://poststatus.com/survivors-guilt-and-fear-of-being-next/\">Layoffs: Survivor&#8217;s Guilt and Fear of Being Next</a>, was published at  <a href=\"https://poststatus.com\">Post Status</a> — the community for WordPress professionals.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 17 Apr 2025 21:30:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Michelle Frechette\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:13;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Post Status: Agency News Weekly\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://poststatus.com/?p=163428\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://poststatus.com/agency-news-weekly-2025-04-07/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:6084:\"<h2 class=\"gb-headline gb-headline-3f9efd72 gb-headline-text\">Google Wants to Subscribe to Your Email List</h2>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Your email newsletter can now influence how brands appear across Google&#8217;s search platforms.</li>\n\n\n\n<li>A new addition to the <a href=\"https://business.google.com/us/merchant-center/\">Google Merchant Center</a> expands Googles index by including marketing emails in its crawled data.</li>\n\n\n\n<li>Google will examine your emails and extract sales and promotions, new products, social media content and links, brand voice, images, and videos.</li>\n\n\n\n<li>To include Google as a recipient, add marketingemailtogoog@gmail.com to your list, or Google may sign up for these communications automatically.</li>\n\n\n\n<li>If you&#8217;d rather not have Google indexing your marketing communications, <a href=\"https://support.google.com/merchants/answer/15760498#How-do-I-opt-out\">you can opt-out</a> in the General Account Options area of the Google Merchant Center</li>\n\n\n\n<li><a href=\"https://progressplanner.com/google-now-wants-your-marketing-emails-literally/\">Read more about this interesting development in this post from Joost de Valk</a>.</li>\n</ul>\n\n\n\n<h2 class=\"gb-headline gb-headline-930042ec gb-headline-text\">Hackers Are Hiding Malicious Code in MU Plugins </h2>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://blog.sucuri.net/2025/02/hidden-backdoors-uncovered-in-wordpress-malware-investigation.html\">Sucuri researchers</a> have noticed a new trend of malicious code hidden in the WordPress mu-plugins directory.</li>\n\n\n\n<li>A <a href=\"https://developer.wordpress.org/advanced-administration/plugins/mu-plugins/\">Must-Use (MU) plugin</a> is a special type of WordPress plugin that automatically executes on every page load without requiring activation like other plugins in the dashboard.</li>\n\n\n\n<li>In order to create an MU plugin, an attacker must gain access to the site by exploiting compromised themes, plugins, or credentials.</li>\n\n\n\n<li>Sucuri researchers have found 3 specific payloads being added to MU plugins:\n<ul class=\"wp-block-list\">\n<li><strong>Redirect.php</strong>: redirects visitors (other than bots and logged-in admins) to page that attempts to trick them into downloading malware.</li>\n\n\n\n<li><strong>Index.php</strong>: a particularly dangerous webshell UI that allows execution of PHP code from a GitHub repository.<br /><strong>Custom-js-loader.php</strong>: replaces all images on the site with adult content and redirects all links to dangerous websites.</li>\n</ul>\n</li>\n\n\n\n<li>While many agencies already have a good process for protecting against compromised themes, plugins, and credentials, adding file change notices and/or regular audits of the mu-plugins directory is something to consider.</li>\n</ul>\n\n\n\n<h2 class=\"gb-headline gb-headline-7643d17f gb-headline-text\">Do Exact Match Domains Matter in Today&#8217;s SEO?</h2>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Back in the day, if you owned the domain name that was an exact match for a search keyword, it was almost a guarantee you&#8217;d be at the top of the search results.</li>\n\n\n\n<li>While exact match domains no longer guarantee SEO success like they used to, they can still provide value as part of a marketing strategy that prioritizes memorability and trust.</li>\n\n\n\n<li>Local businesses in particular can benefit from geo-specific exact match domains, especially in competitive service industries <em>(think chicagoplumber.com or dallaselectrician.com).</em></li>\n\n\n\n<li>Plus, voice search and AI assistants have made memorable, easily pronounced domain names more valuable than ever.</li>\n\n\n\n<li><em>&#8220;If your domain sounds like a real brand, people will treat it like one – and so will search engines.&#8221;</em></li>\n\n\n\n<li>Learn more about <a href=\"https://searchengineland.com/exact-match-domains-value-453837\">exact match domains</a> and the <a href=\"https://searchengineland.com/seo-imperative-brand-building-453277\">importance of brand-building in SEO</a> in these 2 helpful articles from SearchEngineLand.<br /><br /></li>\n</ul>\n\n\n\n<h2 class=\"gb-headline gb-headline-7813eada gb-headline-text\">Worth a Look </h2>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong><a href=\"https://automattic.com/2025/04/02/restructuring-announcement/\">Automattic has announced</a> a 16% workforce reduction</strong> &#8220;to protect&nbsp;Automattic’s long-term future,&#8221; according to Matt Mullenweg.</li>\n\n\n\n<li>ICYMI, <strong>Skype will be shutting down for good on May 5</strong>. If you&#8217;re still using a Skype phone number for VoIP and SMS, Google Voice seems to be the most logical replacement. <a href=\"https://techcrunch.com/2025/03/15/skype-shuts-down-in-may-these-are-the-best-alternatives/#h-how-to-export-skype-data\">Skype also supports data export</a> if you want to save old messages.</li>\n\n\n\n<li><strong><a href=\"https://wpslimseo.com/introducing-slim-seo-pro/\">SlimSEO has released a new Pro version</a></strong> combining its previous <a href=\"https://wpslimseo.com/products/slim-seo-schema/\">Schema</a>&nbsp;and&nbsp;<a href=\"https://wpslimseo.com/products/slim-seo-link-manager/\">Link Manager</a>&nbsp;add-ons into a single new premium plugin.</li>\n\n\n\n<li><a href=\"https://www.theverge.com/news/641270/adobe-premiere-pro-generative-extend-generally-available\"><strong>Adobe Premiere Pro has a new generative AI tool</strong> </a>that can extend 4K clips by up to 2 seconds and audio by 10 seconds.</li>\n\n\n\n<li><strong>Learn <a href=\"https://searchengineland.com/optimize-company-google-knowledge-panel-453882\">how to optimize your agency&#8217;s Google Knowledge Panel</a></strong> with this helpful guide.</li>\n\n\n\n<li><strong>Microsoft has unveiled an <a href=\"https://copilot.microsoft.com/wham\">AI-generated version of Quake II</a></strong> you can play in a browser.</li>\n</ul>\n<p>This article, <a href=\"https://poststatus.com/agency-news-weekly-2025-04-07/\">Agency News Weekly</a>, was published at  <a href=\"https://poststatus.com\">Post Status</a> — the community for WordPress professionals.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 17 Apr 2025 21:30:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Nathan Ingram\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:14;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"Post Status: The Latest from Post Status Members\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://poststatus.com/?p=163434\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"https://poststatus.com/the-latest-from-post-status-members-2025-04-07/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:6448:\"<p><strong>Ronni K. Gothard Christiansen</strong> shared a LinkedIn post highlighting recognition for business technology achievements and the MyData Global Award. <a href=\"https://www.linkedin.com/posts/ronnikc_business-technology-mydataglobalaward-activity-7312787636471939073-Xplz\">See the post</a>.</p>\n\n\n\n<p><strong>Seth Goldstein</strong> had a busy week of appearances and publications: he interviewed <strong>Anthony Franco</strong> on <em>Entrepreneur’s Enigma</em>, discussed branding from scratch on <em>Digital Marketing Dive</em>, and was a guest on <em>Podcasting Amplified</em> to talk podcasting. <a href=\"https://entrepreneursenigma.com/anthonyfranco\">Entrepreneur’s Enigma</a> • <a href=\"https://www.digitalmarketingdive.com/crafting-your-identity-steps-to-kickstart-your-brand-from-ground-zero\">Digital Marketing Dive</a> • <a href=\"https://podcasts.apple.com/us/podcast/essential-podcasting-tips-and-tricks-from-a-15/id1714803934?i=1000701678105\">Podcasting Amplified</a></p>\n\n\n\n<p><strong>Chris Reynolds</strong> posted a quick video recap of <strong>DrupalCon Atlanta</strong>. <a href=\"https://www.youtube.com/watch?v=WxLDEoSidXE\">Watch it here</a></p>\n\n\n\n<p><strong>Rae Morey</strong> shared her excitement about attending <strong>PressConf</strong> in Arizona as an official media partner and wrote about why she’s heading to the event. <a href=\"https://www.therepository.email/why-im-heading-to-arizona-for-the-first-ever-pressconf\">Read the article</a></p>\n\n\n\n<p><strong>Amadeu Arderiu</strong> announced the beta launch of <strong>Joinchat AI</strong>, a new WordPress chatbot that uses only your site content to power AI conversations, with flexible post type selection.</p>\n\n\n\n<p><strong>Seth Goldstein</strong> published the latest edition of the <em>Marketing Junto</em> newsletter, featuring a discussion on <strong>Perplexity and TikTok</strong>. <a href=\"https://marketingjunto.com/perplexity-and-tiktok/\">Read it here</a></p>\n\n\n\n<p><strong>Adrian Tobey</strong> live-streamed a roast of old versions of his Groundhogg plugin. <a href=\"https://youtu.be/DVDhedllJL0?t=402\">Watch the stream</a></p>\n\n\n\n<p><strong>Matt Medeiros</strong> shared a video showing how <strong>AI can handle phone calls</strong> for WordPress freelancers and agencies. <a href=\"https://youtu.be/Gg1BzvIwZng\">Watch here</a></p>\n\n\n\n<p><strong>Derek Ashauer</strong> released <strong>Conversion Bridge 1.7</strong>, now supporting 16 analytics platforms, 6 ad platforms, and 55 plugin integrations for enhanced tracking and segmentation. <a href=\"https://conversionbridgewp.com/enhanced-conversions-for-all/\">View the update</a></p>\n\n\n\n<p><strong>Ronni K. Gothard Christiansen</strong> posted about <strong>new U.S. cross-border data sharing rules</strong> and their potential impact. <a href=\"https://www.linkedin.com/pulse/new-us-cross-border-data-sharing-rules-ronni-k-gothard-christiansen-ngnwc\">Read more</a></p>\n\n\n\n<p><strong>Taco Verdonschot</strong> addressed the ban of <strong>Joost de Valk</strong> and <strong>Progress Planner</strong> from WordCamp Asia and all future events in a personal blog post. <a href=\"https://progressplanner.com/real-impact-of-being-banned-from-wordpress/\">Read his perspective</a></p>\n\n\n\n<p><strong>Alex Standiford</strong> is seeking a new WordPress client and shared a <strong>portfolio of complex projects</strong> he’s worked on. <a href=\"https://www.alexstandiford.com/category/portfolio/\">View portfolio</a></p>\n\n\n\n<p><strong>Ryan Welcher</strong> hosted a live Twitch session focused on <strong>adding user profiles to the Block Developer Cookbook</strong>. <a href=\"https://www.twitch.tv/RyanWelcherCodes\">Watch the stream</a></p>\n\n\n\n<p><strong>Chris</strong> published a blog post recounting his <strong>experience at DrupalCon Atlanta</strong> from a WordPress perspective. <a href=\"https://pantheon.io/blog/wordpresser-goes-drupalcon-atlanta-2025\">Read it here</a></p>\n\n\n\n<p><strong>Benjamin Intal</strong> shared a new project idea exploring how <strong>AI might help with article writing</strong>, especially when struggling to organize thoughts. <a href=\"https://x.com/bfintal/status/1908104586638012774?s=46&t=LFLih_w_bvvXcu6ZC62o4Q\">View the tweet</a></p>\n\n\n\n<p><strong>Jonathan Bossenger</strong> returned to livestreaming and focused on fixing issues in his <strong>WP to MD exporter plugin</strong>. <a href=\"https://www.twitch.tv/jonathanbossenger\">Watch the session</a></p>\n\n\n\n<p><strong>Joost de Valk</strong> published a post discussing how <strong>Google is targeting marketing emails</strong>. <a href=\"https://progressplanner.com/google-now-wants-your-marketing-emails-literally/\">Read the article</a></p>\n\n\n\n<p><strong>Topher DeRosia</strong> announced the launch of the <strong>HeroPress swag store</strong>, with $5 from each sale supporting the HeroPress mission. <a href=\"https://thewp.world/product-category/heropress/\">Visit the store</a></p>\n\n\n\n<p><strong>Tom Whitaker</strong> showcased a Canadian-flavored demo of <strong>voice-driven AI form building</strong> with <strong>GravityBuilder.ai</strong>, which works as an add-on to Gravity Forms. <a href=\"https://gravitybuilder.ai\">Learn more</a></p>\n\n\n\n<p><strong>Carl Alexander</strong> shared a livestream session where he tested <strong>North Commerce with Ymir</strong>, evaluating compatibility between the two platforms. <a href=\"https://www.youtube.com/watch?v=aD0kH-QbRx0\">Watch here</a></p>\n\n\n\n<p><strong>Bob Dunn</strong> announced that <strong>Michelle Frechette</strong> has joined the Do the Woo hosting team to focus on WordPress event discussions. The announcement is available on the <a href=\"https://dothewoo.io/michelle-frechette-joins-the-do-the-woo-hosting-team-for-wordpress-event-talk/\">Do the Woo website</a>.</p>\n\n\n\n<p><strong>Jamie Marsland</strong> highlighted research showing that 90% of B2B buyers create a shortlist before formal research begins, emphasizing the importance of brand trust and visibility for WordPress businesses. More details are in his post on <a href=\"https://www.pootlepress.com/2025/04/90-of-buyers-wont-shortlist-you-unless-they-know-and-trust-your-brand-research-reveals/\">Pootlepress</a>.</p>\n<p>This article, <a href=\"https://poststatus.com/the-latest-from-post-status-members-2025-04-07/\">The Latest from Post Status Members</a>, was published at  <a href=\"https://poststatus.com\">Post Status</a> — the community for WordPress professionals.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 17 Apr 2025 21:30:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Nathan Ingram\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:15;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"Post Status: Post Status Happiness Hour Session Twenty Four\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://poststatus.com/?p=163457\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"https://poststatus.com/post-status-happiness-hour-session-twenty-three-2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:60536:\"<div class=\"wp-block-embed__wrapper\">\n\n</div>\n\n\n\n\n\n\n\n<p><a href=\"https://poststatus.com/category/planet/#h-transcript\">Transcript</a> ↓</p>\n\n\n\n<p>In this episode of the Post Status Happiness Hour, host <a href=\"https://x.com/michelleames\">Michelle Frechette</a> interviews <a href=\"https://www.linkedin.com/in/rogerwilliamsmedia/\">Roger Williams</a> from Kinsta. Who serves as the Partnerships and Community Manager for North America. They discuss various topics including the WordPress community, Kinsta&#8217;s new affiliate program, and their global sponsorship of WordCamps. The episode also highlights the creation of collaborative music playlists within the Post Status Slack community and the importance of concise, engaging content. Additionally, the guest shares insights on supporting WordPress contributors and the launch of Kinsta&#8217;s new automatic updates feature for themes and plugins.</p>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"h-top-takeaways\">Top Takeaways: </h3>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>The Importance of Thorough Testing in Software Development and Releases:</strong> Michelle emphasized the critical role of testing and feedback during the release cycle of WordPress 6.8, particularly as they approach its official launch. Despite having a dedicated testing community, the need for more testers is constant to ensure compatibility with a wide range of plugins and themes. The takeaway is that comprehensive testing is vital for minimizing issues at launch, and encouraging more community involvement can help ensure smoother releases.</li>\n\n\n\n<li><strong>The Value of Consistent Community Contribution and Support for Open Source Projects:</strong> Roger highlighted the importance of documentation in open-source projects like WordPress, noting that it&#8217;s often underappreciated until something goes wrong. He also spoke about Kinsta’s involvement in supporting the community through contributions, such as sponsoring WordCamp and supporting documentation initiatives. The takeaway is that consistent, behind-the-scenes contributions, like documentation and community support, are crucial for the sustainability and success of open-source projects, even though they are often taken for granted.</li>\n\n\n\n<li><strong>Kinsta’s Automatic Updates Feature Enhances Site Reliability:</strong> Roger introduced Kinsta’s new Automatic Updates feature, which ensures WordPress sites remain updated while minimizing risks. The system takes a before-and-after screenshot during updates and automatically reverts changes if visual differences are detected, helping prevent website issues that could impact business operations.</li>\n</ul>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"h-mentioned-in-the-show\">Mentioned In The Show:</h3>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://kinsta.com/\">Kinsta</a></li>\n\n\n\n<li><a href=\"https://linuxcontainers.org/\">Linux container project  </a></li>\n\n\n\n<li><a href=\"https://www.linkedin.com/\">LinkedIn</a></li>\n\n\n\n<li><a href=\"https://us.wordcamp.org/2025/\">WordCamp US</a></li>\n\n\n\n<li><a href=\"https://sevalla.com/\">Sevalla</a></li>\n\n\n\n<li><a href=\"https://www.cloudflare.com/lp/dg/brand/cloudflare-enterprise/?utm_medium=cpc&utm_source=google&utm_campaign=ao-fy-acq-namer_en-connectivity-en-txt-general-brand_product&utm_content=brand_umbrella_core&utm_source=google&utm_medium=cpc&utm_campaign=CLOUD_ACQ_AOFY_CNC_GOOGLE_GENERAL_TXT_NAMER-EN_NA_MOFU_GENERAL_X_LEAD-GEN_BRAND-PRODUCT&utm_content=Brand_Umbrella_Core&campaignid=71700000121545787&adgroupid=58700008860151626&creativeid=739454660289&&utm_term=cloudflare%20enterprise_go_cmp-20146409196_adg-152212902947_ad-739454660289_kwd-418069705345_dev-c_ext-_prd-_sig-CjwKCAjwwLO_BhB2EiwAx2e-3300Ih7Dbq0XKzasJpuOGihSN2zBmtYH097QVZ3Am_X10ChkNQSbvhoCZNUQAvD_BwE&gad_source=1&gclid=CjwKCAjwwLO_BhB2EiwAx2e-3300Ih7Dbq0XKzasJpuOGihSN2zBmtYH097QVZ3Am_X10ChkNQSbvhoCZNUQAvD_BwE&gclsrc=aw.ds\">Cloudflare Enterprise</a></li>\n\n\n\n<li><a href=\"https://stackoverflow.com/questions\">StackOverflow</a></li>\n\n\n\n<li><a href=\"http://meetup.com\">Meetup.com</a></li>\n\n\n\n<li><a href=\"https://wordpressfoundation.org/\">WordPress Foundation</a></li>\n\n\n\n<li><a href=\"https://esoterracider.com/\">EsoTerra Cidery</a></li>\n\n\n\n<li><a href=\"https://kinsta.com/changelog/kinsta-automatic-updates/\">Kinsta Automatic Updates</a></li>\n</ul>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-core-columns-is-layout-2 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<h2 class=\"wp-block-heading\" id=\"h-sponsor-wordpress-com\"><img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/1f64f.png\" alt=\"🙏\" class=\"wp-smiley\" /> Sponsor: <a href=\"https://poststatus.com/wordpresscom\">WordPress.com</a></h2>\n\n\n\n<p>Build and manage professional sites with secure managed hosting on WordPress.com. Beautiful themes, built-in SEO, and payment tools, and access to over 50,000 plugins. Everything you need for your business, plus 24/7 support from WordPress experts. </p>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<img width=\"752\" height=\"752\" src=\"https://poststatus.com/wp-content/uploads/2024/01/WordPress_blue_logo.svg-752x752.png\" alt=\"\" class=\"wp-image-158475\" />\n</div>\n</div>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"h-you-can-follow-post-status-and-our-guests-on-social-media\"><img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/1f426.png\" alt=\"🐦\" class=\"wp-smiley\" /> You can follow Post Status and our guests on Social Media:</h3>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://www.linkedin.com/in/rogerwilliamsmedia/\">Roger Williams</a> (Community Manager, <a href=\"https://www.linkedin.com/company/kinsta/\">Kinsta</a>)</li>\n\n\n\n<li><a href=\"https://twitter.com/michelleames\">Michelle Frechette</a>&nbsp;(Director of Community Relations,&nbsp;<a href=\"https://twitter.com/post_status\">Post Status</a>)</li>\n\n\n\n<li><a href=\"https://twitter.com/lemonadecode\">Olivia Bisset</a>&nbsp;(Intern,&nbsp;<a href=\"https://twitter.com/post_status\">Post Status</a>)</li>\n</ul>\n\n\n\n<p>The <strong>Post Status</strong> podcast is geared toward WordPress professionals, with interviews, news, and deep analysis. <img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/1f4dd.png\" alt=\"📝\" class=\"wp-smiley\" /></p>\n\n\n\n<p><a href=\"https://poststatus.com/category/post-status-podcasts/\">Browse our archives</a>, and don’t forget to subscribe via <a href=\"https://itunes.apple.com/us/podcast/post-status-draft-wordpress/id976403008\">iTunes</a>, <a href=\"https://podcasts.google.com/feed/aHR0cHM6Ly9mZWVkcy5zaW1wbGVjYXN0LmNvbS8ySkU5c2M4UA\">Google Podcasts</a>, <a href=\"https://www.youtube.com/c/PostStatus\">YouTube</a>, <a href=\"http://www.stitcher.com/podcast/krogsgard/post-status-draft-wordpress-podcast\">Stitcher</a>, <a href=\"https://wordpress-post-status-draft-podcast.simplecast.com/\">Simplecast</a>, or <a href=\"https://feeds.simplecast.com/2JE9sc8P\">RSS</a>. <img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/1f3a7.png\" alt=\"🎧\" class=\"wp-smiley\" /></p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"h-transcript\">Transcript</h2>\n\n\n\n<p>Michelle Frechette 00:00:02&nbsp; We&#8217;re live. We&#8217;re live here on the Post Status Happiness Hour. Okay. First questions first. What&#8217;s on your head?</p>\n\n\n\n<p>Roger Williams 00:00:11&nbsp; Oh.</p>\n\n\n\n<p>Michelle Frechette 00:00:12&nbsp; I see, I see rainbows.</p>\n\n\n\n<p>Roger Williams 00:00:14&nbsp; Yeah. So, I was just at a conference last week, and there were a lot of podcasters there, and they told me to stop using Bluetooth headphones when I&#8217;m podcasting. and so. So I switched back to my old school wired in headphones, and all I&#8217;ve got are these really old sennheiser&#8217;s that I had to tape with, rainbow duct tape years ago.</p>\n\n\n\n<p>Michelle Frechette 00:00:39&nbsp; It looks like you have a pretty little bow in your hair.</p>\n\n\n\n<p>Roger Williams 00:00:43&nbsp; Perfect, perfect. That&#8217;s what that&#8217;s that&#8217;s what I&#8217;m hoping. That&#8217;s what I&#8217;m going for.&nbsp;</p>\n\n\n\n<p>Michelle Frechette 00:00:47&nbsp; I mean, but you know what, Roger? On you it works.</p>\n\n\n\n<p>Roger Williams 00:00:51&nbsp; Well, thank you, I appreciate that. Thank you so much.</p>\n\n\n\n<p>Michelle Frechette 00:00:54&nbsp; And thanks for joining me today on the Happiness Hour. I it&#8217;s it&#8217;s always a pleasure to talk to you for multiple reasons, chief, of course, is that you&#8217;re a wonderful person to talk to. But also, I get to see those pictures of your dog in the background and like, who wouldn&#8217;t love those pictures? The dogs, I think one, two dogs, right? Yeah.</p>\n\n\n\n<p>Roger Williams 00:01:13&nbsp; Two dogs. Yeah. So, Daisy. Well, Daisy over here and then Enzo&#8217;s over here.</p>\n\n\n\n<p>Michelle Frechette 00:01:17&nbsp; Yeah, yeah. Just adorable. Adorable. I would love to claim all of the wildlife as my own and my pictures, but alas, they do not live with me.</p>\n\n\n\n<p>Roger Williams 00:01:27&nbsp; Well, that&#8217;s that&#8217;s a lot cheaper. You don&#8217;t have to maintain as much.</p>\n\n\n\n<p>Michelle Frechette 00:01:29&nbsp; True, true. I do have a cat that lives behind my monitor because she has a little bed back there. She likes it back there because I can&#8217;t reach her and she can stay out of it. Like I can&#8217;t make her accept my hugs and kisses, basically. But she comes up and stretches every once in a while and, you know, let&#8217;s me pet her for a second. But anyway.</p>\n\n\n\n<p>Roger Williams 00:01:48&nbsp; So she represents cats very well.</p>\n\n\n\n<p>Michelle Frechette 00:01:50&nbsp; Yeah she does. She&#8217;s got it down pat. She realizes I&#8217;m the staff. I&#8217;m not the owner. So it&#8217;s all good.&nbsp;</p>\n\n\n\n<p>Roger Williams: Nice.&nbsp;</p>\n\n\n\n<p>Michelle Frechette: So first let me say welcome not only to the show, but Kinsta we got everything in the works right now. Any moment we should be able to. I&#8217;m going to officially announce the soft launch of the sponsorship of Post Status. So welcome. As a sponsor, we created our own little sponsorship channel with you all today, and I&#8217;m open for those conversations. It&#8217;s really great.</p>\n\n\n\n<p>Roger Williams 00:02:21&nbsp; I mean once there&#8217;s a sponsor channel in Slack that makes it official, right?</p>\n\n\n\n<p>Michelle Frechette 00:02:25&nbsp; It does, it does. It&#8217;s just the the just. And we signed the contract. It&#8217;s just that little payment thing. And I know that you guys are good for it. So we&#8217;re gonna announce it anyway. So so welcome.</p>\n\n\n\n<p>Roger Williams 00:02:36&nbsp; Absolutely. Thank you.&nbsp; Yeah. Excited to be part of the community and and help. you know, I know it&#8217;s $50 a year now. Like, what, a smoking deal.&nbsp;</p>\n\n\n\n<p>Michelle Frechette: Yeah, right.</p>\n\n\n\n<p>Roger Williams 00:02:47&nbsp; I am encouraging everybody to join. I actually just had a great conversation with Joost, and we talked about, you know, his kind of goal and mission with, you know, making Post Status into a nonprofit and really making it that community that can have all of the conversations, you know, and have the spicy conversations, right. And, and still manage to be a group of people that get along. And so that&#8217;s really encouraging.</p>\n\n\n\n<p>Michelle Frechette 00:03:17&nbsp; And we do fun stuff, too. I don&#8217;t know if you saw it, but we started a new channel today called The Music Channel.&nbsp;</p>\n\n\n\n<p>Roger Williams: Okay.&nbsp;</p>\n\n\n\n<p>Michelle Frechette: And I got an official like, I paid for an official Spotify account today called Post Status, and I have two playlists in there that are open to collaboration amongst our community. So if you&#8217;re in Post Status Slack and you go to the music channel, you will see you can add to those playlists. One is for folks who like mellow music when they work, and the other is for people who like upbeat music when they work. So you can just add to that playlist or building playlists two playlists together as a community for for fun, right? Because you can do that. We can do those fun things there. And I really enjoy that too. So it&#8217;s pretty cool stuff.</p>\n\n\n\n<p>Roger Williams 00:04:04&nbsp; That&#8217;s really awesome. I love the initiative there. It&#8217;s always interesting to hear what other people listen to. When their getting work done.&nbsp;</p>\n\n\n\n<p>Michelle Frechette 00:04:13&nbsp; Yeah. Can I tell you my biggest fear was that because I had to seed it with something, right. So I put like two songs in each one and I thought, I&#8217;m going to be judged so hard by these four songs.</p>\n\n\n\n<p>Roger Williams 00:04:24&nbsp; Okay. What were the songs?</p>\n\n\n\n<p>Speaker 3 00:04:26&nbsp; Oh, now I gotta go back and look.</p>\n\n\n\n<p>Michelle Frechette 00:04:27&nbsp; Okay, hold on a second. I put in You Don&#8217;t Know Me, which is a Ray Charles&nbsp; &amp; Diana Krall song. This is the mellow one. Yeah. which I think nobody but I&#8217;m a huge Josh Groban fan. So the other one was When You Say You Love Me by Josh Groban.&nbsp;</p>\n\n\n\n<p>Roger Williams: Okay.</p>\n\n\n\n<p>Michelle Frechette 00:04:42&nbsp; And then the upbeat songs. I actually did a little research. See, I listened to 70s music all the time, like 70s and 80s. That&#8217;s what I was doing. So I did a little research. I&#8217;m like, what are upbeat songs that people like to listen to? And even though Coldplay gets a bad rap sometimes. Viva la Vida was the number one song on multiple lists. So that and On Top of the World by Imagine Dragons. Were the four that I seeded. Two each, you know two each into those things. And I thought nobody so far has said, Michelle, your taste in music is awful. So we&#8217;re gonna let it ride. We&#8217;re gonna let it ride. If I need to, I can always delete them.</p>\n\n\n\n<p>Roger Williams 00:05:16&nbsp; I feel like you went with some pretty safe choices there.</p>\n\n\n\n<p>Michelle Frechette 00:05:19&nbsp; I mean, I tried.</p>\n\n\n\n<p>Roger Williams 00:05:20&nbsp; Good songs, good bands, so. And. And now it&#8217;s up to people to, proliferate the lists with their ideas. And I&#8217;m looking forward to see what people start sharing.</p>\n\n\n\n<p>Michelle Frechette 00:05:33&nbsp; Yeah. Well, on the upbeat songs, I will say Corey Maass went to work on it because we got we&#8217;re up to 18 songs on that playlist and we have five on the other playlist. So yeah. So if you are not a member of Post Status and you want to be, it&#8217;s only $50 a year, you can influence these playlists. Us. I mean, I&#8217;m going to start listening to him tomorrow and see, you know, how much work I get done. We&#8217;ll see.</p>\n\n\n\n<p>Roger Williams 00:05:54&nbsp; I&#8217;ll tell you what. I feel like we&#8217;re in a telethon type situation.</p>\n\n\n\n<p>Michelle Frechette 00:05:57&nbsp; I know right?</p>\n\n\n\n<p>Roger Williams 00:06:00&nbsp; You&#8217;re standing by to take your call. Let&#8217;s let&#8217;s see what you let&#8217;s get joining up here, people.</p>\n\n\n\n<p>Michelle Frechette 00:06:05&nbsp; Oh, my goodness. I&#8217;m old enough to have grown up on the Jerry Lewis telethons where he&#8217;s like, let&#8217;s see that tote board. Right. As the numbers flip over and like, the old alarm clocks did. It was so.</p>\n\n\n\n<p>Roger Williams 00:06:16&nbsp; Funny. Absolutely. No, I used to remember they would always come on, like, PBS and stuff when I was one to watch the new Star Trek series or something. And I&#8217;m like, you guys are killing me. I&#8217;ve got no money. I&#8217;m just a kid.</p>\n\n\n\n<p>Michelle Frechette 00:06:28&nbsp; Yeah, and all of the people they would bring on were like the old Love Boat type people. Like, it&#8217;s like, I don&#8217;t want to see Charo. I know she does good flamenco. Show me somebody I care about. Like. Yeah. But, you know, I mean, it was what it was. Donald O&#8217;Connor dancing at 78 years old. No, I don&#8217;t need to see that. But anyway. James says hello to both of us. Hey, James. Good to have you here.</p>\n\n\n\n<p>Roger Williams 00:06:53&nbsp; I haven’t seen James in a while.</p>\n\n\n\n<p>Michelle Frechette 00:06:55&nbsp; He&#8217;s a pretty awesome dude.</p>\n\n\n\n<p>Roger Williams 00:06:56&nbsp; Yeah.</p>\n\n\n\n<p>Michelle Frechette 00:06:57&nbsp; He really is. So tell us a little bit about who you are and what you do at Kinsta.</p>\n\n\n\n<p>Roger Williams 00:07:03&nbsp; Oh, boy. Okay, so, so at Kinsta. I&#8217;ll just start there. I recently actually got, kind of a title change, so now I was Community Manager. Now I&#8217;m Partnerships and Community Manager for North America. And so what does that mean? So I get to go to a lot of events, and kind of try and engage the community, get feedback as far as, hey, you know, on the hosting product, get feedback about how what people are thinking about WordPress in general. And then I take that information back to the home base and share it with the powers that be and my coworkers to help improve the product and then also see how we can help. the WordPress project overall. And so one initiative that we&#8217;ve got going relatively recently is we&#8217;ve started sponsoring contributors to WordPress. And so that has been just a lot of fun, reaching out to different contributors and seeing, you know, how we can help them, help their work, and really improve WordPress. Because if WordPress doesn&#8217;t keep improving, there&#8217;s not a whole lot for Kinsta to do. So that&#8217;s kind of a new initiative. Other things. So with the partnership side, I talk with different companies that are adjacent to Kinsta.</p>\n\n\n\n<p>Roger Williams 00:08:30&nbsp; So agencies are a big one. We have a lot of agency customers. And we also have a lot of customers that use agencies. And so it&#8217;s very important that we have a dialogue with agencies as far as what works for them. What we could improve with the product and how we can help them grow their business as well.. And then also with like plugin makers and theme designers and, you know, the whole ecosystem of WordPress companies kind of works in there. And then also just going one step further is open source in general. So at Kinsta one thing that we&#8217;ve utilized for many years is Linux containers for each of the sites, isolates them, gives them a lot of resources. And so we help support the maintainer of the Linux container project, which is changing into Incus and getting a little in the weeds here. But so that&#8217;s really exciting too, is being able to reach out to the people who make the tools that allow us to make WordPress and allow us to host websites and help them get their work. Continued and supported. Jeez. And, you know, it&#8217;s a pretty nebulous position. So there&#8217;s there&#8217;s a lot of things going on. I do a lot of videos. I make videos on LinkedIn where I interview people in the WordPress ecosystem as well as.</p>\n\n\n\n<p>Michelle Frechette 00:09:57&nbsp; Those are compelling, by the way, because you keep them concise, right? They&#8217;re not they don&#8217;t go on for hours. They also are fun. You have topics that you put right there and and they just show up in your newsfeed. So you&#8217;re like, oh, what&#8217;s this all about? Those are awesome. I mean, even if I&#8217;m speaking from having been on the other side of your microphone.</p>\n\n\n\n<p>Roger Williams 00:10:16&nbsp; Well, thank you so much. I appreciate the feedback and the encouragement. It it started as just a fun way to get to know presenters before WordCamp US last year. And then I went to WordCamp US and everybody, not everybody, but a lot of people wanted to ask me if they could be on my podcast. And I was like, well, first of all, it&#8217;s not really technically a podcast. But, Yeah. No, I wanted to interview more people, and I like, you know, LinkedIn imposes the 15 minute time rule that I have, which is kind of nice because it allows me. I&#8217;m only interrupting somebody&#8217;s day for 15 minutes, to do the interview. And then I&#8217;m only interrupting your day for 15 minutes if you want to watch the interview. So I feel like it&#8217;s very courteous of me in some ways.</p>\n\n\n\n<p>Michelle Frechette 00:11:06&nbsp; Yeah, absolutely.</p>\n\n\n\n<p>Roger Williams 00:11:07&nbsp; But. And then there&#8217;s just a lot of fun. It&#8217;s an opportunity to get to know people in the industry, people that I maybe have known for a while and learn more about them and then meet new people and hear their stories and then help share their stories. So, that, like, that was like kind of an afterthought activity. And it&#8217;s really turned into a pretty considerable amount of my job. And, again, I get a lot of encouragement from my bosses to keep doing those.</p>\n\n\n\n<p>Michelle Frechette 00:11:36&nbsp; Yeah. It&#8217;s great, I love it. You&#8217;ve talked to some pretty awesome people. You&#8217;ve talked to a lot of people that I&#8217;ve never heard of or met before, too, which I love because you&#8217;re introducing people to the WordPress community that we want to know because they&#8217;re doing cool stuff. So I love that component of it as well, for sure.</p>\n\n\n\n<p>Roger Williams 00:11:54&nbsp; That&#8217;s great to hear. And I&#8217;d like to say that that is all by design. A lot of it is just because I don&#8217;t know the big names in WordPress, and so.</p>\n\n\n\n<p>Michelle Frechette 00:12:04&nbsp; That&#8217;s okay too.</p>\n\n\n\n<p>Roger Williams 00:12:05&nbsp; I haven&#8217;t connected with them yet. But then also there is has been a little bit of a conscious decision to seek out people who are not getting as much exposure and maybe aren&#8217;t as well known, but who I&#8217;ve met one way or another. And I know that they&#8217;re very interesting people. And I mean, everybody&#8217;s got a story to tell. And I and I think the nice thing about 15 minutes is it makes it easy for people to tell their story and not run out of things to talk about. And so we, can we can put something together that&#8217;s pretty interesting.</p>\n\n\n\n<p>Michelle Frechette 00:12:37&nbsp; Well, I will tell you that you did inspire something I&#8217;ve been working on, which is starting, last month. It is April now. Yep. Starting last month. Last month was Women&#8217;s History Month, and so I got it in my head on like the fourth or fifth day of the month. Oh, it&#8217;s women&#8217;s history. We should interview women in WordPress. I thought I would get maybe ten people, right? I have over 50 interviews now that I&#8217;ve recorded.&nbsp;</p>\n\n\n\n<p>Roger Williams: Wow.&nbsp;</p>\n\n\n\n<p>Michelle Frechette: They average about five minutes. Some go as long as 12, some as short as like four. Which I guess is not really an average of five, but there&#8217;s about five minutes. Six maybe. And, they take out the outliers, but then, it&#8217;s been really awesome. And because there&#8217;s so many of them, I&#8217;m continuing it for months and it might just be a regular feature we have. We have a YouTube playlist. Now that&#8217;s these, women&#8217;s interviews within WordPress.&nbsp; And I am so proud to say that we have interviewed somebody on every inhabitable continent of the world. So I&#8217;ve got women from literally everywhere, which is so cool. But it&#8217;s because I saw your shorter, you know, concise interviews that I thought I could do, like Roger does.</p>\n\n\n\n<p>Roger Williams 00:13:44&nbsp; That&#8217;s awesome. I and I, I&#8217;m sure you&#8217;re blowing it out of the water. you&#8217;re way more composed.</p>\n\n\n\n<p>Michelle Frechette 00:13:49&nbsp; I&#8217;m having fun.I don&#8217;t know about that.</p>\n\n\n\n<p>Roger Williams 00:13:53&nbsp; And I you know, I&#8217;m excited to hear that. And I think that, you know, in the age of these two and three and four hour podcasts, I really like seeing the shift back towards the shorter. You know, it&#8217;s the same way with like, streaming media, right? Like my wife and I, we really get excited when there&#8217;s an episode that&#8217;s only 25 minutes long. Right? Because, like, I just I got to go to bed at some point, people. You know.</p>\n\n\n\n<p>Michelle Frechette 00:14:18&nbsp; It&#8217;s it&#8217;s I call it consumable, right? It&#8217;s like you don&#8217;t feel overwhelmed. You could actually consume it on social media as opposed to having to go someplace and download or look longer or pop popcorn first, you know?</p>\n\n\n\n<p>Roger Williams 00:14:31&nbsp; Exactly, Exactly. No. Yeah, yeah. Having these little bite sized nuggets. And, you know, there&#8217;s also the whole concept of, you know, do you need two hours to really say what you&#8217;re trying to say? Can you can you sum it up for me? And and I, you know, one of the approaches that I&#8217;m kind of doing with my show is once I have somebody on and I get to know, like, who they are and how we interact, then, you know, maybe I invite you back and we do a longer show if there&#8217;s something more for us to dig into. So, yeah, there&#8217;s just a lot of variability. I, I really I talked with Matt Medeiros, I think, last fall about my philosophy on doing the show, and there&#8217;s a lot of a salesman&#8217;s mentality to it. So in sales, to be successful at sales, you just have to deal with rejection and no&#8217;s.</p>\n\n\n\n<p>Michelle Frechette 00:15:25&nbsp; Absolutely.</p>\n\n\n\n<p>Roger Williams 00:15:26&nbsp; And so one of the things I learned early in my sales career was to collect 50 no&#8217;s a day. And then I would get to a yes. Right? And and you know, the math sometimes worked and sometimes it didn&#8217;t, depending on what I was selling. Right? But I think with doing episodes, doing a show like this, especially when you&#8217;re starting out and you&#8217;re not sure what you want to talk about or how good your interviewing skills are, then go for numbers like just start. Do a lot of interviews, talk to a lot of people and figure it out as you&#8217;re going. And yeah, just getting the repetitions in and and seeing if you enjoy it too.</p>\n\n\n\n<p>Michelle Frechette 00:16:05&nbsp; Yeah, absolutely. But I do have to say it as a podcast, if you call it a show. So you&#8217;ve, you&#8217;ve officially tipped over to that territory.&nbsp;</p>\n\n\n\n<p>Roger WIlliams: Okay. I thought.&nbsp;</p>\n\n\n\n<p>Michelle Frechette: I don&#8217;t make the rules. I don&#8217;t make the rules. Roger.</p>\n\n\n\n<p>Roger Williams 00:16:19&nbsp; Okay. I thought that in order for it to be a podcast, it had to have an RSS feed.</p>\n\n\n\n<p>Michelle Frechette 00:16:25&nbsp; I don&#8217;t think so. I think it has to be called a show and put out an in regular format somewhere. I make my own decisions here, so maybe I do make the rules, I don&#8217;t know. But,</p>\n\n\n\n<p>Roger Williams 00:16:35&nbsp; You know, in your defense, you know, people are calling these shows on YouTube podcasts now, even though there’s no RSS feeds. So. All right, we&#8217;ll go with it. We&#8217;ll go.</p>\n\n\n\n<p>Michelle Frechette 00:16:43 &nbsp; Okay. Absolutely. So much fun. So if anybody doesn&#8217;t know what Kinsta is, what is Kinsta?</p>\n\n\n\n<p>Roger Williams 00:16:51&nbsp; Oh wow. Okay. So if you don&#8217;t know what Kinsta is then what what&#8217;s going on?</p>\n\n\n\n<p>Michelle Frechette:&nbsp; I know right.&nbsp;</p>\n\n\n\n<p>Roger WIlliams: Seriously, so Kinsta we&#8217;re a managed hosting company and we focus on WordPress. And then we&#8217;ve actually got a new product for application hosting and database hosting called Sevalla. And if people are interested, they can look that up. But I&#8217;ll really talk more about the WordPress side. That&#8217;s the majority of our business. We&#8217;ve been in business for over 12 years now. We&#8217;ve got hundreds of thousands of sites under management that were, helping people deliver to the world. And, you know, to back up for a second, what do I mean by managed hosting? So with managed hosting, we&#8217;re handling all of the infrastructure outside of WordPress. So the nginx server, the MySQL database, Linux. And then we&#8217;re also integrating with Cloudflare Enterprise. So every site on Kinsta has Cloudflare Enterprise protecting it from DDoS attacks. But also we&#8217;re utilizing their CDN and edge caching and image optimization services to really help speed up your site and make sure that anybody in the world that wants to view it can see it really quickly.</p>\n\n\n\n<p>Michelle Frechette 00:18:08&nbsp; Excellent, excellent. And you have an affiliate program, I noticed I&#8217;m actually going to put this banner up on the screen here. I&#8217;ve been digging into, it&#8217;s like I know what I&#8217;m doing sometimes, I don&#8217;t know, I surprise myself. I&#8217;ve been looking into doing more affiliate sales. Right? And I&#8217;ve signed up. I think I signed up for Kinsta. I did a whole bunch in one day. As you know, I was laid off from my last job, and I was like, where can I find some passive income? So I&#8217;m building a website, I&#8217;m doing reviews, I&#8217;m doing all the things.</p>\n\n\n\n<p>Roger Williams: Excellent.</p>\n\n\n\n<p>Michelle Frechette: And so, yeah. So here&#8217;s a way to do that. What does your affiliate program look like for people who might want to, you know, get involved with that?</p>\n\n\n\n<p>Roger Williams 00:18:43&nbsp; Yeah, absolutely. So, you know, and I at at risk of making this sound like a whole sales pitch all, all day. I apologize to everybody. You&#8217;re asking the questions.</p>\n\n\n\n<p>Michelle Frechette 00:18:53 I am of course, we didn&#8217;t talk about this and we didn&#8217;t talk about this beforehand either. These are just my curiosity.</p>\n\n\n\n<p>Roger Williams 00:18:59&nbsp; No, I&#8217;m I&#8217;m enjoying it. So, our affiliate program is quite generous. You just go to the link that you see on the screen. kinsta.com/affiliates get signed up and we have our amazing affiliate team will review your application. And, once you&#8217;re signed up, you it&#8217;s pretty standard from an affiliate program. You get a link that has a specific code in it. So when somebody clicks that link and then signs up, you get credit for the sale. So that&#8217;s pretty standard affiliate program stuff. The way that you make money is pretty straightforward. We pay you on signup so it&#8217;s anywhere from $50 to $500 depending on which plan somebody signs up for. And then you get 10% of whatever is billed for each month for the life of that account.</p>\n\n\n\n<p>Michelle Frechette 00:19:52&nbsp; There you go.</p>\n\n\n\n<p>Roger Williams 00:19:53&nbsp; So our cheapest plan is $35 a month.</p>\n\n\n\n<p>Michelle Frechette 00:19:57&nbsp; Least expensive marketing. Least expensive.</p>\n\n\n\n<p>Roger Williams 00:20:01&nbsp; Sorry. Thank you. Thank you very much.</p>\n\n\n\n<p>Michelle Frechette 00:20:03&nbsp; That&#8217;s what I&#8217;m here for.</p>\n\n\n\n<p>Roger Williams 00:20:04&nbsp; Our least expensive plan is $35 a month. So 10% of that&#8217;s $3.50 a month for the life of the account. And, you know, we don&#8217;t put any limits on when that&#8217;s going to end. We just keep paying you, as you know, you brought the business to us. So we&#8217;re going to pay you for that. So and thank you for it. You know, other than that, it&#8217;s it&#8217;s really straightforward.</p>\n\n\n\n<p>Roger Williams 00:20:26&nbsp; We have, like I mentioned, a dedicated, an affiliate management team. So if you know, as you&#8217;re an affiliate, there&#8217;s ever any concerns or questions about a sign up, all you have to do is reach out and we&#8217;ll take a look at it and work with you. The, you know, one key time frame to put in there is about a two week limit. So if somebody signs up and they should have gotten credited to you, you need to reach out to us, you know, within two weeks, which isn&#8217;t an unreasonable amount of time to ask you to reach out.</p>\n\n\n\n<p>Michelle Frechette 00:20:58&nbsp; Not at all.</p>\n\n\n\n<p>Roger Williams 00:20:59&nbsp; And and we&#8217;ll work with you to figure all that out.</p>\n\n\n\n<p>Michelle Frechette 00:21:02&nbsp; yeah.</p>\n\n\n\n<p>Roger Williams 00:21:03&nbsp; And then we&#8217;ve built, the, the affiliate dashboard in-house. So it&#8217;s very snappy and.&nbsp;</p>\n\n\n\n<p>Michelle Frechette 00:21:08&nbsp; Nice.&nbsp;</p>\n\n\n\n<p>Roger Williams 00:21:09 You know, and if you have feedback on, you know, in the improvements or suggestions, you know, our developers can take a look at those and choose to implement them. If, if it sounds like a good plan.</p>\n\n\n\n<p>Michelle Frechette 00:21:20&nbsp; Nice. I have pulled up on the screen, as I&#8217;m sure you saw. Not only do you have the affiliate, you know, information on the affiliate page, but you have 17 pages that talk about doing affiliate sales and doing affiliate marketing. So it looks like a very well supported plan as well. 198 results when I just search affiliate on your blog.</p>\n\n\n\n<p>Roger Williams 00:21:38&nbsp; So yeah. So backing up a second, so who is Kinsta big component of who Kinsta is, is our blog. The way that I first learned about Kinsta was when I was working for one of our competitors, and I was in tech support and in tech support. You get these issues that you haven&#8217;t seen before a lot. Right? And so you Google, hey, here&#8217;s the error code that just got thrown at me. And you start looking through stuff. And a lot of times you go to StackOverflow and these types of sites. Now you go to AI, but back about like 6 or 7 years ago Any time I would google a WordPress issue, this one blog would keep coming up with these amazing blog posts that would not only, like, explain the issue, but walk you through how to resolve it, usually in multiple different ways. And that blog was Kinsta.com.</p>\n\n\n\n<p>Speaker 5 00:22:37&nbsp; Nice.</p>\n\n\n\n<p>Roger Williams 00:22:37&nbsp; And. And so that got me. I mean again and again the same blog kept coming up with different answers for all these issues. And so eventually I was like, well, I should just go work for these guys. They seem to have it all figured out. And so I applied and I started off in the migrations team, worked my way to client experience, then to sales, and then we created this community position. But yeah, it really is amazing how much we work to give information back to, you know, the community, to the industry as a whole. Yes. It drives a lot of sales, but I mean, there&#8217;s still a ton of people I know that get value out of the blog who are not our customers. Not yet. Not yet. But your affiliate program is going to work on that for us.</p>\n\n\n\n<p>Michelle Frechette 00:23:29&nbsp; That&#8217;s right, that&#8217;s right. Absolutely. Now, I believe this is fairly new announcement as well.</p>\n\n\n\n<p>Roger Williams 00:23:36&nbsp; Yes.</p>\n\n\n\n<p>Michelle Frechette 00:23:37&nbsp; Kinsta is now a global WordCamp sponsor.</p>\n\n\n\n<p>Roger Williams 00:23:40&nbsp; Yes. So this is pretty exciting. This just came out yesterday, April 1st.</p>\n\n\n\n<p>Michelle Frechette 00:23:45&nbsp; And it was not a joke.</p>\n\n\n\n<p>Roger Williams 00:23:47&nbsp; No. And it was not a joke. It was funny. We were talking about how the you know, it started April 1st, and all these reasons. And I was like, oh, do we want to hold off on doing a press release on April 1st? Probably. So it does get dismissed, but no, just really excited to again find a way to support the community through this. For those that aren&#8217;t aware, the the global WordCamp sponsors, what that means is we&#8217;re now a gold level sponsor for all of the local WordCamps around the globe. Everything except for the flagship three. And, and so that helps immediately get funding to all of those WordCamps and helps them put on those shows. It&#8217;s one less phone call that they need to make to get a sponsor signed up, and all the paperwork and rigmarole that goes through that.</p>\n\n\n\n<p>Roger Williams 00:24:40&nbsp; So now carte blanche, we&#8217;re just all Word Camps that aren&#8217;t flagships we&#8217;re a sponsor of and so help helping get those Word Camps to happen. And then we&#8217;re also helping the Meetups happen. So there&#8217;s I don&#8217;t know the exact number at this point. It&#8217;s it&#8217;s in the thousands, if not more of Meetups around the globe. And I think these are where the the real magic happens with WordPress, right? I help run a small Meetup here in Durango once a month. We have like anywhere from 4 to 9 people show up. But every time we have great conversations and we talk about WordPress, we talk about digital marketing, we talk about how our lives are going, where we&#8217;re going to go on vacation, and we really connect. And so Meetups are just a really exciting way to really get that super local connection happening. And as a global sponsor, we help with the fees responsible for Meetup.com, which love it or hate it. you know, I&#8217;m not going to tell you my judgment right now, but it is a useful site for organizing things.</p>\n\n\n\n<p>Roger Williams 00:25:51&nbsp; As an organizer, it makes it really easy for me to quickly get stuff posted up and then get people to come to the event. And then there&#8217;s another aspect of the Meetups that a little bit less known, apparently, because I keep on having people asking if we can help them with their venue costs. And I always ask, hey, did you reach out to WordPress Foundation yet? Because as global sponsors, we also help with the funding to help get some venue costs covered. and so that&#8217;s just really exciting to help promote both of those programs, WordCamps and Meetups.</p>\n\n\n\n<p>Michelle Frechette 00:26:35&nbsp; Absolutely. That&#8217;s awesome. and it&#8217;s really nice that there are organizations like Kinsta that, you know, are so all in on the WordPress community that you&#8217;re sponsoring, contributors. You&#8217;re sponsoring the community at large as well. I, I, I&#8217;m signing the paperwork today as one of your most recent contributors that you&#8217;re sponsoring. And I want to thank you for sponsoring my time in the WordPress community. So, yeah, I had a little snafu with signing the paperwork, as we talked about before, but it will be signed as soon as we&#8217;re done here today. So it will be official very shortly, and I&#8217;ll be able to post it on social and say how wonderful it is to have organizations like Kinsta sponsoring the work that I do in WordPress. So thank you for that.</p>\n\n\n\n<p>Roger Williams 00:27:21&nbsp; Well, you&#8217;re welcome. And, you know, and we&#8217;re proud to sponsor you and the other contributors because we know it&#8217;s an all volunteer project. Right? And, and it&#8217;s open source and it&#8217;s this is how open source works is the companies that are benefiting off of the projects. You know, you don&#8217;t have to write it&#8217;s open source software. So there&#8217;s no obligation to support the software. But I mean, it just makes sense that you you do realize, hey, our income is based off of these volunteer led projects. We really should be reaching out and helping to contribute in some way. And the thing I really enjoy about sponsoring contributors like yourselves Is its immediate impact, right? You&#8217;re not it. We could turn to a bunch of employees at Kinsta who have never used WordPress, let alone worked to make WordPress Slack and tried to contribute.</p>\n\n\n\n<p>Roger Williams 00:28:24&nbsp; And you know that that could be very helpful for those individuals to learn more about WordPress and how to contribute to it. But as far as the project&#8217;s impact, it&#8217;s just not going to be as impactful as sponsoring people who have already been contributing, who know the ins and outs of the project, and then who can even, you know, in a force multiplier effect, help that many more people become part of the project. You know, we help a lot of people. We sponsor a lot of people that that do a lot of documentation work. And, you know, as somebody who kind of ran the documentation program at Kinsta for a little while. I mean, it&#8217;s it&#8217;s the most important work and it&#8217;s the most thankless work that can happen, right?</p>\n\n\n\n<p>Michelle Frechette 00:29:10&nbsp; And it can be tedious. Right. So to have some incentive to have some to nobody does it because they&#8217;re expecting anything back. But to have a company like Kinsta to say, I see you and I want to support that as well. It&#8217;s just a wonderful thing.</p>\n\n\n\n<p>Roger Williams 00:29:23&nbsp; Agreed, agreed. 100%. And I mean, it is tedious, right? I mean, because you&#8217;ve spent all this time putting some sort of documentation together and you miss, like, one step and that&#8217;s the first thing somebody points out to you. And so like, there&#8217;s a gut punch there. But but it&#8217;s important work. Right? And documentation is one of those things that it gets taken for granted. Right? When it&#8217;s there. You don&#8217;t think anything of the fact that somebody had to put a lot of work into creating this, but the fact that it&#8217;s there is literally allowing you to use some aspect of the tool. And so it&#8217;s so important. So important.</p>\n\n\n\n<p>Michelle Frechette 00:30:02&nbsp; Right. We&#8217;re coming up on a new release soon. We are less than two weeks away from 6.8 being released. We&#8217;re in release candidate two right now, one more week after this to work on it. And then it&#8217;s like out for for being updated. And and we do know that people find more bugs once it&#8217;s been released, but we&#8217;re in that bug squashing right now. So, and the work and, and that&#8217;s part of the work I&#8217;m doing is on that release squad. And so our others. So that&#8217;s the work that you&#8217;re supporting, not just the work that I do in the community, not just the work that I do with the photo directory, for example. But, but every release as well. So, yeah. Thank you. I really appreciate it.</p>\n\n\n\n<p>Roger Williams 00:30:40&nbsp; You&#8217;re welcome. And thank you again for that work that you&#8217;re doing there, because it is really critical. And again, it&#8217;s like the documentation, WordPress can get taken for granted so easily. Because it&#8217;s something that&#8217;s just there. Right. It&#8217;s been there for we&#8217;re at like 22 years now. You just go to WordPress.org and you download the software and you can get to work on it. But there&#8217;s a lot of time and effort and people involved with making that happen. As far as 6.8&nbsp; is going. How are you feeling about it? I know that there&#8217;s been like some, you know, Matt has put out some ideas that maybe we&#8217;re going to do one release a year or something. Do you think that there&#8217;s enough people helping with testing out and and checking for bugs at this point?</p>\n\n\n\n<p>Michelle Frechette 00:31:29&nbsp; I mean, there are right there. There&#8217;s always people who are in there testing. We have, you know, quite a few people who are doing that kind of thing. You can always use more because we can&#8217;t test every scenario. We can&#8217;t test it against, you know, you we don&#8217;t know how it interacts with every single plugin in the world because we can&#8217;t test it on all those things. So the more people test it with those things now never, ever, ever updated on your live site please. I mean, take our word for it. That is not the right way to do it, but open it in a test environment. Use the playground to do that. Use the there&#8217;s a plugin you can use for testing. It&#8217;s all in the guidelines on the 6.8. If you go to WordPress.org /news you will see it there. the most recent release, candidate two, has all of the information to do that.</p>\n\n\n\n<p>Michelle Frechette 00:32:12&nbsp; so the more people I mean, I&#8217;m never going to say we have enough testers, never. So get out there and test it. If you haven&#8217;t tested it yet, we want to hear your feedback. Good, bad, ugly. We want to know because we want to make sure that what gets released on April 15th, it just happens to coincide with Tax day here in the US. What gets released on April 15th? We want it to be the best it can possibly be. And although you can never foresee everything, the more that we can take care of prior to that day, the better. Everybody will have it on release day, so.</p>\n\n\n\n<p>Roger Williams 00:32:44&nbsp; No. Absolutely. And I, you know, I know one of the things that encourages me Kinsta we include staging environments with all of our sites. So people like, go ahead, create a staging environment.</p>\n\n\n\n<p>Michelle Frechette 00:32:56&nbsp; Test it out.</p>\n\n\n\n<p>Roger Williams 00:32:57&nbsp; Install the beta plugin and just like. Look at the site like and test it out. Are your forms working? If you have a calendar or something like that? Test everything that&#8217;s really critical for your business and make sure that it works. You know, make sure that when you fill out a form, you get the email because.</p>\n\n\n\n<p>Michelle Frechette 00:33:17&nbsp; Test it against your themes, all of those things. Absolutely. Yeah. Yeah, definitely. And so yeah. So that&#8217;s the work that we&#8217;re doing right now. It&#8217;s it&#8217;s always something. Right? We just onboarded new a whole bunch of new photo moderators. And the queue has been sitting at zero at the end of every day. We have so many people moderating photos. We have over 20,000 photos now in the photo directory. And yeah, it used to be sometimes I would log in and be like, oh, there&#8217;s 300 to moderate. Well, let me see how many I can do in 15 or 20 minutes. Now I log in. I&#8217;m like the only ones I have to look at are the ones that are held in moderate or held as flagged. Because other people in the United States or outside of the United States can&#8217;t see those. It&#8217;s something to do with laws and things. And so usually it&#8217;s a picture of an animal. Not always. sometimes it&#8217;s things that cannot be released. Of course. for any number of reasons. But, I would say and all of the photos I have not allowed through out of the hundreds that get flagged only two. So it it&#8217;s AI driven. What gets put there versus other and AI is very conservative and so but other than that you know we just have people just getting in there and it&#8217;s all volunteer, as you said, moderating the photos under the photo directory. All of that is voluntary. So it&#8217;s a great program. Open source is great as long as people are contributing to it. And companies like Kinsta to make that a lot easier to do. So thanks for all that you do in the community. So you&#8217;re sponsoring Post Status, you&#8217;re sponsoring, globally. You&#8217;re sponsoring contributors. Goodness gracious. That&#8217;s awesome. I&#8217;d love to hear that.</p>\n\n\n\n<p>Roger Williams 00:34:56&nbsp; Oh, well. Yeah. No, it&#8217;s it&#8217;s really exciting. It&#8217;s something that a lot of us have been pushing for, for, you know, some time and then, Yeah. No, we we realized, hey, this is a good decision to make. not just for Kinsta, but for the community. So, yeah, it&#8217;s we&#8217;re happy to help.</p>\n\n\n\n<p>Michelle Frechette 00:35:14&nbsp; So any questions? I know we&#8217;ve had a couple of comments, but if you have questions, we have just a few more minutes before I let Roger go back to petting his dogs and doing his work. I will say, WordCamp Canada says “Kinsta docs and tutorials are among the best. Super useful.” I don&#8217;t know who is logged in today as WordCamp Canada, but those are lovely words that they&#8217;ve had to share with you, which is awesome.</p>\n\n\n\n<p>Roger Williams 00:35:37&nbsp; Know that. Thank you. And I&#8217;ll make sure that that gets passed on to the team. We&#8217;ve got a team of we&#8217;ve got multiple full time writers on staff. Then we also do, contract people to help with writing as well. But, It&#8217;s a very full time project for us. We have in Slack. We have a content feedback channel that&#8217;s internal. But any time, like a customer lets us know and support. Hey, you know, this documentation or something is. Seems a little off. All of us at Kinsta can go into the content feedback channel and share that feedback. You know, and do our best to kind of try and help make suggestions that are helpful for the writers. But the turnaround on those is really quick, and we want to make sure that the documentation is is up to date and useful.</p>\n\n\n\n<p>Michelle Frechette 00:36:29&nbsp; Sounds like a great team.&nbsp;</p>\n\n\n\n<p>Roger Williams: Oh, absolutely.&nbsp;</p>\n\n\n\n<p>Michelle Frechette: My my last comment is that I think only the best podcasters also have lava lamps in the background, because I have one and I see yours.</p>\n\n\n\n<p>Roger Williams 00:36:42&nbsp; Yes. No. The lava lamp was an absolutely critical piece for the set. It&#8217;s just fun to have. It always reminds me, though, I think it was Cloudflare. Who, I don&#8217;t know if it was an April Fool&#8217;s joke post, but I remember years ago they had released something that the way that they do their random number generator is they have a series of lava lamps, and they use that for actually they scan those and then that&#8217;s how they come up with their random number generation.</p>\n\n\n\n<p>Michelle Frechette&nbsp; 00:37:12&nbsp; That&#8217;s funny. Claudia says “that the lava lamp is also a critical piece of equipment in her office” So. Absolutely. I don&#8217;t know if you can tell, but right in front of my lava lamp is a chicken lamp.</p>\n\n\n\n<p>Roger Williams 00:37:23&nbsp; Okay. Just barely.&nbsp;</p>\n\n\n\n<p>Michelle Frechette 00:37:24&nbsp; And the egg behind, like the egg coming out of the chicken. Is the light bulb.</p>\n\n\n\n<p>Roger Williams 00:37:31&nbsp; Perfect, perfect.</p>\n\n\n\n<p>Michelle Frechette 00:37:35&nbsp; Yeah. There&#8217;s always something you can focus on in my background to talk about, that&#8217;s for sure. Anyway, anything else, go ahead.&nbsp;</p>\n\n\n\n<p>Roger Williams 00:37:41&nbsp; You have a great diversity background there. I&#8217;m just I&#8217;m really happy that it&#8217;s not a bookshelf of books, that that you&#8217;re trying to project that you read.</p>\n\n\n\n<p>Michelle Frechette 00:37:52&nbsp; I never read. No, of course I do. and I did, once upon a time play the guitar. But, those belong to my father. And I joke that when I put them on the wall, I suddenly became a developer because every developer has guitars in their background.</p>\n\n\n\n<p>Roger Williams 00:38:10&nbsp; Okay. All right. I didn&#8217;t know about that theory, but it does. It does seem.</p>\n\n\n\n<p>Michelle Frechette 00:38:14&nbsp; Now you&#8217;ll now you&#8217;ll notice. Now you&#8217;ll notice. I&#8217;ve we&#8217;ve also been asked here “how&#8217;s your Durango WordPress meetup going” since you are an organizer out there.</p>\n\n\n\n<p>Roger Williams 00:38:23&nbsp; Yeah. Thank you for asking. You know, it&#8217;s going well. I think we&#8217;re now I think we&#8217;ve done eight, in a row, so consecutively, I almost dropped the ball, on this month on April&#8217;s, but, we have it. It&#8217;s happening on Friday. It&#8217;s going good. You know, organizing events for any event organizers out there, is challenging, And I feel you and you know, the Meetups are a much more simplified, simplified version of an event than like a WordCamp or something. But it does still take work, right? You need to find the venue. You need to get people to show up. You need to try and have something worthwhile to talk about while you&#8217;re there. And so, and so it&#8217;s a lot of fun. It&#8217;s also a challenge. And, I think one of the best pieces of advice somebody told me was to get co-organizers as soon as possible.</p>\n\n\n\n<p>Michelle Frechette00:39:19&nbsp; Yes.</p>\n\n\n\n<p>Roger Williams 00:39:20&nbsp; And I say it&#8217;s the best advice. I still don&#8217;t know if it is because I haven&#8217;t gotten any co-organizers yet, but I feel like, wow, that would probably help a lot.</p>\n\n\n\n<p>Michelle Frechette 00:39:30&nbsp; So it does, I promise.</p>\n\n\n\n<p>Roger Williams 00:39:31&nbsp; Okay. All right.</p>\n\n\n\n<p>Michelle Frechette 00:39:32&nbsp; Absolutely.</p>\n\n\n\n<p>Roger Williams 00:39:33&nbsp; If anybody has any tips or tricks or advice, please feel free to reach out. Kinsta buys the lunch. So that&#8217;s a pretty cool little perk for coming. And we&#8217;ve got a really cool venue. It&#8217;s EsoTerra Cidery. They have a taproom in downtown Durango, and it&#8217;s a really wonderful venue. Lots of nice seats. They have a nice little lunch menu and they give us the space for free to use. They&#8217;re very happy to host us. So big shout out to Eso Terra. Thank you so much. They make really good cider. if that&#8217;s your jam. But no alcoholic drinks purchased for people during the lunch, by the way.</p>\n\n\n\n<p>Michelle Frechette 00:40:18&nbsp; Makes sense.</p>\n\n\n\n<p>Roger Williams 00:40:19&nbsp; But, yeah, I think, you know, one of the challenges is coming up with topics that apply to the group as a whole, right? And so we&#8217;ll have a variety of people, from beginners to advanced WordPress users. How do we come up with topics that attract all of those people and engages all of them?</p>\n\n\n\n<p>Michelle Frechette 00:40:41&nbsp; That is the challenge.</p>\n\n\n\n<p>Roger Williams 00:40:43&nbsp; Yeah. Any advice, any tips you figured out?</p>\n\n\n\n<p>Michelle Frechette 00:40:47 Um,&nbsp; mostly I figured out to just aim for the middle, basically. And the people, you know, the people that are overqualified for that will tend to either just not come. Which is sad, but they tend to contribute to the conversation. And people who have not reached that level are still learning it. So that&#8217;s basically the best advice I could offer. Or to split, you know, and have a couple of discussions, per conversation, you know, per, per event. So.</p>\n\n\n\n<p>Roger Williams 00:41:19&nbsp; Okay, okay. No, I like that. And I&#8217;ve kind of tracked towards that. The other thing I&#8217;ve done is I&#8217;ve, I&#8217;ve brought in some people from outside of WordPress a little bit to talk about like marketing and branding strategy. And really helped to expand the group and the topics a little bit. So it&#8217;s.</p>\n\n\n\n<p>Michelle Frechette 00:41:38&nbsp; I even had somebody come once and talk about business insurance.</p>\n\n\n\n<p>Michelle Frechette 00:41:43&nbsp; Okay. And errors and omissions. Which is a big thing for website developers. So.</p>\n\n\n\n<p>Roger Williams 00:41:48&nbsp; Excellent, excellent. Yeah. No I and I think getting more people from the business community involved is great. Durango and I&#8217;m outside of Durango. I&#8217;m in a little town called Minkus. We&#8217;re very rural. I think Durango&#8217;s got 17,000 people. Minkus got 1200 people. And one thing that still just drives me crazy is how few local businesses have a website. even, like, even a Wix website, they don&#8217;t even have that. They&#8217;ll have a Facebook page. And, and so that it breaks my heart a little bit. You know, I want to at some point be like, hey, I&#8217;ll build your website for you, but I&#8217;m, I&#8217;m kind of not in this stage of building websites right now.</p>\n\n\n\n<p>Michelle Frechette 00:42:29&nbsp; Same.</p>\n\n\n\n<p>Roger Williams 00:42:31&nbsp; Yeah, maybe I&#8217;ll help. Maybe I&#8217;ll help.</p>\n\n\n\n<p>Michelle Frechette 00:42:34&nbsp; Probably. and we do have, what do you call it? Justification? Vindicate. I don&#8217;t the right word. But anyway, “right about the developers having guitars in their walls. Roger could confirm he doesn&#8217;t have any on his office wall but four on another wall.” So there you go. I mean, there&#8217;s just something about it. And it&#8217;s interesting because development and ma and music go hand in hand because of the mathematical equalities to both of those. So it makes sense that somebody who is, you know, mathematically inclined, would be interested in both of those things. Chords are very math, mathematical.</p>\n\n\n\n<p>Roger Williams 00:43:10&nbsp; So absolutely. And maybe this explains why I&#8217;m not a good developer because I do not know how to play any music.</p>\n\n\n\n<p>Michelle Frechette 00:43:17 That&#8217;s okay. You can go to our Spotify and add some songs that you know and, and contribute musically that way.</p>\n\n\n\n<p>Roger Williams 00:43:24&nbsp; Absolutely. Yeah. No, I love listening to music, but yeah. No, just I tried learning piano a bunch of years ago. I want to say like 12 years ago, had an instructor come to the house, got full weighted keys and everything. And, Yeah, I just couldn&#8217;t get past, like, Tinker, tinkle, tinkle a little bell or something like that. Oh, man. Yeah.</p>\n\n\n\n<p>Michelle Frechette 00:43:45&nbsp; No, I have an upright grand in my other room that I. It was my grandfather&#8217;s from the 20s, 1920s. Not not 2020. So it&#8217;s a oh, gosh, it&#8217;s over 100 years old now. My piano. But yeah. And I learned when I was little. So I don&#8217;t play very often. I live in a condo. And my neighbors would not be happy if I was banging on that piano at night, but, but it is nice to have around. So, any last any last words? Anything last things you&#8217;d like to share with us Roger?</p>\n\n\n\n<p>Roger Williams 00:44:12&nbsp; you know, I it would I&#8217;d be remiss without mentioning that, we just rolled out a new product called Kinsta Automatic Updates. This is an add on feature to your website at Kinsta, and this does automatic updates of your themes and plugins, with the caveat that it does visual regression testing. So we take a screenshot before the update. We update it and then we take a screenshot afterwards if there&#8217;s a difference that means something went wrong. We revert the update and then we notify you of of which plugin caused the issue so you can start troubleshooting it.&nbsp;</p>\n\n\n\n<p>Michelle Frechette: Oh nice.&nbsp;</p>\n\n\n\n<p>Roger Williams: I&#8217;m really excited about that. You know, I was really excited about WordPress 6.5 when we came out with the auto rollback feature. that only catches PHP errors, which is I mean, it&#8217;s still massive. You should at least have that automatically on, I think. but with this feature, it just adds a little bit more to it. So it&#8217;ll catch, you know, maybe a plugin breaks a CSS, feature or something. And, and so the site&#8217;s not necessarily throwing up PHP error. It&#8217;s still running, but it&#8217;s broken. And if you&#8217;re spending a lot of money on your marketing and advertising, having a landing page broken is really annoying. So this helps wit that.Yeah. So if you have questions about it, come to kinsts.com and take a look to automatic updates. That&#8217;s pretty exciting. The team did a really great job.</p>\n\n\n\n<p>Michelle Frechette 00:45:34&nbsp; And if people want to follow up with you, what&#8217;s the best place to get in touch with you Roger?</p>\n\n\n\n<p>Roger Williams 00:45:38&nbsp; LinkedIn. I&#8217;ll be honest with you. So I&#8217;m in the Post Status group. You can DM me there. Thank you for giving me more time in Slack. But honestly, like LinkedIn, I love getting contacted there. I enjoy spending time in LinkedIn. So yeah, reach out to me there. And if you want to be on a Kinsta talk, reach out and we&#8217;ll work something out.</p>\n\n\n\n<p>Michelle Frechette 00:45:59&nbsp; Awesome. Thank you so much for your time today. Again, if people are interested, they can go to Kinsta.com and if they&#8217;re interested in the affiliate program it&#8217;s Kinsta.com/affiliates. So thank you for all your sponsorships, all that you&#8217;re doing and all that you do to highlight some pretty amazing people in WordPress. I appreciate your time today and all that you do.</p>\n\n\n\n<p>Roger Williams 00:46:19&nbsp; Thank you very much, Michelle, and I appreciate you and all the work that you&#8217;ve done. And thank you for having me on the show.</p>\n\n\n\n<p>Michelle Frechette 00:46:25&nbsp; My pleasure. Thank you. We&#8217;ll see everybody else next week.</p>\n\n\n\n<p>Roger Williams 00:46:29&nbsp; Bye&nbsp;</p>\n\n\n\n<p>Michelle Frechette: Bye.</p>\n<p>This article, <a href=\"https://poststatus.com/post-status-happiness-hour-session-twenty-three-2/\">Post Status Happiness Hour Session Twenty Four</a>, was published at  <a href=\"https://poststatus.com\">Post Status</a> — the community for WordPress professionals.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 17 Apr 2025 21:30:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Olivia Bisset\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:16;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"Post Status: Post Status Happiness Hour Session Twenty Three\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://poststatus.com/?p=163414\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://poststatus.com/post-status-happiness-hour-session-twenty-three/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:56604:\"<div class=\"wp-block-embed__wrapper\">\n\n</div>\n\n\n\n\n\n\n\n<p><a href=\"https://poststatus.com/category/planet/#h-transcript\">Transcript</a> ↓</p>\n\n\n\n<p>In this episode of the Post Status Happiness Hour, host Michelle Frechette interviews Cami MacNamara a seasoned web designer and solopreneur. Cami shares insights into her business, Web Cam LLC, and her new initiative, &#8220;Web Designer Habits,&#8221; which aims to help web designers develop productive habits. They discuss the importance of accountability, time management techniques like time blocking and the Pomodoro technique, and the benefits of joining online and local networking groups. The episode also teases a collaborative project between Michelle and Cammy involving a planner designed to support web designers in maintaining their habits.</p>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"h-top-takeaways\">Top Takeaways: </h3>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Small Changes Lead to Big Improvements –</strong> Cami emphasized the power of incremental progress, whether in business, design, or personal productivity. Tackling tasks in small steps can make overwhelming projects more manageable and sustainable.</li>\n\n\n\n<li><strong>Be Prepared for the Unexpected –</strong> Michelle shared practical travel and everyday preparedness tips, from keeping essential items in the car to ensuring that your luggage complies with airline regulations. Thinking ahead can save time, stress, and even money.</li>\n\n\n\n<li><strong>Documenting Processes is Key –</strong> The discussion touched on the importance of writing down systems and workflows, especially for solopreneurs. Whether through standard operating procedures (SOPs) or simple notes, having a record helps maintain efficiency and organization.</li>\n\n\n\n<li><strong>Community and Support Matter –</strong> Both Michelle and Cami highlighted the value of connection in professional spaces, particularly within the WordPress and web design communities. Engaging with peers through newsletters, Facebook groups, and live discussions fosters learning, growth, and mutual encouragement.</li>\n</ul>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"h-mentioned-in-the-show\">Mentioned In The Show:</h3>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://webcami.com/\">Web Cami, LLC</a></li>\n\n\n\n<li><a href=\"http://webdesignerhabits.com\">webdesignerhabits.com</a></li>\n\n\n\n<li><a href=\"https://streamyard.com/\">StreamYard</a></li>\n\n\n\n<li><a href=\"https://webcamicafe.com/\">WebCamiCafe</a></li>\n\n\n\n<li><a href=\"https://www.godaddy.com/\">GoDaddy</a></li>\n\n\n\n<li><a href=\"https://us.shein.com/\">Shein</a></li>\n\n\n\n<li><a href=\"https://www.pomodorotechnique.com/\">Pomodoro Technique</a></li>\n\n\n\n<li><a href=\"https://wordpress.tv/2023/11/13/its-about-time/\">WordPress TV</a></li>\n\n\n\n<li><a href=\"https://managewp.com/\">Managed WP</a></li>\n\n\n\n<li><a href=\"https://theadminbar.com/\">Admin Bar</a></li>\n\n\n\n<li><a href=\"https://www.wpbeaverbuilder.com/\">Beaver Builder</a></li>\n\n\n\n<li><a href=\"https://calendly.com/\">Calendly</a></li>\n\n\n\n<li><a href=\"https://wpcoffeetalk.com/\">WPCoffeeTalk</a></li>\n</ul>\n\n\n\n<div class=\"wp-block-columns has-theme-palette-8-background-color has-background is-layout-flex wp-container-core-columns-is-layout-3 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<h3 class=\"wp-block-heading\"><img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/1f64f.png\" alt=\"🙏\" class=\"wp-smiley\" /> Sponsor: <a href=\"https://poststat.us/a2-hosting\">A2 Hosting</a></h3>\n\n\n\n<p>A2Hosting offers solutions for WordPress and WooCommerce that are both blazing fast and ultra-reliable. WordPress can be easily deployed on ANY web hosting plan from A2: Shared, VPS, or Dedicated. A2 also offers Managed WordPress and WooCommerce Hosting. Take a look at a2hosting.com today!</p>\n</div>\n\n\n\n<div class=\"wp-block-column is-vertically-aligned-center is-layout-flow wp-block-column-is-layout-flow\">\n<img width=\"752\" height=\"470\" src=\"https://poststatus.com/wp-content/uploads/2022/08/imageedit_1_6433774706-752x470.png\" alt=\"A2 Hosting\" class=\"wp-image-104073\" />A2 Hosting\n</div>\n</div>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"h-you-can-follow-post-status-and-our-guests-on-social-media\"><img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/1f426.png\" alt=\"🐦\" class=\"wp-smiley\" /> You can follow Post Status and our guests on Social Media:</h3>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://www.linkedin.com/in/webcami/\">Cami MacNamara</a> (Owner &amp; Designer, <a href=\"https://webcami.com/\">WebCami LLC</a>)</li>\n\n\n\n<li><a href=\"https://twitter.com/michelleames\">Michelle Frechette</a>&nbsp;(Director of Community Relations,&nbsp;<a href=\"https://twitter.com/post_status\">Post Status</a>)</li>\n\n\n\n<li><a href=\"https://twitter.com/lemonadecode\">Olivia Bisset</a>&nbsp;(Intern,&nbsp;<a href=\"https://twitter.com/post_status\">Post Status</a>)</li>\n</ul>\n\n\n\n<p>The <strong>Post Status</strong> podcast is geared toward WordPress professionals, with interviews, news, and deep analysis. <img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/1f4dd.png\" alt=\"📝\" class=\"wp-smiley\" /></p>\n\n\n\n<p><a href=\"https://poststatus.com/category/post-status-podcasts/\">Browse our archives</a>, and don’t forget to subscribe via <a href=\"https://itunes.apple.com/us/podcast/post-status-draft-wordpress/id976403008\">iTunes</a>, <a href=\"https://podcasts.google.com/feed/aHR0cHM6Ly9mZWVkcy5zaW1wbGVjYXN0LmNvbS8ySkU5c2M4UA\">Google Podcasts</a>, <a href=\"https://www.youtube.com/c/PostStatus\">YouTube</a>, <a href=\"http://www.stitcher.com/podcast/krogsgard/post-status-draft-wordpress-podcast\">Stitcher</a>, <a href=\"https://wordpress-post-status-draft-podcast.simplecast.com/\">Simplecast</a>, or <a href=\"https://feeds.simplecast.com/2JE9sc8P\">RSS</a>. <img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/1f3a7.png\" alt=\"🎧\" class=\"wp-smiley\" /></p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"h-transcript\">Transcript</h2>\n\n\n\n<p>Michelle Frechette 00:00:01&nbsp; And we&#8217;re alive with this week&#8217;s Post Status Happiness Hour with my good friend Cami McNamara and Cami does a lot. Hi Cami, I know you do a lot of different things. You have your agency and all these, you know, other things, podcasting and all the things you&#8217;re doing now. But today we&#8217;re really going to talk about your web designer habits, how you came up with that, what some of them might look like, how people can get in on that, and maybe some things that we&#8217;re going to tease about what you and I are working on together too. So.</p>\n\n\n\n<p>Cami MacNamara 00:00:30&nbsp; Well, that sounds great. Thank you.&nbsp;</p>\n\n\n\n<p>Michelle Frechette 00:00:33&nbsp; Yeah. Welcome to the Happiness Hour. It&#8217;s good to have you here.</p>\n\n\n\n<p>Cami MacNamara 00:00:36&nbsp; Yeah, it&#8217;s great to be here. I&#8217;m so. I&#8217;m always happy to talk to you, Michelle. Like, anytime we get to spend time together, it makes my day.</p>\n\n\n\n<p>Michelle Frechette 00:00:44&nbsp; Absolutely. I feel exactly the same way for. For people who haven&#8217;t met you, who don&#8217;t, you know, as equated with who you are. Can you just give us a little bit about where you&#8217;re located, what you do with WordPress, maybe you know anything that you want to mention about your life? I know you got a really cool dog like all those. Just fill us in on the details for a minute.</p>\n\n\n\n<p>Cami MacNamara 00:01:03&nbsp; Sure. Well, I am located. My name is Cami McNamara and otherwise known as Web Cami. So my business is Web Cam, LLC and I have been building websites since 2000 and started my business in 2002. So I just had my 23rd anniversary in business. Oh I&#8217;m a solopreneur. I build websites for small businesses and nonprofits all over the United States, but I&#8217;d say the majority of my clients are here in the Seattle area. So I live in Seattle, in a neighborhood called Alki Beach, and I often on social media and posting pictures of my neighborhood because, well, I just love it.</p>\n\n\n\n<p>Michelle Frechette 00:01:48&nbsp; Because it&#8217;s beautiful.</p>\n\n\n\n<p>Cami MacNamara 00:01:49&nbsp; Thank you. I mean, it&#8217;s like I live at a California beach in a big city. So it&#8217;s kind of nice. Much smaller scale. Not not, you know, nobody&#8217;s hanging tenning out in the water.</p>\n\n\n\n<p>Michelle Frechette 00:02:03&nbsp; It&#8217;s a little chilly up there for that. Probably.</p>\n\n\n\n<p>Cami MacNamara 00:02:05&nbsp; Little chilly. There&#8217;s a lot of cold plungers that, You know, I do. I did it this year on New Year&#8217;s Eve, but. Or New Year&#8217;s Day. But I&#8217;m not planning to do that again. So that&#8217;s it. I have a husband. I&#8217;ve been married for 35 years, and I have a dog who&#8217;s a ten year old Labrador named Tank. I also share a lot of pictures of him, and I have a 28 year old son.</p>\n\n\n\n<p>Michelle Frechette 00:02:32&nbsp; Awesome. And everybody comments on the, the parking meter behind you, so.&nbsp;</p>\n\n\n\n<p>Cami MacNamara: Oh yeah.</p>\n\n\n\n<p>Michelle Frechette: Because I know everybody&#8217;s like, what&#8217;s the parking meter about?</p>\n\n\n\n<p>Cami MacNamara 00:02:45&nbsp; Okay so yes. Yeah. So my parking meter back here, my aunt, worked for Rockwell Industries back in the 70s. And when I was a little kid, she gave me that parking meter. Now, my grandmother had this parking meter, the same kind, but she made it into a lamp. And you&#8217;d have to put your you&#8217;d have to put coins in it to turn the lamp on. And as a as a kid, I was obsessed with that. So my aunt gave me that. You can see the faded number eight. I put like a sticker on there for my eighth birthday, and it&#8217;s there to remind me to keep my time top of mind all day long.</p>\n\n\n\n<p>Michelle Frechette 00:03:27&nbsp; Which is one of the web habits designer habits. But you have. So one of the things that I was just, like, enamored with when you came out with that last year, I think you called it WP Habits to begin with.</p>\n\n\n\n<p>Cami MacNamara 00:03:40&nbsp; Yeah, I called it Habits WP. I had, I had WP Habits, I still have all those domains.</p>\n\n\n\n<p>Michelle Frechette 00:03:47&nbsp; So yes, they can all point to the new one. Right. And now it&#8217;s web designer habits.com Correct?</p>\n\n\n\n<p>Cami MacNamara 00:03:54&nbsp; Yes. Yes because I&#8217;m really sharing habits that aren&#8217;t just for a WordPress designer. They&#8217;re really for anybody who&#8217;s doing web design and and how it came to be was, you know, I&#8217;ve been blogging about running my business for quite a while, and I wrote, I did a blog post about habits, but my friend Anne Marie and I went on a women&#8217;s business retreat with Kim Doyle in Costa Rica a couple of years ago, and I told her I want to figure out some way to share what I know and what I do, but I am not going to have time to develop big, long courses. I have a hard time taking big, long courses. What can I put? How can I put this in little tidbits for people and also for myself to work on each week? And that&#8217;s kind of how it was born.</p>\n\n\n\n<p>Michelle Frechette 00:04:45&nbsp; That makes sense. I loved when you first came out with that. I signed up right away. I get the emails every week. And then I don&#8217;t you keep giving me credit for it. I don&#8217;t know if that&#8217;s really true or not, but I was like, wow, you really have to have a whole website for this where there&#8217;s an art and archive. So like if somebody&#8217;s starting now, they can still go back and see the ones they missed. And, I kind of have a little bit more to.</p>\n\n\n\n<p>Cami MacNamara 00:05:10&nbsp; Well, it was, it was kind of always on my to do list. But you&#8217;re the person who lit the fire underneath me to go ahead and do that. And now, in addition to my website, I am building a circle community for this. So I&#8217;m hoping to have that launch in the next few weeks.</p>\n\n\n\n<p>Michelle Frechette 00:05:29&nbsp; Very cool. So there&#8217;ll be a whole community about it.</p>\n\n\n\n<p>Cami MacNamara 00:05:32&nbsp; Yes. Because you know what? You know, what helps you get your habits in order is having accountability with others.</p>\n\n\n\n<p>Michelle Frechette 00:05:39&nbsp; Yeah, that&#8217;s very true. That is very true. Do you want to bring the site up on and to share your screen? And we&#8217;ll take a look at it.</p>\n\n\n\n<p>Cami MacNamara 00:05:45&nbsp; Yeah, sure. How I&#8217;m not sure how to do that, but that&#8217;s okay. Do you what do you want to do it on your end? It&#8217;s if if that&#8217;s easier for you, is it? I just haven&#8217;t been in StreamYard and.</p>\n\n\n\n<p>Michelle Frechette 00:05:59&nbsp; Yeah. That&#8217;s okay.</p>\n\n\n\n<p>Cami MacNamara 00:05:59&nbsp; In a long time.</p>\n\n\n\n<p>Michelle Frechette 00:06:01&nbsp; Okay, so I&#8217;ve got it up. I can no longer see you, so I&#8217;m going to scroll and let you explain what we&#8217;re looking at then okay.</p>\n\n\n\n<p>Cami MacNamara 00:06:06&nbsp; Well basically this is just where you sign up. and I, I like big fonts and I cannot lie. Okay. I&#8217;ll just say that right off the bat.&nbsp; So when I designed this, I really wanted it to be bold and impactful. But basically this is where you sign up. There&#8217;s just a little bit of a story about me and where, how I came to be here. I have a podcast which I have been doing, off and on for a couple of years. I share the habit each week, and then I also report on how I did adopting the habit, and that&#8217;s under the blog section. So that&#8217;s kind of new. And I&#8217;m building out resources. And as I said before, I&#8217;m going to start a circle community for this, because I just kind of feel like there&#8217;s a need for it.</p>\n\n\n\n<p>Michelle Frechette 00:06:58&nbsp; And you have, you have your, WebCamiCafe over on Facebook.</p>\n\n\n\n<p>Cami MacNamara 00:07:02&nbsp; Yes I do I started a Facebook group basically for friends that I was making as I became a GoDaddy Pro ambassador. This is back in 2018. And you know, I kept going to WOrdCamps and kept meeting people and friends of friends or adding folks, and it&#8217;s just really a nice small networking group and a good place just to meet other web designers.</p>\n\n\n\n<p>Michelle Frechette 00:07:32&nbsp; Yeah, for sure. And I mean, people are posting really cool things in there all the time and asking for feedback and having great conversations about some of those things.</p>\n\n\n\n<p>Cami MacNamara 00:07:40&nbsp; Yeah, it&#8217;s it because the numbers are small, it&#8217;s kind of more intimate and I really like that part of it.</p>\n\n\n\n<p>Michelle Frechette 00:07:48&nbsp; I did too, and I will say, like, I&#8217;m not really doing a lot of web design anymore. If I do, it&#8217;s mostly my own things that I&#8217;m, that I&#8217;m doing, you know, that kind of thing. But, I think we take this off. There we go. but I still, even though I&#8217;m not, like, web designer habit girl, finding so many of the things that you share to still be relevant, even if you aren&#8217;t a designer or a small business owner. So there are constantly reminders in there of things that I need to be doing, even if I don&#8217;t have clientele. I&#8217;m not designing for others.</p>\n\n\n\n<p>Cami MacNamara 00:08:22&nbsp; Well, and and you have contributed to those things. So when I listen to you speak at WordCamp US and you instructed me to stop saying I&#8217;m sorry all the time, I felt like you were just talking to me, and I, I came back and made that a habit that everyone should adopt, because so many times we&#8217;re replying to our clients and emails and saying, oh, I&#8217;m sorry, I&#8217;m sorry, I&#8217;m sorry. And really, we&#8217;re not necessarily the ones that are sorry. It&#8217;s just comes out of your mouth.</p>\n\n\n\n<p>Michelle Frechette 00:08:55&nbsp; Yeah.</p>\n\n\n\n<p>Cami MacNamara 00:08:56&nbsp; As a habit..</p>\n\n\n\n<p>Michelle Frechette 00:08:57&nbsp; Right. There&#8217;s there&#8217;s much better language, more empowering language, stronger language you can do to help move things forward rather than just saying, I&#8217;m sorry, especially if we weren&#8217;t the ones to make the mistake or have an error kind of thing. Yeah. For sure. I also say don&#8217;t say thank you as often and and I don&#8217;t mean that as like don&#8217;t be grateful. Because certainly gratitude is something that I use all the time. But when you normally would say thank you just because that&#8217;s not a good use of thank you.</p>\n\n\n\n<p>Michelle Frechette 00:09:26&nbsp; Right. There&#8217;s other, more empowering language you can use, especially like when somebody buys your software and their automated emails says, thank you for purchasing XYZ. Yeah. But of course we&#8217;re grateful that they purchased it. But do they care that we&#8217;re grateful for the purchase? No. They want to know what can I do with this and how can I make my life better because of it? And so, you know, I just talk about some of those different things. So those are the things I talked about that I think you really liked at WordCamp US. .</p>\n\n\n\n<p>Cami MacNamara 00:09:50&nbsp; Yeah. No, it was fantastic. It really made a strong impression on me. And yeah, I&#8217;m always listening for things that I&#8217;m learning from other people that I know are habits I need to adopt. And selfishly, you know, creating this group is a way to keep me accountable to myself. And yeah.</p>\n\n\n\n<p>Michelle Frechette 00:10:11&nbsp; Yeah, for sure, I have, I actually hired an accountability coach this year. Not because I&#8217;m, you know, don&#8217;t want things to move forward, but because of ADHD brain and out of sight, out of mindedness and things like that.&nbsp; I&#8217;m writing a novel, and I want to make sure that I keep moving forward on the things that I want to keep moving forward on. And so she and I meet every other week on Zoom, and she helps me keep moving forward because I&#8217;ve only accountable to other people for their things. I&#8217;m never accountable to myself for my own things because in my brain, everybody else comes first, right? So when I have to now be accountable to her. It means I&#8217;m not. I&#8217;m being accountable to me through her as a proxy, and I keep moving things forward, if that makes any sense.</p>\n\n\n\n<p>Cami MacNamara 00:10:56&nbsp; Right. Yeah, it&#8217;s so true. Because, you know, we all start off our day with the best intentions, right? And we start off strong every day. And, you know, a lot of these habits that I&#8217;ve been nurturing myself. You know, the dream is to be on autopilot. Right? With some of them. And so whatever can help you, whether it&#8217;s you hiring a coach to help you, it just it just strength strengthens your resolve with you for sure thing.</p>\n\n\n\n<p>Michelle Frechette 00:11:29&nbsp; It really does. And I think that it&#8217;s just a way of helping you move forward on your own projects as well, because I think, I mean, everybody does, but I, I can only speak from the women I know who talk about these kinds of things. I think as women, we always put ourselves last and we never prioritize those things. And so to have somebody help me stay accountable to listening to myself and moving myself forward, I think, became an important thing for me.</p>\n\n\n\n<p>Cami MacNamara 00:11:54&nbsp; Yeah, I agree. I mean, my, my friend Anne Marie and I, we sing to each other in Marco Polo, during the week when we go on walks, just to be accountable, accountable and say, hey, it&#8217;s really cold out here, but I&#8217;m walking anyway, so I yeah, I have accountability buddies, including you all the time.&nbsp;</p>\n\n\n\n<p>Michelle Frechette 00:12:15&nbsp; Yep. And and now we&#8217;ve got a third person helping us actually stay accountable to our project.</p>\n\n\n\n<p>Cami MacNamara 00:12:21&nbsp; That&#8217;s right. Because you can only imagine that it&#8217;s a little difficult for us to stay on topic when we&#8217;re meeting.</p>\n\n\n\n<p>Michelle Frechette 00:12:29&nbsp; Yeah.</p>\n\n\n\n<p>Cami MacNamara 00:12:30&nbsp; Sometimes. Yeah.</p>\n\n\n\n<p>Michelle Frechette 00:12:32&nbsp; For sure. So, so about that project, do you want to tease that out a little bit?</p>\n\n\n\n<p>Cami MacNamara 00:12:37&nbsp; Right. So, Michelle reached out to me and said, hey, have you thought about doing a some sort of planner for the habits that you&#8217;re working on and and of course I it had entered my mind. But you know, I&#8217;m a solopreneur. I manage like 200 websites in my care plan. There&#8217;s just so much on my plate. And Michelle said, I have this wonderful photography and I could work in tips, and I was all in the minute she said that. So we&#8217;ve been meeting every Friday for quite a while, talking about plans, and then we brought in a friend to help us get things rolling, and we actually have a date to come up with.</p>\n\n\n\n<p>Michelle Frechette 00:13:17&nbsp; We set our first deadline.</p>\n\n\n\n<p>Cami MacNamara 00:13:19&nbsp; Right after. But we we have a date to come up with ideas for our layout. And both Michelle and I love planners. We already had a plethora of planners, but we both ordered a bunch to play around with and see what we liked.</p>\n\n\n\n<p>Michelle Frechette 00:13:36&nbsp; Yeah, exactly. And I made the mistake of just buying a bunch, whereas you were really strategic and went to the went to the store and took pictures of a bunch, which was yeah.</p>\n\n\n\n<p>Cami MacNamara 00:13:45&nbsp; I did that too, but I also I did order to you. I ordered a few like habit trackers and you know everybody. There&#8217;s also online options and notion and you know just using a Google Sheets or something like that. But I, I do think it&#8217;s it would be a fun to come up with something to accompany this material.</p>\n\n\n\n<p>Michelle Frechette 00:14:09&nbsp; Yeah, absolutely. Now, I think it was last week I received a, the Anti Planner in the mail and I posted it online saying, I don&#8217;t know where this came from if you sent this to me. Thank you so much. Did I tell you my confession about it? No.</p>\n\n\n\n<p>Cami MacNamara 00:14:25&nbsp; No. Did you order it and forget?</p>\n\n\n\n<p>Michelle Frechette 00:14:28&nbsp; Yes.</p>\n\n\n\n<p>Michelle Frechette 00:14:31&nbsp; It was part of my Shein order. But it came separately. It didn&#8217;t say Shein. And I was like, where did this come from? And I just went over my purchase history, that I was like, well, I&#8217;ll be darned. I bought that for myself.</p>\n\n\n\n<p>Cami MacNamara 00:14:43&nbsp; Oh my gosh, that&#8217;s so funny. I would do that. I would do that 100%.</p>\n\n\n\n<p>Michelle Frechette 00:14:49&nbsp; Anne Marie says I love the Web Designer Habits website Cami, me too.</p>\n\n\n\n<p>Cami MacNamara 00:14:54&nbsp; Aw thank you Ann Marie.</p>\n\n\n\n<p>Michelle Frechette 00:14:55&nbsp; For sure. And Daveden said he watched my WordCamp US talk and needs to improve the way he overused to thank you. So yeah, I think we all kind of do.</p>\n\n\n\n<p>Cami MacNamara 00:15:04&nbsp; Yes, 100%. I&#8217;ve probably been doing that my entire life, right?</p>\n\n\n\n<p>Michelle Frechette 00:15:10&nbsp; Yeah. Now I know, like I see tips all the time. I&#8217;ve written tips. I used to, you know, blog for the local newspaper, business tips, things like that. What are some of your favorite habits that either you&#8217;ve incorporated into your life or that you just think are so cool that other people should do them too? Like, do you have like 2 or 3 that you would go? I think that&#8217;s one of my favorites.</p>\n\n\n\n<p>Cami MacNamara 00:15:32&nbsp; Yeah. Time blocking there. I&#8217;ve heard a lot of people be very resistant to time blocking.&nbsp; And every habit doesn&#8217;t work for everyone. Right. But for me, I needed time blocking. Time blocking has been something that really shapes my day every single day. It helps me when clients send me incoming requests to say, I&#8217;m going to work on this on Wednesday at 4:00, because that&#8217;s when I have maintenance on my schedule. So I absolutely love time blocking, and that has been a huge part of me being productive as a single solopreneur. The next one is the Pomodoro technique. So I am not sitting for hours at a time because, you know, we can all get in the flow and not want to leave a project. And, I remember in the early days having all kinds of neck pain, and eye strain and everything else. It just is so important to take care of your back and everything else. And you can use the Pomodoro Technique in concert with your time blocking, and make sure that you&#8217;re stepping away and getting up every 25 minutes. So working 25 minutes with a five minute break. Yeah, works well for me.</p>\n\n\n\n<p>Michelle Frechette 00:16:58&nbsp; Yeah. Now I do calendar blocking, but I, I use it to, to like, block my calendar from other people being able to schedule on my calendar just to get and not assign particular tasks, but just so I can work through my list of things that I need to do, or honestly like to sleep in a little bit on that morning if I need to. Before I was doing that, I would just say I give people my calendar links and I would wake up in the morning and I felt 15.</p>\n\n\n\n<p>Cami MacNamara 00:17:26&nbsp; Yeah, you have no time. You have no time to work because.</p>\n\n\n\n<p>Michelle Frechette 00:17:28&nbsp; Yeah, I was like, what? Am I going to run to the bathroom or have lunch at that point, you know. So yeah, for sure. Oh look. Yeah, we have it&#8217;s very karmic that, Crystals got in at, the first thing he heard was the Pomodoro technique. Not the best was dealing with his ADHD most times. Trust me, we know. We know we are. We are right there with you. You are not alone.</p>\n\n\n\n<p>Cami MacNamara 00:17:51&nbsp; Right? I if somebody wants to see how I time block, if you go to a WordPress TV, the WordCamp TV, site, I&#8217;m getting that wrong. But, I spoke at Vancouver 2023, Vancouver WordCamp, and I shared in my slides. My time blocking techniques.</p>\n\n\n\n<p>Michelle Frechette 00:18:14&nbsp; Oh, cool. I&#8217;ve got that right here. Hold on. I will put that in the chat. Okay. Like I&#8217;m. On it.</p>\n\n\n\n<p>Cami MacNamara 00:18:20&nbsp; Thank you for doing all the things I need to practice with StreamYard. I&#8217;m a huge fan. Now that I heard their music for testing your speakers, and anybody else who&#8217;s done that will know what I&#8217;m talking about.</p>\n\n\n\n<p>Michelle Frechette 00:18:33&nbsp; I have never done that until today when you told me to do that and I was like, oh, that&#8217;s pretty cool, actually. Yeah.</p>\n\n\n\n<p>Cami MacNamara 00:18:39&nbsp; They have a whole song just about testing there.</p>\n\n\n\n<p>Michelle Frechette 00:18:42&nbsp; You&#8217;re testing your speakers. You&#8217;re testing your speakers.</p>\n\n\n\n<p>Cami MacNamara 00:18:45&nbsp; Yeah, that&#8217;s pretty hilarious with, like, a band and everything.&nbsp;</p>\n\n\n\n<p>Michelle Frechette 00:18:49&nbsp; So yeah, I know they they I&#8217;m gonna guess it&#8217;s AI generated, but even so.</p>\n\n\n\n<p>Cami MacNamara 00:18:53&nbsp; Yes. Pretty cool. It&#8217;s great. It was hilarious.</p>\n\n\n\n<p>Michelle Frechette 00:18:57&nbsp; Some of my favorite things I&#8217;ve learned is over the years, especially when I was freelancing and I could write off so many of my expenses was to keep an envelope in my car with the month listed on it. So if it was, you know, March, I had that envelope either in my purse or in my car. So that like whenever I was shopping, picking up things, I would put the receipts in there. For that month so that I could then at the end of the month, tally things up, keep track of it. And when it came to tax time, I wasn&#8217;t going where all the receipts and what did I do and how much money. And I was a step ahead or two steps ahead of the game at that point in time. So that was one that I really liked. The other thing that I have taught myself recently, so we&#8217;ll see if it hangs on as I habit.</p>\n\n\n\n<p>Michelle Frechette 00:19:40 I have a tendency like throughout the day I as I&#8217;m on calls, I make little notes. And now at the end of the day, instead of just having this giant pile of notes, I&#8217;m transcribing them into action items and keeping track of them in my little like method of how I&#8217;m trying to keep on top of tasks. So I don&#8217;t know what was that I had to do? And where is that piece of paper? And I can&#8217;t read my handwriting and all those things so that while it&#8217;s still fresh in my mind, I&#8217;m translating things into tasks because otherwise things fall through the cracks. And I&#8217;m not a fan of letting things fall through the cracks.</p>\n\n\n\n<p>Cami MacNamara 00:20:12 Yeah, that&#8217;s a great plan. You know, it&#8217;s kind of like at the end of every day, I&#8217;m always thinking, what promises did I make today? Right? And yeah, it&#8217;s a it&#8217;s a very helpful to get all your tasks actually on your calendar too. So you got the tasks and you have them scheduled.</p>\n\n\n\n<p>Michelle Frechette 00:20:33&nbsp; Yes. Yes, exactly. And I discovered today that my, Google calendar was not able to send me those two minute warnings before an event happened, and I was running late to everything because I was relying on those before. And so I was able to troubleshoot that today. And now I&#8217;m getting notifications on my calendar. So sometimes you just have to dig in and figure out what&#8217;s wrong and how to fix it, that&#8217;s for sure.</p>\n\n\n\n<p>Cami MacNamara 00:20:58&nbsp; Right. And you know, we get so involved in our day to day that if you don&#8217;t get that ping right before something happens, you can completely forget.</p>\n\n\n\n<p>Michelle Frechette 00:21:07&nbsp; Yes, exactly. Now, one of the things that you do as an agency is you actually have care plans. And how many websites are you caring for?&nbsp;</p>\n\n\n\n<p>Cami MacNamara 00:21:17&nbsp; Over 200 a month. And, you know, I, I incrementally built that over time. It&#8217;s been ten years, so I didn&#8217;t go from 0 to 200. I have it down. I use I, I use Managed WP. It&#8217;s a tool that I&#8217;ve been using since the beginning of time, I feel like, and it is such a great tool for me because I can start my day and is the only person in my business. The first thing I log into every day is Manage WP, and it&#8217;s the last thing I leave at the end of every day because it&#8217;s my control panel for getting to those client sites in a hurry. It also is like, you know, it&#8217;s not just for the client. The client. I love that they trust me to take care of their websites. They are doing me a favor because if they have an emergency, it doesn&#8217;t disrupt my life entirely to help them. Because I have what I need to help them versus leaving it up to them to have a backup. And oops, I figured out I wasn&#8217;t really making backups the whole time. I can&#8217;t tell you how many times that&#8217;s happened.</p>\n\n\n\n<p>Michelle Frechette 00:22:27&nbsp; Oh, I can imagine. And you&#8217;re also still designing at the same time. So taking on new clients and doing all the work to keep the business going, which is why those habits are so important.</p>\n\n\n\n<p>Cami MacNamara 00:22:37&nbsp; Yeah, I&#8217;m in a networking group, and I took a couple of years off because my parents passed away and I just got back into it in September. So every Thursday morning I&#8217;m going to an in-person meeting. I have kind of some duties as a person in the group. I meet with other people. It&#8217;s but it brings in a steady flow of business. So yes, it&#8217;s I&#8217;m spinning plates all the time.</p>\n\n\n\n<p>Michelle Frechette 00:23:04&nbsp; What is a habit that you would think would be helpful for people who work alone remotely? Like like me. Right. I&#8217;m in my house 24/7, basically, unless I&#8217;m going out meeting somebody for dinner to go shopping. So I work here. I try to meet people online, have that kind of personal touch here and there. What would your suggestion be for like online networking and things?</p>\n\n\n\n<p>Cami MacNamara 00:23:26&nbsp; Well, I would, join some online groups, you know, I&#8217;ll mention Admin Bar. That&#8217;s a really good one to get, kind of like a really big, vast. It&#8217;s it&#8217;s huge. Right. But you get a lot of different types of web designers in there to connect with a group like mine. Web Cami Cafe, smaller. Anybody who&#8217;s just starting out is welcome to join.</p>\n\n\n\n<p>Cami MacNamara 00:23:51&nbsp; But you can also join groups that, are just interests that you have that aren&#8217;t directly web designers, but it might be another tool that you use, like I&#8217;m in the Beaver Builder group, because that&#8217;s the tool that I use, and I, I&#8217;m just interacting with people as important. It&#8217;s actually a line item. It&#8217;s a time block for me to go online and log into all the places I&#8217;m a member of and actually participate and answer a question, or give somebody a like or a heart, and that gets you some exposure. But really, I do think that, networking in your local area because nothing really takes the place of human to human contact. So tonight I was going to a Women in Marketing networking event. It&#8217;s been canceled because we&#8217;re supposed to have severe weather tonight by a little crazy, but getting out of your office and and interacting with people. And even if you&#8217;re an introvert in a small way, it can really just boost your spirits. Like you might dread it before you go. But after it&#8217;s over, I guarantee you you&#8217;ll feel good about it.</p>\n\n\n\n<p>Michelle Frechette 00:25:07&nbsp; And Zach mentions don&#8217;t forget Post Status for the events.</p>\n\n\n\n<p>Cami MacNamara 00:25:09&nbsp; Yes of course Post Status.</p>\n\n\n\n<p>Michelle Frechette 00:25:12&nbsp; We have lots of good conversations in there too. Of course. Yeah, I think that&#8217;s great. I love, I personally I love getting together with people, even if it&#8217;s online. And one of the things, like one of the ways you and I grew our friendship was I was like, does anybody want a coworker during Covid? And you&#8217;re like, I&#8217;ll do it. And like, that was our first really, like face to face, if you will, even though it was virtual.</p>\n\n\n\n<p>Cami MacNamara 00:25:32&nbsp; And let&#8217;s just admit we didn&#8217;t work at all.</p>\n\n\n\n<p>Michelle Frechette 00:25:36&nbsp; No, not at all.</p>\n\n\n\n<p>Cami MacNamara 00:25:38&nbsp; We didn&#8217;t work at all. And we met, in a WordCamp that was online, fully online. I don&#8217;t remember if it was WordCamp Europe or, but it was fully online. And GoDaddy had me working in their virtual booth, and that&#8217;s how it might have been.</p>\n\n\n\n<p>Michelle Frechette 00:25:55&nbsp; Might have been Denver, I don&#8217;t know.</p>\n\n\n\n<p>Cami MacNamara 00:25:57&nbsp; Or, San Antonio.</p>\n\n\n\n<p>Michelle Frechette 00:26:00&nbsp; Oh yeah.</p>\n\n\n\n<p>Cami MacNamara 00:26:01&nbsp; Yeah, that one was one of the first ones to go online.</p>\n\n\n\n<p>Michelle Frechette 00:26:04&nbsp; Yeah, that could have been. Yeah, for sure. It&#8217;s so hard to remember five years ago. Yeah. And yet and yet it&#8217;s hard to forget five years ago too.&nbsp;</p>\n\n\n\n<p>Cami MacNamara 00:26:11&nbsp; Yes.I know.</p>\n\n\n\n<p>Michelle Frechette 00:26:12&nbsp; And it&#8217;s funny because I&#8217;ve recently seen these memes like, you know, like five years ago today, which was, you know, on March 13th. And I was like, what happened five years ago today? And then I was like, oh, wait, that was like lockdown.&nbsp; I remember.</p>\n\n\n\n<p>Cami MacNamara 00:26:23 I, I was flying home, I was visiting my folks in Northern California and I was flying home. And it was surreal because they had just closed down Seattle, like I was coming home and like everything was going to be closed. And, I like they they were spacing people on the airplane. So you weren&#8217;t seated next to people. And that was just bizarre.</p>\n\n\n\n<p>Michelle Frechette 00:26:47&nbsp; It was so surreal. It felt like ghost towns and like you could walk down the middle of Main Street and like, like an old Western, like draw, you know? Yeah, you.</p>\n\n\n\n<p>Cami MacNamara 00:26:56&nbsp; Did all of it because I, I flew home like 20 times during Covid, and there were times when you would get off the plane at the airport. There was nobody there. Everything was closed. It was just like, walk right through it is. Yeah.</p>\n\n\n\n<p>Michelle Frechette 00:27:10&nbsp; Really insane for sure. Anybody in the in the who&#8217;s watching right now, do you have a web habit that you&#8217;ve developed as a web designer or agency owner, or just in business in general that you think you&#8217;d like to share? Maybe Cami will put it in one of her newsletters. I mean, with your permission, of course.&nbsp;</p>\n\n\n\n<p>Cami MacNamara: Yes, of course.</p>\n\n\n\n<p>Michelle Frechette: Because I I&#8217;d love to hear what some people have. So get typing in those comments, we want to hear what some of your habits are. I right now am laid off from a full time job, and one of the things that I have been maintaining as a habit is getting up every day and coming to my desk and doing something at my desk that I don&#8217;t break that you know, continuity of sitting at my desk and doing work. And so I, with the exception of one day that I took off to do something else, but family oriented. But I sit here every day. Some days I&#8217;m done at two. Some days I&#8217;m done at seven. It depends on what I&#8217;m working on and what meetings I have and those kinds of things. But it is actually pretty exciting to think about continuity that way. And so even if you aren&#8217;t working full time or you have a day that you, you know, you don&#8217;t have other, obligations getting up and sitting at your desk and, you know, making that commute down the hall, as I always say, I think is another habit to really be in. So, oh, here we go. Anne Mary says she learned from you to check email three times a day. Because checking emails constantly is a really bad habit of hers. Which, yeah, for sure, I&#8217;m. I have my phone in my pocket all the time, so I try to set it aside with notifications off when I&#8217;m at my desk, because otherwise I will react to every notification. So 100%, that is.</p>\n\n\n\n<p>Cami MacNamara 00:28:56&nbsp; Yeah. That&#8217;s one of the habits that is never going to be an autopilot for me. I, I have to fight my urge to check my email all day to get that done. And I&#8217;ve even put a tab on my Gmail that is called focus. It&#8217;s like an empty inbox that I.</p>\n\n\n\n<p>Michelle Frechette 00:29:15&nbsp; Yeah?</p>\n\n\n\n<p>Cami MacNamara 00:29:15&nbsp; I put that up so I&#8217;m not looking when I shouldn&#8217;t.</p>\n\n\n\n<p>Michelle Frechette 00:29:19&nbsp; Yeah. Nope. I get that, Zach has one too. I set aside time to learn, time to create, time to focus on getting work done and time to handle operations every day. It sounds like that time blocking you were talking about whether it&#8217;s the same time every day, just making sure that you&#8217;re hitting all those marks and continuing moving everything forward in a regular fashion. I think that&#8217;s a great idea, Zach, for sure.</p>\n\n\n\n<p>Cami MacNamara 00:29:41&nbsp; Yeah, I, I totally agree with Zach. I even have like, my wake up block at the beginning of my day. And and it&#8217;s, it&#8217;s like it&#8217;s for me to wake up, shower, exercise, and I put whatever. So if one day I don&#8217;t want to wake up and I just want to sleep until, you know, 7:30 or whatever, I can. It never happens. But I could like, you know, my time block. I would allow it. It&#8217;s flexible. Yeah.</p>\n\n\n\n<p>Michelle Frechette 00:30:10&nbsp; Yeah, yeah, for sure. I, I, I made a decision earlier this week that made me so happy and that, like, my calendly links have been set from 9 a.m. to 5 p.m., and I hate 9:00 meetings. So I was like, why do I have that on my calendar then? So I went in and changed my calendly to start at ten in the morning instead, because I it&#8217;s my calendar, I can do what I want with it. So if I don&#8217;t want 9:00 meetings, I don&#8217;t have to have a 9:00 meeting. And it&#8217;s like, why did I not think of that before? Like, how silly, right.</p>\n\n\n\n<p>Cami MacNamara 00:30:43&nbsp; Yeah, I, I use the time blocking in two ways. I&#8217;m, I&#8217;m blocking the time that, that I need to work and I&#8217;m available for appointments. And over the years I have really shrunk those hours that I&#8217;m available for appointments down to. I think it&#8217;s about 6.5 hours a week now. That&#8217;s it. And, but if I don&#8217;t do that, then I am working constantly on weekends and after hours because I don&#8217;t have enough time in my day.</p>\n\n\n\n<p>Michelle Frechette 00:31:13&nbsp; So Zach doesn&#8217;t start appointments till 11 because this morning are for creativity, which I think is perfect. Yeah. So I know go ahead.</p>\n\n\n\n<p>Cami MacNamara 00:31:22&nbsp; Another another way to do that is to make one day all appointments, and I do that as well. And it&#8217;s exhausting, but it kind of frees up the other days for me to not have me. Yeah, all of them. You know.</p>\n\n\n\n<p>Michelle Frechette 00:31:35&nbsp; Sometimes it&#8217;s hard. So like, this month I&#8217;ve been doing all of these, like over 50, 5 minute interviews with women all over the world. And so I&#8217;ve had my calendar running from anywhere from nine in the morning until 7 or 8:00 at night, because I&#8217;ve been interviewing with women from Uganda and with women from Asia and women from Australia, and like complete opposite timezones of me. So I&#8217;ve tried to be a little more, gracious with the time available to make sure that I can represent women all over the world, and not just in my convenient to my convenience. Right? So, so sometimes, sometimes it&#8217;s a little more challenging for sure, but that&#8217;s finite, right? So that&#8217;s not going to go on forever. And no. And and so.</p>\n\n\n\n<p>Cami MacNamara 00:32:16&nbsp; You have to have flexibility because we all have those things. We have those clients that can&#8217;t meet during the times we&#8217;re available. So we&#8217;re not going to say, I can&#8217;t meet with you ever. You&#8217;re going to adjust, and then you steal that time from wherever you took it from. So if a client enters something that is supposed to be work time for me, I&#8217;m going to reach out in the future and and close off meeting time to make up for it. So yeah.</p>\n\n\n\n<p>Michelle Frechette 00:32:44&nbsp; And I have so I have my regular Calendly slots available. And I have a secret calendar that somebody is on the other side of the world are like, oh, I can&#8217;t make any of those times.</p>\n\n\n\n<p>Michelle Frechette 00:32:53&nbsp; I&#8217;ll be like, well, this calendar work for you? And it&#8217;s got more expensive, but it isn&#8217;t available to everybody all the time. So I try to yeah, little little tricks that kind of work for me here and there.</p>\n\n\n\n<p>Cami MacNamara 00:33:02&nbsp; Yeah. The Calendly secret meeting is fantastic.</p>\n\n\n\n<p>Michelle Frechette 00:33:06&nbsp; Yeah it is. And Ann Marie says she blocks off Fridays. No meetings that day. It is freeing. Absolutely. For sure. Zach, are you the Zach that joined the. Oh, I guess we don&#8217;t need to put that up there. You can just respond to that one. Claudia says she has a secret scheduler too. Very helpful. Absolutely. And it feels almost clandestine. Right. Like you&#8217;ve got this. Like, nobody knows about this unless I bring them into the fold.&nbsp;</p>\n\n\n\n<p>Cami MacNamara 00:33:34&nbsp; I feel a new habit coming along right here. I think that that would be a great I mean, you know, think about yourself as a web designer. And you&#8217;re just starting out, and a lot of these things, like setting up secret meetings and stuff, these are things we learn over time, right? Like, I didn&#8217;t always have the secret meeting thing. And then once I started using Calendly more, you know, on the regular backup, it&#8217;s been 5 or 6 years or something way before Covid. But it just really was like, wow, this is cool. You know, I like, I like, had a calendar for happy hours. Oh, yeah. You know, before Covid.</p>\n\n\n\n<p>Michelle Frechette 00:34:17&nbsp; Sure. Yeah. And I&#8217;ve learned, like, I for my WPCoffeeTalk. I have only one evening and and Saturday is available. And if I know I want to sleep in on a certain Saturday, I just block that day on my calendar. I just want block and then people can&#8217;t schedule for that week, but for that week. And it doesn&#8217;t have to be right away. People can schedule for next month or, you know, a few weeks out or that kind of thing. So I&#8217;m not. Nothing is urgent when you&#8217;re recording a podcast.</p>\n\n\n\n<p>Cami MacNamara 00:34:43&nbsp; Yeah. And and that&#8217;s the other thing about scheduling, like online scheduling, is I usually make sure there&#8217;s like a 12 hour buffer between when somebody can book with me so I don&#8217;t get a, you know, I might start my when I start my day, I know what my schedule is.</p>\n\n\n\n<p>Cami MacNamara 00:34:59&nbsp; I don&#8217;t want people to just be hopping in there in turn, like a one meeting day into a five meeting day all of the sudden.</p>\n\n\n\n<p>Michelle Frechette 00:35:07&nbsp; Yeah. Zach says he also has a schedule that isn&#8217;t as lockdown for VIPs. I&#8217;m assuming. Zach, that&#8217;s the link you give me? Just asking. can I give you another habit I developed this year?</p>\n\n\n\n<p>Cami MacNamara 00:35:19&nbsp; Yeah.</p>\n\n\n\n<p>Michelle Frechette 00:35:20&nbsp; Which is I mostly travel for business to this point and occasionally for fun. I actually have a whole kit of things that I keep in my suitcase. Duplicates of things like I have, you know, my toiletries bag. And I have duplicate minis of all the toiletries so I don&#8217;t have to take things from my bathroom and push back and forth. So I keep that in there. I keep a little, extension cord in there, and I keep my international plugs in there so that an extra watch charger, like all of the things, extra phone charger, so that I don&#8217;t have to make that list every time I travel. I have all those regulars already in the suitcase.&nbsp; All I really have to do is anything specific to that trip and my clothes.</p>\n\n\n\n<p>Cami MacNamara 00:36:03&nbsp; Oh, that&#8217;s a great idea.</p>\n\n\n\n<p>Michelle Frechette 00:36:06&nbsp; It&#8217;s a huge time saver, huge time saver. And it saves me from forgetting things like Tylenol or, you know, those kinds of things because it I I&#8217;ve arrived places before with a horrible headache and don&#8217;t have any Tylenol with me. And then I have to go in search of in a foreign city that I don&#8217;t know, and find some Tylenol or pay at the airport ten times what Tylenol costs, you know, those kinds of things. So yeah.</p>\n\n\n\n<p>Cami MacNamara 00:36:32&nbsp; Yeah, travel hacks, that&#8217;s a whole nother that other a lot of great, great tips for that. When I was going to California a lot, to see my folks, I had like a hanging toiletry bag. And in the morning when I was getting ready, that&#8217;s when I was packing it.</p>\n\n\n\n<p>Michelle Frechette 00:36:49&nbsp; So, yeah, that&#8217;s a good idea too.</p>\n\n\n\n<p>Cami MacNamara 00:36:50&nbsp; That was kind of a nice, streamlined, streamlined way to take care of that.</p>\n\n\n\n<p>Michelle Frechette 00:36:56&nbsp; Absolutely. But I have just purchased extra plug, you know, power strips and things that I can plug all my things into for charging overnight in a hotel room. I have enough of those that I keep one in the suitcase, so it just makes me happy.</p>\n\n\n\n<p>Cami MacNamara 00:37:09&nbsp; Well, I know when I see you in Arizona in about 3 or 4 weeks that, that&#8217;s going to be how you&#8217;re rolling in. All right.</p>\n\n\n\n<p>Michelle Frechette 00:37:17&nbsp; Exactly. All ready ready. That&#8217;s right. So. Oh, and Zach says, you know that his camera bag is go ready at all times, as is mine. Zach, I made the mistake once of not charging batteries, and I got an hour and a half away, and I had no batteries charged, and I was like, well, it&#8217;s a pretty drive, but the birds aren&#8217;t going to be photographed today because I forgot to charge things. So. Yeah. Claudia has a bag of stuff in the car all the time. Yeah, I have a little purse.</p>\n\n\n\n<p>Cami MacNamara 00:37:43&nbsp; Good idea.</p>\n\n\n\n<p>Michelle Frechette 00:37:44&nbsp; A little mini pair of sewing scissors in my car. Because, like, when I get a Starbucks or something, the hole is never big enough to actually, like, drink through. You know how, like, you have to have that second hole. Yeah. So I&#8217;m like, poke it through with an extra pair of scissors, because I made the mistake of using a pen once and ended up with ink in my coffee, which I don&#8217;t recommend to anybody. But yeah, if lip balm in my car I have that. I have a nail file and clippers and things that you wish you had when you suddenly go broke a nail. What am I going to do now? You know, kinds of things. So great advice. All great advice though. Oh, I love it. All the tips and tricks from people in the in the comments too, any last minute before we start to wrap things up here, folks, if you&#8217;ve got any other ideas, throw them in there.</p>\n\n\n\n<p>Michelle Frechette 00:38:25&nbsp; Also, if you have any questions, you know, we want to, we want to hear them. Please put those in the comments as well. If you have a question for Cami or me, panic-mode is the go to before travels. Yeah, I&#8217;m a last minute packer, which is also why I have those things packed in advance. Because otherwise I&#8217;d be like, oh, I forgot my toothpaste and oh, where&#8217;s my toothbrush and all those things. So I just have. I mean, you can own more than one toothbrush. Did you know that?</p>\n\n\n\n<p>Cami MacNamara 00:38:56&nbsp; Yeah. I will get my I will get my suitcase out a few days early and just start throwing things at it. It&#8217;s not packed, but it&#8217;s a pile. And I just. Then, then the night before. That way, if I&#8217;m doing laundry, I can just. Put tuff in there. Yeah. Fold it.</p>\n\n\n\n<p>Michelle Frechette 00:39:14&nbsp; Yeah. Anker makes a USB-C charger hub that can charge up to four devices, including a laptop. Oh, that&#8217;s a great idea. I had something like that, and it got confiscated in Seoul, so I lost that. It was in my suitcase. They told me I could go all the way down to baggage claim and back up through security. Or I could toss that $30 charger. And I said, go ahead and throw it away. So, yeah, don&#8217;t. That&#8217;s another thing. Don&#8217;t pack things in your suitcase that can&#8217;t travel. Good advice. yeah. Any last minute thoughts Cami anything that you wished I&#8217;d asked you or that you want to share.</p>\n\n\n\n<p>Cami MacNamara 00:39:50&nbsp; You know, I just believe that if you can make a tiny change every day and it helps you run your business better, that, you know, that is sometimes we just get so bogged down with what we should be doing or, you know, maybe we want to make a change and it seems too daunting and just breaking things down into tiny little, increments that you can deal with. And that goes for like a task, like a redesign.&nbsp; If you&#8217;re feeling overwhelmed, just do one little thing. If you only work on it for 30 minutes today, consider it a win. So celebrate all the little things that you do</p>\n\n\n\n<p>Michelle Frechette 00:40:30&nbsp; Yes.</p>\n\n\n\n<p>Cami MacNamara 00:40:30&nbsp; That makes a difference and help you make it through your day. So often we just don&#8217;t give ourselves enough credit and can be too critical of ourselves and how our day goes. Nobody has a perfect day, you know? Maybe. I mean, and if you have one, you&#8217;re not going to have one the next day. Right?</p>\n\n\n\n<p>Michelle Frechette 00:40:50&nbsp; That&#8217;s true. You seldom get two in a row.</p>\n\n\n\n<p>Cami MacNamara 00:40:52&nbsp; That&#8217;s. Yeah. You seldom get two in a row and just, you know, whatever you do, some days if you have a bad day, you know, maybe you needed the day off. And just in that instance, you&#8217;re taking care of yourself. And that&#8217;s a good day.</p>\n\n\n\n<p>Michelle Frechette 00:41:07&nbsp; Absolutely. Do you have your, your celebration jar there on your desk still?</p>\n\n\n\n<p>Cami MacNamara 00:41:11&nbsp; So I do, but I emptied it today because it got so. It got so full then.&nbsp;</p>\n\n\n\n<p>Michelle Frechette: Oh that&#8217;s awesome.&nbsp;</p>\n\n\n\n<p>Cami MacNamara: I had yeah like it got really full. But yes, I put little post-it notes in here with what I accomplished. Just one little task at a time and I keep it. Normally I empty it on Friday, but I&#8217;ve been, I&#8217;ve been go I, I kind of worked a little on Sunday, so. Got full early.</p>\n\n\n\n<p>Michelle Frechette 00:41:36&nbsp; Yeah. Zach says the best process for writing down your systems is to have the people doing the work write the SOP. Yeah, that&#8217;s true too. Absolutely.</p>\n\n\n\n<p>Cami MacNamara 00:41:46&nbsp; Well, that would be me I the person.</p>\n\n\n\n<p>Michelle Frechette 00:41:49&nbsp; Yeah, a lot of us, it&#8217;s just ourselves for sure. Yeah.</p>\n\n\n\n<p>Cami MacNamara 00:41:52&nbsp; But yes, I do agree that, like, having those things written down that you do is just a fantastic way to kind of map out what, what you going on.</p>\n\n\n\n<p>Michelle Frechette 00:42:03&nbsp; And they&#8217;re all written down at WebDesignerHabits.com. How is that for a Segway? That was pretty cool.</p>\n\n\n\n<p>Cami MacNamara 00:42:08&nbsp; That was pretty awesome. Thank you Michelle.</p>\n\n\n\n<p>Michelle Frechette 00:42:11&nbsp; You&#8217;re welcome. It is free to sign up for this newsletter. It is free to join Cami’&#8217;s Facebook group. If you are interested in learning more WebDesignerHabits.com, we&#8217;ll get you all the stuff to sign up for that newsletter. It is a treat. I read it&#8217;s the one one of the only three newsletters that I read top to bottom every week.</p>\n\n\n\n<p>Cami MacNamara 00:42:31&nbsp; So thank you, thank you. You know, it isn&#8217;t complex. It&#8217;s just like one thing. I don&#8217;t look it up a whole bunch of other things.</p>\n\n\n\n<p>Michelle Frechette 00:42:38&nbsp; I mean, that makes it easy to read, right? So it&#8217;s easy to consume for sure, which has one of the reasons I love it. And if it doesn&#8217;t apply to me, that&#8217;s okay. I still learn something. and if it does, great. Yeah. So like, I don&#8217;t have a lot of clients, so I&#8217;m not writing newsletters to clients, but, but I do a newsletter for Post Status and, you know, staying on track for that and all the things.</p>\n\n\n\n<p>Michelle Frechette 00:42:58&nbsp; So anyway, so thank you, Web Cami for joining me today.</p>\n\n\n\n<p>Cami MacNamara 00:43:03&nbsp; Thank you. Thank you for having me, Michelle, I really appreciate I appreciate it and I so appreciate you in our community, you know, you are the glue that keeps the WordPress community together.</p>\n\n\n\n<p>Michelle Frechette 00:43:15&nbsp; I try, I do what I can to try to help others along the way and to create a happy place. So thank you. Everybody else, I&#8217;m working on my, my, guest for next week. It most likely will be Roger from Kinston, so I&#8217;m not going to put that in writing, but we&#8217;re working on some details. If not, then I&#8217;ll have somebody else and that will be upcoming. But if you have something you want to talk about, a project that you want to share, get in touch with me. Maybe you can be on the next Post Status Happiness Hour. So thank you everybody who&#8217;s been here all day chatting with us or for the hour chatting with us and really appreciate all of you. And, again, Cami thank you. I appreciate your time today, too.</p>\n\n\n\n<p>Cami MacNamara 00:43:58&nbsp; Yeah. Thanks for having me. And I really enjoyed meeting everyone and reading all your comments.</p>\n\n\n\n<p>Michelle Frechette 00:44:05&nbsp; The comments were great. Yeah, yeah. For sure. Awesome. All right. We&#8217;ll see everybody next week.</p>\n\n\n\n<p>Cami MacNamara 00:44:11&nbsp; Bye.</p>\n<p>This article, <a href=\"https://poststatus.com/post-status-happiness-hour-session-twenty-three/\">Post Status Happiness Hour Session Twenty Three</a>, was published at  <a href=\"https://poststatus.com\">Post Status</a> — the community for WordPress professionals.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 17 Apr 2025 21:30:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Olivia Bisset\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:17;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Post Status: Agency News Weekly\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://poststatus.com/?p=163362\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://poststatus.com/agency-news-weekly-2025-03-31/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5067:\"<h2 class=\"gb-headline gb-headline-930042ec gb-headline-text\">Web Agency Summit is Next Week</h2>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Atarim and Omnisend are presenting a free online <a href=\"https://atarim.io/summit/\">Web Agency Summit</a> next week, April 7-11.</li>\n\n\n\n<li>The event will share strategies for web agencies to adapt, scale, and thrive amidst AI and digital innovation.</li>\n\n\n\n<li>More than 12,000 attendees are expected for the more than 50 sessions led by expert presenters.</li>\n\n\n\n<li><a href=\"https://atarim.io/summit/#ticket\"><strong>Sign up to attend here</strong></a>. Tickets are free, but limited.</li>\n</ul>\n\n\n\n<h2 class=\"gb-headline gb-headline-3f9efd72 gb-headline-text\">Post Status Launches Virtual Stage Webinar Series</h2>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Post Status Executive Director Michelle Frechette has created a new series of webinars  called &#8220;<a href=\"https://poststatus.com/wp-speakers-virtual-stage-series/\">The WP Speakers Virtual Stage Series</a>.&#8221;</li>\n\n\n\n<li>The Virtual Stage creates opportunities for speakers whose WordCamp submissions weren&#8217;t accepted to share their expertise with the community.</li>\n\n\n\n<li>The program will run weekly YouTube Live webinars at 11 AM Eastern Time.</li>\n\n\n\n<li><a href=\"https://poststatus.com/wp-speakers-virtual-stage-series/#:~:text=%E2%AC%87%EF%B8%8F%20%E2%AC%87%EF%B8%8F%20Apply%20Below%20%E2%AC%87%EF%B8%8F%20%E2%AC%87%EF%B8%8F\">Speakers can submit talks</a> on any WordPress-related topic, with organizers encouraging creative and unique presentation ideas.</li>\n\n\n\n<li>Michelle will personally review applications and coordinate with selected speakers to schedule their presentation weeks.</li>\n\n\n\n<li>Each talk will become part of Post Status&#8217;s permanent content library, extending the speaker&#8217;s reach beyond the live event.</li>\n</ul>\n\n\n\n<h2 class=\"gb-headline gb-headline-c5f2a47b gb-headline-text\">Google&#8217;s March Core Update Impacts Rankings &amp; SEO Tools</h2>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://searchengineland.com/google-march-2025-core-update-rollout-is-now-complete-453364\">Google&#8217;s latest Core Update for March 2025</a> is now complete with significant impact on the rankings of some sites.</li>\n\n\n\n<li>Semrush noted that <a href=\"https://www.seroundtable.com/google-march-2025-core-update-volatility-39133.html\">the SERP volatility</a> in the last 30 days was in the very high range: 9.3/10.</li>\n\n\n\n<li>In addition to ranking changes, this core update also <a href=\"https://www.seroundtable.com/google-march-2025-core-update-volatility-hits-39107.html\">impacted the ability of some tools</a> like Ahrefs and SE Ranking to get accurate data.</li>\n\n\n\n<li><a href=\"https://developers.google.com/search/blog/2019/08/core-updates\">Google offers a list of questions</a> for site owners to consider if they lose rankings after a core update like this one.</li>\n\n\n\n<li>Their stance remains that <a href=\"https://developers.google.com/search/docs/fundamentals/creating-helpful-content\">creating helpful, reliable, people-first content</a> is the key to good rankings.</li>\n</ul>\n\n\n\n<ul class=\"wp-block-list\">\n<li></li>\n</ul>\n\n\n\n<h2 class=\"gb-headline gb-headline-bb61369f gb-headline-text\">The Admin Bar&#8217;s 2025 Web Professionals Survey is Open</h2>\n\n\n\n<ul class=\"wp-block-list\">\n<li>For the last few years, The Admin Bar&#8217;s Kyle Van Deusen has surveyed web professionals to capture the latest trends for solopreneurs and agencies.</li>\n\n\n\n<li><strong><a href=\"https://airtable.com/appSlIAaDEJQrB9dc/pag0rwgDZ5g119Kmr/form\">This year&#8217;s survey is now open</a></strong>. </li>\n\n\n\n<li>The 20 quick questions are multiple choice and should take less than 10 minutes to complete.</li>\n\n\n\n<li><a href=\"https://theadminbar.com/2024-survey/\">The results of last year&#8217;s survey</a> included responses from over 1,100 web professional globally and had some interesting takeaways.</li>\n</ul>\n\n\n\n<h2 class=\"gb-headline gb-headline-7643d17f gb-headline-text\">Worth a Look </h2>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong><a href=\"https://www.theverge.com/news/638933/elon-musk-x-xai-acquisition\">Elon Musk has sold X</a> to <a href=\"https://x.ai/\">xAI</a></strong> and plans to blend &#8220;xAi&#8217;s advanced AI capability and expertise with X&#8217;s massive reach.&#8221;</li>\n\n\n\n<li><strong>Amazon has announced <a href=\"https://www.theverge.com/news/639688/amazon-nova-act-ai-agent-web-browser\">a new AI agent called Nova Act</a></strong> that search, make purchases, and perform tasks on a schedule.</li>\n\n\n\n<li><strong>Interesting Read:</strong> <a href=\"https://www.404media.co/how-the-fbi-tracked-and-froze-millions-sent-to-criminals-in-massive-caesars-casino-hack/\">How the FBI Tracked, and Froze, Millions Sent to Criminals in Massive Caesars Casino Hack</a></li>\n</ul>\n<p>This article, <a href=\"https://poststatus.com/agency-news-weekly-2025-03-31/\">Agency News Weekly</a>, was published at  <a href=\"https://poststatus.com\">Post Status</a> — the community for WordPress professionals.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 17 Apr 2025 21:30:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Nathan Ingram\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:18;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"Do The Woo Community: What Enterprises Need from DXPs in 2025: Beyond Vendor Agendas with Dan Drapeau\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=94685\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:99:\"https://dothewoo.io/what-enterprises-need-from-dxps-in-2025-beyond-vendor-agendas-with-dan-drapeau/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:195:\"Host Krim discusses Digital Experience Platforms (DXPs) with insights from Dan Drapeau. Key topics include CMS fragmentation, vendor lock-in, AI\'s role in DXPs, and strategic priorities for 2025.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 17 Apr 2025 13:31:22 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:19;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"Do The Woo Community: Selling Is Not My Strength\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"https://dothewoo.io/?post_type=blog&p=94669\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"https://dothewoo.io/blog/selling-is-not-my-strength/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:228:\"BobWP reflects on his struggles with sales throughout their entrepreneurial journey, emphasizing a preference for honesty and transparency over aggressive selling techniques, ultimately valuing their humanity over sales success.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 17 Apr 2025 09:43:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:20;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Matt: 6.8\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=141353\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://ma.tt/2025/04/cecil/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2862:\"<p><a href=\"https://wordpress.org/news/2025/04/cecil/\">WordPress 6.8 Cecil is out</a>, and it&#8217;s a great release. It&#8217;s unbelievable that it&#8217;s already <a href=\"https://wordpress.org/download/counter/\">been downloaded over 6 million times as I write this</a>. That feeling never gets old.</p>\n\n\n\n<p>It&#8217;s a funny time in WordPress because there are a lot of  really interesting open questions:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Can we iterate faster with canonical plugins?</li>\n\n\n\n<li>What&#8217;s the fun thing we can put in to celebrate 7.0, and when will that be? (I was rooting for real-time co-editing like Notion/Canva/Google Docs.)</li>\n\n\n\n<li>How can we use AI to automate our manual work around WordPress.org?</li>\n\n\n\n<li>Can AI help us make 60k+ open source plugins and themes in the directory more secure? (I think so.)</li>\n\n\n\n<li>What should we do with our 13k issue backlog? (That&#8217;s a lot of bug gardening.)</li>\n\n\n\n<li>How will AI change how people build and update sites?</li>\n\n\n\n<li>Just like RSS and web standards supercharged WordPress for the podcasting and search revolutions, what standards or APIs can we ship to help 40%+ of the web work with AI agents? (Plus an entire rabbit hole of all the new sloppy crawlers using so many resources.)</li>\n</ul>\n\n\n\n<p>Some of these broad changes are mixed. At one point, I used Google to search for things and would visit their top result, which is great for website owners. Nowadays, Google pulls almost everything I need into the results page, so I don&#8217;t see as many random sites. But on <a href=\"https://www.perplexity.ai/\">Perplexity</a>, sometimes I&#8217;ll read the answer and then visit 4-5 of the sources it cites to learn more, so I&#8217;m visiting 4-5x more random websites, usually powered by WordPress, than I would have even in the early days of Google. We don&#8217;t know how this all plays out yet.</p>\n\n\n\n<p>These questions are also against the backdrop of some of the brightest minds in WordPress spending more time with legal code than computer code, which could last until 2027 or longer with appeals. </p>\n\n\n\n<p>Speaking for myself, I was in my first deposition today. I really appreciated the due process and decorum of the rule of law, and just like code, law has a million little quirks, global variables, loaded libraries, and esoteric terminology. But wow, after a full day of that, I&#8217;m mentally exhausted. Hence, I&#8217;m posting about 6.8 after it&#8217;s had 6 million downloads. I&#8217;m more impressed than ever by what smart lawyers do, and the entire thing, though sometimes imperfect and frustrating, is a blessing to our democracy. However, I can&#8217;t wait to return to spending the plurality of my days with engineers and designers again. I&#8217;m sure many other folks in the WordPress community would agree.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 17 Apr 2025 09:19:36 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:21;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"bbPress: bbPress 2.6.13 is out\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://bbpress.org/?p=244192\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://bbpress.org/blog/2025/04/bbpress-2-6-13-is-out/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:513:\"<p>bbPress 2.6.13 is a <strong>minor</strong> release that fixes <a href=\"https://bbpress.trac.wordpress.org/query?status=closed&milestone=2.6.13\">1 small incompatibility</a> with WordPress 6.8.</p>\n\n\n\n<p>(This fix is already merged into the 2.7 development branch.)</p>\n\n\n\n<p>Thank you to vortfu, peterwilsoncc, spacedmonkey, joemcgill, swissspidy, and jorbin for helping communicate this to the bbPress team <img src=\"https://s.w.org/images/core/emoji/15.1.0/72x72/1f41d.png\" alt=\"🐝\" class=\"wp-smiley\" /></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 17 Apr 2025 06:57:18 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"John James Jacoby\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:22;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"WPTavern: #165 – Aaron D. Campbell Why Open Standards and WordPress Matter\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://wptavern.com/?post_type=podcast&p=194783\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:89:\"https://wptavern.com/podcast/165-aaron-d-campbell-why-open-standards-and-wordpress-matter\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:47549:\"Transcript<div>\n<p>[00:00:00] Nathan Wrigley: Welcome to the Jukebox Podcast from WP Tavern. My name is Nathan Wrigley.</p>\n\n\n\n<p>Jukebox is a podcast which is dedicated to all things WordPress. The people, the events, the plugins, the blocks, the themes, and in this case, why open standards matter, and how WordPress fits into an open web.</p>\n\n\n\n<p>If you&#8217;d like to subscribe to the podcast, you can do that by searching for WP Tavern in your podcast player of choice, or by going to wptavern.com/feed/podcast, and you can copy that URL into most podcast players.</p>\n\n\n\n<p>[00:00:53] Nathan Wrigley: If you have a topic that you&#8217;d like us to feature on the podcast, I&#8217;m keen to hear from you and hopefully get you, or your idea, featured on the show. Head to wptavern.com/contact/jukebox, and use the form there.</p>\n\n\n\n<p>So on the podcast today we have Aaron D. Campbell.</p>\n\n\n\n<p>Aaron is an international speaker, open source advocate, and self-described outgoing introvert. He&#8217;s been a regular contributor to WordPress for more than a decade, and is currently director of product at A2 Hosting. His longstanding enthusiasm for WordPress stems from its role as a necessary counterbalance to closed web solutions, providing a vital, open source, alternative that fosters accountability among digital platforms. Aaron&#8217;s vision of WordPress&#8217;s importance has fueled his sustained commitment, and excitement for the platform matching his initial zeal from years ago.</p>\n\n\n\n<p>Today we talk about a topic that&#8217;s integral to Aaron, and likely resonates with many of you listeners, the importance of the open web. With the advent of closed platforms, open standards and open source have become more crucial than ever.</p>\n\n\n\n<p>Aaron shares his journey in the WordPress space, and how his commitment to the open web has kept him passionate about it over the years. We discussed the evolution of open web concepts, maintaining interoperability, and ensuring your digital creations remain under your control.</p>\n\n\n\n<p>We compare this with the growing dominance of closed corporate platforms, and examine the impact of profit motives versus the more altruistic goals of open source. Aaron articulates why preserving the openness of the web is essential, not just for innovation, but for the entire fabric of global society.</p>\n\n\n\n<p>If you&#8217;re curious about the role of open systems and the future they shape and why the open web matters now more than ever, this episode is for you.</p>\n\n\n\n<p>If you&#8217;re interested in finding out more, you can find all of the links in the show notes by heading to wptavern.com/podcast, where you&#8217;ll find all the other episodes as well.</p>\n\n\n\n<p>And so without further delay, I bring you Aaron D. Campbell.</p>\n\n\n\n<p>I am joined on the podcast by Aaron D. Campbell. Hello, Aaron.</p>\n\n\n\n<p>[00:03:13] Aaron D. Campbell: Hey, thanks for having me.</p>\n\n\n\n<p>[00:03:14] Nathan Wrigley: Well, I&#8217;m really pleased to talk to you today. This is a subject which is fairly close to my heart. We&#8217;re going to approach it, first of all, from the non WordPress angle, and then we&#8217;ll get into it from the WordPress angle. It&#8217;s all about open standards, open source.</p>\n\n\n\n<p>I guess before we begin, Aaron, I&#8217;ll just explain that this is the first interview that I&#8217;ve done at WordCamp Asia, which is in Manila. How are you finding it here? Did you have a nice journey over.</p>\n\n\n\n<p>[00:03:36] Aaron D. Campbell: You know, my journey over was smooth and uneventful, which is exactly how I like my journeys to these things to be. And I&#8217;m finding the place to be fantastic, and the time zone change to be very difficult.</p>\n\n\n\n<p>[00:03:48] Nathan Wrigley: Yeah, that&#8217;s exactly my experience as well. I think we&#8217;re both fairly tired at this point.</p>\n\n\n\n<p>It&#8217;s the first day, it&#8217;s Contributor Day, so there&#8217;ll be all of that excitement later. Aaron&#8217;s doing a presentation at WordCamp Asia, and this is what we&#8217;re going to talk about. It&#8217;s called The Future, why Open Web Matters.</p>\n\n\n\n<p>Before we get into that, Aaron, do you just want to give us your little potted bio? Tell us why you are here, who you work for, what it is that you do in the WordPress space.</p>\n\n\n\n<p>[00:04:13] Aaron D. Campbell: Sure, yeah. What do I do in the WordPress space? Well, that has changed a lot over the years, but I&#8217;ve been pretty actively contributing to the WordPress project for about 18 or so years now. Done everything from leading releases and leading the security team to helping put on some of these events like WordCamp US. I work for A2 Hosting, focusing on our products and helping to align what we do with the kind of open web, WordPress ethos that I have at my core.</p>\n\n\n\n<p>[00:04:44] Nathan Wrigley: Can I just ask you, if you&#8217;ve been in the project for as long as you have, which is pretty much the length of the whole project, I think, 18 years or so. But basically you&#8217;ve been in it since the beginning. So it&#8217;s nothing to do with the topic at hand. Are you as excited about WordPress as a thing in 2025 as you were all those years ago?</p>\n\n\n\n<p>[00:05:04] Aaron D. Campbell: Yes. Yes I am. I think that the thing that has kept me around this long, it&#8217;s not easy to do a thing for, you know, going on almost 20 years and to stay excited about it. But I think that the thing that has kept me there is this whole open web concept, and that I see WordPress as a very important counterbalance to some of the closed solutions that exist on the web.</p>\n\n\n\n<p>Having a viable alternative that is open helps keep those other platforms accountable, if you will. And so I think that what&#8217;s kept me around is really that kind of idealistic thing that I have around how important WordPress is. And so, yes, I&#8217;m just as excited about it as I was back then.</p>\n\n\n\n<p>[00:05:47] Nathan Wrigley: It feels like, if we were to rewind the clock 18 years ago, it feels like open was more normal, perhaps than it is now. And I think the closed platforms have monetised their way into the web and have kind of become, in many ways, the default, especially for people who aren&#8217;t in the inner circle of open source projects.</p>\n\n\n\n<p>So for example, the way to carry out messaging online is to go to a closed platform. The way to communicate via email is to use close, well, the protocol&#8217;s open, but you know, the system that you might use may be closed, and so on and so forth. So that seems to be the default.</p>\n\n\n\n<p>However, let me just read the blurb from your presentation so we&#8217;ll get a flavor of what it is that Aaron will be talking about out. So we&#8217;re talking about why the open web matters. And the blurb that went with that goes as follows.</p>\n\n\n\n<p>The internet has revolutionised how we share information, enabling unprecedented collaboration, and accelerating human progress in ways once unimaginable. However, this powerful tool is now at a crossroads. In this talk, Aaron will explore the critical role that open systems and the open web play in shaping our future. He will delve into the potential consequences of a closed digital ecosystem, and argue why preserving the openness of the web is essential, not only for innovation, but the very fabric of our global society. Discover why the open web matters more now than ever, and what&#8217;s at stake if we lose it.</p>\n\n\n\n<p>So there&#8217;s some fairly powerful words in there, you know, the future of society and so on. However, underpinning it all is this phrase, open web. And it occurs to me that, dear listener, you may not know what that means. So my opening gambit to you Aaron, what is the open web? What does that even mean?</p>\n\n\n\n<p>[00:07:20] Aaron D. Campbell: Honestly, you were talking a little bit about how we see more of these closed platforms now, and maybe it was more the standard 18, 20 years ago, and it&#8217;s true. When the web started around 1991, it was open in that information flowed easily and freely back and forth. And the things that we used to interact with the web, HTTP, HTML, all these things that we use were these open standards that could be implemented by anyone. You could implement them in some sort of closed web browser. You could implement them in an open source web browser. Either way, they were open standards that you could implement.</p>\n\n\n\n<p>And I think that that, where we started is kind of the core of this open that I&#8217;m talking about. It&#8217;s the interoperability, the ability for things to work together for different companies to be able to give you that same experience that you might want to have with their flavor. But if you then choose to leave that company, you can go somewhere else and still have whatever it is that you built, or created, or were using.</p>\n\n\n\n<p>And so open, while I love open source and a lot of what I do is around open source, I don&#8217;t think that open source in and of itself is the open web. It&#8217;s more about this freedom to be able to own your stuff and take it wherever you want to take it. It&#8217;s that interoperability that&#8217;s really at the core of open when I&#8217;m talking about the open web.</p>\n\n\n\n<p>[00:08:48] Nathan Wrigley: So it&#8217;s kind of the ability to pick up your data from one spot. Let&#8217;s say that you&#8217;ve got, well, in the case of WordPress, you&#8217;ve got a blog, you&#8217;ve got content that you&#8217;ve created, text, images and so on. The ability to say, you know what? I&#8217;m fed up with my CMS of choice. I want to move it elsewhere.</p>\n\n\n\n<p>But the same would be the case for, okay, I&#8217;ve got a bunch of messages that I&#8217;ve written to some clients and to some friends. I want to be able to drop that platform and move it over here. So I guess email might be a good example there. You know, there&#8217;s the protocol behind the email, that&#8217;s completely open. It would be crazy if you could only email people who are using the same service that you had. And so you can move providers all the time, but you may not be able to move your email address. So it&#8217;s a sort of complicated picture, but transportability, yeah. Is that possibly it?</p>\n\n\n\n<p>[00:09:30] Aaron D. Campbell: Yeah. I think that your example of, I&#8217;m fed up with my CMS, so I want to go somewhere else. That&#8217;s valid, I guess. But I look at it more from, let&#8217;s say that you&#8217;re a company that sells leather goods, and wherever you have your website has decided that they no longer allow you to sell leather goods on their platform.</p>\n\n\n\n<p>You need to go somewhere else for your own livelihood. You need to be able to go somewhere else. Can you? And if your site is WordPress, and it&#8217;s your host that says, we no longer allow leather goods, you can just move somewhere else. But if your site is on Facebook, and Facebook says that you can&#8217;t do that anymore, you can&#8217;t just take what you have and move somewhere else.</p>\n\n\n\n<p>And that&#8217;s a big difference because that&#8217;s a thing that is key to you continuing to, you know, I don&#8217;t know, run your business, make your money, put food on your table. And so it&#8217;s not just like, I got sick of this tool and wanted to move to another one. I think that part of it is like, who has control, and what are your options if what they want no longer aligns with what you want?</p>\n\n\n\n<p>[00:10:36] Nathan Wrigley: So it really boils down, in your case, to the ability for you to choose where things end. Yeah, choice. A choice. Okay.</p>\n\n\n\n<p>I really haven&#8217;t ever read a history of the internet, but the bits and pieces, the impression that I&#8217;ve got over the years when I&#8217;ve been reading around how the internet began, CERN and ARPANET and those kind of things. When the internet began, I don&#8217;t really know what the enterprise was to begin the whole thing.</p>\n\n\n\n<p>But it felt like it was more or less a service to provide the capability for academics to communicate with each other. There was never this intention that, okay, we&#8217;ll be buying and selling goods online. We&#8217;ll all be communicating through messaging platforms online. We&#8217;ll be sending photos online. So how did the internet begin? Do you know?</p>\n\n\n\n<p>[00:11:20] Aaron D. Campbell: It began open and it began specifically for the purposes of sharing information. The commercial internet exchange was trying to connect all these big networks that had tons of information in them at places like universities, governmental agencies, right? That were these silos of information.</p>\n\n\n\n<p>They wanted to interconnect those networks, make the internet, be able to share data back and forth for the purposes of being able to learn from each other. It was very much an academic pursuit.</p>\n\n\n\n<p>I think that that&#8217;s kind of how we grow our knowledge as people, right? We learn from what other people have learned, and then we learn some more on top of that. And they saw the value of having this kind of connected digital network to share information. And it was only useful if it was open, and that information could flow back and forth freely. And so, yes, you&#8217;re right, it wasn&#8217;t meant to be a commercial endeavor. It was meant to be a knowledge sharing endeavor.</p>\n\n\n\n<p>[00:12:18] Nathan Wrigley: It&#8217;s kind of a really altruistic enterprise when you say it in those terms. It really feels like it&#8217;s for the betterment of humanity. But I&#8217;m sure all of us can imagine scenarios where we think about our use of the internet, and the words, betterment of humanity are just not, well, they&#8217;re just an anathema.</p>\n\n\n\n<p>Because, you know, the internet has undoubtedly caused harms in various ways, and there&#8217;s misinformation being spread and all sorts of things like that, problems that we&#8217;ve got online.</p>\n\n\n\n<p>But I&#8217;m wondering, well, if we were talking about open on all levels of the internet, so for example, the internet that I&#8217;m using, I&#8217;m using a CMS, a web browser. It&#8217;s HTTPS, CSS, JavaScript, those kind of things. But underpinning it all, here&#8217;s my Mac, and the Mac presumably talks to the TCP IP stack, and there&#8217;s a bunch of routers and all of those kind of things going on, holding the internet together. Does all of that stack need to be open, or is it okay for some bits and pieces holding the infrastructure together to be closed?</p>\n\n\n\n<p>Because I&#8217;m not sure that you&#8217;d kind of want the hardware layer, if you know what I mean, some of those bits and pieces. Maybe they need to be, well, maybe they need to be proprietary and closed. I don&#8217;t know. What are your thoughts?</p>\n\n\n\n<p>[00:13:27] Aaron D. Campbell: That&#8217;s a really intriguing question, and I think that for the purposes of just being able to use and enjoy and leverage the internet, no, all those layers do not need to be open. For the purposes of preserving the internet as this information sharing kind of altruistic tool, I think that there needs to be openness at every one of those levels.</p>\n\n\n\n<p>I think that, for example, you were talking about the routers that shift all the information around, and they&#8217;re largely these hardware things, although they do have some software on them. But do all of those need to be open? No. But if one company is the only one that&#8217;s capable of shifting information around the web, then it becomes a problem. So as long as there are viable open alternatives, and some are closed and some are open, great.</p>\n\n\n\n<p>But I don&#8217;t want any company, no matter who it is, you know, in this case maybe a, Cisco is maybe the biggest router company, right? I don&#8217;t want them to be the only one in control of what information can be sent back and forth across the world.</p>\n\n\n\n<p>[00:14:31] Nathan Wrigley: Yeah. I think our conversation is probably going to dwell on the information layer, the bit at the top. So the text that we send and, you know, the images, and the CMS and so on. Now, in the beginning of your presentation, there was a phrase which stuck out because you said, we&#8217;re in a time of unprecedented collaboration, and accelerating human progress is what the internet is kind of all about. It&#8217;s a fairly lofty phrase and I was wondering what you meant by that.</p>\n\n\n\n<p>[00:14:59] Aaron D. Campbell: So first of all, the internet allows for a kind of collaboration that we&#8217;ve never seen before in history, right? Like, collaboration, we all hop on these Zoom calls all the time and think nothing of the fact that I am in an instant virtual video call with people in eight different countries. But that&#8217;s possible. I literally do that almost every single day. People on my team are in the UK, they&#8217;re in Bulgaria, that&#8217;s normal. That was not normal 20 years ago. It was certainly not normal, I guess, what, 40 years ago, pre-internet.</p>\n\n\n\n<p>There is a level of collaboration that can happen now that just never was able to before. And we see that in tons of places. My wife&#8217;s neurologist, I think I gave you this example in some notes that I sent over. She collaborates with neurologists all over the world, live, almost daily. And that&#8217;s mind boggling. But the fact that a neurologist can immediately learn from other specialists, like that is fantastic. That&#8217;s so amazing.</p>\n\n\n\n<p>And so, yeah, it sounds lofty when you put it into words, but the truth is, this is our normal every day, and maybe we&#8217;ve gotten a little used to it. But if you take a step back and look, it&#8217;s amazing what the internet has enabled.</p>\n\n\n\n<p>[00:16:22] Nathan Wrigley: I occasionally, and it really is an example of how quickly you can become, something that is extraordinary becomes completely normal, and you don&#8217;t really expect what&#8217;s going on. But occasionally I have the thought that, I&#8217;ll be looking at my computer, on my phone, and I think what I&#8217;m doing, to my 10-year-old self, was the realm of Star Trek. It was science fiction that there was a device in somebody&#8217;s hand which enabled you to communicate.</p>\n\n\n\n<p>There was a screen which held images on it, and it was all encapsulated in your hand, you know? And obviously Star Trek, well, we&#8217;ve still got a long way to go. We can&#8217;t transport each other across the universe and so on. But it&#8217;s incredibly profound. And the mere fact, just take a look and think about it for a moment. You&#8217;re probably listening to this on a phone, dear listener, and I don&#8217;t know, you&#8217;ve probably got a pair of Bluetooth headphones or something like that.</p>\n\n\n\n<p>This incredible stack of technology, which is now completely normal. You and I collaborating for this episode on a Google Doc. The world has utterly changed, and it really does behoove everyone, once in a while, to take a step back and think, wow, I&#8217;m really lucky.</p>\n\n\n\n<p>[00:17:31] Aaron D. Campbell: I mean, when I was in school, my teacher very specifically would not let us use calculators on tests because, quote, you will not always have a calculator in your pocket. You need to know how to do this. Well, they were wrong. I have a calculator in my pocket, which is actually also a computer connected to every other computer in the world. It&#8217;s astounding how much things have changed.</p>\n\n\n\n<p>[00:17:56] Nathan Wrigley: Yeah, it&#8217;s pretty remarkable. I mean, I guess the next point that I want to raise is that the web, despite the fact that it&#8217;s marvelous in all these ways that we&#8217;ve just described, I think it&#8217;s, well, we&#8217;ve had an era over the last, let&#8217;s say, decade, maybe more, where it feels like the internet has been taken over largely by closed corporate platforms.</p>\n\n\n\n<p>I mean, not to throw any aspersions out there, and not to name only these ones, but the ones which come to mind in my life are Google, dominating search, for example. You know, I basically have outsourced my brain most of the time to Google. I don&#8217;t really think I just Google something, and then trust that what Google gives me back is going to be credible and accurate. And I really give it a hundred percent of that. You know, I don&#8217;t question what it gives back. I assume that the algorithm is doing me justice and doing me a favor.</p>\n\n\n\n<p>And equally things like Facebook over the years, I&#8217;ve invested large amounts of time into that. But it feels like in the last year, so we&#8217;re in 2025, most people have got a slightly different relationship. There&#8217;s maybe a bit more skepticism coming in. We can see the harms that maybe some of these companies are doing. And so this really does feel like a moment where open platforms, WordPress in particular, it&#8217;s an important moment to step up. So really there&#8217;s no question there. It&#8217;s more like, do you have any thoughts about proprietary platforms and their growing dominance?</p>\n\n\n\n<p>[00:19:17] Aaron D. Campbell: Yeah. First of all, I hope that you are right and that in 2025 we&#8217;re seeing some of that, kind of, questioning of whether these closed, for-profit platforms are really doing what&#8217;s best for us. Because I know that they&#8217;re doing what&#8217;s best for them. The question is whether that is also what&#8217;s best for us. Companies like Facebook, like Google, they&#8217;re looking out for themselves. The question is, does that help us?</p>\n\n\n\n<p>You&#8217;re right, we&#8217;ve all outsourced our brain to Google in many ways. I mean, when you talk about, I don&#8217;t know, researching a thing, you don&#8217;t even say, I&#8217;m going to go research it. You say, I&#8217;m going to go Google it. That&#8217;s what that means in our vernacular. And I think that, I hope that, people are really starting to realise, not that that&#8217;s bad because I don&#8217;t think it is, I am actually super thankful that Google makes it so easy for me to learn so many things. I love that.</p>\n\n\n\n<p>But I hope that they, everyone&#8217;s starting to understand some of the potential risks there. Is it good that you don&#8217;t even question whether what Google fed back to you is the right thing? Does Google get to decide what we&#8217;re able to learn or not learn now? Is that healthy for us?</p>\n\n\n\n<p>I would love if people are asking those kinds of questions, because it pushes toward having more alternatives. How do you go check, if you decide that you&#8217;re not sure if Google&#8217;s really looking out for you, how do you go check that? What do you use to make sure that Google&#8217;s still giving you what you ought to get? And if you go looking for that, that&#8217;s good. Going and looking for those alternatives, ensuring that there is a choice keeps us from being locked in, in a way that becomes unhealthy.</p>\n\n\n\n<p>[00:21:11] Nathan Wrigley: I think my intuition is that increasingly these platforms seem to be tied up in profit motives, and so, the example that comes to mind in my head is the algorithmic feed in your social network of choice, really. Insert whichever platform you want there. But the idea that it will maximize engagement at any cost.</p>\n\n\n\n<p>So if it can keep your eyes glued to the screen for another minute, that&#8217;s a win, regardless of whether or not that information that&#8217;s being given to you is good. And I&#8217;m doing air quotes. And so if that were to creep into, for example, Google search, okay, can we keep you on our platform? I know that&#8217;s a silly example because that&#8217;s not really the point of Google, but you get the point.</p>\n\n\n\n<p>And what I&#8217;m wondering is, is profit really kind of the enemy here? Does everything have to be freely done by volunteers for it to be open? Because there&#8217;s this feeling, it feels that there&#8217;s a bit of that in the open source community. You know, if it&#8217;s done by volunteers, if it&#8217;s done for free, if you can access it completely for free, if the platform&#8217;s code is verifiable and open on the web, is that better? So, yeah, sorry there&#8217;s a lot there.</p>\n\n\n\n<p>[00:22:18] Aaron D. Campbell: Well, first of all, I&#8217;ll go ahead and plant my flag on this one. And it&#8217;s maybe not the most popular opinion amongst the hardcore open source people that I honestly spend a lot of time with and work with regularly. But I don&#8217;t think profit is bad. I don&#8217;t. But if that is the core motive and that becomes the only tool that you have is one that is focused on profiting off of you, then yeah, there are concerns.</p>\n\n\n\n<p>If Facebook, you&#8217;re right, or any of these social networks, they want to keep you around as long as they can because that&#8217;s their profit model. However, it doesn&#8217;t mean that you can&#8217;t profit off of open, and I am fine with profit as long as there is open. There are many companies in our space that make really good profit implementing WordPress solutions. That is open. The companies that they are implementing those solutions for own their own data. They can move it wherever they want. That&#8217;s great, even if there&#8217;s profit there.</p>\n\n\n\n<p>And so I don&#8217;t think that profit alone is the enemy, but it does seem like most of these kind of closed solutions, yeah, are by for profit companies that are just looking to profit. And again, I think it comes down to choice. As long as there are enough options out there, you&#8217;re not beholden to just the one model from the one company. You know, social networks is a good example. If there&#8217;s something that&#8217;s a problem with you and Facebook, you can go to some other social network. There are other options. It&#8217;s when it&#8217;s a for-profit and just one option that it really starts to become a problem.</p>\n\n\n\n<p>[00:24:03] Nathan Wrigley: I think it&#8217;s really a difficult thread to get right in our community. Because the WordPress community in particular does seem to have two sides. There&#8217;s the real for-profit side, and obviously we&#8217;re here at WordCamp Asia, and if we were to walk into any of the sponsor booths, there&#8217;s a bunch of companies here. And I imagine the fact that they can sponsor, they&#8217;re making a healthy profit. You know, they&#8217;re sending staff here and they&#8217;ve got a booth and so on.</p>\n\n\n\n<p>But then there&#8217;s also the more, and again, I&#8217;m doing air quotes here, there&#8217;s the more community side, which seem to see that as a bit of a trade off. We&#8217;ve got to have these people here, but on some level it would be better if they weren&#8217;t here. If we could just do the whole thing more non-profit, that would be better. So I feel that the community we&#8217;ve got, that&#8217;s a difficult tightrope to tread.</p>\n\n\n\n<p>[00:24:48] Aaron D. Campbell: It&#8217;s a very difficult tightrope to tread. The way that I thread it, I get the altruistic, if we could do everything just volunteer, but we could also have diverse volunteers and many volunteers with different points of view, and different sort of technical backgrounds, right? So that we could build a thing that works for everyone, that would be great.</p>\n\n\n\n<p>But that&#8217;s really difficult because you see many open source projects that had that and built up and then failed and have sort of disappeared, because it&#8217;s very difficult to have longevity in that. To have people that stay around long enough.</p>\n\n\n\n<p>And so I think that what the for-profit side does in our WordPress space is it helps ensure the longevity because those companies, hosts, for example, are hosting many, many thousands, or tens of thousands, hundreds of thousands of WordPress sites, they&#8217;re making money off of that. And so they have a vested interest in making sure that WordPress continues.</p>\n\n\n\n<p>And so, yeah, there&#8217;s this fine balance between, they&#8217;re actually investing in a way that helps keep the platform going, keep the platform being built, keep the platform improving. But does that also mean that they want some influence in the platform? And I think that that&#8217;s that line you have to tread where profit helps with longevity. It does, it keeps people around. But it also leads towards a desire to influence. And are we watching out for that?</p>\n\n\n\n<p>It is been a question that the WordPress project has been struggling with since its very beginning. I think that we&#8217;ve got it right at times. I think we&#8217;ve got it wrong at times. But I think that by and large, for 20 plus years, we have successfully brought those two things together, in a way that&#8217;s built something pretty amazing.</p>\n\n\n\n<p>[00:26:39] Nathan Wrigley: Yeah. And also if you think about it in the long march of history, the internet is still in its infancy. And these open source platforms, this idea of volunteering your time for a global project is quite a new thing. We are just figuring it out.</p>\n\n\n\n<p>And so whilst you and I are inside the baseball, we hear the arguments from both sides all the time, give it another a hundred years and no doubt things will have bedded down and the arguments would&#8217;ve been done this way and that way, and hopefully things figured out. So to me, it&#8217;s pretty remarkable that we&#8217;ve even got 20 years under our belt. Yeah, there&#8217;s going to be some disagreements along the way.</p>\n\n\n\n<p>[00:27:15] Aaron D. Campbell: The internet sort of, as we know, it&#8217;s about 34 years old. It&#8217;s not been around long when you take a more, sort of, broader historical view alright.</p>\n\n\n\n<p>[00:27:24] Nathan Wrigley: Over the last period of time, I&#8217;m going to say 12, 15 years, something like that, the internet feels like it&#8217;s become a sort of platform. So a good example of that would be social media, so X, Twitter and all the other ones, LinkedIn, and the multitude of ones that have come in to existence and even gone away in some cases. They&#8217;ve obviously got their proprietary technology stack, but it feels to me what you are proposing is that the internet shouldn&#8217;t be a place of platforms, it should be more a place of protocols. And what I mean by that is the underpinning technology.</p>\n\n\n\n<p>So as an example, we could swap out X for something like ActivityPub or the AT Protocol. And then a variety of different platforms can build on top of that, change the UI, change the UX, change the experience for everybody. But we&#8217;d all be able to communicate using that same thing. Have I kind of got that right? Is that what you are hoping for?</p>\n\n\n\n<p>[00:28:14] Aaron D. Campbell: I would love to see more of the platforms on the internet having open standards, open protocols, open data standards at their core. It would be fantastic if something like Twitter, X, whatever it is now, built on top of an open standard. And that was, like they built their own custom experience on top of it. They brought a lot of people together and gave a good experience, but that you could, other companies could also implement that protocol. And again, then you would have choice and options.</p>\n\n\n\n<p>I think that at its core, like the easiest way to sum this up for somebody experiencing it is that, I really think that lock-in is unhealthy. If you can just choose to go somewhere else and you&#8217;re not locked in, then that company needs to keep you around by just serving you better, having a better experience for you, delivering more value to you. Rather than keeping you around because you&#8217;re locked in, and you&#8217;ve built a following there and you can&#8217;t get it anywhere else, et cetera.</p>\n\n\n\n<p>And so, yes, I love all these varieties of platforms focusing in on specific things, you know, like LinkedIn on jobs and professional connections. I wish that more of them shared open standards at their core that could be implemented by others.</p>\n\n\n\n<p>[00:29:35] Nathan Wrigley: Do you think there&#8217;s a realistic chance that these companies will move towards these more open protocols? Because obviously, you know, they weren&#8217;t, they weren&#8217;t there at the beginning. They developed their own code base and soon discovered, gosh, there&#8217;s a real economic lever here. If we can keep eyeballs on our platform, if we can lock data inside the platform so that they can&#8217;t go away, you know, users of LinkedIn, it&#8217;s just, you&#8217;re in LinkedIn, you can&#8217;t get stuff out of LinkedIn, it&#8217;s in there.</p>\n\n\n\n<p>Is there any incentive for them to move to an open protocol? Apart from the fact that it&#8217;s just a morally good position to be in. Because it feels like if we were talking to the executives of LinkedIn, Facebook, et cetera, they would maybe make the right noises, but then they turn around and say, huh, we&#8217;re not going anywhere near that. We want to lock people in. We want everybody to be locked inside our silo.</p>\n\n\n\n<p>[00:30:21] Aaron D. Campbell: Unfortunately, I think that there&#8217;s not a lot of, there&#8217;s not a good enough reason yet for them to move that way. So I don&#8217;t see a lot of the current platforms moving that way, at least not in the short term. I hope that some of these new platforms that are spinning up now, and that will in the near future, that might make use of that. We might be able to see new ones coming on with open standards, but I think it&#8217;s less likely to see existing ones move to that.</p>\n\n\n\n<p>If I were talking to those executives though, and trying to talk about what the benefits would be to them, I think that the main things that I would try to focus on is, if there&#8217;s a chunk of your code, your system that many people are working on and improving, and you don&#8217;t have to fund every single worker on it, that there can be shared benefit from that.</p>\n\n\n\n<p>I talk about this with WordPress and hosts all the time. Yeah, build some of your own custom cool stuff on top of WordPress, but also help improve WordPress itself. Yes, that improves it, the experience at other hosts as well. But if every host is doing that, then everyone&#8217;s getting shared benefit as WordPress gets better across the board. And so these existing platforms could benefit from that, not having to be the only one working on improving the protocols or whatever it is.</p>\n\n\n\n<p>And the other thing is, if you are really confident that you&#8217;re building something great, if you really think you have a great product, then if you have shared protocols, that means you should be able to bring people in from those other companies that have those shared protocols. Because it means it&#8217;s easier to bring people from other places to you. They all tend to focus on the, saving what we have, preventing people from leaving. But if you really think that you can offer the best, then you can also win people in that way. And that&#8217;s sort of the approach that I take when I talk to them, but it&#8217;s difficult.</p>\n\n\n\n<p>[00:32:22] Nathan Wrigley: Yeah, I wonder what the age demographic of these debates is. And what I mean by that is, when it comes to events like WordCamps, if I&#8217;m looking around and being honest, I&#8217;m not really seeing many young people. And I don&#8217;t really know what I mean by young, but it seems like the average age here is not really anywhere near 18.</p>\n\n\n\n<p>And I wonder if the ship has sailed in terms of, let&#8217;s take a typical child in the UK, a 16-year-old child, something like that. The excitement is all around things like TikTok and Instagram. I would imagine that the typical 16-year-old doesn&#8217;t even know that there&#8217;s such a thing as an open protocol. It&#8217;s just more, I want to use that service.</p>\n\n\n\n<p>And I wonder if, well, where we need people to be going with these debates is skewing it more towards young people because they&#8217;re going to be the future. Like you and I, we, well, we&#8217;re a bit older, and we probably understand that a little bit more. I don&#8217;t know where the younger people sit around in all of this, and whether or not their semi addiction to technology is something that we can get in the way of. Or if there&#8217;s an argument to be had, if we need to be going out and talking about these things in schools, encouraging it. Curriculums in colleges and what have you, to be talking about this more.</p>\n\n\n\n<p>[00:33:30] Aaron D. Campbell: I think that you&#8217;re right, that it skews towards the older crowd a little bit. As a parent, I kind of draw a parallel here, right? You can tell a kid, don&#8217;t touch that it&#8217;s hot, don&#8217;t touch that it&#8217;s hot, don&#8217;t touch that it&#8217;s hot. But it&#8217;s when they touch that and get burned, hopefully not too badly, but that&#8217;s when they&#8217;re like, oh, it&#8217;s hot. I need to pay attention to that.</p>\n\n\n\n<p>And I think that that&#8217;s the same kind of struggle that I have conveying this kind of thing to youths right now is. Yeah, they&#8217;re super into all these platforms, but what they haven&#8217;t experienced yet is spending a lot of time building a thing on a platform and then it going away, and them having to start all over.</p>\n\n\n\n<p>And people like you and I, people our age, we probably have. We may have experienced that many times over and, sort of, you can tell them what the risks are, but if they haven&#8217;t felt it yet, maybe they don&#8217;t quite get the importance of it. And I wish that there was an easier way to help them learn from my painful experiences rather than make them experience it themselves. But I definitely struggle with figuring out how to properly convey that in a way that they grasp the levity. I do think it&#8217;s important if we can.</p>\n\n\n\n<p>[00:34:43] Nathan Wrigley: We shared some show notes when we were arranging this episode, and the question that I think hit you, the question that hit home the most was one that I wrote and it went like this. How do we get open, in quotes, to be the default given the market forces that we&#8217;re working against?</p>\n\n\n\n<p>And so again, the example of Facebook, Google, et cetera. You know, they&#8217;ve got deep pockets, an incredible amount of money to spend on ads. They can occupy all the app stores, and they&#8217;ve got incredible lobby groups and so on.</p>\n\n\n\n<p>And you thought, well, I think you thought that that was the question in this interview that was going to be the most interest to you. So how do we get open to be the default given the power of these massive platforms?</p>\n\n\n\n<p>[00:35:22] Aaron D. Campbell: It&#8217;s so difficult, right? I think that I said that this is the billion dollar question. I think that this is kind of the core of what we need to look at and figure out. And I do think that there are some people in our space, in the open space, but even specifically in WordPress, that are trying to figure this out.</p>\n\n\n\n<p>WordPress is amazing in that it&#8217;s put together by volunteers all over the world, and there&#8217;s contributors in every walk of life. But it&#8217;s not coordinated in a way that a company like a Google or a Meta or whatever, it can be coordinated to funnel all of their funds together and invest in, whether it&#8217;s lobbying or advertising or whatever it is.</p>\n\n\n\n<p>We need to bring all this variety of companies, and people in our space together in a coordinated way like that, and that&#8217;s so much more difficult when each one of these companies is their own entity. But you&#8217;re starting to see some groups like the Scale Consortium, some of the enterprise WordPress agencies in our space have formed this consortium to work together to put out this kind of like enterprise level marketing for WordPress at that level.</p>\n\n\n\n<p>And I would love to see more of that kind of thing happening. I think that groups working together is kind of our only chance of trying to compete with some of these companies.</p>\n\n\n\n<p>[00:36:50] Nathan Wrigley: What was the organisation called? The Scale Consortium? Yeah, the Scale Consortium. Okay. And do you have a URL for that?</p>\n\n\n\n<p>[00:36:56] Aaron D. Campbell: I think it&#8217;s scaleconsortium.com.</p>\n\n\n\n<p>[00:36:59] Nathan Wrigley: Okay, I&#8217;ll include that in the show notes. But is this something that you are involved with personally? Does A2 Hosting, or are you involved?</p>\n\n\n\n<p>[00:37:06] Aaron D. Campbell: No. So in my past life, I guess, before I really got into hosting, I ran an agency for many years including working in the enterprise space. And so I&#8217;m just still close to a lot of the other agency folks, agencies that are a part of this or people like Crowd Favorite and Human Made and 10up. They&#8217;re forming this Scale Consortium, and it&#8217;s fantastic. I talk to them about it. Every time I can see them and talk to them I want to talk to them about this thing they&#8217;re doing.</p>\n\n\n\n<p>[00:37:32] Nathan Wrigley: It is kind of interesting and it&#8217;s fairly unique, I think, open source. The capacity of rivals, and again, I&#8217;m using air quotes. Yes, we can get together because, well, you know, Microsoft Bing getting together with Google, that seems really strange. I mean, maybe there&#8217;s a few web interoperability things that those companies, those proprietary companies get together on. But you know, they&#8217;re commercial rivals.</p>\n\n\n\n<p>But in the WordPress space, that kind of thing&#8217;s possible. And in the open source space, that kind of thing is possible, because it&#8217;s more a case of a rising tide carries all boats. So not a case of, well yeah, we&#8217;ve got to kill the competition, kill the opposition. And that&#8217;s curious. And maybe that is the key to its success.</p>\n\n\n\n<p>[00:38:08] Aaron D. Campbell: I think that you&#8217;re right about the rising tide lifting all ships. I think that in our space, WordPress especially, we have this amazing like coopetition thing where it&#8217;s cooperative competitors working together. And I think that that&#8217;s because, as long as we grow the open web, as long as we grow the people, the companies, the websites that are building on top of these open platforms, literally the pie is growing. So you don&#8217;t have to take away somebody else&#8217;s slice of the pie. As the pie grows, you can just have more and more and more of the pie.</p>\n\n\n\n<p>And I think that companies in our space have really realised that. The more that they can get these enterprise level customers be building on us instead of Adobe&#8217;s platform, the more the pie has grown, and their piece of it grows. And so if they all work together, they can grow the pie better. And I think that that&#8217;s, honestly, that just makes it a more friendly, more fun area of the internet to work in.</p>\n\n\n\n<p>[00:39:10] Nathan Wrigley: Do you think WordPress encapsulates a more or less perfect example of the open web? I mean, obviously we&#8217;ve got our own problems, but generally speaking, would you hold up WordPress as a really fine example of the open web or would you say there&#8217;s, I don&#8217;t know, room for improvement?</p>\n\n\n\n<p>[00:39:25] Aaron D. Campbell: I think that there&#8217;s always room for improvement. I would hold up WordPress as a pillar of paving the way, right? Like, we&#8217;ve gotten it wrong a number of times, but we have pushed so hard toward building this open platform that really is truly open.</p>\n\n\n\n<p>I think that there are single points of failure and stuff, even in how we have things set up. But by and large, I think we&#8217;ve done it right. I&#8217;m not going to say we&#8217;re perfect. That would be silly, because I think that we should continue to push to grow and improve. And if you think you&#8217;re perfect, you&#8217;re not motivated to do that. But, yeah, I think that we&#8217;ve done a really good job in WordPress of focusing on that.</p>\n\n\n\n<p>[00:40:05] Nathan Wrigley: Well, hopefully people listening to this podcast, by the time this comes out, maybe Aaron&#8217;s talk will be out on WordPress TV. We&#8217;ll have to see. It&#8217;s a really interesting subject. It speaks to so many of the reasons why I enjoy the internet, and why I&#8217;ve skewed towards open source as opposed to proprietary.</p>\n\n\n\n<p>There&#8217;s just something profoundly meaningful there for me. And let&#8217;s hope that if we would have this conversation in, oh, I don&#8217;t know, 10 years time or something like that, the arguments that you are portraying here, the powerful reasons for going open and not closed, let&#8217;s hope they win.</p>\n\n\n\n<p>[00:40:36] Aaron D. Campbell: Let&#8217;s. That&#8217;s one of the most exciting things I could imagine.</p>\n\n\n\n<p>[00:40:39] Nathan Wrigley: Well, Aaron, thank you so much for chatting to me today. I really appreciate it.</p>\n\n\n\n<p>[00:40:44] Aaron D. Campbell: Thank you for having me. This was fantastic.</p>\n</div>\n\n\n\n<p>On the podcast today we have <a href=\"https://profiles.wordpress.org/aaroncampbell/\">Aaron D. Campbell</a>.</p>\n\n\n\n<p>Aaron is an international speaker, open source advocate, and self-described outgoing introvert. He’s been a regular contributor to WordPress for more than a decade, and is currently Director of Product at <a href=\"https://www.a2hosting.com/\">A2 Hosting</a>.</p>\n\n\n\n<p>His long-standing enthusiasm for WordPress stems from its role as a necessary counterbalance to closed web solutions, providing a vital open-source alternative that fosters accountability among digital platforms. Aaron&#8217;s vision of WordPress&#8217;s importance has fuelled his sustained commitment and excitement for the platform, matching his initial zeal from years ago.</p>\n\n\n\n<p>Today we talk about a topic that&#8217;s integral to Aaron, and likely resonates with many of you listeners, the importance of the open web. With the advent of closed platforms, open standards, and open source have become more crucial than ever.</p>\n\n\n\n<p>Aaron shares his journey in the WordPress space, and how his commitment to the open web has kept him passionate about it over the years. We discuss the evolution of open web concepts, maintaining interoperability, and ensuring your digital creations remain under your control.</p>\n\n\n\n<p>We compare this with the growing dominance of closed corporate platforms, and examine the impact of profit motives, versus the more altruistic goals of open source. Aaron articulates why preserving the openness of the web is essential, not just for innovation but for the entire fabric of global society.</p>\n\n\n\n<p>If you&#8217;re curious about the role of open systems and the future they shape, and why the open web matters now more than ever, this episode is for you.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Useful links</h2>\n\n\n\n<p>Aaron&#8217;s presentation at WordCamp Asia 2025 &#8211; <a href=\"https://asia.wordcamp.org/2025/session/tbd-6/\">The Future: Why the Open Web Matters</a></p>\n\n\n\n<p><a href=\"https://www.a2hosting.com/\">A2 Hosting</a></p>\n\n\n\n<p><a href=\"https://www.w3.org/TR/activitypub/\">ActivityPub</a></p>\n\n\n\n<p><a href=\"https://atproto.com/guides/overview\">AT Protocol</a></p>\n\n\n\n<p><a href=\"https://scaleconsortium.org/\">Scale Consortium</a></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 16 Apr 2025 14:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Nathan Wrigley\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:23;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"Do The Woo Community: Do the Woo is Proudly Sponsoring WordCamp Lisboa 2025\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"https://dothewoo.io/?post_type=blog&p=94622\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"https://dothewoo.io/blog/do-the-woo-is-proudly-sponsoring-wordcamp-lisboa-2025/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:186:\"We are excited to sponsor WordCamp Lisboa on May 16th and 17th, following a Warmup Meetup. I will be at our booth, ready for podcasts, and I encourage attendees to get their tickets now.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 16 Apr 2025 11:50:07 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:24;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:87:\"Do The Woo Community: Bring Federated Events to Your WordPress Site with André Menrath\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=94602\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"https://dothewoo.io/bring-federated-events-to-your-wordpress-site-with-andre-menrath/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:367:\"In Episode 642 of Do the Woo, host Matthias Pfefferle brings us another Open Web Conversations and dives into the world of decentralized social networks and the open web, specifically focusing on the Fediverse, with guest André Menrath. André shares his unconventional journey into software development, driven by his passion for events and democracy, and [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 16 Apr 2025 10:02:22 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:25;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Do The Woo Community: Calendars\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"https://dothewoo.io/?post_type=blog&p=94589\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://dothewoo.io/blog/calendars/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:142:\"BobWP touches on the challenges of managing multiple calendars for 14 shows and 30 hosts, highlighting the need for flexibility in scheduling.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 16 Apr 2025 08:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:26;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"HeroPress: Values, Privileges, and Responsibility – Werte, Privilegien und Verantwortung\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://heropress.com/?post_type=heropress-essays&p=7931\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:146:\"https://heropress.com/essays/values-privileges-and-responsibility/#utm_source=rss&utm_medium=rss&utm_campaign=values-privileges-and-responsibility\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:26941:\"<img width=\"1024\" height=\"512\" src=\"https://heropress.com/wp-content/uploads/3025/04/040925-min-1.jpg\" class=\"attachment-large size-large wp-post-image\" alt=\"Pull Quote: Open source in general, and WordPress in particular, thrives on the very values I was raised with: openness, tolerance, diversity, and solidarity.\" /><p>I was more than surprised when <a href=\"https://hallwaychats.com/episodes/episode-166-a-chat-with-maja-benke/\">Maja Benke</a>, a well-known German community member and strong supporter of accessibility, put me in touch with Topher and HeroPress about Kenya. Of course I had heard of Topher. I had read a few posts from people in the WordPress community on HeroPress, people I’ve met, people who have inspired me, people who are very close to me for various reasons, and even some I disagree with. Nonetheless, they are all true WordPress heroes. I assumed the introduction was about someone from the Kenyan WordPress community who should be featured next on HeroPress or perhaps about proofreading something related to it. Imagine my surprise when Topher told me, “It’s about you!”</p>\n\n\n\n<p>I don’t consider myself a hero, especially not in the WordPress ecosystem. My past contributions have been small and widely scattered here and there. A bit of polyglots, a bit of community work and a bit of WordPress TV. I’ve attended several WordPress meetups and, always with the help of others, founded three of them in Nuremberg, Würzburg, and Diani Beach. I’ve attended multiple WordCamps across Europe sometimes as a volunteer, other times as a speaker, and I was even fortunate enough to sponsor some through my company, AdminPress. I was the lead organiser of WordCamp Nuremberg 2016 and Würzburg 2018, both with incredible teams that made both &#8220;lead&#8221; and &#8220;organize&#8221; easy. </p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>Being part of the organising team of WordCamp Europe in Berlin 2019 was my final major involvement, so to speak, before my contributions took their first hit due to COVID.</p>\n</blockquote>\n\n\n\n<p>If I were to compare myself to football personalities, I would side with Jürgen Klopp, who once described himself as &#8220;<a href=\"https://www.youtube.com/watch?v=J-Re0BihMy4\">The Normal One</a>&#8221; rather than with José Mourinho claiming to be &#8220;The Special One&#8221; (Yes, I’m talking about real football not the sport where the ball is egg-shaped and carried with the hands, yet still called football but I digress…). Again, I’m not a hero. So why should I appear on HeroPress?</p>\n\n\n\n<p>Even more so, I’m turning 60 this year. I started using WordPress in 2005 but only discovered in 2012 that it was more than just a piece of software, but also a community. Let&#8217;s be generous WordPress has been a part of my life for about a quarter of it. And by now, we&#8217;ve come full circle, as WordPress has once again become a mere tool for me just as it was when I first started using it. Perhaps I should briefly explain the other three-quarters of my life to provide some context for my journey with WordPress (and why it is no longer my main focus).</p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"h-tolerance-diversity-and-solidarity\">Tolerance, Diversity, and Solidarity</h2>\n\n\n\n<p>I was born and raised in Neuwied, Germany, a small city that shaped me through its history and principles, perhaps more than I realised at the time.</p>\n\n\n\n<p>In the 17th century, the city’s founder, the Count of Wied, granted religious freedom at a time when many others did the opposite. This openness attracted people of diverse faiths bringing with them knowledge, <a href=\"https://en.wikipedia.org/wiki/David_Roentgen\">craftsmanship</a>, and ideas. Neuwied became a place where diversity was not just accepted but thrived. Tolerance was not an end in itself, but the foundation of cohesion, innovation, and prosperity.</p>\n\n\n\n<p>As the town expanded, surrounding villages became part of Neuwied. One of these villages was Heddesdorf, which was responsible for several nearby villages, including Irlich the very part of town where I grew up. In the mid-19th century, Heddesdorf was led by a mayor named <a href=\"https://en.wikipedia.org/wiki/Friedrich_Wilhelm_Raiffeisen\">Friedrich Wilhelm Raiffeisen</a>, one of the pioneers of the cooperative movement. Facing famine in the rural areas of the Westerwald and Siegerland, he developed a system that enabled small farmers to survive.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p><strong>&#8220;The whole is more than the sum of its parts.&#8221;</strong> <br />— <em>Aristotle</em></p>\n</blockquote>\n\n\n\n<p>By pooling resources and forming a cooperative, farmers could buy seeds at lower costs, share labor and support each other financially, and market their harvest together. All of this was done without the intent of making a profit but instead on the principle of solidarity. To this day, I maintain an account with a bank that bears Raiffeisen’s name, and I am, of course, a member of the cooperative that operates it.</p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"h-modesty-honest-work-and-quality\">Modesty, Honest Work, and Quality</h2>\n\n\n\n<p>My late father was a craftsman, a plumber. He deliberately kept his company small, even when he had opportunities for larger projects. He refused to expand beyond what he could personally oversee, ensuring that the quality of work never suffered. For him, it wasn’t about prestige or unchecked growth. It was about honest work, personal responsibility for his employees, and ensuring that every job was done right.</p>\n\n\n\n<p>As a result, I didn’t grow up in opulence, but in a stable, middle-class environment. I had access to a good education, solid structures, and a supportive atmosphere that encouraged me to forge my own path. These values still shape me today. I have inherited my father’s philosophy except that my craft is digital.</p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"h-a-change-in-perspective-living-and-working-in-kenya\">A Change in Perspective: Living and Working in Kenya</h2>\n\n\n\n<p>I have been living in Kenya for seven years now. This decision was not driven by a desire to leave Germany, but by curiosity, another value rooted in Neuwied. In the 19th century, <a href=\"https://en.wikipedia.org/wiki/Prince_Maximilian_of_Wied-Neuwied\">Prince Maximilian zu Wied</a> traveled across North and South America, and his explorations inspired <a href=\"https://en.wikipedia.org/wiki/Karl_May\">Karl May’s</a> adventure novels, which we devoured as children. Now, I wanted to explore how my skills, values, and profession would hold up in a different context. And I quickly learned that what I had considered &#8220;normal&#8221; was not as universal as I had thought.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>The cultural differences are not just fascinating, they are also deeply educational. </p>\n</blockquote>\n\n\n\n<p>Germany thrives on structure, planning, and efficiency. In Kenya, flexibility, networks, and situational awareness are paramount. Decisions require more context, as they must account for social relationships. Time is experienced differently, and trust is built not through contracts but through consistent presence and reliability over time.</p>\n\n\n\n<p>My tolerance and openness were tested like never before. But differences are not disadvantages—they are an invitation to challenge our own thinking.</p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"h-making-privileges-visible\">Making Privileges Visible</h2>\n\n\n\n<p>It was only in Kenya that I fully grasped how many doors had been open to me without any effort on my part. Not because of my talent, but simply because of my passport, my education, and my social security. And sometimes, simply because my white face afforded me opportunities that others had to fight for.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>Consider WordCamps in Europe, the US, and Asia. These events are a reflection of privilege. </p>\n</blockquote>\n\n\n\n<p>For those of us from these regions, attending such an event—even organising one—is relatively easy. Travel restrictions are minimal, and at worst, it is simply a financial decision—getting a visa, booking a flight, and securing accommodation. Travel times are short, flights are reasonably priced, and thanks to the stability of the WordPress industry, many of us can make a living from this industry and therefore can afford these trips.</p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"h-but-what-does-this-look-like-on-the-african-continent\">But what does this look like on the African continent?</h2>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>Exercise: Open <a href=\"https://www.google.com/maps/place/Greenland/@52.7118639,-34.3120335,15429394m/data=!3m1!1e3!4m6!3m5!1s0x4ea20dbbe3c07715:0x34cf9d830114e218!8m2!3d71.706936!4d-42.604303!16zL20vMDM1djM?entry=ttu&g_ep=EgoyMDI1MDQwMi4xIKXMDSoASAFQAw%3D%3D\">Google Maps</a> and compare the size of <a href=\"https://en.wikipedia.org/wiki/Africa\">Africa</a> to <a href=\"https://en.wikipedia.org/wiki/Greenland\">Greenland</a>. Now, check Wikipedia for the actual area of both.</p>\n</blockquote>\n\n\n\n<p>Surprised? Shocked? Many of us, me at least, were misled in school. The <a href=\"https://en.wikipedia.org/wiki/Mercator_projection\">Mercator projection</a> distorts Africa’s size, making it appear smaller—and therefore less significant—in Western minds. The distances alone across Africa are twice as long as those in Europe or the US. There are no low-cost airlines like in Europe, offering fares that almost resemble the costs of bus tickets. A trip from Kenya to Nigeria—two major economies on the continent—takes a full day, even by plane, with layovers in Ethiopia. Even though WordPress developers in Kenya may earn above the national average thanks to remote work, attending a WordCamp outside their country remains prohibitively expensive. For reference, during the recent WordCamp Nairobi, I met a participant from Cameroon who had spent approximately $1,500 for flights and accommodation. Keep in mind that in Kenya, the average the average income is around $250 per month.</p>\n\n\n\n<p>I wrote about this in more detail on my not very well maintained <a href=\"https://stefankremer.de/2023/11/wordcamp-east-africa/\">personal blog</a>. Even though the original idea dates back to 2019, and the article was written in 2023, everything remains relevant today.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>With Great Power Comes Great Responsibility <br />&#8212; <em>Uncle Ben in Stan Lee’s Spider-Man</em></p>\n</blockquote>\n\n\n\n<p>For me, the meaning shifts when you replace &#8220;power&#8221; with &#8220;privilege.&#8221; What I perceive as power is, in reality, privilege. In my case, it is the privilege of growing up in stable circumstances, with access to education, healthcare, and technology, in a country that has provided me with opportunities many people never receive. And with privilege comes responsibility, not moral superiority, not a saviour complex, but simple questions: What do we do with the resources available to us? How do we share our knowledge? How do we create structures that enable others to&nbsp; also grow?</p>\n\n\n\n<p>This perspective is not always easy to convey, especially in an era where many business models prioritise short-term returns, platform effects, scaling, artificial intelligence—insert any buzzword of your choice. Increasingly, control is being sold as freedom, and systems are being centralised without consideration for democratic processes. As developers, the technologies we create often accelerate these trends. Without a strong foundation of values, we risk becoming complicit.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>Open source in general, and WordPress in particular, thrives on the very values I was raised with: openness, tolerance, diversity, and solidarity. </p>\n</blockquote>\n\n\n\n<p>Without trust, collaboration, and a commitment to pragmatic solutions, open source software cannot evolve. Without a focus on quality and the drive to continually improve, no sustainable business model can be built on open source. Without humility, we leave no space for others whose contributions make the whole greater than the sum of its parts. And without a conscious effort to use privilege meaningfully, or better yet, to dismantle it we will not succeed. Not in the WordPress community. Not in this world.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<h1 class=\"wp-block-heading\">Werte, Privilegien und Verantwortung</h1>\n\n\n\n<p>Ich war mehr als überrascht, als <a href=\"https://hallwaychats.com/episodes/episode-166-a-chat-with-maja-benke/\">Maja Benke</a> &#8211; ein bekanntes deutsches Community-Mitglied und starker Befürworter von a11y &#8211; mich wegen Kenia mit Topher und HeroPress in Kontakt brachte. Ich hatte von Topher gehört. Ein paar Beiträge von Leuten aus der WordPress Community hatte ich auf HeroPress bereits gelesen. Menschen, die ich kennengelernt habe, Menschen, die mich inspiriert haben, Menschen, die mir aus verschiedenen Gründen sehr nahe stehen oder sogar welche, mit denen ich nicht übereinstimme. Dennoch sind sie alle wahre WordPress-Helden. Ich war mir sicher, dass es sich bei dem Kontakt um jemanden aus der kenianischen WordPress-Community handelte, der auf HeroPress gefeatured werden sollte oder ein entsprechender Text den ich vielleicht hätte korrekturlesen sollen. Meine Überraschung hätte kaum größer sein können, als ich hörte: „Es geht um dich!“.</p>\n\n\n\n<p>Ich betrachte mich nicht als Held. Schon gar nicht im WordPress-Ökosystem. Meine Beiträge in der Vergangenheit waren klein und sogar weit gestreut. Ein bisschen hier und da. Ein bisschen Polyglots, ein bisschen Community, ein bisschen WordPress TV. Ich habe mehrere WordPress-Meetups besucht und (immer mit Hilfe von anderen) drei davon in Nürnberg, Würzburg und Diani Beach gegründet. Ich habe an mehreren WordCamps in ganz Europa teilgenommen, ich habe dort voluntiert, bei einigen Talks gegeben und hatte das Glück, einige durch meine Firma AdminPress zu sponsern. Ich war Lead-Organizer des WordCamp Nürnberg 2016 und Würzburg 2018, wobei beide mit tollen Teams aufwarten konnten, die das „Lead“ und „Organize“ leicht machten. </p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>Teil des Organisationsteams von WCEU in Berlin 2019 zu sein, war sozusagen der letzte Akt, bevor meine Contributions durch COVID einen ersten Schlag erhielten.</p>\n</blockquote>\n\n\n\n<p>Wenn ich das auf den Fußball übertragen müsste, würde ich mich eher auf die Seite von Jürgen Klopp stellen, der sich selbst mal als „<a href=\"https://www.youtube.com/watch?v=J-Re0BihMy4\">The Normal One</a>“ bezeichnete, als auf die von „The Special One“ José Mourinho. (ja, ich spreche vom echten Fußball, nicht von dem Sport, bei dem der Ball eiförmig ist und mit den Händen getragen wird, aber trotzdem Fußball heißt &#8211; ich schweife ab …). Aber noch einmal: Ich bin kein Held. So warum sollte ich auf HeroPress erscheinen?</p>\n\n\n\n<p>Außerdem: Ich werde dieses Jahr 60 Jahre alt. Ich habe 2005 mit WordPress angefangen und erst 2012 entdeckt, dass es mehr als nur eine Software ist, sondern auch eine Community. Seien wir mal großzügig: Wir reden hier von etwa einem Viertel meines Lebens, in dem ich WordPress zu einem Teil meines Lebens gemacht habe. Und mittlerweile hat sich der Kreis geschlossen. WordPress ist für mich mehr oder minder wieder zu einem reinen Werkzeug geworden, so wie es einst begonnen hatte. Vielleicht sollte ich die anderen 3/4 meines Lebens (so kurz wie möglich) erklären, um meinen WordPress Weg besser zu verstehen (und warum dieser für mich gerade eher zu Ende ist).</p>\n\n\n\n<h2 class=\"wp-block-heading\">Offenheit, Toleranz und Solidarität</h2>\n\n\n\n<p>Ich bin in Neuwied geboren und aufgewachsen. Einer Stadt, die mich durch ihre deren Geschichte und ihren Prinzipien geprägt hat. Vielleicht mehr, als ich es damals ahnte. Im 17. Jahrhundert gewährte der Gründer der Stadt, <a href=\"https://de.wikipedia.org/wiki/Friedrich_III._(Wied)#Gründung_Neuwieds_und_religiöse_Toleranz\">Graf von Wied</a>, Religionsfreiheit, während viele andere das Gegenteil praktizierten. Diese Haltung zog Menschen verschiedenster Glaubensrichtungen an &#8211; und mit ihnen Wissen, <a href=\"https://de.wikipedia.org/wiki/David_Roentgen\">Handwerk</a> und Ideen. Neuwied wurde zu einem Ort, an dem Vielfalt nicht nur akzeptiert sondern aktiv gelebt wurde. Offenheit war nicht Selbstzweck, sondern Grundlage für Zusammenhalt, Innovation und Wohlstand.</p>\n\n\n\n<p>Die umliegenden Dörfer wurden Teil der Stadt Neuwied, als diese im Laufe der Zeit wuchs. Eines dieser Dörfer war Heddesdorf, das selbst schon für einige andere Dörfer in seiner Nähe zuständig war, wie z.B. Irlich &#8211; genau der Teil der Stadt, in dem ich aufgewachsen bin. In der Mitte des 19. Jahrhunderts wurde Heddesdorf von einem Bürgermeister namens <a href=\"https://de.wikipedia.org/wiki/Friedrich_Wilhelm_Raiffeisen\">Friedrich Wilhelm Raiffeisen</a> geführt. Kein Geringerer als einer der Erfinder der Idee der Genossenschaften. Angesichts der Hungersnot in den ländlichen Gebieten des Westerwalds und des Siegerlands ermöglichte er den Kleinbauern das Überleben.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p><strong>&#8220;Das Ganze ist mehr als die Summe seiner Teile&#8221;</strong> <br />&#8212; <em>Aristoteles</em></p>\n</blockquote>\n\n\n\n<p>In dem sich die Bauern zusammenschlossen und eine Genossenschaft gründeten, konnte Saatgut billiger gekauft werden, Arbeit und Geld wurden gegenseitig verliehen und die Ernte gemeinsam vermarktet. All dies geschah ohne Gewinnabsicht und auf der Grundlage von Solidarität. Noch heute unterhalte ich ein Konto bei einer Bank, die Raiffeisens Namen trägt, und natürlich bin ich Mitglied der Genossenschaft, die die Bank betreibt.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Bescheidenheit, ehrliche Arbeit und Qualität</h2>\n\n\n\n<p>Mein jüngst verstorbener Vater war Handwerker, ein Klempner. Er hielt sein Unternehmen bewusst klein, obwohl er Angebote für mehr und größere Projekte erhielt. Er vermied es mehr Leute einzustellen, um nur noch deren Arbeiten kontrollieren zu müssen und die Qualität der Firma auf&#8217;s Spiel zu setzen. Für ihn ging es nicht um Prestige oder Wachstum um jeden Preis. Es ging um ehrliche Arbeit, die mit den Menschen zu tun hatte, die er beschäftigte, und um die Verantwortung für die Aufträge, die er und sein Team ausführten. Ich bin daher nicht in üppigem Wohlstand aufgewachsen, sondern in einer gut situierten Mittelstandsfamilie. Es fehlte mir aber auch an nichts: ich hatte Zugang zu einer guten Ausbildung, stabilen Strukturen und einem Umfeld, das mich ermutigte, meinen eigenen Weg zu gehen. Auch diese Werte prägen mich auch heute noch. Diese Haltung meines Vaters habe ich mir zu eigen gemacht. Nur das mein Handwerk digital ist.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Perspektivwechsel: Leben und Arbeiten in Kenia</h2>\n\n\n\n<p>Seit sieben Jahren lebe ich nun in Kenia. Die Entscheidung war bewusst – nicht getrieben von einem Aussteigen-Wollen, sondern von Neugier. Auch das ein Neuwieder Wert. <a href=\"https://de.wikipedia.org/wiki/Maximilian_zu_Wied-Neuwied\">Prinz Maximilian zu Wied bereiste</a> in im 19. Jahrhundert Nord- und Südamerika und lieferte mit seinen Forschungen die Vorlagen für <a href=\"https://de.wikipedia.org/wiki/Karl_May\">Karl Mays</a> Abenteuerromane, die wir als Kinder verschlagen. Nun wollte ich entdecken, wie sich meine Fähigkeiten, meine Werte, mein Beruf in einem anderen Kontext bewähren. Und ich sollte herausfinden, ob das, was ich als „normal“ empfand, nicht wirklich so universell ist.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>Die kulturellen Unterschiede sind nicht nur spannend, sie sind extrem lehrreich.</p>\n</blockquote>\n\n\n\n<p>Deutschland ist geprägt von Struktur, Planung, Effizienz. In Kenia zählen Flexibilität, Netzwerke, situatives Handeln. Entscheidungen brauchen oft mehr Kontext, da sie soziale Beziehungen berücksichtigen müssen. Zeit wird anders erlebt, Vertrauen entsteht nicht durch Verträge, sondern durch Präsenz und Zuverlässigkeit über längere Zeiträume. Meine Toleranz und Offenheit wurde mehr denn je auf die Probe gestellt. Aber: Unterschiede sind kein Nachteil. Sie sind eine Einladung, das eigene Denken zu hinterfragen.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Privilegien sichtbar machen</h2>\n\n\n\n<p>Erst in Kenia wurde mir richtig bewusst, wie viele Türen mir offenstanden, ohne dass ich sie mir selbst erkämpfen musste. Nicht, weil ich so talentiert war, sondern weil mein Pass, mein Bildungssystem, meine soziale Absicherung, sogar einfach meine Hautfarbe mir Möglichkeiten eröffneten.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>Sprechen wir für einen Augenblick über die WordCamps Europe, US und Asia. Sind sind Ausdruck dieses Privilegs. </p>\n</blockquote>\n\n\n\n<p>Es fällt uns, die wir aus diesen Regionen stammen vergleichsweise leicht an einem solchen Event teilzunehmen oder gar mit zu organisieren. Wir reisen mit wenigen Beschränkungen in die Länder unserer Wahl. Schlimmstenfalls ist es eine Frage des Geldes um ein Visum zu erhalten, das Flugticket zu bezahlen und für ein paar Tage Unterkunft und Verpflegung zu finden. Die Flüge sind in der Regel überschaubar lang, kosten kein Vermögen und dank einer stabilen WordPress Industrie in der wir arbeiten dürfen sind die Kosten auch leicht zu decken.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Was davon existiert auf dem Afrikanischen Kontintent?</h2>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>Übung: öffne <a href=\"https://www.google.com/maps/place/Greenland/@52.7118639,-34.3120335,15429394m/data=!3m1!1e3!4m6!3m5!1s0x4ea20dbbe3c07715:0x34cf9d830114e218!8m2!3d71.706936!4d-42.604303!16zL20vMDM1djM?entry=ttu&g_ep=EgoyMDI1MDQwMi4xIKXMDSoASAFQAw%3D%3D\">Google Maps</a> und schaue dir die Größe der Landmasse von <a href=\"https://en.wikipedia.org/wiki/Africa\">Afrika</a> und die von <a href=\"https://en.wikipedia.org/wiki/Greenland\">Grönland</a> im Vergleich an. Schlage Wikipedia auf und suche nach der Fläche der beiden genannten Landmassen.</p>\n</blockquote>\n\n\n\n<p>Überrascht? Schockiert? Unsere Sicht von außen auf Afrika wurde uns &#8211; mir zumindest &#8211; in der Schule falsch vermittelt. Die <a href=\"https://de.wikipedia.org/wiki/Mercator-Projektion\">Merkator-Projektion</a> macht den Kontinent kleiner als er ist. Und damit in unseren westlichen Köpfen unbedeutender. Schon alleine die Flugstrecken von einem Ende zum anderen sind doppelt so groß wie die, die wir in den USA oder in Europa zurücklegen. Die Billig-Airlines die z.T. Preise anbieten, die eher nach Busfahrten klingen, gibt es in Afrika nicht. Um von Kenia nach Nigeria &#8211; zwei der großen Volkswirtschaften &#8211; zu kommen, bedarf es auch mit dem Flieger einer Tagesreise mit dem Umweg über Äthiopien. Und auch wenn WordPress Entwickler dank Remote Zugang zu Projekten die Möglichkeiten haben mehr zu verdienen als der Durchschnitts-Kenianer, sind die Kosten für die Teilnahme an einem WordCamp außerhalb des eigenen Landes immer noch prohibitiv hoch. Zum Vergleich: das kenianische Durchschnittseinkommen liegt bei ca. $ 250 pro Monat. Flug und Unterkunft zum WordCamp Nairobi kosteten einen Teilnehmer aus Kamerun ca. $1.500.</p>\n\n\n\n<p>Ich habe auf meinem &#8211; nicht sehr gut gepflegten &#8211; <a href=\"https://stefankremer.de/2023/11/wordcamp-east-africa/\">persönlichen Blog</a> (in englisch) ein bisschen ausführlicher darüber geschrieben.</p>\n\n\n\n<p>Auch wenn die Grundidee aus dem Jahr 2019 ist und der Artikel im Jahr 2023 geschrieben wurde, ist trotzdem alles noch anderthalb Jahre später gültig.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p><strong>„With great power comes great responsibility.“</strong><br />&#8212; *Uncle Ben in Stan Lee’s Spider-Man</p>\n</blockquote>\n\n\n\n<p>Für mich gewinnt er eine neue Bedeutung, wenn man „power“ durch „privilege“ ersetzt. Denn das, was ich als Macht empfinde, ist in Wahrheit ein Privileg: aufgewachsen in stabilen Verhältnissen, mit Zugang zu Bildung, Gesundheitsversorgung, Technologie – in einem Land, das mir Möglichkeiten eröffnet hat, die viele Menschen nie bekommen. Und aus diesem Privileg erwächst Verantwortung. Keine moralische Überlegenheit, keine Rettungsphantasien. Sondern die schlichte Frage: Was machen wir mit den Ressourcen, die uns zur Verfügung stehen? Wie teilen wir unser Wissen? Wie schaffen wir Strukturen, in denen auch andere wachsen können?</p>\n\n\n\n<p>Diese Haltung ist nicht immer leicht zu vermitteln, besonders in Zeiten, in denen viele Geschäftsmodelle auf kurzfristige Rendite, Plattformeffekte, Skalierung, künstliche Intelligenz, …&nbsp;buzzword deiner Wahl … setzen. Es gibt in der Welt aktuell eine Tendenz, Kontrolle als Freiheit zu verkaufen, Systeme zu zentralisieren, ohne demokratische Prozesse mitzudenken. Die Technologien, die wir als Entwickler schaffen helfen dabei, diese Tendenzen zu beschleunigen. Ohne einen stabilen Wertekanon machen wir uns zu Mit-Tätern!</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>Open-Source im Allgemeinen und WordPress im Speziellen lebt genau von den Werten, die mir vermittelt wurden: Offenheit, Toleranz, Diversität, Solidarität.</p>\n</blockquote>\n\n\n\n<p>Ohne Vertrauen, Zusammenarbeit und dem Streben nach pragmatischen Lösungen entwickelt sich Open-Source Software nicht. Und ohne die notwendige Qualität und dem Willen Dinge permanent zu verbessern lässt sich kein erfolgreiches und nachhaltiges Geschäftsmodell auf Open-Source aufbauen. Ohne etwas Bescheidenheit werden wir keinen Platz für die anderen haben, die ebenfalls wertvolle Beiträge liefern und das Ganze zu mehr als seiner Summe machen. Ohne die sinnvolle Nutzung von Privilegien und letztlich den Abbau dieser werden wir es nicht schaffen. Nicht in der WordPress Community. Nicht in dieser Welt.</p>\n<p>The post <a href=\"https://heropress.com/essays/values-privileges-and-responsibility/\">Values, Privileges, and Responsibility &#8211; Werte, Privilegien und Verantwortung</a> appeared first on <a href=\"https://heropress.com\">HeroPress</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 16 Apr 2025 05:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Stefan Kremer\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:27;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:45:\"WordPress.org blog: WordPress 6.8 “Cecil”\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=18701\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:41:\"https://wordpress.org/news/2025/04/cecil/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:74505:\"<img width=\"1024\" height=\"535\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/04/WordPress-6-8-Cecil.png?resize=1024%2C535&ssl=1\" alt=\"Simulated record album featuring a grid of brightly-colored duotone portraits of Cecil Taylor\" class=\"wp-image-18708\" />\n\n\n\n<p>Each WordPress release celebrates an artist who has left an indelible mark on music.&nbsp; WordPress 6.8, code-named “Cecil,” honors the legendary pianist and jazz pioneer Cecil Taylor.</p>\n\n\n\n<p>Classically trained yet relentlessly unconventional, Taylor reimagined the piano as a percussive instrument—layering tone clusters, polyphony, and rhythm into a sound both chaotic and precise. His music defied expectation, finding form in disorder and harmony in dissonance.</p>\n\n\n\n<p>That same spirit drives WordPress 6.8. Embrace its bold new features with the same curiosity and experimentation that defined Cecil’s sound.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Welcome to WordPress 6.8!</h2>\n\n\n\n<p>WordPress 6.8 polishes and refines the tools that you use every day, making your site faster, more secure, and easier to manage.&nbsp; The Style Book now has a structured layout and works with Classic themes, giving you more control over global styles. Speculative loading speeds up navigation by preloading links before users navigate to them, bcrypt hashing strengthens password security automatically, and database optimizations improve performance.</p>\n\n\n\n<p><a href=\"https://wordpress.org/wordpress-6.8.zip\">Download WordPress 6.8 “Cecil”</a></p>\n\n\n\n<h2 class=\"wp-block-heading\">A release polished to a high sheen.</h2>\n\n\n\n<h3 class=\"wp-block-heading\">The Style Book gets a cleaner look—and a few new tricks.</h3>\n\n\n\n<p>The Style Book has a new, structured layout and clearer labels, to make it even easier to edit colors, typography—almost all your site styles—in one place.</p>\n\n\n\n<p>Plus, now you can see it in Classic themes that have editor-styles or a theme.json file.&nbsp; Find the Style Book under Appearance &gt; Design and use it to preview your theme’s evolution, as you edit CSS or make changes in the Customizer.</p>\n\n\n\n<img width=\"900\" height=\"900\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/04/6-8-style-book.png?resize=900%2C900&ssl=1\" alt=\"\" class=\"wp-image-18703\" />\n\n\n\n<h3 class=\"wp-block-heading\">Editor improvements</h3>\n\n\n\n<p>Easier ways to see your options in Data Views, and you can exclude sticky posts from the Query Loop.&nbsp; Plus, you’ll find lots of little improvements in the editor that smooth your way through everything you build.</p>\n\n\n\n<img width=\"900\" height=\"900\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/04/6-8-editor-improvements.png?resize=900%2C900&ssl=1\" alt=\"\" class=\"wp-image-18705\" />\n\n\n\n<h3 class=\"wp-block-heading\">Near-instant page loads, thanks to Speculative Loading</h3>\n\n\n\n<p>In WordPress 6.8, pages load faster than ever.&nbsp; When you or your user hovers over or clicks a link, WordPress may preload the next page, for a smoother, near-instant experience. The system balances speed and efficiency, and you can control how it works, with a plugin or your own code.&nbsp; This feature only works in modern browsers—older ones will simply ignore it without any impact.</p>\n\n\n\n<img width=\"900\" height=\"900\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/04/6-8-speculative-loading-1.png?resize=900%2C900&ssl=1\" alt=\"\" class=\"wp-image-18706\" />\n\n\n\n<h3 class=\"wp-block-heading\">Stronger password security with bcrypt</h3>\n\n\n\n<p>Now passwords are harder to crack with bcrypt hashing, which takes a lot more computing power to break.&nbsp; This strengthens overall security, as do other encryption improvements across WordPress.&nbsp; You don’t need to do anything—everything updates automatically.</p>\n\n\n\n<img width=\"900\" height=\"900\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/04/6-8-stronger-password-security-bcrypt.png?resize=900%2C900&ssl=1\" alt=\"\" class=\"wp-image-18707\" />\n\n\n\n<h3 class=\"wp-block-heading\">Accessibility improvements</h3>\n\n\n\n<p>100+ accessibility fixes and enhancements touch a broad spectrum of the WordPress experience.&nbsp; This release includes fixes to every bundled theme, improvements to the navigation menu management, the customizer, and simplified labeling.&nbsp; The Block Editor has over 70 improvements to blocks, DataViews, and to its overall user experience.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Performance updates</h3>\n\n\n\n<p>WordPress 6.8 packs a wide range of performance fixes and enhancements to speed up everything from editing to browsing.&nbsp; Beyond speculative loading, WordPress 6.8 pays special attention to the block editor, block type registration, and query caching.&nbsp; Plus, imagine never waiting longer than 50 milliseconds—for any interaction.&nbsp; In WordPress 6.8, the Interactivity API takes a first step toward that goal.</p>\n\n\n\n<h3 class=\"wp-block-heading\">And much more</h3>\n\n\n\n<p>For a comprehensive overview of all the new features and enhancements in WordPress 6.8, please visit the feature-showcase website.</p>\n\n\n\n<p><a href=\"https://wordpress.org/download/releases/6-8/\">Check out what’s new</a></p>\n\n\n\n<h2 class=\"wp-block-heading\">Learn more about WordPress 6.8</h2>\n\n\n\n<p><a href=\"https://learn.wordpress.org/\">Learn WordPress</a> is a free resource for new and experienced WordPress users.&nbsp; Learn is stocked with how-to videos on using various features in WordPress, <a href=\"https://learn.wordpress.org/social-learning/\">interactive workshops</a> for exploring topics in-depth, and lesson plans for diving deep into specific areas of WordPress.</p>\n\n\n\n<p>Read the <a href=\"https://wordpress.org/documentation/wordpress-version/version-6.8\">WordPress 6.8 Release Notes</a> for information on installation, enhancements, fixed issues, release contributors, learning resources, and the list of file changes.</p>\n\n\n\n<p>Explore the <a href=\"https://make.wordpress.org/core/2025/03/28/wordpress-6-8-field-guide/\">WordPress 6.8 Field Guide</a>.&nbsp; Learn about the changes in this release with detailed developer notes to help you build with WordPress.</p>\n\n\n\n<h2 class=\"wp-block-heading\">The 6.8 release squad</h2>\n\n\n\n<p>Every release comes to you from a dedicated team of enthusiastic contributors who help keep things on track and moving smoothly.&nbsp; The team that has led 6.8 is a cross-functional group of contributors who are always ready to champion ideas, remove blockers, and resolve issues.</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Release Lead: <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a></li>\n\n\n\n<li>Release Coordination: <a href=\"https://profiles.wordpress.org/jeffpaul/\">Jeffrey Paul</a> and <a href=\"https://profiles.wordpress.org/michelleames/\">Michelle Frechette</a></li>\n\n\n\n<li>Tech Leads: <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a>, <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a>, and <a href=\"https://profiles.wordpress.org/mamaduka/\">George Mamadashvili</a></li>\n\n\n\n<li>Triage Lead: <a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a></li>\n\n\n\n<li>Design Lead: <a href=\"https://profiles.wordpress.org/karmatosed/\">Tammie Lister</a></li>\n\n\n\n<li>Performance Lead: <a href=\"https://profiles.wordpress.org/flixos90/\">Felix Arntz</a></li>\n\n\n\n<li>Test Lead: <a href=\"https://profiles.wordpress.org/krupajnanda/\">Krupa Nanda</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Thank you, contributors</strong></h2>\n\n\n\n<p>The mission of WordPress is to <a href=\"https://wordpress.org/about/\">democratize publishing</a> and embody the <a href=\"https://opensource.org/osd-annotated\">freedoms that come with open source</a>.&nbsp; A global and diverse community of people collaborating to strengthen the software supports this effort.</p>\n\n\n\n<p>WordPress 6.8 reflects the tireless efforts and passion of more than 900 contributors in more than 60 countries all over the world. This release also welcomed over 250 first-time contributors!&nbsp;</p>\n\n\n\n<p>Their collaboration delivered more than 320 enhancements and fixes, ensuring a stable release for all—a testament to the power and capability of the WordPress open source community.</p>\n\n\n<p class=\"has-small-font-size\"><a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a> · <a href=\"https://profiles.wordpress.org/aaronrobertshaw/\">Aaron Robertshaw</a> · <a href=\"https://profiles.wordpress.org/thehercules/\">Aashish Sharma</a> · <a href=\"https://profiles.wordpress.org/webcommsat/\">Abha Thakor</a> · <a href=\"https://profiles.wordpress.org/hiabhaykulkarni/\">Abhay Kulkarni</a> · <a href=\"https://profiles.wordpress.org/abhi3315/\">abhi3315</a> · <a href=\"https://profiles.wordpress.org/adakaleh/\">AdaKaleh</a> · <a href=\"https://profiles.wordpress.org/adamsilverstein/\">Adam Silverstein</a> · <a href=\"https://profiles.wordpress.org/zieladam/\">Adam Zieliński</a> · <a href=\"https://profiles.wordpress.org/adhun/\">Adhun Anand</a> · <a href=\"https://profiles.wordpress.org/adityab98/\">Aditya Bansode</a> · <a href=\"https://profiles.wordpress.org/stromhalm/\">Adrian Jagusch</a> · <a href=\"https://profiles.wordpress.org/aduth/\">aduth</a> · <a href=\"https://profiles.wordpress.org/hemant-ahir/\">Ahir Hemant</a> · <a href=\"https://profiles.wordpress.org/ahmarzaidi/\">Ahmar Zaidi</a> · <a href=\"https://profiles.wordpress.org/chaion07/\">Ahmed Kabir Chaion</a> · <a href=\"https://profiles.wordpress.org/engahmeds3ed/\">Ahmed Saeed</a> · <a href=\"https://profiles.wordpress.org/ahsankhan316/\">Ahsan Khan</a> · <a href=\"https://profiles.wordpress.org/aishwarryapande/\">Aishwarrya Pande</a> · <a href=\"https://profiles.wordpress.org/ajayghaghretiya1/\">Ajay Ghaghretiya</a> · <a href=\"https://profiles.wordpress.org/ajmaurya/\">Ajay Maurya</a> · <a href=\"https://profiles.wordpress.org/ajitbohra/\">Ajit Bohra</a> · <a href=\"https://profiles.wordpress.org/akanshusingh/\">Akanshu Singh</a> · <a href=\"https://profiles.wordpress.org/wildworks/\">Aki Hamano</a> · <a href=\"https://profiles.wordpress.org/atachibana/\">Akira Tachibana</a> · <a href=\"https://profiles.wordpress.org/aks30498/\">aks30498</a> · <a href=\"https://profiles.wordpress.org/akshat2802/\">Akshat Kakkad</a> · <a href=\"https://profiles.wordpress.org/akshaydhere/\">Akshay Dhere</a> · <a href=\"https://profiles.wordpress.org/aljullu/\">Albert Juh&#233; Lluveras</a> · <a href=\"https://profiles.wordpress.org/ralessio/\">Alessio</a> · <a href=\"https://profiles.wordpress.org/xknown/\">Alex Concha</a> · <a href=\"https://profiles.wordpress.org/alexflorisca/\">Alex Florisca</a> · <a href=\"https://profiles.wordpress.org/ajlende/\">Alex Lende</a> · <a href=\"https://profiles.wordpress.org/alexstine/\">Alex Stine</a> · <a href=\"https://profiles.wordpress.org/albigdd/\">Alexander Bigga</a> · <a href=\"https://profiles.wordpress.org/alexandrebuffet/\">Alexandre Buffet</a> · <a href=\"https://profiles.wordpress.org/alexus450/\">Alexei Samarschi</a> · <a href=\"https://profiles.wordpress.org/alexschmitz/\">alexschmitz</a> · <a href=\"https://profiles.wordpress.org/alireyad/\">Ali Akbar Reyad</a> · <a href=\"https://profiles.wordpress.org/firewatch/\">allilevine</a> · <a href=\"https://profiles.wordpress.org/alpipego/\">alpipego</a> · <a href=\"https://profiles.wordpress.org/mrfoxtalbot/\">Alvaro G&#243;mez</a> · <a href=\"https://profiles.wordpress.org/akrocks/\">Amaan Khan</a> · <a href=\"https://profiles.wordpress.org/alh0319/\">Amber Hinds</a> · <a href=\"https://profiles.wordpress.org/amimulihsanmahdi/\">Amimul Ihsan</a> · <a href=\"https://profiles.wordpress.org/amin7/\">Amin</a> · <a href=\"https://profiles.wordpress.org/amitbhosale/\">Amit Bhosale</a> · <a href=\"https://profiles.wordpress.org/amitraj2203/\">Amit Raj</a> · <a href=\"https://profiles.wordpress.org/ammarmassoud/\">Ammar Mohamed Fath Allah Abd-Elaaty Massoud</a> · <a href=\"https://profiles.wordpress.org/amolebonde/\">amolebonde</a> · <a href=\"https://profiles.wordpress.org/anandraj346/\">Anand Raj</a> · <a href=\"https://profiles.wordpress.org/anlino/\">Anders Nor&#233;n</a> · <a href=\"https://profiles.wordpress.org/afercia/\">Andrea Fercia</a> · <a href=\"https://profiles.wordpress.org/awetz583/\">Andrea Roenning</a> · <a href=\"https://profiles.wordpress.org/bowedk/\">Andreas Pedersen</a> · <a href=\"https://profiles.wordpress.org/andraganescu/\">Andrei Draganescu</a> · <a href=\"https://profiles.wordpress.org/euthelup/\">Andrei Lupu</a> · <a href=\"https://profiles.wordpress.org/nacin/\">Andrew Nacin</a> · <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a> · <a href=\"https://profiles.wordpress.org/andrewserong/\">Andrew Serong</a> · <a href=\"https://profiles.wordpress.org/andrewssanya/\">Andrew Ssanya</a> · <a href=\"https://profiles.wordpress.org/rarst/\">Andrey \"Rarst\" Savchenko</a> · <a href=\"https://profiles.wordpress.org/oandregal/\">André Maneiro</a> · <a href=\"https://profiles.wordpress.org/afragen/\">Andy Fragen</a> · <a href=\"https://profiles.wordpress.org/rilwis/\">Anh Tran</a> · <a href=\"https://profiles.wordpress.org/wpgurudev/\">Ankit Gade</a> · <a href=\"https://profiles.wordpress.org/ankit-k-gupta/\">Ankit K Gupta</a> · <a href=\"https://profiles.wordpress.org/ankitkumarshah/\">Ankit Kumar Shah</a> · <a href=\"https://profiles.wordpress.org/ankitmaru/\">Ankit Panchal</a> · <a href=\"https://profiles.wordpress.org/ankitpatel1578/\">Ankit Patel</a> · <a href=\"https://profiles.wordpress.org/anmolverma404/\">Anmol Verma</a> · <a href=\"https://profiles.wordpress.org/annchichi/\">annchichi</a> · <a href=\"https://profiles.wordpress.org/annebovelett/\">Anne-Mieke Bovelett</a> · <a href=\"https://profiles.wordpress.org/annezazu/\">annezazu</a> · <a href=\"https://profiles.wordpress.org/antpb/\">Anthony Burchell</a> · <a href=\"https://profiles.wordpress.org/ahortin/\">Anthony Hortin</a> · <a href=\"https://profiles.wordpress.org/antonvlasenko/\">Anton Vlasenko</a> · <a href=\"https://profiles.wordpress.org/anujrathore24/\">Anuj Singh</a> · <a href=\"https://profiles.wordpress.org/anveshika/\">Anveshika Srivastava</a> · <a href=\"https://profiles.wordpress.org/aristath/\">Ari Stathopoulos</a> · <a href=\"https://profiles.wordpress.org/arielmaidana/\">Ariel Maidana</a> · <a href=\"https://profiles.wordpress.org/arnaudbroes/\">arnaudbroes</a> · <a href=\"https://profiles.wordpress.org/arnoutblueshell/\">arnoutblueshell</a> · <a href=\"https://profiles.wordpress.org/artemiosans/\">Artemio Morales</a> · <a href=\"https://profiles.wordpress.org/mohonchandra/\">Asish Chandra Mohon</a> · <a href=\"https://profiles.wordpress.org/auareyou/\">Au</a> · <a href=\"https://profiles.wordpress.org/autotutorial/\">autotutorial</a> · <a href=\"https://profiles.wordpress.org/ayeshrajans/\">Ayesh Karunaratne</a> · <a href=\"https://profiles.wordpress.org/beryldlg/\">B&#233;ryl de La Grandi&#232;re</a> · <a href=\"https://profiles.wordpress.org/neo2k23/\">BackuPs</a> · <a href=\"https://profiles.wordpress.org/balub/\">Balu B</a> · <a href=\"https://profiles.wordpress.org/barry/\">Barry</a> · <a href=\"https://profiles.wordpress.org/beafialho/\">Beatriz Fialho</a> · <a href=\"https://profiles.wordpress.org/benharri/\">ben</a> · <a href=\"https://profiles.wordpress.org/scruffian/\">Ben Dwyer</a> · <a href=\"https://profiles.wordpress.org/bsutcliffe/\">Ben Sutcliffe</a> · <a href=\"https://profiles.wordpress.org/benazeer/\">Benazeer</a> · <a href=\"https://profiles.wordpress.org/benniledl/\">Benedikt Ledl</a> · <a href=\"https://profiles.wordpress.org/benjamin_zekavica/\">Benjamin Zekavica</a> · <a href=\"https://profiles.wordpress.org/benoitchantre/\">Benoit Chantre</a> · <a href=\"https://profiles.wordpress.org/bernhard-reiter/\">bernhard-reiter</a> · <a href=\"https://profiles.wordpress.org/berislavgrgicak/\">Bero</a> · <a href=\"https://profiles.wordpress.org/bgermann/\">bgermann</a> · <a href=\"https://profiles.wordpress.org/albatross10/\">Bhavik Kalpesh</a> · <a href=\"https://profiles.wordpress.org/bijit027/\">Bijit Deb</a> · <a href=\"https://profiles.wordpress.org/birgire/\">Birgir Erlendsson (birgire)</a> · <a href=\"https://profiles.wordpress.org/bph/\">Birgit Pauli-Haack</a> · <a href=\"https://profiles.wordpress.org/rainynewt/\">Bishal Shrestha</a> · <a href=\"https://profiles.wordpress.org/bjornw/\">BjornW</a> · <a href=\"https://profiles.wordpress.org/bluantinoo/\">bluantinoo</a> · <a href=\"https://profiles.wordpress.org/bogdanungureanu/\">BogdanUngureanu</a> · <a href=\"https://profiles.wordpress.org/bor0/\">Boro Sitnikovski</a> · <a href=\"https://profiles.wordpress.org/veryard/\">Brad</a> · <a href=\"https://profiles.wordpress.org/bjorsch/\">Brad Jorsch</a> · <a href=\"https://profiles.wordpress.org/bradleyt/\">Bradley Taylor</a> · <a href=\"https://profiles.wordpress.org/bhubbard/\">Brandon Hubbard</a> · <a href=\"https://profiles.wordpress.org/bpayton/\">Brandon Payton</a> · <a href=\"https://profiles.wordpress.org/brettsmason/\">brettsmason</a> · <a href=\"https://profiles.wordpress.org/brevilo/\">brevilo</a> · <a href=\"https://profiles.wordpress.org/ironprogrammer/\">Brian Alexander</a> · <a href=\"https://profiles.wordpress.org/bacoords/\">Brian Coords</a> · <a href=\"https://profiles.wordpress.org/masteradhoc/\">Brian Haas</a> · <a href=\"https://profiles.wordpress.org/bronsonquick/\">Bronson Quick</a> · <a href=\"https://profiles.wordpress.org/bschneidewind/\">Bryan Schneidewind</a> · <a href=\"https://profiles.wordpress.org/burakkaptan/\">burak</a> · <a href=\"https://profiles.wordpress.org/burnuser/\">burnuser</a> · <a href=\"https://profiles.wordpress.org/snicco/\">Calvin Alkan</a> · <a href=\"https://profiles.wordpress.org/calvinalkan/\">Calvin Alkan</a> · <a href=\"https://profiles.wordpress.org/cbravobernal/\">Carlos Bravo</a> · <a href=\"https://profiles.wordpress.org/poena/\">Carolina Nymark</a> · <a href=\"https://profiles.wordpress.org/cbirdsong/\">cbirdsong</a> · <a href=\"https://profiles.wordpress.org/cgastrell/\">cgastrell</a> · <a href=\"https://profiles.wordpress.org/charleslf/\">charleslf</a> · <a href=\"https://profiles.wordpress.org/mel_cha/\">chiilog (Chiaki Okamoto)</a> · <a href=\"https://profiles.wordpress.org/chintanmachhi207/\">chintanmachhi207</a> · <a href=\"https://profiles.wordpress.org/chrico/\">ChriCo</a> · <a href=\"https://profiles.wordpress.org/chriscct7/\">chriscct7</a> · <a href=\"https://profiles.wordpress.org/chrisdotdotdot/\">chrisdotdotdot</a> · <a href=\"https://profiles.wordpress.org/apermo/\">Christoph Daum</a> · <a href=\"https://profiles.wordpress.org/claimableperch/\">claimableperch</a> · <a href=\"https://profiles.wordpress.org/claudiulodro/\">Claudiu Lodromanean</a> · <a href=\"https://profiles.wordpress.org/codebymikey/\">codebymikey</a> · <a href=\"https://profiles.wordpress.org/codersantosh/\">codersantosh</a> · <a href=\"https://profiles.wordpress.org/costdev/\">Colin Stewart</a> · <a href=\"https://profiles.wordpress.org/colind/\">ColinD</a> · <a href=\"https://profiles.wordpress.org/colinleroy/\">colinleroy</a> · <a href=\"https://profiles.wordpress.org/coreyw/\">Corey Worrell</a> · <a href=\"https://profiles.wordpress.org/courane01/\">Courtney Robertson</a> · <a href=\"https://profiles.wordpress.org/cbusquets1989/\">Cris Busquets</a> · <a href=\"https://profiles.wordpress.org/mitogh/\">Crisoforo Gaspar</a> · <a href=\"https://profiles.wordpress.org/ctienshi/\">ctienshi</a> · <a href=\"https://profiles.wordpress.org/cweiske/\">cweiske</a> · <a href=\"https://profiles.wordpress.org/didierjm/\">cybeardjm</a> · <a href=\"https://profiles.wordpress.org/coquardcyr/\">Cyrille</a> · <a href=\"https://profiles.wordpress.org/css31/\">Cyrille Sanson</a> · <a href=\"https://profiles.wordpress.org/daedalon/\">Daedalon</a> · <a href=\"https://profiles.wordpress.org/acketon/\">Dakota Chichester</a> · <a href=\"https://profiles.wordpress.org/dalleyne/\">Damien Alleyne</a> · <a href=\"https://profiles.wordpress.org/colorful-tones/\">Damon Cook</a> · <a href=\"https://profiles.wordpress.org/dpknauss/\">Dan Knauss</a> · <a href=\"https://profiles.wordpress.org/danht/\">danht</a> · <a href=\"https://profiles.wordpress.org/daniguardiola/\">Dani Guardiola</a> · <a href=\"https://profiles.wordpress.org/danielbachhuber/\">Daniel Bachhuber</a> · <a href=\"https://profiles.wordpress.org/danielpost/\">Daniel Post</a> · <a href=\"https://profiles.wordpress.org/talldanwp/\">Daniel Richards</a> · <a href=\"https://profiles.wordpress.org/mte90/\">Daniele Scasciafratte</a> · <a href=\"https://profiles.wordpress.org/danielpataki/\">danielpataki</a> · <a href=\"https://profiles.wordpress.org/danielvann/\">danielvann</a> · <a href=\"https://profiles.wordpress.org/darerodz/\">darerodz</a> · <a href=\"https://profiles.wordpress.org/dhewercorus/\">Darren Hewer</a> · <a href=\"https://profiles.wordpress.org/davelo/\">Dave Loodts</a> · <a href=\"https://profiles.wordpress.org/davilera/\">David Aguilera</a> · <a href=\"https://profiles.wordpress.org/darnado/\">David Arnado</a> · <a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a> · <a href=\"https://profiles.wordpress.org/davidbinda/\">David Biňovec</a> · <a href=\"https://profiles.wordpress.org/davidabowman/\">David Bowman</a> · <a href=\"https://profiles.wordpress.org/dpcalhoun/\">David Calhoun</a> · <a href=\"https://profiles.wordpress.org/dafargier/\">David FARGIER</a> · <a href=\"https://profiles.wordpress.org/dlh/\">David Herrera</a> · <a href=\"https://profiles.wordpress.org/david-innes/\">David Innes</a> · <a href=\"https://profiles.wordpress.org/justlevine/\">David Levine</a> · <a href=\"https://profiles.wordpress.org/daviedr/\">David Rozando</a> · <a href=\"https://profiles.wordpress.org/dshanske/\">David Shanske</a> · <a href=\"https://profiles.wordpress.org/get_dave/\">David Smith</a> · <a href=\"https://profiles.wordpress.org/daymobrew/\">daymobrew</a> · <a href=\"https://profiles.wordpress.org/deadduck169/\">deadduck169</a> · <a href=\"https://profiles.wordpress.org/dsas/\">Dean Sas</a> · <a href=\"https://profiles.wordpress.org/dkarfa/\">Debabrata Karfa</a> · <a href=\"https://profiles.wordpress.org/debarghyabanerjee/\">DEBARGHYA BANERJEE</a> · <a href=\"https://profiles.wordpress.org/deeppatel8950/\">Deep Patel</a> · <a href=\"https://profiles.wordpress.org/deepakrohilla/\">Deepak Rohilla</a> · <a href=\"https://profiles.wordpress.org/realloc/\">Dennis Ploetner</a> · <a href=\"https://profiles.wordpress.org/dmsnell/\">Dennis Snell</a> · <a href=\"https://profiles.wordpress.org/densinakum/\">Densi Nakum</a> · <a href=\"https://profiles.wordpress.org/designsimply/\">designsimply</a> · <a href=\"https://profiles.wordpress.org/devansh2002/\">Devansh Chaudhary</a> · <a href=\"https://profiles.wordpress.org/dhananjaykuber/\">Dhananjay Kuber</a> · <a href=\"https://profiles.wordpress.org/dharm1025/\">Dharmesh Patel</a> · <a href=\"https://profiles.wordpress.org/dhavalkapadane/\">Dhaval Kapadane</a> · <a href=\"https://profiles.wordpress.org/dheeraj2995/\">Dheeraj Bhosale</a> · <a href=\"https://profiles.wordpress.org/dhrumilk/\">Dhrumil Kumbhani</a> · <a href=\"https://profiles.wordpress.org/dhruvang21/\">Dhruvang21</a> · <a href=\"https://profiles.wordpress.org/dhruvishah2203/\">Dhruvi Shah</a> · <a href=\"https://profiles.wordpress.org/dhruvik18/\">Dhruvik Malaviya</a> · <a href=\"https://profiles.wordpress.org/dilipom13/\">dilip</a> · <a href=\"https://profiles.wordpress.org/dilipbheda/\">Dilip Bheda</a> · <a href=\"https://profiles.wordpress.org/diliphingarajiya/\">Dilip Hingarajiya</a> · <a href=\"https://profiles.wordpress.org/dilip2615/\">Dilip Modhavadiya</a> · <a href=\"https://profiles.wordpress.org/dingguodong/\">DingGuodong</a> · <a href=\"https://profiles.wordpress.org/dd32/\">Dion Hulse</a> · <a href=\"https://profiles.wordpress.org/divyeshk71/\">Divyesh_kakrecha</a> · <a href=\"https://profiles.wordpress.org/djcowan/\">dj.cowan</a> · <a href=\"https://profiles.wordpress.org/mediaformat/\">Django</a> · <a href=\"https://profiles.wordpress.org/dnnsjsk/\">dnnsjsk</a> · <a href=\"https://profiles.wordpress.org/doekenorg/\">Doeke Norg</a> · <a href=\"https://profiles.wordpress.org/dogee/\">dogee</a> · <a href=\"https://profiles.wordpress.org/domenicdenicola/\">domenicdenicola</a> · <a href=\"https://profiles.wordpress.org/ocean90/\">Dominik Schilling</a> · <a href=\"https://profiles.wordpress.org/donalirl/\">donalirl</a> · <a href=\"https://profiles.wordpress.org/dooperweb/\">dooperweb</a> · <a href=\"https://profiles.wordpress.org/dougwollison/\">Doug Wollison</a> · <a href=\"https://profiles.wordpress.org/dretzlaff/\">dretzlaff</a> · <a href=\"https://profiles.wordpress.org/drewapicture/\">Drew Jaynes</a> · <a href=\"https://profiles.wordpress.org/drivingralle/\">Drivingralle</a> · <a href=\"https://profiles.wordpress.org/dwainm/\">Dwain Maralack</a> · <a href=\"https://profiles.wordpress.org/earthman100/\">Earthman Media</a> · <a href=\"https://profiles.wordpress.org/eclev91/\">eclev91</a> · <a href=\"https://profiles.wordpress.org/eddystile/\">Eddy</a> · <a href=\"https://profiles.wordpress.org/cais/\">Edward Caissie</a> · <a href=\"https://profiles.wordpress.org/eceleste/\">efc</a> · <a href=\"https://profiles.wordpress.org/talksina/\">Elena Brescacin</a> · <a href=\"https://profiles.wordpress.org/elizaan36/\">elizaan36</a> · <a href=\"https://profiles.wordpress.org/ellatrix/\">Ella van Durpe</a> · <a href=\"https://profiles.wordpress.org/codex-m/\">Emerson Maningo</a> · <a href=\"https://profiles.wordpress.org/emlebrun/\">Emilie LEBRUN</a> · <a href=\"https://profiles.wordpress.org/eatse/\">Emmanuel Ats&#233;</a> · <a href=\"https://profiles.wordpress.org/lopo/\">Enrico Battocchi</a> · <a href=\"https://profiles.wordpress.org/ericdye/\">Eric Dye</a> · <a href=\"https://profiles.wordpress.org/ethitter/\">Erick Hitter</a> · <a href=\"https://profiles.wordpress.org/codekraft/\">Erik</a> · <a href=\"https://profiles.wordpress.org/kebbet/\">Erik</a> · <a href=\"https://profiles.wordpress.org/im3dabasia1/\">Eshaan Dabasiya</a> · <a href=\"https://profiles.wordpress.org/estelaris/\">Estela Rueda</a> · <a href=\"https://profiles.wordpress.org/eherman24/\">Evan Herman</a> · <a href=\"https://profiles.wordpress.org/etobiesen/\">Even Tobiesen</a> · <a href=\"https://profiles.wordpress.org/fabiankaegy/\">Fabian Kägy</a> · <a href=\"https://profiles.wordpress.org/gaambo/\">Fabian Todt</a> · <a href=\"https://profiles.wordpress.org/faisalahammad/\">Faisal Ahammad</a> · <a href=\"https://profiles.wordpress.org/faisal03/\">Faisal Alvi</a> · <a href=\"https://profiles.wordpress.org/fazyshah/\">Faizan Nabi</a> · <a href=\"https://profiles.wordpress.org/flixos90/\">Felix Arntz</a> · <a href=\"https://profiles.wordpress.org/ffffelix/\">Felix Renicks</a> · <a href=\"https://profiles.wordpress.org/finntown/\">finntown</a> · <a href=\"https://profiles.wordpress.org/firoz2456/\">Firoz Sabaliya</a> · <a href=\"https://profiles.wordpress.org/francina/\">Francesca Marano</a> · <a href=\"https://profiles.wordpress.org/franciscabusas22/\">Francis Cabusas</a> · <a href=\"https://profiles.wordpress.org/fcoveram/\">Francisco</a> · <a href=\"https://profiles.wordpress.org/frankbiganski/\">Frank B.</a> · <a href=\"https://profiles.wordpress.org/frank-klein/\">Frank Klein</a> · <a href=\"https://profiles.wordpress.org/franz00/\">Fransisca H</a> · <a href=\"https://profiles.wordpress.org/frkly/\">frkly</a> · <a href=\"https://profiles.wordpress.org/fushar/\">fushar</a> · <a href=\"https://profiles.wordpress.org/fxbenard/\">fxbenard</a> · <a href=\"https://profiles.wordpress.org/gaellebesson/\">gaellebesson</a> · <a href=\"https://profiles.wordpress.org/gajendrasingh/\">Gajendra Singh</a> · <a href=\"https://profiles.wordpress.org/galibh/\">Galib Hayder</a> · <a href=\"https://profiles.wordpress.org/ecgan/\">Gan Eng Chin</a> · <a href=\"https://profiles.wordpress.org/garrett-eclipse/\">Garrett Hyder</a> · <a href=\"https://profiles.wordpress.org/garyj/\">Gary Jones</a> · <a href=\"https://profiles.wordpress.org/pento/\">Gary Pendergast</a> · <a href=\"https://profiles.wordpress.org/soulseekah/\">Gennady Kovshenin</a> · <a href=\"https://profiles.wordpress.org/mamaduka/\">George Mamadashvili</a> · <a href=\"https://profiles.wordpress.org/geriux/\">Gerardo Pacheco</a> · <a href=\"https://profiles.wordpress.org/ghinamt/\">ghinamt</a> · <a href=\"https://profiles.wordpress.org/girishpanchal/\">Girish Panchal</a> · <a href=\"https://profiles.wordpress.org/giuriani/\">giuriani</a> · <a href=\"https://profiles.wordpress.org/glendaviesnz/\">Glen Davies</a> · <a href=\"https://profiles.wordpress.org/glynnquelch/\">Glynn Quelch</a> · <a href=\"https://profiles.wordpress.org/ingeniumed/\">Gopal Krishnan</a> · <a href=\"https://profiles.wordpress.org/grantmkin/\">Grant M. Kinney</a> · <a href=\"https://profiles.wordpress.org/gziolo/\">Greg Ziółkowski</a> · <a href=\"https://profiles.wordpress.org/gregbenz/\">gregbenz</a> · <a href=\"https://profiles.wordpress.org/grgarside/\">grgarside</a> · <a href=\"https://profiles.wordpress.org/guido07111975/\">Guido</a> · <a href=\"https://profiles.wordpress.org/guillaumeturpin/\">Guillaume TURPIN</a> · <a href=\"https://profiles.wordpress.org/gulamdastgir04/\">Gulamdastgir Momin</a> · <a href=\"https://profiles.wordpress.org/priethor/\">H&#233;ctor Prieto</a> · <a href=\"https://profiles.wordpress.org/gencmedya/\">Halil Kaya</a> · <a href=\"https://profiles.wordpress.org/yahaly/\">Halyna Yampolska</a> · <a href=\"https://profiles.wordpress.org/hameem1102/\">Hameem Mahdad Kader</a> · <a href=\"https://profiles.wordpress.org/hanneslsm/\">Hannes Leismann</a> · <a href=\"https://profiles.wordpress.org/hage/\">Hans-Gerd Gerhards</a> · <a href=\"https://profiles.wordpress.org/hareesh-pillai/\">Hareesh S</a> · <a href=\"https://profiles.wordpress.org/harrym/\">harrym</a> · <a href=\"https://profiles.wordpress.org/harshalkadu/\">Harshal Kadu</a> · <a href=\"https://profiles.wordpress.org/hazdiego/\">Haz</a> · <a href=\"https://profiles.wordpress.org/hekuranredev/\">hekuranredev</a> · <a href=\"https://profiles.wordpress.org/helen/\">Helen Hou-Sandi</a> · <a href=\"https://profiles.wordpress.org/hdkothari81/\">Hemant Kothari</a> · <a href=\"https://profiles.wordpress.org/iamarinoh/\">Henrique Iamarino</a> · <a href=\"https://profiles.wordpress.org/henrywright/\">Henry Wright</a> · <a href=\"https://profiles.wordpress.org/rvouill/\">Herve THOMAS</a> · <a href=\"https://profiles.wordpress.org/hideishi/\">hideishi</a> · <a href=\"https://profiles.wordpress.org/kurudrive/\">Hidekazu Ishikawa</a> · <a href=\"https://profiles.wordpress.org/hilayt24/\">Hilay Trivedi</a> · <a href=\"https://profiles.wordpress.org/panchalhimani711/\">Himani Panchal</a> · <a href=\"https://profiles.wordpress.org/abcd95/\">Himanshu Pathak</a> · <a href=\"https://profiles.wordpress.org/hbhalodia/\">Hit Bhalodia</a> · <a href=\"https://profiles.wordpress.org/hiteshhuptechweb/\">Hitesh Dhokai</a> · <a href=\"https://profiles.wordpress.org/hovhanneshovakimyan/\">Hovhannes Hovakimyan</a> · <a href=\"https://profiles.wordpress.org/hueitan/\">hueitan</a> · <a href=\"https://profiles.wordpress.org/humanify/\">humanify</a> · <a href=\"https://profiles.wordpress.org/hussain896/\">hussain896</a> · <a href=\"https://profiles.wordpress.org/huubl/\">huubl</a> · <a href=\"https://profiles.wordpress.org/huzaifaalmesbah/\">Huzaifa Al Mesbah</a> · <a href=\"https://profiles.wordpress.org/iandunn/\">Ian Dunn</a> · <a href=\"https://profiles.wordpress.org/ilovecats7/\">ilovecats7</a> · <a href=\"https://profiles.wordpress.org/imranhasanraaz/\">Imran</a> · <a href=\"https://profiles.wordpress.org/imranh920/\">Imran Hossain (a11n)</a> · <a href=\"https://profiles.wordpress.org/indirabiswas27/\">Indira Biswas</a> · <a href=\"https://profiles.wordpress.org/indithemes/\">indithemes</a> · <a href=\"https://profiles.wordpress.org/isabel_brison/\">Isabel Brison</a> · <a href=\"https://profiles.wordpress.org/iseulde/\">iseulde</a> · <a href=\"https://profiles.wordpress.org/isuke01/\">Isu</a> · <a href=\"https://profiles.wordpress.org/ivankristianto/\">Ivan Kristianto</a> · <a href=\"https://profiles.wordpress.org/moxie/\">Jack</a> · <a href=\"https://profiles.wordpress.org/jagirbahesh/\">Jagir Bahesh</a> · <a href=\"https://profiles.wordpress.org/jainil07/\">Jainil Shah</a> · <a href=\"https://profiles.wordpress.org/whyisjake/\">Jake Spurlock</a> · <a href=\"https://profiles.wordpress.org/jameskoster/\">James Koster</a> · <a href=\"https://profiles.wordpress.org/jhmonroe/\">James Monroe</a> · <a href=\"https://profiles.wordpress.org/jopdop30/\">James Payne</a> · <a href=\"https://profiles.wordpress.org/imaginarymedia/\">James Robinson</a> · <a href=\"https://profiles.wordpress.org/q0rban/\">James Sansbury</a> · <a href=\"https://profiles.wordpress.org/jamieblomerus/\">Jamie Blomerus</a> · <a href=\"https://profiles.wordpress.org/jammycakes/\">jammycakes</a> · <a href=\"https://profiles.wordpress.org/lysyjan87/\">Jan Lys&#253;</a> · <a href=\"https://profiles.wordpress.org/janak007/\">janak Kaneriya</a> · <a href=\"https://profiles.wordpress.org/janusdev/\">janusdev</a> · <a href=\"https://profiles.wordpress.org/jsnajdr/\">Jarda Snajdr</a> · <a href=\"https://profiles.wordpress.org/jarekmorawski/\">jarekmorawski</a> · <a href=\"https://profiles.wordpress.org/boogah/\">Jason Cosper</a> · <a href=\"https://profiles.wordpress.org/madtownlems/\">Jason LeMahieu (MadtownLems)</a> · <a href=\"https://profiles.wordpress.org/jasonsa19/\">Jason Sauerwald</a> · <a href=\"https://profiles.wordpress.org/javiercasares/\">Javier Casares</a> · <a href=\"https://profiles.wordpress.org/shovan_jaya/\">Jayaram</a> · <a href=\"https://profiles.wordpress.org/jdahir0789/\">JD Ahir</a> · <a href=\"https://profiles.wordpress.org/jdnd/\">jdnd</a> · <a href=\"https://profiles.wordpress.org/audrasjb/\">Jean-Baptiste Audras</a> · <a href=\"https://profiles.wordpress.org/krokodok/\">Jeff Chi</a> · <a href=\"https://profiles.wordpress.org/maverick3x6/\">Jeff Golenski</a> · <a href=\"https://profiles.wordpress.org/jffng/\">Jeff Ong</a> · <a href=\"https://profiles.wordpress.org/jeffpaul/\">Jeff Paul</a> · <a href=\"https://profiles.wordpress.org/jeflopodev/\">jeflopo</a> · <a href=\"https://profiles.wordpress.org/jdy68/\">Jenny Dupuy</a> · <a href=\"https://profiles.wordpress.org/jepperask/\">jepperask</a> · <a href=\"https://profiles.wordpress.org/jeremyfelt/\">Jeremy Felt</a> · <a href=\"https://profiles.wordpress.org/jeremy80/\">jeremy80</a> · <a href=\"https://profiles.wordpress.org/jeremyroman/\">jeremyroman</a> · <a href=\"https://profiles.wordpress.org/jeryj/\">jeryj</a> · <a href=\"https://profiles.wordpress.org/jessedyck/\">jessedyck</a> · <a href=\"https://profiles.wordpress.org/luminuu/\">Jessica Lyschik</a> · <a href=\"https://profiles.wordpress.org/jigar-bhanushali/\">Jigar Bhanushali</a> · <a href=\"https://profiles.wordpress.org/jigar9998/\">Jigar Panchal</a> · <a href=\"https://profiles.wordpress.org/jnweaver/\">jnweaver</a> · <a href=\"https://profiles.wordpress.org/jartes/\">Joan Artes</a> · <a href=\"https://profiles.wordpress.org/jodamo5/\">jodamo5</a> · <a href=\"https://profiles.wordpress.org/joedolson/\">Joe Dolson</a> · <a href=\"https://profiles.wordpress.org/joehoyle/\">Joe Hoyle</a> · <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a> · <a href=\"https://profiles.wordpress.org/joecsmalley/\">joecsmalley</a> · <a href=\"https://profiles.wordpress.org/joen/\">Joen Asmussen</a> · <a href=\"https://profiles.wordpress.org/timse201/\">Johannes J&#252;lg</a> · <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a> · <a href=\"https://profiles.wordpress.org/johnjamesjacoby/\">John James Jacoby</a> · <a href=\"https://profiles.wordpress.org/johnregan3/\">John Regan</a> · <a href=\"https://profiles.wordpress.org/arrcorona/\">Jomar Jay</a> · <a href=\"https://profiles.wordpress.org/jomonthomaslobo1/\">Jomon Thomas Lobo</a> · <a href=\"https://profiles.wordpress.org/jonsurrell/\">Jon Surrell</a> · <a href=\"https://profiles.wordpress.org/psykro/\">Jonathan Bossenger</a> · <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a> · <a href=\"https://profiles.wordpress.org/jongycastillo/\">Jong</a> · <a href=\"https://profiles.wordpress.org/n2erjo00/\">Joni Erkkil&#228;</a> · <a href=\"https://profiles.wordpress.org/spacedmonkey/\">Jonny Harris</a> · <a href=\"https://profiles.wordpress.org/jonnyauk/\">jonnyauk</a> · <a href=\"https://profiles.wordpress.org/joomskys/\">joomskys</a> · <a href=\"https://profiles.wordpress.org/joostdevalk/\">Joost de Valk</a> · <a href=\"https://profiles.wordpress.org/jordesign/\">jordesign</a> · <a href=\"https://profiles.wordpress.org/jorgefilipecosta/\">Jorge Costa</a> · <a href=\"https://profiles.wordpress.org/josvelasco/\">Jos Velasco</a> · <a href=\"https://profiles.wordpress.org/josevarghese/\">Jose Varghese</a> · <a href=\"https://profiles.wordpress.org/blogitsolutions/\">Josef Seidl</a> · <a href=\"https://profiles.wordpress.org/josephscott/\">Joseph Scott</a> · <a href=\"https://profiles.wordpress.org/joshuawold/\">Joshua Wold</a> · <a href=\"https://profiles.wordpress.org/jottevanger/\">jottevanger</a> · <a href=\"https://profiles.wordpress.org/jokanane/\">Jouni Kananen</a> · <a href=\"https://profiles.wordpress.org/joyously/\">Joy</a> · <a href=\"https://profiles.wordpress.org/juanfra/\">Juan Aldasoro</a> · <a href=\"https://profiles.wordpress.org/juanbuis/\">juanbuis</a> · <a href=\"https://profiles.wordpress.org/juanmaguitar/\">JuanMa Garrido</a> · <a href=\"https://profiles.wordpress.org/juanwp22/\">juanwp22</a> · <a href=\"https://profiles.wordpress.org/jules-colle/\">Jules Colle</a> · <a href=\"https://profiles.wordpress.org/julianmar/\">julianmar</a> · <a href=\"https://profiles.wordpress.org/juliemoynat/\">Julie Moynat</a> · <a href=\"https://profiles.wordpress.org/jrf/\">Juliette Reinders Folmer</a> · <a href=\"https://profiles.wordpress.org/juliobox/\">Julio Potier</a> · <a href=\"https://profiles.wordpress.org/greenshady/\">Justin Tadlock</a> · <a href=\"https://profiles.wordpress.org/juzar/\">Juzar</a> · <a href=\"https://profiles.wordpress.org/kadamwhite/\">K. Adam White</a> · <a href=\"https://profiles.wordpress.org/kafleg/\">KafleG</a> · <a href=\"https://profiles.wordpress.org/kevin940726/\">Kai Hao</a> · <a href=\"https://profiles.wordpress.org/kaitohm/\">Kaito Hanamori</a> · <a href=\"https://profiles.wordpress.org/ikamal/\">Kamal Hosen</a> · <a href=\"https://profiles.wordpress.org/kapasias/\">KAP ASIAs</a> · <a href=\"https://profiles.wordpress.org/kapilpaul/\">Kapil Paul</a> · <a href=\"https://profiles.wordpress.org/karlgroves/\">karlgroves</a> · <a href=\"https://profiles.wordpress.org/karolmanijak/\">Karol Manijak</a> · <a href=\"https://profiles.wordpress.org/karthickmurugan/\">Karthick Murugan</a> · <a href=\"https://profiles.wordpress.org/thekt12/\">Karthik Thayyil</a> · <a href=\"https://profiles.wordpress.org/karthikeya01/\">Karthikeya Bethu</a> · <a href=\"https://profiles.wordpress.org/kasparsd/\">Kaspars</a> · <a href=\"https://profiles.wordpress.org/zoonini/\">Kathryn Presner</a> · <a href=\"https://profiles.wordpress.org/kausaralm/\">Kausar Alam</a> · <a href=\"https://profiles.wordpress.org/keithdevon/\">keithdevon</a> · <a href=\"https://profiles.wordpress.org/kel-dc/\">Kel Santiago-Pilarski</a> · <a href=\"https://profiles.wordpress.org/ryelle/\">Kelly Choyce-Dwan</a> · <a href=\"https://profiles.wordpress.org/tinypixel/\">Kelly Mears</a> · <a href=\"https://profiles.wordpress.org/keoshi/\">keoshi</a> · <a href=\"https://profiles.wordpress.org/ketanniruke/\">Ketan Niruke</a> · <a href=\"https://profiles.wordpress.org/patelketan/\">Ketan Patel</a> · <a href=\"https://profiles.wordpress.org/kevinlearynet/\">Kevinleary.net</a> · <a href=\"https://profiles.wordpress.org/kharisblank/\">Kharis Sulistiyono</a> · <a href=\"https://profiles.wordpress.org/kirasong/\">Kira Schroder</a> · <a href=\"https://profiles.wordpress.org/kjroelke/\">KJ Roelke</a> · <a href=\"https://profiles.wordpress.org/kkmuffme/\">kkmuffme</a> · <a href=\"https://profiles.wordpress.org/knutsp/\">Knut Sparhell</a> · <a href=\"https://profiles.wordpress.org/kohheepeace/\">kohheepeace</a> · <a href=\"https://profiles.wordpress.org/kmgalanakis/\">Konstantinos Galanakis</a> · <a href=\"https://profiles.wordpress.org/xkon/\">Konstantinos Xenos</a> · <a href=\"https://profiles.wordpress.org/kristastevens/\">kristastevens</a> · <a href=\"https://profiles.wordpress.org/krupajnanda/\">Krupa Nanda</a> · <a href=\"https://profiles.wordpress.org/krupaly2k/\">Krupal Lakhia</a> · <a href=\"https://profiles.wordpress.org/laurelfulford/\">laurelfulford</a> · <a href=\"https://profiles.wordpress.org/wplmillet/\">Laurent MILLET</a> · <a href=\"https://profiles.wordpress.org/lakshmananphp/\">Lax Mariappan</a> · <a href=\"https://profiles.wordpress.org/laxman-prajapati/\">Laxman Prajapati</a> · <a href=\"https://profiles.wordpress.org/lcarevic/\">lcarevic</a> · <a href=\"https://profiles.wordpress.org/leecollings/\">Lee</a> · <a href=\"https://profiles.wordpress.org/leewillis77/\">Lee Willis</a> · <a href=\"https://profiles.wordpress.org/leedxw/\">leedxw</a> · <a href=\"https://profiles.wordpress.org/0mirka00/\">Lena Morita</a> · <a href=\"https://profiles.wordpress.org/lenasterg/\">lenasterg</a> · <a href=\"https://profiles.wordpress.org/leszeks/\">leszeks</a> · <a href=\"https://profiles.wordpress.org/leup/\">leup</a> · <a href=\"https://profiles.wordpress.org/levskipg/\">levskipg</a> · <a href=\"https://profiles.wordpress.org/lgladdy/\">Liam Gladdy</a> · <a href=\"https://profiles.wordpress.org/louislaugesen/\">Louis</a> · <a href=\"https://profiles.wordpress.org/louwie17/\">Lourens</a> · <a href=\"https://profiles.wordpress.org/lovesoni1999/\">Love Soni</a> · <a href=\"https://profiles.wordpress.org/thelovekesh/\">Lovekesh Kumar</a> · <a href=\"https://profiles.wordpress.org/lovewpmu/\">lovewpmu</a> · <a href=\"https://profiles.wordpress.org/lovor/\">Lovro Hrust</a> · <a href=\"https://profiles.wordpress.org/dreadlox/\">Lox</a> · <a href=\"https://profiles.wordpress.org/ltrihan/\">ltrihan</a> · <a href=\"https://profiles.wordpress.org/gigitux/\">Luigi Teschio</a> · <a href=\"https://profiles.wordpress.org/zaguiini/\">Luis Felipe Zaguini</a> · <a href=\"https://profiles.wordpress.org/luisherranz/\">luisherranz</a> · <a href=\"https://profiles.wordpress.org/wpfed/\">Lukasz</a> · <a href=\"https://profiles.wordpress.org/lukecavanagh/\">Luke Cavanagh</a> · <a href=\"https://profiles.wordpress.org/gadelhas/\">M&#225;rio Santos</a> · <a href=\"https://profiles.wordpress.org/maciejmackowiak/\">maciejmackowiak</a> · <a href=\"https://profiles.wordpress.org/madhudollu/\">Madhu Dollu</a> · <a href=\"https://profiles.wordpress.org/madpeter/\">madpeter</a> · <a href=\"https://profiles.wordpress.org/magdarogier/\">Magda Rogier</a> · <a href=\"https://profiles.wordpress.org/onemaggie/\">Maggie Cabrera</a> · <a href=\"https://profiles.wordpress.org/mp518/\">Mahesh Prajapati</a> · <a href=\"https://profiles.wordpress.org/mai21/\">Mai</a> · <a href=\"https://profiles.wordpress.org/maikelraow/\">maikelraow</a> · <a href=\"https://profiles.wordpress.org/travel_girl/\">Maja Benke</a> · <a href=\"https://profiles.wordpress.org/mkrndmane/\">Makarand G. Mane</a> · <a href=\"https://profiles.wordpress.org/tomdxw/\">mallorydxw-old</a> · <a href=\"https://profiles.wordpress.org/manfcarlo/\">manfcarlo</a> · <a href=\"https://profiles.wordpress.org/manojmaharrshi/\">Manoj Maharrshi</a> · <a href=\"https://profiles.wordpress.org/manzoorwanijk/\">Manzoor Wani (a11n)</a> · <a href=\"https://profiles.wordpress.org/mdxfr/\">Marc</a> · <a href=\"https://profiles.wordpress.org/fullofcaffeine/\">Marcelo de Moraes Serpa</a> · <a href=\"https://profiles.wordpress.org/marchalyoan/\">marchalyoan</a> · <a href=\"https://profiles.wordpress.org/afmarchetti/\">Marchetti Design</a> · <a href=\"https://profiles.wordpress.org/mciampini/\">Marco Ciampini</a> · <a href=\"https://profiles.wordpress.org/mariayohana/\">Maria Yohana</a> · <a href=\"https://profiles.wordpress.org/marian1/\">marian1</a> · <a href=\"https://profiles.wordpress.org/nuryko/\">Marianna</a> · <a href=\"https://profiles.wordpress.org/plari/\">Marie</a> · <a href=\"https://profiles.wordpress.org/tyxla/\">Marin Atanasov</a> · <a href=\"https://profiles.wordpress.org/marineevain/\">Marine EVAIN</a> · <a href=\"https://profiles.wordpress.org/nofearinc/\">Mario Peshev</a> · <a href=\"https://profiles.wordpress.org/santosguillamot/\">Mario Santos</a> · <a href=\"https://profiles.wordpress.org/clorith/\">Marius L. J.</a> · <a href=\"https://profiles.wordpress.org/markhowellsmead/\">Mark Howells-Mead</a> · <a href=\"https://profiles.wordpress.org/mapk/\">Mark Uraine</a> · <a href=\"https://profiles.wordpress.org/mark-k/\">Mark-k</a> · <a href=\"https://profiles.wordpress.org/martinkrcho/\">martin.krcho</a> · <a href=\"https://profiles.wordpress.org/marybaum/\">Mary Baum</a> · <a href=\"https://profiles.wordpress.org/immasud/\">Masud Rana</a> · <a href=\"https://profiles.wordpress.org/paapst/\">Mathieu Paapst</a> · <a href=\"https://profiles.wordpress.org/mmaattiiaass/\">Matias Benedetto</a> · <a href=\"https://profiles.wordpress.org/matveb/\">Matias Ventura</a> · <a href=\"https://profiles.wordpress.org/iammattthomas/\">Matt (Thomas) Miklic</a> · <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a> · <a href=\"https://profiles.wordpress.org/mattyrob/\">Matt Robinson</a> · <a href=\"https://profiles.wordpress.org/mattwest/\">Matt West</a> · <a href=\"https://profiles.wordpress.org/kinggmobb/\">Matthew</a> · <a href=\"https://profiles.wordpress.org/mboynes/\">Matthew Boynes</a> · <a href=\"https://profiles.wordpress.org/mattryanwalker/\">mattryanwalker</a> · <a href=\"https://profiles.wordpress.org/azouamauriac/\">Mauriac AZOUA</a> · <a href=\"https://profiles.wordpress.org/maximemeganck/\">Maxime Meganck</a> · <a href=\"https://profiles.wordpress.org/maximebj/\">maximebj</a> · <a href=\"https://profiles.wordpress.org/mayanktripathi32/\">Mayank Tripathi</a> · <a href=\"https://profiles.wordpress.org/mayur8991/\">Mayur Prajapati</a> · <a href=\"https://profiles.wordpress.org/faithcoder/\">Md Abdullah Al Arif</a> · <a href=\"https://profiles.wordpress.org/hmbashar/\">Md Abul Bashar</a> · <a href=\"https://profiles.wordpress.org/itsmhrahman/\">Md Hafijur Rahman</a> · <a href=\"https://profiles.wordpress.org/kawsar007/\">MD Kawsar Chowdhury</a> · <a href=\"https://profiles.wordpress.org/mehdi01/\">Md Mahdi Hasan</a> · <a href=\"https://profiles.wordpress.org/mdibrahimk48/\">Md. Ibrahim Khalil</a> · <a href=\"https://profiles.wordpress.org/najmulsaju/\">Md. Najmul Islam</a> · <a href=\"https://profiles.wordpress.org/mehedi_csit/\">Md.Mehedi Hasan</a> · <a href=\"https://profiles.wordpress.org/mdviralsampat/\">mdviralsampat</a> · <a href=\"https://profiles.wordpress.org/megane9988/\">megane9988</a> · <a href=\"https://profiles.wordpress.org/leeseoftbc/\">MelissaH</a> · <a href=\"https://profiles.wordpress.org/metropolis_john/\">metropolis_john</a> · <a href=\"https://profiles.wordpress.org/mdawaffe/\">Michael Adams (mdawaffe)</a> · <a href=\"https://profiles.wordpress.org/mburridge/\">Michael Burridge</a> · <a href=\"https://profiles.wordpress.org/websiteredev/\">Michael Willman</a> · <a href=\"https://profiles.wordpress.org/czapla/\">Michal Czaplinski</a> · <a href=\"https://profiles.wordpress.org/michelleames/\">Michelle Frechette</a> · <a href=\"https://profiles.wordpress.org/micromadness/\">micromadness</a> · <a href=\"https://profiles.wordpress.org/mcsf/\">Miguel Fonseca</a> · <a href=\"https://profiles.wordpress.org/mmtr86/\">Miguel Torres</a> · <a href=\"https://profiles.wordpress.org/mijotj/\">Mijo T J</a> · <a href=\"https://profiles.wordpress.org/simison/\">Mikael Korpela</a> · <a href=\"https://profiles.wordpress.org/mbijon/\">Mike Bijon</a> · <a href=\"https://profiles.wordpress.org/ritterml/\">Mike Ritter</a> · <a href=\"https://profiles.wordpress.org/mikinc860/\">Mikin Chauhan</a> · <a href=\"https://profiles.wordpress.org/milana_cap/\">Milana Cap</a> · <a href=\"https://profiles.wordpress.org/milindmore22/\">Milind More</a> · <a href=\"https://profiles.wordpress.org/mimitips/\">mimi</a> · <a href=\"https://profiles.wordpress.org/369work/\">miroku</a> · <a href=\"https://profiles.wordpress.org/presstoke/\">Mitchell Austin</a> · <a href=\"https://profiles.wordpress.org/modi2918/\">Modi Sahil</a> · <a href=\"https://profiles.wordpress.org/antwortzeit/\">modulbuero</a> · <a href=\"https://profiles.wordpress.org/aboelfotoh/\">Mohamed Aboelfotoh Mohamed</a> · <a href=\"https://profiles.wordpress.org/mohitdadhich10/\">Mohit Dadhich</a> · <a href=\"https://profiles.wordpress.org/mojorob/\">mojorob</a> · <a href=\"https://profiles.wordpress.org/jucaduca/\">Morais Junior</a> · <a href=\"https://profiles.wordpress.org/mosescursor/\">Moses Cursor Ssebunya</a> · <a href=\"https://profiles.wordpress.org/mosne/\">Mosne / Paolo Tesei</a> · <a href=\"https://profiles.wordpress.org/mr660/\">mr660</a> · <a href=\"https://profiles.wordpress.org/mreishus/\">mreishus</a> · <a href=\"https://profiles.wordpress.org/mrwweb/\">mrwweb</a> · <a href=\"https://profiles.wordpress.org/mtdkei/\">mt</a> · <a href=\"https://profiles.wordpress.org/muddassirnasim/\">Muddassir Rahman Nasim</a> · <a href=\"https://profiles.wordpress.org/devmuhib/\">Muhibul Haque</a> · <a href=\"https://profiles.wordpress.org/mujuonly/\">mujuonly</a> · <a href=\"https://profiles.wordpress.org/mukesh27/\">Mukesh Panchal</a> · <a href=\"https://profiles.wordpress.org/mukulsingh27/\">Mukul Singh</a> · <a href=\"https://profiles.wordpress.org/my1xt/\">My1</a> · <a href=\"https://profiles.wordpress.org/n8finch/\">n8finch</a> · <a href=\"https://profiles.wordpress.org/assassinateur/\">Nadir Seghir</a> · <a href=\"https://profiles.wordpress.org/nandow/\">nandow</a> · <a href=\"https://profiles.wordpress.org/nanisamireddy/\">NANI SAMIREDDY</a> · <a href=\"https://profiles.wordpress.org/narenin/\">Narendra Sishodiya</a> · <a href=\"https://profiles.wordpress.org/nareshbheda/\">Naresh Bheda</a> · <a href=\"https://profiles.wordpress.org/nataliat2004/\">Natalia T</a> · <a href=\"https://profiles.wordpress.org/nathanatmoz/\">Nathan Johnson</a> · <a href=\"https://profiles.wordpress.org/navneet/\">navneet</a> · <a href=\"https://profiles.wordpress.org/navi161/\">Navneet Kaur</a> · <a href=\"https://profiles.wordpress.org/nhrrob/\">Nazmul Hasan Robin</a> · <a href=\"https://profiles.wordpress.org/greatislander/\">Ned Zimmerman</a> · <a href=\"https://profiles.wordpress.org/neotrope/\">neotrope</a> · <a href=\"https://profiles.wordpress.org/mcqueen22/\">NerQuiles</a> · <a href=\"https://profiles.wordpress.org/krstarica/\">net</a> · <a href=\"https://profiles.wordpress.org/ndiego/\">Nick Diego</a> · <a href=\"https://profiles.wordpress.org/nickgalvez/\">nickgalvez</a> · <a href=\"https://profiles.wordpress.org/undefinedfr/\">Nicolas RIVIERE</a> · <a href=\"https://profiles.wordpress.org/nicolasleroy/\">nicolasleroy</a> · <a href=\"https://profiles.wordpress.org/nidhidhandhukiya/\">nidhidhandhukiya</a> · <a href=\"https://profiles.wordpress.org/ntsekouras/\">Nik Tsekouras</a> · <a href=\"https://profiles.wordpress.org/smushytaco/\">Nikan Radan</a> · <a href=\"https://profiles.wordpress.org/nikitasolanki1812/\">Nikita Solanki</a> · <a href=\"https://profiles.wordpress.org/nikunj8866/\">Nikunj Hatkar</a> · <a href=\"https://profiles.wordpress.org/snilesh/\">Nilesh Shiragave</a> · <a href=\"https://profiles.wordpress.org/nirajgirixd/\">Niraj Giri</a> · <a href=\"https://profiles.wordpress.org/nithins53/\">Nithin SreeRaj</a> · <a href=\"https://profiles.wordpress.org/mrtortai/\">Noam Eppel</a> · <a href=\"https://profiles.wordpress.org/noruzzaman/\">Noruzzaman</a> · <a href=\"https://profiles.wordpress.org/nosilver4u/\">nosilver4u</a> · <a href=\"https://profiles.wordpress.org/oceantober/\">oceantober</a> · <a href=\"https://profiles.wordpress.org/finalwebsites/\">Olaf Lederer</a> · <a href=\"https://profiles.wordpress.org/oglekler/\">Olga Gleckler</a> · <a href=\"https://profiles.wordpress.org/domainsupport/\">Oliver Campion</a> · <a href=\"https://profiles.wordpress.org/jbkkd/\">Omer Korner</a> · <a href=\"https://profiles.wordpress.org/arzola/\">Oscar Arzola</a> · <a href=\"https://profiles.wordpress.org/groenroos/\">Oskari Groenroos</a> · <a href=\"https://profiles.wordpress.org/othernoel/\">othernoel</a> · <a href=\"https://profiles.wordpress.org/ov3rfly/\">Ov3rfly</a> · <a href=\"https://profiles.wordpress.org/paaljoachim/\">Paal Joachim Romdahl</a> · <a href=\"https://profiles.wordpress.org/pampfelimetten/\">pampfelimetten</a> · <a href=\"https://profiles.wordpress.org/parinpanjari/\">Parin Panjari</a> · <a href=\"https://profiles.wordpress.org/dparthj/\">Parth Dodiya</a> · <a href=\"https://profiles.wordpress.org/parthvataliya/\">Parth vataliya</a> · <a href=\"https://profiles.wordpress.org/swissspidy/\">Pascal Birchler</a> · <a href=\"https://profiles.wordpress.org/casiepa/\">Pascal Casier</a> · <a href=\"https://profiles.wordpress.org/pateljaymin/\">Patel Jaymin</a> · <a href=\"https://profiles.wordpress.org/lumiblog/\">Patrick Lumumba</a> · <a href=\"https://profiles.wordpress.org/eartboard/\">Paul</a> · <a href=\"https://profiles.wordpress.org/pbearne/\">Paul Bearne</a> · <a href=\"https://profiles.wordpress.org/pbiron/\">Paul Biron</a> · <a href=\"https://profiles.wordpress.org/bbpaule/\">Paul English</a> · <a href=\"https://profiles.wordpress.org/paulkevan/\">Paul Kevan</a> · <a href=\"https://profiles.wordpress.org/paullb/\">paullb</a> · <a href=\"https://profiles.wordpress.org/psrpinto/\">Paulo Pinto</a> · <a href=\"https://profiles.wordpress.org/paulopmt1/\">Paulo Trentin</a> · <a href=\"https://profiles.wordpress.org/pavanpatil1/\">Pavan Patil</a> · <a href=\"https://profiles.wordpress.org/creadordev/\">Pawan Kumar</a> · <a href=\"https://profiles.wordpress.org/pedromendonca/\">Pedro Mendon&#231;a</a> · <a href=\"https://profiles.wordpress.org/provenself/\">Peter Rubin</a> · <a href=\"https://profiles.wordpress.org/westi/\">Peter Westwood</a> · <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a> · <a href=\"https://profiles.wordpress.org/peter8nss/\">peter8nss</a> · <a href=\"https://profiles.wordpress.org/peterdavehello/\">peterdavehello</a> · <a href=\"https://profiles.wordpress.org/petitphp/\">petitphp</a> · <a href=\"https://profiles.wordpress.org/philliproth/\">philliproth</a> · <a href=\"https://profiles.wordpress.org/philwebs/\">philwebs</a> · <a href=\"https://profiles.wordpress.org/pitamdey/\">Pitam Dey</a> · <a href=\"https://profiles.wordpress.org/pixlpirate/\">pixlpirate</a> · <a href=\"https://profiles.wordpress.org/podpirate/\">podpirate</a> · <a href=\"https://profiles.wordpress.org/poojabhimani/\">Pooja Bhimani</a> · <a href=\"https://profiles.wordpress.org/pooja1210/\">Pooja Killekar (Muchandikar)</a> · <a href=\"https://profiles.wordpress.org/pooja9712/\">pooja9712</a> · <a href=\"https://profiles.wordpress.org/praful2111/\">Praful Patel</a> · <a href=\"https://profiles.wordpress.org/prasadkarmalkar/\">Prasad Karmalkar</a> · <a href=\"https://profiles.wordpress.org/prashant/\">prashant</a> · <a href=\"https://profiles.wordpress.org/pmbaldha/\">Prashant Baldha</a> · <a href=\"https://profiles.wordpress.org/contactprashantpp/\">Prashant Patil</a> · <a href=\"https://profiles.wordpress.org/prathamesh24/\">Prathamesh Shirke</a> · <a href=\"https://profiles.wordpress.org/prathameshbhagat1511/\">prathameshbhagat1511</a> · <a href=\"https://profiles.wordpress.org/pkbhatt/\">Pratik Bhatt</a> · <a href=\"https://profiles.wordpress.org/pratikgandhi/\">Pratik Gandhi</a> · <a href=\"https://profiles.wordpress.org/pratiklondhe/\">Pratik Londhe</a> · <a href=\"https://profiles.wordpress.org/presskopp/\">Presskopp</a> · <a href=\"https://profiles.wordpress.org/priyank9033/\">Priyank</a> · <a href=\"https://profiles.wordpress.org/pushpenderindia/\">Pushpender Singh</a> · <a href=\"https://profiles.wordpress.org/itsjonq/\">Q</a> · <a href=\"https://profiles.wordpress.org/qhaensler/\">qhaensler</a> · <a href=\"https://profiles.wordpress.org/rfischmann/\">Rafael Fischmann</a> · <a href=\"https://profiles.wordpress.org/rahulsprajapati/\">Rahul Prajapati</a> · <a href=\"https://profiles.wordpress.org/imrraaj/\">Raj Patel</a> · <a href=\"https://profiles.wordpress.org/rajat1192/\">Rajat Patel</a> · <a href=\"https://profiles.wordpress.org/raj198/\">Rajendra Patel</a> · <a href=\"https://profiles.wordpress.org/rajendrapatilraj/\">Rajendra Patil</a> · <a href=\"https://profiles.wordpress.org/rkradadiya/\">Rajesh Radadiya</a> · <a href=\"https://profiles.wordpress.org/rajeshrathodwp/\">Rajesh Rathod</a> · <a href=\"https://profiles.wordpress.org/rajinsharwar/\">Rajin Sharwar</a> · <a href=\"https://profiles.wordpress.org/rahmohn/\">Ramon Ahnert</a> · <a href=\"https://profiles.wordpress.org/rcorrales/\">Ramon Corrales</a> · <a href=\"https://profiles.wordpress.org/ramonopoly/\">Ramon James</a> · <a href=\"https://profiles.wordpress.org/ravigadhiyawp/\">Ravi Gadhiya</a> · <a href=\"https://profiles.wordpress.org/redkite/\">redkite</a> · <a href=\"https://profiles.wordpress.org/rehanali/\">Rehan Ali</a> · <a href=\"https://profiles.wordpress.org/rejaulalomkhan/\">Rejaul Alom Khan</a> · <a href=\"https://profiles.wordpress.org/rembem/\">Remco</a> · <a href=\"https://profiles.wordpress.org/renathoc/\">Renatho</a> · <a href=\"https://profiles.wordpress.org/ooraiser69/\">Renz Jay Sanchez</a> · <a href=\"https://profiles.wordpress.org/youknowriad/\">Riad Benguella</a> · <a href=\"https://profiles.wordpress.org/richtabor/\">Rich Tabor</a> · <a href=\"https://profiles.wordpress.org/riddhidave/\">Riddhi Dave</a> · <a href=\"https://profiles.wordpress.org/rinkalpagdar/\">Rinkal Pagdar</a> · <a href=\"https://profiles.wordpress.org/rishavdutta/\">Rishav Dutta</a> · <a href=\"https://profiles.wordpress.org/rcreators/\">Rishi Mehta</a> · <a href=\"https://profiles.wordpress.org/rishishah/\">Rishi Shah</a> · <a href=\"https://profiles.wordpress.org/rishit30g/\">Rishit Gupta</a> · <a href=\"https://profiles.wordpress.org/rkyburz/\">rkyburz</a> · <a href=\"https://profiles.wordpress.org/noisysocks/\">Robert Anderson</a> · <a href=\"https://profiles.wordpress.org/miqrogroove/\">Robert Chapin</a> · <a href=\"https://profiles.wordpress.org/robertghetau/\">Robert Ghetau</a> · <a href=\"https://profiles.wordpress.org/harmr/\">Robert Seyfriedsberger</a> · <a href=\"https://profiles.wordpress.org/robertstaddon/\">robertstaddon</a> · <a href=\"https://profiles.wordpress.org/robinmartijn/\">Robin Martijn</a> · <a href=\"https://profiles.wordpress.org/kreppar/\">Rodrigo Arias</a> · <a href=\"https://profiles.wordpress.org/rodrigosprimo/\">Rodrigo Primo</a> · <a href=\"https://profiles.wordpress.org/rogierlankhorst/\">Rogier Lankhorst</a> · <a href=\"https://profiles.wordpress.org/geekofshire/\">Rohan Jha</a> · <a href=\"https://profiles.wordpress.org/rohitmathur7/\">rohitmathur7</a> · <a href=\"https://profiles.wordpress.org/rohjay/\">rohjay</a> · <a href=\"https://profiles.wordpress.org/room34/\">room34</a> · <a href=\"https://profiles.wordpress.org/rotemg/\">Rotem Gelbart</a> · <a href=\"https://profiles.wordpress.org/lev0/\">Roy Orbitson</a> · <a href=\"https://profiles.wordpress.org/roytanck/\">Roy Tanck</a> · <a href=\"https://profiles.wordpress.org/roybellingan/\">roybellingan</a> · <a href=\"https://profiles.wordpress.org/rseigel/\">rseigel</a> · <a href=\"https://profiles.wordpress.org/ruchirj/\">Ruchir Goswami</a> · <a href=\"https://profiles.wordpress.org/rudrakshigupta/\">Rudrakshi Gupta</a> · <a href=\"https://profiles.wordpress.org/rupesh5438/\">Rupesh Patil</a> · <a href=\"https://profiles.wordpress.org/rupw/\">rupw</a> · <a href=\"https://profiles.wordpress.org/ruturajraval2305/\">Ruturaj Raval</a> · <a href=\"https://profiles.wordpress.org/rvoigt/\">rvoigt</a> · <a href=\"https://profiles.wordpress.org/bookdude13/\">Ryan Fredlund</a> · <a href=\"https://profiles.wordpress.org/ryanhellyer/\">Ryan Hellyer</a> · <a href=\"https://profiles.wordpress.org/rmccue/\">Ryan McCue</a> · <a href=\"https://profiles.wordpress.org/welcher/\">Ryan Welcher</a> · <a href=\"https://profiles.wordpress.org/looswebstudio/\">Ryo</a> · <a href=\"https://profiles.wordpress.org/sppramodh/\">S P Pramodh</a> · <a href=\"https://profiles.wordpress.org/sebastienserre/\">S&#233;bastien SERRE</a> · <a href=\"https://profiles.wordpress.org/sergiomdgomes/\">S&#233;rgio Gomes</a> · <a href=\"https://profiles.wordpress.org/soean/\">S&#246;ren W&#252;nsch</a> · <a href=\"https://profiles.wordpress.org/sabbir1991/\">Sabbir Ahmed</a> · <a href=\"https://profiles.wordpress.org/sabrineg/\">sabrineg</a> · <a href=\"https://profiles.wordpress.org/isaeedam/\">Saeed Piri</a> · <a href=\"https://profiles.wordpress.org/sagarlakhani/\">Sagar Lakhani</a> · <a href=\"https://profiles.wordpress.org/sagarprajapati/\">Sagar Prajapati</a> · <a href=\"https://profiles.wordpress.org/mi5t4n/\">Sagar Tamang</a> · <a href=\"https://profiles.wordpress.org/sailpete/\">sailpete</a> · <a href=\"https://profiles.wordpress.org/sainathpoojary/\">Sainath Poojary</a> · <a href=\"https://profiles.wordpress.org/sallyruchman/\">sally</a> · <a href=\"https://profiles.wordpress.org/samiamnot/\">samiamnot</a> · <a href=\"https://profiles.wordpress.org/viralsampat/\">Sampat Viral</a> · <a href=\"https://profiles.wordpress.org/ranafge/\">Samsul Islam Rana</a> · <a href=\"https://profiles.wordpress.org/otto42/\">Samuel Wood (Otto)</a> · <a href=\"https://profiles.wordpress.org/codexdemon/\">Sanyogg Shelar</a> · <a href=\"https://profiles.wordpress.org/mikachan/\">Sarah Norris</a> · <a href=\"https://profiles.wordpress.org/sarathar/\">Sarath AR</a> · <a href=\"https://profiles.wordpress.org/sarthaknagoshe2002/\">Sarthak Nagoshe</a> · <a href=\"https://profiles.wordpress.org/sathyapulse/\">Sathiya Venkatesan</a> · <a href=\"https://profiles.wordpress.org/sfougnier/\">Saul Fougnier</a> · <a href=\"https://profiles.wordpress.org/saurabhdhariwal/\">saurabh.dhariwal</a> · <a href=\"https://profiles.wordpress.org/saxonafletcher/\">Saxon Fletcher</a> · <a href=\"https://profiles.wordpress.org/infosatech/\">Sayan Datta</a> · <a href=\"https://profiles.wordpress.org/sayedulsayem/\">Sayedul Sayem</a> · <a href=\"https://profiles.wordpress.org/sbathompson/\">sbathompson</a> · <a href=\"https://profiles.wordpress.org/paragoninitiativeenterprises/\">Scott Arciszewski</a> · <a href=\"https://profiles.wordpress.org/scribu/\">scribu</a> · <a href=\"https://profiles.wordpress.org/sean212/\">Sean Fisher</a> · <a href=\"https://profiles.wordpress.org/seanlanglands/\">seanlanglands</a> · <a href=\"https://profiles.wordpress.org/sebastianpisula/\">Sebastian Pisula</a> · <a href=\"https://profiles.wordpress.org/seifradwane/\">Seif Radwane</a> · <a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey Biryukov</a> · <a href=\"https://profiles.wordpress.org/sergiogutierrez/\">sergiogutierrez</a> · <a href=\"https://profiles.wordpress.org/smrubenstein/\">Seth Rubenstein</a> · <a href=\"https://profiles.wordpress.org/shadialaghbari/\">Shadi G شادي جـ</a> · <a href=\"https://profiles.wordpress.org/shailu25/\">Shail Mehta</a> · <a href=\"https://profiles.wordpress.org/sh4lin/\">Shalin Shah</a> · <a href=\"https://profiles.wordpress.org/shanemuir/\">Shane Muirhead</a> · <a href=\"https://profiles.wordpress.org/spdft/\">Shoe</a> · <a href=\"https://profiles.wordpress.org/shraddhagore/\">Shraddha Gore</a> · <a href=\"https://profiles.wordpress.org/shreyashd21/\">shreyashd21</a> · <a href=\"https://profiles.wordpress.org/shub07/\">Shubham Kumar Bansal</a> · <a href=\"https://profiles.wordpress.org/iamshubhamsp/\">Shubham Patil</a> · <a href=\"https://profiles.wordpress.org/shulard/\">shulard</a> · <a href=\"https://profiles.wordpress.org/shyamkariya/\">Shyam Kariya</a> · <a href=\"https://profiles.wordpress.org/nomnom99/\">Siddharth Thevaril</a> · <a href=\"https://profiles.wordpress.org/siliconforks/\">siliconforks</a> · <a href=\"https://profiles.wordpress.org/simo_m/\">Simone Maranzana</a> · <a href=\"https://profiles.wordpress.org/sirlouen/\">SirLouen</a> · <a href=\"https://profiles.wordpress.org/sjefen6/\">sjefen6</a> · <a href=\"https://profiles.wordpress.org/slaffik/\">Slava Abakumov</a> · <a href=\"https://profiles.wordpress.org/mslavco/\">Slavco Mihajloski</a> · <a href=\"https://profiles.wordpress.org/smerriman/\">smerriman</a> · <a href=\"https://profiles.wordpress.org/snehapatil02/\">Sneha Patil</a> · <a href=\"https://profiles.wordpress.org/sourabhjain/\">Sourabh Jain</a> · <a href=\"https://profiles.wordpress.org/sourav08/\">Sourav Pahwa</a> · <a href=\"https://profiles.wordpress.org/soyebsalar/\">soyeb salar</a> · <a href=\"https://profiles.wordpress.org/spencerfinnell/\">Spencer Finnell</a> · <a href=\"https://profiles.wordpress.org/spenserhale/\">Spenser Hale</a> · <a href=\"https://profiles.wordpress.org/spmultidots/\">spmultidots</a> · <a href=\"https://profiles.wordpress.org/spncr/\">spncr</a> · <a href=\"https://profiles.wordpress.org/srikat/\">Sridhar Katakam</a> · <a href=\"https://profiles.wordpress.org/stefahn/\">Stefan Seidner-Britting</a> · <a href=\"https://profiles.wordpress.org/ryokuhi/\">Stefano Minoia</a> · <a href=\"https://profiles.wordpress.org/stein2nd/\">stein2nd</a> · <a href=\"https://profiles.wordpress.org/sabernhardt/\">Stephen Bernhardt</a> · <a href=\"https://profiles.wordpress.org/netweb/\">Stephen Edgar</a> · <a href=\"https://profiles.wordpress.org/dufresnesteven/\">Steve Dufresne</a> · <a href=\"https://profiles.wordpress.org/stimul/\">stimul</a> · <a href=\"https://profiles.wordpress.org/strarsis/\">strarsis</a> · <a href=\"https://profiles.wordpress.org/stuartmcalpine/\">Stuart McAlpine</a> · <a href=\"https://profiles.wordpress.org/subodhrajpopat/\">Subodh Rajpopat</a> · <a href=\"https://profiles.wordpress.org/subrataemfluence/\">Subrata Sarkar</a> · <a href=\"https://profiles.wordpress.org/sketchboy/\">SUHAS SUTAR</a> · <a href=\"https://profiles.wordpress.org/sukhendu2002/\">Sukhendu Sekhar Guria</a> · <a href=\"https://profiles.wordpress.org/sumitbagthariya16/\">Sumit Bagthariya</a> · <a href=\"https://profiles.wordpress.org/sumitsingh/\">Sumit Singh</a> · <a href=\"https://profiles.wordpress.org/csesumonpro/\">Sumon Sarker</a> · <a href=\"https://profiles.wordpress.org/sunil25393/\">SunilPrajapati</a> · <a href=\"https://profiles.wordpress.org/surajswalstar/\">Suraj Sutar</a> · <a href=\"https://profiles.wordpress.org/swalkinshaw/\">swalkinshaw</a> · <a href=\"https://profiles.wordpress.org/cybr/\">Sybre Waaijer</a> · <a href=\"https://profiles.wordpress.org/synchro/\">Synchro</a> · <a href=\"https://profiles.wordpress.org/tschwarz-1/\">t.schwarz</a> · <a href=\"https://profiles.wordpress.org/tacoverdo/\">Taco Verdonschot</a> · <a href=\"https://profiles.wordpress.org/gonom9/\">Taegon Kim</a> · <a href=\"https://profiles.wordpress.org/iamtakashi/\">Takashi Irie</a> · <a href=\"https://profiles.wordpress.org/inc2734/\">Takashi Kitajima</a> · <a href=\"https://profiles.wordpress.org/takayukister/\">Takayuki Miyoshi</a> · <a href=\"https://profiles.wordpress.org/takuword/\">takuword</a> · <a href=\"https://profiles.wordpress.org/karmatosed/\">Tammie Lister</a> · <a href=\"https://profiles.wordpress.org/devtanbir/\">Tanbir Ahmod</a> · <a href=\"https://profiles.wordpress.org/voboghure/\">Tapan Kumer Das</a> · <a href=\"https://profiles.wordpress.org/th23/\">th23</a> · <a href=\"https://profiles.wordpress.org/thakordarshil/\">Thakor Darshil</a> · <a href=\"https://profiles.wordpress.org/thelmachido/\">thelmachido a11n</a> · <a href=\"https://profiles.wordpress.org/thomaswm/\">thomaswm</a> · <a href=\"https://profiles.wordpress.org/thrijith/\">Thrijith Thankachan</a> · <a href=\"https://profiles.wordpress.org/tiagogoncalves/\">tiago</a> · <a href=\"https://profiles.wordpress.org/tigriweb/\">TigriWeb</a> · <a href=\"https://profiles.wordpress.org/tillkruess/\">Till Kr&#252;ss</a> · <a href=\"https://profiles.wordpress.org/tb1909/\">Tim Brath&#228;rig</a> · <a href=\"https://profiles.wordpress.org/dontfeedthecode/\">Tim Sheehan</a> · <a href=\"https://profiles.wordpress.org/timwhitlock/\">Tim W</a> · <a href=\"https://profiles.wordpress.org/sippis/\">Timi Wahalahti</a> · <a href=\"https://profiles.wordpress.org/spaceshipone/\">Timoth&#233;e Brosille</a> · <a href=\"https://profiles.wordpress.org/timothyblynjacobs/\">Timothy Jacobs</a> · <a href=\"https://profiles.wordpress.org/tkama/\">Timur Kamaev</a> · <a href=\"https://profiles.wordpress.org/tirth03/\">Tirth Doshi</a> · <a href=\"https://profiles.wordpress.org/tjarrett/\">TJarrett</a> · <a href=\"https://profiles.wordpress.org/tobiasbg/\">Tobias B&#228;thge</a> · <a href=\"https://profiles.wordpress.org/tobifjellner/\">tobifjellner (Tor-Bjorn &#8220;Tobi&#8221; Fjellner)</a> · <a href=\"https://profiles.wordpress.org/tgsrvrs/\">Tom Gugel</a> · <a href=\"https://profiles.wordpress.org/tommusrhodus/\">Tom Rhodes</a> · <a href=\"https://profiles.wordpress.org/shimotomoki/\">Tomoki Shimomura</a> · <a href=\"https://profiles.wordpress.org/skithund/\">Toni Viemer&#246;</a> · <a href=\"https://profiles.wordpress.org/hellofromtonya/\">Tonya Mork</a> · <a href=\"https://profiles.wordpress.org/toro_unit/\">Toro_Unit (Hiroshi Urabe)</a> · <a href=\"https://profiles.wordpress.org/zodiac1978/\">Torsten Landsiedel</a> · <a href=\"https://profiles.wordpress.org/tropicalista/\">tropicalista</a> · <a href=\"https://profiles.wordpress.org/areziaal/\">Troy Chaplin</a> · <a href=\"https://profiles.wordpress.org/truptikanzariya/\">Trupti Kanzariya</a> · <a href=\"https://profiles.wordpress.org/trushaamin/\">Trusha</a> · <a href=\"https://profiles.wordpress.org/tunetheweb/\">tunetheweb</a> · <a href=\"https://profiles.wordpress.org/dinhtungdu/\">Tung Du</a> · <a href=\"https://profiles.wordpress.org/tusharaddweb/\">Tushar Patel</a> · <a href=\"https://profiles.wordpress.org/tyb/\">Ty</a> · <a href=\"https://profiles.wordpress.org/tysonlmao/\">tysonlmao</a> · <a href=\"https://profiles.wordpress.org/ugyensupport/\">Ugyen Dorji</a> · <a href=\"https://profiles.wordpress.org/umeshsinghin/\">Umesh Singh</a> · <a href=\"https://profiles.wordpress.org/unsalkorkmaz/\">Unsal Korkmaz</a> · <a href=\"https://profiles.wordpress.org/up1512001/\">up1512001</a> · <a href=\"https://profiles.wordpress.org/upadalavipul/\">upadalavipul</a> · <a href=\"https://profiles.wordpress.org/utrenkner/\">utrenkner</a> · <a href=\"https://profiles.wordpress.org/eboxnet/\">Vagelis</a> · <a href=\"https://profiles.wordpress.org/vaibhavsweb/\">Vaibhav Singh Web</a> · <a href=\"https://profiles.wordpress.org/vaibhav2527/\">Vaibhav Tukaram Nawale</a> · <a href=\"https://profiles.wordpress.org/twvania/\">Vania</a> · <a href=\"https://profiles.wordpress.org/okvee/\">vee</a> · <a href=\"https://profiles.wordpress.org/vevas/\">Vegard S.</a> · <a href=\"https://profiles.wordpress.org/vgnavada/\">vgnavada</a> · <a href=\"https://profiles.wordpress.org/vcanales/\">Vicente Canales</a> · <a href=\"https://profiles.wordpress.org/fylgjur/\">Victoria - a11n</a> · <a href=\"https://profiles.wordpress.org/gvgvgvijayan/\">Vijayan</a> · <a href=\"https://profiles.wordpress.org/vijaysinh9094/\">Vijaysinh Zala</a> · <a href=\"https://profiles.wordpress.org/szepeviktor/\">Viktor Sz&#233;pe</a> · <a href=\"https://profiles.wordpress.org/vineet2003/\">Vinit</a> · <a href=\"https://profiles.wordpress.org/vipulgupta003/\">Vipul Gupta</a> · <a href=\"https://profiles.wordpress.org/vipulpatil/\">Vipul Patil</a> · <a href=\"https://profiles.wordpress.org/virgildia/\">Virgildia</a> · <a href=\"https://profiles.wordpress.org/virgar/\">Virginie Garnier</a> · <a href=\"https://profiles.wordpress.org/virginienacci/\">virginienacci</a> · <a href=\"https://profiles.wordpress.org/vishy-moghan/\">Vishy Moghan</a> · <a href=\"https://profiles.wordpress.org/vivekawsm/\">vivekawsm</a> · <a href=\"https://profiles.wordpress.org/vrishabhsk/\">Vrishabh Jasani</a> · <a href=\"https://profiles.wordpress.org/vykesmac/\">vykesmac</a> · <a href=\"https://profiles.wordpress.org/wadowad/\">wadowad</a> · <a href=\"https://profiles.wordpress.org/pctevree/\">Web-Pepper</a> · <a href=\"https://profiles.wordpress.org/webmandesign/\">WebMan Design &#124; Oliver Juhas</a> · <a href=\"https://profiles.wordpress.org/west7/\">Wes Theron</a> · <a href=\"https://profiles.wordpress.org/westonruter/\">Weston Ruter</a> · <a href=\"https://profiles.wordpress.org/whaze/\">whaze</a> · <a href=\"https://profiles.wordpress.org/skorasaurus/\">Will Skora</a> · <a href=\"https://profiles.wordpress.org/williampatton/\">williampatton</a> · <a href=\"https://profiles.wordpress.org/wongjn/\">wongjn</a> · <a href=\"https://profiles.wordpress.org/worldweb/\">World Web Technology</a> · <a href=\"https://profiles.wordpress.org/wpgerd/\">wpgerd</a> · <a href=\"https://profiles.wordpress.org/wwdes/\">wwdes</a> · <a href=\"https://profiles.wordpress.org/xate/\">xate</a> · <a href=\"https://profiles.wordpress.org/xavilc/\">xavilc</a> · <a href=\"https://profiles.wordpress.org/xpurichan/\">xpurichan</a> · <a href=\"https://profiles.wordpress.org/yahil/\">Yahil Madakiya</a> · <a href=\"https://profiles.wordpress.org/yaniiliev/\">Yani</a> · <a href=\"https://profiles.wordpress.org/yashrocz/\">Yash Kukreja</a> · <a href=\"https://profiles.wordpress.org/yellowafterlife/\">yellowafterlife</a> · <a href=\"https://profiles.wordpress.org/yogeshbhutkar/\">Yogesh Bhutkar</a> · <a href=\"https://profiles.wordpress.org/fierevere/\">Yui</a> · <a href=\"https://profiles.wordpress.org/yuliyan/\">Yuliyan Slavchev</a> · <a href=\"https://profiles.wordpress.org/omaeyusuke/\">yuu</a> · <a href=\"https://profiles.wordpress.org/zaoyao/\">zaoyao</a> · <a href=\"https://profiles.wordpress.org/zargarov/\">Zargarov</a> · <a href=\"https://profiles.wordpress.org/zebulan/\">Zebulan Stanphill</a> · <a href=\"https://profiles.wordpress.org/zeelthakkar/\">zeelthakkar</a> · <a href=\"https://profiles.wordpress.org/zunaid321/\">Zunaid Amin</a> · <a href=\"https://profiles.wordpress.org/haozi/\">耗子</a></p>\n\n\n\n<p>More than <a href=\"https://translate.wordpress.org/stats/\">60 locales have fully translated</a> WordPress 6.8 into their language making this one of the most translated releases ever on day one.&nbsp; Community translators are working hard to ensure more translations are on their way.&nbsp; Thank you to everyone who helps make WordPress available in 200 languages.</p>\n\n\n\n<p>Last but not least, thanks to the volunteers who contribute to the <a href=\"https://wordpress.org/support/\">support forums</a> by answering questions from WordPress users worldwide.</p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Get involved</strong></h2>\n\n\n\n<p>Participation in WordPress goes far beyond coding. And learning more and getting involved is easy.&nbsp; Discover the teams that come together to <a href=\"https://make.wordpress.org/\">Make WordPress</a> and use <a href=\"https://make.wordpress.org/contribute/\">this interactive tool</a> to help you decide which is right for you.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 15 Apr 2025 17:00:45 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Jeffrey Paul\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:28;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"Do The Woo Community: Writing Notes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"https://dothewoo.io/?post_type=blog&p=94561\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"https://dothewoo.io/blog/writing-notes/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:211:\"BobWP, Wired for Open: At CloudFest 2024, BobWP received a reMarkable 2 tablet, which helped organize his messy notes, overcoming challenges with quick tech note-taking and revitalizing his handwriting practice.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 15 Apr 2025 08:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:29;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"WordPress.org blog: WordCamp Europe 2025: Sali, Basel!\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=18683\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"https://wordpress.org/news/2025/04/wordcamp-europe-2025-sali-basel/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5469:\"<img width=\"1024\" height=\"390\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/04/473144529_985418666952827_8265761567676487048_n.png?resize=1024%2C390&ssl=1\" alt=\"\" class=\"wp-image-18690\" />\n\n\n\n<p>WordCamp Europe 2025 will be held in gorgeous Basel, Switzerland, from June 5 to 7. It will bring together open source enthusiasts, developers, and WordPress professionals from across the region—and the world!</p>\n\n\n\n<p>This year’s event offers fresh perspectives, engaging conversations, and countless opportunities to connect with the WordPress community, agencies, and innovators over three action-packed days of learning, networking, and collaboration.</p>\n\n\n\n<div class=\"wp-block-group has-off-white-background-color has-background is-layout-constrained wp-container-core-group-is-layout-8503c47b wp-block-group-is-layout-constrained\">\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<p class=\"has-text-align-center has-large-font-size\"><img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/1f39f.png\" alt=\"🎟\" class=\"wp-smiley\" /> <strong>Tickets are limited—secure yours today!</strong></p>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<div class=\"wp-block-buttons is-content-justification-center is-layout-flex wp-container-core-buttons-is-layout-a89b3969 wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link has-text-align-center wp-element-button\" href=\"https://europe.wordcamp.org/2025/tickets/\">Get your ticket now</a></div>\n</div>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n</div>\n\n\n\n<h2 class=\"wp-block-heading\">Keynotes, panels, and deep dives</h2>\n\n\n\n<p>The main conference, which will be held on June 6th and 7th, will feature <a href=\"https://europe.wordcamp.org/2025/schedule/\">a lineup of notable keynote sessions</a>, including diverse sessions on business strategy and building innovative modern features, open-source advocacy, accessibility, and more. For those looking to sharpen their skills, presentations will dive deep into topics like SEO for WordPress, performance optimization, speed-builds, and leveraging AI.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Q&amp;A Fireside Chat</h2>\n\n\n\n<p>You can join Mary Hubbard, the WordPress Executive Director, and Matt Mullenweg, co-founder of the WordPress project on June 7th to discuss WordPress and its community, followed by an in-person Q&amp;A session here in Basel.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Explore Basel</h2>\n\n\n\n<p>Basel, the third-largest city in Switzerland, <a href=\"https://europe.wordcamp.org/2025/location/\">is filled with historical buildings, a cathedral, museums, and hidden gems</a>! You can get around Basel and experience it yourself using your BaselCard, which allows you to hop on and off all public transportation without a worry. A walk down Basel’s river Rhine could be the perfect evening during your visit to WordCamp Europe!</p>\n\n\n\n<p><img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/1f6cf.png\" alt=\"🛏\" class=\"wp-smiley\" /><a href=\"https://europe.wordcamp.org/2025/location/accommodation/\"> Find accommodations in Basel<br /></a><img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/1f68c.png\" alt=\"🚌\" class=\"wp-smiley\" /><a href=\"https://europe.wordcamp.org/2025/location/getting-around-in-basel/\"> Learn about BaselCard benefits<br /></a><img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/1f4c4.png\" alt=\"📄\" class=\"wp-smiley\" /><a href=\"https://europe.wordcamp.org/2025/location/visa/\"> Need a visa? Apply by May 10, 2025</a></p>\n\n\n\n<p><img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/1f4c5.png\" alt=\"📅\" class=\"wp-smiley\" /> <strong>Plan Your WordCamp Europe Experience</strong> See the <a href=\"https://europe.wordcamp.org/2025/schedule/\">full schedule</a>, plan your sessions, and maximize your time in Basel.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Get WordCamp-ready</h2>\n\n\n\n<p><img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/1f39f.png\" alt=\"🎟\" class=\"wp-smiley\" /> <strong>Make sure to secure your <a href=\"https://europe.wordcamp.org/2025/tickets/\">WordCamp Europe 2025 tickets</a></strong> (if you haven’t already!)</p>\n\n\n\n<p>Follow WordCamp Europe news on <a href=\"https://bsky.app/profile/wordpress.org\">Bluesky</a>, <a href=\"https://instagram.com/wordpress/\">Instagram</a>, <a href=\"https://www.facebook.com/WordPress\">Facebook</a>, <a href=\"https://www.linkedin.com/company/wordpress/\">LinkedIn</a>, <a href=\"https://www.threads.net/@wordpress\">Threads</a>, <a href=\"https://mastodon.world/@wordpress\">Mastodon</a>, and <a href=\"https://twitter.com/WordPress\">X/Twitter</a> for real-time updates!</p>\n\n\n\n<p>You can also help us spread the word about WordCamp Europe this year! Post about your attendance <a href=\"https://europe.wordcamp.org/2025/press/spread-the-word/\">using our ready-made texts</a> or we also encourage you to use your own voice – you know your community best.</p>\n\n\n\n<p>And as always, be part of the conversation! Whether you’re attending in-person in Basel or following along online, share your experiences using the tags #WCEU and #WordPress on all social media networks!</p>\n\n\n\n<p>Basel is calling—see you at WordCamp Europe 2025! <img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/1f1e8-1f1ed.png\" alt=\"🇨🇭\" class=\"wp-smiley\" /></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<p>Thank you to <a href=\"https://profiles.wordpress.org/dolgelukkig/\">@dolgelukkig</a> for drafting this copy.</p>\n\n\n\n<p></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 14 Apr 2025 19:16:10 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Brett McSherry\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:30;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:96:\"Do The Woo Community: How Philip Levine Balances Managing Hundreds of Sites and Avoiding Burnout\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=94456\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:95:\"https://dothewoo.io/how-philip-levine-balances-managing-hundreds-of-sites-and-avoiding-burnout/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:232:\"In this WP Agency Track episode, hosts Cami and Marcus interview Philip Levine, owner of South Florida Web Advisors, discussing his evolution from static sites to WordPress, emphasizing networking, automation, and work-life balance.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 14 Apr 2025 11:26:57 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:31;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"Do The Woo Community: BobWP, Wired for Open\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"https://dothewoo.io/?post_type=blog&p=94466\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"https://dothewoo.io/blog/bobwp-wired-for-open/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:220:\"In a recent podcast, I discussed a new daily post concept originally named BobWP Unplugged. After reconsidering, I renamed it BobWP, Wired for Open, focusing on sharing life and business experiences on my WordPress site.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 14 Apr 2025 08:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:32;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"Do The Woo Community: BobWP Unplugged, Do the Woo Query Newsletter and Daily Posts\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=94265\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"https://dothewoo.io/bobwp-unplugged-do-the-woo-query-newsletter-and-daily-posts/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:156:\"In episode 640, BobWP announces his newsletter \"Do the Woo Query,\" introduces a posts with a daily thought, and explains the name change to BobWP Unplugged.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 12 Apr 2025 12:09:25 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:33;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:99:\"Gutenberg Times: Woo 9.8, Blocks and publishers, Interactivity API and more — Weekend Edition 325\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://gutenbergtimes.com/?p=39920\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:104:\"https://gutenbergtimes.com/woo-9-8-blocks-and-publishers-interactivity-api-and-more-weekend-edition-325/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:14053:\"<p>Hi there, I am so excited! <img src=\"https://s.w.org/images/core/emoji/15.1.0/72x72/1f389.png\" alt=\"🎉\" class=\"wp-smiley\" /></p>\n\n\n\n<p>AI is here. WordPress.com just <a href=\"https://wordpress.com/blog/2025/04/09/ai-website-builder/\">released the new AI builder</a> for their new users. I am so excited as it solves the blank page onboarding problem, new WordPress users struggled with. Now they have an AI buddy to get online quickly. <a href=\"https://wordpress.com/ai-website-builder/\">You can try it here</a>. Let me know what you think, just hit reply or email pauli@gutenbergtimes.com. Rae Morey at The Repository<a href=\"https://www.therepository.email/wordpress-com-launches-ai-powered-website-builder\"> has the skinny for you</a>.</p>\n\n\n\n<p><img src=\"https://s.w.org/images/core/emoji/15.1.0/72x72/1f389.png\" alt=\"🎉\" class=\"wp-smiley\" /> Next week is WordPress 6.8 release! I hope you are prepared.</p>\n\n\n\n<p>Enjoy the conversations and updates in this shorter than usual edition. Take your time, slow down!</p>\n\n\n\n<p>Yours, <img src=\"https://s.w.org/images/core/emoji/15.1.0/72x72/1f495.png\" alt=\"💕\" class=\"wp-smiley\" /><br /><em>Birgit</em></p>\n\n\n\n<div class=\"wp-block-group has-light-background-background-color has-background\"><div class=\"wp-block-group__inner-container is-layout-flow wp-block-group-is-layout-flow\">\n<p><strong>Table of Contents</strong></p>\n\n\n\n<ol><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/woo-9-8-blocks-and-publishers-interactivity-api-and-more-weekend-edition-325/#0-word-press-release-information\">Developing Gutenberg and WordPress</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/woo-9-8-blocks-and-publishers-interactivity-api-and-more-weekend-edition-325/#0-p\">Plugins, Themes, and Tools for #nocode site builders and owners</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/woo-9-8-blocks-and-publishers-interactivity-api-and-more-weekend-edition-325/#3-building-themes-for-fse-and-word-press\">Building Blocks and Tools for the Block editor</a></li></ol>\n</div></div>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"0-word-press-release-information\">Developing Gutenberg and WordPress</h2>\n\n\n\n<p><a href=\"https://wordpress.org/news/2025/04/wordpress-6-8-release-candidate-3/\"><strong>WordPress 6.8 RC 3 was released this week</strong>.</a> In case you missed them before: </p>\n\n\n\n<p>Consult the <a href=\"https://make.wordpress.org/core/2025/03/28/wordpress-6-8-field-guide/\"><strong>WordPress 6.8 Field Guide</strong></a> about developer relevant updates and the <a href=\"https://gutenbergtimes.com/source-of-truth-wordpress-6-8/\"><strong>Source of Truth (WordPress 6.8)</strong></a> for Block editor updates. </p>\n\n\n\n<p>As for almost every WordPress release, <strong>Carlo Daniele, </strong>Kinsta, published a comprehensive guide: <a href=\"https://kinsta.com/blog/wordpress-6-8/\"><strong>What’s new in WordPress 6.8: security upgrades, performance gains, editor enhancements, and more!</strong></a> He breaks down the benefits of WordPress 6.8, offering actionable tips and advice for website owners and developers looking to take advantage of its capabilities.</p>\n\n\n\n<div class=\"wp-block-group has-light-background-background-color has-background\"><div class=\"wp-block-group__inner-container is-layout-constrained wp-block-group-is-layout-constrained\">\n<p><img src=\"https://s.w.org/images/core/emoji/15.1.0/72x72/1f399.png\" alt=\"🎙\" class=\"wp-smiley\" /> Latest episode: <a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-116-wordpress-6-8-field-guide/\">Gutenberg Changelog 116 – WordPress 6.8, Source of Truth, Field Guide, Gutenberg 20.5 and 20.6</a> with special guest JC Palmes, WebDev Studios</p>\n\n\n\n<img width=\"652\" height=\"184\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/04/Screenshot-2025-04-05-at-12.27.14.png?resize=652%2C184&ssl=1\" alt=\"\" class=\"wp-image-39894\" />\n</div></div>\n\n\n\n<p><strong>Milana Cap</strong> wrote the <a href=\"https://developer.wordpress.org/news/2025/04/whats-new-for-developers-april-2025/\"><strong>What’s new for developers? (April 2025)</strong></a> on the WordPress Developer Blog. As recent updates, she emphasizes performance and user experience, introducing a &#8220;performance mode&#8221; for speed prioritization and improved error messages for debugging. The core team has also enhanced accessibility by adding ARIA attributes and semantic HTML, facilitating the creation of faster, more secure, and accessible sites for developers.</p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"0-p\">Plugins, Themes, and Tools for #nocode site builders and owners</h2>\n\n\n\n<p><strong>Steve Burge</strong> had a conversation with <strong>Brad Williams</strong>, co-founder of Webdev Studios on <a href=\"https://www.youtube.com/watch?v=omJVDhiE4hQ\"><strong>WordPress as a World-Class Publishing Platform</strong></a>. They talked extensively about how the agency&#8217;s approach working with organizations that want and need to transition to a block-based presence. Williams cited site performance reasons, great-looking content within minutes, and a better user experience. They talked quite a bit about an incremental approach to bring clients to the new system, so certain high-traffic pages can run on a block theme while the rest of the site stays on the legacy systems a while longer. Williams also covered why companies with multiple sites should consider using WordPress as a multi-site network. <a href=\"https://bsky.app/profile/bradw.illiams.com/post/3llra7kxmlc2l\">Via Bluesky</a>, Williams also invited people to signup for the  beta of their next product to help with the incremental migration process. </p>\n\n\n<div width=\"100%\" class=\"wp-block-newsletterglue-showhide ng-block\">\n<div class=\"wp-block-embed__wrapper\">\n\n</div>\n</div>\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Hitesh Patel</strong>, a developer in Ahmedabad, India, released his first plugin to the WordPress plugin repository: <a href=\"https://wordpress.org/plugins/flexi-patterns/\"><strong>Flexi Patterns</strong></a>. With this plugin installed, you can create and manage custom pattern categories, making it easier to access and use design elements in the block editor. It&#8217;s the first version.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>WooCommerce 9.8.1 has been released. In his release post ,<a href=\"https://developer.woocommerce.com/2025/04/09/woocommerce-9-8-modernized-designs-and-email-previews/\"><strong>WooCommerce 9.8: Modernized Designs and Email Previews</strong></a>, <strong>Brian Coords</strong>  highlights </p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://developer.woocommerce.com/2025/04/09/woocommerce-9-8-modernized-designs-and-email-previews/#h-new-coming-soon-templates\">New Coming Soon templates</a></li>\n\n\n\n<li><a href=\"https://developer.woocommerce.com/2025/04/09/woocommerce-9-8-modernized-designs-and-email-previews/#h-modernized-email-templates-and-previews\">Modernized email templates and previews</a></li>\n\n\n\n<li><a href=\"https://developer.woocommerce.com/2025/04/09/woocommerce-9-8-modernized-designs-and-email-previews/#h-a-faster-woocommerce-admin\">A faster WooCommerce admin</a></li>\n\n\n\n<li><a href=\"https://developer.woocommerce.com/2025/04/09/woocommerce-9-8-modernized-designs-and-email-previews/#h-display-a-brand-in-the-single-product-template\">Display a Brand in the Single Product template</a></li>\n\n\n\n<li><a href=\"https://developer.woocommerce.com/2025/04/09/woocommerce-9-8-modernized-designs-and-email-previews/#h-redirect-to-add-product-task-if-no-products-created-in-store-yet\">Redirect to “Add product” task if no products created in store yet</a></li>\n</ul>\n\n\n\n<p>You might also be interested in the <a href=\"https://developer.woocommerce.com/2025/04/09/woocommerce-9-8-modernized-designs-and-email-previews/#h-api-updates\">API Updates</a> for Store API and REST API </p>\n\n\n\n<p><strong>&nbsp;<a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/\" target=\"_blank\" rel=\"noreferrer noopener\">&#8220;Keeping up with Gutenberg &#8211; Index 2025&#8221;</a>&nbsp;</strong><br />A chronological list of the WordPress Make Blog posts from various teams involved in Gutenberg development: Design, Theme Review Team, Core Editor, Core JS, Core CSS, Test, and Meta team from Jan. 2024 on. Updated by yours truly. The previous years are also available: <strong><strong><a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2020/\">2020</a>&nbsp;|&nbsp;<a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2021/\">2021</a></strong>&nbsp;|&nbsp;<strong><a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2022/\">2022</a></strong></strong>&nbsp;|&nbsp;<strong><a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/gutenberg-index-2023\">2023</a></strong> | <a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/gutenberg-index-2024/\"><strong>2024</strong></a></p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"3-building-themes-for-fse-and-word-press\">Building Blocks and Tools for the Block editor</h2>\n\n\n\n<p><strong>JuanMa Garrido</strong> continue with his series <a href=\"https://www.youtube.com/watch?v=tm402NyLcuE\"><strong>Data in the Block Editor with @wordpress/data</strong></a> on his live stream. <a href=\"https://www.youtube.com/watch?v=tm402NyLcuE\">Part 4</a> is now available on YouTube. </p>\n\n\n\n<p>Previous <a href=\"https://www.youtube.com/watch?v=18zDV5KIDog\">Part 1</a>,&nbsp;<a href=\"https://www.youtube.com/watch?v=GlowE1b11Jk\">Part 2</a> and <a href=\"https://www.youtube.com/watch?v=E4SblEO4vuU\">Part 3</a> are also available on YouTube</p>\n\n\n<div width=\"100%\" class=\"wp-block-newsletterglue-showhide ng-block\">\n<div class=\"wp-block-embed__wrapper\">\n\n</div>\n</div>\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Nathan Wrigley </strong>published another episode on the WPTavern Jukebox podcast. <a href=\"https://wptavern.com/podcast/164-milana-cap-on-the-interactivity-and-html-apis-and-their-enormous-potential\"><strong>164 – Milana Cap on the Interactivity and HTML APIs, and Their Enormous Potential.</strong></a> The conversation  revealed two exciting developments in WordPress. <strong>Milana Cap</strong> explained the Interactivity API using a party analogy &#8211; blocks that were once isolated can now communicate freely, enabling features like shopping carts to interact seamlessly with other elements. </p>\n\n\n\n<p>When discussing the HTML API, Cap&#8217;s enthusiasm was evident as she described how it replaces JavaScript DOM manipulation with faster PHP solutions. Built by Dennis Snell, this WordPress-original feature particularly benefits enterprise sites. These standardized APIs, she emphasized, mean developers can finally stop reinventing the wheel and build on a common foundation.</p>\n\n\n<div width=\"100%\" class=\"wp-block-newsletterglue-showhide ng-block\">\n<div class=\"wp-block-embed__wrapper\">\n<div>    <div></div>    </div>\n</div>\n</div>\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong><a href=\"https://gutenbergtimes.com/need-a-zip-from-master/\">Need a plugin .zip from Gutenberg&#8217;s master branch?</a></strong><br />Gutenberg Times provides daily build for testing and review. </p>\n\n\n\n<p>Now also available via <a href=\"https://playground.wordpress.net/?blueprint-url=https://gutenbergtimes.com/wp-content/uploads/2020/11/playnightly.json\">WordPress Playground</a>. There is no need for a test site locally or on a server. Have you been using it? <a href=\"mailto:pauli@gutenbergtimes.com\">Email me </a>with your experience</p>\n\n\n\n<p><img alt=\"GitHub all releases\" src=\"https://img.shields.io/github/downloads/bph/gutenberg/total?style=for-the-badge\" /></p>\n\n\n\n<p class=\"has-text-align-center has-small-font-size\"><em>Questions? Suggestions? Ideas? </em><br /><em>Don&#8217;t hesitate to send <a href=\"mailto:pauli@gutenbergtimes.com\">them via email</a> or</em><br /><em> send me a message on WordPress Slack or Twitter @bph</em>.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<p class=\"has-text-align-center has-small-font-size\">For questions to be answered on the <a href=\"http://gutenbergtimes.com/podcast\">Gutenberg Changelog</a>, <br />send them to <a href=\"mailto:changelog@gutenbergtimes.com\">changelog@gutenbergtimes.com</a></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>Featured Image:</p>\n\n\n\n<hr class=\"wp-block-separator has-css-opacity is-style-wide\" />\n\n\n\n<p class=\"has-text-align-left\"><strong>Don&#8217;t want to miss the next Weekend Edition? </strong></p>\n\n\n<form class=\"wp-block-newsletterglue-form ngl-form ngl-portrait\" action=\"https://gutenbergtimes.com/feed/\" method=\"post\"><div class=\"ngl-form-container\"><div class=\"ngl-form-field\"><label class=\"ngl-form-label\" for=\"ngl_email\"><br />Type in your Email address to subscribe.</label><div class=\"ngl-form-input\"><input type=\"email\" class=\"ngl-form-input-text\" name=\"ngl_email\" id=\"ngl_email\" /></div></div><button type=\"submit\" class=\"ngl-form-button\">Subscribe</button><p class=\"ngl-form-text\">We hate spam, too, and won&#8217;t give your email address to anyone <br />except Mailchimp to send out our Weekend Edition</p></div><div class=\"ngl-message-overlay\"><div class=\"ngl-message-svg-wrap\"></div><div class=\"ngl-message-overlay-text\">Thanks for subscribing.</div></div><input type=\"hidden\" name=\"ngl_list_id\" id=\"ngl_list_id\" value=\"26f81bd8ae\" /><input type=\"hidden\" name=\"ngl_double_optin\" id=\"ngl_double_optin\" value=\"yes\" /></form>\n\n\n<hr class=\"wp-block-separator has-css-opacity is-style-wide\" />\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 11 Apr 2025 23:52:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Birgit Pauli-Haack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:34;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"Gravatar: 9 Inspiring Sign Up Pages for Better User Experience\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"http://blog.gravatar.com/?p=3039\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://blog.gravatar.com/2025/04/11/sign-up-page-examples/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:19555:\"<p>Did you know that <a href=\"https://www.omnisend.com/blog/best-signup-forms-conversions/\">forms with just three fields have a conversion rate of 10%</a>? This remarkable finding from Omnisend&#8217;s research of over 128,000 email campaigns confirms a universal truth about sign-up pages: Simplicity drives success.</p>\n\n\n\n<p>But just being simple isn’t enough – you need to find the balance between collecting essential user data and reducing &#8220;information friction&#8221;. Each additional field creates potential hesitation, yet too little information limits personalization opportunities. The most effective sign-up pages manage this tension masterfully, gathering just enough details without overwhelming potential users.</p>\n\n\n\n<p>We&#8217;re going to give you 9 sign-up page examples that will help skyrocket conversion rates on your website or platform&#8217;s sign-up page! You’ll see minimalist designs that convert at first glance, strategic integration of social proof, and other proven techniques from companies that have mastered the art of turning visitors into registered users.</p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>How Sign-Up Pages Convert Visitors into Users</strong></h2>\n\n\n\n<p>The difference between a high-converting sign-up page and one that hemorrhages potential customers often comes down to thoughtful design choices. Successful pages don&#8217;t just look good – they strategically reduce obstacles while maximizing value perception.</p>\n\n\n\n<p>The best sign-up experiences balance several competing factors.&nbsp;</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>They collect enough information to personalize the user experience without creating excessive friction.&nbsp;</li>\n\n\n\n<li>They showcase the product&#8217;s value while keeping focus on completing registration.&nbsp;</li>\n\n\n\n<li>They build trust through transparency while maintaining a clean interface.</li>\n</ul>\n\n\n\n<p>Every element matters: The number of form fields, button text, color psychology, placement of social proof elements, and even microcopy that addresses potential concerns. A visitor&#8217;s decision to sign up happens in seconds, making these subtle optimizations crucial.&nbsp;</p>\n\n\n\n<p>The examples covered in this article span the full spectrum of approaches. Some use extreme minimalism with just an email field and a strong call to action, while others carefully structure multi-step processes that break complex registrations into digestible chunks. Each represents a different solution to the sign-up challenge, optimized for specific business goals and user expectations.</p>\n\n\n\n<p>Many of these strategies are also part of trends, like the minimalistic approach. If we think about how pages used to be 10 years ago, the difference is massive. New trends will continue to reshape best practices, and an example of that is the integration of profile verification systems that allow users to authenticate via existing accounts, eliminating repetitive form-filling.&nbsp;</p>\n\n\n\n<p>Services like <a href=\"https://gravatar.com/\">Gravatar</a> enable universal profile management, where users maintain a single identity across multiple platforms. This &#8220;update once, apply everywhere&#8221; approach simplifies sign-up flows while ensuring consistent user experiences.</p>\n\n\n\n<p>Trust-building has also become central to sign-up design. With growing privacy concerns, successful pages now clearly communicate how user data will be used and protected. Transparent privacy controls, simple explanations of data policies, and explicit consent mechanisms help overcome skepticism and build confidence during registration.</p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Design Inspiration from Leading Brands</strong></h2>\n\n\n\n<p>In this section, we&#8217;re going to dive into sign-up page strategies from several industry leaders that go beyond basic design principles. This section examines different approaches to minimalist design, innovative applications of social proof, and data-driven form optimization techniques that create exceptional UX.</p>\n\n\n\n<p>Let’s dive in!&nbsp;</p>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>Minimalist designs that maximize conversion</strong></h3>\n\n\n\n<h4 class=\"wp-block-heading\"><strong>1. PayPal</strong></h4>\n\n\n\n<p><a href=\"https://www.paypal.com/\">PayPal&#8217;s</a> sign-up approach breaks down what could be an overwhelming verification process into a series of manageable steps.</p>\n\n\n\n<p>This is done through a progressive disclosure system – rather than presenting users with a lengthy form containing numerous fields, PayPal segments the process into distinct stages.&nbsp;</p>\n\n\n\n<ol class=\"wp-block-list\">\n<li>Choose the type of account.&nbsp;</li>\n</ol>\n\n\n\n<img width=\"1648\" height=\"1158\" src=\"https://blog.gravatar.com/wp-content/uploads/2025/03/paypal-signup-page.png\" alt=\"Creating a new PayPal account: Choosing between personal and business\" class=\"wp-image-3042\" />\n\n\n\n<ol start=\"2\" class=\"wp-block-list\">\n<li>Fill in basic information.&nbsp;</li>\n</ol>\n\n\n\n<img width=\"1422\" height=\"903\" src=\"https://blog.gravatar.com/wp-content/uploads/2025/03/paypal-business-account-creation.png\" alt=\"PayPal basic sign-up form\" class=\"wp-image-3043\" />\n\n\n\n<ol start=\"3\" class=\"wp-block-list\">\n<li>Verify your email address.&nbsp;</li>\n</ol>\n\n\n\n<img width=\"943\" height=\"495\" src=\"https://blog.gravatar.com/wp-content/uploads/2025/03/paypal-code-confirmation-screen.png\" alt=\"PayPal code verification page\" class=\"wp-image-3044\" />\n\n\n\n<p>That’s it! You officially have a PayPal account. Of course, in order to actually use the account, people need to give further information about their business, but even that’s broken down into manageable steps, and you also have the option to skip the process for the time being.&nbsp;</p>\n\n\n\n<img width=\"1007\" height=\"658\" src=\"https://blog.gravatar.com/wp-content/uploads/2025/03/paypal-second-phase-signup.png\" alt=\"PayPal account activation page\" class=\"wp-image-3045\" />\n\n\n\n<p>This chunking technique achieves two important goals. First, it makes the process feel less daunting by hiding the total complexity up front. Second, it creates a sense of investment – once users complete the first step, they&#8217;re more likely to continue through subsequent stages.&nbsp;</p>\n\n\n\n<p>See how they continue with the business account setup: First, you only have to click a button and select your business type from a drop-down menu, and only after that do you see the longer form with important information.&nbsp;</p>\n\n\n\n<img width=\"660\" height=\"371\" src=\"https://blog.gravatar.com/wp-content/uploads/2025/03/paypal-signup-flow.gif?w=660\" alt=\"PayPal signup flow for business account creation\" class=\"wp-image-3047\" />\n\n\n\n<h4 class=\"wp-block-heading\"><strong>2. Mailchimp&nbsp;</strong></h4>\n\n\n\n<p><a href=\"https://mailchimp.com/\">MailChimp&#8217;s</a> sign-up flow also uses the power of intelligent progressive disclosure. Their form initially appears simple, requesting only essential information like name, email, and password. But this simplicity hides sophisticated mechanics working behind the scenes.</p>\n\n\n\n<p>As users begin creating a password, MailChimp reveals password requirements in real time, eliminating the frustration of form rejections after submission.&nbsp;</p>\n\n\n\n<img width=\"660\" height=\"489\" src=\"https://blog.gravatar.com/wp-content/uploads/2025/03/mailchimp-signup-form.png?w=660\" alt=\"Mailchimp signup page\" class=\"wp-image-3048\" />\n\n\n\n<p>This interactive guidance helps users succeed without overwhelming them with requirements upfront.</p>\n\n\n\n<h4 class=\"wp-block-heading\"><strong>3.</strong> <strong>Typeform</strong></h4>\n\n\n\n<p><a href=\"https://www.typeform.com/\">Typeform</a> specializes in creating engaging form experiences and naturally applies its expertise to the sign-up process, embodying the company&#8217;s philosophy: Forms should be conversational and human.</p>\n\n\n\n<p>Users can register with email or authenticate through existing <a href=\"https://www.google.com/\">Google</a> or <a href=\"https://www.microsoft.com/\">Microsoft</a> accounts, so they can choose their preferred method without dealing with a cluttered interface.</p>\n\n\n\n<img width=\"660\" height=\"305\" src=\"https://blog.gravatar.com/wp-content/uploads/2025/03/typeform-signup-page.png?w=660\" alt=\"Typeform signup page\" class=\"wp-image-3049\" />\n\n\n\n<p>What sets Typeform&#8217;s approach apart is how it uses conversational prompts and subtle animations to guide users through each step. Despite offering multiple sign-up options, the page maintains visual simplicity through thoughtful spacing, typography hierarchy, and focused interaction design.</p>\n\n\n\n<p>Typeform also takes advantage of Gravatar integration to further improve the experience. For users with existing Gravatar profiles, their avatar automatically appears in the interface after registration.</p>\n\n\n\n<img width=\"660\" height=\"365\" src=\"https://blog.gravatar.com/wp-content/uploads/2025/03/typeform-gravatar-integration.png?w=660\" alt=\"Typeform Gravatar integration in profile settings\" class=\"wp-image-3050\" />\n\n\n\n<p>This eliminates the need to manually upload profile images and creates an immediate sense of personalization that makes the platform feel familiar right from the start.</p>\n\n\n\n<h4 class=\"wp-block-heading\"><strong>4. SalesForce</strong></h4>\n\n\n\n<p><a href=\"https://www.salesforce.com/eu/\">SalesForce</a> tackles the challenge of gathering user information while maintaining engagement through its multi-step trial registration form and a progress tracking system. Clear indicators show users exactly where they are in the process and how many questions remain.&nbsp;</p>\n\n\n\n<img width=\"660\" height=\"472\" src=\"https://blog.gravatar.com/wp-content/uploads/2025/03/salesforce-signup-form.png?w=660\" alt=\"SalesForce signup page\" class=\"wp-image-3052\" />\n\n\n\n<p>This transparency helps set appropriate expectations and reduces abandonment by making the remaining effort visible.</p>\n\n\n\n<p>Each step collects related information chunks, allowing users to focus on one category at a time rather than facing a wall of fields. This reduces cognitive load while still gathering all necessary data for effective lead qualification.</p>\n\n\n\n<img width=\"646\" height=\"606\" src=\"https://blog.gravatar.com/wp-content/uploads/2025/03/salesforce-step2.png?w=646\" alt=\"Salesforce signup step 2 of 3\" class=\"wp-image-3053\" />\n\n\n\n<h3 class=\"wp-block-heading\"><strong>Social proof and trust signals that work</strong></h3>\n\n\n\n<p>Social proof elements transform sign-up pages from simple data collection forms into persuasive marketing tools. When implemented effectively, these trust signals overcome hesitation and provide the final push users need to complete registration.</p>\n\n\n\n<h4 class=\"wp-block-heading\"><strong>5. Webflow</strong></h4>\n\n\n\n<p><a href=\"https://webflow.com/\">Webflow</a> positions itself as a sophisticated CMS and website-building platform for professionals seeking more control than traditional systems like <a href=\"https://wordpress.org/\">WordPress</a>. Their sign-up page reinforces this premium positioning through strategic social proof.</p>\n\n\n\n<p>The form displays logos from high-profile clients, including <a href=\"http://monday.com\">Monday.com</a> and <a href=\"https://www.nytimes.com/international/\">The New York Times</a>.&nbsp;</p>\n\n\n\n<img width=\"660\" height=\"346\" src=\"https://blog.gravatar.com/wp-content/uploads/2025/03/webflow-signup-page.png?w=660\" alt=\"Webflow signup page\" class=\"wp-image-3054\" />\n\n\n\n<p>These recognizable brands create an immediate trust signal, showing potential users that Webflow is used by serious organizations.</p>\n\n\n\n<p>Their team-focused messaging targets decision-makers directly. Rather than addressing individual users, the copy speaks to teams and organizations, prompting leaders to envision how Webflow might serve their entire department or company.</p>\n\n\n\n<h4 class=\"wp-block-heading\"><strong>6. OptinMonster</strong></h4>\n\n\n\n<p><a href=\"https://optinmonster.com/\">OptInMonster</a>, a conversion rate optimization platform, integrates social proof directly into their sign-up process. As specialists in conversion tactics, they practice what they preach in their own registration flow.</p>\n\n\n\n<p>The pricing page includes customer testimonials strategically positioned near decision points. These elements appear directly below pricing information, precisely where potential customers might hesitate.</p>\n\n\n\n<img width=\"660\" height=\"329\" src=\"https://blog.gravatar.com/wp-content/uploads/2025/03/optinmonster-payment_signup-page.png?w=660\" alt=\"OptinMonster checkout page with a verified customer review\" class=\"wp-image-3055\" />\n\n\n\n<p>The social proof sits alongside automatically applied discounts, creating a powerful combination. The discount creates a sense of value, while testimonials confirm that value through third-party validation, addressing both cost concerns and the need for reassurance at the critical moment of decision.</p>\n\n\n\n<h4 class=\"wp-block-heading\"><strong>7. Kit</strong></h4>\n\n\n\n<p>The email marketing platform <a href=\"https://kit.com/\">Kit</a> takes a personal approach to social proof. Their sign-up page features rotating full-sized images of actual Kit users, with different creator portraits appearing with each page refresh.</p>\n\n\n\n<img width=\"660\" height=\"259\" src=\"https://blog.gravatar.com/wp-content/uploads/2025/03/kit-sign-up-page.png?w=660\" alt=\"Kit sign-up page\" class=\"wp-image-3078\" />\n\n\n\n<p>This visual representation helps potential subscribers see themselves reflected in the current user base, creating immediate identification. The rotating images suggest a large, active community without explicitly stating numbers.</p>\n\n\n\n<p>By helping visitors envision themselves as part of this community before they even sign up, Kit creates perceived value that motivates form completion and reduces registration friction.</p>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>Smart form optimization techniques</strong></h3>\n\n\n\n<h4 class=\"wp-block-heading\"><strong>8. OpenAI</strong></h4>\n\n\n\n<p><a href=\"https://openai.com/\">OpenAI</a>, the company behind ChatGPT and other groundbreaking AI tools, has a sign-up flow that requires just two essential fields: An email address and a password (that is if users don’t want to login with an existing account). This ultra-minimalist approach removes almost all barriers to entry while still collecting the information needed to create an account.</p>\n\n\n\n<img width=\"660\" height=\"368\" src=\"https://blog.gravatar.com/wp-content/uploads/2025/03/chatgpt-registration-form.png?w=660\" alt=\"ChatGPT signup page\" class=\"wp-image-3056\" />\n\n\n\n<p>What makes this approach particularly effective is OpenAI&#8217;s Gravatar integration. The system automatically pulls in user avatars through <a href=\"https://docs.gravatar.com/api/avatars/images/\">Gravatar&#8217;s Avatar API</a>, enhancing the profile without requiring manual uploads. This allows OpenAI to maintain a clean, uncluttered registration form while still creating personalized user experiences after login.</p>\n\n\n\n<img width=\"660\" height=\"391\" src=\"https://blog.gravatar.com/wp-content/uploads/2025/03/open-ai-gravatar-profile-pic.png?w=660\" alt=\"Integrated Gravatar profile picture on an OpenAI profile\" class=\"wp-image-3057\" />\n\n\n\n<h4 class=\"wp-block-heading\"><strong>9. Gravatar</strong></h4>\n\n\n\n<p>Gravatar itself offers perhaps the most efficient sign-up process of all, serving as a universal profile service that streamlines registration across the web. The sign-up flow requires only an email address to create a base profile, with verification handled through that same email.</p>\n\n\n\n<img width=\"1254\" height=\"865\" src=\"https://blog.gravatar.com/wp-content/uploads/2025/03/create-your-profile-page-gravatar-1.png\" alt=\"Gravatar signup page\" class=\"wp-image-3058\" />\n\n\n\n<p>This stripped-down approach perfectly matches Gravatar&#8217;s purpose as an identity service provider. Users create a single profile that follows them across platforms, eliminating the need for repetitive profile creation.</p>\n\n\n\n<p>The system also features intelligent platform detection, automatically identifying if a user has an existing <a href=\"http://wordpress.com\">WordPress.com</a> account and enabling one-click sign-up through that connection. This cross-platform authentication further reduces friction.</p>\n\n\n\n<img width=\"842\" height=\"366\" src=\"https://blog.gravatar.com/wp-content/uploads/2025/03/image.png\" alt=\"Prompt to login to Gravatar with an existing WordPress.com account\" class=\"wp-image-3079\" />\n\n\n\n<p>Gravatar&#8217;s &#8220;universal email profile&#8221; feature is increasingly adopted by major platforms like <a href=\"https://slack.com/\">Slack</a>, <a href=\"https://github.com/\">GitHub</a>, and OpenAI to improve the user onboarding process and enable developers to implement simple sign-up experiences with <a href=\"https://docs.gravatar.com/\">Gravatar&#8217;s API</a>.</p>\n\n\n\n<p>The &#8220;update once, sync everywhere&#8221; functionality means users maintain consistent profiles across all integrated platforms with a single update. This dramatically reduces profile management overhead and ensures consistent identity presentation across the web.</p>\n\n\n\n<p>For developers, the <a href=\"https://developer.wordpress.org/rest-api/\">WordPress REST API integration</a> provides a standardized way to incorporate Gravatar profiles into WordPress-based applications, extending this efficiency benefit to the broader WordPress ecosystem with minimal development effort.</p>\n\n\n\n<img width=\"1220\" height=\"836\" src=\"https://blog.gravatar.com/wp-content/uploads/2025/03/profile-settings-wordpress-com-1.png\" alt=\"Example of a WordPress.com profile settings page with a Gravatar profile picture\" class=\"wp-image-3060\" />\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Elevate your sign-up experience now</strong></h2>\n\n\n\n<p>Implementing thoughtful sign-up optimizations transforms first interactions from barriers into conversion tools. The best pages share key traits: minimalist design requesting only essential information, strategic social proof building trust, and careful form optimization maintaining registration momentum.</p>\n\n\n\n<p>For teams managing user profiles at scale, email-based identity management through Gravatar offers an elegant solution. This &#8220;profile service provider&#8221; approach creates immediate benefits for both developers and users.</p>\n\n\n\n<p>When users update their Gravatar profiles, changes automatically sync across all integrated platforms, keeping user data current without additional input. This simplifies onboarding while enhancing personalization through API-driven information exchange.</p>\n\n\n\n<p>Gravatar integration provides three key advantages:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Universal profile recognition across major platforms.</li>\n\n\n\n<li>Automatic synchronization of user information updates.</li>\n\n\n\n<li>Simplified development with <a href=\"https://docs.gravatar.com/getting-started/\">standardized API integration</a>.</li>\n</ul>\n\n\n\n<p>Modern sign-up processes create user-friendly, branded experiences that set the tone for your entire user relationship. Ready to transform your sign-up process? Get started with <a href=\"https://docs.gravatar.com/\">Gravatar&#8217;s developer documentation</a> today.</p>\n\n\n\n<a href=\"https://docs.gravatar.com/getting-started/\"><img width=\"3242\" height=\"729\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/12/gravatar_integration_cta.png\" alt=\"\" class=\"wp-image-2632\" /></a>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 11 Apr 2025 14:56:46 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Ronnie Burt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:35;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"Do The Woo Community: Do the Woo Friday Shares, April 11, 2025 v14\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"https://dothewoo.io/?post_type=blog&p=94248\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"https://dothewoo.io/blog/do-the-woo-friday-shares-april-11-2025-v14/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"Our list of of curated content across the Woo, WordPress and Open Web community.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 11 Apr 2025 12:42:09 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:36;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"Do The Woo Community: Should You Make Your Podcast Seasonal?\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"https://dothewoo.io/?post_type=blog&p=93353\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"https://dothewoo.io/blog/should-you-make-your-podcast-seasonal/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:222:\"BobWP talks about the benefits of seasonal podcasts, such as providing breaks and fostering creativity. He suggests thematic seasons and shorter podcasts can enhance growth while emphasizing consistency and goal alignment.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 11 Apr 2025 08:21:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:37;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"WordCamp Central: Women in Tech – Ajmer: A Celebration of Empowerment and Connection\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://central.wordcamp.org/?p=10201616\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:106:\"https://central.wordcamp.org/news/2025/04/women-in-tech-ajmer-a-celebration-of-empowerment-and-connection/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:16292:\"<p><strong>What an incredible Women’s Day celebration this year! Women supporting Women is a true celebration of strength and unity.</strong> Seeing pictures of Women&#8217;s Day celebrations from across the globe has been nothing short of inspiring. It’s a powerful reminder that incredible things happen when women support each other. </p>\n\n\n\n<p>On March 8, 2025, the Ajmer WordPress community hosted a remarkable <strong>Women in Tech</strong> event at The Fern Residency, Vaishali Nagar, Ajmer. This event was part of a larger global initiative supported by <strong>WordPress</strong>, aimed at creating a welcoming space for women in tech to connect, learn, and grow.</p>\n\n\n\n<a href=\"https://events.wordpress.org/ajmer/2025/WomensDay/files/2025/04/event-group-photo-scaled.jpg\"><img src=\"https://events.wordpress.org/ajmer/2025/WomensDay/files/2025/04/event-group-photo-scaled.jpg\" alt=\"\" /></a>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>The Inspiration Behind the Event</strong></h2>\n\n\n\n<p>This event was part of a <strong>global initiative</strong> led by the <strong>Make WordPress Community Team</strong> to celebrate and empower women in tech. The idea was to create a space where women could connect, learn, and grow by organizing events exclusively led by women — from organizers and speakers to volunteers. This initiative aimed to encourage more women to take active roles in WordPress events, fostering inclusivity and representation. You can learn more about this inspiring movement at <a href=\"https://make.wordpress.org/community/2024/12/19/hosting-wordpress-events-for-women-on-international-womens-day/\">Hosting WordPress Events for Women on International Women’s Day</a>. As part of this incredible initiative, <strong>25+ Women’s Day celebration events</strong> took place in different cities across the globe, showcasing the collective effort to empower and uplift women in WordPress and technology.</p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>The Planning Phase</strong></h2>\n\n\n\n<p>When I decided to be part of this initiative and organize a women-centric event in our city, I discussed the idea with <strong>Priyanshi</strong>. Together, we brainstormed the event format — outlining key details such as the required budget, the structure of the event day, and forming a dedicated team of volunteers. We also explored potential speakers and actively reached out to women working in various IT sectors. Our vision included a mix of <strong>inspiring sessions</strong>, <strong>engaging speakers</strong>, <strong>fun activities</strong>, and meaningful interactions. This initial plan laid the foundation for what turned out to be a memorable and impactful event. <strong>This picture is from our first planning meeting</strong>, where we began shaping the ideas that brought this event to life.</p>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-core-columns-is-layout-9d6595d7 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<a href=\"https://events.wordpress.org/ajmer/2025/WomensDay/files/2025/04/IMG_8800-scaled.jpg\"><img src=\"https://events.wordpress.org/ajmer/2025/WomensDay/files/2025/04/IMG_8800-scaled.jpg\" alt=\"\" /></a>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<a href=\"https://events.wordpress.org/ajmer/2025/WomensDay/files/2025/04/IMG_8804-scaled.jpg\"><img src=\"https://events.wordpress.org/ajmer/2025/WomensDay/files/2025/04/IMG_8804-scaled.jpg\" alt=\"\" /></a>\n</div>\n</div>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Overcoming Challenges: A Journey of Determination in Ajmer</strong></h2>\n\n\n\n<p>Organizing the <strong>Women in Tech – Ajmer</strong> event was an incredible journey, but it wasn&#8217;t without its challenges. One major hurdle we faced was reaching our target audience. Bringing together <strong>50-60 women</strong> from the tech industry in Ajmer seemed daunting at first, especially considering the limited number of local IT companies and the unfamiliarity of WordPress events in the region.</p>\n\n\n\n<p>To overcome this, our team took proactive steps — we personally reached out to IT companies, educational institutions, and other local tech communities. Through consistent social media promotions and word-of-mouth efforts, we gradually built interest and engagement. The result? Over <strong>50 attendees</strong> on event day — a remarkable turnout that exceeded our expectations.</p>\n\n\n\n<p>What made this even more special was that some attendees traveled from <strong>nearby cities like Beawar and Jodhpur, spending over four hours on the journey</strong> just to be part of this celebration. Their commitment was truly inspiring and a heartwarming reminder of the growing enthusiasm for WordPress and tech opportunities in our region.</p>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-core-columns-is-layout-9d6595d7 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<a href=\"https://events.wordpress.org/ajmer/2025/WomensDay/files/2025/04/Women-day-attendee-scaled.jpg\"><img src=\"https://events.wordpress.org/ajmer/2025/WomensDay/files/2025/04/Women-day-attendee-scaled.jpg\" alt=\"\" /></a>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<a href=\"https://events.wordpress.org/ajmer/2025/WomensDay/files/2025/04/all-attendees-scaled.jpg\"><img src=\"https://events.wordpress.org/ajmer/2025/WomensDay/files/2025/04/all-attendees-scaled.jpg\" alt=\"\" /></a>\n</div>\n</div>\n\n\n\n<p>Another unexpected challenge occurred just one day before the event when a <strong>citywide curfew</strong> was announced, restricting movement until <strong>5 PM</strong> on the event day. Despite this uncertainty, our team remained calm, kept communication open with attendees, and ensured everything was ready to proceed smoothly once the curfew was lifted. Thanks to the dedication of our volunteers and the patience of our attendees, the event went ahead successfully.</p>\n\n\n\n<p>These challenges only strengthened our resolve, and the end result — seeing women connect, learn, and celebrate together — made every effort worthwhile. This experience reinforced the power of persistence, teamwork, and community support in turning challenges into triumphs.</p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Memorable Sessions and Activities</strong></h2>\n\n\n\n<p>We were privileged to host inspiring speakers who graciously dedicated their time to share their expertise and motivate our attendees:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Divya Vyas</strong> shared her journey and spoke on <strong>&#8220;Empower and Elevate&#8221;</strong>, discussing her 16+ years in tech and valuable career insights.</li>\n\n\n\n<li><strong>Payal Loungani</strong> addressed the crucial topic of <strong>mental health</strong>, emphasizing self-care and balance in professional life.</li>\n\n\n\n<li><strong>Meenakshi Dholpuriya</strong> presented <strong>&#8220;From Dreamer to Doer: The Power of Taking Risks&#8221;</strong>, sharing her inspiring story of taking bold steps that led to her success.</li>\n</ul>\n\n\n\n<p>We are incredibly grateful to these speakers for making the event impactful and memorable.</p>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-core-columns-is-layout-9d6595d7 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<a href=\"https://events.wordpress.org/ajmer/2025/WomensDay/files/2025/04/divya-vyas-scaled.jpg\"><img src=\"https://events.wordpress.org/ajmer/2025/WomensDay/files/2025/04/divya-vyas-scaled.jpg\" alt=\"\" /></a>Divya Vyas\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<a href=\"https://events.wordpress.org/ajmer/2025/WomensDay/files/2025/04/payal-scaled.jpg\"><img src=\"https://events.wordpress.org/ajmer/2025/WomensDay/files/2025/04/payal-scaled.jpg\" alt=\"\" /></a>Payal Loungani\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<a href=\"https://events.wordpress.org/ajmer/2025/WomensDay/files/2025/04/meenakshi-scaled.jpg\"><img src=\"https://events.wordpress.org/ajmer/2025/WomensDay/files/2025/04/meenakshi-scaled.jpg\" alt=\"\" /></a>Meenakshi Dholpuriya\n</div>\n</div>\n\n\n\n<p>The evening began with warm opening remarks from my fellow organizer, <strong>Priyanshi</strong>, followed by incredible support from our dedicated volunteers: <strong>Rashi Gupta</strong>, <strong>Stuti Goyal</strong>, <strong>Chitra Chauhan</strong>, <strong>Divya Khatri</strong>, <strong>Palak Gandhi</strong>, <strong>Dolvi Tak</strong>, <strong>Manvi Singh</strong>, and <strong>Harshita Mathur</strong>. A warm thanks to <strong>Mahima Golani</strong>, who stepped up at the last minute to handle photography and video reels beautifully.</p>\n\n\n\n<a href=\"https://events.wordpress.org/ajmer/2025/WomensDay/files/2025/04/Volunteer-group-photo-scaled.jpg\"><img src=\"https://events.wordpress.org/ajmer/2025/WomensDay/files/2025/04/Volunteer-group-photo-scaled.jpg\" alt=\"\" /></a>\n\n\n\n<p>The event included:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>High tea and snacks</strong> at the start.</li>\n\n\n\n<li><strong>Inspiring sessions</strong>, <strong>networking opportunities</strong>, and <strong>connecting with industry experts</strong>.</li>\n\n\n\n<li><strong>Quizzes, fun games, and a cake-cutting ceremony</strong>.</li>\n\n\n\n<li>Distribution of cool swags and engaging selfie props.</li>\n\n\n\n<li>The evening concluded with a delightful <strong>dinner</strong>, encouraging further networking and bonding.</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Special Thanks to Our Sponsors</strong></h2>\n\n\n\n<p>A heartfelt thank you to our amazing sponsors for their incredible support. This event would not have been possible without your generosity. Your contributions played a crucial role in creating a memorable experience for all attendees, and we are deeply grateful for your commitment to this cause.</p>\n\n\n\n<a href=\"https://events.wordpress.org/ajmer/2025/WomensDay/files/2025/04/sponsors-women-in-tech.png\"><img src=\"https://events.wordpress.org/ajmer/2025/WomensDay/files/2025/04/sponsors-women-in-tech.png\" alt=\"\" /></a>\n\n\n\n<p>Our heartfelt gratitude to:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>A2 Hosting</strong>, <strong>Bluehost</strong>, <strong>Hostinger</strong>, <strong>Elementor</strong>, <strong>Jetpack</strong>, <strong>Woo</strong>, and <strong>WPVibes</strong> as our <strong>Community Sponsors</strong>.</li>\n\n\n\n<li><strong>Yoast</strong> as our <strong>Dinner Sponsor</strong>.</li>\n\n\n\n<li><strong>CB Video Vision</strong> for their invaluable <strong>in-kind support</strong>, helping us set up the LED screen and stage setup.</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>The Impact</strong></h2>\n\n\n\n<p>This event created a meaningful and lasting impact on our community. Women felt genuinely welcomed and valued, fostering a strong sense of belonging within the WordPress ecosystem. The initiative empowered them to speak openly, share ideas without hesitation, and feel confident about exploring more opportunities. Their joy, excitement, and connection with like-minded women were truly heartwarming.</p>\n\n\n\n<p>Many attendees expressed feeling special and appreciated, which encouraged them to engage in future WordPress events. The supportive and comfortable environment allowed women to share their thoughts without hesitation.</p>\n\n\n\n<p>This initiative has not only inspired women to take part in WordPress but also paved the way for greater female representation in tech leadership roles, empowering them to contribute, lead, and thrive in the industry.</p>\n\n\n\n<p>Some of the attendees shared their feedback:</p>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-core-columns-is-layout-9d6595d7 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<a href=\"https://events.wordpress.org/ajmer/2025/WomensDay/files/2025/04/mahima-feedback.png\"><img src=\"https://events.wordpress.org/ajmer/2025/WomensDay/files/2025/04/mahima-feedback.png\" alt=\"\" /></a>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<a href=\"https://events.wordpress.org/ajmer/2025/WomensDay/files/2025/04/richa-feedback.png\"><img src=\"https://events.wordpress.org/ajmer/2025/WomensDay/files/2025/04/richa-feedback.png\" alt=\"\" /></a>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<a href=\"https://events.wordpress.org/ajmer/2025/WomensDay/files/2025/04/tanisha-feedback.png\"><img src=\"https://events.wordpress.org/ajmer/2025/WomensDay/files/2025/04/tanisha-feedback.png\" alt=\"\" /></a>\n</div>\n</div>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-core-columns-is-layout-9d6595d7 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<a href=\"https://events.wordpress.org/ajmer/2025/WomensDay/files/2025/04/rupali-feedback.png\"><img src=\"https://events.wordpress.org/ajmer/2025/WomensDay/files/2025/04/rupali-feedback.png\" alt=\"\" /></a>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<a href=\"https://events.wordpress.org/ajmer/2025/WomensDay/files/2025/04/payal-feedabck.png\"><img src=\"https://events.wordpress.org/ajmer/2025/WomensDay/files/2025/04/payal-feedabck.png\" alt=\"\" /></a>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<a href=\"https://events.wordpress.org/ajmer/2025/WomensDay/files/2025/04/law-prep-feedback.png\"><img src=\"https://events.wordpress.org/ajmer/2025/WomensDay/files/2025/04/law-prep-feedback.png\" alt=\"\" /></a>\n</div>\n</div>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-core-columns-is-layout-9d6595d7 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<a href=\"https://events.wordpress.org/ajmer/2025/WomensDay/files/2025/04/rashi-feedback.png\"><img src=\"https://events.wordpress.org/ajmer/2025/WomensDay/files/2025/04/rashi-feedback.png\" alt=\"\" /></a>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<a href=\"https://events.wordpress.org/ajmer/2025/WomensDay/files/2025/04/hanish-feedback.png\"><img src=\"https://events.wordpress.org/ajmer/2025/WomensDay/files/2025/04/hanish-feedback.png\" alt=\"\" /></a>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<a href=\"https://events.wordpress.org/ajmer/2025/WomensDay/files/2025/04/kajal-feedback.png\"><img src=\"https://events.wordpress.org/ajmer/2025/WomensDay/files/2025/04/kajal-feedback.png\" alt=\"\" /></a>\n</div>\n</div>\n\n\n\n<h2 class=\"wp-block-heading\">Event Highlights</h2>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"instagram-media\"><div> <a href=\"https://www.instagram.com/reel/DHbBdILhMhL/?utm_source=ig_embed&utm_campaign=loading\" target=\"_blank\"> <div> <div></div> <div> <div></div> <div></div></div></div><div></div> <div></div><div> <div>View this post on Instagram</div></div><div></div> <div><div> <div></div> <div></div> <div></div></div><div> <div></div> <div></div></div><div> <div></div> <div></div> <div></div></div></div> <div> <div></div> <div></div></div></a><p><a href=\"https://www.instagram.com/reel/DHbBdILhMhL/?utm_source=ig_embed&utm_campaign=loading\" target=\"_blank\">A post shared by WPAjmer (@wpajmer)</a></p></div></blockquote>\n</div>\n\n\n\n<p>The <strong>Women in Tech – Ajmer</strong> event was a powerful step toward increasing female representation in WordPress leadership roles, and I’m incredibly proud of what we achieved together. The dedication of the volunteers, the passion of the speakers, and the unwavering support from our sponsors made this initiative a resounding success.</p>\n\n\n\n<p>This incredible journey wouldn&#8217;t have been possible without the WordPress community&#8217;s collaborative spirit. Here’s to breaking barriers and empowering more women to shine in tech! <img src=\"https://s.w.org/images/core/emoji/15.1.0/72x72/1f680.png\" alt=\"🚀\" class=\"wp-smiley\" /><img src=\"https://s.w.org/images/core/emoji/15.1.0/72x72/2728.png\" alt=\"✨\" class=\"wp-smiley\" /></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 11 Apr 2025 07:22:55 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Pooja Derashri\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:38;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:91:\"Do The Woo Community: The Power of Customer Service in Building a WordPress Plugin Business\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"https://dothewoo.io/?post_type=blog&p=93964\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:95:\"https://dothewoo.io/blog/the-power-of-customer-service-in-building-a-wordpress-plugin-business/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:192:\"A plugin business involves strategic decisions, challenges in development, customer support intricacies, and the importance of personal branding in the evolving world of open-source platforms.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 10 Apr 2025 08:33:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:39;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"Gravatar: New ‘Tools’ For Your Digital Identity\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"http://blog.gravatar.com/?p=3137\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"https://blog.gravatar.com/2025/04/09/new-tools-for-your-digital-identity/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3424:\"<p>Your Gravatar profile just got smarter with a handful of updates that make sharing your digital identity even easier.</p>\n\n\n\n<p>You will find them all under a new <strong>Tools</strong> menu in your profile editor, packed with features to help you connect and share across the web. </p>\n\n\n\n<p>Here&#8217;s what&#8217;s new:</p>\n\n\n\n<h2 class=\"wp-block-heading\">Card Customization</h2>\n\n\n\n<img width=\"2376\" height=\"1216\" src=\"https://blog.gravatar.com/wp-content/uploads/2025/04/cleanshot-2025-04-08-at-17.18.59402x.png\" alt=\"\" class=\"wp-image-3141\" />\n\n\n\n<p>Those little Gravatar cards that appear when you comment on WordPress sites and around the web? You&#8217;re now in control of how they look! Choose to include your header image, add a contact button, or enable the &#8220;send money&#8221; feature.</p>\n\n\n\n<p>It is the new digital business card. With one click, you can copy the HTML code for your card to display on any website.</p>\n\n\n\n<p>Find and edit your card under the new <a href=\"https://gravatar.com/profile/tools/card\">Tools &gt; Card</a> menu item.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Email Signature Generator</h2>\n\n\n\n<img width=\"2086\" height=\"970\" src=\"https://blog.gravatar.com/wp-content/uploads/2025/02/cleanshot-2025-02-18-at-12.24.39402x.png\" alt=\"\" class=\"wp-image-2932\" />\n\n\n\n<p>Make every email count with your personalized Gravatar signature. It&#8217;s like your card, but perfectly formatted for email. Copy the code once, paste it into Gmail, Outlook, or your preferred email tool, and you&#8217;re set.</p>\n\n\n\n<p>The email signature now has a new easier to find home under <a href=\"https://gravatar.com/profile/tools/email-signature\">Tools &gt; Email signature</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Smart Redirects Get A Home</h2>\n\n\n\n<img width=\"2318\" height=\"1194\" src=\"https://blog.gravatar.com/wp-content/uploads/2025/04/cleanshot-2025-04-08-at-17.28.25402x.png\" alt=\"\" class=\"wp-image-3145\" />\n\n\n\n<p>For custom domain users, we&#8217;ve made it even easier to copy and share your smart redirects. These are the magic links Gravatar automatically creates for you – like your-name.link/linkedin or your-name.link/calendar.</p>\n\n\n\n<p>See the full list in one new place under <a href=\"https://gravatar.com/profile/tools/smart-redirects\">Tools &gt; Smart redirects</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Private Messages, Simplified</h2>\n\n\n\n<img width=\"2292\" height=\"1172\" src=\"https://blog.gravatar.com/wp-content/uploads/2025/04/cleanshot-2025-04-08-at-17.29.53402x.png\" alt=\"\" class=\"wp-image-3147\" />\n\n\n\n<p>We&#8217;ve clarified how our simple contact form works with a dedicated Private messages menu. When enabled, anyone can send you a short message, but with important safeguards:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>They can only contact you once</li>\n\n\n\n<li>You see their complete Gravatar profile</li>\n\n\n\n<li>Your email and private contact info stays hidden</li>\n</ul>\n\n\n\n<p>Enable the contact form on your profile under the new <a href=\"https://gravatar.com/profile/contact-info\">Tools &gt; Private messages</a> menu.</p>\n\n\n\n<p>These small improvements add up to a more connected, streamlined experience for your online identity. And as always, we&#8217;re working on more fun features and tools, so stay tuned!</p>\n\n\n\n<p>To check these out, <a href=\"https://gravatar.com/profile\">edit your profile</a> and look for the <strong>Tools</strong> option in the sidebar.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 09 Apr 2025 17:23:50 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Ronnie Burt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:40;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"Matt: AI Site Builder\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=141197\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"https://ma.tt/2025/04/ai-site-builder/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:563:\"<p>The long-anticipated <a href=\"https://wordpress.com/ai-website-builder/?ref=blog\">&#8220;Big Sky&#8221; AI site builder on WordPress.com went live today</a>. It combines several models and can create logos, site designs, typography, color schemes, and content. It&#8217;s an entirely new way to interact with and edit a brand-new or existing WordPress site. This AI agent will make WordPress accessible to an entirely new generation and class of customers, and it will be a power tool for professionals to do things in minutes that used to take them hours.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 09 Apr 2025 17:14:06 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:41;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:89:\"Do The Woo Community: Navigating the Accessibility Landscape: Real Stories with Bud Kraus\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=94129\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:87:\"https://dothewoo.io/navigating-the-accessibility-landscape-real-stories-with-bud-kraus/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:215:\"In this podcast episode, hosts Anne Bovelett and BobWP, along with guest Bud Kraus, explore ecommerce accessibility, discussing user experiences, challenges, and the importance of inclusive web design for all users.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 09 Apr 2025 15:13:19 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:42;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:113:\"HeroPress: How WordPress Changed My Life — Gratitude – Como o WordPress Mudou a Minha Realidade – Gratidão\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://heropress.com/?post_type=heropress-essays&p=7856\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:152:\"https://heropress.com/essays/how-wordpress-changed-my-life-gratitude/#utm_source=rss&utm_medium=rss&utm_campaign=how-wordpress-changed-my-life-gratitude\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:22331:\"<img width=\"1024\" height=\"512\" src=\"https://heropress.com/wp-content/uploads/3025/04/040925-min.jpg\" class=\"attachment-large size-large wp-post-image\" alt=\"Pull Quote: WordPress turned out to be so much more than just a tool — it changed my life.\" />\nHere is Caio reading his own story aloud.\n\n\n\n\n\n<p><a href=\"https://heropress.com/feed/#portuguese\">O texto também está disponível em português do Brasil.</a></p>\n\n\n\n<p>My name is Caio Ferreira and I&#8217;ve been using WordPress since 2020. In this article I&#8217;ll tell you a little about my history with this platform and how it changed everything &#8211; from experimental business ideas &#8211; to a real professional experience.</p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"h-my-childhood\">My childhood</h2>\n\n\n\n<p>I&#8217;ve always been passionate about technology, even as a kid. When we got our first computer at home — one of those classic white models my father bought in many installments — it became the main attraction in the house. And rightfully so: it sat in the living room, where everyone could see it.</p>\n\n\n\n<p>Back then, I was already browsing the internet, exploring system settings, customizing Windows XP, and maybe (just maybe) installing a few viruses or unwanted installers here and there.</p>\n\n\n\n<p>Despite the limitations, I had a lot of fun creating blogs, managing Facebook communities, and trying out platforms like Blogger, Wix, Squarespace — basically anything free that allowed me to publish something online. I didn’t have much technical knowledge, and even less money to invest. But I already had this strong desire to share my ideas with the world.</p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"h-discovering-wordpress\">Discovering WordPress</h2>\n\n\n\n<p>Besides the blogs, I loved creating websites for imaginary businesses that never really existed — and honestly wouldn’t work in any real-world scenario. But the excitement was real. Every time a new idea came up, I would recruit some friends to &#8220;invest&#8221; in it and try to convince them it was just a matter of time before we made a lot of money — like the success stories we saw on TV.</p>\n\n\n\n<p>In one of these pitches, I showed a site I had built on Wix to a more experienced friend, and he asked me: </p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>“Why are you using Wix? Have you ever tried WordPress?” </p>\n</blockquote>\n\n\n\n<p>That sparked something in me. I had heard of WordPress before but thought it was too complex. Plus, I was always stopped by the need for paid hosting.</p>\n\n\n\n<p>Still, my curiosity got the best of me. I started researching more seriously and quickly realized WordPress was far more powerful than any tool I had used before. But the cost barrier remained. So I put the idea on hold, waiting for the right time to dive in.</p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"h-high-school-searching-for-direction\">High school: searching for direction</h2>\n\n\n\n<p>High school felt like a marathon. I didn’t really know where I was going, but I knew I had to keep moving. I didn’t have any career role models, nor pressure to follow a specific path. The only reference points were what I saw on TV or heard from distant relatives — law, engineering… the so-called “safe” careers parents often dream of.</p>\n\n\n\n<p>Even without a clear direction, I was always committed. I learned English on my own playing RPGs online and created a Duolingo account back in 2014. I used to take part in school competitions — even math ones — not because I was the best, but because I saw them as a chance to stand out. </p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>If I didn’t have obvious advantages, I’d create my own.</p>\n</blockquote>\n\n\n\n<p>That mindset led me to participate in the Junior Achievement &#8220;Junior Company&#8221; program. Our school was selected to form a student-run fictional business, funded by the local government. That experience was life-changing.</p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"h-my-junior-company-volunteering-and-a-visit-to-a-startup\">My junior company, volunteering, and a visit to a startup</h2>\n\n\n\n<p>Even though I was just in my first year of high school — and technically under the age requirement — I asked to join the program and, more boldly, applied to be the company’s president. I put on a dress shirt, prepared a speech, and was elected.</p>\n\n\n\n<p>Despite having no real experience, we ended up doing well. Our project turned a small profit (a few reais per “shareholder,” but still, profit!). That success motivated me to stay involved with Junior Achievement. I started volunteering and joined more programs.</p>\n\n\n\n<p>One of those opportunities allowed me to spend a day inside a startup in Belo Horizonte. I had never even set foot in a corporate office before — let alone a startup with a playful office, relaxed people, and even a ball pit!</p>\n\n\n\n<p>I brought a notebook and wrote down everything I could. The whole experience left me stunned. Up until then, I thought work environments were dull and gray, with strict rules and judgment over things like shoes and dress codes.</p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"h-my-first-job-in-that-same-company\">My first job — in that same company?</h2>\n\n\n\n<p>A few days after the visit, encouraged by the staff, I created a LinkedIn profile and started sharing every experience I had, no matter how small. Around that time, they gave me access to a free WordPress course. I loved it. I wasn’t just taking the course — I was exploring on my own and learning as much as I could.</p>\n\n\n\n<p>I kept in touch with the people I had met, interacted with their posts, and shared my progress. Then, one day, I received a message that changed everything.</p>\n\n\n\n<p>One of the employees who hosted us at the office reached out: the company was looking for someone like me to join the team. </p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>I had recorded a few videos after the visit expressing how much the experience meant to me — and somehow, that had reached them.</p>\n</blockquote>\n\n\n\n<p>I was still finishing high school at the time, just 17 years old, when I got the offer. The following year, I started working there as an assistant and began my Computer Science degree on a scholarship.</p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"h-promotion-to-developer\">Promotion to developer</h2>\n\n\n\n<p>In my first two years, I worked mostly with SEO and content distribution, handling a variety of CMS platforms. But WordPress had my heart from day one. Its flexibility, the power to customize everything, and the massive community — it was everything I loved.</p>\n\n\n\n<p>Eventually, an opportunity opened for an internal role as a web developer — and I jumped at it. I went through the selection process and got the position.</p>\n\n\n\n<p>Our team was partly based in Brazil, led by our manager Manny, who was in Canada. It was the perfect challenge: a chance to leave my comfort zone and practice English daily. Manny even learned a few Portuguese words with us.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>As a developer, I dove deep into WordPress.</p>\n</blockquote>\n\n\n\n<p>Each project pushed my limits and made me grow. It was around this time that I also got involved with the WordPress community in my city.</p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"h-how-wordpress-changed-my-reality\">How WordPress changed my reality</h2>\n\n\n\n<p>WordPress turned out to be so much more than just a tool — it changed my life.</p>\n\n\n\n<p>With the income I earned through projects using the platform, I was able to make a down payment on my first apartment. </p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>That same kid who couldn’t afford hosting fees was now buying property.</p>\n</blockquote>\n\n\n\n<p>And it didn’t stop there. In 2022, I received a job offer from a company in the United States — something I would’ve never dreamed of just a few years earlier.</p>\n\n\n\n<p>That same year, I attended my first WordPress meetup (still during the pandemic), and later, my first WordCamp as a participant — held remotely in São Paulo. It felt like everything was starting to connect.</p>\n\n\n\n<p>And as if all that wasn’t enough, I married the love of my life. It was a simple ceremony, but one we had always dreamed of — made possible, in large part, thanks to the income I earned working with WordPress.</p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"h-returning-to-the-community\">Returning to the Community</h2>\n\n\n\n<p>In 2025, we resumed in-person WordPress community meetups after the pandemic. I was nervous — what if no one showed up?</p>\n\n\n\n<p>But they did. We had 25 people, all engaged and eager to contribute, learn, and share. That meetup was a turning point for me. </p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>I realized I could lead, organize, and give back.</p>\n</blockquote>\n\n\n\n<p>Today, I’m actively involved in the community — helping plan events, staying connected with members, and always looking for new ways to contribute. WordPress didn’t just help me build a career — it helped shape who I am.</p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"h-the-importance-of-english\">The Importance of English</h2>\n\n\n\n<p><a href=\"https://heropress.com/essays/journey-resilience/\">Like Rafael shared in another HeroPress story</a>, English remains a big challenge for many of us in Brazil — but also a powerful key.</p>\n\n\n\n<p>I’m far from fluent, but I keep learning. Each Duolingo lesson, each YouTube tutorial, each Slack conversation with my international team is a step forward. </p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>What matters is not giving up.</p>\n</blockquote>\n\n\n\n<p>Because if there’s one thing I’ve learned from this entire journey, it’s that everything can change. Sometimes, all we need is a small opportunity, a bit of encouragement — or simply, a platform like WordPress.</p>\n\n\n<div class=\"kb-row-layout-wrap kb-row-layout-id7856_47d34c-b3 alignnone kt-row-has-bg wp-block-kadence-rowlayout\"><div class=\"kt-row-column-wrap kt-has-1-columns kt-row-layout-equal kt-tab-layout-inherit kt-mobile-layout-row kt-row-valign-top\">\n\n<div class=\"wp-block-kadence-column kadence-column7856_92e2da-1b\"><div class=\"kt-inside-inner-col\">\n<h2 id=\"work-environment\" class=\"kt-adv-heading7856_420812-bc wp-block-kadence-advancedheading\">Caio&#8217;s Work Environment</h2>\n\n\n\n<p>We asked Caio for a view into his development life and this is what he sent!</p>\n\n\n	<div class=\"hotspots-image-container\">\n		<img width=\"2016\" height=\"1512\" src=\"https://heropress.com/wp-content/uploads/2025/04/my-desk-1.webp\" alt=\"Caio\'s Desktop\" class=\"hotspots-image skip-lazy\" />\n	</div>\n\n\n\n\n<p class=\"kt-adv-heading7856_686471-4d wp-block-kadence-advancedheading has-theme-palette-9-background-color has-background\">HeroPress would like to thank <a href=\"https://wpdrawattention.com/\">Draw Attention</a> for their donation of the plugin to make this interactive image!</p>\n</div></div>\n\n</div></div>\n\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<h1 id=\"portuguese\" class=\"kt-adv-heading7856_6bd26d-2d wp-block-kadence-advancedheading\">Como o WordPress Mudou a Minha Realidade &#8211; Gratidão</h1>\n\n\n\nAqui está o Caio lendo sua própria história em voz alta.\n\n\n\n\n\n<p>Oi! Eu me chamo Caio Ferreira e venho utilizando o WordPress desde 2020. Hoje quero compartilhar um pouco da minha trajetória com essa plataforma e como ela transformou tudo na minha vida – desde ideias de negócios experimentais até uma carreira profissional de verdade.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Na minha infância</h2>\n\n\n\n<p>Sempre gostei muito de tecnologia desde pequeno. Ainda novo, quando recebemos o nosso primeiro computador em casa, tudo ainda era muito novo. Era um daqueles modelos brancos, que meu pai comprou dividido em muitas vezes, e que virou a atração da casa — também não era pra menos: ele ficava na sala de estar, onde todo mundo via.</p>\n\n\n\n<p>Naquele tempo, eu já navegava na internet, procurava formas de fuçar o sistema, personalizava o Windows XP do jeito que podia, e talvez (só talvez mesmo) tenha instalado alguns vírus ou instaladores indesejados algumas vezes.</p>\n\n\n\n<p>Apesar das limitações, eu me divertia criando blogs, gerenciando comunidades no Facebook e testando plataformas como Blogger, Wix, Squarespace, ou qualquer outra gratuita que me deixasse publicar algo online. Eu não tinha muito conhecimento técnico, e menos ainda dinheiro para investir. Mas já naquela época eu tinha essa vontade de compartilhar ideias com o mundo.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Conhecendo o WordPress</h2>\n\n\n\n<p>Além dos blogs, eu também gostava de criar sites para negócios fictícios, que nunca saíam do papel — e que, honestamente, provavelmente não dariam certo de qualquer jeito. Mas a empolgação era grande. Sempre que surgia uma ideia, eu chamava amigos para “investir” comigo, e tentava convencê-los de que era só uma questão de tempo até aquilo dar certo. Era como víamos nas reportagens de sucesso na televisão.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>Em uma dessas aventuras, mostrei o site para um amigo mais experiente, que me perguntou por que eu estava usando o Wix. Ele comentou que existiam outras opções com mais possibilidades, como o WordPress. </p>\n</blockquote>\n\n\n\n<p>Eu já tinha ouvido falar do WordPress, mas achava complexo demais — e, além disso, sempre esbarrava na questão da hospedagem paga.</p>\n\n\n\n<p>Mesmo assim, aquilo me deixou curioso. Comecei a pesquisar mais a fundo, entendi que o WordPress era muito mais robusto do que qualquer ferramenta que eu tinha usado até então, mas acabei deixando de lado naquele momento. Afinal, eu não tinha como pagar uma hospedagem. Guardei a ideia comigo, esperando por um momento em que ela fizesse mais sentido.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Meu ensino médio</h2>\n\n\n\n<p>O ensino médio foi uma maratona. Eu não sabia ao certo onde queria chegar, mas tinha pressa em encontrar esse “algum lugar”. Não tive exemplos próximos de carreira, nem cobrança direta para seguir determinada profissão. As referências eram as mesmas de muita gente: Direito? Engenharia? Os “cursos de sucesso” que a TV e alguns parentes diziam valer a pena.</p>\n\n\n\n<p>Mesmo sem um caminho definido, sempre fui esforçado. Aprendi inglês sozinho jogando RPG online e criei minha conta no Duolingo ainda em 2014. Me destacava em atividades que a maioria evitava — como concursos de matemática — mesmo sem ser o melhor. </p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>A ideia era simples: se eu não tinha vantagens competitivas óbvias, eu criaria as minhas. </p>\n</blockquote>\n\n\n\n<p>Me envolver nessas atividades era a forma que eu via para construir algo diferente, já que o mercado de trabalho viria logo.</p>\n\n\n\n<p>Foi com esse espírito que participei do programa Miniempresa da ONG Junior Achievement, onde minha escola foi selecionada para criar uma empresa estudantil fictícia, com tudo financiado pelo governo. Aquilo mudou tudo.</p>\n\n\n\n<p>Minha miniempresa, voluntariado e a primeira visita a uma startup</p>\n\n\n\n<p>Mesmo sendo do primeiro ano, pedi para participar do programa — mesmo sem ter a idade sugerida — e mais: me candidatei para presidente. Usei uma camisa social e um discurso bem montado, e fui escolhido para liderar a miniempresa.</p>\n\n\n\n<p>Apesar da falta de experiência, conseguimos um resultado positivo. A empresa gerou lucro (poucos reais para cada “acionista”, mas ainda assim, lucro). O programa me deixou animado, e comecei a me envolver em outras atividades da Junior Achievement, atuando como voluntário em eventos e ajudando em novos programas.</p>\n\n\n\n<p>Foi em uma dessas iniciativas que surgiu a oportunidade de visitar, por um dia, uma startup em Belo Horizonte. Eu nunca tinha imaginado sequer entrar na sede de uma empresa, quem dirá de uma startup com escritório descolado, pessoas à vontade, piscina de bolinha e um clima completamente diferente do que eu imaginava ser “trabalhar”.</p>\n\n\n\n<p>Levei um caderninho e anotei tudo o que pude. Saí de lá em estado de choque, pensando: “é possível trabalhar num lugar assim?”. Até então, tudo que eu imaginava era o oposto: ambientes cinzentos, baías sem graça e muita formalidade.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Meu primeiro trabalho — e na mesma empresa?</h2>\n\n\n\n<p>Poucos dias depois, incentivado pela visita, criei meu LinkedIn (com ajuda de quem nos recebeu na empresa) e comecei a registrar todas as experiências que já tinha vivido. Também recebi acesso a um curso de WordPress oferecido por eles. Gostei tanto da ferramenta que, além do curso, comecei a explorar muito por conta própria.</p>\n\n\n\n<p>Me mantive em contato com o pessoal da empresa, interagia nas redes, compartilhava o que estava aprendendo — até que uma mensagem mudou tudo.</p>\n\n\n\n<p>Uma das pessoas que nos recebeu durante a visita me chamou no privado: a empresa estava procurando alguém com o meu perfil para integrar o time.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>Eu tinha gravado vídeos contando o quanto aquela experiência tinha me impactado, e isso, de alguma forma, chegou até eles.</p>\n</blockquote>\n\n\n\n<p>Eu ainda estava finalizando o ensino médio, com 17 anos, quando recebi a proposta. No ano seguinte, comecei a trabalhar na empresa como assistente e iniciei minha graduação em Ciência da Computação, com uma bolsa de estudos.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Minha promoção a desenvolvedor</h2>\n\n\n\n<p>Durante os dois primeiros anos, trabalhei com SEO e distribuição de conteúdo, lidando com diversos CMSs. Mas foi o WordPress que capturou minha atenção desde o começo. A versatilidade, a comunidade, a possibilidade de personalização — tudo me encantava.</p>\n\n\n\n<p>Quando surgiu uma vaga internacional dentro da própria empresa para atuar como desenvolvedor web, me inscrevi sem pensar duas vezes. Passei por um processo interno, fui aprovado e comecei a atuar em projetos mais técnicos.</p>\n\n\n\n<p>Nosso time era parcialmente brasileiro e liderado pelo Manny, nosso gerente no Canadá. Foi um baita desafio — e uma excelente oportunidade para praticar inglês no dia a dia. Ele, inclusive, chegou a aprender algumas palavras em português com a gente.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>No novo cargo, mergulhei ainda mais fundo no desenvolvimento com WordPress. </p>\n</blockquote>\n\n\n\n<p>Era ali que eu percebia: cada novo desafio me tirava da zona de conforto, mas me deixava mais preparado.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Como o WordPress transformou minha realidade</h2>\n\n\n\n<p>O WordPress foi muito mais do que uma ferramenta de trabalho. Ele transformou minha realidade.</p>\n\n\n\n<p>Com o que ganhei trabalhando com a plataforma, consegui dar entrada no meu apartamento. </p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>Isso mesmo — aquele mesmo garoto que não podia pagar uma hospedagem agora realizava um sonho pessoal.</p>\n</blockquote>\n\n\n\n<p>E não parou por aí. Em 2022, recebi uma proposta de trabalho de uma empresa dos Estados Unidos. Algo que, anos antes, eu não ousava nem imaginar.</p>\n\n\n\n<p>Naquele mesmo ano, participei do meu primeiro meetup (ainda durante a pandemia), e também do meu primeiro WordCamp como participante — que aconteceu remotamente, em São Paulo. A sensação era de que tudo estava se encaixando.</p>\n\n\n\n<p>E como se não bastasse, me casei com o amor da minha vida. Foi uma cerimônia simples, mas do jeito que sempre sonhamos — e que só foi possível, em grande parte, graças à renda que conquistei trabalhando com WordPress.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Retorno à comunidade</h2>\n\n\n\n<p>Em 2025, com o fim do período pandêmico, retomamos os encontros presenciais da comunidade WordPress da minha cidade. A ansiedade era inevitável: e se ninguém aparecesse?</p>\n\n\n\n<p>Mas apareceram. Foram 25 pessoas — todas engajadas, com vontade de aprender, ensinar, trocar experiências. Aquilo foi um divisor de águas pra mim. </p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>Eu entendi que podia liderar, contribuir, devolver um pouco do que recebi.</p>\n</blockquote>\n\n\n\n<p>Hoje, mantenho contato constante com membros da comunidade, ajudo na organização de encontros e eventos, e continuo buscando espaços e oportunidades para fortalecer esse ecossistema. O WordPress não só me ajudou a construir uma carreira — ele ajudou a moldar quem eu sou.</p>\n\n\n\n<h2 class=\"wp-block-heading\">A importância do inglês</h2>\n\n\n\n<p>Assim como o Rafael contou em <a href=\"https://heropress.com/essays/journey-resilience/#portuguese\">outro texto aqui no HeroPress</a>, o inglês ainda é uma barreira para muitos brasileiros. Mas também é uma chave. Uma chave que, quando girada, abre portas para oportunidades inimagináveis.</p>\n\n\n\n<p>Eu não sou fluente. Mas sigo aprendendo. Cada lição no Duolingo, cada vídeo no YouTube, cada conversa improvisada no Slack internacional da empresa é uma forma de evoluir. </p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>O importante é seguir — mesmo aos poucos, com tropeços.</p>\n</blockquote>\n\n\n\n<p>Porque se tem uma coisa que aprendi nessa jornada toda, é que tudo pode mudar. Às vezes, tudo o que a gente precisa é de um empurrãozinho, uma oportunidade, ou simplesmente&#8230; uma plataforma como o WordPress.</p>\n<p>The post <a href=\"https://heropress.com/essays/how-wordpress-changed-my-life-gratitude/\">How WordPress Changed My Life — Gratitude &#8211; Como o WordPress Mudou a Minha Realidade &#8211; Gratidão</a> appeared first on <a href=\"https://heropress.com\">HeroPress</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 09 Apr 2025 14:54:01 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Caio Ferreira\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:43;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"WPTavern: 164 – Milana Cap on the Interactivity and HTML APIs, and Their Enormous Potential\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://wptavern.com/?post_type=podcast&p=194643\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:107:\"https://wptavern.com/podcast/164-milana-cap-on-the-interactivity-and-html-apis-and-their-enormous-potential\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:44216:\"Transcript<div>\n<p>[00:00:00] <strong>Nathan Wrigley:</strong> Welcome to the Jukebox Podcast from WP Tavern. My name is Nathan Wrigley.</p>\n\n\n\n<p>Jukebox is a podcast which is dedicated to all things WordPress, the people, the events, the plugins, the blocks, the themes, and in this case, how the Interactivity and HTML APIs are transforming the way developers work with WordPress.</p>\n\n\n\n<p>If you&#8217;d like to subscribe to the podcast, you can do that by searching for WP Tavern in your podcast player of choice, or by going to wptavern.com/feed/podcast, and you can copy that URL into most podcast players.</p>\n\n\n\n<p>If you have a topic that you&#8217;d like us to feature on the podcast, I&#8217;m keen to hear from you and hopefully get you, or your idea, featured on the show. Head to wptavern.com/contact/jukebox and use the form there.</p>\n\n\n\n<p>So on the podcast today, we have Milana Cap. Milana is a seasoned WordPress engineer from Serbia working with XWP, and freelancing through Toptal. She&#8217;s not just a developer, she&#8217;s also active in WordPress community roles such as a co-rep for the documentation team, organizer at multiple WordCamps, and a member of the plugin review team.</p>\n\n\n\n<p>We discussed some groundbreaking WordPress features that developers should be aware of, specifically focusing on her presentation at WordCamp Asia in Manila, titled, WordPress gems for developers: Fresh new features you&#8217;ll actually want to use.</p>\n\n\n\n<p>We start the discussion with the Interactivity API. Milana explains how this feature allows blocks within WordPress to communicate seamlessly with one another. Until now, most blocks were just silos of information, they could not communicate with one another. This API enables developers to manage interactivity across multiple blocks without resorting to custom solutions.</p>\n\n\n\n<p>Milana also gets into the HTML API, which underpins the Interactivity API. This empowers developers to manipulate HTML attributes using PHP, thereby reducing the reliance on JavaScript. This not only enhances page load speeds, but also simplifies the code management process. It&#8217;s not something that I&#8217;d heard of, but Milana explains how important it can be in rewriting the DOM for whatever goals you have in mind.</p>\n\n\n\n<p>Throughout the episode, Milana shares examples of these APIs in action, demonstrating how they can simplify and optimize WordPress development projects, particularly at an enterprise level.</p>\n\n\n\n<p>If you&#8217;re a developer looking to leverage these new WordPress features, this episode is for you.</p>\n\n\n\n<p>If you&#8217;re interested in finding out more, you can find all of the links in the show notes by heading to wptavern.com/podcast, where you&#8217;ll find all the other episodes as well.</p>\n\n\n\n<p>And so, without further delay, I bring you Milana Cap.</p>\n\n\n\n<p>I am joined on the podcast by Milana Cap.</p>\n\n\n\n<p>[00:03:32] <strong>Milana Cap:</strong> Yes. Thank you.</p>\n\n\n\n<p>[00:03:33] <strong>Nathan Wrigley:</strong> Thank you. I&#8217;ve had to practice that name several times. It&#8217;s lovely to have you on the podcast today. I&#8217;ve never spoken to Milana before, although I&#8217;ve seen her from afar many times.</p>\n\n\n\n<p>And we&#8217;re facing each other because we&#8217;re in the Philippines. We&#8217;re in Manila. It&#8217;s WordCamp Asia, and Milana is doing a presentation at the event. It is called WordPress gems for developers: fresh new features you&#8217;ll actually want to use.</p>\n\n\n\n<p>Before we get into that conversation Milana, will you just spend a moment introducing yourself. Tell us who you are, where you&#8217;re from, what you do with WordPress, that kind of thing.</p>\n\n\n\n<p>[00:04:07] <strong>Milana Cap:</strong> I&#8217;m Milana Cap from Serbia, and we have the best community in the world. I am currently WordPress Engineer at XWP and also freelancing through Toptal. I am one of the co reps for the documentation team, one of plugin review team members. I&#8217;m also a classical musician and just, you know, being loud all around. I like traveling and speaking at conferences, and that&#8217;s basically it.</p>\n\n\n\n<p>[00:04:38] <strong>Nathan Wrigley:</strong> Can you just tell us a little bit about the bits and pieces going on in Serbia there? You sound quite proud of it. You said it the best or something like that. You&#8217;ve got a vibrant, healthy growing Serbian community.</p>\n\n\n\n<p>[00:04:49] <strong>Milana Cap:</strong> Well, it&#8217;s not really growing, and it&#8217;s not that vibrant as it was. But the core of community that started getting together in 2016, or even before that, we still stayed, and we are still active and they&#8217;re like my brothers. We travel, we plan together. We visit each other in Serbia as friends, and we plan for barbecues and all the other stuff, besides, you know, organising events.</p>\n\n\n\n<p>[00:05:22] <strong>Nathan Wrigley:</strong> So it really is an actual community.</p>\n\n\n\n<p>[00:05:24] <strong>Milana Cap:</strong> Yeah it is.</p>\n\n\n\n<p>[00:05:25] <strong>Nathan Wrigley:</strong> You spend social time together. Oh, that&#8217;s lovely. Yeah, and you mentioned you work with, for, XWP. This is a name that I hear a lot, but I don&#8217;t really know much about the company. Just tell us a little bit about what you do for them, and with them.</p>\n\n\n\n<p>[00:05:39] <strong>Milana Cap:</strong> First of all, they are sponsoring my time at wordpress.org. It&#8217;s an agency that works mainly with enterprise clients. So we do all of it, like building you a new website, or maintaining the existing one, or fixing problems. And it&#8217;s usually, mostly, just enterprise clients.</p>\n\n\n\n<p>[00:05:59] <strong>Nathan Wrigley:</strong> Is that an Australian based company?</p>\n\n\n\n<p>[00:06:02] <strong>Milana Cap:</strong> It&#8217;s kind of, yeah, based. It&#8217;s created there but we are completely remote.</p>\n\n\n\n<p>[00:06:07] <strong>Nathan Wrigley:</strong> Everything distributed, like a global team. Oh, that&#8217;s nice.</p>\n\n\n\n<p>Okay, so let&#8217;s just move on into the topic today. The presentation that you were giving, I&#8217;ll just repeat the title, WordPress gems for developers, fresh new features you&#8217;ll actually want to use. And then I&#8217;ll read the blurb as well because it&#8217;ll give the listeners some context. We&#8217;ll take a closer look at the innovative HTML and Interactivity APIs as the most significant game changers in today&#8217;s WordPress development, with a splash of WP-CLI magic for fast and more fun development. And there might be a surprise or two.</p>\n\n\n\n<p>Well, obviously on the audio podcast, we&#8217;re not going to be able to breakout WPCLI, but nevertheless, we&#8217;re going to talk about those things. We&#8217;re going to concentrate primarily on the Interactivity API. Obviously this is something that you&#8217;d need to get your hands on, you&#8217;d need to be opening a laptop. But we can&#8217;t do that. It&#8217;s an audio podcast. So first of all, let&#8217;s just break into the topic by asking the question, what is the Interactivity API? And let&#8217;s do that from a total novice perspective.</p>\n\n\n\n<p>[00:07:07] <strong>Milana Cap:</strong> Okay, yeah. Well, Interactivity API allows you to get back to the whole page. At least I see it that way. Because before Gutenberg, we were using only PHP, and PHP page is aware of all of its parts. So in header, you know what&#8217;s happening in footer and vice versa.</p>\n\n\n\n<p>But then we got Gutenberg and these blocks didn&#8217;t know about their surroundings. They were just like, oh, I&#8217;m a block here, and I do what I do and I don&#8217;t care about others.</p>\n\n\n\n<p>And it was difficult to get that in your head, like this is a completely separate entity that, once it&#8217;s in a page, you can work with that, but there is no way to connect to it to the rest of the page. And today you have a lot of requests for having interactive page. You know, not just showing the text and people come and read, you need to have something that&#8217;s happening on that page.</p>\n\n\n\n<p>And it was very difficult to, for example, make one block do something and then you use that data in another block, that was insane. And people were trying to do those things in so many different ways. It was a mess. Like, I have a slide with dolls that have misplaced eyes and all of that. That&#8217;s how it looks like.</p>\n\n\n\n<p>So now with Interactivity API we finally get that connection, but it&#8217;s not like hacky thing, it&#8217;s in Core. So every block can be aware of the other block, and you can send the data from one block to all other blocks. And that&#8217;s really what was missing for a long time. And not just in WordPress, we have the same things happening before WordPress, in Symphony, in Laravel. So now we have that too.</p>\n\n\n\n<p>[00:09:04] <strong>Nathan Wrigley:</strong> So let me just try and sum up what you&#8217;ve just said, and see if I&#8217;ve parsed it correctly and understood it. So prior to Gutenberg, given the PHP nature of WordPress, the bits and pieces that were displaying on the page, so header, footer content and what have you, they had some recognition within PHP of what one was doing and what the other was doing.</p>\n\n\n\n<p>And then along comes Gutenberg and we shatter the experience on the page into a variety of different blocks. There&#8217;s an image here, and a paragraph here, and some more text over here, and a heading and what have you. And each of those little blocks is a silo. It lives by itself, for itself, it&#8217;s erected walls around itself so that it can&#8217;t be communicated.</p>\n\n\n\n<p>[00:09:41] <strong>Milana Cap:</strong> It&#8217;s a diva.</p>\n\n\n\n<p>[00:09:41] <strong>Nathan Wrigley:</strong> It can&#8217;t talk out and it can&#8217;t hear things in. And that&#8217;s a problem. I mean, it&#8217;s a brilliant solution if you want to move content around, but If you want one thing to shout to another thing and say, look, I just got clicked, go and update yourself. Add one to yourself, or whatever it may be. So that possibility evaporated.</p>\n\n\n\n<p>But now with the Interactivity API, we&#8217;ve come up with a Core solution. So it ships with WordPress, everybody has it. And suddenly we&#8217;re able to say, okay, I&#8217;m a block, I&#8217;m a button, and when I get clicked, I want you to add one to the cart. And the shopping cart number can increment by one and what have you. So suddenly everything can communicate with everything else. Have I got that about right?</p>\n\n\n\n<p>[00:10:23] <strong>Milana Cap:</strong> Yes.</p>\n\n\n\n<p>[00:10:24] <strong>Nathan Wrigley:</strong> Oh, perfect. Okay. And so I&#8217;ve seen examples of Interactivity over many years since Gutenberg came around, and I&#8217;m imagining that each developer, therefore has had to create their own way of doing it. And presumably that works for them, but it doesn&#8217;t work for the project as a whole.</p>\n\n\n\n<p>[00:10:44] <strong>Milana Cap:</strong> Not just that. It might work for them but, let&#8217;s say you have a plugin and your plugin is doing that interactive thing with your own blocks. But me as another developer, I want maybe to enhance your blocks, but I don&#8217;t have access to whatever is happening in your blocks. So whatever you are doing, like counting stuff and changing something, I don&#8217;t have that info. So I have to do, again, hacky thing.</p>\n\n\n\n<p>But with Interactivity API, I have a standardised access to that. So I can, you know, set my blocks to support Interactivity API. And I can get, with just one function, I can get all the data from your blocks and work with them, and it&#8217;s completely in Core. It&#8217;s standardised. And anybody can take my data and, you know, this data and do whatever they want with that. And it&#8217;s not just that it&#8217;s easy to get that data, but we all do it the same way. So when I open your block, I know exactly what I will find there. I know exactly how to get that data, and how to provide to others.</p>\n\n\n\n<p>[00:11:58] <strong>Nathan Wrigley:</strong> So the benefit is basically that it&#8217;s a standard mechanism. Everybody knows what the rules of the game are. So in the past, the experiences that I&#8217;ve seen online where plugin A has been able to clearly demonstrate this interactivity, a different developer coming to that would have to learn how plugin A does it, and then if they go and try and do the same thing for a different plugin from a rival, for example, they would have to learn that one.</p>\n\n\n\n<p>And every time you wanted to do it, you&#8217;d have to learn how that system does it. So there&#8217;s no interoperability. It&#8217;s just little silos of interactivity. They worked, but they were a sort of stepping stone to what we&#8217;ve got now.</p>\n\n\n\n<p>Okay, I think I understand that. That&#8217;s great. Hopefully the audience has got that as well. That should be good. Can you give us some nice examples that you&#8217;ve seen where the Interactivity API, you describe it, the audience can hear it and readily understand, okay, that&#8217;s something that it can handle.</p>\n\n\n\n<p>[00:12:49] <strong>Milana Cap:</strong> Well, there is a beautiful demo that is used for demonstrating the Interactivity API by people who created Interactivity API. It&#8217;s a movie demo, and you can find it if you go for introductory post of Interactivity API at Core blog, you will find it. So it&#8217;s a simplified Netflix made with WordPress. So you get simple things like there is a favorites. So you can heart a movie, and it&#8217;ll show the number, how many favorites you have. But when you dig deeper, you can open one movie and play the trailer, and it&#8217;ll have a minimised video on the bottom. And you can, you know, browse the website and switch pages, and the video is still playing in the corner and it doesn&#8217;t even hiccup.</p>\n\n\n\n<p>The thing that is happening there is you think you are reloading pages. You think you are going to different pages, but it&#8217;s really the same page and it&#8217;s just being reloaded in what you need to reload. So it&#8217;s the hardest thing for developer to do, to switch page, but doesn&#8217;t really reload the page. And if you take a look, if you try that demo and you take a look, you will see that URL changes, everything changes, but you really didn&#8217;t move from the first page.</p>\n\n\n\n<p>[00:14:18] <strong>Nathan Wrigley:</strong> Okay, so what you&#8217;ve just described then, you&#8217;ve got a, like a tiled selection of videos, and underneath it is like a little heart icon. So it&#8217;s just a demonstration that if you click the heart icon, it says, I like this one. And then it keeps a record of that somewhere else. Like, how many of you hearted over here? Or, click this heart icon and it&#8217;ll take you to the ones that you favorited. That kind of thing. But also it gives the impression that you&#8217;re reloading pages, but really it&#8217;s all just happening within that one page session.</p>\n\n\n\n<p>[00:14:46] <strong>Milana Cap:</strong> Yes.</p>\n\n\n\n<p>[00:14:47] <strong>Nathan Wrigley:</strong> Okay. So that&#8217;s a really easy to understand version of it. And I would imagine something like, let&#8217;s say a shopping cart, I think I mentioned that earlier, where you, I don&#8217;t know, you click that you want to add something to the cart, sort of similar process. It&#8217;s a bit like hearting, isn&#8217;t it? You add something to the cart and you get that interactive cart icon in the top right of the screen if you&#8217;re on a desktop. And it says you&#8217;ve got three items in there, and you click it and you&#8217;ve got four items in there, and so on. Those kind of things. So again, it&#8217;s one part of the website, one block if you like, updating another thing. Are there any other examples that you think are quite useful?</p>\n\n\n\n<p>[00:15:21] <strong>Milana Cap:</strong> Well, I saw like countdown. So if you want your website to show the countdown until launching something. There&#8217;s also we have already two examples in Core working. So you have a query block, and you can select to have it paginated, without pagination. That&#8217;s Interactivity API.</p>\n\n\n\n<p>So anywhere you would use Ajax before, you can use Interactivity API. It&#8217;ll give you that feeling of nothing has been reloaded, so it&#8217;s just loading in that place. You don&#8217;t use Ajax, you just use Interactivity API.</p>\n\n\n\n<p>[00:16:05] <strong>Nathan Wrigley:</strong> So this would be, I don&#8217;t know, a list of posts or something like that. And at the bottom of the screen, we&#8217;ve seen the first 12, 12 more, you would typically click two or the right arrow or something, and that would do some sort of Ajaxy request. But in this case, that&#8217;s now been removed and we&#8217;re using the Interactivity API, and it will give you the next 12, and the next 12, and so on. Yeah, that&#8217;s a really great example.</p>\n\n\n\n<p>So presumably, if this is moving into WordPress Core, does that mean that a lot of the Core features that, like for example, pagination, has that now moved over in WordPress Core to using the Interactivity API?</p>\n\n\n\n<p>[00:16:37] <strong>Milana Cap:</strong> Well, I know that that specific feature has moved to Interactivity API, and also the image block has the option for lightbox. That&#8217;s also Interactivity API. That&#8217;s currently in Core. And I imagine a lot of other things can be moved. But also it doesn&#8217;t have to. The only thing that it needs is a good documentation, and option that you can use it so you can do with it whatever you want.</p>\n\n\n\n<p>[00:17:07] <strong>Nathan Wrigley:</strong> What is the documentation like? You know, if I was a developer and I wanted to begin using this because, sounds good, I&#8217;d rather not maintain my own bucket load of code for my interactivity in my plugin, for example. Let&#8217;s just throw all that out and go with what WordPress has. Is there a ton of documentation to get developers started?</p>\n\n\n\n<p>[00:17:25] <strong>Milana Cap:</strong> There is. They are not making the same mistake we had with Gutenberg. I think for Interactivity API, the most difficult thing is to actually understand it. Because we had, I had, as PHP developer primarily, I had a problem to understand Gutenberg and to understand how React works, and why React doesn&#8217;t understand how I think, you know? And I was always over-engineering it because I was covering all the cases.</p>\n\n\n\n<p>But React doesn&#8217;t care about all the cases. It was very difficult for me to understand how that works on components based, and these components don&#8217;t care about anything else but themselves.</p>\n\n\n\n<p>So Interactivity API now connects all of this. And we are coming back to the system that is aware of all its parts. But not just that, in Interactivity API you have the option to write the code where it makes the most sense.</p>\n\n\n\n<p>When I was playing with it, I had two blocks that were supposed to talk to each other, and I realised that something that was one block doing, it made the most sense to write the code for it in another block&#8217;s VueJS. So I was using the, there is the template that you can use for Interactivity API, and it&#8217;ll run the Create Block Script, but just use the Interactivity API template. And then you get the block that has switch from light to dark theme.</p>\n\n\n\n<p>There is a toggle. The first was, it was only the toggle, and I was very disappointed. Like, the toggle shouldn&#8217;t use any JavaScript at all. But it was a good example for what Interactivity API can do. And now with the theme switching, it&#8217;s kind of complete. You understand all the things that Interactivity API is.</p>\n\n\n\n<p>So this toggle was another button, and you click on it, and it shows the paragraph. And then you click on it again and it closes the paragraph. And then I used another block, and I wanted that other block to count how many times I opened and closed this toggle. It was mind blowing that that code for counting how many times I open and close it, I will show the data in this other block.</p>\n\n\n\n<p>But it made much more sense to write the code for it in this first block, because I already have there code that is aware that this is open and closed. So I could just, you know, add one line of the code, and update the number there in another block. So that&#8217;s kind of the most difficult thing with Interactivity API, to understand how that functions, and that you can really achieve a lot with one piece of code, one line of code, but put it in a right place. And it can be in different places. So that&#8217;s something, you know, for you as a developer to document where I wrote things.</p>\n\n\n\n<p>So with the Interactivity API, the most important thing is to actually understand how that works. There is very good documentation there for the basic stuff, definitions and all of it. And also, examples. But really, it&#8217;s not just copy, pasting from example, it&#8217;s playing with it and understanding how it is connected.</p>\n\n\n\n<p>And once it&#8217;s clicked in your mind, it&#8217;s mind blowing. It&#8217;s like a game. Well, the coding for me is like a game. That&#8217;s why I started coding. But it is very interesting that you can, you know, play with it, you can break it, you can find different ways. And I was playing with putting the same code in different places to see if it will work, it will.</p>\n\n\n\n<p>So there is a new skill that we will see with Interactivity API, like the most beautiful code and the most beautiful place where you put that code. And I think it&#8217;s very much open for optimising code. And you&#8217;ll see there the level of expertise of developer for how much they understand the optimisation of JavaScript code.</p>\n\n\n\n<p>[00:21:45] <strong>Nathan Wrigley:</strong> Is the Interactivity API, how to describe it, is it finished?</p>\n\n\n\n<p>[00:21:49] <strong>Milana Cap:</strong> No.</p>\n\n\n\n<p>[00:21:50] <strong>Nathan Wrigley:</strong> Yeah. I mean, basically nothing in WordPress really is ever quite finished, is it?</p>\n\n\n\n<p>[00:21:54] <strong>Milana Cap:</strong> If you software, then it&#8217;s never finished.</p>\n\n\n\n<p>[00:21:56] <strong>Nathan Wrigley:</strong> No. But would you say it already has pretty much everything that you require it to have? Or can you imagine scenarios where it would be really nice to have this feature or this feature? What I&#8217;m trying to get to is, is it still under active development? Can people listening to this podcast who think that that would be an interesting use of their time to help contribute to that, is there still work to be done? And where would we go to get involved in that?</p>\n\n\n\n<p>[00:22:21] <strong>Milana Cap:</strong> You can go to, there is a GitHub issue that is called Interactivity API showcase. It&#8217;s in Gutenberg repository. And you&#8217;ll see a lot of different ideas, how people want to use Interactivity API. And you will, when you start looking at those examples, you start to get ideas, what you could use it for. And you get to remember all the projects you had that you could really use Interactivity API there.</p>\n\n\n\n<p>I don&#8217;t think it&#8217;s done. I don&#8217;t think it&#8217;ll ever be done because, you know, clients get very creative with things they want. And I think we can&#8217;t even imagine what we would want until we get to the request to do it for a project. So there&#8217;s a lot of things to do, as in feature terms, but there&#8217;s always, you know, fixing code, optimising here and there and cleaning things up. And then there&#8217;s an update from library that it depends on, and then you have to, you know, do that. So there&#8217;s always maintenance if you use software. It&#8217;s never done.</p>\n\n\n\n<p>[00:23:31] <strong>Nathan Wrigley:</strong> I feel like if you are, let&#8217;s say 18 years old, you&#8217;ve been brought up in an era where you&#8217;ve had a phone in your hand and the apps on the phone are kind of what you&#8217;ve grown up with expecting from things online. And everything over on the phone is interactive. There&#8217;s just this expectation that you can click a button and it will do some desired action over there.</p>\n\n\n\n<p>And it feels like a website that doesn&#8217;t have interactivity is almost, well, I mean, I know you can have brochure websites and things like that where it&#8217;s just static content. It feels like that&#8217;s the expectation and it&#8217;s more and more going to be the expectation. So if a project like this hadn&#8217;t come along, WordPress websites would&#8217;ve felt really strange. You know, stuck in the past in a way, because of that lack of interactivity.</p>\n\n\n\n<p>And now hopefully developers who haven&#8217;t got the time, the budget or the experience to do this on their own, hopefully they can start offering solutions by just reading the documentation and not having to dig into the weeds of absolutely everything, just implement what&#8217;s been written for you, and hopefully that&#8217;ll bring WordPress more into the year 2025.</p>\n\n\n\n<p>[00:24:36] <strong>Milana Cap:</strong> Well, I think that if you take from that perspective, like you are 18 years old and have everything, all the apps you want in your phone, I think that WordPress is already weird to them. They are not using CMS, it&#8217;s too much effort for the things they can do with another app in their phone.</p>\n\n\n\n<p>But I don&#8217;t think that WordPress is for them. I mean, WordPress is CMS. So it&#8217;s meant to be used with purpose while kids today still look for, you know, quick content that they can, my daughter is 21 years old and she sends me, you know, memes and videos all the time. Most often than not, yeah, I tell her I don&#8217;t understand this. And she says, well, it&#8217;s funny because it&#8217;s stupid. I say, I still don&#8217;t understand this.</p>\n\n\n\n<p>I mean, she understands the life cycle of something that is meaningful, something that is important. And that is something that we would use WordPress for. But their concentration and focus span is just, give me this stupid video, that&#8217;s funny because it&#8217;s stupid, and I&#8217;ll move on. So I don&#8217;t think we should even try to put WordPress there and try to satisfy that request. But still there are requests that Interactivity API does satisfy. And that was needed to be added to WordPress.</p>\n\n\n\n<p>[00:26:07] <strong>Nathan Wrigley:</strong> Yeah, it&#8217;s certainly nice for developers not to have to, well just basically roll their own solution and waste tons of time doing something 1,000 times, literally 1,000, maybe 10,000 times done differently. Whereas now everybody can just lean into this one implementation, and it&#8217;s baked into Core. And then everybody can inject things into, on top of your code, and you can look at other people&#8217;s code and extend it in that way. So hopefully that will mean that, you know, the project as a whole can move forward.</p>\n\n\n\n<p>Let&#8217;s move on to something that I literally know nothing about, HTML API. You&#8217;re going to have to go from the very most basic description and I will try to keep up.</p>\n\n\n\n<p>[00:26:46] <strong>Milana Cap:</strong> Well, HTML API is actually what powers Interactivity API. So we wouldn&#8217;t have Interactivity API as it is right now, if we didn&#8217;t have HTML API. For now we have two classes that we can use, HTML tag processor. Which is idea to use PHP to modify attributes in Gutenberg blocks, in their markup. Because it was so difficult to approach the block to get to that code and modify anything once it&#8217;s on the page.</p>\n\n\n\n<p>So the HTML tag processor is just working with the attributes in markup. But it was meant to be used for Gutenberg blocks, but it really doesn&#8217;t matter what you use, it&#8217;ll process any HTML if it finds it. And it&#8217;s very useful for many things that we would use jQuery for before, and we would load the whole JavaScript file. You can add, remove, classes. You can set the aspect ratio for iframe. You can set image size attributes. You can add accessibility attributes where you need them.</p>\n\n\n\n<p>And it&#8217;s all happening in PHP, you know, on the page load. It&#8217;s very fast. It&#8217;s amazing. And that&#8217;s what is powering those HTML directives that we have in Interactivity API. So in markup you will find data WP and then the rest of directive. And those directives are connecting the server side and the client side in JavaScript for Interactivity API. I think it&#8217;s called WP Directive Manager, the class that is really internal class, and it&#8217;s just being used by Interactivity API.</p>\n\n\n\n<p>But then there&#8217;s a class that&#8217;s called HTML processor. And this one is doing more things than tag processor. This one knows about the closing tag, and this one will support inserting and removing nodes from the page, or wrapping and unwrapping tags on the page, then reading and modifying inner content. So everything that you were loading JavaScript for, you know, all the makeup stuff, and if something is clicked then, you know, wrap me this paragraph in this div, and then we will change the class or whatever.</p>\n\n\n\n<p>You can do that with PHP now, and it feels so much less hacky. You have it. I had actually example for removing the no-follow attribute for internal links. So searching for internal links, before HTML tag processor, you would have to use regex, and regex is invented by extraterrestrials to make fun of humans.</p>\n\n\n\n<p>So it&#8217;s also, you cannot cover all the cases with regex. There are always surprises. There is always some edge case you didn&#8217;t think of and cover. And when you look at that code, even five minutes later, you don&#8217;t understand anything. It&#8217;s something that you Google, and you trust the code that you found on Google.</p>\n\n\n\n<p>But this one, when you used a tag processor, you actually understand everything. And it covers all edge cases. There are no surprises because it&#8217;s been built with HTML standards. So it supports every type of HTML that we will probably never see in our lives. You know, all the broken stuff and all of it, it supports it. And it&#8217;s been built by Dennis Snell. That is something unlike Interactivity API.</p>\n\n\n\n<p>So we saw that Laravel has it, and Symphony has it, and Phoenix first did it. But this is something that nobody has. This is our own. And Dennis now built it from zero, completely custom. And he&#8217;s now working in putting it into PHP. So it&#8217;ll be available, yeah, to everyone. That&#8217;s a really big thing.</p>\n\n\n\n<p>I gave this talk in September at PHP Serbia and people were sitting, you know, PHP developers who are working with Symphony and Laravel and doing custom PHP, and they were like, oh my God. And I was like, yeah, WordPress has something you don&#8217;t have. That was really nice feeling. Yeah, I like that Dennis is actually putting that into PHP.</p>\n\n\n\n<p>[00:31:30] <strong>Nathan Wrigley:</strong> So again, like I did with the Interactivity API, I&#8217;m going to do the same here. Let me just see if I&#8217;ve understood what it is. So the idea really, if you want to interact with the DOM, right now, the typical way of doing that is with some JavaScript or other. So let&#8217;s say for example, I don&#8217;t know, you want to do the third child of a div, and you want to put a border around that.</p>\n\n\n\n<p>With JavaScript, you&#8217;re going to find that third div, and then you&#8217;re going to insert some class, which will then get modified by the CSS to add a border and a border radius, and what have you. So that&#8217;s all done on the client side. Page loads, JavaScript loads, and then the DOM gets rewritten by the JavaScript.</p>\n\n\n\n<p>But in this scenario, it&#8217;s going server side. It is PHP. So it&#8217;s really much more readable and maintainable, and it all just lives in this one spot with all the other PHP. And then you would write something, basically the same thing, but in PHP, to do the same job. And then WordPress, so there&#8217;s no rewriting of the DOM. WordPress writes the DOM with that in mind. So the output HTML already has that in it. You&#8217;re not using JavaScript to rewrite what&#8217;s already been written, so it speeds things up as well.</p>\n\n\n\n<p>[00:32:39] <strong>Milana Cap:</strong> Yes, yes. You have less requests because there&#8217;s no file that you are requesting. There&#8217;s no waiting on, you know, everything to load. And to rewrite it, it&#8217;s just going right there.</p>\n\n\n\n<p>[00:32:51] <strong>Nathan Wrigley:</strong> So it&#8217;s the same process though. The way that you would do it in JavaScript, you&#8217;re now just transferring that into PHP, but the method that you&#8217;re using to do it would be the same, you know, search for the third child of this parent div, and then give it an extra class and that&#8217;s what happens.</p>\n\n\n\n<p>[00:33:04] <strong>Milana Cap:</strong> Yes.</p>\n\n\n\n<p>[00:33:05] <strong>Nathan Wrigley:</strong> Okay. Yeah, that&#8217;s really straightforward. And really, really, really powerful.</p>\n\n\n\n<p>[00:33:09] <strong>Milana Cap:</strong> It is.</p>\n\n\n\n<p>[00:33:10] <strong>Nathan Wrigley:</strong> Because not only can you write your own thing in that way, but if you want to upend what&#8217;s already been written by, I don&#8217;t know, let&#8217;s say there&#8217;s something strange in a plugin that you&#8217;ve downloaded. Would this be able to rewrite the things that the plugin is injecting?</p>\n\n\n\n<p>[00:33:23] <strong>Milana Cap:</strong> Yes.</p>\n\n\n\n<p>[00:33:23] <strong>Nathan Wrigley:</strong> Okay, so you can, I don&#8217;t know, let&#8217;s say there&#8217;s a plugin which does something quirky in the HTML, you don&#8217;t like it, you want to strip something out or add something in. It sits between where the plugin injects its code and where the end user receives the HTML.</p>\n\n\n\n<p>[00:33:35] <strong>Milana Cap:</strong> Yeah.</p>\n\n\n\n<p>[00:33:35] <strong>Nathan Wrigley:</strong> That is interesting. So it&#8217;s a total rewrite of the HTML.</p>\n\n\n\n<p>[00:33:38] <strong>Milana Cap:</strong> Mm-hmm.</p>\n\n\n\n<p>[00:33:39] <strong>Nathan Wrigley:</strong> That is fascinating.</p>\n\n\n\n<p>[00:33:41] <strong>Milana Cap:</strong> Yeah, and it&#8217;s fast. It&#8217;s actually working faster than when you would load JavaScript for that.</p>\n\n\n\n<p>[00:33:48] <strong>Nathan Wrigley:</strong> So in many cases it renders much of the JavaScript, the JavaScript that&#8217;s being used to modify the DOM. It completely negates the need for that?</p>\n\n\n\n<p>[00:33:59] <strong>Milana Cap:</strong> Yes.</p>\n\n\n\n<p>[00:33:59] <strong>Nathan Wrigley:</strong> Have you found it easy to learn this?</p>\n\n\n\n<p>[00:34:01] <strong>Milana Cap:</strong> Yeah, yeah. It&#8217;s very easy. It&#8217;s even easier than Interactivity API. It&#8217;s just, you know, you instantiate the class, pass the string to it that you want to, you know, search for tags, and then you have methods. You call the method and loop through the things, or you don&#8217;t have to loop, depending what you are looking for. And there is a method, remove attribute, add attribute, remove class. You know, it&#8217;s that easy.</p>\n\n\n\n<p>[00:34:28] <strong>Nathan Wrigley:</strong> And, like everything in WordPress, you said earlier, it&#8217;s never finished. There&#8217;ll always be work done on it. But as of now, we&#8217;re recording this late February, 2025, is it pretty complete for all the things that you&#8217;ve wished to do? Does it have an answer for that, or is there still work to be done?</p>\n\n\n\n<p>[00:34:42] <strong>Milana Cap:</strong> The HTML processor needs to be optimised, so it&#8217;s not completely production ready yet. Tag processor is optimised and ready to use, and we actually used it in 2023. We waited for new release when it was coming into Core. We waited for two weeks and delayed the deployment to get it in to actually, because that example that I used for removing no-follow attribute from internal links, that&#8217;s the real world example that we had. And it was really annoying problem that was so easily fixed with five lines of code, once the HTML API got into Core.</p>\n\n\n\n<p>[00:35:25] <strong>Nathan Wrigley:</strong> I obsess about WordPress, like that&#8217;s all I think about most days basically, and yet this is somehow completely passed me by. The Interactivity API, somehow that captured my attention. There must have been some press release, or something to explain that this is happening. But the HTML API completely passed me by. I wonder if that&#8217;s just my lack of trying hard enough.</p>\n\n\n\n<p>[00:35:46] <strong>Milana Cap:</strong> No, that was actually the case for many people. So for that WordPress release, I was leading the documentation focus. So I know, I wrote the field guide, and I knew that was there. But many people didn&#8217;t know.</p>\n\n\n\n<p>And that idea behind this new series of talks that I do. So to find these, it&#8217;s very good that these things come into Core slowly, like piece by piece. What is ready? What is optimised? But because they are small, people don&#8217;t hear about them, because we don&#8217;t advertise that. And Interactivity API is, it gets the same treatment as any other Gutenberg feature. Like, oh, it&#8217;s flashy, it&#8217;s new, come see this.</p>\n\n\n\n<p>But HTML API is completely PHP. It actually powers Interactivity API, but nobody knows that. And those were like small pieces getting in, because its purpose was to serve Gutenberg. So it wasn&#8217;t really advertised as something you can use for other things. But you know developers, they find ways to use something for different things.</p>\n\n\n\n<p>And that&#8217;s why I wanted to create these talks to actually show people there are so many things you can do with WordPress now that are new. And you can use them today, and tomorrow they will be even better.</p>\n\n\n\n<p>[00:37:14] <strong>Nathan Wrigley:</strong> I guess with the Interactivity API you are solving a really hard problem. So to be able to modify one part of the page, it&#8217;s content and it&#8217;s a separate block, that&#8217;s a difficult thing to overcome. So there&#8217;s a lot of work to get over that. But if you just want to add a border to the third child of a div, everybody&#8217;s using the same JavaScript technique to do it. So there&#8217;s a well understood way of doing it.</p>\n\n\n\n<p>And so that, I suppose, leads to the question, what is the benefit over just using JavaScript? Why would we want to use the HTML API instead of just the familiar thing, which probably everybody&#8217;s doing, you know, just rewrite things with JavaScript. Is it basically coming down to ease of readability for everybody, and speed?</p>\n\n\n\n<p>[00:37:57] <strong>Milana Cap:</strong> Yeah. I think if you take a look at, for example, enterprise projects. The way developers optimise the code, it&#8217;s like every piece of millisecond counts because these projects are huge, and they have a lot of visits. So if you can remove all the JavaScript, I mean, that&#8217;s huge. That is making such impact, and it brings you like 10 places before your competition. Doing just that is enough to use this over JavaScript.</p>\n\n\n\n<p>But also, it replaces not just need for JavaScript, but need for regex as well. And again, in enterprise projects, when you have huge databases running regex and having potential to not work everywhere where it&#8217;s supposed to work, as opposed to this, that is very straightforward. Not too many lines of code, and it&#8217;s actually faster. You would take that chance.</p>\n\n\n\n<p>[00:39:03] <strong>Nathan Wrigley:</strong> Yeah, I guess if you&#8217;ve just got like a five page brochure website, that&#8217;s for a mom and pop store, you&#8217;re probably not going to be worrying too much. But if you&#8217;ve got an enterprise page, you know, an enterprise level website which is maybe getting, I don&#8217;t know, 50,000 hits every hour or something like that. Shaving 10 milliseconds out, multiply that by 50,000, I mean, not only is it quicker, so Google likes it, but also the cost of everything goes down. You know, there&#8217;s less bits flying across the internet. It&#8217;s all been optimised. And I guess at the enterprise level, all of those things matter.</p>\n\n\n\n<p>[00:39:36] <strong>Milana Cap:</strong> Yeah, everything matters.</p>\n\n\n\n<p>[00:39:37] <strong>Nathan Wrigley:</strong> Yeah, that&#8217;s fascinating, genuinely fascinating, and something that I&#8217;d never heard of. So I will go and, when I&#8217;ve edited this podcast, I&#8217;ll go and preach the gospel of the HTML and Interactivity APIs. That&#8217;s everything I wanted to ask. Milana, is there anything that you wanted to get across that I didn&#8217;t ask?</p>\n\n\n\n<p>[00:39:53] <strong>Milana Cap:</strong> No.</p>\n\n\n\n<p>[00:39:54] <strong>Nathan Wrigley:</strong> No. In that case, Milana Cap, thank you very much for chatting to me today. Really appreciate it. I hope you enjoy the rest of your time in Manila.</p>\n\n\n\n<p>[00:40:01] <strong>Milana Cap:</strong> Yeah, thank you for having me.</p>\n\n\n\n<p>[00:40:03] <strong>Nathan Wrigley:</strong> You&#8217;re very welcome.</p>\n</div>\n\n\n\n<p>On the podcast today we have Milana Cap.</p>\n\n\n\n<p>Milana is a seasoned WordPress Engineer from Serbia, working with XWP and freelancing through Toptal. She&#8217;s not just a developer; she&#8217;s also active in WordPress community roles such as a co-rep for the documentation team, organiser at multiple WordCamps, and a member of the plugin review team.</p>\n\n\n\n<p>We discuss some groundbreaking WordPress features that developers should be aware of, specifically focusing on her presentation at WordCamp Asia in Manila titled &#8220;WordPress gems for developers: fresh new features you&#8217;ll actually want to use.&#8221;</p>\n\n\n\n<p>We start the discussion with the Interactivity API. Milana explains how this feature allows blocks within WordPress to communicate seamlessly with one another. Until now, most blocks were just silos of information, they could not communicate with one another. This API enables developers to manage interactivity across multiple blocks without resorting to custom solutions. We talk about some possible use cases.</p>\n\n\n\n<p>Milana also gets into the HTML API, which underpins the Interactivity API. This empowers developers to manipulate HTML attributes using PHP, thereby reducing the reliance on JavaScript. This not only enhances page load speeds but also simplifies the code management process. It’s not something that I’d heard of, but Milana explains how important it can be in rewriting the DOM for whatever goals you have in mind.</p>\n\n\n\n<p>Throughout the episode, Milana shares examples of these APIs in action, demonstrating how they can simplify and optimise WordPress development projects, particularly at an enterprise level.</p>\n\n\n\n<p>If you&#8217;re a developer looking to leverage these new WordPress features, this episode is for you.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Useful links</h2>\n\n\n\n<p>Milana&#8217;s presentation at WordCamp Asia 2025: <a href=\"https://asia.wordcamp.org/2025/session/wordpress-gems-for-devs-fresh-new-features-youll-actually-want-to-use/\">WordPress gems for devs: fresh new features you’ll actually want to use</a></p>\n\n\n\n<p><a href=\"https://xwp.co/\">XWP</a></p>\n\n\n\n<p><a href=\"https://www.toptal.com/\">Toptal</a></p>\n\n\n\n<p><a href=\"https://wpmovies.dev/\">Interactivity API preview</a></p>\n\n\n\n<p><a href=\"https://github.com/WordPress/gutenberg/discussions/55642\">Interactivity API showcase #55642</a></p>\n\n\n\n<p><a href=\"https://developer.wordpress.org/news/2023/09/the-html-api-process-your-tags-not-your-pain/\">The HTML API: process your tags, not your pain</a></p>\n\n\n\n<p><a href=\"https://2024.phpsrbija.rs/\">PHP Serbia 2024</a></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 09 Apr 2025 14:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Nathan Wrigley\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:44;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"Do The Woo Community: The Do the Woo Release Notes Newsletter on LinkedIn\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"https://dothewoo.io/?post_type=blog&p=94001\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"https://dothewoo.io/blog/the-do-the-woo-release-notes-newsletter-on-linkedin/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:128:\"If you are on LinkedIn and looking for a deeper look into our episodes as they are released, we have a newsletter there for you.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 09 Apr 2025 10:39:06 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:45;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"WordPress.org blog: WordPress 6.8 Release Candidate 3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=18673\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://wordpress.org/news/2025/04/wordpress-6-8-release-candidate-3/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:8462:\"<p>The third release candidate (“RC3”) for WordPress 6.8 is ready for download and testing!</p>\n\n\n\n<p><strong>This version of the WordPress software is under development</strong>.<strong>&nbsp; Please do not install, run, or test this version of WordPress on production or mission-critical websites.</strong>&nbsp; Instead, it’s recommended that you evaluate RC3 on a test server and site.</p>\n\n\n\n<p>Reaching this phase of the release cycle is an important milestone.&nbsp; While release candidates are considered ready for release, testing remains crucial to ensure that everything in WordPress 6.8 is the best it can be.</p>\n\n\n\n<p>You can test WordPress 6.8 RC3 in four ways:</p>\n\n\n\n<table class=\"has-fixed-layout\"><tbody><tr><td><strong>Plugin</strong></td><td>Install and activate the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin on a WordPress install.&nbsp; (Select the “Bleeding edge” channel and “Beta/RC Only” stream).</td></tr><tr><td><strong>Direct Download</strong></td><td>Download the <a href=\"https://wordpress.org/wordpress-6.8-RC3.zip\">RC3 version (zip)</a> and install it on a WordPress website.</td></tr><tr><td><strong>Command Line</strong></td><td>Use the following <a href=\"https://make.wordpress.org/cli/\">WP-CLI</a> command: <code>wp core update --version=6.8-RC3</code></td></tr><tr><td><strong>WordPress Playground</strong></td><td>Use the <a href=\"https://playground.wordpress.net/?php=8.0&wp=beta&networking=no&language=&multisite=no&random=y4q1rn88xn\">6.8 RC3 WordPress Playground instance</a> (available within 35 minutes after the release is ready) to test the software directly in your browser without the need for a separate site or setup.</td></tr></tbody></table>\n\n\n\n<p>The current target for the WordPress 6.8 release is <strong>April 15, 2025</strong>. Get an overview of the <a href=\"https://make.wordpress.org/core/6-8/\">6.8 release cycle</a>, and check the <a href=\"https://make.wordpress.org/core/\">Make WordPress Core blog</a> for <a href=\"https://make.wordpress.org/core/tag/6-8/\">6.8-related posts</a> leading up to next week’s release for further details.</p>\n\n\n\n<h2 class=\"wp-block-heading\">What’s in WordPress 6.8 RC3?</h2>\n\n\n\n<p>Get a recap of WordPress 6.8’s highlighted features in the <a href=\"https://wordpress.org/news/2025/03/wordpress-6-8-beta-1/\">Beta 1 announcement</a>. For more technical information related to issues addressed since <a href=\"https://wordpress.org/news/2025/04/wordpress-6-8-release-candidate-2/\">RC2</a>, you can browse the following links:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://github.com/WordPress/gutenberg/commits/wp/6.8?since=2025-04-02&until=2025-04-08\">GitHub commits for 6.8</a> since April 1</li>\n\n\n\n<li><a href=\"https://core.trac.wordpress.org/log/branches/6.8?action=stop_on_copy&mode=stop_on_copy&rev=60145&stop_rev=60125&limit=100&sfp_email=&sfph_mail=\">Changes committed</a> since April 1</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">How you can contribute</h2>\n\n\n\n<p>WordPress is open source software made possible by a passionate community that collaborates and contributes to its development. The resources below outline various ways you can help the world’s most popular open source web platform, regardless of your technical expertise.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Get involved in testing</h3>\n\n\n\n<p>Testing for issues is critical to ensuring WordPress is performant and stable. It’s also a meaningful way for anyone to contribute. <a href=\"https://make.wordpress.org/test/2025/03/04/help-test-wordpress-6-8/\">This detailed guide</a> will walk you through testing features in WordPress 6.8.&nbsp; For those new to testing, follow <a href=\"https://make.wordpress.org/test/handbook/get-setup-for-testing/\">this general testing guide</a> for more details on getting set up.</p>\n\n\n\n<p>If you encounter an issue, please report it to the <a href=\"https://wordpress.org/support/forum/alphabeta/\">Alpha/Beta area</a> of the support forums or directly to <a href=\"https://core.trac.wordpress.org/newticket\">WordPress Trac</a> if you are comfortable writing a reproducible bug report. You can also check your issue against a list of <a href=\"https://core.trac.wordpress.org/tickets/major\">known bugs</a>.</p>\n\n\n\n<p>Curious about testing releases in general?&nbsp; Follow along with the <a href=\"https://make.wordpress.org/test/\">testing initiatives in Make Core</a> and join the <a href=\"https://wordpress.slack.com/messages/core-test/\">#core-test channel</a> on <a href=\"https://wordpress.slack.com/\">Making WordPress Slack</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Search for vulnerabilities</h3>\n\n\n\n<p>From now until the final release of WordPress 6.8 (scheduled for April 15, 2025), the <a href=\"https://make.wordpress.org/core/handbook/testing/reporting-security-vulnerabilities/#enhanced-bounty-rewards-during-beta-and-release-candidate-phases\">monetary reward for reporting new, unreleased security vulnerabilities</a> is doubled.&nbsp; Please follow responsible disclosure practices as detailed in the project’s security practices and policies outlined on the <a href=\"https://hackerone.com/wordpress\">HackerOne page</a> and in the <a href=\"https://wordpress.org/about/security/\">security white paper</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Update your theme or plugin</h3>\n\n\n\n<p>For plugin and theme authors, your products play an integral role in extending the functionality and value of WordPress for all users.&nbsp; For more details on developer-related changes in 6.8, please review the <a href=\"https://make.wordpress.org/core/2025/03/28/wordpress-6-8-field-guide/\">WordPress 6.8 Field Guide</a>.</p>\n\n\n\n<p>Thanks for continuing to test your themes and plugins with the WordPress 6.8 beta releases.&nbsp; With RC3, you’ll want to conclude your testing and update the <em>“Tested up to”</em> version in your <a href=\"https://developer.wordpress.org/plugins/wordpress-org/how-your-readme-txt-works/\">plugin’s readme file</a> to 6.8.</p>\n\n\n\n<p>If you find compatibility issues, please post detailed information to the <a href=\"https://wordpress.org/support/forum/alphabeta/\">support forum</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Help translate WordPress</h3>\n\n\n\n<p>Do you speak a language other than English?  ¿Español?  Français?  Русский?  日本語? हिन्दी? मराठी? বাংলা?  You can <a href=\"https://translate.wordpress.org/projects/wp/dev/\">help translate WordPress into more than 100 languages</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">An RC3 haiku</h2>\n\n\n\n<p><em>The launch draws closer,</em><em><br /></em><em>Six-eight sings through RC3,</em><em><br /></em><em>Almost time to shine.</em></p>\n\n\n\n<p class=\"has-text-align-right\"><em>Thank you to the following contributors for collaborating on this post: <a href=\"https://profiles.wordpress.org/audrasjb/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>audrasjb</a>, <a href=\"https://profiles.wordpress.org/mamaduka/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>mamaduka</a>, <a href=\"https://profiles.wordpress.org/krupajnanda/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>krupajnanda</a>, <a href=\"https://profiles.wordpress.org/benjamin_zekavica/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>benjamin_zekavica</a>, <a href=\"https://profiles.wordpress.org/narenin/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>narenin</a>, <a href=\"https://profiles.wordpress.org/joedolson/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>joedolson</a>, <a href=\"https://profiles.wordpress.org/courane01/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>courane01</a>, <a href=\"https://profiles.wordpress.org/joemcgill/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>joemcgill</a>, <a href=\"https://profiles.wordpress.org/marybaum/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>marybaum</a>, <a href=\"https://profiles.wordpress.org/kmgalanakis/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>kmgalanakis</a>, <a href=\"https://profiles.wordpress.org/umeshsinghin/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>umeshsinghin</a>, <a href=\"https://profiles.wordpress.org/wildworks/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>wildworks</a>, <a href=\"https://profiles.wordpress.org/mkrndmane/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>mkrndmane</a>.</em></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 08 Apr 2025 15:54:49 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Jeffrey Paul\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:46;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"Do The Woo Community: Our Final Wrap of CloudFest 2025 with Robert, Zach and Carl\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=94070\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"https://dothewoo.io/our-final-wrap-of-cloudfest-2025-with-robert-zach-and-carl/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:205:\"In this episode of Dev Pulse, hosts discuss CloudFest 2025, highlighting unique event experiences, innovative hackathon projects, networking opportunities, and a preview of upcoming CloudFest USA in Miami.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 08 Apr 2025 12:32:39 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:47;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:96:\"Do The Woo Community: Four Practical Steps Towards Inclusion for Content Creators and Developers\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"https://dothewoo.io/?post_type=blog&p=85966\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:100:\"https://dothewoo.io/blog/four-practical-steps-towards-inclusion-for-content-creators-and-developers/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:305:\"In a past podcast our host Anne provided practical advice for content creators and developers to foster an inclusive environment. They are simple and to the point. Key suggestions included: You can hear the full episode here Exploring Accessibility and Neurodiversity in WordPress with Anne Mieke Bovelett\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 08 Apr 2025 09:55:22 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:48;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"Do The Woo Community: Do the Woo v5.1 Changelog\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"https://dothewoo.io/?post_type=blog&p=93974\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://dothewoo.io/blog/do-the-woo-v5-1-changelog/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"Four new co-hosts and more.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 07 Apr 2025 13:07:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:49;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:99:\"Do The Woo Community: Michelle Frechette Joins the Do the Woo Hosting Team for WordPress Event Talk\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=93984\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:98:\"https://dothewoo.io/michelle-frechette-joins-the-do-the-woo-hosting-team-for-wordpress-event-talk/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"BobWP announces Michelle Frechette as the new host for WordPress Event Talk.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 07 Apr 2025 09:42:17 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:48:\"WpOrg\\Requests\\Utility\\CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:9:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Mon, 21 Apr 2025 03:37:52 GMT\";s:12:\"content-type\";s:8:\"text/xml\";s:13:\"last-modified\";s:29:\"Mon, 21 Apr 2025 03:30:28 GMT\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:16:\"content-encoding\";s:2:\"br\";s:7:\"alt-svc\";s:19:\"h3=\":443\"; ma=86400\";s:4:\"x-nc\";s:9:\"HIT ord 1\";}}s:5:\"build\";i:1727758220;s:21:\"cache_expiration_time\";i:1745249873;s:23:\"__cache_expiration_time\";i:1745249873;}", "off");
INSERT INTO `wpbq_options` VALUES("199", "softaculous_pro_onboarding_shown", "1740043257", "auto");
INSERT INTO `wpbq_options` VALUES("200", "can_compress_scripts", "0", "on");
INSERT INTO `wpbq_options` VALUES("201", "softaculous_pro_onboarding_dismiss", "1740043263", "auto");
INSERT INTO `wpbq_options` VALUES("207", "_site_transient_wp_plugin_dependencies_plugin_data", "a:2:{s:8:\"backuply\";a:35:{s:4:\"name\";s:51:\"Backuply &#8211; Backup, Restore, Migrate and Clone\";s:4:\"slug\";s:8:\"backuply\";s:7:\"version\";s:5:\"1.4.3\";s:6:\"author\";s:69:\"<a href=\"https://profiles.wordpress.org/softaculous/\">softaculous</a>\";s:14:\"author_profile\";s:43:\"https://profiles.wordpress.org/softaculous/\";s:12:\"contributors\";a:2:{s:11:\"softaculous\";a:3:{s:7:\"profile\";s:43:\"https://profiles.wordpress.org/softaculous/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/d5f508eb226ae8cade7ed9f0f0cda7115f419afe760e0b64af278ed042b47c1f?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:11:\"softaculous\";}s:8:\"backuply\";a:3:{s:7:\"profile\";s:40:\"https://profiles.wordpress.org/backuply/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/eb4cb4dfe7bc9494507a2402850a581a6e86ca572dfda5bce7e97161602e0dd9?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:8:\"Backuply\";}}s:8:\"requires\";s:3:\"4.7\";s:6:\"tested\";s:5:\"6.7.2\";s:12:\"requires_php\";s:3:\"5.5\";s:16:\"requires_plugins\";a:0:{}s:6:\"rating\";i:92;s:7:\"ratings\";a:5:{i:5;i:96;i:4;i:1;i:3;i:0;i:2;i:3;i:1;i:8;}s:11:\"num_ratings\";i:108;s:11:\"support_url\";s:46:\"https://wordpress.org/support/plugin/backuply/\";s:15:\"support_threads\";i:0;s:24:\"support_threads_resolved\";i:0;s:15:\"active_installs\";i:400000;s:12:\"last_updated\";s:21:\"2025-02-10 2:23pm GMT\";s:5:\"added\";s:10:\"2022-07-22\";s:8:\"homepage\";s:38:\"http://wordpress.org/plugins/backuply/\";s:8:\"sections\";a:5:{s:11:\"description\";s:5542:\"<p>Backuply is a WordPress backup plugin that helps you backup your WordPress website, saving you from loss of data because of server crashes, hacks, dodgy updates, or bad plugins.</p>\n<p>Backuply comes with Local Backups and Secure Cloud backups with easy integrations with FTP, FTPS, SFTP, WebDAV, Google Drive, Microsoft OneDrive, Dropbox, Amazon S3 and easy One-click restoration.</p>\n<p>Your website is your asset and it needs to constantly be protected from various security issues, server issues, hacking, etc. While you take all precautionary steps to protect your website, backups are the best form of security. With Backuply, you can be confident that your data is protected and is always available for restore during any disaster. Backuply creates full backups of your website and you can restore it to the same or a new WordPress website with the click of a button.</p>\n<p>Our backup and website cloning technology have been in use for more than a decade and we have now ported it to WordPress.</p>\n<p>You can find our official documentation at <a href=\"https://backuply.com/docs\" rel=\"nofollow ugc\">https://backuply.com/docs</a>. We are also active in our community support forums on wordpress.org if you are one of our free users. Our Premium Support Ticket System is at <a href=\"https://softaculous.deskuss.com/open.php?topicId=17\" rel=\"nofollow ugc\">https://softaculous.deskuss.com/open.php?topicId=17</a></p>\n<p><a href=\"https://backuply.com\" title=\"Backuply Homepage\" rel=\"nofollow ugc\">Home Page</a> | <a href=\"https://softaculous.deskuss.com/open.php?topicId=17\" title=\"Backuply Support\" rel=\"nofollow ugc\">Support</a> | <a href=\"http://backuply.com/docs\" title=\"Documents\" rel=\"nofollow ugc\">Documents</a></p>\n<h3>Features</h3>\n<ul>\n<li><strong>Local Backups:</strong> Backup your complete website locally on your server with just one click.</li>\n<li><strong>FTP:</strong> Easily backup and restore your backup using FTP.</li>\n<li><strong>Backup to Google Drive</strong></li>\n<li><strong>One-Click Restore:</strong> Restore your website files and databases with a one-click restore.</li>\n<li><strong>Migration:</strong> Stress-free migration to any domain or host.</li>\n<li><strong>Database Backups:</strong> Backup your website&#8217;s database only.</li>\n</ul>\n<h3>Premium Features</h3>\n<ul>\n<li><strong>Automatic Backups:</strong> Choose to back up your website at regular intervals like Daily, Weekly, or Monthly. You can also customize the interval.</li>\n<li><strong>One-click Restore:</strong> With Backuply, restoring your website is simple. Just click on the restore button next to the backup you want to restore from. Your entire backup will be downloaded and the changes will be applied to the website.</li>\n<li><strong>Selective Backup:</strong> You have the option to choose from whether only files or database backups or full backups should be performed.</li>\n<li><strong>Website Migration:</strong> You can easily migrate your website by restoring from one of the Cloud Backup options on the new website.</li>\n<li><strong>Website Cloning:</strong> If you would like to clone your website for any purpose, Backuply can do that for you. Backuply will restore the data but replace the URLs and information as per the existing website. In this way, you can create multiple clones.</li>\n<li><strong>Backup to FTPS:</strong> You can back up your site to an FTPS i.e. FTP over SSL / TLS.</li>\n<li><strong>Backup to SFTP:</strong> Supports the SFTP protocol.</li>\n<li><strong>Backup to Dropbox</strong></li>\n<li><strong>Backup to Microsoft One Drive</strong></li>\n<li><strong>Backup to Amazon S3</strong></li>\n<li><strong>Backup to WebDAV</strong></li>\n<li><strong>Backup to S3 Compatible Storages:</strong> Added support for DigitalOcean Spaces, Linode Object Storage, Vultr Object Storage, and Cloudflare R2.</li>\n<li><strong>Support for WP-CLI:</strong> You can use Backuply through WP-CLI</li>\n<li><strong>Professional Support:</strong> Get professional support and more features to make backup your website with <a href=\"https://backuply.com/pricing\" rel=\"nofollow ugc\">Backuply</a></li>\n</ul>\n<h3>Backups</h3>\n<p>Backup is a way of copying your data or files to a secure place, which can be used to restore your website in case of data loss. Backups are vital in securing the data that you have published or written. Backups with Backuply are easy and secure with support for multiple options of storage like local storage using FTP or using third-party services like Google Drive, Dropbox, Microsoft OneDrive, AWS S3 and WebDAV.<br />\nTo make it even easier we support Automatic Backups with a customizable backup schedule.</p>\n<h3>Restores</h3>\n<p>Restoring is just a One-Click process using Backuply. If the selected backup is available then Backuply will restore your backups safely. Restoring a backup will roll back your site in the exact same state as it was when the backup was created.</p>\n<h3>Migration</h3>\n<p>Backuply creates a tar file of your whole WordPress install with the Database, so you can migrate your site to any host or location where WordPress can be installed. All you need to do is create a Backup of your WordPress install on a remote location, and that&#8217;s it, It can be synced on any WordPress install with ease so you just need to restore the synced backup on the new location for Migration to happen.</p>\n<h3>How to install Backuply</h3>\n<p>Go To your WordPress install -&gt; Plugins -&gt; Add New Button -&gt; In Search Box search For Backuply -&gt; Click on Install.</p>\n\";s:3:\"faq\";s:334:\"<p>Do you have questions related to Backuply? Use the following links :</p>\n<ol>\n<li><a href=\"https://backuply.com/docs\" rel=\"nofollow ugc\">Docs</a></li>\n<li><a href=\"https://backuply.deskuss.com\" rel=\"nofollow ugc\">Help Desk</a></li>\n<li><a href=\"https://wordpress.org/support/plugin/backuply\" rel=\"ugc\">Support Forum</a></li>\n</ol>\n\";s:9:\"changelog\";s:15178:\"<h4>1.4.3 (February 10th 2025)</h4>\n<ul>\n<li>[Bug-Fix] There was an issue which was causing downloaded file to be of size 0, this has been fixed.</li>\n</ul>\n<h4>1.4.2 (January 17th 2025)</h4>\n<ul>\n<li>[Bug-Fix] For some users the download file was returning different file name, this has been fixed.</li>\n<li>[Improvement] Restore was getting blocked in case where htaccess rules had some blocking rule, this has been handled.</li>\n</ul>\n<h4>1.4.1 (November 29th 2024)</h4>\n<ul>\n<li>[Improvement] The backup logs were overwhelming the browsers of some users, we have improved that by just logging the required info which reduces the backup logs.</li>\n</ul>\n<h4>1.4.0 (November 19th 2024)</h4>\n<ul>\n<li>[Task] Made some internal code changes.</li>\n</ul>\n<h4>1.3.9 (November 18th 2024)</h4>\n<ul>\n<li>[Task] Improved some internal codes and tested the same.</li>\n</ul>\n<h4>1.3.8 (November 4th 2024)</h4>\n<ul>\n<li>[Task] Tested with WordPress 6.7</li>\n<li>[Bug-Fix] Settings page was getting killed when some data was not integer.</li>\n<li>[Bug-Fix] functions.php was loading later than few of the registered hooks, which was causing issue to some users this has been fixed.</li>\n</ul>\n<h4>1.3.7 (October 21th 2024)</h4>\n<ul>\n<li>[Improvement] Added retries in Backuply cloud upload.</li>\n</ul>\n<h4>1.3.6 (September 24th 2024)</h4>\n<ul>\n<li>[Improvement] Error reporting has been improved.</li>\n<li>[Task] Improved license handling.</li>\n</ul>\n<h4>1.3.5 (September 13th 2024)</h4>\n<ul>\n<li>[Security-Fix] A security issue reported by bart[WordFence], has been fixed.</li>\n<li>[Improvement] Serialization fix has been improved, its now atleast 100 times faster now.</li>\n</ul>\n<h4>1.3.4 (September 6th 2024)</h4>\n<ul>\n<li>[Improvement] Restores are now faster.</li>\n<li>[Bug-Fix] There was an issue with serialization fix, that has been fixed.</li>\n<li>[Bug-Fix] On some servers backup request was getting blocked as WordPress&#8217;s default User Agent add url too in it which some servers and firewalls sees to be suspicious, this has been fixed.</li>\n</ul>\n<h4>1.3.3 (July 27th 2024)</h4>\n<ul>\n<li>[Improvement] Restore timeouts have been improved to handle restores easily on the slow servers.</li>\n<li>[Improvement] Downloads of local backpup will be handled directly by the browser now.</li>\n<li>[Task] Tested with WordPress 6.6.</li>\n<li>[Bug-Fix] There was an issue adding Backuply Cloud, if the user has reached quota limit, that has been fixed.</li>\n</ul>\n<h4>1.3.2 (June 19th 2024)</h4>\n<ul>\n<li>[Improvement] Restores work better now, will go in maintenance mode when restoring database to prevent noise from WordPress or plugin functionalities, which could break the restore sometimes.</li>\n<li>[Improvement] We have refactored Google Drive lib and it will improve the speed of download when restoring by around 10%.</li>\n<li>[Improvement] Backups will sync just after they are uploaded, using Backuply&#8217;s upload module.</li>\n<li>[Bug-Fix] PHP warnings on backup_ins.php has been fixed.</li>\n<li>[Bug-Fix] PHP warnings when deletion of backups has been fixed.</li>\n</ul>\n<h4>1.3.1 (May 09th 2024)</h4>\n<ul>\n<li>[Bug-Fix] There was a issue with restore for some user, where Backuply was unable to unzip, that has been fixed.</li>\n<li>[Bug-Fix] There was an issue with migration in case when the wp-config.php file was not writable, that has been fixed.</li>\n<li>[Bug-Fix] sanitize_file_name function was adding a _ in the file names which was preventing downloads for some domains, which has been fixed.</li>\n<li>[Bug-Fix] Some PHP warnings has been fixed.</li>\n</ul>\n<h4>1.3.0 (April 16th 2024)</h4>\n<ul>\n<li>[Bug-Fix] There was issue downloading Backups for some users that has been fixed.</li>\n<li>[Bug-Fix] There was an issue connecting to Database when the database was being served over a socket, that has been fixed.</li>\n<li>[Bug-Fix] There was issue in using Custom Cron for Bcloud users that has been fixed.</li>\n<li>[Bug-Fix] For some of the OneDrive users there was a error when trying to add the Backup location, that has been fixed.</li>\n</ul>\n<h4>1.2.9 (March 26th 2024)</h4>\n<ul>\n<li>[Bug-Fix] There was an issue with download for some user because of their WordPress not supporting tar or gz mime types, this has been fixed.</li>\n<li>[Bug-Fix] There was an issue when syncing a backup uploaded manually which originally belonged to backup location other than Local Folder, would not show in the Backup History, that has been fixed.</li>\n<li>[Task] Tested with WordPress 6.5.</li>\n</ul>\n<h4>1.2.8 (March 13 2024)</h4>\n<ul>\n<li>[Improvement] We have made improvements to make Backup Downloads better.</li>\n</ul>\n<h4>1.2.7 (February 16 2024)</h4>\n<ul>\n<li>[Bug-Fix] Version 1.2.5 got included in the plugin package, this release is to fix that.</li>\n</ul>\n<h4>1.2.6 (February  08 2024)</h4>\n<ul>\n<li>[Security-Fix] In some cases it was possible to fill up the logs and has been fixed. Reported by Villu Orav (WordFence)</li>\n<li>[Bug-Fix] There was issue while restoring which has been fixed.</li>\n<li>[Bug-Fix] There was an issue uploading backup file, in which in the name of uploaded backup a _(underscore) was getting added due to a WordPress sanitization function which have been fixed.</li>\n</ul>\n<h4>1.2.5 (February 01 2024)</h4>\n<ul>\n<li>[Bug-Fix] There was an issue uploading backup on Safari Browser that has been fixed.</li>\n</ul>\n<h4>1.2.4 (January 25 2024)</h4>\n<ul>\n<li>[Feature] Option to upload backup files to the user server, directly form the plugin.</li>\n<li>[Improvement] A suggestion made by Bence Szalai to add limit on admin access on Exclude list folder.</li>\n<li>[Improvement] Made the settings of Custom Auto Backups simpler.</li>\n<li>[Bug-Fix] There was an issue with deletion in Backup rotation which has been fixed.</li>\n</ul>\n<h4>1.2.3 (January 18 2024)</h4>\n<ul>\n<li>[Feature] Option to add notes to every manual backups.</li>\n<li>[Bug-Fix] The /backuply/backups folder was getting filled with tmp files or the backup files in case of faliure, which has been fixed, by adding a daily Cron to clean it.</li>\n<li>[Bug-Fix] Backuply Cloud storage was not getting updated on deletion or Creation of backups, it has been fixed.</li>\n<li>[Bug-Fix] cPgaurd was blocking restores, this has been fixed.</li>\n<li>[Bug-Fix] There was an issue while auto backup where security check was failing which has been fixed.</li>\n<li>[Tweak] Backup Rotation was happening before creation of Backup, which is risky, this has been changed to delete after successful backup.</li>\n</ul>\n<h4>1.2.2 (December 15 2023)</h4>\n<ul>\n<li>[Security-fix] There was a privilege check failure which has been fixed.</li>\n</ul>\n<h4>1.2.1 (December 07 2023)</h4>\n<ul>\n<li>[Structural Change] We have made some structural changes, now Backuply Free will be required for the Pro version to work.</li>\n<li>[Improvement] Now you can check quota of backup locations like OneDrive, Dropbox, and Google Drive.</li>\n<li>[Bug-Fix] There was issue with updation of Backuply Cloud quota which has been fixed.</li>\n<li>[Bug-Fix] There was issue while restoring using SFTP and FTPS which has been fixed.</li>\n<li>[Bug-Fix] There were some warnings on the settings page which has been fixed.</li>\n<li>[Bug-Fix] There was an issue related to deletion of Backuply Cloud backups when storage limt reached, which has been fixed.</li>\n</ul>\n<h4>1.2.0 (November 06 2023)</h4>\n<ul>\n<li>[Improvement] While restoring the permission of the root folder wont be updated.</li>\n<li>[Improvement] Logs have been improved to, while restoring all fatal error will be logged in Backuply logs.</li>\n<li>[Bug-Fix] There was a conflict with a few SMTP plugins, which has been fixed.</li>\n<li>[Bug-Fix] There was issue unsetting Email notification field which has been fixed.</li>\n<li>[Bug-Fix] On some servers the restore was failing as it was not able to create files, that has been fixed.</li>\n<li>[Task] Tested with WordPress 6.4.</li>\n</ul>\n<h4>1.1.9 (October 05 2023)</h4>\n<ul>\n<li>[Tweak] Now the timezone of the Backup will be the timezone of the WordPress.</li>\n<li>[Tweak] Memory limit fatal error will be logged in Backuply backup progress.</li>\n<li>[Bug-Fix] There was a function incompatibility issue when creating Backup to FTP.</li>\n<li>[Bug-Fix] There was a issue in FTPS when uploading the file, which has been fixed.</li>\n<li>[Bug-Fix] There was an issue with migration of website when migrating from  / to /example, which has been fixed.</li>\n</ul>\n<h4>1.1.8 (August 24 2023)</h4>\n<ul>\n<li>[Bug-Fix] There was issue while restoring, some users were getting error of unable to unzip, that has been fixed.</li>\n<li>[Tweak] Nag timings where updated.</li>\n<li>[Tweak] Database backups created after version 1.1.7 will delete old tables progressively while restoring, instead of deleting them all at once. This is to reduce the chance of breaking the site if something goes wrong during the restore process..</li>\n</ul>\n<h4>1.1.7 (July, 25 2023)</h4>\n<ul>\n<li>[Feature] Option to download Backuply Cloud backups.</li>\n<li>[Bug-Fix] There was an issue for some users while restoring, with a fatal error of duplicate entry in database restore, which has been fixed.</li>\n<li>[Tweak] The chunk size of Google Drive while restore has been increased to improve the speed of download.</li>\n</ul>\n<h4>1.1.6 (July, 05 2023)</h4>\n<ul>\n<li>[Bug-Fix] There was an issue while restoring of backup not able to unzip that has been fixed.</li>\n<li>[Bug-Fix] There was an issue while downloading backup through Backuply while restoring, that has been fixed.</li>\n</ul>\n<h4>1.1.5 (June, 29 2023)</h4>\n<ul>\n<li>[Bug-Fix] There was issue with Auto Backups for Trial users that has been fixed.</li>\n<li>[Bug-Fix] There was an issue while connecting to Backuply through the trial promo.</li>\n</ul>\n<h4>1.1.4 (June, 24 2023)</h4>\n<ul>\n<li>[Feature] Backuply Cloud now provides 10GB of default space which was set as 1 GB previously.</li>\n<li>[Bug-Fix] The quota of Backuply Cloud was not showing properly.</li>\n<li>[Bug-Fix] On restore a info file was not getting delete after completion of restore that has been fixed.</li>\n</ul>\n<h4>1.1.3 (June, 13 2023)</h4>\n<ul>\n<li>[Feature] Now use Backuply Cloud as your Backup location to keep your website safe.</li>\n<li>[Bug-Fix] There was an issue with Gdrive, backup was getting stuck.</li>\n<li>[Bug-Fix] A user faced a fatal error while listing backups that has been fixed.</li>\n</ul>\n<h4>1.1.2 (April, 3 2023)</h4>\n<ul>\n<li>[Bug-Fix] For some user backup was completing but not creating backup of all directories when backup of Database and Directories was selected that has been fixed.</li>\n<li>[Bug-Fix] Backup was failing at 100% when creating backup to Google Drive that has been fixed.</li>\n<li>[Bug-Fix] There was an issue while deleting local backups thats has been fixed.</li>\n</ul>\n<h4>1.1.1 (March, 31 2023)</h4>\n<ul>\n<li>[Bug-Fix] There was an issue with Backup and restore on sites with broken SSL that has been fixed.</li>\n<li>[Task] Tested with WordPress 6.2.</li>\n</ul>\n<h4>1.1.0 (February, 13 2023)</h4>\n<ul>\n<li>[Feature] Added Support for Wasabi S3 Compatible Object Storage.</li>\n<li>[Feature] Local backups created in Backuply version 1.1.0 and above can be synced.</li>\n<li>[Tweak] To initiate backup we were dependent on WP CRON, which was causing issue for some of our users, as WP Cron was getting stuck. So now manual backup dosen&#8217;t uses WP CRON, WP CRON in backuply is only used by Automatic Backups.</li>\n</ul>\n<h4>1.0.9 (December, 24 2022)</h4>\n<ul>\n<li>[Security-Improvement] Removed all app keys.</li>\n<li>[Security-Improvement] Made restore logs even more secure with more randomness</li>\n</ul>\n<h4>1.0.8 (December, 22 2022)</h4>\n<ul>\n<li>[Security-Fix] Added index.html file and web.config to improve the protection of the backup folder.</li>\n<li>[Security-Fix] Made the backup folder have random strings to make the name be unpredictible.</li>\n<li>[Bug-Fix] There was an issue while creating database backup for some users that has been fixed.</li>\n<li>[Bug-Fix] There was issue loading last logs for some uses, that has been fixed.</li>\n<li>[Bug-Fix] For some user while downloading the Local Backup the progress bar was not updating that has been fixed.</li>\n<li>[Removed] Installing Backuply Pro from the Free version as per the WordPress guidelines.</li>\n</ul>\n<h4>1.0.7 (December, 19 2022)</h4>\n<ul>\n<li>[Security-Fix] The Google Drive App Secret key of Backuply was committed in the code. This is fixed. We have issued a new secret as well !</li>\n</ul>\n<h4>1.0.6 (December, 12 2022)</h4>\n<ul>\n<li>[Bug-Fix] There was an issue while saving the additional file in settings page that has been fixed.</li>\n<li>[Bug-Fix] Issues related to PHP 8.1 and 8.0 compatibility have been fixed.</li>\n<li>[Bug-Fix] There was an issue while creating backuply config for some users that has been fixed.</li>\n<li>[Bug-Fix] When selecting check all files in Additional file option, all databases were getting selected to in exclude database, that has been fixed.</li>\n<li>[Bug-Fix] When selecting auto backup time the auto backup options weren&#8217;t visible for some users that has been fixed.</li>\n<li>[Bug-Fix] For some users the backup was getting stuck at 17% sometimes that has been fixed.</li>\n</ul>\n<h4>1.0.5 (November 15, 2022)</h4>\n<ul>\n<li>[Feature] Added support for WP-CLI, you can perform backup, restore, and sync right from your terminal.</li>\n<li>[Task] We have improved the promotion nags, so it doesn&#8217;t cause inconvenience to our users.</li>\n<li>[Bug-Fix] There was a PHP warning being shown while syncing or downloading from Dropbox that has been fixed.</li>\n<li>[Bug-Fix] There was an issue while deleting GDrive backups that has been fixed.</li>\n</ul>\n<h4>1.0.4 (October 14, 2022)</h4>\n<ul>\n<li>[Feature] Added support for S3 Compatible backup locations like DigitalOcean Spaces, Linode Object Storage, Vultr Object Storage, and Cloudflare R2.</li>\n<li>[Feature] Added support for Server Side Encryption for AWS.</li>\n<li>[Task] Google Drive is now available for all users.</li>\n<li>[Bug-Fix] Part Number while downloading for restore in AWS had an issue. That has been fixed.</li>\n<li>[Bug-Fix] For some user restore was getting stuck at repairing database status, that has been fixed.</li>\n</ul>\n<h4>1.0.3 (September 20, 2022)</h4>\n<ul>\n<li>[Improvement] Added Backup Download progress</li>\n<li>[Task] The Backuply nag will now appear after 7 days instead of 1 day.</li>\n<li>[Bug-Fix] The last backup time was shown from 1970 when no backup was created. This has been fixed.</li>\n<li>[Bug-Fix] Backup on Google was failing for some users. This has been fixed.</li>\n<li>[Bug-Fix] On failure, in some cases the partial backup file was not cleaned. This has been fixed.</li>\n<li>[Bug-Fix] At times, the backup nag was not getting dismissed. This has been fixed.</li>\n</ul>\n<h4>1.0.2 (August 18, 2022)</h4>\n<ul>\n<li>Exclude Files, Directories or Database tables from a backup</li>\n<li>Logs for every backup</li>\n<li>Minor bug fixes</li>\n</ul>\n<h4>1.0.1 (July 22, 2022)</h4>\n<ul>\n<li>Added Last Logs of Backups and Restore</li>\n</ul>\n<h4>1.0.0 (July 21, 2022)</h4>\n<ul>\n<li>Released Plugin</li>\n</ul>\n\";s:11:\"screenshots\";s:2327:\"<ol><li><a href=\"https://ps.w.org/backuply/assets/screenshot-1.png?rev=2760139\"><img src=\"https://ps.w.org/backuply/assets/screenshot-1.png?rev=2760139\" alt=\"&lt;strong&gt;Dashboard&lt;/strong&gt; manual backup and info.\"></a><p><strong>Dashboard</strong> manual backup and info.</p></li><li><a href=\"https://ps.w.org/backuply/assets/screenshot-2.png?rev=2760139\"><img src=\"https://ps.w.org/backuply/assets/screenshot-2.png?rev=2760139\" alt=\"&lt;strong&gt;Settings&lt;/strong&gt; set backup settings like backup location, backup options and email to notify.\"></a><p><strong>Settings</strong> set backup settings like backup location, backup options and email to notify.</p></li><li><a href=\"https://ps.w.org/backuply/assets/screenshot-3.png?rev=2760139\"><img src=\"https://ps.w.org/backuply/assets/screenshot-3.png?rev=2760139\" alt=\"&lt;strong&gt;Backup Locations&lt;/strong&gt; add remote locations to backup and restore from.\"></a><p><strong>Backup Locations</strong> add remote locations to backup and restore from.</p></li><li><a href=\"https://ps.w.org/backuply/assets/screenshot-4.png?rev=2760139\"><img src=\"https://ps.w.org/backuply/assets/screenshot-4.png?rev=2760139\" alt=\"&lt;strong&gt;Backup History&lt;/strong&gt; manage all your backups.\"></a><p><strong>Backup History</strong> manage all your backups.</p></li><li><a href=\"https://ps.w.org/backuply/assets/screenshot-5.png?rev=2761227\"><img src=\"https://ps.w.org/backuply/assets/screenshot-5.png?rev=2761227\" alt=\"&lt;strong&gt;Restore Process&lt;/strong&gt; easy to understand restore progress.\"></a><p><strong>Restore Process</strong> easy to understand restore progress.</p></li><li><a href=\"https://ps.w.org/backuply/assets/screenshot-6.png?rev=2760139\"><img src=\"https://ps.w.org/backuply/assets/screenshot-6.png?rev=2760139\" alt=\"&lt;strong&gt;Add Backup Location&lt;/strong&gt; with a fairly simple form to add a backup location.\"></a><p><strong>Add Backup Location</strong> with a fairly simple form to add a backup location.</p></li><li><a href=\"https://ps.w.org/backuply/assets/screenshot-7.png?rev=2760139\"><img src=\"https://ps.w.org/backuply/assets/screenshot-7.png?rev=2760139\" alt=\"&lt;strong&gt;Backup Process&lt;/strong&gt; easy to understand backup progress.\"></a><p><strong>Backup Process</strong> easy to understand backup progress.</p></li></ol>\";s:7:\"reviews\";s:16117:\"<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Nice plugin</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 out of 5 stars\" data-title-template=\"%s out of 5 stars\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/crahman332/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/4000d85db1f2b18f33fd78c826cceaee285fa3d8edb255aaf782d44aed5e09e4?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/4000d85db1f2b18f33fd78c826cceaee285fa3d8edb255aaf782d44aed5e09e4?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/crahman332/\" class=\"reviewer-name\">crahman332</a> on <span class=\"review-date\">March 7, 2025</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>This plugin is useful for wordpress website.</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Quick, convenient backup of all u need for a successful restore (tested ! :) )</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 out of 5 stars\" data-title-template=\"%s out of 5 stars\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/sdhelliott/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/41f243a907fc63401bff7e81edf25daa631fad70464f25284591f09d58e96b22?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/41f243a907fc63401bff7e81edf25daa631fad70464f25284591f09d58e96b22?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/sdhelliott/\" class=\"reviewer-name\">sdhelliott</a> on <span class=\"review-date\">February 16, 2025</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>and that\'s 5 stars for the free version.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Wouldn\'t it be even better if the (optional) backup note (additional option on the Dashboard/CreateBackup page/tab) was actually displayed in the BackupHistory tab alongside the Restore button(s) ?</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Previously worked, now permanently stuck at 17%</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"2 out of 5 stars\" data-title-template=\"%s out of 5 stars\" data-rating=\"2\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/webartistry/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/920d7fb9a1788d08334f06642965e96abb5487def37cd7c7488eb09e33e4895c?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/920d7fb9a1788d08334f06642965e96abb5487def37cd7c7488eb09e33e4895c?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/webartistry/\" class=\"reviewer-name\">visualfire <small>(webartistry)</small></a> on <span class=\"review-date\">January 31, 2025</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>I have the pro version of the plugin and it worked well, until it got stuck at 17%... permanently. I\'ve uninstalled and reinstalled the plugin, removing all tables from my database in between installs, but that did not help with the issue. The help documents and state that PHP INI memory must be at least 256MB, but mine is 1024MB, so memory should not be an issue! I\'ve spent as much time troubleshooting this as I\'m willing. Backups are not an area in which I am willing to deal with unnecessary hassles or risks. Oh well!</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Ótimo</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 out of 5 stars\" data-title-template=\"%s out of 5 stars\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/rwydra/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/47a64878d6409e3d525a99ddd9e55099060571345e4bcb6ba7af40bda4bfa26e?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/47a64878d6409e3d525a99ddd9e55099060571345e4bcb6ba7af40bda4bfa26e?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/rwydra/\" class=\"reviewer-name\">rwydra</a> on <span class=\"review-date\">January 20, 2025</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>Entrega o que promete!</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">good plugin!</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 out of 5 stars\" data-title-template=\"%s out of 5 stars\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/klebeband356/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/fc2679b74f0d59038ba6780cc5f5e7e761d6a85d91dcacb72f8e6bf1113a3b5d?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/fc2679b74f0d59038ba6780cc5f5e7e761d6a85d91dcacb72f8e6bf1113a3b5d?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/klebeband356/\" class=\"reviewer-name\">klebeband356</a> on <span class=\"review-date\">January 17, 2025</s